"\n"
"Usage\n"
"-----\n"
"\n"
"uchime --input query.fasta [--db db.fasta] [--uchimeout results.uchime]\n"
"    [--uchimealns results.alns]\n"
"\n"
"Options\n"
"-------\n"
"\n"
"--input filename\n"
"    Query sequences in FASTA format.\n"
"    If the --db option is not specificed, uchime uses de novo\n"
"    detection. In de novo mode, relative abundance must be given\n"
"    by a string /ab=xxx/ somewhere in the label, where xxx is a\n"
"    floating-point number, e.g. >F00QGH67HG/ab=1.2/.\n"
"\n"
"--db filename\n"
"    Reference database in FASTA format.\n"
"    Optional, if not specified uchime uses de novo mode.\n"
"\n"
"    ***WARNING*** The database is searched ONLY on the plus strand.\n"
"    You MUST include reverse-complemented sequences in the database\n"
"    if you want both strands to be searched.\n"
"\n"
"--abskew x\n"
"    Minimum abundance skew. Default 1.9. De novo mode only.\n"
"    Abundance skew is:\n"
"        min [ abund(parent1), abund(parent2) ] / abund(query).\n"
"\n"
"--uchimeout filename\n"
"    Output in tabbed format with one record per query sequence.\n"
"    First field is score (h), second field is query label.\n"
"    For details, see manual.\n"
"\n"
"--uchimealns filename\n"
"    Multiple alignments of query sequences to parents in human-\n"
"    readable format. Alignments show columns with differences\n"
"    that support or contradict a chimeric model.\n"
"\n"
"--minh h\n"
"    Mininum score to report chimera. Default 0.3. Values from 0.1\n"
"    to 5 might be reasonable. Lower values increase sensitivity\n"
"    but may report more false positives. If you decrease --xn,\n"
"    you may need to increase --minh, and vice versa.\n"
"\n"
"--mindiv div\n"
"    Minimum divergence ratio, default 0.5. Div ratio is 100%% - \n"
"    %%identity between query sequence and the closest candidate for\n"
"    being a parent. If you don't care about very close chimeras,\n"
"    then you could increase --mindiv to, say, 1.0 or 2.0, and\n"
"    also decrease --min h, say to 0.1, to increase sensitivity.\n"
"    How well this works will depend on your data. Best is to\n"
"    tune parameters on a good benchmark.\n"
"\n"
"--xn beta\n"
"    Weight of a no vote, also called the beta parameter. Default 8.0.\n"
"    Decreasing this weight to around 3 or 4 may give better\n"
"    performance on denoised data.\n"
"\n"
"--dn n\n"
"    Pseudo-count prior on number of no votes. Default 1.4. Probably\n"
"    no good reason to change this unless you can retune to a good\n"
"    benchmark for your data. Reasonable values are probably in the\n"
"    range from 0.2 to 2.\n"
"\n"
"--xa w\n"
"    Weight of an abstain vote. Default 1. So far, results do not\n"
"    seem to be very sensitive to this parameter, but if you have\n"
"    a good training set might be worth trying. Reasonable values\n"
"    might range from 0.1 to 2.\n"
"\n"
"--chunks n\n"
"    Number of chunks to extract from the query sequence when searching\n"
"    for parents. Default 4.\n"
"\n"
"--[no]ovchunks\n"
"    [Do not] use overlapping chunks. Default do not.\n"
"\n"
"--minchunk n\n"
"    Minimum length of a chunk. Default 64.\n"
"\n"
"--idsmoothwindow w\n"
"    Length of id smoothing window. Default 32.\n"
"\n"
"--minsmoothid f\n"
"    Minimum factional identity over smoothed window of candidate parent.\n"
"    Default 0.95.\n"
"\n"
"--maxp n\n"
"    Maximum number of candidate parents to consider. Default 2. In tests so\n"
"    far, increasing --maxp gives only a very small improvement in sensivity\n"
"    but tends to increase the error rate quite a bit.\n"
"\n"
"--[no]skipgaps\n"
"--[no]skipgaps2\n"
"    These options control how gapped columns affect counting of diffs.\n"
"    If --skipgaps is specified, columns containing gaps do not found as diffs.\n"
"    If --skipgaps2 is specified, if column is immediately adjacent to\n"
"    a column containing a gap, it is not counted as a diff.\n"
"    Default is --skipgaps --skipgaps2.\n"
"\n"
"--minlen L\n"
"--maxlen L\n"
"    Minimum and maximum sequence length. Defaults 10, 10000.\n"
"    Applies to both query and reference sequences.\n"
"\n"
"--ucl\n"
"    Use local-X alignments. Default is global-X. On tests so far, global-X\n"
"    is always better; this option is retained because it just might work\n"
"    well on some future type of data.\n"
"\n"
"--queryfract f\n"
"    Minimum fraction of the query sequence that must be covered by a local-X\n"
"    alignment. Default 0.5. Applies only when --ucl is specified.\n"
"\n"
"--quiet\n"
"    Do not display progress messages on stderr.\n"
"\n"
"--log filename\n"
"    Write miscellaneous information to the log file. Mostly of interest\n"
"    to me (the algorithm developer). Use --verbose to get more info.\n"
"\n"
"--self\n"
"    In reference database mode, exclude a reference sequence if it has\n"
"    the same label as the query. This is useful for benchmarking by using\n"
"    the ref db as a query to test for false positives.\n"
