/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQLayerWidget_H
#define MvQLayerWidget_H

#include <QModelIndex>
#include <QWidget>

#include "MvRequest.h"

class QLabel;
class QSlider;
class QSpinBox;
class QToolButton;
class QTreeView;

class MgQLayerItem;
class MvQLayerModel;
class MgQPlotScene;
class MgQSceneItem;

class MvQLayerContentsItemEditor
{
public:
	MvQLayerContentsItemEditor(const Cached& name);

	~MvQLayerContentsItemEditor() {}

	void EditedDefinition(MvRequest&);

private:
	Cached name_;

};

class MvQLayerWidget : public QWidget
{
Q_OBJECT

public:
	MvQLayerWidget(MgQPlotScene*,QWidget *parent=0);
	~MvQLayerWidget();
	void layersAreAboutToChange();
	void reset(MgQSceneItem *,MgQLayerItem*);
	void reset(MgQSceneItem *);
	MgQLayerItem* currentLayer();
	QString currentLayerText();
	int  layerAtGlobalPos(const QPoint&);
	void iconEdited(MvRequest&);

public slots:
	void slotSelectLayer(MgQLayerItem* layer);
	void slotSelectLayer(const QModelIndex &);
	void slotTrSpinValueChanged(int);
	void slotTrSliderValueChanged(int);
	void slotTrSliderReleased();
	void slotMoveBottom();
	void slotMoveDown();
	void slotMoveUp();
	void slotMoveTop();
	void slotCheckItemStatus();
	void slotContextMenu(const QPoint &position);
	void slotFrameChanged();
	
signals:
        void layerVisibilityChanged(QString,bool);
	void layerTransparencyChanged(QString,int);
	void layerStackingOrderChanged(QList<QPair<QString,int> >);
  
protected:
	void changeTransparency(int);
	void startIconEditor(QString);
	
	QTreeView *view_;
	MvQLayerModel *model_;
	QSlider *trSlider_;
	QSpinBox *trSpin_;
	bool initTrWidgets_;

	QToolButton *topTb_;
	QToolButton *upTb_;
	QToolButton *downTb_;
	QToolButton *bottomTb_;
	
	QModelIndexList expandList_; 
	QString lastSelectedLayerText_;
};

#endif


/*



#ifndef MvQLayerWidget_H
#define MvQLayerWidget_H

#include <QSettings>
#include <QWidget>

class QButtonGroup;
class QListWidget;
class QListWidgetItem;
class QStackedLayout;
class QToolButton;

class MgQLayerItem;
class MgQPlotScene;
class MgQSceneItem;

class MvQLayerContentsWidget;
class MvQLayerDataWidget;
class MvQLayerMetaDataWidget;
class MvQPlotView;

class MvQLayerWidget : public QWidget
{
Q_OBJECT

public:
	MvQLayerWidget(MgQPlotScene*,MvQPlotView*,QWidget *parent=0);
	~MvQLayerWidget();
	void layersAreAboutToChange();
	void reset(MgQSceneItem *);
	void writeSettings(QSettings&);
	void readSettings(QSettings&);
	int  layerAtGlobalPos(const QPoint&);
	MvQLayerContentsWidget *contentsWidget() const {return contentsWidget_;}

public slots:
	void slotShowContents(int);
	void slotFrameChanged();
	void slotSelectLayerFromList(QListWidgetItem*);
	
protected:
	MgQLayerItem* currentLayerFromList();
	void setCurrentItemForLayerList(MgQLayerItem*);
	void resetLayerList(MgQSceneItem *,MgQLayerItem*);
	
	QStackedLayout *centralLayout_;
	MvQLayerContentsWidget *contentsWidget_;
	MvQLayerMetaDataWidget* metaWidget_;
	MvQLayerDataWidget* dataWidget_;
	QToolButton *showLayerTb_;
	QToolButton *showMetaTb_;
	QToolButton *showDataTb_;
	QButtonGroup *showBg_;
	QListWidget* layerList_;
	MgQSceneItem *sceneItem_;
	QString lastSelectedLayerText_;
	bool contentsLoaded_;
	bool metaLoaded_;
	bool dataLoaded_;
	bool layerListLoaded_;	
};

#endif

*/
