/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQFileInfoLabel.h"
#include "MvFileInfo.h"

MvQFileInfoLabel::MvQFileInfoLabel(QWidget* parent) : QLabel(parent)
{
	setObjectName(QString::fromUtf8("fileInfoLabel"));

        //Set size policy
	QSizePolicy sizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed);
        sizePolicy.setHorizontalStretch(0);
        sizePolicy.setVerticalStretch(0);
        sizePolicy.setHeightForWidth(this->sizePolicy().hasHeightForWidth());
        setSizePolicy(sizePolicy);
        //setMinimumSize(QSize(0, 60));
        //setMaximumSize(QSize(16777215, 45));
	
	setMargin(8);
	setAlignment(Qt::AlignLeft| Qt::AlignVCenter);

	//Other settings
        setAutoFillBackground(true);
	//setFrameShape(QFrame::Box);
        //setFrameShape(QFrame::StyledPanel);
        setTextInteractionFlags(Qt::LinksAccessibleByMouse|Qt::TextSelectableByKeyboard|Qt::TextSelectableByMouse);

}


QString MvQFileInfoLabel::buildTextLabel(QString fileName)
{
	QString s;
	MvFileInfo info(fileName.toStdString());

	s="<b><font color=#000000>File: </font></b>";
	s+="<font color=000010>" + QString(info.name().c_str()) + "</font>";	
	s+="<br>";
	
	if(info.permissions().find("l") != string::npos)
	{
		s+="<b><font color=#000000>Symlink target: </font></b>";	
		s+="<font color=000010>" +QString(info.linkTo().c_str()) + "</font>";
		s+="<br>";
		
		//Make the label bigger
		//setMinimumSize(QSize(0, 70));
	}

	s+="<b><font color=#000000>Permissions: </font></b>";
	s+="<font color=000010>" + QString(info.permissions().c_str()) + "</font>";
	s+="<b><font color=#000000> Owner: </font></b>";
	s+="<font color=000010>" + QString(info.owner().c_str()) + "</font>";
	s+="<b><font color=#000000> Group:</font> </b>";
	s+="<font color=000010>" + QString(info.group().c_str()) + "</font>";	
	//s+="<b> Size: </b> <font color=#ff0000>";
	s+="<b><font color=#000000> Size: </font></b>";
	s+="<font color=000010>" + QString(info.size().c_str()) + "</font>";
	s+="<font color=#000000><b> Modified:</font> </b>";
	s+="<font color=000010>" + QString(info.modified().c_str()) + "</font>";
	
	return s;
}

void MvQFileInfoLabel::setTextLabel(QString fileName)
{
	QString s=buildTextLabel(fileName);
	setText(s);
}		

void MvQFileInfoLabel::setGribTextLabel(QString fileName,int messageNum,bool filtered,int filteredMessageNum,bool hasMultiMessage)
{
	QString s=buildTextLabel(fileName);
	s+="<br>";

	if(filtered)
	{
		s+="<b><font color=#000000>Number of filtered messages: </font></b>";
		s+="<font color=000010>" + QString::number(filteredMessageNum);
		s+=" (out of " + QString::number(messageNum) + ")</font>";
	}	
	else
	{
		s+="<b><font color=#000000>Total number of messages: </font></b>";		
		s+="<font color=000010>" + QString::number(messageNum) + "</font>";
		if(hasMultiMessage)
		{
			s+="<font color=#f4a119> (some messages contain multiple fields!) </font>";	
		}
		
	}	
	setText(s);
}	

void MvQFileInfoLabel::setBufrTextLabel(QString fileName,int messageNum)
{
	QString s=buildTextLabel(fileName);
	s+="<br>";
	s+="<b><font color=#000000>Total number of messages: </font></b>";		
	s+="<font color=000010>" + QString::number(messageNum) + "</font>";
	
	setText(s);
}	

void MvQFileInfoLabel::setObstatScatterTextLabel(QString fileName,int itemNum)
{
	QString s=buildTextLabel(fileName);
	s+="<br>";
	s+="<b><font color=#000000>Total number of items: </font></b>";
	s+="<font color=000010>" + QString::number(itemNum) + "</font>";

	setText(s);
}

void MvQFileInfoLabel::setOdbTextLabel(QString fileName,QString)
{
	QString s=buildTextLabel(fileName);
	//s+="<br>";
	//s+="<b>Version: </b>";
	//s+=version;

	setText(s);
}

void MvQFileInfoLabel::setGeopTextLabel(QString fileName, QString format, long itemNum)
{
	QString s=buildTextLabel(fileName);
	s+="<br>";

	s+="<b><font color=#000000>Format: </font></b>";
	s+="<font color=000010>" + format + "</font>";
	s+="<br>";

	s+="<b><font color=#000000>Total number of points: </font></b>";
	s+="<font color=000010>" + QString::number(itemNum) + "</font>";

	setText(s);
}

void MvQFileInfoLabel::setFlextraTextLabel(QString fileName, QString iconName, int itemNum)
{
	QString s;
	s="<b><font color=#000000>Icon: </font></b>";
	s+="<font color=000010>" + iconName + "</font>";
	s+="<br>";
  	s+=buildTextLabel(fileName);
	s+="<br>";
	s+="<b><font color=#000000>Total number of groups: </font></b>";
	s+="<font color=000010>" + QString::number(itemNum) + "</font>";

	setText(s);
}

void MvQFileInfoLabel::setProfileTextLabel(QString fileName,int stepNum, int levNum,QString id)
{
	QString s=buildTextLabel(fileName);
	s+="<br>";
	s+="<b><font color=#000000>Steps: </font></b>";		
	s+="<font color=000010>" + QString::number(stepNum) + "</font>";
	s+="<b><font color=#000000> Model levels: </font></b>";		
	s+="<font color=000010>" + QString::number(levNum) + "</font>";
	s+="<br>";
	s+="<b><font color=#000000>Data type: </font></b>";		
	s+="<font color=000010>" + id + "</font>";
	
	setText(s);
}	
