/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <MMatrix.hpp>

void MMatrix::init(MWidget* parent, const char *name, ...)
{
        va_list argptr;
        Arg al[64];           // Arg List
        register int ac = 0;  // Arg Count

        va_start(argptr, name);
        ac = MInitArgs(al, (const char*)NULL, argptr);
        widget = XmCreateMatrix(parent->widget, (char*)name, al, ac);
        attachObject();
        ident = mMatrix;
}

//
//	Add callbacks to the scroll bar widget maintained by the Matrix widget
//

void MMatrix::addScrollProc (int posit, ...)
{
	va_list		argptr;
	char*		cbname;
	XtCallbackProc	cbproc;
	XtPointer	cbdata;
	Widget		scrollbar = XmMatrixScrollBar (widget, posit);

	if (!scrollbar) return;

	// initialize variable argument list

	va_start(argptr, posit);
	cbname = va_arg(argptr, char *);

	// remaining callbacks

	while (cbname)
	{
		// add callback

		cbproc = va_arg(argptr, XtCallbackProc);
		cbdata = va_arg(argptr, XtPointer);
		XtAddCallback(scrollbar, cbname, cbproc, cbdata);

		// get next callback name

		cbname = va_arg(argptr, char *);
	}

	va_end(argptr);
}

//
//	Set the parameter of the scroll bar widget maintained by the Matrix widget
//

void MMatrix::setScrollValues (int posit, int value, int scroll_size, int size, int increment, int page_increment)
{
	Widget scrollbar = XmMatrixScrollBar (widget, posit);
	Arg al[3];
//<*deleteme*>	int init_value;
	int ac = 0;

	if (!scrollbar) return;

//<*deleteme*>	XtSetArg (al[ac], XmNinit_value , &init_value); ac++;
//<*deleteme*>	XtGetValues (scrollbar, al, ac);
//<*deleteme*>	ac = 0;
	
	// Set size of the scroll bar

	XtSetArg (al[ac], XmNminimum, 0); ac++;
	XtSetArg (al[ac], XmNmaximum, scroll_size); ac++;
	XtSetArg (al[ac], XmNsliderSize, scroll_size); ac++;
	XtSetValues (scrollbar, al, ac);
	ac = 0;

	if (value < 0) value = 0;
	if (value > scroll_size - size) value =  scroll_size - size;

	XmScrollBarSetValues (scrollbar,		// Widget
			      value,			// current init_value
			      size,			// slider size
			      increment,		// increment
			      page_increment,		// page increment
			      FALSE);

}
