/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MetviewTask_H
#define MetviewTask_H

#include "Task.h"
#include "Action.h"
#include "ReplyObserver.h"

#include "TaskObserver.h"
#include "IconObject.h"
#include "Dependancy.h"
#include "Request.h"

class MetviewTask : public Task, public ReplyObserver, public TaskObserver 
{
public:
	MetviewTask(const string&,const Action&,IconObject*);
	virtual ~MetviewTask();
	
	void addContext (const Request& req) { context_ = req; }

protected:
	 void print(ostream&) const;

private:
	// No copy allowed
	MetviewTask(const MetviewTask&);
	MetviewTask& operator=(const MetviewTask&);

	void check();

	string      service_;
	Action      action_;
	IconObjectH object_;
	bool        error_;
	int         waiting_;
	Request     context_;

	typedef map<TaskH,DependancyH> Map;
	Map tasks_;

	// -- Overridden methods

	// From Task
	virtual void start();

	// From ReplyObserver
	virtual void reply(const Request&,int);
	virtual void progress(const Request&);
	virtual void message(const string&);

	// From TaskObserver
	virtual void success(Task*,const Request&);
	virtual void failure(Task*);

};

inline void destroy(MetviewTask**) {}

#endif
