.TH "ZIP_SOURCE_BUFFER_FRAGMENT" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_buffer_fragment\fR,
\fBzip_source_buffer_fragment_create\fR
\- create zip data source from multiple buffer
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_source_t *\fR
.br
.PD 0
.HP 4n
\fBzip_source_buffer_fragment\fR(\fIzip_t\ *archive\fR, \fIzip_buffer_fragment_t\ *fragments\fR, \fIzip_uint64_t\ nfragments\fR, \fIint\ freep\fR);
.PD
.PP
\fIzip_source_t *\fR
.br
.PD 0
.HP 4n
\fBzip_source_buffer_fragment_create\fR(\fIzip_buffer_fragment_t\ *fragments\fR, \fIzip_uint64_t\ nfragments\fR, \fIint\ freep\fR, \fIzip_error_t\ *error\fR);
.PD
.SH "DESCRIPTION"
The functions
\fBzip_source_buffer_fragment\fR()
and
\fBzip_source_buffer_fragment_create\fR()
create a zip source from the data in
\fIfragments\fR.
\fInfragments\fR
specifies the number of fragments.
If
\fIfreep\fR
is non-zero, the data will be freed when it is no longer needed.
.nf
.sp
.RS 0n
struct zip_stat {
    zip_uint8_t *data;    /* pointer to the actual data */
    zip_uint64_t length;  /* length of this fragment */
};
.RE
.fi
.PP
The data
\fIfragments\fR
point to must remain valid for the lifetime of the created source.
\fIfragments\fR
itself can be discarded once the source is created.
.PP
The source can be used to open a zip archive from.
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
or
\fIerror\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_source_buffer\fR()
and
\fBzip_source_buffer_create\fR()
fail if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fInfragments\fR
is greater than zero and
\fIfragments\fR
is
\fRNULL\fR.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_open_from_source(3),
zip_replace(3),
zip_source(3)
.SH "HISTORY"
\fBzip_source_buffer_fragment\fR()
and
\fBzip_source_buffer_fragment_create\fR()
were added in libzip 1.4.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
