/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdlib.h>
#include <string.h>

int main() {
	int i;
	uint16_t number_cpus;
	uint16_t written;
	int ret;

#ifdef SA_OPEN_CPU
	ret = sa_open_cpu();
	if (ret != 0) {
		printf("sa_open_cpu(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	ret = sa_count_cpus(&number_cpus);
	if (ret != 0 || number_cpus == 0) {
		printf("sa_count_cpus(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
	struct sa_cpu* cpus = malloc(number_cpus * sizeof(struct sa_cpu));

	for (i = 0; i < 30000; ++i) {
		ret = sa_count_cpus(&number_cpus);
		if (ret != 0 || number_cpus == 0) {
			printf("sa_count_cpus(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_reset_cpus();
		if (ret != 0) {
			printf("sa_reset_cpus(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_get_cpu(0, cpus);
		if (ret != 0) {
			printf("sa_get_cpu(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}

		written = 0;
		ret = sa_get_cpus(cpus, number_cpus, &written);
		if (ret != 0) {
			printf("sa_get_cpus(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}
	}

	free(cpus);

#ifdef SA_CLOSE_CPU
	ret = sa_close_cpu();
	if (ret != 0) {
		printf("sa_close_cpu(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return EXIT_SUCCESS;
}
