/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

#include "Association.h"

// Deprecated by Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr> (2007/05/22)
int CA_resolveDirection(const CMPIBroker* broker, const string& refLeftClass, const string& refRightClass, const string& known, const string& unknown, Objectpath& left, Objectpath& right, const Objectpath& Known, int& direction, string& errorMessage) {
	string _unknown = unknown;
	string knownClass = Known.getClassname();
	if (!CF_strCmpNoCase(knownClass, refLeftClass) && !CF_strCmpNoCase(knownClass, refRightClass))
		return -1;
	if (CF_strCmpNoCase(known, refLeftClass)) {
		if (CF_strCmpNoCase(_unknown, "Null"))
			_unknown = refRightClass;
		if (!CF_strCmpNoCase(_unknown, refRightClass))
			return -1;
		left = Known;
		right = Objectpath(broker, _unknown, left.getNamespace());
		direction = 1;
	}
	else {
		if (CF_strCmpNoCase(known, refRightClass)) {
			if (CF_strCmpNoCase(_unknown, "Null"))
				_unknown = refLeftClass;
			if (!CF_strCmpNoCase(_unknown, refLeftClass))
				return -1;
			right = Known;
			left = Objectpath(broker, _unknown, right.getNamespace());
			direction = 0;
		}
	}
	return OK;
}

// Deprecated by Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr> (2007/05/22)
int CA_associatorFilter(const CMPIBroker* broker, const CMPIContext* ctx, const string& assocClass, const string& resultClass, const string& classname, const string refLeftClass, const string& refRightClass, const string& refLeft, const string& refRight, const string& role, const string& resultRole, Objectpath& left, Objectpath& right, const Objectpath& Known, int& direction, string& errorMessage) {
	if (!CF_strCmpNoCase(assocClass, classname)) {
		errorMessage = "Wrong assosClass parameter: " + assocClass;
		return INVALID_PARAMETER;
	}
	int errorCode = CA_resolveDirection(broker, refLeftClass, refRightClass, ((Objectpath&) Known).getClassname(), resultClass, left, right, Known, direction, errorMessage);
	if (errorCode != OK)
		return errorCode;
	
	if ((direction==1 && ((!CF_strCmpNoCase(role, "Null") && !CF_strCmpNoCase(role, refLeft)) || (!CF_strCmpNoCase(resultRole, "Null") && !CF_strCmpNoCase(resultRole, refRight)))) || (direction==0 && ((!CF_strCmpNoCase(role, "Null") && !CF_strCmpNoCase(role, refRight)) || (!CF_strCmpNoCase(resultRole, "Null") && !CF_strCmpNoCase(resultRole, refLeft)))))
		return -1;
	
	/*Instance instance;
	const char** _properties = NULL;
	errorCode = CB_getInstance(broker, ctx, Known, _properties, instance, errorMessage);
	if (errorCode != OK)
		return errorCode;*/
	return OK;	
}

// Deprecated by Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr> (2007/05/22)
int CA_referenceFilter(const CMPIBroker* broker, const CMPIContext* ctx, const string& assocClass, const string& classname, const string& refLeftClass, const string& refRightClass, const string& refLeft, const string& refRight, const string& role, Objectpath& left, Objectpath& right, const Objectpath& Known, int& direction, string& errorMessage) {
	if (!CF_strCmpNoCase(assocClass, classname)) {
		errorMessage = "Wrong assosClass parameter: " + assocClass;
		return INVALID_PARAMETER;
	}	
	if (CF_strCmpNoCase(((Objectpath&) Known).getClassname(), refLeftClass)) {
		direction = 1;
		left = Known;
	}
	else {
		if (CF_strCmpNoCase(((Objectpath&) Known).getClassname(), refRightClass)) {
			direction = 0;
			right = Known;
		}
		else
			return -1;
	}
	if ((direction==1 && (!CF_strCmpNoCase(role, "Null") && !CF_strCmpNoCase(role, refLeft))) || (direction==0 && (!CF_strCmpNoCase(role, "Null") && !CF_strCmpNoCase(role, refRight))))
		return -1;
	/*Instance instance;
	const char** _properties = NULL;
	int errorCode = CB_getInstance(broker, ctx, Known, _properties, instance, errorMessage);
	if (errorCode != OK)
		return errorCode;*/
	return OK;
}

// Added by Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr> (2007/05/22)
int CA_associatorResolveDirection(const char* leftClasses[], const char* rightClasses[], const string& leftNamespace, const string& rightNamespace, const string& leftRole, const string& rightRole, const Objectpath& known, const string& resultClass, const string& role, const string& resultRole, bool& leftToRight) {	
	string knownClass = known.getClassname();
	string knownNamespace = known.getNamespace();
	string _resultClass = resultClass;
	if (CF_strCmpNoCase(knownClass, leftClasses[0])) {
		if (!CF_strCmpNoCase(knownNamespace, "") && !CF_strCmpNoCase(knownNamespace, leftNamespace))
			return -1;
		if (!CF_strCmpNoCase(role, "null") && !CF_strCmpNoCase(role, leftRole))
			return -1;
		if (!CF_strCmpNoCase(resultRole, "null") && !CF_strCmpNoCase(resultRole, rightRole))
			return -1;
		for (unsigned int i=0; i<sizeof(rightClasses)/sizeof(char*); i++) {
			DEBUG;
			if (CF_strCmpNoCase(_resultClass, rightClasses[i])) {				
				_resultClass=rightClasses[0];
				break;
			}
		}
		if (!CF_strCmpNoCase(_resultClass, "null") && !CF_strCmpNoCase(_resultClass, rightClasses[0]))
			return -1;
		leftToRight=true;
	} else if (CF_strCmpNoCase(knownClass, rightClasses[0])) {
		if (!CF_strCmpNoCase(knownNamespace, "") && !CF_strCmpNoCase(knownNamespace, rightNamespace))
			return -1;
		if (!CF_strCmpNoCase(role, "null") && !CF_strCmpNoCase(role, rightRole))
			return -1;
		if (!CF_strCmpNoCase(resultRole, "null") && !CF_strCmpNoCase(resultRole, leftRole))
			return -1;
		
		_DEBUG(CF_intToStr(sizeof(rightClasses)/sizeof(char*)));
		_DEBUG(CF_intToStr(sizeof(leftClasses)/sizeof(char*)));
		for (unsigned int i=0; i<sizeof(leftClasses)/sizeof(char*); i++) {
			DEBUG;
			_DEBUG(_resultClass);
			_DEBUG(leftClasses[i]);
			if (CF_strCmpNoCase(_resultClass, leftClasses[i])) {				
				_resultClass=leftClasses[0];
				break;
			}
		}
		if (!CF_strCmpNoCase(_resultClass, "null") && !CF_strCmpNoCase(_resultClass, leftClasses[0]))
			return -1;
		leftToRight=false;
	} else
		return -1;
	return OK;
}

//Added by Ilsoo Byun
// To solve a pointer problem.
int CA_associatorResolveDirection(const CMPIBroker* broker, const char* leftClasses[], const char* rightClasses[], const string& leftNamespace, const string& rightNamespace, const string& leftRole, const string& rightRole, const Objectpath& known, const string& resultClass, const string& role, const string& resultRole, bool& leftToRight) {	
        _E_;
        //-1 means not associated.
        CMPIStatus rc;
        if (CMClassPathIsA(broker, known.getHdl(), leftClasses[0], &rc)) {
                leftToRight=true;
                if (role != "null" && strcasecmp(leftRole.c_str(), role.c_str()) != 0) return -1;
                if (resultRole != "null" && strcasecmp(rightRole.c_str(), resultRole.c_str()) != 0) return -1;
        } else if (CMClassPathIsA(broker, known.getHdl(), rightClasses[0], &rc)) {
                leftToRight=false;
                if (role != "null" && strcasecmp(rightRole.c_str(), role.c_str()) != 0) return -1;
                if (resultRole != "null" && strcasecmp(leftRole.c_str(), resultRole.c_str()) != 0) return -1;
        } else {
                return -1;
        }
        _L_;
        return OK;
}

