package org.jboss.test.managed.factory.support.mcf;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;

import org.jboss.managed.api.annotation.ManagementObject;

@XmlAccessorType(XmlAccessType.FIELD)
@ManagementObject
public class ManagedConnectionFactoryPropertyMetaData implements Serializable
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 4978655092571661074L;
   
   /** The name */
   @XmlAttribute(name="name")
   private String name;
   
   /** The type */
   @XmlAttribute(name="type")   
   private String type = "java.lang.String";
   
   @XmlValue
   private String value;
   
   /**
    * Get the name.
    * 
    * @return the name.
    */
   public String getName()
   {
      return name;
   }
   /**
    * Set the name.
    * 
    * @param name The name to set.
    */
   public void setName(String name)
   {
      this.name = name;
   }
   /**
    * Get the type.
    * 
    * @return the type.
    */
   public String getType()
   {
      return type;
   }
   /**
    * Set the type.
    * 
    * @param type The type to set.
    */
   public void setType(String type)
   {
      this.type = type;
   }
   /**
    * Get the value.
    * 
    * @return the value.
    */
   public String getValue()
   {
      return value;
   }
   /**
    * Set the value.
    * 
    * @param value The value to set.
    */
   public void setValue(String value)
   {
      this.value = value;
   }
   
   @Override
   public boolean equals(Object obj)
   {
      if(this == obj)
         return true;
      
      if(!(obj instanceof ManagedConnectionFactoryPropertyMetaData))
      {
         return false;         
      }
      
      ManagedConnectionFactoryPropertyMetaData other = (ManagedConnectionFactoryPropertyMetaData)obj;
      
      if(getName() == null)
         return false;
      
      else
      {
         return getName().equals(other.getName());
      }
   }
   
   @Override
   public int hashCode()
   {
      if (getName() == null)
      {
         return 42;
      }

      return getName().hashCode();
   }
}
