#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
VERSION=$2
DIR=libjaudiotagger-java-$VERSION
TAR=libjaudiotagger-java_$VERSION.orig.tar.gz
TAG=$(echo "$VERSION")

svn export https://svn.java.net/svn/jaudiotagger~svn/tags/${TAG}/ $DIR
GZIP=--best tar czf $TAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
    . .svn/deb-layout
    mv $TAR $origDir
    echo "moved $TAR to $origDir"
fi
