with GNATCOLL.Projects; use GNATCOLL.Projects;
with GNATCOLL.Traces;   use GNATCOLL.Traces;
with GNATCOLL.VFS;      use GNATCOLL.VFS;
with GNAT.Directory_Operations; use GNAT.Directory_Operations;
with GNAT.IO; use GNAT.IO;  --  not text_IO, to avoid CR+LF

procedure Objects is
   use Library_Info_Lists;
   Tree : Project_Tree;
   LIs  : Library_Info_List;
   C    : Library_Info_Lists.Cursor;
   Current_Dir : constant Virtual_File := Get_Current_Dir;
begin
   Parse_Config_File;
   Tree.Load (Create ("extending.gpr"));

   LIs.Clear;
   Tree.Root_Project.Library_Files
      (Recursive          => True,
       List               => LIs,
       Exclude_Overridden => True);
   C := First (LIs);
   while Has_Element (C) loop
      Put_Line ("recursive from root LI="
         & Format_Pathname
            (+Relative_Path (Element (C).Library_File, Current_Dir),
             UNIX));
      Next (C);
   end loop;

   LIs.Clear;
   Tree.Root_Project.Library_Files
      (Recursive          => True,
       List               => LIs,
       Exclude_Overridden => False);
   C := First (LIs);
   while Has_Element (C) loop
      Put_Line ("recursive from root, show overridden, LI="
         & Format_Pathname
            (+Relative_Path (Element (C).Library_File, Current_Dir),
             UNIX));
      Next (C);
   end loop;

   LIs.Clear;
   Tree.Root_Project.Library_Files
      (Recursive          => False,
       List               => LIs,
       Exclude_Overridden => True);
   C := First (LIs);
   while Has_Element (C) loop
      Put_Line ("non recursive from root LI="
         & Format_Pathname
            (+Relative_Path (Element (C).Library_File, Current_Dir),
             UNIX));
      Next (C);
   end loop;

   LIs.Clear;
   Tree.Project_From_Name ("extended").Library_Files
      (Recursive          => False,
       List               => LIs,
       Exclude_Overridden => True);
   C := First (LIs);
   while Has_Element (C) loop
      Put_Line ("non recursive from extended LI="
         & Format_Pathname
            (+Relative_Path (Element (C).Library_File, Current_Dir),
             UNIX));
      Next (C);
   end loop;

   LIs.Clear;
   Tree.Project_From_Name ("extended").Library_Files
      (Recursive          => False,
       List               => LIs,
       Exclude_Overridden => False);
   C := First (LIs);
   while Has_Element (C) loop
      Put_Line ("non recursive from extended, show overridden, LI="
         & Format_Pathname
            (+Relative_Path (Element (C).Library_File, Current_Dir),
             UNIX));
      Next (C);
   end loop;


end Objects;
