#if   !defined(__LISTEVENTS_HPP)
#define __LISTEVENTS_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__EVENT_HPP)
#include <Event.hpp>
#endif

#if   !defined(__MEMENTO_HPP)
#include <Memento.hpp>
#endif

/**
Useful event identifier assignments
*/

static   DwordIdentifier   ListChanged(1);
static   DwordIdentifier   SelectionMade(2);
static   DwordIdentifier   EditedEntry(3);


DECLARE_CLASS( ListEvent );

/**
We define our domain event type which uses a numeric identifier and
accepts generic Memento pointers. The destructor of the Event
clears out the Memento for us. How nice.
*/

class ListEvent : public CORELINUX( Event< DwordIdentifier > )
{
public:

                        /// Constructor

                        ListEvent
                           ( 
                              DwordIdentifierCref aId, 
                              CORELINUX(MementoPtr) aMemento 
                           )
                           throw ( CORELINUX( NullPointerException ) )
                           :
                           CORELINUX(Event<DwordIdentifier>)( aId ),
                           theMemento(aMemento)
                        {
                           if( theMemento == NULLPTR )
                           {
                              throw CORELINUX(NullPointerException)(LOCATION);
                           }
                        }

                        /// Virtual destructor

   virtual              ~ListEvent( void )
                        {
                           if( theMemento != NULLPTR )
                           {
                              delete theMemento;
                              theMemento = NULLPTR;
                           }
                           else
                           {
                              ;  // do nothing
                           }
                        }

   //
   // Accessors
   //

            /// Retrieve the memento 

   inline   CORELINUX(MementoRef)  getMemento( void ) 
            {
               return *theMemento;
            }
protected:

                           ListEvent( void )
                              :
                              CORELINUX( Event<DwordIdentifier> )(),
                              theMemento( NULLPTR )
                           {
                              ;  // do nothing
                           }

private:

            CORELINUX(MementoPtr)     theMemento;
};

#endif // if !defined(__LISTEVENTS_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 03:46:00 $
   $Locker:  $
*/

