/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.errors;

import com.sun.tdk.signaturetest.errors.AnnotationHandler;
import com.sun.tdk.signaturetest.errors.Chain;
import com.sun.tdk.signaturetest.errors.ConstantValueHandler;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.errors.Handler;
import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.errors.ModifiersHandler;
import com.sun.tdk.signaturetest.errors.ReturnTypeHandler;
import com.sun.tdk.signaturetest.errors.SortedErrorFormatter;
import com.sun.tdk.signaturetest.errors.ThrowsHandler;
import com.sun.tdk.signaturetest.errors.TypeParametersHandler;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class HumanErrorFormatter
extends SortedErrorFormatter {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$errors$SortedErrorFormatter == null ? (class$com$sun$tdk$signaturetest$errors$SortedErrorFormatter = HumanErrorFormatter.class$("com.sun.tdk.signaturetest.errors.SortedErrorFormatter")) : class$com$sun$tdk$signaturetest$errors$SortedErrorFormatter);
    private Level level;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$errors$SortedErrorFormatter;

    public HumanErrorFormatter(PrintWriter out, boolean isv, Level l) {
        super(out, isv);
        this.level = l;
    }

    public void printErrors() {
        this.sortErrors();
        ErrorComparator ec = new ErrorComparator();
        int length = this.failedMessages.size();
        Chain ch = new Chain(this.failedMessages);
        int i = 0;
        while (i < length) {
            ErrorFormatter.Message e1 = (ErrorFormatter.Message)this.failedMessages.get(i);
            if (e1 != null) {
                int j = i;
                while (j + 1 < this.failedMessages.size()) {
                    ErrorFormatter.Message e2 = (ErrorFormatter.Message)this.failedMessages.get(j + 1);
                    if (ec.compare(e1, e2) != 0) break;
                    ++j;
                }
                List currentGroup = this.failedMessages.subList(i, j + 1);
                Handler h = this.constructHandlerChain();
                h.process(currentGroup, ch);
                i = j;
            }
            ++i;
        }
        ch.finishProcessing();
        this.supressExtraErrors();
        Iterator it = this.failedMessages.iterator();
        this.numErrors = 0;
        this.numWarnings = 0;
        while (it.hasNext()) {
            ErrorFormatter.Message m = (ErrorFormatter.Message)it.next();
            if (this.level.intValue() <= m.getLevel().intValue()) {
                ++this.numErrors;
                continue;
            }
            ++this.numWarnings;
        }
        this.sortErrorsForOutput();
        this.outProcessedErrors();
    }

    protected void outProcessedErrors() {
        boolean hasHeader = false;
        MessageType lastType = null;
        String cl = "";
        int i = 0;
        while (i < this.failedMessages.size()) {
            ErrorFormatter.Message current = (ErrorFormatter.Message)this.failedMessages.get(i);
            if (current != null) {
                String ccl = current.className;
                if (current.errorObject != null && current.errorObject.isInner()) {
                    ccl = current.errorObject.getQualifiedName();
                }
                if (current.messageType == MessageType.ADD_CLASSES) {
                    lastType = current.messageType;
                    this.out.println("\n+ Class " + ccl);
                    cl = ccl;
                } else if (current.messageType == MessageType.MISS_CLASSES) {
                    lastType = current.messageType;
                    this.out.println("\n- Class " + ccl);
                    cl = ccl;
                } else {
                    if (!cl.equals(ccl)) {
                        cl = ccl;
                        lastType = null;
                        this.out.println("\nClass " + cl);
                    }
                    if (current.messageType != lastType) {
                        hasHeader = true;
                        this.out.println("  " + current.messageType.getLocMessage());
                        lastType = current.messageType;
                    }
                    if (hasHeader) {
                        if (current.definition.equals("")) {
                            this.out.println(current.className);
                        } else {
                            StringBuffer name = new StringBuffer();
                            if (current.messageType != MessageType.CHNG_CLASSES_MEMBERS) {
                                this.out.println("    " + current.definition);
                                if (this.isVerbose() && current.tail.length() != 0) {
                                    this.out.println(i18n.getString("SortedErrorFormatter.error.affected", current.tail));
                                }
                            } else {
                                if (current.errorObject.getMemberType() != MemberType.CLASS) {
                                    name.append("    ");
                                    name.append(current.errorObject);
                                    this.out.println(name);
                                }
                                this.out.print(current.definition);
                            }
                        }
                    } else {
                        this.out.println(current);
                    }
                }
            }
            ++i;
        }
        if (this.failedMessages.size() > 0) {
            this.out.println("");
        }
    }

    protected Handler constructHandlerChain() {
        return new ModifiersHandler().setNext(new ReturnTypeHandler().setNext(new TypeParametersHandler().setNext(new ThrowsHandler().setNext(new ConstantValueHandler().setNext(new AnnotationHandler())))));
    }

    private void sortErrorsForOutput() {
        Collections.sort(this.failedMessages, new Comparator(){

            public int compare(Object o1, Object o2) {
                ErrorFormatter.Message m1 = (ErrorFormatter.Message)o1;
                ErrorFormatter.Message m2 = (ErrorFormatter.Message)o2;
                if (m1 == null && m2 == null) {
                    return 0;
                }
                if (m1 == null && m2 != null) {
                    return -1;
                }
                if (m1 != null && m2 == null) {
                    return 1;
                }
                int comp = m1.className.compareTo(m2.className);
                if (comp == 0 && (comp = m1.errorObject.getMemberType().compareTo(m2.errorObject.getMemberType())) == 0) {
                    comp = m1.messageType.compareTo(m2.messageType);
                    if (comp == 0 && (comp = m1.definition.compareTo(m2.definition)) == 0) {
                        comp = m1.tail != null && m2.tail != null ? m1.tail.compareTo(m2.tail) : (m1.tail == null ? -1 : 1);
                    }
                    return comp;
                }
                return comp;
            }
        });
    }

    protected void sortErrors() {
        Collections.sort(this.failedMessages, new ErrorComparator());
    }

    private void supressExtraErrors() {
        Collections.sort(this.failedMessages, new Comparator(){

            public int compare(Object o1, Object o2) {
                ErrorFormatter.Message m1 = (ErrorFormatter.Message)o1;
                ErrorFormatter.Message m2 = (ErrorFormatter.Message)o2;
                if (!HumanErrorFormatter.this.isSameKind(m1, m2)) {
                    return -1;
                }
                return m1.className.compareTo(m2.className);
            }
        });
        ArrayList toRemove = new ArrayList();
        int i = 0;
        while (i < this.failedMessages.size()) {
            block7: {
                ErrorFormatter.Message m1 = (ErrorFormatter.Message)this.failedMessages.get(i);
                int last = i;
                int j = i + 1;
                while (j < this.failedMessages.size()) {
                    ErrorFormatter.Message m2 = (ErrorFormatter.Message)this.failedMessages.get(j);
                    if (!this.isSameKind(m1, m2)) {
                        if (last != i) break;
                        i = j;
                        break block7;
                    }
                    last = j++;
                }
                boolean found = false;
                ArrayList<ErrorFormatter.Message> rem = new ArrayList<ErrorFormatter.Message>();
                int k = i;
                while (k <= last) {
                    ErrorFormatter.Message m = (ErrorFormatter.Message)this.failedMessages.get(k);
                    if (m.className.equals(m.errorObject.getDeclaringClassName())) {
                        found = true;
                    } else {
                        rem.add(m);
                    }
                    ++k;
                }
                if (found) {
                    toRemove.addAll(rem);
                }
                i = last;
            }
            ++i;
        }
        this.failedMessages.removeAll(toRemove);
    }

    private boolean isSameKind(ErrorFormatter.Message m1, ErrorFormatter.Message m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.errorObject.equals(m2.errorObject) && m1.definition.equals(m2.definition) && m1.tail.equals(m2.tail) && m1.messageType.equals(m2.messageType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ErrorComparator
    implements Comparator {
        private ErrorComparator() {
        }

        public int compare(Object o1, Object o2) {
            ErrorFormatter.Message msg1 = (ErrorFormatter.Message)o1;
            ErrorFormatter.Message msg2 = (ErrorFormatter.Message)o2;
            MemberDescription md1 = msg1.errorObject;
            MemberDescription md2 = msg2.errorObject;
            int comp = md1.getQualifiedName().compareTo(md2.getQualifiedName());
            if (comp == 0) {
                comp = md1.getMemberType().compareTo(md2.getMemberType());
                if (comp == 0 && (md1.getMemberType() == MemberType.METHOD || md1.getMemberType() == MemberType.CONSTRUCTOR)) {
                    if (md1 instanceof MethodDescr && md2 instanceof MethodDescr) {
                        MethodDescr mth1 = (MethodDescr)md1;
                        MethodDescr mth2 = (MethodDescr)md2;
                        comp = mth1.getSignature().compareTo(mth2.getSignature());
                    } else if (md1 instanceof ConstructorDescr && md2 instanceof ConstructorDescr) {
                        ConstructorDescr co1 = (ConstructorDescr)md1;
                        ConstructorDescr co2 = (ConstructorDescr)md2;
                        comp = co1.getSignature().compareTo(co2.getSignature());
                    }
                }
                if (comp == 0) {
                    comp = msg1.className.compareTo(msg2.className);
                }
            }
            return comp;
        }
    }
}

