/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "transaction.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "./transaction_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */
GWEN_LIST_FUNCTIONS(AB_TRANSACTION, AB_Transaction)
GWEN_LIST2_FUNCTIONS(AB_TRANSACTION, AB_Transaction)
GWEN_CONSTLIST2_FUNCTIONS(AB_TRANSACTION, AB_Transaction)


AB_TRANSACTION_TYPE AB_Transaction_Type_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AB_Transaction_TypeNone;
    else if (strcasecmp(p_s, "statement")==0)
      return AB_Transaction_TypeStatement;
    else if (strcasecmp(p_s, "notedStatement")==0)
      return AB_Transaction_TypeNotedStatement;
    else if (strcasecmp(p_s, "transfer")==0)
      return AB_Transaction_TypeTransfer;
    else if (strcasecmp(p_s, "debitNote")==0)
      return AB_Transaction_TypeDebitNote;
    else if (strcasecmp(p_s, "standingOrder")==0)
      return AB_Transaction_TypeStandingOrder;
    else if (strcasecmp(p_s, "internalTransfer")==0)
      return AB_Transaction_TypeInternalTransfer;
    else if (strcasecmp(p_s, "transaction")==0)
      return AB_Transaction_TypeTransaction;
    else if (strcasecmp(p_s, "split")==0)
      return AB_Transaction_TypeSplit;
  }
  return AB_Transaction_TypeUnknown;
}

AB_TRANSACTION_SUBTYPE AB_Transaction_SubType_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AB_Transaction_SubTypeNone;
    else if (strcasecmp(p_s, "standard")==0)
      return AB_Transaction_SubTypeStandard;
    else if (strcasecmp(p_s, "check")==0)
      return AB_Transaction_SubTypeCheck;
    else if (strcasecmp(p_s, "bookedDebitNote")==0)
      return AB_Transaction_SubTypeBookedDebitNote;
    else if (strcasecmp(p_s, "drawnDebitNote")==0)
      return AB_Transaction_SubTypeDrawnDebitNote;
    else if (strcasecmp(p_s, "standingOrder")==0)
      return AB_Transaction_SubTypeStandingOrder;
    else if (strcasecmp(p_s, "loan")==0)
      return AB_Transaction_SubTypeLoan;
    else if (strcasecmp(p_s, "euStandard")==0)
      return AB_Transaction_SubTypeEuStandard;
    else if (strcasecmp(p_s, "euASAP")==0)
      return AB_Transaction_SubTypeEuASAP;
    else if (strcasecmp(p_s, "buy")==0)
      return AB_Transaction_SubTypeBuy;
    else if (strcasecmp(p_s, "sell")==0)
      return AB_Transaction_SubTypeSell;
    else if (strcasecmp(p_s, "reinvest")==0)
      return AB_Transaction_SubTypeReinvest;
    else if (strcasecmp(p_s, "dividend")==0)
      return AB_Transaction_SubTypeDividend;
  }
  return AB_Transaction_SubTypeUnknown;
}

AB_TRANSACTION_COMMAND AB_Transaction_Command_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AB_Transaction_CommandNone;
    else if (strcasecmp(p_s, "getBalance")==0)
      return AB_Transaction_CommandGetBalance;
    else if (strcasecmp(p_s, "getTransactions")==0)
      return AB_Transaction_CommandGetTransactions;
    else if (strcasecmp(p_s, "getStandingOrders")==0)
      return AB_Transaction_CommandGetStandingOrders;
    else if (strcasecmp(p_s, "getDatedTransfers")==0)
      return AB_Transaction_CommandGetDatedTransfers;
    else if (strcasecmp(p_s, "sepaGetStandingOrders")==0)
      return AB_Transaction_CommandSepaGetStandingOrders;
    else if (strcasecmp(p_s, "loadCellPhone")==0)
      return AB_Transaction_CommandLoadCellPhone;
    else if (strcasecmp(p_s, "getEStatements")==0)
      return AB_Transaction_CommandGetEStatements;
    else if (strcasecmp(p_s, "transfer")==0)
      return AB_Transaction_CommandTransfer;
    else if (strcasecmp(p_s, "debitNote")==0)
      return AB_Transaction_CommandDebitNote;
    else if (strcasecmp(p_s, "createStandingOrder")==0)
      return AB_Transaction_CommandCreateStandingOrder;
    else if (strcasecmp(p_s, "modifyStandingOrder")==0)
      return AB_Transaction_CommandModifyStandingOrder;
    else if (strcasecmp(p_s, "deleteStandingOrder")==0)
      return AB_Transaction_CommandDeleteStandingOrder;
    else if (strcasecmp(p_s, "createDatedTransfer")==0)
      return AB_Transaction_CommandCreateDatedTransfer;
    else if (strcasecmp(p_s, "modifyDatedTransfer")==0)
      return AB_Transaction_CommandModifyDatedTransfer;
    else if (strcasecmp(p_s, "deleteDatedTransfer")==0)
      return AB_Transaction_CommandDeleteDatedTransfer;
    else if (strcasecmp(p_s, "internalTransfer")==0)
      return AB_Transaction_CommandInternalTransfer;
    else if (strcasecmp(p_s, "sepaTransfer")==0)
      return AB_Transaction_CommandSepaTransfer;
    else if (strcasecmp(p_s, "sepaDebitNote")==0)
      return AB_Transaction_CommandSepaDebitNote;
    else if (strcasecmp(p_s, "sepaFlashDebitNote")==0)
      return AB_Transaction_CommandSepaFlashDebitNote;
    else if (strcasecmp(p_s, "sepaCreateStandingOrder")==0)
      return AB_Transaction_CommandSepaCreateStandingOrder;
    else if (strcasecmp(p_s, "sepaModifyStandingOrder")==0)
      return AB_Transaction_CommandSepaModifyStandingOrder;
    else if (strcasecmp(p_s, "sepaDeleteStandingOrder")==0)
      return AB_Transaction_CommandSepaDeleteStandingOrder;
    else if (strcasecmp(p_s, "sepaCreateDatedTransfer")==0)
      return AB_Transaction_CommandSepaCreateDatedTransfer;
    else if (strcasecmp(p_s, "sepaModifyDatedTransfer")==0)
      return AB_Transaction_CommandSepaModifyDatedTransfer;
    else if (strcasecmp(p_s, "sepaDeleteDatedTransfer")==0)
      return AB_Transaction_CommandSepaDeleteDatedTransfer;
    else if (strcasecmp(p_s, "sepaInternalTransfer")==0)
      return AB_Transaction_CommandSepaInternalTransfer;
  }
  return AB_Transaction_CommandUnknown;
}

AB_TRANSACTION_STATUS AB_Transaction_Status_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AB_Transaction_StatusNone;
    else if (strcasecmp(p_s, "enqueued")==0)
      return AB_Transaction_StatusEnqueued;
    else if (strcasecmp(p_s, "sending")==0)
      return AB_Transaction_StatusSending;
    else if (strcasecmp(p_s, "sent")==0)
      return AB_Transaction_StatusSent;
    else if (strcasecmp(p_s, "accepted")==0)
      return AB_Transaction_StatusAccepted;
    else if (strcasecmp(p_s, "rejected")==0)
      return AB_Transaction_StatusRejected;
    else if (strcasecmp(p_s, "pending")==0)
      return AB_Transaction_StatusPending;
    else if (strcasecmp(p_s, "autoReconciled")==0)
      return AB_Transaction_StatusAutoReconciled;
    else if (strcasecmp(p_s, "manuallyReconciled")==0)
      return AB_Transaction_StatusManuallyReconciled;
    else if (strcasecmp(p_s, "revoked")==0)
      return AB_Transaction_StatusRevoked;
    else if (strcasecmp(p_s, "aborted")==0)
      return AB_Transaction_StatusAborted;
    else if (strcasecmp(p_s, "error")==0)
      return AB_Transaction_StatusError;
  }
  return AB_Transaction_StatusUnknown;
}

AB_TRANSACTION_PERIOD AB_Transaction_Period_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AB_Transaction_PeriodNone;
    else if (strcasecmp(p_s, "monthly")==0)
      return AB_Transaction_PeriodMonthly;
    else if (strcasecmp(p_s, "weekly")==0)
      return AB_Transaction_PeriodWeekly;
  }
  return AB_Transaction_PeriodUnknown;
}

AB_TRANSACTION_CHARGE AB_Transaction_Charge_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "nobody")==0)
      return AB_Transaction_ChargeNobody;
    else if (strcasecmp(p_s, "local")==0)
      return AB_Transaction_ChargeLocal;
    else if (strcasecmp(p_s, "remote")==0)
      return AB_Transaction_ChargeRemote;
    else if (strcasecmp(p_s, "share")==0)
      return AB_Transaction_ChargeShare;
  }
  return AB_Transaction_ChargeUnknown;
}

AB_TRANSACTION_SEQUENCE AB_Transaction_Sequence_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "once")==0)
      return AB_Transaction_SequenceOnce;
    else if (strcasecmp(p_s, "first")==0)
      return AB_Transaction_SequenceFirst;
    else if (strcasecmp(p_s, "following")==0)
      return AB_Transaction_SequenceFollowing;
    else if (strcasecmp(p_s, "final")==0)
      return AB_Transaction_SequenceFinal;
  }
  return AB_Transaction_SequenceUnknown;
}

const char *AB_Transaction_Type_toString(AB_TRANSACTION_TYPE p_i)
{
  switch (p_i) {
  case AB_Transaction_TypeNone:
    return "none";
  case AB_Transaction_TypeStatement:
    return "statement";
  case AB_Transaction_TypeNotedStatement:
    return "notedStatement";
  case AB_Transaction_TypeTransfer:
    return "transfer";
  case AB_Transaction_TypeDebitNote:
    return "debitNote";
  case AB_Transaction_TypeStandingOrder:
    return "standingOrder";
  case AB_Transaction_TypeInternalTransfer:
    return "internalTransfer";
  case AB_Transaction_TypeTransaction:
    return "transaction";
  case AB_Transaction_TypeSplit:
    return "split";
  case AB_Transaction_TypeUnknown:
  default:
    return "unknown";
  }
}

const char *AB_Transaction_SubType_toString(AB_TRANSACTION_SUBTYPE p_i)
{
  switch (p_i) {
  case AB_Transaction_SubTypeNone:
    return "none";
  case AB_Transaction_SubTypeStandard:
    return "standard";
  case AB_Transaction_SubTypeCheck:
    return "check";
  case AB_Transaction_SubTypeBookedDebitNote:
    return "bookedDebitNote";
  case AB_Transaction_SubTypeDrawnDebitNote:
    return "drawnDebitNote";
  case AB_Transaction_SubTypeStandingOrder:
    return "standingOrder";
  case AB_Transaction_SubTypeLoan:
    return "loan";
  case AB_Transaction_SubTypeEuStandard:
    return "euStandard";
  case AB_Transaction_SubTypeEuASAP:
    return "euASAP";
  case AB_Transaction_SubTypeBuy:
    return "buy";
  case AB_Transaction_SubTypeSell:
    return "sell";
  case AB_Transaction_SubTypeReinvest:
    return "reinvest";
  case AB_Transaction_SubTypeDividend:
    return "dividend";
  case AB_Transaction_SubTypeUnknown:
  default:
    return "unknown";
  }
}

const char *AB_Transaction_Command_toString(AB_TRANSACTION_COMMAND p_i)
{
  switch (p_i) {
  case AB_Transaction_CommandNone:
    return "none";
  case AB_Transaction_CommandGetBalance:
    return "getBalance";
  case AB_Transaction_CommandGetTransactions:
    return "getTransactions";
  case AB_Transaction_CommandGetStandingOrders:
    return "getStandingOrders";
  case AB_Transaction_CommandGetDatedTransfers:
    return "getDatedTransfers";
  case AB_Transaction_CommandSepaGetStandingOrders:
    return "sepaGetStandingOrders";
  case AB_Transaction_CommandLoadCellPhone:
    return "loadCellPhone";
  case AB_Transaction_CommandGetEStatements:
    return "getEStatements";
  case AB_Transaction_CommandTransfer:
    return "transfer";
  case AB_Transaction_CommandDebitNote:
    return "debitNote";
  case AB_Transaction_CommandCreateStandingOrder:
    return "createStandingOrder";
  case AB_Transaction_CommandModifyStandingOrder:
    return "modifyStandingOrder";
  case AB_Transaction_CommandDeleteStandingOrder:
    return "deleteStandingOrder";
  case AB_Transaction_CommandCreateDatedTransfer:
    return "createDatedTransfer";
  case AB_Transaction_CommandModifyDatedTransfer:
    return "modifyDatedTransfer";
  case AB_Transaction_CommandDeleteDatedTransfer:
    return "deleteDatedTransfer";
  case AB_Transaction_CommandInternalTransfer:
    return "internalTransfer";
  case AB_Transaction_CommandSepaTransfer:
    return "sepaTransfer";
  case AB_Transaction_CommandSepaDebitNote:
    return "sepaDebitNote";
  case AB_Transaction_CommandSepaFlashDebitNote:
    return "sepaFlashDebitNote";
  case AB_Transaction_CommandSepaCreateStandingOrder:
    return "sepaCreateStandingOrder";
  case AB_Transaction_CommandSepaModifyStandingOrder:
    return "sepaModifyStandingOrder";
  case AB_Transaction_CommandSepaDeleteStandingOrder:
    return "sepaDeleteStandingOrder";
  case AB_Transaction_CommandSepaCreateDatedTransfer:
    return "sepaCreateDatedTransfer";
  case AB_Transaction_CommandSepaModifyDatedTransfer:
    return "sepaModifyDatedTransfer";
  case AB_Transaction_CommandSepaDeleteDatedTransfer:
    return "sepaDeleteDatedTransfer";
  case AB_Transaction_CommandSepaInternalTransfer:
    return "sepaInternalTransfer";
  case AB_Transaction_CommandUnknown:
  default:
    return "unknown";
  }
}

const char *AB_Transaction_Status_toString(AB_TRANSACTION_STATUS p_i)
{
  switch (p_i) {
  case AB_Transaction_StatusNone:
    return "none";
  case AB_Transaction_StatusEnqueued:
    return "enqueued";
  case AB_Transaction_StatusSending:
    return "sending";
  case AB_Transaction_StatusSent:
    return "sent";
  case AB_Transaction_StatusAccepted:
    return "accepted";
  case AB_Transaction_StatusRejected:
    return "rejected";
  case AB_Transaction_StatusPending:
    return "pending";
  case AB_Transaction_StatusAutoReconciled:
    return "autoReconciled";
  case AB_Transaction_StatusManuallyReconciled:
    return "manuallyReconciled";
  case AB_Transaction_StatusRevoked:
    return "revoked";
  case AB_Transaction_StatusAborted:
    return "aborted";
  case AB_Transaction_StatusError:
    return "error";
  case AB_Transaction_StatusUnknown:
  default:
    return "unknown";
  }
}

const char *AB_Transaction_Period_toString(AB_TRANSACTION_PERIOD p_i)
{
  switch (p_i) {
  case AB_Transaction_PeriodNone:
    return "none";
  case AB_Transaction_PeriodMonthly:
    return "monthly";
  case AB_Transaction_PeriodWeekly:
    return "weekly";
  case AB_Transaction_PeriodUnknown:
  default:
    return "unknown";
  }
}

const char *AB_Transaction_Charge_toString(AB_TRANSACTION_CHARGE p_i)
{
  switch (p_i) {
  case AB_Transaction_ChargeNobody:
    return "nobody";
  case AB_Transaction_ChargeLocal:
    return "local";
  case AB_Transaction_ChargeRemote:
    return "remote";
  case AB_Transaction_ChargeShare:
    return "share";
  case AB_Transaction_ChargeUnknown:
  default:
    return "unknown";
  }
}

const char *AB_Transaction_Sequence_toString(AB_TRANSACTION_SEQUENCE p_i)
{
  switch (p_i) {
  case AB_Transaction_SequenceOnce:
    return "once";
  case AB_Transaction_SequenceFirst:
    return "first";
  case AB_Transaction_SequenceFollowing:
    return "following";
  case AB_Transaction_SequenceFinal:
    return "final";
  case AB_Transaction_SequenceUnknown:
  default:
    return "unknown";
  }
}

AB_TRANSACTION *AB_Transaction_new(void)
{
  AB_TRANSACTION *p_struct;

  GWEN_NEW_OBJECT(AB_TRANSACTION, p_struct)
  p_struct->_refCount=1;
  GWEN_LIST_INIT(AB_TRANSACTION, p_struct)
  /* members */
  p_struct->type=AB_Transaction_TypeUnknown;
  p_struct->subType=AB_Transaction_SubTypeNone;
  p_struct->command=AB_Transaction_CommandNone;
  p_struct->status=AB_Transaction_StatusUnknown;
  p_struct->uniqueAccountId=0;
  p_struct->uniqueId=0;
  p_struct->refUniqueId=0;
  p_struct->idForApplication=0;
  p_struct->stringIdForApplication=0;
  p_struct->sessionId=0;
  p_struct->groupId=0;
  p_struct->fiId=NULL;
  p_struct->localIban=NULL;
  p_struct->localBic=NULL;
  p_struct->localCountry=NULL;
  p_struct->localBankCode=NULL;
  p_struct->localBranchId=NULL;
  p_struct->localAccountNumber=NULL;
  p_struct->localSuffix=NULL;
  p_struct->localName=NULL;
  p_struct->remoteCountry=NULL;
  p_struct->remoteBankCode=NULL;
  p_struct->remoteBranchId=NULL;
  p_struct->remoteAccountNumber=NULL;
  p_struct->remoteSuffix=NULL;
  p_struct->remoteIban=NULL;
  p_struct->remoteBic=NULL;
  p_struct->remoteName=NULL;
  p_struct->date=NULL;
  p_struct->valutaDate=NULL;
  p_struct->value=AB_Value_new();
  p_struct->fees=AB_Value_new();
  p_struct->transactionCode=0;
  p_struct->transactionText=NULL;
  p_struct->transactionKey=NULL;
  p_struct->textKey=0;
  p_struct->primanota=NULL;
  p_struct->purpose=NULL;
  p_struct->category=NULL;
  p_struct->customerReference=NULL;
  p_struct->bankReference=NULL;
  p_struct->endToEndReference=NULL;
  p_struct->creditorSchemeId=NULL;
  p_struct->originatorId=NULL;
  p_struct->mandateId=NULL;
  p_struct->mandateDate=NULL;
  p_struct->mandateDebitorName=NULL;
  p_struct->originalCreditorSchemeId=NULL;
  p_struct->originalMandateId=NULL;
  p_struct->originalCreditorName=NULL;
  p_struct->sequence=AB_Transaction_SequenceUnknown;
  p_struct->charge=AB_Transaction_ChargeUnknown;
  p_struct->remoteAddrStreet=NULL;
  p_struct->remoteAddrZipcode=NULL;
  p_struct->remoteAddrCity=NULL;
  p_struct->remoteAddrPhone=NULL;
  p_struct->period=AB_Transaction_PeriodUnknown;
  p_struct->cycle=0;
  p_struct->executionDay=0;
  p_struct->firstDate=NULL;
  p_struct->lastDate=NULL;
  p_struct->nextDate=NULL;
  p_struct->unitId=NULL;
  p_struct->unitIdNameSpace=NULL;
  p_struct->tickerSymbol=NULL;
  p_struct->units=AB_Value_new();
  p_struct->unitPriceValue=AB_Value_new();
  p_struct->unitPriceDate=NULL;
  p_struct->commissionValue=AB_Value_new();
  p_struct->memo=NULL;
  p_struct->hash=NULL;
  /* virtual functions */

  return p_struct;
}

void AB_Transaction_free(AB_TRANSACTION *p_struct)
{
  if (p_struct) {
    assert(p_struct->_refCount);
    if (p_struct->_refCount==1) {
      GWEN_LIST_FINI(AB_TRANSACTION, p_struct)
      /* members */
      free(p_struct->fiId);
      p_struct->fiId=NULL;
      free(p_struct->localIban);
      p_struct->localIban=NULL;
      free(p_struct->localBic);
      p_struct->localBic=NULL;
      free(p_struct->localCountry);
      p_struct->localCountry=NULL;
      free(p_struct->localBankCode);
      p_struct->localBankCode=NULL;
      free(p_struct->localBranchId);
      p_struct->localBranchId=NULL;
      free(p_struct->localAccountNumber);
      p_struct->localAccountNumber=NULL;
      free(p_struct->localSuffix);
      p_struct->localSuffix=NULL;
      free(p_struct->localName);
      p_struct->localName=NULL;
      free(p_struct->remoteCountry);
      p_struct->remoteCountry=NULL;
      free(p_struct->remoteBankCode);
      p_struct->remoteBankCode=NULL;
      free(p_struct->remoteBranchId);
      p_struct->remoteBranchId=NULL;
      free(p_struct->remoteAccountNumber);
      p_struct->remoteAccountNumber=NULL;
      free(p_struct->remoteSuffix);
      p_struct->remoteSuffix=NULL;
      free(p_struct->remoteIban);
      p_struct->remoteIban=NULL;
      free(p_struct->remoteBic);
      p_struct->remoteBic=NULL;
      free(p_struct->remoteName);
      p_struct->remoteName=NULL;
      GWEN_Date_free(p_struct->date);
      p_struct->date=NULL;
      GWEN_Date_free(p_struct->valutaDate);
      p_struct->valutaDate=NULL;
      AB_Value_free(p_struct->value);
      AB_Value_free(p_struct->fees);
      free(p_struct->transactionText);
      p_struct->transactionText=NULL;
      free(p_struct->transactionKey);
      p_struct->transactionKey=NULL;
      free(p_struct->primanota);
      p_struct->primanota=NULL;
      free(p_struct->purpose);
      p_struct->purpose=NULL;
      free(p_struct->category);
      p_struct->category=NULL;
      free(p_struct->customerReference);
      p_struct->customerReference=NULL;
      free(p_struct->bankReference);
      p_struct->bankReference=NULL;
      free(p_struct->endToEndReference);
      p_struct->endToEndReference=NULL;
      free(p_struct->creditorSchemeId);
      p_struct->creditorSchemeId=NULL;
      free(p_struct->originatorId);
      p_struct->originatorId=NULL;
      free(p_struct->mandateId);
      p_struct->mandateId=NULL;
      GWEN_Date_free(p_struct->mandateDate);
      p_struct->mandateDate=NULL;
      free(p_struct->mandateDebitorName);
      p_struct->mandateDebitorName=NULL;
      free(p_struct->originalCreditorSchemeId);
      p_struct->originalCreditorSchemeId=NULL;
      free(p_struct->originalMandateId);
      p_struct->originalMandateId=NULL;
      free(p_struct->originalCreditorName);
      p_struct->originalCreditorName=NULL;
      free(p_struct->remoteAddrStreet);
      p_struct->remoteAddrStreet=NULL;
      free(p_struct->remoteAddrZipcode);
      p_struct->remoteAddrZipcode=NULL;
      free(p_struct->remoteAddrCity);
      p_struct->remoteAddrCity=NULL;
      free(p_struct->remoteAddrPhone);
      p_struct->remoteAddrPhone=NULL;
      GWEN_Date_free(p_struct->firstDate);
      p_struct->firstDate=NULL;
      GWEN_Date_free(p_struct->lastDate);
      p_struct->lastDate=NULL;
      GWEN_Date_free(p_struct->nextDate);
      p_struct->nextDate=NULL;
      free(p_struct->unitId);
      p_struct->unitId=NULL;
      free(p_struct->unitIdNameSpace);
      p_struct->unitIdNameSpace=NULL;
      free(p_struct->tickerSymbol);
      p_struct->tickerSymbol=NULL;
      AB_Value_free(p_struct->units);
      AB_Value_free(p_struct->unitPriceValue);
      GWEN_Date_free(p_struct->unitPriceDate);
      p_struct->unitPriceDate=NULL;
      AB_Value_free(p_struct->commissionValue);
      free(p_struct->memo);
      p_struct->memo=NULL;
      free(p_struct->hash);
      p_struct->hash=NULL;
      p_struct->_refCount=0;
      GWEN_FREE_OBJECT(p_struct);
    }
    else
      p_struct->_refCount--;
  }
}

void AB_Transaction_Attach(AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

AB_TRANSACTION *AB_Transaction_dup(const AB_TRANSACTION *p_src)
{
  AB_TRANSACTION *p_struct;

  assert(p_src);
  p_struct=AB_Transaction_new();
  /* member "type" */
  p_struct->type=p_src->type;

  /* member "subType" */
  p_struct->subType=p_src->subType;

  /* member "command" */
  p_struct->command=p_src->command;

  /* member "status" */
  p_struct->status=p_src->status;

  /* member "uniqueAccountId" */
  p_struct->uniqueAccountId=p_src->uniqueAccountId;

  /* member "uniqueId" */
  p_struct->uniqueId=p_src->uniqueId;

  /* member "refUniqueId" */
  p_struct->refUniqueId=p_src->refUniqueId;

  /* member "idForApplication" */
  p_struct->idForApplication=p_src->idForApplication;

  /* member "stringIdForApplication" */
  p_struct->stringIdForApplication=NULL;
  if (p_src->stringIdForApplication) {
    p_struct->stringIdForApplication=strdup(p_src->stringIdForApplication);
  }

  /* member "sessionId" */
  p_struct->sessionId=p_src->sessionId;

  /* member "groupId" */
  p_struct->groupId=p_src->groupId;

  /* member "fiId" */
  if (p_struct->fiId) {
    free(p_struct->fiId);
    p_struct->fiId=NULL;
    p_struct->fiId=NULL;
  }
  if (p_src->fiId) {
    p_struct->fiId=strdup(p_src->fiId);
  }

  /* member "localIban" */
  if (p_struct->localIban) {
    free(p_struct->localIban);
    p_struct->localIban=NULL;
    p_struct->localIban=NULL;
  }
  if (p_src->localIban) {
    p_struct->localIban=strdup(p_src->localIban);
  }

  /* member "localBic" */
  if (p_struct->localBic) {
    free(p_struct->localBic);
    p_struct->localBic=NULL;
    p_struct->localBic=NULL;
  }
  if (p_src->localBic) {
    p_struct->localBic=strdup(p_src->localBic);
  }

  /* member "localCountry" */
  if (p_struct->localCountry) {
    free(p_struct->localCountry);
    p_struct->localCountry=NULL;
    p_struct->localCountry=NULL;
  }
  if (p_src->localCountry) {
    p_struct->localCountry=strdup(p_src->localCountry);
  }

  /* member "localBankCode" */
  if (p_struct->localBankCode) {
    free(p_struct->localBankCode);
    p_struct->localBankCode=NULL;
    p_struct->localBankCode=NULL;
  }
  if (p_src->localBankCode) {
    p_struct->localBankCode=strdup(p_src->localBankCode);
  }

  /* member "localBranchId" */
  if (p_struct->localBranchId) {
    free(p_struct->localBranchId);
    p_struct->localBranchId=NULL;
    p_struct->localBranchId=NULL;
  }
  if (p_src->localBranchId) {
    p_struct->localBranchId=strdup(p_src->localBranchId);
  }

  /* member "localAccountNumber" */
  if (p_struct->localAccountNumber) {
    free(p_struct->localAccountNumber);
    p_struct->localAccountNumber=NULL;
    p_struct->localAccountNumber=NULL;
  }
  if (p_src->localAccountNumber) {
    p_struct->localAccountNumber=strdup(p_src->localAccountNumber);
  }

  /* member "localSuffix" */
  if (p_struct->localSuffix) {
    free(p_struct->localSuffix);
    p_struct->localSuffix=NULL;
    p_struct->localSuffix=NULL;
  }
  if (p_src->localSuffix) {
    p_struct->localSuffix=strdup(p_src->localSuffix);
  }

  /* member "localName" */
  if (p_struct->localName) {
    free(p_struct->localName);
    p_struct->localName=NULL;
    p_struct->localName=NULL;
  }
  if (p_src->localName) {
    p_struct->localName=strdup(p_src->localName);
  }

  /* member "remoteCountry" */
  if (p_struct->remoteCountry) {
    free(p_struct->remoteCountry);
    p_struct->remoteCountry=NULL;
    p_struct->remoteCountry=NULL;
  }
  if (p_src->remoteCountry) {
    p_struct->remoteCountry=strdup(p_src->remoteCountry);
  }

  /* member "remoteBankCode" */
  if (p_struct->remoteBankCode) {
    free(p_struct->remoteBankCode);
    p_struct->remoteBankCode=NULL;
    p_struct->remoteBankCode=NULL;
  }
  if (p_src->remoteBankCode) {
    p_struct->remoteBankCode=strdup(p_src->remoteBankCode);
  }

  /* member "remoteBranchId" */
  if (p_struct->remoteBranchId) {
    free(p_struct->remoteBranchId);
    p_struct->remoteBranchId=NULL;
    p_struct->remoteBranchId=NULL;
  }
  if (p_src->remoteBranchId) {
    p_struct->remoteBranchId=strdup(p_src->remoteBranchId);
  }

  /* member "remoteAccountNumber" */
  if (p_struct->remoteAccountNumber) {
    free(p_struct->remoteAccountNumber);
    p_struct->remoteAccountNumber=NULL;
    p_struct->remoteAccountNumber=NULL;
  }
  if (p_src->remoteAccountNumber) {
    p_struct->remoteAccountNumber=strdup(p_src->remoteAccountNumber);
  }

  /* member "remoteSuffix" */
  if (p_struct->remoteSuffix) {
    free(p_struct->remoteSuffix);
    p_struct->remoteSuffix=NULL;
    p_struct->remoteSuffix=NULL;
  }
  if (p_src->remoteSuffix) {
    p_struct->remoteSuffix=strdup(p_src->remoteSuffix);
  }

  /* member "remoteIban" */
  if (p_struct->remoteIban) {
    free(p_struct->remoteIban);
    p_struct->remoteIban=NULL;
    p_struct->remoteIban=NULL;
  }
  if (p_src->remoteIban) {
    p_struct->remoteIban=strdup(p_src->remoteIban);
  }

  /* member "remoteBic" */
  if (p_struct->remoteBic) {
    free(p_struct->remoteBic);
    p_struct->remoteBic=NULL;
    p_struct->remoteBic=NULL;
  }
  if (p_src->remoteBic) {
    p_struct->remoteBic=strdup(p_src->remoteBic);
  }

  /* member "remoteName" */
  if (p_struct->remoteName) {
    free(p_struct->remoteName);
    p_struct->remoteName=NULL;
    p_struct->remoteName=NULL;
  }
  if (p_src->remoteName) {
    p_struct->remoteName=strdup(p_src->remoteName);
  }

  /* member "date" */
  if (p_struct->date) {
    GWEN_Date_free(p_struct->date);
    p_struct->date=NULL;
    p_struct->date=NULL;
  }
  if (p_src->date) {
    p_struct->date=GWEN_Date_dup(p_src->date);
  }

  /* member "valutaDate" */
  if (p_struct->valutaDate) {
    GWEN_Date_free(p_struct->valutaDate);
    p_struct->valutaDate=NULL;
    p_struct->valutaDate=NULL;
  }
  if (p_src->valutaDate) {
    p_struct->valutaDate=GWEN_Date_dup(p_src->valutaDate);
  }

  /* member "value" */
  if (p_struct->value) {
    AB_Value_free(p_struct->value);
    p_struct->value=NULL;
  }
  if (p_src->value) {
    p_struct->value=AB_Value_dup(p_src->value);
  }

  /* member "fees" */
  if (p_struct->fees) {
    AB_Value_free(p_struct->fees);
    p_struct->fees=NULL;
  }
  if (p_src->fees) {
    p_struct->fees=AB_Value_dup(p_src->fees);
  }

  /* member "transactionCode" */
  p_struct->transactionCode=p_src->transactionCode;

  /* member "transactionText" */
  if (p_struct->transactionText) {
    free(p_struct->transactionText);
    p_struct->transactionText=NULL;
    p_struct->transactionText=NULL;
  }
  if (p_src->transactionText) {
    p_struct->transactionText=strdup(p_src->transactionText);
  }

  /* member "transactionKey" */
  if (p_struct->transactionKey) {
    free(p_struct->transactionKey);
    p_struct->transactionKey=NULL;
    p_struct->transactionKey=NULL;
  }
  if (p_src->transactionKey) {
    p_struct->transactionKey=strdup(p_src->transactionKey);
  }

  /* member "textKey" */
  p_struct->textKey=p_src->textKey;

  /* member "primanota" */
  if (p_struct->primanota) {
    free(p_struct->primanota);
    p_struct->primanota=NULL;
    p_struct->primanota=NULL;
  }
  if (p_src->primanota) {
    p_struct->primanota=strdup(p_src->primanota);
  }

  /* member "purpose" */
  if (p_struct->purpose) {
    free(p_struct->purpose);
    p_struct->purpose=NULL;
    p_struct->purpose=NULL;
  }
  if (p_src->purpose) {
    p_struct->purpose=strdup(p_src->purpose);
  }

  /* member "category" */
  if (p_struct->category) {
    free(p_struct->category);
    p_struct->category=NULL;
    p_struct->category=NULL;
  }
  if (p_src->category) {
    p_struct->category=strdup(p_src->category);
  }

  /* member "customerReference" */
  if (p_struct->customerReference) {
    free(p_struct->customerReference);
    p_struct->customerReference=NULL;
    p_struct->customerReference=NULL;
  }
  if (p_src->customerReference) {
    p_struct->customerReference=strdup(p_src->customerReference);
  }

  /* member "bankReference" */
  if (p_struct->bankReference) {
    free(p_struct->bankReference);
    p_struct->bankReference=NULL;
    p_struct->bankReference=NULL;
  }
  if (p_src->bankReference) {
    p_struct->bankReference=strdup(p_src->bankReference);
  }

  /* member "endToEndReference" */
  if (p_struct->endToEndReference) {
    free(p_struct->endToEndReference);
    p_struct->endToEndReference=NULL;
    p_struct->endToEndReference=NULL;
  }
  if (p_src->endToEndReference) {
    p_struct->endToEndReference=strdup(p_src->endToEndReference);
  }

  /* member "creditorSchemeId" */
  if (p_struct->creditorSchemeId) {
    free(p_struct->creditorSchemeId);
    p_struct->creditorSchemeId=NULL;
    p_struct->creditorSchemeId=NULL;
  }
  if (p_src->creditorSchemeId) {
    p_struct->creditorSchemeId=strdup(p_src->creditorSchemeId);
  }

  /* member "originatorId" */
  if (p_struct->originatorId) {
    free(p_struct->originatorId);
    p_struct->originatorId=NULL;
    p_struct->originatorId=NULL;
  }
  if (p_src->originatorId) {
    p_struct->originatorId=strdup(p_src->originatorId);
  }

  /* member "mandateId" */
  if (p_struct->mandateId) {
    free(p_struct->mandateId);
    p_struct->mandateId=NULL;
    p_struct->mandateId=NULL;
  }
  if (p_src->mandateId) {
    p_struct->mandateId=strdup(p_src->mandateId);
  }

  /* member "mandateDate" */
  if (p_struct->mandateDate) {
    GWEN_Date_free(p_struct->mandateDate);
    p_struct->mandateDate=NULL;
    p_struct->mandateDate=NULL;
  }
  if (p_src->mandateDate) {
    p_struct->mandateDate=GWEN_Date_dup(p_src->mandateDate);
  }

  /* member "mandateDebitorName" */
  if (p_struct->mandateDebitorName) {
    free(p_struct->mandateDebitorName);
    p_struct->mandateDebitorName=NULL;
    p_struct->mandateDebitorName=NULL;
  }
  if (p_src->mandateDebitorName) {
    p_struct->mandateDebitorName=strdup(p_src->mandateDebitorName);
  }

  /* member "originalCreditorSchemeId" */
  if (p_struct->originalCreditorSchemeId) {
    free(p_struct->originalCreditorSchemeId);
    p_struct->originalCreditorSchemeId=NULL;
    p_struct->originalCreditorSchemeId=NULL;
  }
  if (p_src->originalCreditorSchemeId) {
    p_struct->originalCreditorSchemeId=strdup(p_src->originalCreditorSchemeId);
  }

  /* member "originalMandateId" */
  if (p_struct->originalMandateId) {
    free(p_struct->originalMandateId);
    p_struct->originalMandateId=NULL;
    p_struct->originalMandateId=NULL;
  }
  if (p_src->originalMandateId) {
    p_struct->originalMandateId=strdup(p_src->originalMandateId);
  }

  /* member "originalCreditorName" */
  if (p_struct->originalCreditorName) {
    free(p_struct->originalCreditorName);
    p_struct->originalCreditorName=NULL;
    p_struct->originalCreditorName=NULL;
  }
  if (p_src->originalCreditorName) {
    p_struct->originalCreditorName=strdup(p_src->originalCreditorName);
  }

  /* member "sequence" */
  p_struct->sequence=p_src->sequence;

  /* member "charge" */
  p_struct->charge=p_src->charge;

  /* member "remoteAddrStreet" */
  if (p_struct->remoteAddrStreet) {
    free(p_struct->remoteAddrStreet);
    p_struct->remoteAddrStreet=NULL;
    p_struct->remoteAddrStreet=NULL;
  }
  if (p_src->remoteAddrStreet) {
    p_struct->remoteAddrStreet=strdup(p_src->remoteAddrStreet);
  }

  /* member "remoteAddrZipcode" */
  if (p_struct->remoteAddrZipcode) {
    free(p_struct->remoteAddrZipcode);
    p_struct->remoteAddrZipcode=NULL;
    p_struct->remoteAddrZipcode=NULL;
  }
  if (p_src->remoteAddrZipcode) {
    p_struct->remoteAddrZipcode=strdup(p_src->remoteAddrZipcode);
  }

  /* member "remoteAddrCity" */
  if (p_struct->remoteAddrCity) {
    free(p_struct->remoteAddrCity);
    p_struct->remoteAddrCity=NULL;
    p_struct->remoteAddrCity=NULL;
  }
  if (p_src->remoteAddrCity) {
    p_struct->remoteAddrCity=strdup(p_src->remoteAddrCity);
  }

  /* member "remoteAddrPhone" */
  if (p_struct->remoteAddrPhone) {
    free(p_struct->remoteAddrPhone);
    p_struct->remoteAddrPhone=NULL;
    p_struct->remoteAddrPhone=NULL;
  }
  if (p_src->remoteAddrPhone) {
    p_struct->remoteAddrPhone=strdup(p_src->remoteAddrPhone);
  }

  /* member "period" */
  p_struct->period=p_src->period;

  /* member "cycle" */
  p_struct->cycle=p_src->cycle;

  /* member "executionDay" */
  p_struct->executionDay=p_src->executionDay;

  /* member "firstDate" */
  if (p_struct->firstDate) {
    GWEN_Date_free(p_struct->firstDate);
    p_struct->firstDate=NULL;
    p_struct->firstDate=NULL;
  }
  if (p_src->firstDate) {
    p_struct->firstDate=GWEN_Date_dup(p_src->firstDate);
  }

  /* member "lastDate" */
  if (p_struct->lastDate) {
    GWEN_Date_free(p_struct->lastDate);
    p_struct->lastDate=NULL;
    p_struct->lastDate=NULL;
  }
  if (p_src->lastDate) {
    p_struct->lastDate=GWEN_Date_dup(p_src->lastDate);
  }

  /* member "nextDate" */
  if (p_struct->nextDate) {
    GWEN_Date_free(p_struct->nextDate);
    p_struct->nextDate=NULL;
    p_struct->nextDate=NULL;
  }
  if (p_src->nextDate) {
    p_struct->nextDate=GWEN_Date_dup(p_src->nextDate);
  }

  /* member "unitId" */
  if (p_struct->unitId) {
    free(p_struct->unitId);
    p_struct->unitId=NULL;
    p_struct->unitId=NULL;
  }
  if (p_src->unitId) {
    p_struct->unitId=strdup(p_src->unitId);
  }

  /* member "unitIdNameSpace" */
  if (p_struct->unitIdNameSpace) {
    free(p_struct->unitIdNameSpace);
    p_struct->unitIdNameSpace=NULL;
    p_struct->unitIdNameSpace=NULL;
  }
  if (p_src->unitIdNameSpace) {
    p_struct->unitIdNameSpace=strdup(p_src->unitIdNameSpace);
  }

  /* member "tickerSymbol" */
  if (p_struct->tickerSymbol) {
    free(p_struct->tickerSymbol);
    p_struct->tickerSymbol=NULL;
    p_struct->tickerSymbol=NULL;
  }
  if (p_src->tickerSymbol) {
    p_struct->tickerSymbol=strdup(p_src->tickerSymbol);
  }

  /* member "units" */
  if (p_struct->units) {
    AB_Value_free(p_struct->units);
    p_struct->units=NULL;
  }
  if (p_src->units) {
    p_struct->units=AB_Value_dup(p_src->units);
  }

  /* member "unitPriceValue" */
  if (p_struct->unitPriceValue) {
    AB_Value_free(p_struct->unitPriceValue);
    p_struct->unitPriceValue=NULL;
  }
  if (p_src->unitPriceValue) {
    p_struct->unitPriceValue=AB_Value_dup(p_src->unitPriceValue);
  }

  /* member "unitPriceDate" */
  if (p_struct->unitPriceDate) {
    GWEN_Date_free(p_struct->unitPriceDate);
    p_struct->unitPriceDate=NULL;
    p_struct->unitPriceDate=NULL;
  }
  if (p_src->unitPriceDate) {
    p_struct->unitPriceDate=GWEN_Date_dup(p_src->unitPriceDate);
  }

  /* member "commissionValue" */
  if (p_struct->commissionValue) {
    AB_Value_free(p_struct->commissionValue);
    p_struct->commissionValue=NULL;
  }
  if (p_src->commissionValue) {
    p_struct->commissionValue=AB_Value_dup(p_src->commissionValue);
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo);
    p_struct->memo=NULL;
    p_struct->memo=NULL;
  }
  if (p_src->memo) {
    p_struct->memo=strdup(p_src->memo);
  }

  /* member "hash" */
  if (p_struct->hash) {
    free(p_struct->hash);
    p_struct->hash=NULL;
    p_struct->hash=NULL;
  }
  if (p_src->hash) {
    p_struct->hash=strdup(p_src->hash);
  }

  return p_struct;
}

AB_TRANSACTION *AB_Transaction_copy(AB_TRANSACTION *p_struct, const AB_TRANSACTION *p_src)
{
  assert(p_struct);
  assert(p_src);
  /* member "type" */
  p_struct->type=p_src->type;

  /* member "subType" */
  p_struct->subType=p_src->subType;

  /* member "command" */
  p_struct->command=p_src->command;

  /* member "status" */
  p_struct->status=p_src->status;

  /* member "uniqueAccountId" */
  p_struct->uniqueAccountId=p_src->uniqueAccountId;

  /* member "uniqueId" */
  p_struct->uniqueId=p_src->uniqueId;

  /* member "refUniqueId" */
  p_struct->refUniqueId=p_src->refUniqueId;

  /* member "idForApplication" */
  p_struct->idForApplication=p_src->idForApplication;

  /* member "stringIdForApplication" */
  p_struct->stringIdForApplication=NULL;
  if (p_src->stringIdForApplication) {
    p_struct->stringIdForApplication=strdup(p_src->stringIdForApplication);
  }

  /* member "sessionId" */
  p_struct->sessionId=p_src->sessionId;

  /* member "groupId" */
  p_struct->groupId=p_src->groupId;

  /* member "fiId" */
  if (p_struct->fiId) {
    free(p_struct->fiId);
    p_struct->fiId=NULL;
    p_struct->fiId=NULL;
  }
  if (p_src->fiId) {
    p_struct->fiId=strdup(p_src->fiId);
  }

  /* member "localIban" */
  if (p_struct->localIban) {
    free(p_struct->localIban);
    p_struct->localIban=NULL;
    p_struct->localIban=NULL;
  }
  if (p_src->localIban) {
    p_struct->localIban=strdup(p_src->localIban);
  }

  /* member "localBic" */
  if (p_struct->localBic) {
    free(p_struct->localBic);
    p_struct->localBic=NULL;
    p_struct->localBic=NULL;
  }
  if (p_src->localBic) {
    p_struct->localBic=strdup(p_src->localBic);
  }

  /* member "localCountry" */
  if (p_struct->localCountry) {
    free(p_struct->localCountry);
    p_struct->localCountry=NULL;
    p_struct->localCountry=NULL;
  }
  if (p_src->localCountry) {
    p_struct->localCountry=strdup(p_src->localCountry);
  }

  /* member "localBankCode" */
  if (p_struct->localBankCode) {
    free(p_struct->localBankCode);
    p_struct->localBankCode=NULL;
    p_struct->localBankCode=NULL;
  }
  if (p_src->localBankCode) {
    p_struct->localBankCode=strdup(p_src->localBankCode);
  }

  /* member "localBranchId" */
  if (p_struct->localBranchId) {
    free(p_struct->localBranchId);
    p_struct->localBranchId=NULL;
    p_struct->localBranchId=NULL;
  }
  if (p_src->localBranchId) {
    p_struct->localBranchId=strdup(p_src->localBranchId);
  }

  /* member "localAccountNumber" */
  if (p_struct->localAccountNumber) {
    free(p_struct->localAccountNumber);
    p_struct->localAccountNumber=NULL;
    p_struct->localAccountNumber=NULL;
  }
  if (p_src->localAccountNumber) {
    p_struct->localAccountNumber=strdup(p_src->localAccountNumber);
  }

  /* member "localSuffix" */
  if (p_struct->localSuffix) {
    free(p_struct->localSuffix);
    p_struct->localSuffix=NULL;
    p_struct->localSuffix=NULL;
  }
  if (p_src->localSuffix) {
    p_struct->localSuffix=strdup(p_src->localSuffix);
  }

  /* member "localName" */
  if (p_struct->localName) {
    free(p_struct->localName);
    p_struct->localName=NULL;
    p_struct->localName=NULL;
  }
  if (p_src->localName) {
    p_struct->localName=strdup(p_src->localName);
  }

  /* member "remoteCountry" */
  if (p_struct->remoteCountry) {
    free(p_struct->remoteCountry);
    p_struct->remoteCountry=NULL;
    p_struct->remoteCountry=NULL;
  }
  if (p_src->remoteCountry) {
    p_struct->remoteCountry=strdup(p_src->remoteCountry);
  }

  /* member "remoteBankCode" */
  if (p_struct->remoteBankCode) {
    free(p_struct->remoteBankCode);
    p_struct->remoteBankCode=NULL;
    p_struct->remoteBankCode=NULL;
  }
  if (p_src->remoteBankCode) {
    p_struct->remoteBankCode=strdup(p_src->remoteBankCode);
  }

  /* member "remoteBranchId" */
  if (p_struct->remoteBranchId) {
    free(p_struct->remoteBranchId);
    p_struct->remoteBranchId=NULL;
    p_struct->remoteBranchId=NULL;
  }
  if (p_src->remoteBranchId) {
    p_struct->remoteBranchId=strdup(p_src->remoteBranchId);
  }

  /* member "remoteAccountNumber" */
  if (p_struct->remoteAccountNumber) {
    free(p_struct->remoteAccountNumber);
    p_struct->remoteAccountNumber=NULL;
    p_struct->remoteAccountNumber=NULL;
  }
  if (p_src->remoteAccountNumber) {
    p_struct->remoteAccountNumber=strdup(p_src->remoteAccountNumber);
  }

  /* member "remoteSuffix" */
  if (p_struct->remoteSuffix) {
    free(p_struct->remoteSuffix);
    p_struct->remoteSuffix=NULL;
    p_struct->remoteSuffix=NULL;
  }
  if (p_src->remoteSuffix) {
    p_struct->remoteSuffix=strdup(p_src->remoteSuffix);
  }

  /* member "remoteIban" */
  if (p_struct->remoteIban) {
    free(p_struct->remoteIban);
    p_struct->remoteIban=NULL;
    p_struct->remoteIban=NULL;
  }
  if (p_src->remoteIban) {
    p_struct->remoteIban=strdup(p_src->remoteIban);
  }

  /* member "remoteBic" */
  if (p_struct->remoteBic) {
    free(p_struct->remoteBic);
    p_struct->remoteBic=NULL;
    p_struct->remoteBic=NULL;
  }
  if (p_src->remoteBic) {
    p_struct->remoteBic=strdup(p_src->remoteBic);
  }

  /* member "remoteName" */
  if (p_struct->remoteName) {
    free(p_struct->remoteName);
    p_struct->remoteName=NULL;
    p_struct->remoteName=NULL;
  }
  if (p_src->remoteName) {
    p_struct->remoteName=strdup(p_src->remoteName);
  }

  /* member "date" */
  if (p_struct->date) {
    GWEN_Date_free(p_struct->date);
    p_struct->date=NULL;
    p_struct->date=NULL;
  }
  if (p_src->date) {
    p_struct->date=GWEN_Date_dup(p_src->date);
  }

  /* member "valutaDate" */
  if (p_struct->valutaDate) {
    GWEN_Date_free(p_struct->valutaDate);
    p_struct->valutaDate=NULL;
    p_struct->valutaDate=NULL;
  }
  if (p_src->valutaDate) {
    p_struct->valutaDate=GWEN_Date_dup(p_src->valutaDate);
  }

  /* member "value" */
  if (p_struct->value) {
    AB_Value_free(p_struct->value);
    p_struct->value=NULL;
  }
  if (p_src->value) {
    p_struct->value=AB_Value_dup(p_src->value);
  }

  /* member "fees" */
  if (p_struct->fees) {
    AB_Value_free(p_struct->fees);
    p_struct->fees=NULL;
  }
  if (p_src->fees) {
    p_struct->fees=AB_Value_dup(p_src->fees);
  }

  /* member "transactionCode" */
  p_struct->transactionCode=p_src->transactionCode;

  /* member "transactionText" */
  if (p_struct->transactionText) {
    free(p_struct->transactionText);
    p_struct->transactionText=NULL;
    p_struct->transactionText=NULL;
  }
  if (p_src->transactionText) {
    p_struct->transactionText=strdup(p_src->transactionText);
  }

  /* member "transactionKey" */
  if (p_struct->transactionKey) {
    free(p_struct->transactionKey);
    p_struct->transactionKey=NULL;
    p_struct->transactionKey=NULL;
  }
  if (p_src->transactionKey) {
    p_struct->transactionKey=strdup(p_src->transactionKey);
  }

  /* member "textKey" */
  p_struct->textKey=p_src->textKey;

  /* member "primanota" */
  if (p_struct->primanota) {
    free(p_struct->primanota);
    p_struct->primanota=NULL;
    p_struct->primanota=NULL;
  }
  if (p_src->primanota) {
    p_struct->primanota=strdup(p_src->primanota);
  }

  /* member "purpose" */
  if (p_struct->purpose) {
    free(p_struct->purpose);
    p_struct->purpose=NULL;
    p_struct->purpose=NULL;
  }
  if (p_src->purpose) {
    p_struct->purpose=strdup(p_src->purpose);
  }

  /* member "category" */
  if (p_struct->category) {
    free(p_struct->category);
    p_struct->category=NULL;
    p_struct->category=NULL;
  }
  if (p_src->category) {
    p_struct->category=strdup(p_src->category);
  }

  /* member "customerReference" */
  if (p_struct->customerReference) {
    free(p_struct->customerReference);
    p_struct->customerReference=NULL;
    p_struct->customerReference=NULL;
  }
  if (p_src->customerReference) {
    p_struct->customerReference=strdup(p_src->customerReference);
  }

  /* member "bankReference" */
  if (p_struct->bankReference) {
    free(p_struct->bankReference);
    p_struct->bankReference=NULL;
    p_struct->bankReference=NULL;
  }
  if (p_src->bankReference) {
    p_struct->bankReference=strdup(p_src->bankReference);
  }

  /* member "endToEndReference" */
  if (p_struct->endToEndReference) {
    free(p_struct->endToEndReference);
    p_struct->endToEndReference=NULL;
    p_struct->endToEndReference=NULL;
  }
  if (p_src->endToEndReference) {
    p_struct->endToEndReference=strdup(p_src->endToEndReference);
  }

  /* member "creditorSchemeId" */
  if (p_struct->creditorSchemeId) {
    free(p_struct->creditorSchemeId);
    p_struct->creditorSchemeId=NULL;
    p_struct->creditorSchemeId=NULL;
  }
  if (p_src->creditorSchemeId) {
    p_struct->creditorSchemeId=strdup(p_src->creditorSchemeId);
  }

  /* member "originatorId" */
  if (p_struct->originatorId) {
    free(p_struct->originatorId);
    p_struct->originatorId=NULL;
    p_struct->originatorId=NULL;
  }
  if (p_src->originatorId) {
    p_struct->originatorId=strdup(p_src->originatorId);
  }

  /* member "mandateId" */
  if (p_struct->mandateId) {
    free(p_struct->mandateId);
    p_struct->mandateId=NULL;
    p_struct->mandateId=NULL;
  }
  if (p_src->mandateId) {
    p_struct->mandateId=strdup(p_src->mandateId);
  }

  /* member "mandateDate" */
  if (p_struct->mandateDate) {
    GWEN_Date_free(p_struct->mandateDate);
    p_struct->mandateDate=NULL;
    p_struct->mandateDate=NULL;
  }
  if (p_src->mandateDate) {
    p_struct->mandateDate=GWEN_Date_dup(p_src->mandateDate);
  }

  /* member "mandateDebitorName" */
  if (p_struct->mandateDebitorName) {
    free(p_struct->mandateDebitorName);
    p_struct->mandateDebitorName=NULL;
    p_struct->mandateDebitorName=NULL;
  }
  if (p_src->mandateDebitorName) {
    p_struct->mandateDebitorName=strdup(p_src->mandateDebitorName);
  }

  /* member "originalCreditorSchemeId" */
  if (p_struct->originalCreditorSchemeId) {
    free(p_struct->originalCreditorSchemeId);
    p_struct->originalCreditorSchemeId=NULL;
    p_struct->originalCreditorSchemeId=NULL;
  }
  if (p_src->originalCreditorSchemeId) {
    p_struct->originalCreditorSchemeId=strdup(p_src->originalCreditorSchemeId);
  }

  /* member "originalMandateId" */
  if (p_struct->originalMandateId) {
    free(p_struct->originalMandateId);
    p_struct->originalMandateId=NULL;
    p_struct->originalMandateId=NULL;
  }
  if (p_src->originalMandateId) {
    p_struct->originalMandateId=strdup(p_src->originalMandateId);
  }

  /* member "originalCreditorName" */
  if (p_struct->originalCreditorName) {
    free(p_struct->originalCreditorName);
    p_struct->originalCreditorName=NULL;
    p_struct->originalCreditorName=NULL;
  }
  if (p_src->originalCreditorName) {
    p_struct->originalCreditorName=strdup(p_src->originalCreditorName);
  }

  /* member "sequence" */
  p_struct->sequence=p_src->sequence;

  /* member "charge" */
  p_struct->charge=p_src->charge;

  /* member "remoteAddrStreet" */
  if (p_struct->remoteAddrStreet) {
    free(p_struct->remoteAddrStreet);
    p_struct->remoteAddrStreet=NULL;
    p_struct->remoteAddrStreet=NULL;
  }
  if (p_src->remoteAddrStreet) {
    p_struct->remoteAddrStreet=strdup(p_src->remoteAddrStreet);
  }

  /* member "remoteAddrZipcode" */
  if (p_struct->remoteAddrZipcode) {
    free(p_struct->remoteAddrZipcode);
    p_struct->remoteAddrZipcode=NULL;
    p_struct->remoteAddrZipcode=NULL;
  }
  if (p_src->remoteAddrZipcode) {
    p_struct->remoteAddrZipcode=strdup(p_src->remoteAddrZipcode);
  }

  /* member "remoteAddrCity" */
  if (p_struct->remoteAddrCity) {
    free(p_struct->remoteAddrCity);
    p_struct->remoteAddrCity=NULL;
    p_struct->remoteAddrCity=NULL;
  }
  if (p_src->remoteAddrCity) {
    p_struct->remoteAddrCity=strdup(p_src->remoteAddrCity);
  }

  /* member "remoteAddrPhone" */
  if (p_struct->remoteAddrPhone) {
    free(p_struct->remoteAddrPhone);
    p_struct->remoteAddrPhone=NULL;
    p_struct->remoteAddrPhone=NULL;
  }
  if (p_src->remoteAddrPhone) {
    p_struct->remoteAddrPhone=strdup(p_src->remoteAddrPhone);
  }

  /* member "period" */
  p_struct->period=p_src->period;

  /* member "cycle" */
  p_struct->cycle=p_src->cycle;

  /* member "executionDay" */
  p_struct->executionDay=p_src->executionDay;

  /* member "firstDate" */
  if (p_struct->firstDate) {
    GWEN_Date_free(p_struct->firstDate);
    p_struct->firstDate=NULL;
    p_struct->firstDate=NULL;
  }
  if (p_src->firstDate) {
    p_struct->firstDate=GWEN_Date_dup(p_src->firstDate);
  }

  /* member "lastDate" */
  if (p_struct->lastDate) {
    GWEN_Date_free(p_struct->lastDate);
    p_struct->lastDate=NULL;
    p_struct->lastDate=NULL;
  }
  if (p_src->lastDate) {
    p_struct->lastDate=GWEN_Date_dup(p_src->lastDate);
  }

  /* member "nextDate" */
  if (p_struct->nextDate) {
    GWEN_Date_free(p_struct->nextDate);
    p_struct->nextDate=NULL;
    p_struct->nextDate=NULL;
  }
  if (p_src->nextDate) {
    p_struct->nextDate=GWEN_Date_dup(p_src->nextDate);
  }

  /* member "unitId" */
  if (p_struct->unitId) {
    free(p_struct->unitId);
    p_struct->unitId=NULL;
    p_struct->unitId=NULL;
  }
  if (p_src->unitId) {
    p_struct->unitId=strdup(p_src->unitId);
  }

  /* member "unitIdNameSpace" */
  if (p_struct->unitIdNameSpace) {
    free(p_struct->unitIdNameSpace);
    p_struct->unitIdNameSpace=NULL;
    p_struct->unitIdNameSpace=NULL;
  }
  if (p_src->unitIdNameSpace) {
    p_struct->unitIdNameSpace=strdup(p_src->unitIdNameSpace);
  }

  /* member "tickerSymbol" */
  if (p_struct->tickerSymbol) {
    free(p_struct->tickerSymbol);
    p_struct->tickerSymbol=NULL;
    p_struct->tickerSymbol=NULL;
  }
  if (p_src->tickerSymbol) {
    p_struct->tickerSymbol=strdup(p_src->tickerSymbol);
  }

  /* member "units" */
  if (p_struct->units) {
    AB_Value_free(p_struct->units);
    p_struct->units=NULL;
  }
  if (p_src->units) {
    p_struct->units=AB_Value_dup(p_src->units);
  }

  /* member "unitPriceValue" */
  if (p_struct->unitPriceValue) {
    AB_Value_free(p_struct->unitPriceValue);
    p_struct->unitPriceValue=NULL;
  }
  if (p_src->unitPriceValue) {
    p_struct->unitPriceValue=AB_Value_dup(p_src->unitPriceValue);
  }

  /* member "unitPriceDate" */
  if (p_struct->unitPriceDate) {
    GWEN_Date_free(p_struct->unitPriceDate);
    p_struct->unitPriceDate=NULL;
    p_struct->unitPriceDate=NULL;
  }
  if (p_src->unitPriceDate) {
    p_struct->unitPriceDate=GWEN_Date_dup(p_src->unitPriceDate);
  }

  /* member "commissionValue" */
  if (p_struct->commissionValue) {
    AB_Value_free(p_struct->commissionValue);
    p_struct->commissionValue=NULL;
  }
  if (p_src->commissionValue) {
    p_struct->commissionValue=AB_Value_dup(p_src->commissionValue);
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo);
    p_struct->memo=NULL;
    p_struct->memo=NULL;
  }
  if (p_src->memo) {
    p_struct->memo=strdup(p_src->memo);
  }

  /* member "hash" */
  if (p_struct->hash) {
    free(p_struct->hash);
    p_struct->hash=NULL;
    p_struct->hash=NULL;
  }
  if (p_src->hash) {
    p_struct->hash=strdup(p_src->hash);
  }

  return p_struct;
}

AB_TRANSACTION_TYPE AB_Transaction_GetType(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->type;
}

AB_TRANSACTION_SUBTYPE AB_Transaction_GetSubType(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->subType;
}

AB_TRANSACTION_COMMAND AB_Transaction_GetCommand(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->command;
}

AB_TRANSACTION_STATUS AB_Transaction_GetStatus(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->status;
}

uint32_t AB_Transaction_GetUniqueAccountId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->uniqueAccountId;
}

uint32_t AB_Transaction_GetUniqueId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->uniqueId;
}

uint32_t AB_Transaction_GetRefUniqueId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->refUniqueId;
}

uint32_t AB_Transaction_GetIdForApplication(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->idForApplication;
}

const char *AB_Transaction_GetStringIdForApplication(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->stringIdForApplication;
}

uint32_t AB_Transaction_GetSessionId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->sessionId;
}

uint32_t AB_Transaction_GetGroupId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->groupId;
}

const char *AB_Transaction_GetFiId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->fiId;
}

const char *AB_Transaction_GetLocalIban(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->localIban;
}

const char *AB_Transaction_GetLocalBic(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->localBic;
}

const char *AB_Transaction_GetLocalCountry(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->localCountry;
}

const char *AB_Transaction_GetLocalBankCode(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->localBankCode;
}

const char *AB_Transaction_GetLocalBranchId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->localBranchId;
}

const char *AB_Transaction_GetLocalAccountNumber(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->localAccountNumber;
}

const char *AB_Transaction_GetLocalSuffix(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->localSuffix;
}

const char *AB_Transaction_GetLocalName(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->localName;
}

const char *AB_Transaction_GetRemoteCountry(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteCountry;
}

const char *AB_Transaction_GetRemoteBankCode(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteBankCode;
}

const char *AB_Transaction_GetRemoteBranchId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteBranchId;
}

const char *AB_Transaction_GetRemoteAccountNumber(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteAccountNumber;
}

const char *AB_Transaction_GetRemoteSuffix(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteSuffix;
}

const char *AB_Transaction_GetRemoteIban(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteIban;
}

const char *AB_Transaction_GetRemoteBic(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteBic;
}

const char *AB_Transaction_GetRemoteName(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteName;
}

const GWEN_DATE *AB_Transaction_GetDate(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->date;
}

const GWEN_DATE *AB_Transaction_GetValutaDate(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->valutaDate;
}

const AB_VALUE *AB_Transaction_GetValue(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->value;
}

const AB_VALUE *AB_Transaction_GetFees(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->fees;
}

int AB_Transaction_GetTransactionCode(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->transactionCode;
}

const char *AB_Transaction_GetTransactionText(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->transactionText;
}

const char *AB_Transaction_GetTransactionKey(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->transactionKey;
}

int AB_Transaction_GetTextKey(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->textKey;
}

const char *AB_Transaction_GetPrimanota(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->primanota;
}

const char *AB_Transaction_GetPurpose(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->purpose;
}

const char *AB_Transaction_GetCategory(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->category;
}

const char *AB_Transaction_GetCustomerReference(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->customerReference;
}

const char *AB_Transaction_GetBankReference(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->bankReference;
}

const char *AB_Transaction_GetEndToEndReference(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->endToEndReference;
}

const char *AB_Transaction_GetCreditorSchemeId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->creditorSchemeId;
}

const char *AB_Transaction_GetOriginatorId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->originatorId;
}

const char *AB_Transaction_GetMandateId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->mandateId;
}

const GWEN_DATE *AB_Transaction_GetMandateDate(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->mandateDate;
}

const char *AB_Transaction_GetMandateDebitorName(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->mandateDebitorName;
}

const char *AB_Transaction_GetOriginalCreditorSchemeId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->originalCreditorSchemeId;
}

const char *AB_Transaction_GetOriginalMandateId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->originalMandateId;
}

const char *AB_Transaction_GetOriginalCreditorName(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->originalCreditorName;
}

AB_TRANSACTION_SEQUENCE AB_Transaction_GetSequence(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->sequence;
}

AB_TRANSACTION_CHARGE AB_Transaction_GetCharge(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->charge;
}

const char *AB_Transaction_GetRemoteAddrStreet(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteAddrStreet;
}

const char *AB_Transaction_GetRemoteAddrZipcode(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteAddrZipcode;
}

const char *AB_Transaction_GetRemoteAddrCity(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteAddrCity;
}

const char *AB_Transaction_GetRemoteAddrPhone(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->remoteAddrPhone;
}

AB_TRANSACTION_PERIOD AB_Transaction_GetPeriod(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->period;
}

uint32_t AB_Transaction_GetCycle(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->cycle;
}

uint32_t AB_Transaction_GetExecutionDay(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->executionDay;
}

const GWEN_DATE *AB_Transaction_GetFirstDate(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->firstDate;
}

const GWEN_DATE *AB_Transaction_GetLastDate(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->lastDate;
}

const GWEN_DATE *AB_Transaction_GetNextDate(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->nextDate;
}

const char *AB_Transaction_GetUnitId(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->unitId;
}

const char *AB_Transaction_GetUnitIdNameSpace(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->unitIdNameSpace;
}

const char *AB_Transaction_GetTickerSymbol(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->tickerSymbol;
}

const AB_VALUE *AB_Transaction_GetUnits(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->units;
}

const AB_VALUE *AB_Transaction_GetUnitPriceValue(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->unitPriceValue;
}

const GWEN_DATE *AB_Transaction_GetUnitPriceDate(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->unitPriceDate;
}

const AB_VALUE *AB_Transaction_GetCommissionValue(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->commissionValue;
}

const char *AB_Transaction_GetMemo(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->memo;
}

const char *AB_Transaction_GetHash(const AB_TRANSACTION *p_struct)
{
  assert(p_struct);
  return p_struct->hash;
}

void AB_Transaction_SetType(AB_TRANSACTION *p_struct, AB_TRANSACTION_TYPE  p_src)
{
  assert(p_struct);
  p_struct->type=p_src;
}

void AB_Transaction_SetSubType(AB_TRANSACTION *p_struct, AB_TRANSACTION_SUBTYPE  p_src)
{
  assert(p_struct);
  p_struct->subType=p_src;
}

void AB_Transaction_SetCommand(AB_TRANSACTION *p_struct, AB_TRANSACTION_COMMAND  p_src)
{
  assert(p_struct);
  p_struct->command=p_src;
}

void AB_Transaction_SetStatus(AB_TRANSACTION *p_struct, AB_TRANSACTION_STATUS  p_src)
{
  assert(p_struct);
  p_struct->status=p_src;
}

void AB_Transaction_SetUniqueAccountId(AB_TRANSACTION *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->uniqueAccountId=p_src;
}

void AB_Transaction_SetUniqueId(AB_TRANSACTION *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->uniqueId=p_src;
}

void AB_Transaction_SetRefUniqueId(AB_TRANSACTION *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->refUniqueId=p_src;
}

void AB_Transaction_SetIdForApplication(AB_TRANSACTION *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->idForApplication=p_src;
}

void AB_Transaction_SetStringIdForApplication(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_src) {
    p_struct->stringIdForApplication=strdup(p_src);
  }
  else {
    p_struct->stringIdForApplication=0;
  }
}

void AB_Transaction_SetSessionId(AB_TRANSACTION *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->sessionId=p_src;
}

void AB_Transaction_SetGroupId(AB_TRANSACTION *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->groupId=p_src;
}

void AB_Transaction_SetFiId(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->fiId) {
    free(p_struct->fiId);
    p_struct->fiId=NULL;
  }
  if (p_src) {
    p_struct->fiId=strdup(p_src);
  }
  else {
    p_struct->fiId=NULL;
  }
}

void AB_Transaction_SetLocalIban(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->localIban) {
    free(p_struct->localIban);
    p_struct->localIban=NULL;
  }
  if (p_src) {
    p_struct->localIban=strdup(p_src);
  }
  else {
    p_struct->localIban=NULL;
  }
}

void AB_Transaction_SetLocalBic(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->localBic) {
    free(p_struct->localBic);
    p_struct->localBic=NULL;
  }
  if (p_src) {
    p_struct->localBic=strdup(p_src);
  }
  else {
    p_struct->localBic=NULL;
  }
}

void AB_Transaction_SetLocalCountry(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->localCountry) {
    free(p_struct->localCountry);
    p_struct->localCountry=NULL;
  }
  if (p_src) {
    p_struct->localCountry=strdup(p_src);
  }
  else {
    p_struct->localCountry=NULL;
  }
}

void AB_Transaction_SetLocalBankCode(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->localBankCode) {
    free(p_struct->localBankCode);
    p_struct->localBankCode=NULL;
  }
  if (p_src) {
    p_struct->localBankCode=strdup(p_src);
  }
  else {
    p_struct->localBankCode=NULL;
  }
}

void AB_Transaction_SetLocalBranchId(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->localBranchId) {
    free(p_struct->localBranchId);
    p_struct->localBranchId=NULL;
  }
  if (p_src) {
    p_struct->localBranchId=strdup(p_src);
  }
  else {
    p_struct->localBranchId=NULL;
  }
}

void AB_Transaction_SetLocalAccountNumber(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->localAccountNumber) {
    free(p_struct->localAccountNumber);
    p_struct->localAccountNumber=NULL;
  }
  if (p_src) {
    p_struct->localAccountNumber=strdup(p_src);
  }
  else {
    p_struct->localAccountNumber=NULL;
  }
}

void AB_Transaction_SetLocalSuffix(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->localSuffix) {
    free(p_struct->localSuffix);
    p_struct->localSuffix=NULL;
  }
  if (p_src) {
    p_struct->localSuffix=strdup(p_src);
  }
  else {
    p_struct->localSuffix=NULL;
  }
}

void AB_Transaction_SetLocalName(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->localName) {
    free(p_struct->localName);
    p_struct->localName=NULL;
  }
  if (p_src) {
    p_struct->localName=strdup(p_src);
  }
  else {
    p_struct->localName=NULL;
  }
}

void AB_Transaction_SetRemoteCountry(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteCountry) {
    free(p_struct->remoteCountry);
    p_struct->remoteCountry=NULL;
  }
  if (p_src) {
    p_struct->remoteCountry=strdup(p_src);
  }
  else {
    p_struct->remoteCountry=NULL;
  }
}

void AB_Transaction_SetRemoteBankCode(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteBankCode) {
    free(p_struct->remoteBankCode);
    p_struct->remoteBankCode=NULL;
  }
  if (p_src) {
    p_struct->remoteBankCode=strdup(p_src);
  }
  else {
    p_struct->remoteBankCode=NULL;
  }
}

void AB_Transaction_SetRemoteBranchId(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteBranchId) {
    free(p_struct->remoteBranchId);
    p_struct->remoteBranchId=NULL;
  }
  if (p_src) {
    p_struct->remoteBranchId=strdup(p_src);
  }
  else {
    p_struct->remoteBranchId=NULL;
  }
}

void AB_Transaction_SetRemoteAccountNumber(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteAccountNumber) {
    free(p_struct->remoteAccountNumber);
    p_struct->remoteAccountNumber=NULL;
  }
  if (p_src) {
    p_struct->remoteAccountNumber=strdup(p_src);
  }
  else {
    p_struct->remoteAccountNumber=NULL;
  }
}

void AB_Transaction_SetRemoteSuffix(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteSuffix) {
    free(p_struct->remoteSuffix);
    p_struct->remoteSuffix=NULL;
  }
  if (p_src) {
    p_struct->remoteSuffix=strdup(p_src);
  }
  else {
    p_struct->remoteSuffix=NULL;
  }
}

void AB_Transaction_SetRemoteIban(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteIban) {
    free(p_struct->remoteIban);
    p_struct->remoteIban=NULL;
  }
  if (p_src) {
    p_struct->remoteIban=strdup(p_src);
  }
  else {
    p_struct->remoteIban=NULL;
  }
}

void AB_Transaction_SetRemoteBic(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteBic) {
    free(p_struct->remoteBic);
    p_struct->remoteBic=NULL;
  }
  if (p_src) {
    p_struct->remoteBic=strdup(p_src);
  }
  else {
    p_struct->remoteBic=NULL;
  }
}

void AB_Transaction_SetRemoteName(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteName) {
    free(p_struct->remoteName);
    p_struct->remoteName=NULL;
  }
  if (p_src) {
    p_struct->remoteName=strdup(p_src);
  }
  else {
    p_struct->remoteName=NULL;
  }
}

void AB_Transaction_SetDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src)
{
  assert(p_struct);
  if (p_struct->date) {
    GWEN_Date_free(p_struct->date);
    p_struct->date=NULL;
  }
  if (p_src) {
    p_struct->date=GWEN_Date_dup(p_src);
  }
  else {
    p_struct->date=NULL;
  }
}

void AB_Transaction_SetValutaDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src)
{
  assert(p_struct);
  if (p_struct->valutaDate) {
    GWEN_Date_free(p_struct->valutaDate);
    p_struct->valutaDate=NULL;
  }
  if (p_src) {
    p_struct->valutaDate=GWEN_Date_dup(p_src);
  }
  else {
    p_struct->valutaDate=NULL;
  }
}

void AB_Transaction_SetValue(AB_TRANSACTION *p_struct, const AB_VALUE *p_src)
{
  assert(p_struct);
  if (p_struct->value) {
    AB_Value_free(p_struct->value);
  }
  if (p_src) {
    p_struct->value=AB_Value_dup(p_src);
  }
  else {
    p_struct->value=AB_Value_new();
  }
}

void AB_Transaction_SetFees(AB_TRANSACTION *p_struct, const AB_VALUE *p_src)
{
  assert(p_struct);
  if (p_struct->fees) {
    AB_Value_free(p_struct->fees);
  }
  if (p_src) {
    p_struct->fees=AB_Value_dup(p_src);
  }
  else {
    p_struct->fees=AB_Value_new();
  }
}

void AB_Transaction_SetTransactionCode(AB_TRANSACTION *p_struct, int p_src)
{
  assert(p_struct);
  p_struct->transactionCode=p_src;
}

void AB_Transaction_SetTransactionText(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->transactionText) {
    free(p_struct->transactionText);
    p_struct->transactionText=NULL;
  }
  if (p_src) {
    p_struct->transactionText=strdup(p_src);
  }
  else {
    p_struct->transactionText=NULL;
  }
}

void AB_Transaction_SetTransactionKey(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->transactionKey) {
    free(p_struct->transactionKey);
    p_struct->transactionKey=NULL;
  }
  if (p_src) {
    p_struct->transactionKey=strdup(p_src);
  }
  else {
    p_struct->transactionKey=NULL;
  }
}

void AB_Transaction_SetTextKey(AB_TRANSACTION *p_struct, int p_src)
{
  assert(p_struct);
  p_struct->textKey=p_src;
}

void AB_Transaction_SetPrimanota(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->primanota) {
    free(p_struct->primanota);
    p_struct->primanota=NULL;
  }
  if (p_src) {
    p_struct->primanota=strdup(p_src);
  }
  else {
    p_struct->primanota=NULL;
  }
}

void AB_Transaction_SetPurpose(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->purpose) {
    free(p_struct->purpose);
    p_struct->purpose=NULL;
  }
  if (p_src) {
    p_struct->purpose=strdup(p_src);
  }
  else {
    p_struct->purpose=NULL;
  }
}

void AB_Transaction_SetCategory(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->category) {
    free(p_struct->category);
    p_struct->category=NULL;
  }
  if (p_src) {
    p_struct->category=strdup(p_src);
  }
  else {
    p_struct->category=NULL;
  }
}

void AB_Transaction_SetCustomerReference(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->customerReference) {
    free(p_struct->customerReference);
    p_struct->customerReference=NULL;
  }
  if (p_src) {
    p_struct->customerReference=strdup(p_src);
  }
  else {
    p_struct->customerReference=NULL;
  }
}

void AB_Transaction_SetBankReference(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->bankReference) {
    free(p_struct->bankReference);
    p_struct->bankReference=NULL;
  }
  if (p_src) {
    p_struct->bankReference=strdup(p_src);
  }
  else {
    p_struct->bankReference=NULL;
  }
}

void AB_Transaction_SetEndToEndReference(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->endToEndReference) {
    free(p_struct->endToEndReference);
    p_struct->endToEndReference=NULL;
  }
  if (p_src) {
    p_struct->endToEndReference=strdup(p_src);
  }
  else {
    p_struct->endToEndReference=NULL;
  }
}

void AB_Transaction_SetCreditorSchemeId(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->creditorSchemeId) {
    free(p_struct->creditorSchemeId);
    p_struct->creditorSchemeId=NULL;
  }
  if (p_src) {
    p_struct->creditorSchemeId=strdup(p_src);
  }
  else {
    p_struct->creditorSchemeId=NULL;
  }
}

void AB_Transaction_SetOriginatorId(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->originatorId) {
    free(p_struct->originatorId);
    p_struct->originatorId=NULL;
  }
  if (p_src) {
    p_struct->originatorId=strdup(p_src);
  }
  else {
    p_struct->originatorId=NULL;
  }
}

void AB_Transaction_SetMandateId(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->mandateId) {
    free(p_struct->mandateId);
    p_struct->mandateId=NULL;
  }
  if (p_src) {
    p_struct->mandateId=strdup(p_src);
  }
  else {
    p_struct->mandateId=NULL;
  }
}

void AB_Transaction_SetMandateDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src)
{
  assert(p_struct);
  if (p_struct->mandateDate) {
    GWEN_Date_free(p_struct->mandateDate);
    p_struct->mandateDate=NULL;
  }
  if (p_src) {
    p_struct->mandateDate=GWEN_Date_dup(p_src);
  }
  else {
    p_struct->mandateDate=NULL;
  }
}

void AB_Transaction_SetMandateDebitorName(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->mandateDebitorName) {
    free(p_struct->mandateDebitorName);
    p_struct->mandateDebitorName=NULL;
  }
  if (p_src) {
    p_struct->mandateDebitorName=strdup(p_src);
  }
  else {
    p_struct->mandateDebitorName=NULL;
  }
}

void AB_Transaction_SetOriginalCreditorSchemeId(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->originalCreditorSchemeId) {
    free(p_struct->originalCreditorSchemeId);
    p_struct->originalCreditorSchemeId=NULL;
  }
  if (p_src) {
    p_struct->originalCreditorSchemeId=strdup(p_src);
  }
  else {
    p_struct->originalCreditorSchemeId=NULL;
  }
}

void AB_Transaction_SetOriginalMandateId(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->originalMandateId) {
    free(p_struct->originalMandateId);
    p_struct->originalMandateId=NULL;
  }
  if (p_src) {
    p_struct->originalMandateId=strdup(p_src);
  }
  else {
    p_struct->originalMandateId=NULL;
  }
}

void AB_Transaction_SetOriginalCreditorName(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->originalCreditorName) {
    free(p_struct->originalCreditorName);
    p_struct->originalCreditorName=NULL;
  }
  if (p_src) {
    p_struct->originalCreditorName=strdup(p_src);
  }
  else {
    p_struct->originalCreditorName=NULL;
  }
}

void AB_Transaction_SetSequence(AB_TRANSACTION *p_struct, AB_TRANSACTION_SEQUENCE  p_src)
{
  assert(p_struct);
  p_struct->sequence=p_src;
}

void AB_Transaction_SetCharge(AB_TRANSACTION *p_struct, AB_TRANSACTION_CHARGE  p_src)
{
  assert(p_struct);
  p_struct->charge=p_src;
}

void AB_Transaction_SetRemoteAddrStreet(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteAddrStreet) {
    free(p_struct->remoteAddrStreet);
    p_struct->remoteAddrStreet=NULL;
  }
  if (p_src) {
    p_struct->remoteAddrStreet=strdup(p_src);
  }
  else {
    p_struct->remoteAddrStreet=NULL;
  }
}

void AB_Transaction_SetRemoteAddrZipcode(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteAddrZipcode) {
    free(p_struct->remoteAddrZipcode);
    p_struct->remoteAddrZipcode=NULL;
  }
  if (p_src) {
    p_struct->remoteAddrZipcode=strdup(p_src);
  }
  else {
    p_struct->remoteAddrZipcode=NULL;
  }
}

void AB_Transaction_SetRemoteAddrCity(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteAddrCity) {
    free(p_struct->remoteAddrCity);
    p_struct->remoteAddrCity=NULL;
  }
  if (p_src) {
    p_struct->remoteAddrCity=strdup(p_src);
  }
  else {
    p_struct->remoteAddrCity=NULL;
  }
}

void AB_Transaction_SetRemoteAddrPhone(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->remoteAddrPhone) {
    free(p_struct->remoteAddrPhone);
    p_struct->remoteAddrPhone=NULL;
  }
  if (p_src) {
    p_struct->remoteAddrPhone=strdup(p_src);
  }
  else {
    p_struct->remoteAddrPhone=NULL;
  }
}

void AB_Transaction_SetPeriod(AB_TRANSACTION *p_struct, AB_TRANSACTION_PERIOD  p_src)
{
  assert(p_struct);
  p_struct->period=p_src;
}

void AB_Transaction_SetCycle(AB_TRANSACTION *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->cycle=p_src;
}

void AB_Transaction_SetExecutionDay(AB_TRANSACTION *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->executionDay=p_src;
}

void AB_Transaction_SetFirstDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src)
{
  assert(p_struct);
  if (p_struct->firstDate) {
    GWEN_Date_free(p_struct->firstDate);
    p_struct->firstDate=NULL;
  }
  if (p_src) {
    p_struct->firstDate=GWEN_Date_dup(p_src);
  }
  else {
    p_struct->firstDate=NULL;
  }
}

void AB_Transaction_SetLastDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src)
{
  assert(p_struct);
  if (p_struct->lastDate) {
    GWEN_Date_free(p_struct->lastDate);
    p_struct->lastDate=NULL;
  }
  if (p_src) {
    p_struct->lastDate=GWEN_Date_dup(p_src);
  }
  else {
    p_struct->lastDate=NULL;
  }
}

void AB_Transaction_SetNextDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src)
{
  assert(p_struct);
  if (p_struct->nextDate) {
    GWEN_Date_free(p_struct->nextDate);
    p_struct->nextDate=NULL;
  }
  if (p_src) {
    p_struct->nextDate=GWEN_Date_dup(p_src);
  }
  else {
    p_struct->nextDate=NULL;
  }
}

void AB_Transaction_SetUnitId(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->unitId) {
    free(p_struct->unitId);
    p_struct->unitId=NULL;
  }
  if (p_src) {
    p_struct->unitId=strdup(p_src);
  }
  else {
    p_struct->unitId=NULL;
  }
}

void AB_Transaction_SetUnitIdNameSpace(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->unitIdNameSpace) {
    free(p_struct->unitIdNameSpace);
    p_struct->unitIdNameSpace=NULL;
  }
  if (p_src) {
    p_struct->unitIdNameSpace=strdup(p_src);
  }
  else {
    p_struct->unitIdNameSpace=NULL;
  }
}

void AB_Transaction_SetTickerSymbol(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->tickerSymbol) {
    free(p_struct->tickerSymbol);
    p_struct->tickerSymbol=NULL;
  }
  if (p_src) {
    p_struct->tickerSymbol=strdup(p_src);
  }
  else {
    p_struct->tickerSymbol=NULL;
  }
}

void AB_Transaction_SetUnits(AB_TRANSACTION *p_struct, const AB_VALUE *p_src)
{
  assert(p_struct);
  if (p_struct->units) {
    AB_Value_free(p_struct->units);
  }
  if (p_src) {
    p_struct->units=AB_Value_dup(p_src);
  }
  else {
    p_struct->units=AB_Value_new();
  }
}

void AB_Transaction_SetUnitPriceValue(AB_TRANSACTION *p_struct, const AB_VALUE *p_src)
{
  assert(p_struct);
  if (p_struct->unitPriceValue) {
    AB_Value_free(p_struct->unitPriceValue);
  }
  if (p_src) {
    p_struct->unitPriceValue=AB_Value_dup(p_src);
  }
  else {
    p_struct->unitPriceValue=AB_Value_new();
  }
}

void AB_Transaction_SetUnitPriceDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src)
{
  assert(p_struct);
  if (p_struct->unitPriceDate) {
    GWEN_Date_free(p_struct->unitPriceDate);
    p_struct->unitPriceDate=NULL;
  }
  if (p_src) {
    p_struct->unitPriceDate=GWEN_Date_dup(p_src);
  }
  else {
    p_struct->unitPriceDate=NULL;
  }
}

void AB_Transaction_SetCommissionValue(AB_TRANSACTION *p_struct, const AB_VALUE *p_src)
{
  assert(p_struct);
  if (p_struct->commissionValue) {
    AB_Value_free(p_struct->commissionValue);
  }
  if (p_src) {
    p_struct->commissionValue=AB_Value_dup(p_src);
  }
  else {
    p_struct->commissionValue=AB_Value_new();
  }
}

void AB_Transaction_SetMemo(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->memo) {
    free(p_struct->memo);
    p_struct->memo=NULL;
  }
  if (p_src) {
    p_struct->memo=strdup(p_src);
  }
  else {
    p_struct->memo=NULL;
  }
}

void AB_Transaction_SetHash(AB_TRANSACTION *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->hash) {
    free(p_struct->hash);
    p_struct->hash=NULL;
  }
  if (p_src) {
    p_struct->hash=strdup(p_src);
  }
  else {
    p_struct->hash=NULL;
  }
}

/* list1 functions */
AB_TRANSACTION_LIST *AB_Transaction_List_dup(const AB_TRANSACTION_LIST *p_src)
{
  AB_TRANSACTION_LIST *p_dest;
  AB_TRANSACTION *p_elem;

  assert(p_src);
  p_dest=AB_Transaction_List_new();
  p_elem=AB_Transaction_List_First(p_src);
  while (p_elem) {
    AB_TRANSACTION *p_cpy;

    p_cpy=AB_Transaction_dup(p_elem);
    AB_Transaction_List_Add(p_cpy, p_dest);
    p_elem=AB_Transaction_List_Next(p_elem);
  }

  return p_dest;
}

void AB_Transaction_ReadDb(AB_TRANSACTION *p_struct, GWEN_DB_NODE *p_db)
{
  assert(p_struct);
  /* member "type" */
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "type", 0, NULL);
    if (s)
      p_struct->type=AB_Transaction_Type_fromString(s);
    else
      p_struct->type=AB_Transaction_TypeUnknown;
  }

  /* member "subType" */
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "subType", 0, NULL);
    if (s)
      p_struct->subType=AB_Transaction_SubType_fromString(s);
    else
      p_struct->subType=AB_Transaction_SubTypeNone;
  }

  /* member "command" */
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "command", 0, NULL);
    if (s)
      p_struct->command=AB_Transaction_Command_fromString(s);
    else
      p_struct->command=AB_Transaction_CommandNone;
  }

  /* member "status" */
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "status", 0, NULL);
    if (s)
      p_struct->status=AB_Transaction_Status_fromString(s);
    else
      p_struct->status=AB_Transaction_StatusUnknown;
  }

  /* member "uniqueAccountId" */
  p_struct->uniqueAccountId=GWEN_DB_GetIntValue(p_db, "uniqueAccountId", 0, 0);

  /* member "uniqueId" */
  p_struct->uniqueId=GWEN_DB_GetIntValue(p_db, "uniqueId", 0, 0);

  /* member "refUniqueId" */
  p_struct->refUniqueId=GWEN_DB_GetIntValue(p_db, "refUniqueId", 0, 0);

  /* member "idForApplication" */
  p_struct->idForApplication=GWEN_DB_GetIntValue(p_db, "idForApplication", 0, 0);

  /* member "stringIdForApplication" */
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "stringIdForApplication", 0, 0);
    if (s)
      p_struct->stringIdForApplication=strdup(s);
  }
  if (p_struct->stringIdForApplication==NULL) {
    p_struct->stringIdForApplication=0;
  }

  /* member "sessionId" */
  p_struct->sessionId=GWEN_DB_GetIntValue(p_db, "sessionId", 0, 0);

  /* member "groupId" */
  p_struct->groupId=GWEN_DB_GetIntValue(p_db, "groupId", 0, 0);

  /* member "fiId" */
  if (p_struct->fiId) {
    free(p_struct->fiId);
    p_struct->fiId=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "fiId", 0, NULL);
    if (s)
      p_struct->fiId=strdup(s);
  }
  if (p_struct->fiId==NULL) {
    p_struct->fiId=NULL;
  }

  /* member "localIban" */
  if (p_struct->localIban) {
    free(p_struct->localIban);
    p_struct->localIban=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "localIban", 0, NULL);
    if (s)
      p_struct->localIban=strdup(s);
  }
  if (p_struct->localIban==NULL) {
    p_struct->localIban=NULL;
  }

  /* member "localBic" */
  if (p_struct->localBic) {
    free(p_struct->localBic);
    p_struct->localBic=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "localBic", 0, NULL);
    if (s)
      p_struct->localBic=strdup(s);
  }
  if (p_struct->localBic==NULL) {
    p_struct->localBic=NULL;
  }

  /* member "localCountry" */
  if (p_struct->localCountry) {
    free(p_struct->localCountry);
    p_struct->localCountry=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "localCountry", 0, NULL);
    if (s)
      p_struct->localCountry=strdup(s);
  }
  if (p_struct->localCountry==NULL) {
    p_struct->localCountry=NULL;
  }

  /* member "localBankCode" */
  if (p_struct->localBankCode) {
    free(p_struct->localBankCode);
    p_struct->localBankCode=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "localBankCode", 0, NULL);
    if (s)
      p_struct->localBankCode=strdup(s);
  }
  if (p_struct->localBankCode==NULL) {
    p_struct->localBankCode=NULL;
  }

  /* member "localBranchId" */
  if (p_struct->localBranchId) {
    free(p_struct->localBranchId);
    p_struct->localBranchId=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "localBranchId", 0, NULL);
    if (s)
      p_struct->localBranchId=strdup(s);
  }
  if (p_struct->localBranchId==NULL) {
    p_struct->localBranchId=NULL;
  }

  /* member "localAccountNumber" */
  if (p_struct->localAccountNumber) {
    free(p_struct->localAccountNumber);
    p_struct->localAccountNumber=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "localAccountNumber", 0, NULL);
    if (s)
      p_struct->localAccountNumber=strdup(s);
  }
  if (p_struct->localAccountNumber==NULL) {
    p_struct->localAccountNumber=NULL;
  }

  /* member "localSuffix" */
  if (p_struct->localSuffix) {
    free(p_struct->localSuffix);
    p_struct->localSuffix=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "localSuffix", 0, NULL);
    if (s)
      p_struct->localSuffix=strdup(s);
  }
  if (p_struct->localSuffix==NULL) {
    p_struct->localSuffix=NULL;
  }

  /* member "localName" */
  if (p_struct->localName) {
    free(p_struct->localName);
    p_struct->localName=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "localName", 0, NULL);
    if (s)
      p_struct->localName=strdup(s);
  }
  if (p_struct->localName==NULL) {
    p_struct->localName=NULL;
  }

  /* member "remoteCountry" */
  if (p_struct->remoteCountry) {
    free(p_struct->remoteCountry);
    p_struct->remoteCountry=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteCountry", 0, NULL);
    if (s)
      p_struct->remoteCountry=strdup(s);
  }
  if (p_struct->remoteCountry==NULL) {
    p_struct->remoteCountry=NULL;
  }

  /* member "remoteBankCode" */
  if (p_struct->remoteBankCode) {
    free(p_struct->remoteBankCode);
    p_struct->remoteBankCode=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteBankCode", 0, NULL);
    if (s)
      p_struct->remoteBankCode=strdup(s);
  }
  if (p_struct->remoteBankCode==NULL) {
    p_struct->remoteBankCode=NULL;
  }

  /* member "remoteBranchId" */
  if (p_struct->remoteBranchId) {
    free(p_struct->remoteBranchId);
    p_struct->remoteBranchId=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteBranchId", 0, NULL);
    if (s)
      p_struct->remoteBranchId=strdup(s);
  }
  if (p_struct->remoteBranchId==NULL) {
    p_struct->remoteBranchId=NULL;
  }

  /* member "remoteAccountNumber" */
  if (p_struct->remoteAccountNumber) {
    free(p_struct->remoteAccountNumber);
    p_struct->remoteAccountNumber=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteAccountNumber", 0, NULL);
    if (s)
      p_struct->remoteAccountNumber=strdup(s);
  }
  if (p_struct->remoteAccountNumber==NULL) {
    p_struct->remoteAccountNumber=NULL;
  }

  /* member "remoteSuffix" */
  if (p_struct->remoteSuffix) {
    free(p_struct->remoteSuffix);
    p_struct->remoteSuffix=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteSuffix", 0, NULL);
    if (s)
      p_struct->remoteSuffix=strdup(s);
  }
  if (p_struct->remoteSuffix==NULL) {
    p_struct->remoteSuffix=NULL;
  }

  /* member "remoteIban" */
  if (p_struct->remoteIban) {
    free(p_struct->remoteIban);
    p_struct->remoteIban=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteIban", 0, NULL);
    if (s)
      p_struct->remoteIban=strdup(s);
  }
  if (p_struct->remoteIban==NULL) {
    p_struct->remoteIban=NULL;
  }

  /* member "remoteBic" */
  if (p_struct->remoteBic) {
    free(p_struct->remoteBic);
    p_struct->remoteBic=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteBic", 0, NULL);
    if (s)
      p_struct->remoteBic=strdup(s);
  }
  if (p_struct->remoteBic==NULL) {
    p_struct->remoteBic=NULL;
  }

  /* member "remoteName" */
  if (p_struct->remoteName) {
    free(p_struct->remoteName);
    p_struct->remoteName=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteName", 0, NULL);
    if (s)
      p_struct->remoteName=strdup(s);
  }
  if (p_struct->remoteName==NULL) {
    p_struct->remoteName=NULL;
  }

  /* member "date" */
  if (p_struct->date) {
    GWEN_Date_free(p_struct->date);
    p_struct->date=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "date", 0, NULL);
    if (s && *s)
      p_struct->date=GWEN_Date_fromString(s);
  }
  if (p_struct->date==NULL) {
    p_struct->date=NULL;
  }

  /* member "valutaDate" */
  if (p_struct->valutaDate) {
    GWEN_Date_free(p_struct->valutaDate);
    p_struct->valutaDate=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "valutaDate", 0, NULL);
    if (s && *s)
      p_struct->valutaDate=GWEN_Date_fromString(s);
  }
  if (p_struct->valutaDate==NULL) {
    p_struct->valutaDate=NULL;
  }

  /* member "value" */
  if (p_struct->value) {
    AB_Value_free(p_struct->value);
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "value", 0, NULL);
    if (s)
      p_struct->value=AB_Value_fromString(s);
    else
      p_struct->value=NULL;
  }
  if (p_struct->value==NULL) {
    p_struct->value=AB_Value_new();
  }

  /* member "fees" */
  if (p_struct->fees) {
    AB_Value_free(p_struct->fees);
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "fees", 0, NULL);
    if (s)
      p_struct->fees=AB_Value_fromString(s);
    else
      p_struct->fees=NULL;
  }
  if (p_struct->fees==NULL) {
    p_struct->fees=AB_Value_new();
  }

  /* member "transactionCode" */
  p_struct->transactionCode=GWEN_DB_GetIntValue(p_db, "transactionCode", 0, 0);

  /* member "transactionText" */
  if (p_struct->transactionText) {
    free(p_struct->transactionText);
    p_struct->transactionText=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "transactionText", 0, NULL);
    if (s)
      p_struct->transactionText=strdup(s);
  }
  if (p_struct->transactionText==NULL) {
    p_struct->transactionText=NULL;
  }

  /* member "transactionKey" */
  if (p_struct->transactionKey) {
    free(p_struct->transactionKey);
    p_struct->transactionKey=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "transactionKey", 0, NULL);
    if (s)
      p_struct->transactionKey=strdup(s);
  }
  if (p_struct->transactionKey==NULL) {
    p_struct->transactionKey=NULL;
  }

  /* member "textKey" */
  p_struct->textKey=GWEN_DB_GetIntValue(p_db, "textKey", 0, 0);

  /* member "primanota" */
  if (p_struct->primanota) {
    free(p_struct->primanota);
    p_struct->primanota=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "primanota", 0, NULL);
    if (s)
      p_struct->primanota=strdup(s);
  }
  if (p_struct->primanota==NULL) {
    p_struct->primanota=NULL;
  }

  /* member "purpose" */
  if (p_struct->purpose) {
    free(p_struct->purpose);
    p_struct->purpose=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "purpose", 0, NULL);
    if (s)
      p_struct->purpose=strdup(s);
  }
  if (p_struct->purpose==NULL) {
    p_struct->purpose=NULL;
  }

  /* member "category" */
  if (p_struct->category) {
    free(p_struct->category);
    p_struct->category=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "category", 0, NULL);
    if (s)
      p_struct->category=strdup(s);
  }
  if (p_struct->category==NULL) {
    p_struct->category=NULL;
  }

  /* member "customerReference" */
  if (p_struct->customerReference) {
    free(p_struct->customerReference);
    p_struct->customerReference=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "customerReference", 0, NULL);
    if (s)
      p_struct->customerReference=strdup(s);
  }
  if (p_struct->customerReference==NULL) {
    p_struct->customerReference=NULL;
  }

  /* member "bankReference" */
  if (p_struct->bankReference) {
    free(p_struct->bankReference);
    p_struct->bankReference=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "bankReference", 0, NULL);
    if (s)
      p_struct->bankReference=strdup(s);
  }
  if (p_struct->bankReference==NULL) {
    p_struct->bankReference=NULL;
  }

  /* member "endToEndReference" */
  if (p_struct->endToEndReference) {
    free(p_struct->endToEndReference);
    p_struct->endToEndReference=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "endToEndReference", 0, NULL);
    if (s)
      p_struct->endToEndReference=strdup(s);
  }
  if (p_struct->endToEndReference==NULL) {
    p_struct->endToEndReference=NULL;
  }

  /* member "creditorSchemeId" */
  if (p_struct->creditorSchemeId) {
    free(p_struct->creditorSchemeId);
    p_struct->creditorSchemeId=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "creditorSchemeId", 0, NULL);
    if (s)
      p_struct->creditorSchemeId=strdup(s);
  }
  if (p_struct->creditorSchemeId==NULL) {
    p_struct->creditorSchemeId=NULL;
  }

  /* member "originatorId" */
  if (p_struct->originatorId) {
    free(p_struct->originatorId);
    p_struct->originatorId=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "originatorId", 0, NULL);
    if (s)
      p_struct->originatorId=strdup(s);
  }
  if (p_struct->originatorId==NULL) {
    p_struct->originatorId=NULL;
  }

  /* member "mandateId" */
  if (p_struct->mandateId) {
    free(p_struct->mandateId);
    p_struct->mandateId=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "mandateId", 0, NULL);
    if (s)
      p_struct->mandateId=strdup(s);
  }
  if (p_struct->mandateId==NULL) {
    p_struct->mandateId=NULL;
  }

  /* member "mandateDate" */
  if (p_struct->mandateDate) {
    GWEN_Date_free(p_struct->mandateDate);
    p_struct->mandateDate=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "mandateDate", 0, NULL);
    if (s && *s)
      p_struct->mandateDate=GWEN_Date_fromString(s);
  }
  if (p_struct->mandateDate==NULL) {
    p_struct->mandateDate=NULL;
  }

  /* member "mandateDebitorName" */
  if (p_struct->mandateDebitorName) {
    free(p_struct->mandateDebitorName);
    p_struct->mandateDebitorName=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "mandateDebitorName", 0, NULL);
    if (s)
      p_struct->mandateDebitorName=strdup(s);
  }
  if (p_struct->mandateDebitorName==NULL) {
    p_struct->mandateDebitorName=NULL;
  }

  /* member "originalCreditorSchemeId" */
  if (p_struct->originalCreditorSchemeId) {
    free(p_struct->originalCreditorSchemeId);
    p_struct->originalCreditorSchemeId=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "originalCreditorSchemeId", 0, NULL);
    if (s)
      p_struct->originalCreditorSchemeId=strdup(s);
  }
  if (p_struct->originalCreditorSchemeId==NULL) {
    p_struct->originalCreditorSchemeId=NULL;
  }

  /* member "originalMandateId" */
  if (p_struct->originalMandateId) {
    free(p_struct->originalMandateId);
    p_struct->originalMandateId=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "originalMandateId", 0, NULL);
    if (s)
      p_struct->originalMandateId=strdup(s);
  }
  if (p_struct->originalMandateId==NULL) {
    p_struct->originalMandateId=NULL;
  }

  /* member "originalCreditorName" */
  if (p_struct->originalCreditorName) {
    free(p_struct->originalCreditorName);
    p_struct->originalCreditorName=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "originalCreditorName", 0, NULL);
    if (s)
      p_struct->originalCreditorName=strdup(s);
  }
  if (p_struct->originalCreditorName==NULL) {
    p_struct->originalCreditorName=NULL;
  }

  /* member "sequence" */
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "sequence", 0, NULL);
    if (s)
      p_struct->sequence=AB_Transaction_Sequence_fromString(s);
    else
      p_struct->sequence=AB_Transaction_SequenceUnknown;
  }

  /* member "charge" */
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "charge", 0, NULL);
    if (s)
      p_struct->charge=AB_Transaction_Charge_fromString(s);
    else
      p_struct->charge=AB_Transaction_ChargeUnknown;
  }

  /* member "remoteAddrStreet" */
  if (p_struct->remoteAddrStreet) {
    free(p_struct->remoteAddrStreet);
    p_struct->remoteAddrStreet=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteAddrStreet", 0, NULL);
    if (s)
      p_struct->remoteAddrStreet=strdup(s);
  }
  if (p_struct->remoteAddrStreet==NULL) {
    p_struct->remoteAddrStreet=NULL;
  }

  /* member "remoteAddrZipcode" */
  if (p_struct->remoteAddrZipcode) {
    free(p_struct->remoteAddrZipcode);
    p_struct->remoteAddrZipcode=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteAddrZipcode", 0, NULL);
    if (s)
      p_struct->remoteAddrZipcode=strdup(s);
  }
  if (p_struct->remoteAddrZipcode==NULL) {
    p_struct->remoteAddrZipcode=NULL;
  }

  /* member "remoteAddrCity" */
  if (p_struct->remoteAddrCity) {
    free(p_struct->remoteAddrCity);
    p_struct->remoteAddrCity=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteAddrCity", 0, NULL);
    if (s)
      p_struct->remoteAddrCity=strdup(s);
  }
  if (p_struct->remoteAddrCity==NULL) {
    p_struct->remoteAddrCity=NULL;
  }

  /* member "remoteAddrPhone" */
  if (p_struct->remoteAddrPhone) {
    free(p_struct->remoteAddrPhone);
    p_struct->remoteAddrPhone=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "remoteAddrPhone", 0, NULL);
    if (s)
      p_struct->remoteAddrPhone=strdup(s);
  }
  if (p_struct->remoteAddrPhone==NULL) {
    p_struct->remoteAddrPhone=NULL;
  }

  /* member "period" */
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "period", 0, NULL);
    if (s)
      p_struct->period=AB_Transaction_Period_fromString(s);
    else
      p_struct->period=AB_Transaction_PeriodUnknown;
  }

  /* member "cycle" */
  p_struct->cycle=GWEN_DB_GetIntValue(p_db, "cycle", 0, 0);

  /* member "executionDay" */
  p_struct->executionDay=GWEN_DB_GetIntValue(p_db, "executionDay", 0, 0);

  /* member "firstDate" */
  if (p_struct->firstDate) {
    GWEN_Date_free(p_struct->firstDate);
    p_struct->firstDate=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "firstDate", 0, NULL);
    if (s && *s)
      p_struct->firstDate=GWEN_Date_fromString(s);
  }
  if (p_struct->firstDate==NULL) {
    p_struct->firstDate=NULL;
  }

  /* member "lastDate" */
  if (p_struct->lastDate) {
    GWEN_Date_free(p_struct->lastDate);
    p_struct->lastDate=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "lastDate", 0, NULL);
    if (s && *s)
      p_struct->lastDate=GWEN_Date_fromString(s);
  }
  if (p_struct->lastDate==NULL) {
    p_struct->lastDate=NULL;
  }

  /* member "nextDate" */
  if (p_struct->nextDate) {
    GWEN_Date_free(p_struct->nextDate);
    p_struct->nextDate=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "nextDate", 0, NULL);
    if (s && *s)
      p_struct->nextDate=GWEN_Date_fromString(s);
  }
  if (p_struct->nextDate==NULL) {
    p_struct->nextDate=NULL;
  }

  /* member "unitId" */
  if (p_struct->unitId) {
    free(p_struct->unitId);
    p_struct->unitId=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "unitId", 0, NULL);
    if (s)
      p_struct->unitId=strdup(s);
  }
  if (p_struct->unitId==NULL) {
    p_struct->unitId=NULL;
  }

  /* member "unitIdNameSpace" */
  if (p_struct->unitIdNameSpace) {
    free(p_struct->unitIdNameSpace);
    p_struct->unitIdNameSpace=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "unitIdNameSpace", 0, NULL);
    if (s)
      p_struct->unitIdNameSpace=strdup(s);
  }
  if (p_struct->unitIdNameSpace==NULL) {
    p_struct->unitIdNameSpace=NULL;
  }

  /* member "tickerSymbol" */
  if (p_struct->tickerSymbol) {
    free(p_struct->tickerSymbol);
    p_struct->tickerSymbol=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "tickerSymbol", 0, NULL);
    if (s)
      p_struct->tickerSymbol=strdup(s);
  }
  if (p_struct->tickerSymbol==NULL) {
    p_struct->tickerSymbol=NULL;
  }

  /* member "units" */
  if (p_struct->units) {
    AB_Value_free(p_struct->units);
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "units", 0, NULL);
    if (s)
      p_struct->units=AB_Value_fromString(s);
    else
      p_struct->units=NULL;
  }
  if (p_struct->units==NULL) {
    p_struct->units=AB_Value_new();
  }

  /* member "unitPriceValue" */
  if (p_struct->unitPriceValue) {
    AB_Value_free(p_struct->unitPriceValue);
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "unitPriceValue", 0, NULL);
    if (s)
      p_struct->unitPriceValue=AB_Value_fromString(s);
    else
      p_struct->unitPriceValue=NULL;
  }
  if (p_struct->unitPriceValue==NULL) {
    p_struct->unitPriceValue=AB_Value_new();
  }

  /* member "unitPriceDate" */
  if (p_struct->unitPriceDate) {
    GWEN_Date_free(p_struct->unitPriceDate);
    p_struct->unitPriceDate=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "unitPriceDate", 0, NULL);
    if (s && *s)
      p_struct->unitPriceDate=GWEN_Date_fromString(s);
  }
  if (p_struct->unitPriceDate==NULL) {
    p_struct->unitPriceDate=NULL;
  }

  /* member "commissionValue" */
  if (p_struct->commissionValue) {
    AB_Value_free(p_struct->commissionValue);
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "commissionValue", 0, NULL);
    if (s)
      p_struct->commissionValue=AB_Value_fromString(s);
    else
      p_struct->commissionValue=NULL;
  }
  if (p_struct->commissionValue==NULL) {
    p_struct->commissionValue=AB_Value_new();
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo);
    p_struct->memo=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "memo", 0, NULL);
    if (s)
      p_struct->memo=strdup(s);
  }
  if (p_struct->memo==NULL) {
    p_struct->memo=NULL;
  }

  /* member "hash" */
  if (p_struct->hash) {
    free(p_struct->hash);
    p_struct->hash=NULL;
  }
  /* member "hash" is volatile, just presetting */
  p_struct->hash=NULL;

}

int AB_Transaction_WriteDb(const AB_TRANSACTION *p_struct, GWEN_DB_NODE *p_db)
{
  int p_rv;

  assert(p_struct);
  /* member "type" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "type", AB_Transaction_Type_toString(p_struct->type));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "subType" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "subType",
                            AB_Transaction_SubType_toString(p_struct->subType));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "command" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "command",
                            AB_Transaction_Command_toString(p_struct->command));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "status" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "status",
                            AB_Transaction_Status_toString(p_struct->status));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "uniqueAccountId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "uniqueAccountId", p_struct->uniqueAccountId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "uniqueId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "uniqueId", p_struct->uniqueId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "refUniqueId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "refUniqueId", p_struct->refUniqueId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "idForApplication" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "idForApplication", p_struct->idForApplication);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "stringIdForApplication" */
  if (p_struct->stringIdForApplication)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "stringIdForApplication",
                              p_struct->stringIdForApplication);
  else {
    GWEN_DB_DeleteVar(p_db, "stringIdForApplication");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "sessionId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "sessionId", p_struct->sessionId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "groupId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "groupId", p_struct->groupId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "fiId" */
  if (p_struct->fiId)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "fiId", p_struct->fiId);
  else {
    GWEN_DB_DeleteVar(p_db, "fiId");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "localIban" */
  if (p_struct->localIban)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localIban", p_struct->localIban);
  else {
    GWEN_DB_DeleteVar(p_db, "localIban");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "localBic" */
  if (p_struct->localBic)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localBic", p_struct->localBic);
  else {
    GWEN_DB_DeleteVar(p_db, "localBic");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "localCountry" */
  if (p_struct->localCountry)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localCountry", p_struct->localCountry);
  else {
    GWEN_DB_DeleteVar(p_db, "localCountry");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "localBankCode" */
  if (p_struct->localBankCode)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localBankCode", p_struct->localBankCode);
  else {
    GWEN_DB_DeleteVar(p_db, "localBankCode");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "localBranchId" */
  if (p_struct->localBranchId)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localBranchId", p_struct->localBranchId);
  else {
    GWEN_DB_DeleteVar(p_db, "localBranchId");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "localAccountNumber" */
  if (p_struct->localAccountNumber)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localAccountNumber", p_struct->localAccountNumber);
  else {
    GWEN_DB_DeleteVar(p_db, "localAccountNumber");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "localSuffix" */
  if (p_struct->localSuffix)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localSuffix", p_struct->localSuffix);
  else {
    GWEN_DB_DeleteVar(p_db, "localSuffix");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "localName" */
  if (p_struct->localName)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localName", p_struct->localName);
  else {
    GWEN_DB_DeleteVar(p_db, "localName");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteCountry" */
  if (p_struct->remoteCountry)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteCountry", p_struct->remoteCountry);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteCountry");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteBankCode" */
  if (p_struct->remoteBankCode)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteBankCode", p_struct->remoteBankCode);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteBankCode");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteBranchId" */
  if (p_struct->remoteBranchId)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteBranchId", p_struct->remoteBranchId);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteBranchId");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteAccountNumber" */
  if (p_struct->remoteAccountNumber)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteAccountNumber", p_struct->remoteAccountNumber);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteAccountNumber");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteSuffix" */
  if (p_struct->remoteSuffix)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteSuffix", p_struct->remoteSuffix);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteSuffix");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteIban" */
  if (p_struct->remoteIban)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteIban", p_struct->remoteIban);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteIban");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteBic" */
  if (p_struct->remoteBic)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteBic", p_struct->remoteBic);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteBic");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteName" */
  if (p_struct->remoteName)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteName", p_struct->remoteName);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteName");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "date" */
  if (p_struct->date) {
    const char *s=GWEN_Date_GetString(p_struct->date);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "date", s);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "date");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "valutaDate" */
  if (p_struct->valutaDate) {
    const char *s=GWEN_Date_GetString(p_struct->valutaDate);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "valutaDate", s);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "valutaDate");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "value" */
  if (p_struct->value) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->value, tbuf);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "value", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "value");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "fees" */
  if (p_struct->fees) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->fees, tbuf);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "fees", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "fees");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "transactionCode" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "transactionCode", p_struct->transactionCode);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "transactionText" */
  if (p_struct->transactionText)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "transactionText", p_struct->transactionText);
  else {
    GWEN_DB_DeleteVar(p_db, "transactionText");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "transactionKey" */
  if (p_struct->transactionKey)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "transactionKey", p_struct->transactionKey);
  else {
    GWEN_DB_DeleteVar(p_db, "transactionKey");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "textKey" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "textKey", p_struct->textKey);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "primanota" */
  if (p_struct->primanota)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "primanota", p_struct->primanota);
  else {
    GWEN_DB_DeleteVar(p_db, "primanota");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "purpose" */
  if (p_struct->purpose)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "purpose", p_struct->purpose);
  else {
    GWEN_DB_DeleteVar(p_db, "purpose");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "category" */
  if (p_struct->category)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "category", p_struct->category);
  else {
    GWEN_DB_DeleteVar(p_db, "category");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "customerReference" */
  if (p_struct->customerReference)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "customerReference", p_struct->customerReference);
  else {
    GWEN_DB_DeleteVar(p_db, "customerReference");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "bankReference" */
  if (p_struct->bankReference)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "bankReference", p_struct->bankReference);
  else {
    GWEN_DB_DeleteVar(p_db, "bankReference");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "endToEndReference" */
  if (p_struct->endToEndReference)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "endToEndReference", p_struct->endToEndReference);
  else {
    GWEN_DB_DeleteVar(p_db, "endToEndReference");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "creditorSchemeId" */
  if (p_struct->creditorSchemeId)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "creditorSchemeId", p_struct->creditorSchemeId);
  else {
    GWEN_DB_DeleteVar(p_db, "creditorSchemeId");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "originatorId" */
  if (p_struct->originatorId)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "originatorId", p_struct->originatorId);
  else {
    GWEN_DB_DeleteVar(p_db, "originatorId");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "mandateId" */
  if (p_struct->mandateId)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "mandateId", p_struct->mandateId);
  else {
    GWEN_DB_DeleteVar(p_db, "mandateId");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "mandateDate" */
  if (p_struct->mandateDate) {
    const char *s=GWEN_Date_GetString(p_struct->mandateDate);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "mandateDate", s);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "mandateDate");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "mandateDebitorName" */
  if (p_struct->mandateDebitorName)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "mandateDebitorName", p_struct->mandateDebitorName);
  else {
    GWEN_DB_DeleteVar(p_db, "mandateDebitorName");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "originalCreditorSchemeId" */
  if (p_struct->originalCreditorSchemeId)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "originalCreditorSchemeId",
                              p_struct->originalCreditorSchemeId);
  else {
    GWEN_DB_DeleteVar(p_db, "originalCreditorSchemeId");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "originalMandateId" */
  if (p_struct->originalMandateId)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "originalMandateId", p_struct->originalMandateId);
  else {
    GWEN_DB_DeleteVar(p_db, "originalMandateId");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "originalCreditorName" */
  if (p_struct->originalCreditorName)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "originalCreditorName", p_struct->originalCreditorName);
  else {
    GWEN_DB_DeleteVar(p_db, "originalCreditorName");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "sequence" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "sequence",
                            AB_Transaction_Sequence_toString(p_struct->sequence));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "charge" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "charge",
                            AB_Transaction_Charge_toString(p_struct->charge));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteAddrStreet" */
  if (p_struct->remoteAddrStreet)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteAddrStreet", p_struct->remoteAddrStreet);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteAddrStreet");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteAddrZipcode" */
  if (p_struct->remoteAddrZipcode)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteAddrZipcode", p_struct->remoteAddrZipcode);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteAddrZipcode");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteAddrCity" */
  if (p_struct->remoteAddrCity)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteAddrCity", p_struct->remoteAddrCity);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteAddrCity");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "remoteAddrPhone" */
  if (p_struct->remoteAddrPhone)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteAddrPhone", p_struct->remoteAddrPhone);
  else {
    GWEN_DB_DeleteVar(p_db, "remoteAddrPhone");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "period" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "period",
                            AB_Transaction_Period_toString(p_struct->period));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "cycle" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "cycle", p_struct->cycle);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "executionDay" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "executionDay", p_struct->executionDay);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "firstDate" */
  if (p_struct->firstDate) {
    const char *s=GWEN_Date_GetString(p_struct->firstDate);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "firstDate", s);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "firstDate");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "lastDate" */
  if (p_struct->lastDate) {
    const char *s=GWEN_Date_GetString(p_struct->lastDate);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "lastDate", s);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "lastDate");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "nextDate" */
  if (p_struct->nextDate) {
    const char *s=GWEN_Date_GetString(p_struct->nextDate);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "nextDate", s);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "nextDate");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "unitId" */
  if (p_struct->unitId)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "unitId", p_struct->unitId);
  else {
    GWEN_DB_DeleteVar(p_db, "unitId");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "unitIdNameSpace" */
  if (p_struct->unitIdNameSpace)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "unitIdNameSpace", p_struct->unitIdNameSpace);
  else {
    GWEN_DB_DeleteVar(p_db, "unitIdNameSpace");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "tickerSymbol" */
  if (p_struct->tickerSymbol)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "tickerSymbol", p_struct->tickerSymbol);
  else {
    GWEN_DB_DeleteVar(p_db, "tickerSymbol");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "units" */
  if (p_struct->units) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->units, tbuf);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "units", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "units");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "unitPriceValue" */
  if (p_struct->unitPriceValue) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->unitPriceValue, tbuf);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "unitPriceValue", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "unitPriceValue");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "unitPriceDate" */
  if (p_struct->unitPriceDate) {
    const char *s=GWEN_Date_GetString(p_struct->unitPriceDate);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "unitPriceDate", s);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "unitPriceDate");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "commissionValue" */
  if (p_struct->commissionValue) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->commissionValue, tbuf);
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "commissionValue", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }
  else {
    GWEN_DB_DeleteVar(p_db, "commissionValue");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "memo" */
  if (p_struct->memo)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "memo", p_struct->memo);
  else {
    GWEN_DB_DeleteVar(p_db, "memo");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "hash" is volatile, not writing to db */

  return 0;
}

AB_TRANSACTION *AB_Transaction_fromDb(GWEN_DB_NODE *p_db)
{
  AB_TRANSACTION *p_struct;
  p_struct=AB_Transaction_new();
  AB_Transaction_ReadDb(p_struct, p_db);
  return p_struct;
}

int AB_Transaction_toDb(const AB_TRANSACTION *p_struct, GWEN_DB_NODE *p_db)
{
  return AB_Transaction_WriteDb(p_struct, p_db);
}

void AB_Transaction_ReadXml(AB_TRANSACTION *p_struct, GWEN_XMLNODE *p_db)
{
  assert(p_struct);
  /* member "type" */
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "type", NULL);
    if (s)
      p_struct->type=AB_Transaction_Type_fromString(s);
    else
      p_struct->type=AB_Transaction_TypeUnknown;
  }

  /* member "subType" */
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "subType", NULL);
    if (s)
      p_struct->subType=AB_Transaction_SubType_fromString(s);
    else
      p_struct->subType=AB_Transaction_SubTypeNone;
  }

  /* member "command" */
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "command", NULL);
    if (s)
      p_struct->command=AB_Transaction_Command_fromString(s);
    else
      p_struct->command=AB_Transaction_CommandNone;
  }

  /* member "status" */
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "status", NULL);
    if (s)
      p_struct->status=AB_Transaction_Status_fromString(s);
    else
      p_struct->status=AB_Transaction_StatusUnknown;
  }

  /* member "uniqueAccountId" */
  p_struct->uniqueAccountId=GWEN_XMLNode_GetIntValue(p_db, "uniqueAccountId", 0);

  /* member "uniqueId" */
  p_struct->uniqueId=GWEN_XMLNode_GetIntValue(p_db, "uniqueId", 0);

  /* member "refUniqueId" */
  p_struct->refUniqueId=GWEN_XMLNode_GetIntValue(p_db, "refUniqueId", 0);

  /* member "idForApplication" */
  p_struct->idForApplication=GWEN_XMLNode_GetIntValue(p_db, "idForApplication", 0);

  /* member "stringIdForApplication" */
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "stringIdForApplication", 0);
    if (s)
      p_struct->stringIdForApplication=strdup(s);
  }
  if (p_struct->stringIdForApplication==NULL) {  /* preset member "stringIdForApplication" if empty */
    p_struct->stringIdForApplication=0;
  }

  /* member "sessionId" */
  p_struct->sessionId=GWEN_XMLNode_GetIntValue(p_db, "sessionId", 0);

  /* member "groupId" */
  p_struct->groupId=GWEN_XMLNode_GetIntValue(p_db, "groupId", 0);

  /* member "fiId" */
  if (p_struct->fiId) {
    free(p_struct->fiId);
    p_struct->fiId=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "fiId", NULL);
    if (s)
      p_struct->fiId=strdup(s);
  }
  if (p_struct->fiId==NULL) {  /* preset member "fiId" if empty */
    p_struct->fiId=NULL;
  }

  /* member "localIban" */
  if (p_struct->localIban) {
    free(p_struct->localIban);
    p_struct->localIban=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "localIban", NULL);
    if (s)
      p_struct->localIban=strdup(s);
  }
  if (p_struct->localIban==NULL) {  /* preset member "localIban" if empty */
    p_struct->localIban=NULL;
  }

  /* member "localBic" */
  if (p_struct->localBic) {
    free(p_struct->localBic);
    p_struct->localBic=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "localBic", NULL);
    if (s)
      p_struct->localBic=strdup(s);
  }
  if (p_struct->localBic==NULL) {  /* preset member "localBic" if empty */
    p_struct->localBic=NULL;
  }

  /* member "localCountry" */
  if (p_struct->localCountry) {
    free(p_struct->localCountry);
    p_struct->localCountry=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "localCountry", NULL);
    if (s)
      p_struct->localCountry=strdup(s);
  }
  if (p_struct->localCountry==NULL) {  /* preset member "localCountry" if empty */
    p_struct->localCountry=NULL;
  }

  /* member "localBankCode" */
  if (p_struct->localBankCode) {
    free(p_struct->localBankCode);
    p_struct->localBankCode=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "localBankCode", NULL);
    if (s)
      p_struct->localBankCode=strdup(s);
  }
  if (p_struct->localBankCode==NULL) {  /* preset member "localBankCode" if empty */
    p_struct->localBankCode=NULL;
  }

  /* member "localBranchId" */
  if (p_struct->localBranchId) {
    free(p_struct->localBranchId);
    p_struct->localBranchId=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "localBranchId", NULL);
    if (s)
      p_struct->localBranchId=strdup(s);
  }
  if (p_struct->localBranchId==NULL) {  /* preset member "localBranchId" if empty */
    p_struct->localBranchId=NULL;
  }

  /* member "localAccountNumber" */
  if (p_struct->localAccountNumber) {
    free(p_struct->localAccountNumber);
    p_struct->localAccountNumber=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "localAccountNumber", NULL);
    if (s)
      p_struct->localAccountNumber=strdup(s);
  }
  if (p_struct->localAccountNumber==NULL) {  /* preset member "localAccountNumber" if empty */
    p_struct->localAccountNumber=NULL;
  }

  /* member "localSuffix" */
  if (p_struct->localSuffix) {
    free(p_struct->localSuffix);
    p_struct->localSuffix=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "localSuffix", NULL);
    if (s)
      p_struct->localSuffix=strdup(s);
  }
  if (p_struct->localSuffix==NULL) {  /* preset member "localSuffix" if empty */
    p_struct->localSuffix=NULL;
  }

  /* member "localName" */
  if (p_struct->localName) {
    free(p_struct->localName);
    p_struct->localName=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "localName", NULL);
    if (s)
      p_struct->localName=strdup(s);
  }
  if (p_struct->localName==NULL) {  /* preset member "localName" if empty */
    p_struct->localName=NULL;
  }

  /* member "remoteCountry" */
  if (p_struct->remoteCountry) {
    free(p_struct->remoteCountry);
    p_struct->remoteCountry=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteCountry", NULL);
    if (s)
      p_struct->remoteCountry=strdup(s);
  }
  if (p_struct->remoteCountry==NULL) {  /* preset member "remoteCountry" if empty */
    p_struct->remoteCountry=NULL;
  }

  /* member "remoteBankCode" */
  if (p_struct->remoteBankCode) {
    free(p_struct->remoteBankCode);
    p_struct->remoteBankCode=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteBankCode", NULL);
    if (s)
      p_struct->remoteBankCode=strdup(s);
  }
  if (p_struct->remoteBankCode==NULL) {  /* preset member "remoteBankCode" if empty */
    p_struct->remoteBankCode=NULL;
  }

  /* member "remoteBranchId" */
  if (p_struct->remoteBranchId) {
    free(p_struct->remoteBranchId);
    p_struct->remoteBranchId=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteBranchId", NULL);
    if (s)
      p_struct->remoteBranchId=strdup(s);
  }
  if (p_struct->remoteBranchId==NULL) {  /* preset member "remoteBranchId" if empty */
    p_struct->remoteBranchId=NULL;
  }

  /* member "remoteAccountNumber" */
  if (p_struct->remoteAccountNumber) {
    free(p_struct->remoteAccountNumber);
    p_struct->remoteAccountNumber=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteAccountNumber", NULL);
    if (s)
      p_struct->remoteAccountNumber=strdup(s);
  }
  if (p_struct->remoteAccountNumber==NULL) {  /* preset member "remoteAccountNumber" if empty */
    p_struct->remoteAccountNumber=NULL;
  }

  /* member "remoteSuffix" */
  if (p_struct->remoteSuffix) {
    free(p_struct->remoteSuffix);
    p_struct->remoteSuffix=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteSuffix", NULL);
    if (s)
      p_struct->remoteSuffix=strdup(s);
  }
  if (p_struct->remoteSuffix==NULL) {  /* preset member "remoteSuffix" if empty */
    p_struct->remoteSuffix=NULL;
  }

  /* member "remoteIban" */
  if (p_struct->remoteIban) {
    free(p_struct->remoteIban);
    p_struct->remoteIban=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteIban", NULL);
    if (s)
      p_struct->remoteIban=strdup(s);
  }
  if (p_struct->remoteIban==NULL) {  /* preset member "remoteIban" if empty */
    p_struct->remoteIban=NULL;
  }

  /* member "remoteBic" */
  if (p_struct->remoteBic) {
    free(p_struct->remoteBic);
    p_struct->remoteBic=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteBic", NULL);
    if (s)
      p_struct->remoteBic=strdup(s);
  }
  if (p_struct->remoteBic==NULL) {  /* preset member "remoteBic" if empty */
    p_struct->remoteBic=NULL;
  }

  /* member "remoteName" */
  if (p_struct->remoteName) {
    free(p_struct->remoteName);
    p_struct->remoteName=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteName", NULL);
    if (s)
      p_struct->remoteName=strdup(s);
  }
  if (p_struct->remoteName==NULL) {  /* preset member "remoteName" if empty */
    p_struct->remoteName=NULL;
  }

  /* member "date" */
  if (p_struct->date) {
    GWEN_Date_free(p_struct->date);
    p_struct->date=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "date", NULL);
    if (s && *s)
      p_struct->date=GWEN_Date_fromString(s);
  }
  if (p_struct->date==NULL) {  /* preset member "date" if empty */
    p_struct->date=NULL;
  }

  /* member "valutaDate" */
  if (p_struct->valutaDate) {
    GWEN_Date_free(p_struct->valutaDate);
    p_struct->valutaDate=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "valutaDate", NULL);
    if (s && *s)
      p_struct->valutaDate=GWEN_Date_fromString(s);
  }
  if (p_struct->valutaDate==NULL) {  /* preset member "valutaDate" if empty */
    p_struct->valutaDate=NULL;
  }

  /* member "value" */
  if (p_struct->value) {
    AB_Value_free(p_struct->value);
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "value", NULL);
    if (s)
      p_struct->value=AB_Value_fromString(s);
    else
      p_struct->value=NULL;
  }
  if (p_struct->value==NULL) {  /* preset member "value" if empty */
    p_struct->value=AB_Value_new();
  }

  /* member "fees" */
  if (p_struct->fees) {
    AB_Value_free(p_struct->fees);
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "fees", NULL);
    if (s)
      p_struct->fees=AB_Value_fromString(s);
    else
      p_struct->fees=NULL;
  }
  if (p_struct->fees==NULL) {  /* preset member "fees" if empty */
    p_struct->fees=AB_Value_new();
  }

  /* member "transactionCode" */
  p_struct->transactionCode=GWEN_XMLNode_GetIntValue(p_db, "transactionCode", 0);

  /* member "transactionText" */
  if (p_struct->transactionText) {
    free(p_struct->transactionText);
    p_struct->transactionText=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "transactionText", NULL);
    if (s)
      p_struct->transactionText=strdup(s);
  }
  if (p_struct->transactionText==NULL) {  /* preset member "transactionText" if empty */
    p_struct->transactionText=NULL;
  }

  /* member "transactionKey" */
  if (p_struct->transactionKey) {
    free(p_struct->transactionKey);
    p_struct->transactionKey=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "transactionKey", NULL);
    if (s)
      p_struct->transactionKey=strdup(s);
  }
  if (p_struct->transactionKey==NULL) {  /* preset member "transactionKey" if empty */
    p_struct->transactionKey=NULL;
  }

  /* member "textKey" */
  p_struct->textKey=GWEN_XMLNode_GetIntValue(p_db, "textKey", 0);

  /* member "primanota" */
  if (p_struct->primanota) {
    free(p_struct->primanota);
    p_struct->primanota=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "primanota", NULL);
    if (s)
      p_struct->primanota=strdup(s);
  }
  if (p_struct->primanota==NULL) {  /* preset member "primanota" if empty */
    p_struct->primanota=NULL;
  }

  /* member "purpose" */
  if (p_struct->purpose) {
    free(p_struct->purpose);
    p_struct->purpose=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "purpose", NULL);
    if (s)
      p_struct->purpose=strdup(s);
  }
  if (p_struct->purpose==NULL) {  /* preset member "purpose" if empty */
    p_struct->purpose=NULL;
  }

  /* member "category" */
  if (p_struct->category) {
    free(p_struct->category);
    p_struct->category=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "category", NULL);
    if (s)
      p_struct->category=strdup(s);
  }
  if (p_struct->category==NULL) {  /* preset member "category" if empty */
    p_struct->category=NULL;
  }

  /* member "customerReference" */
  if (p_struct->customerReference) {
    free(p_struct->customerReference);
    p_struct->customerReference=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "customerReference", NULL);
    if (s)
      p_struct->customerReference=strdup(s);
  }
  if (p_struct->customerReference==NULL) {  /* preset member "customerReference" if empty */
    p_struct->customerReference=NULL;
  }

  /* member "bankReference" */
  if (p_struct->bankReference) {
    free(p_struct->bankReference);
    p_struct->bankReference=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "bankReference", NULL);
    if (s)
      p_struct->bankReference=strdup(s);
  }
  if (p_struct->bankReference==NULL) {  /* preset member "bankReference" if empty */
    p_struct->bankReference=NULL;
  }

  /* member "endToEndReference" */
  if (p_struct->endToEndReference) {
    free(p_struct->endToEndReference);
    p_struct->endToEndReference=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "endToEndReference", NULL);
    if (s)
      p_struct->endToEndReference=strdup(s);
  }
  if (p_struct->endToEndReference==NULL) {  /* preset member "endToEndReference" if empty */
    p_struct->endToEndReference=NULL;
  }

  /* member "creditorSchemeId" */
  if (p_struct->creditorSchemeId) {
    free(p_struct->creditorSchemeId);
    p_struct->creditorSchemeId=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "creditorSchemeId", NULL);
    if (s)
      p_struct->creditorSchemeId=strdup(s);
  }
  if (p_struct->creditorSchemeId==NULL) {  /* preset member "creditorSchemeId" if empty */
    p_struct->creditorSchemeId=NULL;
  }

  /* member "originatorId" */
  if (p_struct->originatorId) {
    free(p_struct->originatorId);
    p_struct->originatorId=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "originatorId", NULL);
    if (s)
      p_struct->originatorId=strdup(s);
  }
  if (p_struct->originatorId==NULL) {  /* preset member "originatorId" if empty */
    p_struct->originatorId=NULL;
  }

  /* member "mandateId" */
  if (p_struct->mandateId) {
    free(p_struct->mandateId);
    p_struct->mandateId=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "mandateId", NULL);
    if (s)
      p_struct->mandateId=strdup(s);
  }
  if (p_struct->mandateId==NULL) {  /* preset member "mandateId" if empty */
    p_struct->mandateId=NULL;
  }

  /* member "mandateDate" */
  if (p_struct->mandateDate) {
    GWEN_Date_free(p_struct->mandateDate);
    p_struct->mandateDate=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "mandateDate", NULL);
    if (s && *s)
      p_struct->mandateDate=GWEN_Date_fromString(s);
  }
  if (p_struct->mandateDate==NULL) {  /* preset member "mandateDate" if empty */
    p_struct->mandateDate=NULL;
  }

  /* member "mandateDebitorName" */
  if (p_struct->mandateDebitorName) {
    free(p_struct->mandateDebitorName);
    p_struct->mandateDebitorName=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "mandateDebitorName", NULL);
    if (s)
      p_struct->mandateDebitorName=strdup(s);
  }
  if (p_struct->mandateDebitorName==NULL) {  /* preset member "mandateDebitorName" if empty */
    p_struct->mandateDebitorName=NULL;
  }

  /* member "originalCreditorSchemeId" */
  if (p_struct->originalCreditorSchemeId) {
    free(p_struct->originalCreditorSchemeId);
    p_struct->originalCreditorSchemeId=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "originalCreditorSchemeId", NULL);
    if (s)
      p_struct->originalCreditorSchemeId=strdup(s);
  }
  if (p_struct->originalCreditorSchemeId==NULL) {  /* preset member "originalCreditorSchemeId" if empty */
    p_struct->originalCreditorSchemeId=NULL;
  }

  /* member "originalMandateId" */
  if (p_struct->originalMandateId) {
    free(p_struct->originalMandateId);
    p_struct->originalMandateId=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "originalMandateId", NULL);
    if (s)
      p_struct->originalMandateId=strdup(s);
  }
  if (p_struct->originalMandateId==NULL) {  /* preset member "originalMandateId" if empty */
    p_struct->originalMandateId=NULL;
  }

  /* member "originalCreditorName" */
  if (p_struct->originalCreditorName) {
    free(p_struct->originalCreditorName);
    p_struct->originalCreditorName=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "originalCreditorName", NULL);
    if (s)
      p_struct->originalCreditorName=strdup(s);
  }
  if (p_struct->originalCreditorName==NULL) {  /* preset member "originalCreditorName" if empty */
    p_struct->originalCreditorName=NULL;
  }

  /* member "sequence" */
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "sequence", NULL);
    if (s)
      p_struct->sequence=AB_Transaction_Sequence_fromString(s);
    else
      p_struct->sequence=AB_Transaction_SequenceUnknown;
  }

  /* member "charge" */
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "charge", NULL);
    if (s)
      p_struct->charge=AB_Transaction_Charge_fromString(s);
    else
      p_struct->charge=AB_Transaction_ChargeUnknown;
  }

  /* member "remoteAddrStreet" */
  if (p_struct->remoteAddrStreet) {
    free(p_struct->remoteAddrStreet);
    p_struct->remoteAddrStreet=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteAddrStreet", NULL);
    if (s)
      p_struct->remoteAddrStreet=strdup(s);
  }
  if (p_struct->remoteAddrStreet==NULL) {  /* preset member "remoteAddrStreet" if empty */
    p_struct->remoteAddrStreet=NULL;
  }

  /* member "remoteAddrZipcode" */
  if (p_struct->remoteAddrZipcode) {
    free(p_struct->remoteAddrZipcode);
    p_struct->remoteAddrZipcode=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteAddrZipcode", NULL);
    if (s)
      p_struct->remoteAddrZipcode=strdup(s);
  }
  if (p_struct->remoteAddrZipcode==NULL) {  /* preset member "remoteAddrZipcode" if empty */
    p_struct->remoteAddrZipcode=NULL;
  }

  /* member "remoteAddrCity" */
  if (p_struct->remoteAddrCity) {
    free(p_struct->remoteAddrCity);
    p_struct->remoteAddrCity=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteAddrCity", NULL);
    if (s)
      p_struct->remoteAddrCity=strdup(s);
  }
  if (p_struct->remoteAddrCity==NULL) {  /* preset member "remoteAddrCity" if empty */
    p_struct->remoteAddrCity=NULL;
  }

  /* member "remoteAddrPhone" */
  if (p_struct->remoteAddrPhone) {
    free(p_struct->remoteAddrPhone);
    p_struct->remoteAddrPhone=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "remoteAddrPhone", NULL);
    if (s)
      p_struct->remoteAddrPhone=strdup(s);
  }
  if (p_struct->remoteAddrPhone==NULL) {  /* preset member "remoteAddrPhone" if empty */
    p_struct->remoteAddrPhone=NULL;
  }

  /* member "period" */
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "period", NULL);
    if (s)
      p_struct->period=AB_Transaction_Period_fromString(s);
    else
      p_struct->period=AB_Transaction_PeriodUnknown;
  }

  /* member "cycle" */
  p_struct->cycle=GWEN_XMLNode_GetIntValue(p_db, "cycle", 0);

  /* member "executionDay" */
  p_struct->executionDay=GWEN_XMLNode_GetIntValue(p_db, "executionDay", 0);

  /* member "firstDate" */
  if (p_struct->firstDate) {
    GWEN_Date_free(p_struct->firstDate);
    p_struct->firstDate=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "firstDate", NULL);
    if (s && *s)
      p_struct->firstDate=GWEN_Date_fromString(s);
  }
  if (p_struct->firstDate==NULL) {  /* preset member "firstDate" if empty */
    p_struct->firstDate=NULL;
  }

  /* member "lastDate" */
  if (p_struct->lastDate) {
    GWEN_Date_free(p_struct->lastDate);
    p_struct->lastDate=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "lastDate", NULL);
    if (s && *s)
      p_struct->lastDate=GWEN_Date_fromString(s);
  }
  if (p_struct->lastDate==NULL) {  /* preset member "lastDate" if empty */
    p_struct->lastDate=NULL;
  }

  /* member "nextDate" */
  if (p_struct->nextDate) {
    GWEN_Date_free(p_struct->nextDate);
    p_struct->nextDate=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "nextDate", NULL);
    if (s && *s)
      p_struct->nextDate=GWEN_Date_fromString(s);
  }
  if (p_struct->nextDate==NULL) {  /* preset member "nextDate" if empty */
    p_struct->nextDate=NULL;
  }

  /* member "unitId" */
  if (p_struct->unitId) {
    free(p_struct->unitId);
    p_struct->unitId=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "unitId", NULL);
    if (s)
      p_struct->unitId=strdup(s);
  }
  if (p_struct->unitId==NULL) {  /* preset member "unitId" if empty */
    p_struct->unitId=NULL;
  }

  /* member "unitIdNameSpace" */
  if (p_struct->unitIdNameSpace) {
    free(p_struct->unitIdNameSpace);
    p_struct->unitIdNameSpace=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "unitIdNameSpace", NULL);
    if (s)
      p_struct->unitIdNameSpace=strdup(s);
  }
  if (p_struct->unitIdNameSpace==NULL) {  /* preset member "unitIdNameSpace" if empty */
    p_struct->unitIdNameSpace=NULL;
  }

  /* member "tickerSymbol" */
  if (p_struct->tickerSymbol) {
    free(p_struct->tickerSymbol);
    p_struct->tickerSymbol=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "tickerSymbol", NULL);
    if (s)
      p_struct->tickerSymbol=strdup(s);
  }
  if (p_struct->tickerSymbol==NULL) {  /* preset member "tickerSymbol" if empty */
    p_struct->tickerSymbol=NULL;
  }

  /* member "units" */
  if (p_struct->units) {
    AB_Value_free(p_struct->units);
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "units", NULL);
    if (s)
      p_struct->units=AB_Value_fromString(s);
    else
      p_struct->units=NULL;
  }
  if (p_struct->units==NULL) {  /* preset member "units" if empty */
    p_struct->units=AB_Value_new();
  }

  /* member "unitPriceValue" */
  if (p_struct->unitPriceValue) {
    AB_Value_free(p_struct->unitPriceValue);
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "unitPriceValue", NULL);
    if (s)
      p_struct->unitPriceValue=AB_Value_fromString(s);
    else
      p_struct->unitPriceValue=NULL;
  }
  if (p_struct->unitPriceValue==NULL) {  /* preset member "unitPriceValue" if empty */
    p_struct->unitPriceValue=AB_Value_new();
  }

  /* member "unitPriceDate" */
  if (p_struct->unitPriceDate) {
    GWEN_Date_free(p_struct->unitPriceDate);
    p_struct->unitPriceDate=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "unitPriceDate", NULL);
    if (s && *s)
      p_struct->unitPriceDate=GWEN_Date_fromString(s);
  }
  if (p_struct->unitPriceDate==NULL) {  /* preset member "unitPriceDate" if empty */
    p_struct->unitPriceDate=NULL;
  }

  /* member "commissionValue" */
  if (p_struct->commissionValue) {
    AB_Value_free(p_struct->commissionValue);
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "commissionValue", NULL);
    if (s)
      p_struct->commissionValue=AB_Value_fromString(s);
    else
      p_struct->commissionValue=NULL;
  }
  if (p_struct->commissionValue==NULL) {  /* preset member "commissionValue" if empty */
    p_struct->commissionValue=AB_Value_new();
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo);
    p_struct->memo=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "memo", NULL);
    if (s)
      p_struct->memo=strdup(s);
  }
  if (p_struct->memo==NULL) {  /* preset member "memo" if empty */
    p_struct->memo=NULL;
  }

  /* member "hash" */
  if (p_struct->hash) {
    free(p_struct->hash);
    p_struct->hash=NULL;
  }
  /* member "hash" is volatile, just presetting */
  p_struct->hash=NULL;

}

void AB_Transaction_WriteXml(const AB_TRANSACTION *p_struct, GWEN_XMLNODE *p_db)
{
  assert(p_struct);
  /* member "type" */
  GWEN_XMLNode_SetCharValue(p_db, "type", AB_Transaction_Type_toString(p_struct->type));

  /* member "subType" */
  GWEN_XMLNode_SetCharValue(p_db, "subType", AB_Transaction_SubType_toString(p_struct->subType));

  /* member "command" */
  GWEN_XMLNode_SetCharValue(p_db, "command", AB_Transaction_Command_toString(p_struct->command));

  /* member "status" */
  GWEN_XMLNode_SetCharValue(p_db, "status", AB_Transaction_Status_toString(p_struct->status));

  /* member "uniqueAccountId" */
  GWEN_XMLNode_SetIntValue(p_db, "uniqueAccountId", p_struct->uniqueAccountId);

  /* member "uniqueId" */
  GWEN_XMLNode_SetIntValue(p_db, "uniqueId", p_struct->uniqueId);

  /* member "refUniqueId" */
  GWEN_XMLNode_SetIntValue(p_db, "refUniqueId", p_struct->refUniqueId);

  /* member "idForApplication" */
  GWEN_XMLNode_SetIntValue(p_db, "idForApplication", p_struct->idForApplication);

  /* member "stringIdForApplication" */
  GWEN_XMLNode_SetCharValue(p_db, "stringIdForApplication", p_struct->stringIdForApplication);

  /* member "sessionId" */
  GWEN_XMLNode_SetIntValue(p_db, "sessionId", p_struct->sessionId);

  /* member "groupId" */
  GWEN_XMLNode_SetIntValue(p_db, "groupId", p_struct->groupId);

  /* member "fiId" */
  GWEN_XMLNode_SetCharValue(p_db, "fiId", p_struct->fiId);

  /* member "localIban" */
  GWEN_XMLNode_SetCharValue(p_db, "localIban", p_struct->localIban);

  /* member "localBic" */
  GWEN_XMLNode_SetCharValue(p_db, "localBic", p_struct->localBic);

  /* member "localCountry" */
  GWEN_XMLNode_SetCharValue(p_db, "localCountry", p_struct->localCountry);

  /* member "localBankCode" */
  GWEN_XMLNode_SetCharValue(p_db, "localBankCode", p_struct->localBankCode);

  /* member "localBranchId" */
  GWEN_XMLNode_SetCharValue(p_db, "localBranchId", p_struct->localBranchId);

  /* member "localAccountNumber" */
  GWEN_XMLNode_SetCharValue(p_db, "localAccountNumber", p_struct->localAccountNumber);

  /* member "localSuffix" */
  GWEN_XMLNode_SetCharValue(p_db, "localSuffix", p_struct->localSuffix);

  /* member "localName" */
  GWEN_XMLNode_SetCharValue(p_db, "localName", p_struct->localName);

  /* member "remoteCountry" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteCountry", p_struct->remoteCountry);

  /* member "remoteBankCode" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteBankCode", p_struct->remoteBankCode);

  /* member "remoteBranchId" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteBranchId", p_struct->remoteBranchId);

  /* member "remoteAccountNumber" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteAccountNumber", p_struct->remoteAccountNumber);

  /* member "remoteSuffix" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteSuffix", p_struct->remoteSuffix);

  /* member "remoteIban" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteIban", p_struct->remoteIban);

  /* member "remoteBic" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteBic", p_struct->remoteBic);

  /* member "remoteName" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteName", p_struct->remoteName);

  /* member "date" */
  if (p_struct->date) {
    const char *s=GWEN_Date_GetString(p_struct->date);
    GWEN_XMLNode_SetCharValue(p_db, "date", s);
  }

  /* member "valutaDate" */
  if (p_struct->valutaDate) {
    const char *s=GWEN_Date_GetString(p_struct->valutaDate);
    GWEN_XMLNode_SetCharValue(p_db, "valutaDate", s);
  }

  /* member "value" */
  if (p_struct->value) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->value, tbuf);
    GWEN_XMLNode_SetCharValue(p_db, "value", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }

  /* member "fees" */
  if (p_struct->fees) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->fees, tbuf);
    GWEN_XMLNode_SetCharValue(p_db, "fees", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }

  /* member "transactionCode" */
  GWEN_XMLNode_SetIntValue(p_db, "transactionCode", p_struct->transactionCode);

  /* member "transactionText" */
  GWEN_XMLNode_SetCharValue(p_db, "transactionText", p_struct->transactionText);

  /* member "transactionKey" */
  GWEN_XMLNode_SetCharValue(p_db, "transactionKey", p_struct->transactionKey);

  /* member "textKey" */
  GWEN_XMLNode_SetIntValue(p_db, "textKey", p_struct->textKey);

  /* member "primanota" */
  GWEN_XMLNode_SetCharValue(p_db, "primanota", p_struct->primanota);

  /* member "purpose" */
  GWEN_XMLNode_SetCharValue(p_db, "purpose", p_struct->purpose);

  /* member "category" */
  GWEN_XMLNode_SetCharValue(p_db, "category", p_struct->category);

  /* member "customerReference" */
  GWEN_XMLNode_SetCharValue(p_db, "customerReference", p_struct->customerReference);

  /* member "bankReference" */
  GWEN_XMLNode_SetCharValue(p_db, "bankReference", p_struct->bankReference);

  /* member "endToEndReference" */
  GWEN_XMLNode_SetCharValue(p_db, "endToEndReference", p_struct->endToEndReference);

  /* member "creditorSchemeId" */
  GWEN_XMLNode_SetCharValue(p_db, "creditorSchemeId", p_struct->creditorSchemeId);

  /* member "originatorId" */
  GWEN_XMLNode_SetCharValue(p_db, "originatorId", p_struct->originatorId);

  /* member "mandateId" */
  GWEN_XMLNode_SetCharValue(p_db, "mandateId", p_struct->mandateId);

  /* member "mandateDate" */
  if (p_struct->mandateDate) {
    const char *s=GWEN_Date_GetString(p_struct->mandateDate);
    GWEN_XMLNode_SetCharValue(p_db, "mandateDate", s);
  }

  /* member "mandateDebitorName" */
  GWEN_XMLNode_SetCharValue(p_db, "mandateDebitorName", p_struct->mandateDebitorName);

  /* member "originalCreditorSchemeId" */
  GWEN_XMLNode_SetCharValue(p_db, "originalCreditorSchemeId", p_struct->originalCreditorSchemeId);

  /* member "originalMandateId" */
  GWEN_XMLNode_SetCharValue(p_db, "originalMandateId", p_struct->originalMandateId);

  /* member "originalCreditorName" */
  GWEN_XMLNode_SetCharValue(p_db, "originalCreditorName", p_struct->originalCreditorName);

  /* member "sequence" */
  GWEN_XMLNode_SetCharValue(p_db, "sequence", AB_Transaction_Sequence_toString(p_struct->sequence));

  /* member "charge" */
  GWEN_XMLNode_SetCharValue(p_db, "charge", AB_Transaction_Charge_toString(p_struct->charge));

  /* member "remoteAddrStreet" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteAddrStreet", p_struct->remoteAddrStreet);

  /* member "remoteAddrZipcode" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteAddrZipcode", p_struct->remoteAddrZipcode);

  /* member "remoteAddrCity" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteAddrCity", p_struct->remoteAddrCity);

  /* member "remoteAddrPhone" */
  GWEN_XMLNode_SetCharValue(p_db, "remoteAddrPhone", p_struct->remoteAddrPhone);

  /* member "period" */
  GWEN_XMLNode_SetCharValue(p_db, "period", AB_Transaction_Period_toString(p_struct->period));

  /* member "cycle" */
  GWEN_XMLNode_SetIntValue(p_db, "cycle", p_struct->cycle);

  /* member "executionDay" */
  GWEN_XMLNode_SetIntValue(p_db, "executionDay", p_struct->executionDay);

  /* member "firstDate" */
  if (p_struct->firstDate) {
    const char *s=GWEN_Date_GetString(p_struct->firstDate);
    GWEN_XMLNode_SetCharValue(p_db, "firstDate", s);
  }

  /* member "lastDate" */
  if (p_struct->lastDate) {
    const char *s=GWEN_Date_GetString(p_struct->lastDate);
    GWEN_XMLNode_SetCharValue(p_db, "lastDate", s);
  }

  /* member "nextDate" */
  if (p_struct->nextDate) {
    const char *s=GWEN_Date_GetString(p_struct->nextDate);
    GWEN_XMLNode_SetCharValue(p_db, "nextDate", s);
  }

  /* member "unitId" */
  GWEN_XMLNode_SetCharValue(p_db, "unitId", p_struct->unitId);

  /* member "unitIdNameSpace" */
  GWEN_XMLNode_SetCharValue(p_db, "unitIdNameSpace", p_struct->unitIdNameSpace);

  /* member "tickerSymbol" */
  GWEN_XMLNode_SetCharValue(p_db, "tickerSymbol", p_struct->tickerSymbol);

  /* member "units" */
  if (p_struct->units) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->units, tbuf);
    GWEN_XMLNode_SetCharValue(p_db, "units", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }

  /* member "unitPriceValue" */
  if (p_struct->unitPriceValue) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->unitPriceValue, tbuf);
    GWEN_XMLNode_SetCharValue(p_db, "unitPriceValue", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }

  /* member "unitPriceDate" */
  if (p_struct->unitPriceDate) {
    const char *s=GWEN_Date_GetString(p_struct->unitPriceDate);
    GWEN_XMLNode_SetCharValue(p_db, "unitPriceDate", s);
  }

  /* member "commissionValue" */
  if (p_struct->commissionValue) {
    GWEN_BUFFER *tbuf=GWEN_Buffer_new(0, 64, 0, 1);
    AB_Value_toString(p_struct->commissionValue, tbuf);
    GWEN_XMLNode_SetCharValue(p_db, "commissionValue", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }

  /* member "memo" */
  GWEN_XMLNode_SetCharValue(p_db, "memo", p_struct->memo);

  /* member "hash" is volatile, not writing to xml */

}

void AB_Transaction_toXml(const AB_TRANSACTION *p_struct, GWEN_XMLNODE *p_db)
{
  AB_Transaction_WriteXml(p_struct, p_db);
}

AB_TRANSACTION *AB_Transaction_fromXml(GWEN_XMLNODE *p_db)
{
  AB_TRANSACTION *p_struct;
  p_struct=AB_Transaction_new();
  AB_Transaction_ReadXml(p_struct, p_db);
  return p_struct;
}

AB_TRANSACTION *AB_Transaction_List_GetByUniqueId(const AB_TRANSACTION_LIST *p_list, uint32_t p_cmp)
{
  AB_TRANSACTION *p_struct;

  assert(p_list);
  p_struct = AB_Transaction_List_First(p_list);
  while (p_struct) {
    int p_rv;

    if (p_struct->uniqueId==p_cmp)
      p_rv=0;
    else if (p_cmp<p_struct->uniqueId)
      p_rv=-1;
    else
      p_rv=1;
    if (p_rv == 0)
      return p_struct;
    p_struct = AB_Transaction_List_Next(p_struct);
  }
  return NULL;
}

AB_TRANSACTION *AB_Transaction_List_GetByIdForApplication(const AB_TRANSACTION_LIST *p_list, uint32_t p_cmp)
{
  AB_TRANSACTION *p_struct;

  assert(p_list);
  p_struct = AB_Transaction_List_First(p_list);
  while (p_struct) {
    int p_rv;

    if (p_struct->idForApplication==p_cmp)
      p_rv=0;
    else if (p_cmp<p_struct->idForApplication)
      p_rv=-1;
    else
      p_rv=1;
    if (p_rv == 0)
      return p_struct;
    p_struct = AB_Transaction_List_Next(p_struct);
  }
  return NULL;
}

AB_TRANSACTION *AB_Transaction_List_GetByStringIdForApplication(const AB_TRANSACTION_LIST *p_list,  const char *p_cmp)
{
  AB_TRANSACTION *p_struct;

  assert(p_list);
  p_struct = AB_Transaction_List_First(p_list);
  while (p_struct) {
    int p_rv;

    if (p_struct->stringIdForApplication && p_cmp)
      p_rv=strcasecmp(p_cmp, p_struct->stringIdForApplication);
    else if (p_cmp)
      p_rv=1;
    else if (p_struct->stringIdForApplication)
      p_rv=-1;
    else
      p_rv=0;
    if (p_rv == 0)
      return p_struct;
    p_struct = AB_Transaction_List_Next(p_struct);
  }
  return NULL;
}

void AB_Transaction_toHashString(const AB_TRANSACTION *p_struct, GWEN_BUFFER *p_buffer)
{
  assert(p_struct);
  /* member "type" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->type);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "subType" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->subType);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "command" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->command);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "status" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->status);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "uniqueAccountId" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->uniqueAccountId);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "uniqueId" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->uniqueId);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "refUniqueId" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->refUniqueId);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "idForApplication" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->idForApplication);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "stringIdForApplication" */
  if (p_struct->stringIdForApplication)
    GWEN_Buffer_AppendString(p_buffer, p_struct->stringIdForApplication);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "sessionId" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->sessionId);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "groupId" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->groupId);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "fiId" */
  if (p_struct->fiId)
    GWEN_Buffer_AppendString(p_buffer, p_struct->fiId);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "localIban" */
  if (p_struct->localIban)
    GWEN_Buffer_AppendString(p_buffer, p_struct->localIban);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "localBic" */
  if (p_struct->localBic)
    GWEN_Buffer_AppendString(p_buffer, p_struct->localBic);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "localCountry" */
  if (p_struct->localCountry)
    GWEN_Buffer_AppendString(p_buffer, p_struct->localCountry);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "localBankCode" */
  if (p_struct->localBankCode)
    GWEN_Buffer_AppendString(p_buffer, p_struct->localBankCode);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "localBranchId" */
  if (p_struct->localBranchId)
    GWEN_Buffer_AppendString(p_buffer, p_struct->localBranchId);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "localAccountNumber" */
  if (p_struct->localAccountNumber)
    GWEN_Buffer_AppendString(p_buffer, p_struct->localAccountNumber);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "localSuffix" */
  if (p_struct->localSuffix)
    GWEN_Buffer_AppendString(p_buffer, p_struct->localSuffix);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "localName" */
  if (p_struct->localName)
    GWEN_Buffer_AppendString(p_buffer, p_struct->localName);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteCountry" */
  if (p_struct->remoteCountry)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteCountry);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteBankCode" */
  if (p_struct->remoteBankCode)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteBankCode);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteBranchId" */
  if (p_struct->remoteBranchId)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteBranchId);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteAccountNumber" */
  if (p_struct->remoteAccountNumber)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteAccountNumber);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteSuffix" */
  if (p_struct->remoteSuffix)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteSuffix);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteIban" */
  if (p_struct->remoteIban)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteIban);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteBic" */
  if (p_struct->remoteBic)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteBic);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteName" */
  if (p_struct->remoteName)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteName);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "date" */
  if (p_struct->date)
    GWEN_Buffer_AppendString(p_buffer, GWEN_Date_GetString(p_struct->date));
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "valutaDate" */
  if (p_struct->valutaDate)
    GWEN_Buffer_AppendString(p_buffer, GWEN_Date_GetString(p_struct->valutaDate));
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "value" */
  if (p_struct->value) {
    double d=AB_Value_GetValueAsDouble(p_struct->value);
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%.4f", d);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "fees" */
  if (p_struct->fees) {
    double d=AB_Value_GetValueAsDouble(p_struct->fees);
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%.4f", d);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "transactionCode" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->transactionCode);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "transactionText" */
  if (p_struct->transactionText)
    GWEN_Buffer_AppendString(p_buffer, p_struct->transactionText);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "transactionKey" */
  if (p_struct->transactionKey)
    GWEN_Buffer_AppendString(p_buffer, p_struct->transactionKey);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "textKey" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->textKey);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "primanota" */
  if (p_struct->primanota)
    GWEN_Buffer_AppendString(p_buffer, p_struct->primanota);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "purpose" */
  if (p_struct->purpose)
    GWEN_Buffer_AppendString(p_buffer, p_struct->purpose);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "category" */
  if (p_struct->category)
    GWEN_Buffer_AppendString(p_buffer, p_struct->category);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "customerReference" */
  if (p_struct->customerReference)
    GWEN_Buffer_AppendString(p_buffer, p_struct->customerReference);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "bankReference" */
  if (p_struct->bankReference)
    GWEN_Buffer_AppendString(p_buffer, p_struct->bankReference);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "endToEndReference" */
  if (p_struct->endToEndReference)
    GWEN_Buffer_AppendString(p_buffer, p_struct->endToEndReference);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "creditorSchemeId" */
  if (p_struct->creditorSchemeId)
    GWEN_Buffer_AppendString(p_buffer, p_struct->creditorSchemeId);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "originatorId" */
  if (p_struct->originatorId)
    GWEN_Buffer_AppendString(p_buffer, p_struct->originatorId);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "mandateId" */
  if (p_struct->mandateId)
    GWEN_Buffer_AppendString(p_buffer, p_struct->mandateId);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "mandateDate" */
  if (p_struct->mandateDate)
    GWEN_Buffer_AppendString(p_buffer, GWEN_Date_GetString(p_struct->mandateDate));
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "mandateDebitorName" */
  if (p_struct->mandateDebitorName)
    GWEN_Buffer_AppendString(p_buffer, p_struct->mandateDebitorName);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "originalCreditorSchemeId" */
  if (p_struct->originalCreditorSchemeId)
    GWEN_Buffer_AppendString(p_buffer, p_struct->originalCreditorSchemeId);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "originalMandateId" */
  if (p_struct->originalMandateId)
    GWEN_Buffer_AppendString(p_buffer, p_struct->originalMandateId);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "originalCreditorName" */
  if (p_struct->originalCreditorName)
    GWEN_Buffer_AppendString(p_buffer, p_struct->originalCreditorName);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "sequence" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->sequence);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "charge" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->charge);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteAddrStreet" */
  if (p_struct->remoteAddrStreet)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteAddrStreet);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteAddrZipcode" */
  if (p_struct->remoteAddrZipcode)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteAddrZipcode);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteAddrCity" */
  if (p_struct->remoteAddrCity)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteAddrCity);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "remoteAddrPhone" */
  if (p_struct->remoteAddrPhone)
    GWEN_Buffer_AppendString(p_buffer, p_struct->remoteAddrPhone);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "period" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->period);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "cycle" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->cycle);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "executionDay" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->executionDay);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "firstDate" */
  if (p_struct->firstDate)
    GWEN_Buffer_AppendString(p_buffer, GWEN_Date_GetString(p_struct->firstDate));
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "lastDate" */
  if (p_struct->lastDate)
    GWEN_Buffer_AppendString(p_buffer, GWEN_Date_GetString(p_struct->lastDate));
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "nextDate" */
  if (p_struct->nextDate)
    GWEN_Buffer_AppendString(p_buffer, GWEN_Date_GetString(p_struct->nextDate));
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "unitId" */
  if (p_struct->unitId)
    GWEN_Buffer_AppendString(p_buffer, p_struct->unitId);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "unitIdNameSpace" */
  if (p_struct->unitIdNameSpace)
    GWEN_Buffer_AppendString(p_buffer, p_struct->unitIdNameSpace);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "tickerSymbol" */
  if (p_struct->tickerSymbol)
    GWEN_Buffer_AppendString(p_buffer, p_struct->tickerSymbol);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "units" */
  if (p_struct->units) {
    double d=AB_Value_GetValueAsDouble(p_struct->units);
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%.4f", d);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "unitPriceValue" */
  if (p_struct->unitPriceValue) {
    double d=AB_Value_GetValueAsDouble(p_struct->unitPriceValue);
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%.4f", d);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "unitPriceDate" */
  if (p_struct->unitPriceDate)
    GWEN_Buffer_AppendString(p_buffer, GWEN_Date_GetString(p_struct->unitPriceDate));
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "commissionValue" */
  if (p_struct->commissionValue) {
    double d=AB_Value_GetValueAsDouble(p_struct->commissionValue);
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%.4f", d);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "memo" */
  if (p_struct->memo)
    GWEN_Buffer_AppendString(p_buffer, p_struct->memo);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "hash" does not have the with_hash flag, ignoring */
}

int AB_Transaction_GenerateHash(AB_TRANSACTION *st)
{
  GWEN_BUFFER *buf;
  int rv;
  GWEN_MDIGEST *md;
  assert(st);
  buf=GWEN_Buffer_new(0, 256, 0, 1);
  AB_Transaction_toHashString(st, buf);
  md=GWEN_MDigest_Rmd160_new();
  rv=GWEN_MDigest_Begin(md);
  if (rv<0) {
    DBG_INFO(AQBANKING_LOGDOMAIN, "here (%d)", rv);
    GWEN_MDigest_free(md);
    GWEN_Buffer_free(buf);
    return rv;
  }
  rv=GWEN_MDigest_Update(md, (const uint8_t *)GWEN_Buffer_GetStart(buf), GWEN_Buffer_GetUsedBytes(buf));
  if (rv<0) {
    DBG_INFO(AQBANKING_LOGDOMAIN, "here (%d)", rv);
    GWEN_MDigest_free(md);
    GWEN_Buffer_free(buf);
    return rv;
  }
  rv=GWEN_MDigest_End(md);
  if (rv<0) {
    DBG_INFO(AQBANKING_LOGDOMAIN, "here (%d)", rv);
    GWEN_MDigest_free(md);
    GWEN_Buffer_free(buf);
    return rv;
  }
  GWEN_Buffer_Reset(buf);
  rv=GWEN_Text_ToHexBuffer((const char *)GWEN_MDigest_GetDigestPtr(md), GWEN_MDigest_GetDigestSize(md), buf, 0, 0, 0);
  if (rv<0) {
    DBG_INFO(AQBANKING_LOGDOMAIN, "here (%d)", rv);
    GWEN_MDigest_free(md);
    GWEN_Buffer_free(buf);
    return rv;
  }
  GWEN_MDigest_free(md);
  AB_Transaction_SetHash(st, GWEN_Buffer_GetStart(buf));
  GWEN_Buffer_free(buf);
  return 0;
}
int AB_Transaction_MatchTypeAndCommand(const AB_TRANSACTION *t, int ty, int cmd)
{
  int match=1;
  if (match) {
    if ((ty > AB_Transaction_TypeNone) && (t->type!=ty)) {
      return 0;
    }
  }
  if (match) {
    if ((cmd > AB_Transaction_CommandNone) && (t->command!=cmd)) {
      return 0;
    }
  }
  if (match) {
    if ((cmd < AB_Transaction_CommandNone) && (t->command <= AB_Transaction_CommandNone)) {
      return 0;
    }
  } /* matches */ return 1;
}
AB_TRANSACTION *AB_Transaction_List_FindFirstByType(const AB_TRANSACTION_LIST *tl, int ty, int cmd)
{
  if (tl) {
    AB_TRANSACTION *t;
    t=AB_Transaction_List_First(tl);
    while (t) {
      if (AB_Transaction_MatchTypeAndCommand(t, ty, cmd))
        return t;
      t=AB_Transaction_List_Next(t);
    }
  }
  return NULL;
}
AB_TRANSACTION *AB_Transaction_List_FindNextByType(const AB_TRANSACTION *tPrev, int ty, int cmd)
{
  if (tPrev) {
    AB_TRANSACTION *t;
    t=AB_Transaction_List_Next(tPrev);
    while (t) {
      if (AB_Transaction_MatchTypeAndCommand(t, ty, cmd))
        return t;
      t=AB_Transaction_List_Next(t);
    }
  }
  return NULL;
}
int AB_Transaction_List_RemoveByType(AB_TRANSACTION_LIST *tl, int ty, int cmd)
{
  int cntRemoved=0;
  if (tl) {
    AB_TRANSACTION *t;
    t=AB_Transaction_List_First(tl);
    while (t) {
      AB_TRANSACTION *tNext;
      tNext=AB_Transaction_List_Next(t);
      if (AB_Transaction_MatchTypeAndCommand(t, ty, cmd)) {
        AB_Transaction_List_Del(t);
        AB_Transaction_free(t);
        cntRemoved++;
      }
      t=tNext;
    }
  }
  return cntRemoved;
}
int AB_Transaction_List_KeepByType(AB_TRANSACTION_LIST *tl, int ty, int cmd)
{
  int cntRemoved=0;
  if (tl) {
    AB_TRANSACTION *t;
    t=AB_Transaction_List_First(tl);
    while (t) {
      AB_TRANSACTION *tNext;
      tNext=AB_Transaction_List_Next(t);
      if (! AB_Transaction_MatchTypeAndCommand(t, ty, cmd)) {
        AB_Transaction_List_Del(t);
        AB_Transaction_free(t);
        cntRemoved++;
      }
      t=tNext;
    }
  }
  return cntRemoved;
}
int AB_Transaction_List_CountByType(const AB_TRANSACTION_LIST *tl, int ty, int cmd)
{
  int count=0;
  if (tl) {
    AB_TRANSACTION *t;
    t=AB_Transaction_List_First(tl);
    while (t) {
      if (AB_Transaction_MatchTypeAndCommand(t, ty, cmd))
        count++;
      t=AB_Transaction_List_Next(t);
    }
  }
  return count;
}
const AB_TRANSACTION *AB_Transaction_List_ForEachByType(const AB_TRANSACTION_LIST *tl,
                                                        AB_TRANSACTION_LIST_FOREACHBYTYPE_CB fn, void *user_data, int ty, int cmd)
{
  if (tl) {
    const AB_TRANSACTION *t;
    t=AB_Transaction_List_First(tl);
    while (t) {
      if (AB_Transaction_MatchTypeAndCommand(t, ty, cmd)) {
        const AB_TRANSACTION *tReturned;
        tReturned=fn(t, user_data);
        if (tReturned)
          return tReturned;
      }
      t=AB_Transaction_List_Next(t);
    }
  }
  return NULL;
}
AB_TRANSACTION *AB_Transaction_List_FindName(const AB_TRANSACTION_LIST *tl, int ty, const char *ns, const char *n)
{
  if (tl) {
    AB_TRANSACTION *t;
    t=AB_Transaction_List_First(tl);
    while (t) {
      if ((ty==AB_Transaction_TypeNone || AB_Transaction_GetType(t)==ty) && (ns==NULL ||
                                                                             0==GWEN_Text_Compare(ns, t->unitIdNameSpace, 1)) && (n==NULL || 0==GWEN_Text_Compare(n, t->unitId, 1)))
        return t;
      t=AB_Transaction_List_Next(t);
    }
  }
  return NULL;
}
int AB_Transaction_List_WriteDb(const AB_TRANSACTION_LIST *tl, GWEN_DB_NODE *db)
{
  if (tl) {
    const AB_TRANSACTION *t;
    t=AB_Transaction_List_First(tl);
    while (t) {
      GWEN_DB_NODE *dbT;
      int rv;
      dbT=GWEN_DB_Group_new("transaction");
      rv=AB_Transaction_WriteDb(t, dbT);
      if (rv < 0) {
        DBG_ERROR(AQBANKING_LOGDOMAIN, "here (%d)", rv);
        GWEN_DB_Group_free(dbT);
        return rv;
      }
      else {
        GWEN_DB_AddGroup(db, dbT);
      }
      t=AB_Transaction_List_Next(t);
    }
  }
  return 0;
}
int AB_Transaction_List_ReadDb(AB_TRANSACTION_LIST *tl, GWEN_DB_NODE *db)
{
  if (tl && db) {
    GWEN_DB_NODE *dbT;
    dbT=GWEN_DB_GetFirstGroup(db);
    while (dbT) {
      AB_TRANSACTION *t;
      t=AB_Transaction_fromDb(dbT);
      if (t) {
        AB_Transaction_List_Add(t, tl);
      }
      dbT=GWEN_DB_GetNextGroup(dbT);
    }
  }
  else {
    DBG_ERROR(AQBANKING_LOGDOMAIN, "Either list or db missing");
    return GWEN_ERROR_INVALID;
  }
  return 0;
}
void AB_Transaction_AddPurposeLine(AB_TRANSACTION *t, const char *s)
{
  assert(t);
  if (s && *s) {
    if (t->purpose && *(t->purpose)) {
      GWEN_BUFFER *tbuf;
      tbuf=GWEN_Buffer_new(0, 256, 0, 1);
      GWEN_Buffer_AppendString(tbuf, t->purpose);
      GWEN_Buffer_AppendString(tbuf, "\n");
      GWEN_Buffer_AppendString(tbuf, s);
      AB_Transaction_SetPurpose(t, GWEN_Buffer_GetStart(tbuf));
      GWEN_Buffer_free(tbuf);
    }
    else
      AB_Transaction_SetPurpose(t, s);
  }
  else {
    DBG_ERROR(AQBANKING_LOGDOMAIN, "Not adding empty string");
  }
}
void AB_Transaction_SetPurposeFromStringList(AB_TRANSACTION *t, const GWEN_STRINGLIST *sl)
{
  assert(t);
  if (sl) {
    GWEN_STRINGLISTENTRY *se;
    GWEN_BUFFER *tbuf;
    tbuf=GWEN_Buffer_new(0, 256, 0, 1);
    se=GWEN_StringList_FirstEntry(sl);
    while (se) {
      const char *s;
      s=GWEN_StringListEntry_Data(se);
      if (s && *s) {
        if (GWEN_Buffer_GetUsedBytes(tbuf))
          GWEN_Buffer_AppendString(tbuf, "\n");
        GWEN_Buffer_AppendString(tbuf, s);
      }
      se=GWEN_StringListEntry_Next(se);
    }
    AB_Transaction_SetPurpose(t, GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }
  else {
    AB_Transaction_SetPurpose(t, NULL);
  }
}
GWEN_STRINGLIST *AB_Transaction_GetPurposeAsStringList(const AB_TRANSACTION *t)
{
  const char *s;
  assert(t);
  s=AB_Transaction_GetPurpose(t);
  if (s && *s) {
    GWEN_STRINGLIST *stringList;
    stringList=GWEN_StringList_fromString(s, "\n", 0);
    return stringList;
  }
  return NULL;
}
void AB_Transaction_AddCategory(AB_TRANSACTION *t, const char *s)
{
  assert(t);
  if (s && *s) {
    if (t->category && *(t->category)) {
      GWEN_BUFFER *tbuf;
      tbuf=GWEN_Buffer_new(0, 256, 0, 1);
      GWEN_Buffer_AppendString(tbuf, t->category);
      GWEN_Buffer_AppendString(tbuf, "\n");
      GWEN_Buffer_AppendString(tbuf, s);
      AB_Transaction_SetPurpose(t, GWEN_Buffer_GetStart(tbuf));
      GWEN_Buffer_free(tbuf);
    }
    else
      AB_Transaction_SetCategory(t, s);
  }
  else {
    DBG_ERROR(AQBANKING_LOGDOMAIN, "Not adding empty string");
  }
}
void AB_Transaction_SetCategoryFromStringList(AB_TRANSACTION *t, const GWEN_STRINGLIST *sl)
{
  assert(t);
  if (sl) {
    GWEN_STRINGLISTENTRY *se;
    GWEN_BUFFER *tbuf;
    tbuf=GWEN_Buffer_new(0, 256, 0, 1);
    se=GWEN_StringList_FirstEntry(sl);
    while (se) {
      const char *s;
      s=GWEN_StringListEntry_Data(se);
      if (s && *s) {
        if (GWEN_Buffer_GetUsedBytes(tbuf))
          GWEN_Buffer_AppendString(tbuf, "\n");
        GWEN_Buffer_AppendString(tbuf, s);
      }
      se=GWEN_StringListEntry_Next(se);
    }
    AB_Transaction_SetCategory(t, GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }
  else {
    AB_Transaction_SetCategory(t, NULL);
  }
}
static AB_TRANSACTION *AB_Transaction_List2__freeAll_cb(AB_TRANSACTION *t, void *user_data)
{
  AB_Transaction_free(t);
  return NULL;
}
int AB_Transaction_List2_freeAll(AB_TRANSACTION_LIST2 *tl)
{
  if (tl) {
    AB_Transaction_List2_ForEach(tl, AB_Transaction_List2__freeAll_cb, NULL);
    AB_Transaction_List2_free(tl);
  }
  else {
    DBG_ERROR(AQBANKING_LOGDOMAIN, "List missing");
    return GWEN_ERROR_INVALID;
  }
  return 0;
}

/* code headers */

