#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f1(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f2(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f3(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f4(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('Z', str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f5(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f6(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f7(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f8(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f9(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f10(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f11(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f12(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f13(struct tm *dst, const char *str, off_t &off, size_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

struct ptime_fmt PTIMEC_FORMATS[] = {
    { "%Y-%m-%d %H:%M:%S", ptime_f1 },
    { "%Y-%m-%d %H:%M", ptime_f2 },
    { "%Y-%m-%dT%H:%M:%S", ptime_f3 },
    { "%Y-%m-%dT%H:%M:%SZ", ptime_f4 },
    { "%Y/%m/%d %H:%M:%S", ptime_f5 },
    { "%Y/%m/%d %H:%M", ptime_f6 },
    { "%a %b %d %H:%M:%S %Y", ptime_f7 },
    { "%a %b %d %H:%M:%S %Z %Y", ptime_f8 },
    { "%a %b %d %H:%M:%S ", ptime_f9 },
    { "%d/%b/%Y:%H:%M:%S %z", ptime_f10 },
    { "%b %d %H:%M:%S", ptime_f11 },
    { "%m/%d/%y %H:%M:%S", ptime_f12 },
    { "%m%d %H:%M:%S", ptime_f13 },

    { NULL, NULL }
};
const char *PTIMEC_FORMAT_STR[] = {
    "%Y-%m-%d %H:%M:%S",
    "%Y-%m-%d %H:%M",
    "%Y-%m-%dT%H:%M:%S",
    "%Y-%m-%dT%H:%M:%SZ",
    "%Y/%m/%d %H:%M:%S",
    "%Y/%m/%d %H:%M",
    "%a %b %d %H:%M:%S %Y",
    "%a %b %d %H:%M:%S %Z %Y",
    "%a %b %d %H:%M:%S ",
    "%d/%b/%Y:%H:%M:%S %z",
    "%b %d %H:%M:%S",
    "%m/%d/%y %H:%M:%S",
    "%m%d %H:%M:%S",

    NULL
};
