; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=powerpc64le-linux-gnu | FileCheck %s

define float @can_fma_with_fewer_uses(float %f1, float %f2, float %f3, float %f4) {
; CHECK-LABEL: can_fma_with_fewer_uses:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xsmulsp 0, 1, 2
; CHECK-NEXT:    fmr 1, 0
; CHECK-NEXT:    xsmaddasp 1, 3, 4
; CHECK-NEXT:    xsdivsp 1, 0, 1
; CHECK-NEXT:    blr
  %mul1 = fmul contract float %f1, %f2
  %mul2 = fmul contract float %f3, %f4
  %add = fadd contract float %mul1, %mul2
  %second_use_of_mul1 = fdiv float %mul1, %add
  ret float %second_use_of_mul1
}

; There is no contract on the mul with no extra use so we can't fuse that.
; Since we are fusing with the mul with an extra use, the fmul needs to stick
; around beside the fma.
define float @no_fma_with_fewer_uses(float %f1, float %f2, float %f3, float %f4) {
; CHECK-LABEL: no_fma_with_fewer_uses:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xsmulsp 0, 1, 2
; CHECK-NEXT:    fmr 1, 0
; CHECK-NEXT:    xsmaddasp 1, 3, 4
; CHECK-NEXT:    xsdivsp 1, 0, 1
; CHECK-NEXT:    blr
  %mul1 = fmul contract float %f1, %f2
  %mul2 = fmul float %f3, %f4
  %add = fadd contract float %mul1, %mul2
  %second_use_of_mul1 = fdiv float %mul1, %add
  ret float %second_use_of_mul1
}
