/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.jps.build;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class IncrementalJpsTestGenerated extends AbstractIncrementalJpsTest {
    @TestMetadata("jps-plugin/testData/incremental/multiModule/common")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Common extends AbstractIncrementalJpsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCommon() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classAdded")
        public void testClassAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/classAdded/");
        }

        @TestMetadata("classRemoved")
        public void testClassRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/classRemoved/");
        }

        @TestMetadata("constantValueChanged")
        public void testConstantValueChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/constantValueChanged/");
        }

        @TestMetadata("copyFileToAnotherModule")
        public void testCopyFileToAnotherModule() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/copyFileToAnotherModule/");
        }

        @TestMetadata("defaultArgumentInConstructorRemoved")
        public void testDefaultArgumentInConstructorRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/defaultArgumentInConstructorRemoved/");
        }

        @TestMetadata("defaultParameterAdded")
        public void testDefaultParameterAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/defaultParameterAdded/");
        }

        @TestMetadata("defaultParameterAddedForTopLevelFun")
        public void testDefaultParameterAddedForTopLevelFun() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/defaultParameterAddedForTopLevelFun/");
        }

        @TestMetadata("defaultParameterRemoved")
        public void testDefaultParameterRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/defaultParameterRemoved/");
        }

        @TestMetadata("defaultParameterRemovedForTopLevelFun")
        public void testDefaultParameterRemovedForTopLevelFun() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/defaultParameterRemovedForTopLevelFun/");
        }

        @TestMetadata("defaultValueInConstructorRemoved")
        public void testDefaultValueInConstructorRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/defaultValueInConstructorRemoved/");
        }

        @TestMetadata("duplicatedClass")
        public void testDuplicatedClass() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/duplicatedClass/");
        }

        @TestMetadata("exportedDependency")
        public void testExportedDependency() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/exportedDependency/");
        }

        @TestMetadata("functionFromDifferentPackageChanged")
        public void testFunctionFromDifferentPackageChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/functionFromDifferentPackageChanged/");
        }

        @TestMetadata("inlineFunctionInlined")
        public void testInlineFunctionInlined() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/inlineFunctionInlined/");
        }

        @TestMetadata("inlineFunctionTwoPackageParts")
        public void testInlineFunctionTwoPackageParts() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/inlineFunctionTwoPackageParts/");
        }

        @TestMetadata("moveFileToAnotherModule")
        public void testMoveFileToAnotherModule() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/moveFileToAnotherModule/");
        }

        @TestMetadata("simple")
        public void testSimple() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/simple/");
        }

        @TestMetadata("simpleDependency")
        public void testSimpleDependency() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/simpleDependency/");
        }

        @TestMetadata("simpleDependencyErrorOnAccessToInternal1")
        public void testSimpleDependencyErrorOnAccessToInternal1() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/simpleDependencyErrorOnAccessToInternal1/");
        }

        @TestMetadata("simpleDependencyErrorOnAccessToInternal2")
        public void testSimpleDependencyErrorOnAccessToInternal2() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/simpleDependencyErrorOnAccessToInternal2/");
        }

        @TestMetadata("simpleDependencyUnchanged")
        public void testSimpleDependencyUnchanged() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/simpleDependencyUnchanged/");
        }

        @TestMetadata("transitiveDependency")
        public void testTransitiveDependency() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/transitiveDependency/");
        }

        @TestMetadata("transitiveInlining")
        public void testTransitiveInlining() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/transitiveInlining/");
        }

        @TestMetadata("twoDependants")
        public void testTwoDependants() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/common/twoDependants/");
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/classAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/classAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/classRemoved")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassRemoved extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassRemoved() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/classRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/constantValueChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConstantValueChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConstantValueChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/constantValueChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/copyFileToAnotherModule")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CopyFileToAnotherModule extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCopyFileToAnotherModule() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/copyFileToAnotherModule"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/defaultArgumentInConstructorRemoved")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultArgumentInConstructorRemoved extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultArgumentInConstructorRemoved() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/defaultArgumentInConstructorRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/defaultParameterAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultParameterAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultParameterAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/defaultParameterAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/defaultParameterAddedForTopLevelFun")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultParameterAddedForTopLevelFun extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultParameterAddedForTopLevelFun() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/defaultParameterAddedForTopLevelFun"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/defaultParameterRemoved")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultParameterRemoved extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultParameterRemoved() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/defaultParameterRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/defaultParameterRemovedForTopLevelFun")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultParameterRemovedForTopLevelFun extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultParameterRemovedForTopLevelFun() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/defaultParameterRemovedForTopLevelFun"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/defaultValueInConstructorRemoved")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultValueInConstructorRemoved extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultValueInConstructorRemoved() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/defaultValueInConstructorRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/duplicatedClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DuplicatedClass extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDuplicatedClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/duplicatedClass"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/exportedDependency")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExportedDependency extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInExportedDependency() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/exportedDependency"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/functionFromDifferentPackageChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionFromDifferentPackageChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionFromDifferentPackageChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/functionFromDifferentPackageChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/inlineFunctionInlined")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineFunctionInlined extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInlineFunctionInlined() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/inlineFunctionInlined"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/inlineFunctionTwoPackageParts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineFunctionTwoPackageParts extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInlineFunctionTwoPackageParts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/inlineFunctionTwoPackageParts"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/moveFileToAnotherModule")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MoveFileToAnotherModule extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMoveFileToAnotherModule() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/moveFileToAnotherModule"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/simple")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Simple extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSimple() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/simple"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/simpleDependency")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SimpleDependency extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSimpleDependency() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/simpleDependency"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/simpleDependencyErrorOnAccessToInternal1")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SimpleDependencyErrorOnAccessToInternal1 extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSimpleDependencyErrorOnAccessToInternal1() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/simpleDependencyErrorOnAccessToInternal1"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/simpleDependencyErrorOnAccessToInternal2")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SimpleDependencyErrorOnAccessToInternal2 extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSimpleDependencyErrorOnAccessToInternal2() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/simpleDependencyErrorOnAccessToInternal2"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/simpleDependencyUnchanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SimpleDependencyUnchanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSimpleDependencyUnchanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/simpleDependencyUnchanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/transitiveDependency")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TransitiveDependency extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTransitiveDependency() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/transitiveDependency"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/transitiveInlining")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TransitiveInlining extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTransitiveInlining() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/transitiveInlining"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/common/twoDependants")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TwoDependants extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTwoDependants() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/common/twoDependants"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("jps-plugin/testData/incremental/multiModule/jvm")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Jvm extends AbstractIncrementalJpsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJvm() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/jvm"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("circular")
        public void testCircular() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/jvm/circular/");
        }

        @TestMetadata("circularDependencyClasses")
        public void testCircularDependencyClasses() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/jvm/circularDependencyClasses/");
        }

        @TestMetadata("circularDependencySamePackageUnchanged")
        public void testCircularDependencySamePackageUnchanged() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/jvm/circularDependencySamePackageUnchanged/");
        }

        @TestMetadata("circularDependencyTopLevelFunctions")
        public void testCircularDependencyTopLevelFunctions() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/jvm/circularDependencyTopLevelFunctions/");
        }

        @TestMetadata("circularDependencyWithAccessToInternal")
        public void testCircularDependencyWithAccessToInternal() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/jvm/circularDependencyWithAccessToInternal/");
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/jvm/circular")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Circular extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCircular() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/jvm/circular"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/jvm/circularDependencyClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CircularDependencyClasses extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCircularDependencyClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/jvm/circularDependencyClasses"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/jvm/circularDependencySamePackageUnchanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CircularDependencySamePackageUnchanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCircularDependencySamePackageUnchanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/jvm/circularDependencySamePackageUnchanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/jvm/circularDependencyTopLevelFunctions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CircularDependencyTopLevelFunctions extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCircularDependencyTopLevelFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/jvm/circularDependencyTopLevelFunctions"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/jvm/circularDependencyWithAccessToInternal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CircularDependencyWithAccessToInternal extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCircularDependencyWithAccessToInternal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/jvm/circularDependencyWithAccessToInternal"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("jps-plugin/testData/incremental/multiModule/multiplatform/custom")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Custom extends AbstractIncrementalJpsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCustom() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/multiplatform/custom"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("buildError")
        public void testBuildError() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/multiplatform/custom/buildError/");
        }

        @TestMetadata("buildError2Levels")
        public void testBuildError2Levels() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/multiplatform/custom/buildError2Levels/");
        }

        @TestMetadata("commonSourcesCompilerArg")
        public void testCommonSourcesCompilerArg() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/multiplatform/custom/commonSourcesCompilerArg/");
        }

        @TestMetadata("complementaryFiles")
        public void testComplementaryFiles() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/multiplatform/custom/complementaryFiles/");
        }

        @TestMetadata("notSameCompiler")
        public void testNotSameCompiler() throws Exception {
            runTest("jps-plugin/testData/incremental/multiModule/multiplatform/custom/notSameCompiler/");
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/multiplatform/custom/buildError")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BuildError extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInBuildError() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/multiplatform/custom/buildError"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/multiplatform/custom/buildError2Levels")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BuildError2Levels extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInBuildError2Levels() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/multiplatform/custom/buildError2Levels"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/multiplatform/custom/commonSourcesCompilerArg")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CommonSourcesCompilerArg extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCommonSourcesCompilerArg() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/multiplatform/custom/commonSourcesCompilerArg"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/multiplatform/custom/complementaryFiles")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ComplementaryFiles extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInComplementaryFiles() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/multiplatform/custom/complementaryFiles"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/multiModule/multiplatform/custom/notSameCompiler")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NotSameCompiler extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInNotSameCompiler() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule/multiplatform/custom/notSameCompiler"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("jps-plugin/testData/incremental/pureKotlin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PureKotlin extends AbstractIncrementalJpsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("accessingFunctionsViaPackagePart")
        public void testAccessingFunctionsViaPackagePart() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/accessingFunctionsViaPackagePart/");
        }

        @TestMetadata("accessingPropertiesViaField")
        public void testAccessingPropertiesViaField() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/accessingPropertiesViaField/");
        }

        @TestMetadata("addClass")
        public void testAddClass() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/addClass/");
        }

        @TestMetadata("addFileWithFunctionOverload")
        public void testAddFileWithFunctionOverload() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/addFileWithFunctionOverload/");
        }

        @TestMetadata("addMemberTypeAlias")
        public void testAddMemberTypeAlias() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/addMemberTypeAlias/");
        }

        @TestMetadata("addTopLevelTypeAlias")
        public void testAddTopLevelTypeAlias() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/addTopLevelTypeAlias/");
        }

        @TestMetadata("allConstants")
        public void testAllConstants() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/allConstants/");
        }

        public void testAllFilesPresentInPureKotlin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/pureKotlin"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
        }

        @TestMetadata("annotations")
        public void testAnnotations() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/annotations/");
        }

        @TestMetadata("anonymousObjectChanged")
        public void testAnonymousObjectChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/anonymousObjectChanged/");
        }

        @TestMetadata("changeTypeImplicitlyWithCircularDependency")
        public void testChangeTypeImplicitlyWithCircularDependency() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/changeTypeImplicitlyWithCircularDependency/");
        }

        @TestMetadata("changeWithRemovingUsage")
        public void testChangeWithRemovingUsage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/changeWithRemovingUsage/");
        }

        @TestMetadata("classInlineFunctionChanged")
        public void testClassInlineFunctionChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/classInlineFunctionChanged/");
        }

        @TestMetadata("classObjectConstantChanged")
        public void testClassObjectConstantChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/classObjectConstantChanged/");
        }

        @TestMetadata("classRecreated")
        public void testClassRecreated() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/classRecreated/");
        }

        @TestMetadata("classSignatureChanged")
        public void testClassSignatureChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/classSignatureChanged/");
        }

        @TestMetadata("classSignatureUnchanged")
        public void testClassSignatureUnchanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/classSignatureUnchanged/");
        }

        @TestMetadata("compilationErrorThenFixedOtherPackage")
        public void testCompilationErrorThenFixedOtherPackage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedOtherPackage/");
        }

        @TestMetadata("compilationErrorThenFixedSamePackage")
        public void testCompilationErrorThenFixedSamePackage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedSamePackage/");
        }

        @TestMetadata("compilationErrorThenFixedWithPhantomPart")
        public void testCompilationErrorThenFixedWithPhantomPart() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedWithPhantomPart/");
        }

        @TestMetadata("compilationErrorThenFixedWithPhantomPart2")
        public void testCompilationErrorThenFixedWithPhantomPart2() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedWithPhantomPart2/");
        }

        @TestMetadata("compilationErrorThenFixedWithPhantomPart3")
        public void testCompilationErrorThenFixedWithPhantomPart3() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedWithPhantomPart3/");
        }

        @TestMetadata("constantRemoved")
        public void testConstantRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/constantRemoved/");
        }

        @TestMetadata("constantValueChanged")
        public void testConstantValueChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/constantValueChanged/");
        }

        @TestMetadata("constantsUnchanged")
        public void testConstantsUnchanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/constantsUnchanged/");
        }

        @TestMetadata("defaultArgumentInConstructorAdded")
        public void testDefaultArgumentInConstructorAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/defaultArgumentInConstructorAdded/");
        }

        @TestMetadata("defaultArgumentInConstructorRemoved")
        public void testDefaultArgumentInConstructorRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/defaultArgumentInConstructorRemoved/");
        }

        @TestMetadata("defaultValueAdded")
        public void testDefaultValueAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/defaultValueAdded/");
        }

        @TestMetadata("defaultValueChanged")
        public void testDefaultValueChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/defaultValueChanged/");
        }

        @TestMetadata("defaultValueInConstructorChanged")
        public void testDefaultValueInConstructorChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/defaultValueInConstructorChanged/");
        }

        @TestMetadata("defaultValueInConstructorRemoved")
        public void testDefaultValueInConstructorRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/defaultValueInConstructorRemoved/");
        }

        @TestMetadata("defaultValueRemoved1")
        public void testDefaultValueRemoved1() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/defaultValueRemoved1/");
        }

        @TestMetadata("defaultValueRemoved2")
        public void testDefaultValueRemoved2() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/defaultValueRemoved2/");
        }

        @TestMetadata("delegatedPropertyInlineExtensionAccessor")
        public void testDelegatedPropertyInlineExtensionAccessor() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/delegatedPropertyInlineExtensionAccessor/");
        }

        @TestMetadata("delegatedPropertyInlineMethodAccessor")
        public void testDelegatedPropertyInlineMethodAccessor() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/delegatedPropertyInlineMethodAccessor/");
        }

        @TestMetadata("dependencyClassReferenced")
        public void testDependencyClassReferenced() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/dependencyClassReferenced/");
        }

        @TestMetadata("fileWithConstantRemoved")
        public void testFileWithConstantRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/fileWithConstantRemoved/");
        }

        @TestMetadata("fileWithInlineFunctionRemoved")
        public void testFileWithInlineFunctionRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/fileWithInlineFunctionRemoved/");
        }

        @TestMetadata("filesExchangePackages")
        public void testFilesExchangePackages() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/filesExchangePackages/");
        }

        @TestMetadata("funRedeclaration")
        public void testFunRedeclaration() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/funRedeclaration/");
        }

        @TestMetadata("funVsConstructorOverloadConflict")
        public void testFunVsConstructorOverloadConflict() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/funVsConstructorOverloadConflict/");
        }

        @TestMetadata("functionBecameInline")
        public void testFunctionBecameInline() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/functionBecameInline/");
        }

        @TestMetadata("functionReferencingClass")
        public void testFunctionReferencingClass() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/functionReferencingClass/");
        }

        @TestMetadata("independentClasses")
        public void testIndependentClasses() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/independentClasses/");
        }

        @TestMetadata("inlineFunctionBecomesNonInline")
        public void testInlineFunctionBecomesNonInline() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlineFunctionBecomesNonInline/");
        }

        @TestMetadata("inlineFunctionUsageAdded")
        public void testInlineFunctionUsageAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlineFunctionUsageAdded/");
        }

        @TestMetadata("inlineFunctionsCircularDependency")
        public void testInlineFunctionsCircularDependency() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlineFunctionsCircularDependency/");
        }

        @TestMetadata("inlineFunctionsUnchanged")
        public void testInlineFunctionsUnchanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlineFunctionsUnchanged/");
        }

        @TestMetadata("inlineLinesChanged")
        public void testInlineLinesChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlineLinesChanged/");
        }

        @TestMetadata("inlineModifiedWithUsage")
        public void testInlineModifiedWithUsage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlineModifiedWithUsage/");
        }

        @TestMetadata("inlinePrivateFunctionAdded")
        public void testInlinePrivateFunctionAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlinePrivateFunctionAdded/");
        }

        @TestMetadata("inlinePropertyInClass")
        public void testInlinePropertyInClass() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlinePropertyInClass/");
        }

        @TestMetadata("inlinePropertyOnTopLevel")
        public void testInlinePropertyOnTopLevel() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlinePropertyOnTopLevel/");
        }

        @TestMetadata("inlineSuspendFunctionChanged")
        public void testInlineSuspendFunctionChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlineSuspendFunctionChanged/");
        }

        @TestMetadata("inlineTwoFunctionsOneChanged")
        public void testInlineTwoFunctionsOneChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlineTwoFunctionsOneChanged/");
        }

        @TestMetadata("inlineUsedWhereDeclared")
        public void testInlineUsedWhereDeclared() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/inlineUsedWhereDeclared/");
        }

        @TestMetadata("internalClassChanged")
        public void testInternalClassChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/internalClassChanged/");
        }

        @TestMetadata("internalMemberInClassChanged")
        public void testInternalMemberInClassChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/internalMemberInClassChanged/");
        }

        @TestMetadata("internalTypealias")
        public void testInternalTypealias() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/internalTypealias/");
        }

        @TestMetadata("internalTypealiasConstructor")
        public void testInternalTypealiasConstructor() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/internalTypealiasConstructor/");
        }

        @TestMetadata("internalTypealiasObject")
        public void testInternalTypealiasObject() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/internalTypealiasObject/");
        }

        @TestMetadata("localClassChanged")
        public void testLocalClassChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/localClassChanged/");
        }

        @TestMetadata("moveClass")
        public void testMoveClass() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/moveClass/");
        }

        @TestMetadata("moveFileWithChangingPackage")
        public void testMoveFileWithChangingPackage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/moveFileWithChangingPackage/");
        }

        @TestMetadata("moveFileWithoutChangingPackage")
        public void testMoveFileWithoutChangingPackage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/moveFileWithoutChangingPackage/");
        }

        @TestMetadata("multiplePackagesModified")
        public void testMultiplePackagesModified() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/multiplePackagesModified/");
        }

        @TestMetadata("objectConstantChanged")
        public void testObjectConstantChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/objectConstantChanged/");
        }

        @TestMetadata("ourClassReferenced")
        public void testOurClassReferenced() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/ourClassReferenced/");
        }

        @TestMetadata("overloadInlined")
        public void testOverloadInlined() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/overloadInlined/");
        }

        @TestMetadata("packageConstantChanged")
        public void testPackageConstantChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageConstantChanged/");
        }

        @TestMetadata("packageFileAdded")
        public void testPackageFileAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageFileAdded/");
        }

        @TestMetadata("packageFileChangedPackage")
        public void testPackageFileChangedPackage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageFileChangedPackage/");
        }

        @TestMetadata("packageFileChangedThenOtherRemoved")
        public void testPackageFileChangedThenOtherRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageFileChangedThenOtherRemoved/");
        }

        @TestMetadata("packageFileRemoved")
        public void testPackageFileRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageFileRemoved/");
        }

        @TestMetadata("packageFilesChangedInTurn")
        public void testPackageFilesChangedInTurn() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageFilesChangedInTurn/");
        }

        @TestMetadata("packageInlineFunctionAccessingField")
        public void testPackageInlineFunctionAccessingField() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageInlineFunctionAccessingField/");
        }

        @TestMetadata("packageInlineFunctionFromOurPackage")
        public void testPackageInlineFunctionFromOurPackage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageInlineFunctionFromOurPackage/");
        }

        @TestMetadata("packagePrivateOnlyChanged")
        public void testPackagePrivateOnlyChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packagePrivateOnlyChanged/");
        }

        @TestMetadata("packageRecreated")
        public void testPackageRecreated() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageRecreated/");
        }

        @TestMetadata("packageRecreatedAfterRenaming")
        public void testPackageRecreatedAfterRenaming() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageRecreatedAfterRenaming/");
        }

        @TestMetadata("packageRemoved")
        public void testPackageRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/packageRemoved/");
        }

        @TestMetadata("privateConstantsChanged")
        public void testPrivateConstantsChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateConstantsChanged/");
        }

        @TestMetadata("privateMethodAdded")
        public void testPrivateMethodAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateMethodAdded/");
        }

        @TestMetadata("privateMethodDeleted")
        public void testPrivateMethodDeleted() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateMethodDeleted/");
        }

        @TestMetadata("privateMethodSignatureChanged")
        public void testPrivateMethodSignatureChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateMethodSignatureChanged/");
        }

        @TestMetadata("privateSecondaryConstructorAdded")
        public void testPrivateSecondaryConstructorAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateSecondaryConstructorAdded/");
        }

        @TestMetadata("privateSecondaryConstructorDeleted")
        public void testPrivateSecondaryConstructorDeleted() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateSecondaryConstructorDeleted/");
        }

        @TestMetadata("privateValAccessorChanged")
        public void testPrivateValAccessorChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateValAccessorChanged/");
        }

        @TestMetadata("privateValAdded")
        public void testPrivateValAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateValAdded/");
        }

        @TestMetadata("privateValDeleted")
        public void testPrivateValDeleted() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateValDeleted/");
        }

        @TestMetadata("privateValSignatureChanged")
        public void testPrivateValSignatureChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateValSignatureChanged/");
        }

        @TestMetadata("privateVarAdded")
        public void testPrivateVarAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateVarAdded/");
        }

        @TestMetadata("privateVarDeleted")
        public void testPrivateVarDeleted() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateVarDeleted/");
        }

        @TestMetadata("privateVarSignatureChanged")
        public void testPrivateVarSignatureChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/privateVarSignatureChanged/");
        }

        @TestMetadata("propertyRedeclaration")
        public void testPropertyRedeclaration() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/propertyRedeclaration/");
        }

        @TestMetadata("publicPropertyWithPrivateSetter")
        public void testPublicPropertyWithPrivateSetter() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/publicPropertyWithPrivateSetter/");
        }

        @TestMetadata("removeAndRestoreCompanion")
        public void testRemoveAndRestoreCompanion() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/removeAndRestoreCompanion/");
        }

        @TestMetadata("removeAndRestoreCompanionWithImplicitUsages")
        public void testRemoveAndRestoreCompanionWithImplicitUsages() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/removeAndRestoreCompanionWithImplicitUsages/");
        }

        @TestMetadata("removeClass")
        public void testRemoveClass() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/removeClass/");
        }

        @TestMetadata("removeClassInDefaultPackage")
        public void testRemoveClassInDefaultPackage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/removeClassInDefaultPackage/");
        }

        @TestMetadata("removeFileWithFunctionOverload")
        public void testRemoveFileWithFunctionOverload() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/removeFileWithFunctionOverload/");
        }

        @TestMetadata("removeMemberTypeAlias")
        public void testRemoveMemberTypeAlias() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/removeMemberTypeAlias/");
        }

        @TestMetadata("removeTopLevelTypeAlias")
        public void testRemoveTopLevelTypeAlias() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/removeTopLevelTypeAlias/");
        }

        @TestMetadata("removeUnusedFile")
        public void testRemoveUnusedFile() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/removeUnusedFile/");
        }

        @TestMetadata("renameClass")
        public void testRenameClass() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/renameClass/");
        }

        @TestMetadata("renameFileWithFunctionOverload")
        public void testRenameFileWithFunctionOverload() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/renameFileWithFunctionOverload/");
        }

        @TestMetadata("returnTypeChanged")
        public void testReturnTypeChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/returnTypeChanged/");
        }

        @TestMetadata("secondaryConstructorInlined")
        public void testSecondaryConstructorInlined() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/secondaryConstructorInlined/");
        }

        @TestMetadata("simpleClassDependency")
        public void testSimpleClassDependency() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/simpleClassDependency/");
        }

        @TestMetadata("soleFileChangesPackage")
        public void testSoleFileChangesPackage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/soleFileChangesPackage/");
        }

        @TestMetadata("subpackage")
        public void testSubpackage() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/subpackage/");
        }

        @TestMetadata("suspendWithStateMachine")
        public void testSuspendWithStateMachine() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/suspendWithStateMachine/");
        }

        @TestMetadata("topLevelFunctionSameSignature")
        public void testTopLevelFunctionSameSignature() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/topLevelFunctionSameSignature/");
        }

        @TestMetadata("topLevelMembersInTwoFiles")
        public void testTopLevelMembersInTwoFiles() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/topLevelMembersInTwoFiles/");
        }

        @TestMetadata("topLevelPrivateValUsageAdded")
        public void testTopLevelPrivateValUsageAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/topLevelPrivateValUsageAdded/");
        }

        @TestMetadata("traitClassObjectConstantChanged")
        public void testTraitClassObjectConstantChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/traitClassObjectConstantChanged/");
        }

        @TestMetadata("valAddCustomAccessor")
        public void testValAddCustomAccessor() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/valAddCustomAccessor/");
        }

        @TestMetadata("valRemoveCustomAccessor")
        public void testValRemoveCustomAccessor() throws Exception {
            runTest("jps-plugin/testData/incremental/pureKotlin/valRemoveCustomAccessor/");
        }
    }

    @TestMetadata("jps-plugin/testData/incremental/withJava")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WithJava extends AbstractIncrementalJpsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInWithJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConvertBetweenJavaAndKotlin extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConvertBetweenJavaAndKotlin() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaToKotlin")
            public void testJavaToKotlin() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlin/");
            }

            @TestMetadata("javaToKotlinAndBack")
            public void testJavaToKotlinAndBack() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlinAndBack/");
            }

            @TestMetadata("javaToKotlinAndRemove")
            public void testJavaToKotlinAndRemove() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlinAndRemove/");
            }

            @TestMetadata("kotlinToJava")
            public void testKotlinToJava() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/kotlinToJava/");
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlin")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JavaToKotlin extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJavaToKotlin() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlin"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlinAndBack")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JavaToKotlinAndBack extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJavaToKotlinAndBack() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlinAndBack"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlinAndRemove")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JavaToKotlinAndRemove extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJavaToKotlinAndRemove() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlinAndRemove"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/kotlinToJava")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class KotlinToJava extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInKotlinToJava() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/kotlinToJava"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaUsedInKotlin extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInJavaUsedInKotlin() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeFieldType")
            public void testChangeFieldType() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeFieldType/");
            }

            @TestMetadata("changeNotUsedSignature")
            public void testChangeNotUsedSignature() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeNotUsedSignature/");
            }

            @TestMetadata("changePropertyOverrideType")
            public void testChangePropertyOverrideType() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changePropertyOverrideType/");
            }

            @TestMetadata("changeSignature")
            public void testChangeSignature() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignature/");
            }

            @TestMetadata("changeSignaturePackagePrivate")
            public void testChangeSignaturePackagePrivate() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignaturePackagePrivate/");
            }

            @TestMetadata("changeSignaturePackagePrivateNonRoot")
            public void testChangeSignaturePackagePrivateNonRoot() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignaturePackagePrivateNonRoot/");
            }

            @TestMetadata("changeSignatureStatic")
            public void testChangeSignatureStatic() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignatureStatic/");
            }

            @TestMetadata("constantChanged")
            public void testConstantChanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/constantChanged/");
            }

            @TestMetadata("constantUnchanged")
            public void testConstantUnchanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/constantUnchanged/");
            }

            @TestMetadata("enumEntryAdded")
            public void testEnumEntryAdded() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/enumEntryAdded/");
            }

            @TestMetadata("enumEntryRemoved")
            public void testEnumEntryRemoved() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/enumEntryRemoved/");
            }

            @TestMetadata("javaAndKotlinChangedSimultaneously")
            public void testJavaAndKotlinChangedSimultaneously() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaAndKotlinChangedSimultaneously/");
            }

            @TestMetadata("javaFieldNullabilityChanged")
            public void testJavaFieldNullabilityChanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaFieldNullabilityChanged/");
            }

            @TestMetadata("javaMethodParamNullabilityChanged")
            public void testJavaMethodParamNullabilityChanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaMethodParamNullabilityChanged/");
            }

            @TestMetadata("javaMethodReturnTypeNullabilityChanged")
            public void testJavaMethodReturnTypeNullabilityChanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaMethodReturnTypeNullabilityChanged/");
            }

            @TestMetadata("methodAddedInSuper")
            public void testMethodAddedInSuper() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/methodAddedInSuper/");
            }

            @TestMetadata("methodRenamed")
            public void testMethodRenamed() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/methodRenamed/");
            }

            @TestMetadata("mixedInheritance")
            public void testMixedInheritance() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/mixedInheritance/");
            }

            @TestMetadata("notChangeSignature")
            public void testNotChangeSignature() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/notChangeSignature/");
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeFieldType")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ChangeFieldType extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInChangeFieldType() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeFieldType"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeNotUsedSignature")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ChangeNotUsedSignature extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInChangeNotUsedSignature() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeNotUsedSignature"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changePropertyOverrideType")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ChangePropertyOverrideType extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInChangePropertyOverrideType() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changePropertyOverrideType"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignature")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ChangeSignature extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInChangeSignature() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignature"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignaturePackagePrivate")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ChangeSignaturePackagePrivate extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInChangeSignaturePackagePrivate() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignaturePackagePrivate"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignaturePackagePrivateNonRoot")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ChangeSignaturePackagePrivateNonRoot extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInChangeSignaturePackagePrivateNonRoot() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignaturePackagePrivateNonRoot"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignatureStatic")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ChangeSignatureStatic extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInChangeSignatureStatic() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignatureStatic"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/constantChanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ConstantChanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInConstantChanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/constantChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/constantUnchanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ConstantUnchanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInConstantUnchanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/constantUnchanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/enumEntryAdded")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class EnumEntryAdded extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInEnumEntryAdded() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/enumEntryAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/enumEntryRemoved")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class EnumEntryRemoved extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInEnumEntryRemoved() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/enumEntryRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaAndKotlinChangedSimultaneously")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JavaAndKotlinChangedSimultaneously extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJavaAndKotlinChangedSimultaneously() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaAndKotlinChangedSimultaneously"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaFieldNullabilityChanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JavaFieldNullabilityChanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJavaFieldNullabilityChanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaFieldNullabilityChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaMethodParamNullabilityChanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JavaMethodParamNullabilityChanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJavaMethodParamNullabilityChanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaMethodParamNullabilityChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaMethodReturnTypeNullabilityChanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JavaMethodReturnTypeNullabilityChanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJavaMethodReturnTypeNullabilityChanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaMethodReturnTypeNullabilityChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/methodAddedInSuper")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MethodAddedInSuper extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMethodAddedInSuper() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/methodAddedInSuper"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/methodRenamed")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MethodRenamed extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMethodRenamed() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/methodRenamed"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/mixedInheritance")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MixedInheritance extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMixedInheritance() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/mixedInheritance"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/notChangeSignature")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NotChangeSignature extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNotChangeSignature() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/notChangeSignature"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SamConversions extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSamConversions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("methodAdded")
                public void testMethodAdded() throws Exception {
                    runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodAdded/");
                }

                @TestMetadata("methodAddedSamAdapter")
                public void testMethodAddedSamAdapter() throws Exception {
                    runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodAddedSamAdapter/");
                }

                @TestMetadata("methodSignatureChanged")
                public void testMethodSignatureChanged() throws Exception {
                    runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodSignatureChanged/");
                }

                @TestMetadata("methodSignatureChangedSamAdapter")
                public void testMethodSignatureChangedSamAdapter() throws Exception {
                    runTest("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodSignatureChangedSamAdapter/");
                }

                @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodAdded")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class MethodAdded extends AbstractIncrementalJpsTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInMethodAdded() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodAddedSamAdapter")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class MethodAddedSamAdapter extends AbstractIncrementalJpsTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInMethodAddedSamAdapter() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodAddedSamAdapter"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodSignatureChanged")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class MethodSignatureChanged extends AbstractIncrementalJpsTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInMethodSignatureChanged() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodSignatureChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodSignatureChangedSamAdapter")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class MethodSignatureChangedSamAdapter extends AbstractIncrementalJpsTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInMethodSignatureChangedSamAdapter() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodSignatureChangedSamAdapter"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                    }
                }
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KotlinUsedInJava extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("addOptionalParameter")
            public void testAddOptionalParameter() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/addOptionalParameter/");
            }

            public void testAllFilesPresentInKotlinUsedInJava() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeNotUsedSignature")
            public void testChangeNotUsedSignature() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/changeNotUsedSignature/");
            }

            @TestMetadata("changeSignature")
            public void testChangeSignature() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/changeSignature/");
            }

            @TestMetadata("constantChanged")
            public void testConstantChanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/constantChanged/");
            }

            @TestMetadata("constantUnchanged")
            public void testConstantUnchanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/constantUnchanged/");
            }

            @TestMetadata("funRenamed")
            public void testFunRenamed() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/funRenamed/");
            }

            @TestMetadata("jvmFieldChanged")
            public void testJvmFieldChanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/jvmFieldChanged/");
            }

            @TestMetadata("jvmFieldUnchanged")
            public void testJvmFieldUnchanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/jvmFieldUnchanged/");
            }

            @TestMetadata("methodAddedInSuper")
            public void testMethodAddedInSuper() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/methodAddedInSuper/");
            }

            @TestMetadata("notChangeSignature")
            public void testNotChangeSignature() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/notChangeSignature/");
            }

            @TestMetadata("onlyTopLevelFunctionInFileRemoved")
            public void testOnlyTopLevelFunctionInFileRemoved() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/onlyTopLevelFunctionInFileRemoved/");
            }

            @TestMetadata("packageFileAdded")
            public void testPackageFileAdded() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/packageFileAdded/");
            }

            @TestMetadata("privateChanges")
            public void testPrivateChanges() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/privateChanges/");
            }

            @TestMetadata("propertyRenamed")
            public void testPropertyRenamed() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/propertyRenamed/");
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/addOptionalParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AddOptionalParameter extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAddOptionalParameter() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/addOptionalParameter"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/changeNotUsedSignature")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ChangeNotUsedSignature extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInChangeNotUsedSignature() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/changeNotUsedSignature"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/changeSignature")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ChangeSignature extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInChangeSignature() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/changeSignature"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/constantChanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ConstantChanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInConstantChanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/constantChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/constantUnchanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ConstantUnchanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInConstantUnchanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/constantUnchanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/funRenamed")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunRenamed extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFunRenamed() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/funRenamed"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/jvmFieldChanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JvmFieldChanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJvmFieldChanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/jvmFieldChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/jvmFieldUnchanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JvmFieldUnchanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJvmFieldUnchanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/jvmFieldUnchanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/methodAddedInSuper")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MethodAddedInSuper extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMethodAddedInSuper() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/methodAddedInSuper"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/notChangeSignature")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NotChangeSignature extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNotChangeSignature() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/notChangeSignature"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/onlyTopLevelFunctionInFileRemoved")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OnlyTopLevelFunctionInFileRemoved extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInOnlyTopLevelFunctionInFileRemoved() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/onlyTopLevelFunctionInFileRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/packageFileAdded")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PackageFileAdded extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPackageFileAdded() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/packageFileAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/privateChanges")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PrivateChanges extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPrivateChanges() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/privateChanges"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/propertyRenamed")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PropertyRenamed extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPropertyRenamed() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/propertyRenamed"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/withJava/other")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Other extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("accessingFunctionsViaRenamedFileClass")
            public void testAccessingFunctionsViaRenamedFileClass() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/accessingFunctionsViaRenamedFileClass/");
            }

            public void testAllFilesPresentInOther() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("allKotlinFilesRemovedThenNewAdded")
            public void testAllKotlinFilesRemovedThenNewAdded() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/allKotlinFilesRemovedThenNewAdded/");
            }

            @TestMetadata("classRedeclaration")
            public void testClassRedeclaration() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/classRedeclaration/");
            }

            @TestMetadata("classToPackageFacade")
            public void testClassToPackageFacade() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/classToPackageFacade/");
            }

            @TestMetadata("conflictingPlatformDeclarations")
            public void testConflictingPlatformDeclarations() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/conflictingPlatformDeclarations/");
            }

            @TestMetadata("defaultValueInConstructorAdded")
            public void testDefaultValueInConstructorAdded() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/defaultValueInConstructorAdded/");
            }

            @TestMetadata("inlineTopLevelFunctionWithJvmName")
            public void testInlineTopLevelFunctionWithJvmName() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/inlineTopLevelFunctionWithJvmName/");
            }

            @TestMetadata("inlineTopLevelValPropertyWithJvmName")
            public void testInlineTopLevelValPropertyWithJvmName() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/inlineTopLevelValPropertyWithJvmName/");
            }

            @TestMetadata("innerClassNotGeneratedWhenRebuilding")
            public void testInnerClassNotGeneratedWhenRebuilding() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/innerClassNotGeneratedWhenRebuilding/");
            }

            @TestMetadata("jvmNameChanged")
            public void testJvmNameChanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/jvmNameChanged/");
            }

            @TestMetadata("mainRedeclaration")
            public void testMainRedeclaration() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/mainRedeclaration/");
            }

            @TestMetadata("multifileClassAddTopLevelFunWithDefault")
            public void testMultifileClassAddTopLevelFunWithDefault() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifileClassAddTopLevelFunWithDefault/");
            }

            @TestMetadata("multifileClassFileAdded")
            public void testMultifileClassFileAdded() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifileClassFileAdded/");
            }

            @TestMetadata("multifileClassFileChanged")
            public void testMultifileClassFileChanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifileClassFileChanged/");
            }

            @TestMetadata("multifileClassFileMovedToAnotherMultifileClass")
            public void testMultifileClassFileMovedToAnotherMultifileClass() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifileClassFileMovedToAnotherMultifileClass/");
            }

            @TestMetadata("multifileClassInlineFunction")
            public void testMultifileClassInlineFunction() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifileClassInlineFunction/");
            }

            @TestMetadata("multifileClassInlineFunctionAccessingField")
            public void testMultifileClassInlineFunctionAccessingField() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifileClassInlineFunctionAccessingField/");
            }

            @TestMetadata("multifileClassRecreated")
            public void testMultifileClassRecreated() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifileClassRecreated/");
            }

            @TestMetadata("multifileClassRecreatedAfterRenaming")
            public void testMultifileClassRecreatedAfterRenaming() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifileClassRecreatedAfterRenaming/");
            }

            @TestMetadata("multifileClassRemoved")
            public void testMultifileClassRemoved() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifileClassRemoved/");
            }

            @TestMetadata("multifilePackagePartMethodAdded")
            public void testMultifilePackagePartMethodAdded() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/multifilePackagePartMethodAdded/");
            }

            @TestMetadata("optionalParameter")
            public void testOptionalParameter() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/optionalParameter/");
            }

            @TestMetadata("packageFacadeToClass")
            public void testPackageFacadeToClass() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/packageFacadeToClass/");
            }

            @TestMetadata("packageMultifileClassOneFileWithPublicChanges")
            public void testPackageMultifileClassOneFileWithPublicChanges() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/packageMultifileClassOneFileWithPublicChanges/");
            }

            @TestMetadata("packageMultifileClassPrivateOnlyChanged")
            public void testPackageMultifileClassPrivateOnlyChanged() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/packageMultifileClassPrivateOnlyChanged/");
            }

            @TestMetadata("publicPropertyWithPrivateSetterMultiFileFacade")
            public void testPublicPropertyWithPrivateSetterMultiFileFacade() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/publicPropertyWithPrivateSetterMultiFileFacade/");
            }

            @TestMetadata("topLevelFunctionWithJvmName")
            public void testTopLevelFunctionWithJvmName() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/topLevelFunctionWithJvmName/");
            }

            @TestMetadata("topLevelPropertyWithJvmName")
            public void testTopLevelPropertyWithJvmName() throws Exception {
                runTest("jps-plugin/testData/incremental/withJava/other/topLevelPropertyWithJvmName/");
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/accessingFunctionsViaRenamedFileClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AccessingFunctionsViaRenamedFileClass extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAccessingFunctionsViaRenamedFileClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/accessingFunctionsViaRenamedFileClass"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/allKotlinFilesRemovedThenNewAdded")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AllKotlinFilesRemovedThenNewAdded extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAllKotlinFilesRemovedThenNewAdded() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/allKotlinFilesRemovedThenNewAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/classRedeclaration")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ClassRedeclaration extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInClassRedeclaration() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/classRedeclaration"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/classToPackageFacade")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ClassToPackageFacade extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInClassToPackageFacade() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/classToPackageFacade"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/conflictingPlatformDeclarations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ConflictingPlatformDeclarations extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInConflictingPlatformDeclarations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/conflictingPlatformDeclarations"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/defaultValueInConstructorAdded")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DefaultValueInConstructorAdded extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDefaultValueInConstructorAdded() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/defaultValueInConstructorAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/inlineTopLevelFunctionWithJvmName")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InlineTopLevelFunctionWithJvmName extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInlineTopLevelFunctionWithJvmName() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/inlineTopLevelFunctionWithJvmName"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/inlineTopLevelValPropertyWithJvmName")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InlineTopLevelValPropertyWithJvmName extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInlineTopLevelValPropertyWithJvmName() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/inlineTopLevelValPropertyWithJvmName"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/innerClassNotGeneratedWhenRebuilding")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InnerClassNotGeneratedWhenRebuilding extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInnerClassNotGeneratedWhenRebuilding() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/innerClassNotGeneratedWhenRebuilding"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/jvmNameChanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JvmNameChanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJvmNameChanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/jvmNameChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/mainRedeclaration")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MainRedeclaration extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMainRedeclaration() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/mainRedeclaration"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifileClassAddTopLevelFunWithDefault")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifileClassAddTopLevelFunWithDefault extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifileClassAddTopLevelFunWithDefault() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifileClassAddTopLevelFunWithDefault"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifileClassFileAdded")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifileClassFileAdded extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifileClassFileAdded() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifileClassFileAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifileClassFileChanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifileClassFileChanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifileClassFileChanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifileClassFileChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifileClassFileMovedToAnotherMultifileClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifileClassFileMovedToAnotherMultifileClass extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifileClassFileMovedToAnotherMultifileClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifileClassFileMovedToAnotherMultifileClass"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifileClassInlineFunction")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifileClassInlineFunction extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifileClassInlineFunction() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifileClassInlineFunction"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifileClassInlineFunctionAccessingField")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifileClassInlineFunctionAccessingField extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifileClassInlineFunctionAccessingField() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifileClassInlineFunctionAccessingField"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifileClassRecreated")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifileClassRecreated extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifileClassRecreated() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifileClassRecreated"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifileClassRecreatedAfterRenaming")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifileClassRecreatedAfterRenaming extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifileClassRecreatedAfterRenaming() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifileClassRecreatedAfterRenaming"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifileClassRemoved")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifileClassRemoved extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifileClassRemoved() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifileClassRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/multifilePackagePartMethodAdded")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultifilePackagePartMethodAdded extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultifilePackagePartMethodAdded() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/multifilePackagePartMethodAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/optionalParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OptionalParameter extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInOptionalParameter() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/optionalParameter"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/packageFacadeToClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PackageFacadeToClass extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPackageFacadeToClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/packageFacadeToClass"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/packageMultifileClassOneFileWithPublicChanges")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PackageMultifileClassOneFileWithPublicChanges extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPackageMultifileClassOneFileWithPublicChanges() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/packageMultifileClassOneFileWithPublicChanges"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/packageMultifileClassPrivateOnlyChanged")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PackageMultifileClassPrivateOnlyChanged extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPackageMultifileClassPrivateOnlyChanged() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/packageMultifileClassPrivateOnlyChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/publicPropertyWithPrivateSetterMultiFileFacade")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PublicPropertyWithPrivateSetterMultiFileFacade extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPublicPropertyWithPrivateSetterMultiFileFacade() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/publicPropertyWithPrivateSetterMultiFileFacade"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/topLevelFunctionWithJvmName")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TopLevelFunctionWithJvmName extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTopLevelFunctionWithJvmName() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/topLevelFunctionWithJvmName"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/other/topLevelPropertyWithJvmName")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TopLevelPropertyWithJvmName extends AbstractIncrementalJpsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTopLevelPropertyWithJvmName() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/other/topLevelPropertyWithJvmName"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }
            }
        }
    }

    @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineFunCallSite extends AbstractIncrementalJpsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInlineFunCallSite() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classProperty")
        public void testClassProperty() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/classProperty/");
        }

        @TestMetadata("companionObjectProperty")
        public void testCompanionObjectProperty() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/companionObjectProperty/");
        }

        @TestMetadata("coroutine")
        public void testCoroutine() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/coroutine/");
        }

        @TestMetadata("function")
        public void testFunction() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/function/");
        }

        @TestMetadata("getter")
        public void testGetter() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/getter/");
        }

        @TestMetadata("lambda")
        public void testLambda() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/lambda/");
        }

        @TestMetadata("localFun")
        public void testLocalFun() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/localFun/");
        }

        @TestMetadata("method")
        public void testMethod() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/method/");
        }

        @TestMetadata("parameterDefaultValue")
        public void testParameterDefaultValue() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/parameterDefaultValue/");
        }

        @TestMetadata("primaryConstructorParameterDefaultValue")
        public void testPrimaryConstructorParameterDefaultValue() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/primaryConstructorParameterDefaultValue/");
        }

        @TestMetadata("superCall")
        public void testSuperCall() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/superCall/");
        }

        @TestMetadata("thisCall")
        public void testThisCall() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/thisCall/");
        }

        @TestMetadata("topLevelObjectProperty")
        public void testTopLevelObjectProperty() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/topLevelObjectProperty/");
        }

        @TestMetadata("topLevelProperty")
        public void testTopLevelProperty() throws Exception {
            runTest("jps-plugin/testData/incremental/inlineFunCallSite/topLevelProperty/");
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/classProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassProperty extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/classProperty"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/companionObjectProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompanionObjectProperty extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCompanionObjectProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/companionObjectProperty"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/coroutine")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Coroutine extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCoroutine() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/coroutine"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/function"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/getter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Getter extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInGetter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/getter"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/lambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lambda extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLambda() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/lambda"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/localFun")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalFun extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLocalFun() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/localFun"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/method")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Method extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMethod() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/method"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/parameterDefaultValue")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ParameterDefaultValue extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInParameterDefaultValue() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/parameterDefaultValue"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/primaryConstructorParameterDefaultValue")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PrimaryConstructorParameterDefaultValue extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInPrimaryConstructorParameterDefaultValue() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/primaryConstructorParameterDefaultValue"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/superCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuperCall extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSuperCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/superCall"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/thisCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ThisCall extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInThisCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/thisCall"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/topLevelObjectProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TopLevelObjectProperty extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTopLevelObjectProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/topLevelObjectProperty"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite/topLevelProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TopLevelProperty extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTopLevelProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite/topLevelProperty"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClassHierarchyAffected extends AbstractIncrementalJpsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInClassHierarchyAffected() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationFlagRemoved")
        public void testAnnotationFlagRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/annotationFlagRemoved/");
        }

        @TestMetadata("annotationListChanged")
        public void testAnnotationListChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/annotationListChanged/");
        }

        @TestMetadata("bridgeGenerated")
        public void testBridgeGenerated() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/bridgeGenerated/");
        }

        @TestMetadata("classBecameFinal")
        public void testClassBecameFinal() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/classBecameFinal/");
        }

        @TestMetadata("classBecameInterface")
        public void testClassBecameInterface() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/classBecameInterface/");
        }

        @TestMetadata("classBecamePrivate")
        public void testClassBecamePrivate() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/classBecamePrivate/");
        }

        @TestMetadata("classMovedIntoOtherClass")
        public void testClassMovedIntoOtherClass() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/classMovedIntoOtherClass/");
        }

        @TestMetadata("classRemoved")
        public void testClassRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/classRemoved/");
        }

        @TestMetadata("classRemovedAndRestored")
        public void testClassRemovedAndRestored() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/classRemovedAndRestored/");
        }

        @TestMetadata("companionObjectInheritedMemberChanged")
        public void testCompanionObjectInheritedMemberChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectInheritedMemberChanged/");
        }

        @TestMetadata("companionObjectMemberChanged")
        public void testCompanionObjectMemberChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectMemberChanged/");
        }

        @TestMetadata("companionObjectNameChanged")
        public void testCompanionObjectNameChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectNameChanged/");
        }

        @TestMetadata("companionObjectToSimpleObject")
        public void testCompanionObjectToSimpleObject() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectToSimpleObject/");
        }

        @TestMetadata("constructorVisibilityChanged")
        public void testConstructorVisibilityChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/constructorVisibilityChanged/");
        }

        @TestMetadata("enumEntryAdded")
        public void testEnumEntryAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/enumEntryAdded/");
        }

        @TestMetadata("enumEntryRemoved")
        public void testEnumEntryRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/enumEntryRemoved/");
        }

        @TestMetadata("enumMemberChanged")
        public void testEnumMemberChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/enumMemberChanged/");
        }

        @TestMetadata("flagsAndMemberInDifferentClassesChanged")
        public void testFlagsAndMemberInDifferentClassesChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/flagsAndMemberInDifferentClassesChanged/");
        }

        @TestMetadata("flagsAndMemberInSameClassChanged")
        public void testFlagsAndMemberInSameClassChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/flagsAndMemberInSameClassChanged/");
        }

        @TestMetadata("implcitUpcast")
        public void testImplcitUpcast() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/implcitUpcast/");
        }

        @TestMetadata("inferredTypeArgumentChanged")
        public void testInferredTypeArgumentChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/inferredTypeArgumentChanged/");
        }

        @TestMetadata("inferredTypeChanged")
        public void testInferredTypeChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/inferredTypeChanged/");
        }

        @TestMetadata("lambdaParameterAffected")
        public void testLambdaParameterAffected() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/lambdaParameterAffected/");
        }

        @TestMetadata("methodAdded")
        public void testMethodAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/methodAdded/");
        }

        @TestMetadata("methodAnnotationAdded")
        public void testMethodAnnotationAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/methodAnnotationAdded/");
        }

        @TestMetadata("methodNullabilityChanged")
        public void testMethodNullabilityChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/methodNullabilityChanged/");
        }

        @TestMetadata("methodParameterWithDefaultValueAdded")
        public void testMethodParameterWithDefaultValueAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/methodParameterWithDefaultValueAdded/");
        }

        @TestMetadata("methodRemoved")
        public void testMethodRemoved() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/methodRemoved/");
        }

        @TestMetadata("overrideExplicit")
        public void testOverrideExplicit() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/overrideExplicit/");
        }

        @TestMetadata("overrideImplicit")
        public void testOverrideImplicit() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/overrideImplicit/");
        }

        @TestMetadata("propertyNullabilityChanged")
        public void testPropertyNullabilityChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/propertyNullabilityChanged/");
        }

        @TestMetadata("sealedClassImplAdded")
        public void testSealedClassImplAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassImplAdded/");
        }

        @TestMetadata("sealedClassIndirectImplAdded")
        public void testSealedClassIndirectImplAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassIndirectImplAdded/");
        }

        @TestMetadata("sealedClassNestedImplAdded")
        public void testSealedClassNestedImplAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassNestedImplAdded/");
        }

        @TestMetadata("secondaryConstructorAdded")
        public void testSecondaryConstructorAdded() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/secondaryConstructorAdded/");
        }

        @TestMetadata("starProjectionUpperBoundChanged")
        public void testStarProjectionUpperBoundChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/starProjectionUpperBoundChanged/");
        }

        @TestMetadata("supertypesListChanged")
        public void testSupertypesListChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/supertypesListChanged/");
        }

        @TestMetadata("typeParameterListChanged")
        public void testTypeParameterListChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/typeParameterListChanged/");
        }

        @TestMetadata("varianceChanged")
        public void testVarianceChanged() throws Exception {
            runTest("jps-plugin/testData/incremental/classHierarchyAffected/varianceChanged/");
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/annotationFlagRemoved")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotationFlagRemoved extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotationFlagRemoved() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/annotationFlagRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/annotationListChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotationListChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotationListChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/annotationListChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/bridgeGenerated")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BridgeGenerated extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInBridgeGenerated() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/bridgeGenerated"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classBecameFinal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassBecameFinal extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassBecameFinal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/classBecameFinal"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classBecameInterface")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassBecameInterface extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassBecameInterface() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/classBecameInterface"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classBecamePrivate")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassBecamePrivate extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassBecamePrivate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/classBecamePrivate"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classMovedIntoOtherClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassMovedIntoOtherClass extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassMovedIntoOtherClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/classMovedIntoOtherClass"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classRemoved")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassRemoved extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassRemoved() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/classRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classRemovedAndRestored")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassRemovedAndRestored extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassRemovedAndRestored() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/classRemovedAndRestored"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectInheritedMemberChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompanionObjectInheritedMemberChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCompanionObjectInheritedMemberChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectInheritedMemberChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectMemberChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompanionObjectMemberChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCompanionObjectMemberChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectMemberChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectNameChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompanionObjectNameChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCompanionObjectNameChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectNameChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectToSimpleObject")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompanionObjectToSimpleObject extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCompanionObjectToSimpleObject() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectToSimpleObject"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/constructorVisibilityChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConstructorVisibilityChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConstructorVisibilityChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/constructorVisibilityChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/enumEntryAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class EnumEntryAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInEnumEntryAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/enumEntryAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/enumEntryRemoved")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class EnumEntryRemoved extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInEnumEntryRemoved() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/enumEntryRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/enumMemberChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class EnumMemberChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInEnumMemberChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/enumMemberChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/flagsAndMemberInDifferentClassesChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FlagsAndMemberInDifferentClassesChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFlagsAndMemberInDifferentClassesChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/flagsAndMemberInDifferentClassesChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/flagsAndMemberInSameClassChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FlagsAndMemberInSameClassChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFlagsAndMemberInSameClassChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/flagsAndMemberInSameClassChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/implcitUpcast")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ImplcitUpcast extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInImplcitUpcast() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/implcitUpcast"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/inferredTypeArgumentChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InferredTypeArgumentChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInferredTypeArgumentChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/inferredTypeArgumentChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/inferredTypeChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InferredTypeChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInferredTypeChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/inferredTypeChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/lambdaParameterAffected")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LambdaParameterAffected extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLambdaParameterAffected() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/lambdaParameterAffected"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MethodAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMethodAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/methodAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodAnnotationAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MethodAnnotationAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMethodAnnotationAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/methodAnnotationAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodNullabilityChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MethodNullabilityChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMethodNullabilityChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/methodNullabilityChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodParameterWithDefaultValueAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MethodParameterWithDefaultValueAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMethodParameterWithDefaultValueAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/methodParameterWithDefaultValueAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodRemoved")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MethodRemoved extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMethodRemoved() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/methodRemoved"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/overrideExplicit")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OverrideExplicit extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInOverrideExplicit() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/overrideExplicit"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/overrideImplicit")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OverrideImplicit extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInOverrideImplicit() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/overrideImplicit"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/propertyNullabilityChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PropertyNullabilityChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInPropertyNullabilityChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/propertyNullabilityChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassImplAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SealedClassImplAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSealedClassImplAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassImplAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassIndirectImplAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SealedClassIndirectImplAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSealedClassIndirectImplAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassIndirectImplAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassNestedImplAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SealedClassNestedImplAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSealedClassNestedImplAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassNestedImplAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/secondaryConstructorAdded")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SecondaryConstructorAdded extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSecondaryConstructorAdded() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/secondaryConstructorAdded"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/starProjectionUpperBoundChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StarProjectionUpperBoundChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInStarProjectionUpperBoundChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/starProjectionUpperBoundChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/supertypesListChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SupertypesListChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSupertypesListChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/supertypesListChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/typeParameterListChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeParameterListChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTypeParameterListChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/typeParameterListChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected/varianceChanged")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class VarianceChanged extends AbstractIncrementalJpsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInVarianceChanged() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected/varianceChanged"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }
        }
    }
}
