/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2015-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package javax.xml.bind.test;

import org.junit.Before;
import org.junit.Test;

import javax.xml.bind.*;
import java.util.Map;

import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.assertNotNull;
import static junit.framework.TestCase.fail;

/**
 * regression test for
 * JDK-8145104: NPE is thrown when JAXBContextFactory implementation is specified in system property
 */
public class JAXBContextServiceProviderNPETest {

    public static class Factory implements JAXBContextFactory {

        @Override
        public JAXBContext createContext(Class<?>[] classesToBeBound, Map<String, ?> properties) throws JAXBException {
            return new MyContext();
        }

        @Override
        public JAXBContext createContext(String contextPath, ClassLoader classLoader, Map<String, ?> properties)
                throws JAXBException {
            return new MyContext();
        }
    }

    static class MyContext extends JAXBContext {
        @Override
        public Unmarshaller createUnmarshaller() throws JAXBException {
            return null;
        }

        @Override
        public Marshaller createMarshaller() throws JAXBException {
            return null;
        }

        @Override
        public Validator createValidator() throws JAXBException {
            return null;
        }
    }

    @Test
    public void testContextPath() {
        try {
            JAXBContext ctx = JAXBContext.newInstance("whatever", ClassLoader.getSystemClassLoader());
            assertNotNull("Expected non-null instance to be returned from the test Factory", ctx);
            assertEquals("Expected MyContext instance to be returned from the test Factory", MyContext.class, ctx.getClass());
        } catch (Throwable t) {
            t.printStackTrace();
            fail("Not expected to fail!");
        }
    }

    @Test
    public void testClasses() {
        try {
            JAXBContext ctx = JAXBContext.newInstance(new Class[0]);
            assertNotNull("Expected non-null instance to be returned from the test Factory", ctx);
            assertEquals("Expected MyContext instance to be returned from the test Factory", MyContext.class, ctx.getClass());
        } catch (Throwable t) {
            t.printStackTrace();
            fail("Not expected to fail!");
        }
    }

    @Before
    public void setup() {
        System.setProperty("javax.xml.bind.JAXBContextFactory", "javax.xml.bind.test.JAXBContextServiceProviderNPETest$Factory");
    }

    public static void main(String[] args) throws JAXBException {
        JAXBContextServiceProviderNPETest tst = new JAXBContextServiceProviderNPETest();
        tst.setup();
        tst.testContextPath();
        tst.testClasses();
    }

}
