; REQUIRES: regkeys,pvc-supported,llvm-14
; RUN: llvm-as %s -o %t.bc
; RUN: ocloc compile -llvm_input -file %t.bc -device pvc -options "-igc_opts 'VISAOptions=-asmToConsole'" &> %t_output.ll
; RUN: FileCheck --input-file %t_output.ll %s

; CHECK://.kernel __omp_offloading_803_6ec32c3__Z8bcBottom_l138
; I'm trying to match 4 consecutive numbers starting with 2: 23477 for example, and EOL character {{$}} so we won't match more than 4
; CHECK://.spill size 2[[A:[0-9]{4}]]{{$}}
; CHECK: end of thread

; CHECK://.kernel __omp_offloading_803_6ec32c3__Z8bcBottom_l138
; CHECK://.spill size 1[[B:[0-9]{4}]]{{$}}
; CHECK: end of thread


; ModuleID = 'reduced_cfg.ll'
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v16:16:16-v24:32:32-v32:32:32-v48:64:64-v64:64:64-v96:128:128-v128:128:128-v192:256:256-v256:256:256-v512:512:512-v1024:1024:1024"
target triple = "spir64-unknown-unknown"

%struct.par_t = type { [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double], [37 x double] }

; Function Attrs: nounwind
declare spir_func i64 @_Z13get_global_idj(i32) #0

; Function Attrs: noinline nounwind
define spir_kernel void @__omp_offloading_803_6ec32c3__Z8bcBottom_l138(double addrspace(1)* noalias %0, %struct.par_t addrspace(1)* noalias %1, double addrspace(1)* noalias %2, i64 %3, i64 %4, i64 %5, i64 %6, i64 %7, i64 %8) #1 {
  %10 = icmp ult i64 %7, %8
  %11 = add i64 %6, 1
  %12 = icmp ugt i64 %11, %5
  %13 = select i1 %10, i1 %12, i1 false
  br i1 %13, label %14, label %1718

14:                                               ; preds = %9
  %15 = call spir_func i64 @_Z13get_global_idj(i32 0) #0
  %16 = icmp ult i64 %15, %6
  %17 = select i1 %16, i64 %15, i64 %6
  %18 = icmp sgt i64 %15, %17
  br i1 %18, label %1718, label %19

19:                                               ; preds = %14
  %20 = mul i64 %3, 15
  %21 = mul i64 %20, %4
  %22 = mul i64 %3, 22
  %23 = mul i64 %22, %4
  %24 = shl i64 %3, 3
  %25 = mul i64 %24, %4
  %26 = mul i64 %3, 29
  %27 = mul i64 %26, %4
  %28 = mul i64 %3, 23
  %29 = mul i64 %28, %4
  %30 = shl i64 %3, 4
  %31 = mul i64 %30, %4
  %32 = mul i64 %3, 9
  %33 = mul i64 %32, %4
  %34 = mul i64 %3, 3
  %35 = mul i64 %34, %4
  %36 = mul i64 %3, 34
  %37 = mul i64 %36, %4
  %38 = mul i64 %3, 30
  %39 = mul i64 %38, %4
  %40 = mul i64 %3, 24
  %41 = mul i64 %40, %4
  %42 = mul i64 %3, 17
  %43 = mul i64 %42, %4
  %44 = mul i64 %3, 10
  %45 = mul i64 %44, %4
  %46 = shl i64 %3, 2
  %47 = mul i64 %46, %4
  %48 = mul i64 %3, 35
  %49 = mul i64 %48, %4
  %50 = mul i64 %3, 31
  %51 = mul i64 %50, %4
  %52 = mul i64 %3, 25
  %53 = mul i64 %52, %4
  %54 = mul i64 %3, 11
  %55 = mul i64 %54, %4
  %56 = mul i64 %3, 5
  %57 = mul i64 %56, %4
  %58 = mul i64 %3, %4
  %59 = mul i64 %3, 18
  %60 = mul i64 %59, %4
  %61 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 35
  %62 = load double, double addrspace(1)* %61, align 8
  %63 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 31
  %64 = load double, double addrspace(1)* %63, align 8
  %65 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 25
  %66 = load double, double addrspace(1)* %65, align 8
  %67 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 11
  %68 = load double, double addrspace(1)* %67, align 8
  %69 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 5
  %70 = load double, double addrspace(1)* %69, align 8
  %71 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 1
  %72 = load double, double addrspace(1)* %71, align 8
  %73 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 34
  %74 = load double, double addrspace(1)* %73, align 8
  %75 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 30
  %76 = load double, double addrspace(1)* %75, align 8
  %77 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 24
  %78 = load double, double addrspace(1)* %77, align 8
  %79 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 17
  %80 = load double, double addrspace(1)* %79, align 8
  %81 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 10
  %82 = load double, double addrspace(1)* %81, align 8
  %83 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 4
  %84 = load double, double addrspace(1)* %83, align 8
  %85 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 0
  %86 = load double, double addrspace(1)* %85, align 8
  %87 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 29
  %88 = load double, double addrspace(1)* %87, align 8
  %89 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 23
  %90 = load double, double addrspace(1)* %89, align 8
  %91 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 16
  %92 = load double, double addrspace(1)* %91, align 8
  %93 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 9
  %94 = load double, double addrspace(1)* %93, align 8
  %95 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 3
  %96 = load double, double addrspace(1)* %95, align 8
  %97 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 22
  %98 = load double, double addrspace(1)* %97, align 8
  %99 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 15
  %100 = load double, double addrspace(1)* %99, align 8
  %101 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 8
  %102 = load double, double addrspace(1)* %101, align 8
  %103 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 35
  %104 = load double, double addrspace(1)* %103, align 8
  %105 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 31
  %106 = load double, double addrspace(1)* %105, align 8
  %107 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 25
  %108 = load double, double addrspace(1)* %107, align 8
  %109 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 11
  %110 = load double, double addrspace(1)* %109, align 8
  %111 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 5
  %112 = load double, double addrspace(1)* %111, align 8
  %113 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 1
  %114 = load double, double addrspace(1)* %113, align 8
  %115 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 34
  %116 = load double, double addrspace(1)* %115, align 8
  %117 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 30
  %118 = load double, double addrspace(1)* %117, align 8
  %119 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 24
  %120 = load double, double addrspace(1)* %119, align 8
  %121 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 17
  %122 = load double, double addrspace(1)* %121, align 8
  %123 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 10
  %124 = load double, double addrspace(1)* %123, align 8
  %125 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 4
  %126 = load double, double addrspace(1)* %125, align 8
  %127 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 0
  %128 = load double, double addrspace(1)* %127, align 8
  %129 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 29
  %130 = load double, double addrspace(1)* %129, align 8
  %131 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 23
  %132 = load double, double addrspace(1)* %131, align 8
  %133 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 16
  %134 = load double, double addrspace(1)* %133, align 8
  %135 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 9
  %136 = load double, double addrspace(1)* %135, align 8
  %137 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 3
  %138 = load double, double addrspace(1)* %137, align 8
  %139 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 22
  %140 = load double, double addrspace(1)* %139, align 8
  %141 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 15
  %142 = load double, double addrspace(1)* %141, align 8
  %143 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 8
  %144 = load double, double addrspace(1)* %143, align 8
  %145 = fmul double %104, %104
  %146 = call spir_func double @_Z15__spirv_ocl_madddd(double %62, double %62, double %145) #0
  %147 = fmul double %146, 5.000000e-01
  %148 = fmul double %106, %106
  %149 = call spir_func double @_Z15__spirv_ocl_madddd(double %64, double %64, double %148) #0
  %150 = fmul double %149, 5.000000e-01
  %151 = fmul double %108, %108
  %152 = call spir_func double @_Z15__spirv_ocl_madddd(double %66, double %66, double %151) #0
  %153 = fmul double %152, 5.000000e-01
  %154 = fmul double %110, %110
  %155 = call spir_func double @_Z15__spirv_ocl_madddd(double %68, double %68, double %154) #0
  %156 = fmul double %155, 5.000000e-01
  %157 = fmul double %112, %112
  %158 = call spir_func double @_Z15__spirv_ocl_madddd(double %70, double %70, double %157) #0
  %159 = fmul double %158, 5.000000e-01
  %160 = fmul double %114, %114
  %161 = call spir_func double @_Z15__spirv_ocl_madddd(double %72, double %72, double %160) #0
  %162 = fmul double %161, 5.000000e-01
  %163 = fmul double %116, %116
  %164 = call spir_func double @_Z15__spirv_ocl_madddd(double %74, double %74, double %163) #0
  %165 = fmul double %164, 5.000000e-01
  %166 = fmul double %118, %118
  %167 = call spir_func double @_Z15__spirv_ocl_madddd(double %76, double %76, double %166) #0
  %168 = fmul double %167, 5.000000e-01
  %169 = fmul double %120, %120
  %170 = call spir_func double @_Z15__spirv_ocl_madddd(double %78, double %78, double %169) #0
  %171 = fmul double %170, 5.000000e-01
  %172 = fmul double %122, %122
  %173 = call spir_func double @_Z15__spirv_ocl_madddd(double %80, double %80, double %172) #0
  %174 = fmul double %173, 5.000000e-01
  %175 = fmul double %124, %124
  %176 = call spir_func double @_Z15__spirv_ocl_madddd(double %82, double %82, double %175) #0
  %177 = fmul double %176, 5.000000e-01
  %178 = fmul double %126, %126
  %179 = call spir_func double @_Z15__spirv_ocl_madddd(double %84, double %84, double %178) #0
  %180 = fmul double %179, 5.000000e-01
  %181 = fmul double %128, %128
  %182 = call spir_func double @_Z15__spirv_ocl_madddd(double %86, double %86, double %181) #0
  %183 = fmul double %182, 5.000000e-01
  %184 = fmul double %130, %130
  %185 = call spir_func double @_Z15__spirv_ocl_madddd(double %88, double %88, double %184) #0
  %186 = fmul double %185, 5.000000e-01
  %187 = fmul double %132, %132
  %188 = call spir_func double @_Z15__spirv_ocl_madddd(double %90, double %90, double %187) #0
  %189 = fmul double %188, 5.000000e-01
  %190 = fmul double %134, %134
  %191 = call spir_func double @_Z15__spirv_ocl_madddd(double %92, double %92, double %190) #0
  %192 = fmul double %191, 5.000000e-01
  %193 = fmul double %136, %136
  %194 = call spir_func double @_Z15__spirv_ocl_madddd(double %94, double %94, double %193) #0
  %195 = fmul double %194, 5.000000e-01
  %196 = fmul double %138, %138
  %197 = call spir_func double @_Z15__spirv_ocl_madddd(double %96, double %96, double %196) #0
  %198 = fmul double %197, 5.000000e-01
  %199 = fmul double %140, %140
  %200 = call spir_func double @_Z15__spirv_ocl_madddd(double %98, double %98, double %199) #0
  %201 = fmul double %200, 5.000000e-01
  %202 = fmul double %142, %142
  %203 = call spir_func double @_Z15__spirv_ocl_madddd(double %100, double %100, double %202) #0
  %204 = fmul double %203, 5.000000e-01
  %205 = fmul double %144, %144
  %206 = call spir_func double @_Z15__spirv_ocl_madddd(double %102, double %102, double %205) #0
  %207 = fmul double %206, 5.000000e-01
  %208 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 19
  %209 = load double, double addrspace(1)* %208, align 8
  %210 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 19
  %211 = load double, double addrspace(1)* %210, align 8
  %212 = fmul double %211, %211
  %213 = call spir_func double @_Z15__spirv_ocl_madddd(double %209, double %209, double %212) #0
  %214 = fmul double %213, 5.000000e-01
  %215 = mul i64 %3, 19
  %216 = mul i64 %215, %4
  %217 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 20
  %218 = load double, double addrspace(1)* %217, align 8
  %219 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 20
  %220 = load double, double addrspace(1)* %219, align 8
  %221 = fmul double %220, %220
  %222 = call spir_func double @_Z15__spirv_ocl_madddd(double %218, double %218, double %221) #0
  %223 = fmul double %222, 5.000000e-01
  %224 = mul i64 %3, 20
  %225 = mul i64 %224, %4
  %226 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 21
  %227 = load double, double addrspace(1)* %226, align 8
  %228 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 21
  %229 = load double, double addrspace(1)* %228, align 8
  %230 = fmul double %229, %229
  %231 = call spir_func double @_Z15__spirv_ocl_madddd(double %227, double %227, double %230) #0
  %232 = fmul double %231, 5.000000e-01
  %233 = mul i64 %3, 21
  %234 = mul i64 %233, %4
  %235 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 12
  %236 = load double, double addrspace(1)* %235, align 8
  %237 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 12
  %238 = load double, double addrspace(1)* %237, align 8
  %239 = fmul double %238, %238
  %240 = call spir_func double @_Z15__spirv_ocl_madddd(double %236, double %236, double %239) #0
  %241 = fmul double %240, 5.000000e-01
  %242 = mul i64 %3, 12
  %243 = mul i64 %242, %4
  %244 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 13
  %245 = load double, double addrspace(1)* %244, align 8
  %246 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 13
  %247 = load double, double addrspace(1)* %246, align 8
  %248 = fmul double %247, %247
  %249 = call spir_func double @_Z15__spirv_ocl_madddd(double %245, double %245, double %248) #0
  %250 = fmul double %249, 5.000000e-01
  %251 = mul i64 %3, 13
  %252 = mul i64 %251, %4
  %253 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 14
  %254 = load double, double addrspace(1)* %253, align 8
  %255 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 14
  %256 = load double, double addrspace(1)* %255, align 8
  %257 = fmul double %256, %256
  %258 = call spir_func double @_Z15__spirv_ocl_madddd(double %254, double %254, double %257) #0
  %259 = fmul double %258, 5.000000e-01
  %260 = mul i64 %3, 14
  %261 = mul i64 %260, %4
  %262 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 26
  %263 = load double, double addrspace(1)* %262, align 8
  %264 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 26
  %265 = load double, double addrspace(1)* %264, align 8
  %266 = fmul double %265, %265
  %267 = call spir_func double @_Z15__spirv_ocl_madddd(double %263, double %263, double %266) #0
  %268 = fmul double %267, 5.000000e-01
  %269 = mul i64 %3, 26
  %270 = mul i64 %269, %4
  %271 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 27
  %272 = load double, double addrspace(1)* %271, align 8
  %273 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 27
  %274 = load double, double addrspace(1)* %273, align 8
  %275 = fmul double %274, %274
  %276 = call spir_func double @_Z15__spirv_ocl_madddd(double %272, double %272, double %275) #0
  %277 = fmul double %276, 5.000000e-01
  %278 = mul i64 %3, 27
  %279 = mul i64 %278, %4
  %280 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 28
  %281 = load double, double addrspace(1)* %280, align 8
  %282 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 28
  %283 = load double, double addrspace(1)* %282, align 8
  %284 = fmul double %283, %283
  %285 = call spir_func double @_Z15__spirv_ocl_madddd(double %281, double %281, double %284) #0
  %286 = fmul double %285, 5.000000e-01
  %287 = mul i64 %3, 28
  %288 = mul i64 %287, %4
  %289 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 7
  %290 = load double, double addrspace(1)* %289, align 8
  %291 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 7
  %292 = load double, double addrspace(1)* %291, align 8
  %293 = fmul double %292, %292
  %294 = call spir_func double @_Z15__spirv_ocl_madddd(double %290, double %290, double %293) #0
  %295 = fmul double %294, 5.000000e-01
  %296 = mul i64 %3, 7
  %297 = mul i64 %296, %4
  %298 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 6
  %299 = load double, double addrspace(1)* %298, align 8
  %300 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 6
  %301 = load double, double addrspace(1)* %300, align 8
  %302 = fmul double %301, %301
  %303 = call spir_func double @_Z15__spirv_ocl_madddd(double %299, double %299, double %302) #0
  %304 = fmul double %303, 5.000000e-01
  %305 = mul i64 %3, 6
  %306 = mul i64 %305, %4
  %307 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 33
  %308 = load double, double addrspace(1)* %307, align 8
  %309 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 33
  %310 = load double, double addrspace(1)* %309, align 8
  %311 = fmul double %310, %310
  %312 = call spir_func double @_Z15__spirv_ocl_madddd(double %308, double %308, double %311) #0
  %313 = fmul double %312, 5.000000e-01
  %314 = mul i64 %3, 33
  %315 = mul i64 %314, %4
  %316 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 32
  %317 = load double, double addrspace(1)* %316, align 8
  %318 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 32
  %319 = load double, double addrspace(1)* %318, align 8
  %320 = fmul double %319, %319
  %321 = call spir_func double @_Z15__spirv_ocl_madddd(double %317, double %317, double %320) #0
  %322 = fmul double %321, 5.000000e-01
  %323 = shl i64 %3, 5
  %324 = mul i64 %323, %4
  %325 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 2
  %326 = load double, double addrspace(1)* %325, align 8
  %327 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 2
  %328 = load double, double addrspace(1)* %327, align 8
  %329 = fmul double %328, %328
  %330 = call spir_func double @_Z15__spirv_ocl_madddd(double %326, double %326, double %329) #0
  %331 = fmul double %330, 5.000000e-01
  %332 = shl i64 %3, 1
  %333 = mul i64 %332, %4
  %334 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 36
  %335 = load double, double addrspace(1)* %334, align 8
  %336 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 36
  %337 = load double, double addrspace(1)* %336, align 8
  %338 = fmul double %337, %337
  %339 = call spir_func double @_Z15__spirv_ocl_madddd(double %335, double %335, double %338) #0
  %340 = fmul double %339, 5.000000e-01
  %341 = mul i64 %3, 36
  %342 = mul i64 %341, %4
  %343 = add i64 %15, %7
  %344 = mul i64 %343, %4
  %345 = add i64 %344, 16
  br label %346

346:                                              ; preds = %346, %19
  %347 = phi i32 [ 0, %19 ], [ %365, %346 ]
  %348 = phi double [ 0.000000e+00, %19 ], [ %364, %346 ]
  %349 = phi double [ 0.000000e+00, %19 ], [ %361, %346 ]
  %350 = phi double [ 0.000000e+00, %19 ], [ %358, %346 ]
  %351 = sext i32 %347 to i64
  %352 = mul i64 %351, %3
  %353 = mul i64 %352, %4
  %354 = add i64 %353, %345
  %355 = add i64 %354, 3
  %356 = getelementptr inbounds double, double addrspace(1)* %0, i64 %355
  %357 = load double, double addrspace(1)* %356, align 8
  %358 = fadd double %350, %357
  %359 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 %351
  %360 = load double, double addrspace(1)* %359, align 8
  %361 = call spir_func double @_Z15__spirv_ocl_madddd(double %360, double %357, double %349) #0
  %362 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 %351
  %363 = load double, double addrspace(1)* %362, align 8
  %364 = call spir_func double @_Z15__spirv_ocl_madddd(double %363, double %357, double %348) #0
  %365 = add nuw nsw i32 %347, 1
  %366 = icmp eq i32 %365, 37
  br i1 %366, label %367, label %346

367:                                              ; preds = %346
  %368 = fdiv double 1.000000e+00, %358
  %369 = fmul double %361, %368
  %370 = fmul double %364, %368
  br label %371

371:                                              ; preds = %371, %367
  %372 = phi i32 [ 0, %367 ], [ %391, %371 ]
  %373 = phi double [ 0.000000e+00, %367 ], [ %390, %371 ]
  %374 = sext i32 %372 to i64
  %375 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 %374
  %376 = load double, double addrspace(1)* %375, align 8
  %377 = fsub double %376, %369
  %378 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 %374
  %379 = load double, double addrspace(1)* %378, align 8
  %380 = fsub double %379, %370
  %381 = fmul double %380, %380
  %382 = call spir_func double @_Z15__spirv_ocl_madddd(double %377, double %377, double %381) #0
  %383 = fmul double %382, 5.000000e-01
  %384 = mul i64 %374, %3
  %385 = mul i64 %384, %4
  %386 = add i64 %385, %345
  %387 = add i64 %386, 3
  %388 = getelementptr inbounds double, double addrspace(1)* %0, i64 %387
  %389 = load double, double addrspace(1)* %388, align 8
  %390 = call spir_func double @_Z15__spirv_ocl_madddd(double %383, double %389, double %373) #0
  %391 = add nuw nsw i32 %372, 1
  %392 = icmp eq i32 %391, 37
  br i1 %392, label %393, label %371

393:                                              ; preds = %371
  %394 = fmul double %358, 0xBEC23E3A5A7D3718
  %395 = fmul double %390, %368
  %396 = call spir_func double @_Z15__spirv_ocl_madddd(double %394, double %394, double 0.000000e+00) #0
  %397 = fmul double %396, %368
  %398 = fmul double %397, %368
  %399 = fmul double %398, 1.250000e-01
  %400 = fadd double %395, %399
  %401 = add i64 %21, %345
  %402 = getelementptr inbounds double, double addrspace(1)* %2, i64 %401
  %403 = load double, double addrspace(1)* %402, align 8
  %404 = add i64 %23, %345
  %405 = getelementptr inbounds double, double addrspace(1)* %2, i64 %404
  %406 = load double, double addrspace(1)* %405, align 8
  %407 = fadd double %403, %406
  %408 = add i64 %25, %345
  %409 = getelementptr inbounds double, double addrspace(1)* %2, i64 %408
  %410 = load double, double addrspace(1)* %409, align 8
  %411 = fadd double %407, %410
  %412 = add i64 %27, %345
  %413 = getelementptr inbounds double, double addrspace(1)* %2, i64 %412
  %414 = load double, double addrspace(1)* %413, align 8
  %415 = fadd double %411, %414
  %416 = add i64 %29, %345
  %417 = getelementptr inbounds double, double addrspace(1)* %2, i64 %416
  %418 = load double, double addrspace(1)* %417, align 8
  %419 = fadd double %415, %418
  %420 = add i64 %31, %345
  %421 = getelementptr inbounds double, double addrspace(1)* %2, i64 %420
  %422 = load double, double addrspace(1)* %421, align 8
  %423 = fadd double %419, %422
  %424 = add i64 %33, %345
  %425 = getelementptr inbounds double, double addrspace(1)* %2, i64 %424
  %426 = load double, double addrspace(1)* %425, align 8
  %427 = fadd double %423, %426
  %428 = add i64 %35, %345
  %429 = getelementptr inbounds double, double addrspace(1)* %2, i64 %428
  %430 = load double, double addrspace(1)* %429, align 8
  %431 = fadd double %427, %430
  %432 = add i64 %37, %345
  %433 = getelementptr inbounds double, double addrspace(1)* %2, i64 %432
  %434 = load double, double addrspace(1)* %433, align 8
  %435 = fadd double %431, %434
  %436 = add i64 %39, %345
  %437 = getelementptr inbounds double, double addrspace(1)* %2, i64 %436
  %438 = load double, double addrspace(1)* %437, align 8
  %439 = fadd double %435, %438
  %440 = add i64 %41, %345
  %441 = getelementptr inbounds double, double addrspace(1)* %2, i64 %440
  %442 = load double, double addrspace(1)* %441, align 8
  %443 = fadd double %439, %442
  %444 = add i64 %43, %345
  %445 = getelementptr inbounds double, double addrspace(1)* %2, i64 %444
  %446 = load double, double addrspace(1)* %445, align 8
  %447 = fadd double %443, %446
  %448 = add i64 %45, %345
  %449 = getelementptr inbounds double, double addrspace(1)* %2, i64 %448
  %450 = load double, double addrspace(1)* %449, align 8
  %451 = fadd double %447, %450
  %452 = add i64 %47, %345
  %453 = getelementptr inbounds double, double addrspace(1)* %2, i64 %452
  %454 = load double, double addrspace(1)* %453, align 8
  %455 = fadd double %451, %454
  %456 = getelementptr inbounds double, double addrspace(1)* %2, i64 %345
  %457 = load double, double addrspace(1)* %456, align 8
  %458 = fadd double %455, %457
  %459 = add i64 %49, %345
  %460 = getelementptr inbounds double, double addrspace(1)* %0, i64 %459
  %461 = load double, double addrspace(1)* %460, align 8
  %462 = fadd double %458, %461
  %463 = add i64 %51, %345
  %464 = getelementptr inbounds double, double addrspace(1)* %0, i64 %463
  %465 = load double, double addrspace(1)* %464, align 8
  %466 = fadd double %462, %465
  %467 = add i64 %53, %345
  %468 = getelementptr inbounds double, double addrspace(1)* %0, i64 %467
  %469 = load double, double addrspace(1)* %468, align 8
  %470 = fadd double %466, %469
  %471 = add i64 %55, %345
  %472 = getelementptr inbounds double, double addrspace(1)* %0, i64 %471
  %473 = load double, double addrspace(1)* %472, align 8
  %474 = fadd double %470, %473
  %475 = add i64 %57, %345
  %476 = getelementptr inbounds double, double addrspace(1)* %0, i64 %475
  %477 = load double, double addrspace(1)* %476, align 8
  %478 = fadd double %474, %477
  %479 = add i64 %58, %345
  %480 = getelementptr inbounds double, double addrspace(1)* %0, i64 %479
  %481 = load double, double addrspace(1)* %480, align 8
  %482 = fadd double %478, %481
  %483 = getelementptr inbounds double, double addrspace(1)* %0, i64 %432
  %484 = load double, double addrspace(1)* %483, align 8
  %485 = fadd double %482, %484
  %486 = getelementptr inbounds double, double addrspace(1)* %0, i64 %436
  %487 = load double, double addrspace(1)* %486, align 8
  %488 = fadd double %485, %487
  %489 = getelementptr inbounds double, double addrspace(1)* %0, i64 %440
  %490 = load double, double addrspace(1)* %489, align 8
  %491 = fadd double %488, %490
  %492 = getelementptr inbounds double, double addrspace(1)* %0, i64 %444
  %493 = load double, double addrspace(1)* %492, align 8
  %494 = fadd double %491, %493
  %495 = getelementptr inbounds double, double addrspace(1)* %0, i64 %448
  %496 = load double, double addrspace(1)* %495, align 8
  %497 = fadd double %494, %496
  %498 = getelementptr inbounds double, double addrspace(1)* %0, i64 %452
  %499 = load double, double addrspace(1)* %498, align 8
  %500 = fadd double %497, %499
  %501 = getelementptr inbounds double, double addrspace(1)* %0, i64 %345
  %502 = load double, double addrspace(1)* %501, align 8
  %503 = fadd double %500, %502
  %504 = getelementptr inbounds double, double addrspace(1)* %0, i64 %412
  %505 = load double, double addrspace(1)* %504, align 8
  %506 = fadd double %503, %505
  %507 = getelementptr inbounds double, double addrspace(1)* %0, i64 %416
  %508 = load double, double addrspace(1)* %507, align 8
  %509 = fadd double %506, %508
  %510 = getelementptr inbounds double, double addrspace(1)* %0, i64 %420
  %511 = load double, double addrspace(1)* %510, align 8
  %512 = fadd double %509, %511
  %513 = getelementptr inbounds double, double addrspace(1)* %0, i64 %424
  %514 = load double, double addrspace(1)* %513, align 8
  %515 = fadd double %512, %514
  %516 = getelementptr inbounds double, double addrspace(1)* %0, i64 %428
  %517 = load double, double addrspace(1)* %516, align 8
  %518 = fadd double %515, %517
  %519 = getelementptr inbounds double, double addrspace(1)* %0, i64 %404
  %520 = load double, double addrspace(1)* %519, align 8
  %521 = fadd double %518, %520
  %522 = getelementptr inbounds double, double addrspace(1)* %0, i64 %401
  %523 = load double, double addrspace(1)* %522, align 8
  %524 = fadd double %521, %523
  %525 = getelementptr inbounds double, double addrspace(1)* %0, i64 %408
  %526 = load double, double addrspace(1)* %525, align 8
  %527 = fadd double %524, %526
  %528 = add i64 %60, %345
  %529 = getelementptr inbounds double, double addrspace(1)* %0, i64 %528
  %530 = load double, double addrspace(1)* %529, align 8
  %531 = fadd double %527, %530
  %532 = fmul double %531, 0.000000e+00
  %533 = fmul double %531, 0xBEB5D62B1A5FFD97
  %534 = fdiv double %533, 0xBFF326D4427CFD50
  %535 = call spir_func double @_Z15__spirv_ocl_madddd(double %531, double 0.000000e+00, double %534) #0
  %536 = fmul double %535, %535
  %537 = call spir_func double @_Z15__spirv_ocl_madddd(double %532, double %532, double %536) #0
  %538 = fmul double %537, 5.000000e-01
  %539 = fdiv double %538, %531
  %540 = call spir_func double @_Z15__spirv_ocl_madddd(double %400, double %531, double %539) #0
  %541 = fmul double %64, %465
  %542 = call spir_func double @_Z15__spirv_ocl_madddd(double %62, double %461, double %541) #0
  %543 = call spir_func double @_Z15__spirv_ocl_madddd(double %66, double %469, double %542) #0
  %544 = call spir_func double @_Z15__spirv_ocl_madddd(double %68, double %473, double %543) #0
  %545 = call spir_func double @_Z15__spirv_ocl_madddd(double %70, double %477, double %544) #0
  %546 = call spir_func double @_Z15__spirv_ocl_madddd(double %72, double %481, double %545) #0
  %547 = call spir_func double @_Z15__spirv_ocl_madddd(double %74, double %484, double %546) #0
  %548 = call spir_func double @_Z15__spirv_ocl_madddd(double %76, double %487, double %547) #0
  %549 = call spir_func double @_Z15__spirv_ocl_madddd(double %78, double %490, double %548) #0
  %550 = call spir_func double @_Z15__spirv_ocl_madddd(double %80, double %493, double %549) #0
  %551 = call spir_func double @_Z15__spirv_ocl_madddd(double %82, double %496, double %550) #0
  %552 = call spir_func double @_Z15__spirv_ocl_madddd(double %84, double %499, double %551) #0
  %553 = call spir_func double @_Z15__spirv_ocl_madddd(double %86, double %502, double %552) #0
  %554 = call spir_func double @_Z15__spirv_ocl_madddd(double %88, double %505, double %553) #0
  %555 = call spir_func double @_Z15__spirv_ocl_madddd(double %90, double %508, double %554) #0
  %556 = call spir_func double @_Z15__spirv_ocl_madddd(double %92, double %511, double %555) #0
  %557 = call spir_func double @_Z15__spirv_ocl_madddd(double %94, double %514, double %556) #0
  %558 = call spir_func double @_Z15__spirv_ocl_madddd(double %96, double %517, double %557) #0
  %559 = call spir_func double @_Z15__spirv_ocl_madddd(double %98, double %520, double %558) #0
  %560 = call spir_func double @_Z15__spirv_ocl_madddd(double %100, double %523, double %559) #0
  %561 = call spir_func double @_Z15__spirv_ocl_madddd(double %102, double %526, double %560) #0
  %562 = fmul double %106, %465
  %563 = call spir_func double @_Z15__spirv_ocl_madddd(double %104, double %461, double %562) #0
  %564 = call spir_func double @_Z15__spirv_ocl_madddd(double %108, double %469, double %563) #0
  %565 = call spir_func double @_Z15__spirv_ocl_madddd(double %110, double %473, double %564) #0
  %566 = call spir_func double @_Z15__spirv_ocl_madddd(double %112, double %477, double %565) #0
  %567 = call spir_func double @_Z15__spirv_ocl_madddd(double %114, double %481, double %566) #0
  %568 = call spir_func double @_Z15__spirv_ocl_madddd(double %116, double %484, double %567) #0
  %569 = call spir_func double @_Z15__spirv_ocl_madddd(double %118, double %487, double %568) #0
  %570 = call spir_func double @_Z15__spirv_ocl_madddd(double %120, double %490, double %569) #0
  %571 = call spir_func double @_Z15__spirv_ocl_madddd(double %122, double %493, double %570) #0
  %572 = call spir_func double @_Z15__spirv_ocl_madddd(double %124, double %496, double %571) #0
  %573 = call spir_func double @_Z15__spirv_ocl_madddd(double %126, double %499, double %572) #0
  %574 = call spir_func double @_Z15__spirv_ocl_madddd(double %128, double %502, double %573) #0
  %575 = call spir_func double @_Z15__spirv_ocl_madddd(double %130, double %505, double %574) #0
  %576 = call spir_func double @_Z15__spirv_ocl_madddd(double %132, double %508, double %575) #0
  %577 = call spir_func double @_Z15__spirv_ocl_madddd(double %134, double %511, double %576) #0
  %578 = call spir_func double @_Z15__spirv_ocl_madddd(double %136, double %514, double %577) #0
  %579 = call spir_func double @_Z15__spirv_ocl_madddd(double %138, double %517, double %578) #0
  %580 = call spir_func double @_Z15__spirv_ocl_madddd(double %140, double %520, double %579) #0
  %581 = call spir_func double @_Z15__spirv_ocl_madddd(double %142, double %523, double %580) #0
  %582 = call spir_func double @_Z15__spirv_ocl_madddd(double %144, double %526, double %581) #0
  %583 = fmul double %150, %465
  %584 = call spir_func double @_Z15__spirv_ocl_madddd(double %147, double %461, double %583) #0
  %585 = call spir_func double @_Z15__spirv_ocl_madddd(double %153, double %469, double %584) #0
  %586 = call spir_func double @_Z15__spirv_ocl_madddd(double %156, double %473, double %585) #0
  %587 = call spir_func double @_Z15__spirv_ocl_madddd(double %159, double %477, double %586) #0
  %588 = call spir_func double @_Z15__spirv_ocl_madddd(double %162, double %481, double %587) #0
  %589 = call spir_func double @_Z15__spirv_ocl_madddd(double %165, double %484, double %588) #0
  %590 = call spir_func double @_Z15__spirv_ocl_madddd(double %168, double %487, double %589) #0
  %591 = call spir_func double @_Z15__spirv_ocl_madddd(double %171, double %490, double %590) #0
  %592 = call spir_func double @_Z15__spirv_ocl_madddd(double %174, double %493, double %591) #0
  %593 = call spir_func double @_Z15__spirv_ocl_madddd(double %177, double %496, double %592) #0
  %594 = call spir_func double @_Z15__spirv_ocl_madddd(double %180, double %499, double %593) #0
  %595 = call spir_func double @_Z15__spirv_ocl_madddd(double %183, double %502, double %594) #0
  %596 = call spir_func double @_Z15__spirv_ocl_madddd(double %186, double %505, double %595) #0
  %597 = call spir_func double @_Z15__spirv_ocl_madddd(double %189, double %508, double %596) #0
  %598 = call spir_func double @_Z15__spirv_ocl_madddd(double %192, double %511, double %597) #0
  %599 = call spir_func double @_Z15__spirv_ocl_madddd(double %195, double %514, double %598) #0
  %600 = call spir_func double @_Z15__spirv_ocl_madddd(double %198, double %517, double %599) #0
  %601 = call spir_func double @_Z15__spirv_ocl_madddd(double %201, double %520, double %600) #0
  %602 = call spir_func double @_Z15__spirv_ocl_madddd(double %204, double %523, double %601) #0
  %603 = call spir_func double @_Z15__spirv_ocl_madddd(double %207, double %526, double %602) #0
  %604 = fsub double %532, %561
  %605 = fmul double %604, 2.600000e+01
  %606 = fmul double %605, 0x3FF326D4427CFD50
  %607 = fmul double %458, -4.000000e+01
  %608 = fmul double %607, 0x3FF326D4427CFD50
  %609 = fmul double %608, 0x3FF326D4427CFD50
  %610 = fmul double %604, 4.700000e+01
  %611 = fmul double %610, 0x3FF326D4427CFD50
  %612 = fmul double %611, 0x3FF326D4427CFD50
  %613 = fmul double %604, 1.500000e+01
  %614 = fsub double %535, %582
  %615 = fmul double %614, 2.600000e+01
  %616 = fmul double %458, 5.400000e+01
  %617 = fmul double %616, 0x3FF326D4427CFD50
  %618 = fmul double %617, 0xBFF326D4427CFD50
  %619 = call spir_func double @_Z15__spirv_ocl_madddd(double %615, double 0x3FF326D4427CFD50, double %618) #0
  %620 = fmul double %614, 4.700000e+01
  %621 = fmul double %620, 0x3FF326D4427CFD50
  %622 = fmul double %458, 9.100000e+01
  %623 = fmul double %622, 0x3FF326D4427CFD50
  %624 = fmul double %623, 0x3FF326D4427CFD50
  %625 = fmul double %624, 0xBFF326D4427CFD50
  %626 = call spir_func double @_Z15__spirv_ocl_madddd(double %621, double 0x3FF326D4427CFD50, double %625) #0
  %627 = fmul double %458, 2.600000e+01
  %628 = fmul double %627, 0xBFF326D4427CFD50
  %629 = call spir_func double @_Z15__spirv_ocl_madddd(double %614, double 1.500000e+01, double %628) #0
  %630 = fsub double %540, %603
  %631 = fmul double %630, 2.600000e+01
  %632 = call spir_func double @_Z15__spirv_ocl_madddd(double %631, double 0x3FF326D4427CFD50, double %625) #0
  %633 = fmul double %630, 4.700000e+01
  %634 = fmul double %633, 0x3FF326D4427CFD50
  %635 = fmul double %458, 0x3FF326D4427CFD50
  %636 = fmul double %635, 0x3FF326D4427CFD50
  %637 = fmul double %636, 0x3FF326D4427CFD50
  %638 = fmul double %637, 0x3FF326D4427CFD50
  %639 = fmul double %638, 3.670000e+02
  %640 = fmul double %639, -5.000000e-01
  %641 = call spir_func double @_Z15__spirv_ocl_madddd(double %634, double 0x3FF326D4427CFD50, double %640) #0
  %642 = fmul double %458, 4.700000e+01
  %643 = fmul double %642, 0x3FF326D4427CFD50
  %644 = fmul double %643, 0xBFF326D4427CFD50
  %645 = call spir_func double @_Z15__spirv_ocl_madddd(double %630, double 1.500000e+01, double %644) #0
  %646 = fneg double %641
  %647 = fmul double %626, %645
  %648 = call spir_func double @_Z15__spirv_ocl_madddd(double %646, double %629, double %647) #0
  %649 = fneg double %632
  %650 = fmul double %619, %641
  %651 = call spir_func double @_Z15__spirv_ocl_madddd(double %649, double %626, double %650) #0
  %652 = fdiv double %648, %651
  %653 = fneg double %619
  %654 = fmul double %612, %653
  %655 = fmul double %654, %645
  %656 = call spir_func double @_Z15__spirv_ocl_madddd(double %650, double %613, double %655) #0
  %657 = fmul double %626, %649
  %658 = call spir_func double @_Z15__spirv_ocl_madddd(double %657, double %613, double %656) #0
  %659 = fmul double %606, %646
  %660 = call spir_func double @_Z15__spirv_ocl_madddd(double %659, double %629, double %658) #0
  %661 = fmul double %612, %632
  %662 = call spir_func double @_Z15__spirv_ocl_madddd(double %661, double %629, double %660) #0
  %663 = fmul double %606, %626
  %664 = call spir_func double @_Z15__spirv_ocl_madddd(double %663, double %645, double %662) #0
  %665 = fneg double %650
  %666 = call spir_func double @_Z15__spirv_ocl_madddd(double %632, double %626, double %665) #0
  %667 = fmul double %609, %666
  %668 = fdiv double %664, %667
  %669 = fmul double %619, %645
  %670 = call spir_func double @_Z15__spirv_ocl_madddd(double %649, double %629, double %669) #0
  %671 = fmul double %641, %653
  %672 = call spir_func double @_Z15__spirv_ocl_madddd(double %632, double %626, double %671) #0
  %673 = fdiv double %670, %672
  %674 = call spir_func double @_Z15__spirv_ocl_madddd(double %209, double %668, double 1.000000e+00) #0
  %675 = call spir_func double @_Z15__spirv_ocl_madddd(double %211, double %652, double %674) #0
  %676 = call spir_func double @_Z15__spirv_ocl_madddd(double %214, double %673, double %675) #0
  %677 = add i64 %216, %345
  %678 = getelementptr inbounds double, double addrspace(1)* %0, i64 %677
  store double %676, double addrspace(1)* %678, align 8
  %679 = call spir_func double @_Z15__spirv_ocl_madddd(double %218, double %668, double 1.000000e+00) #0
  %680 = call spir_func double @_Z15__spirv_ocl_madddd(double %220, double %652, double %679) #0
  %681 = call spir_func double @_Z15__spirv_ocl_madddd(double %223, double %673, double %680) #0
  %682 = add i64 %225, %345
  %683 = getelementptr inbounds double, double addrspace(1)* %0, i64 %682
  store double %681, double addrspace(1)* %683, align 8
  %684 = call spir_func double @_Z15__spirv_ocl_madddd(double %227, double %668, double 1.000000e+00) #0
  %685 = call spir_func double @_Z15__spirv_ocl_madddd(double %229, double %652, double %684) #0
  %686 = call spir_func double @_Z15__spirv_ocl_madddd(double %232, double %673, double %685) #0
  %687 = add i64 %234, %345
  %688 = getelementptr inbounds double, double addrspace(1)* %0, i64 %687
  store double %686, double addrspace(1)* %688, align 8
  %689 = call spir_func double @_Z15__spirv_ocl_madddd(double %236, double %668, double 1.000000e+00) #0
  %690 = call spir_func double @_Z15__spirv_ocl_madddd(double %238, double %652, double %689) #0
  %691 = call spir_func double @_Z15__spirv_ocl_madddd(double %241, double %673, double %690) #0
  %692 = add i64 %243, %345
  %693 = getelementptr inbounds double, double addrspace(1)* %0, i64 %692
  store double %691, double addrspace(1)* %693, align 8
  %694 = call spir_func double @_Z15__spirv_ocl_madddd(double %245, double %668, double 1.000000e+00) #0
  %695 = call spir_func double @_Z15__spirv_ocl_madddd(double %247, double %652, double %694) #0
  %696 = call spir_func double @_Z15__spirv_ocl_madddd(double %250, double %673, double %695) #0
  %697 = add i64 %252, %345
  %698 = getelementptr inbounds double, double addrspace(1)* %0, i64 %697
  store double %696, double addrspace(1)* %698, align 8
  %699 = call spir_func double @_Z15__spirv_ocl_madddd(double %254, double %668, double 1.000000e+00) #0
  %700 = call spir_func double @_Z15__spirv_ocl_madddd(double %256, double %652, double %699) #0
  %701 = call spir_func double @_Z15__spirv_ocl_madddd(double %259, double %673, double %700) #0
  %702 = add i64 %261, %345
  %703 = getelementptr inbounds double, double addrspace(1)* %0, i64 %702
  store double %701, double addrspace(1)* %703, align 8
  %704 = call spir_func double @_Z15__spirv_ocl_madddd(double %263, double %668, double 1.000000e+00) #0
  %705 = call spir_func double @_Z15__spirv_ocl_madddd(double %265, double %652, double %704) #0
  %706 = call spir_func double @_Z15__spirv_ocl_madddd(double %268, double %673, double %705) #0
  %707 = add i64 %270, %345
  %708 = getelementptr inbounds double, double addrspace(1)* %0, i64 %707
  store double %706, double addrspace(1)* %708, align 8
  %709 = call spir_func double @_Z15__spirv_ocl_madddd(double %272, double %668, double 1.000000e+00) #0
  %710 = call spir_func double @_Z15__spirv_ocl_madddd(double %274, double %652, double %709) #0
  %711 = call spir_func double @_Z15__spirv_ocl_madddd(double %277, double %673, double %710) #0
  %712 = add i64 %279, %345
  %713 = getelementptr inbounds double, double addrspace(1)* %0, i64 %712
  store double %711, double addrspace(1)* %713, align 8
  %714 = call spir_func double @_Z15__spirv_ocl_madddd(double %281, double %668, double 1.000000e+00) #0
  %715 = call spir_func double @_Z15__spirv_ocl_madddd(double %283, double %652, double %714) #0
  %716 = call spir_func double @_Z15__spirv_ocl_madddd(double %286, double %673, double %715) #0
  %717 = add i64 %288, %345
  %718 = getelementptr inbounds double, double addrspace(1)* %0, i64 %717
  store double %716, double addrspace(1)* %718, align 8
  %719 = call spir_func double @_Z15__spirv_ocl_madddd(double %290, double %668, double 1.000000e+00) #0
  %720 = call spir_func double @_Z15__spirv_ocl_madddd(double %292, double %652, double %719) #0
  %721 = call spir_func double @_Z15__spirv_ocl_madddd(double %295, double %673, double %720) #0
  %722 = add i64 %297, %345
  %723 = getelementptr inbounds double, double addrspace(1)* %0, i64 %722
  store double %721, double addrspace(1)* %723, align 8
  %724 = call spir_func double @_Z15__spirv_ocl_madddd(double %299, double %668, double 1.000000e+00) #0
  %725 = call spir_func double @_Z15__spirv_ocl_madddd(double %301, double %652, double %724) #0
  %726 = call spir_func double @_Z15__spirv_ocl_madddd(double %304, double %673, double %725) #0
  %727 = add i64 %306, %345
  %728 = getelementptr inbounds double, double addrspace(1)* %0, i64 %727
  store double %726, double addrspace(1)* %728, align 8
  %729 = call spir_func double @_Z15__spirv_ocl_madddd(double %308, double %668, double 1.000000e+00) #0
  %730 = call spir_func double @_Z15__spirv_ocl_madddd(double %310, double %652, double %729) #0
  %731 = call spir_func double @_Z15__spirv_ocl_madddd(double %313, double %673, double %730) #0
  %732 = add i64 %315, %345
  %733 = getelementptr inbounds double, double addrspace(1)* %0, i64 %732
  store double %731, double addrspace(1)* %733, align 8
  %734 = call spir_func double @_Z15__spirv_ocl_madddd(double %317, double %668, double 1.000000e+00) #0
  %735 = call spir_func double @_Z15__spirv_ocl_madddd(double %319, double %652, double %734) #0
  %736 = call spir_func double @_Z15__spirv_ocl_madddd(double %322, double %673, double %735) #0
  %737 = add i64 %324, %345
  %738 = getelementptr inbounds double, double addrspace(1)* %0, i64 %737
  store double %736, double addrspace(1)* %738, align 8
  %739 = call spir_func double @_Z15__spirv_ocl_madddd(double %326, double %668, double 1.000000e+00) #0
  %740 = call spir_func double @_Z15__spirv_ocl_madddd(double %328, double %652, double %739) #0
  %741 = call spir_func double @_Z15__spirv_ocl_madddd(double %331, double %673, double %740) #0
  %742 = add i64 %333, %345
  %743 = getelementptr inbounds double, double addrspace(1)* %0, i64 %742
  store double %741, double addrspace(1)* %743, align 8
  %744 = call spir_func double @_Z15__spirv_ocl_madddd(double %335, double %668, double 1.000000e+00) #0
  %745 = call spir_func double @_Z15__spirv_ocl_madddd(double %337, double %652, double %744) #0
  %746 = call spir_func double @_Z15__spirv_ocl_madddd(double %340, double %673, double %745) #0
  %747 = add i64 %342, %345
  %748 = getelementptr inbounds double, double addrspace(1)* %0, i64 %747
  store double %746, double addrspace(1)* %748, align 8
  %749 = load double, double addrspace(1)* %678, align 8
  %750 = load double, double addrspace(1)* %683, align 8
  %751 = fadd double %749, %750
  %752 = load double, double addrspace(1)* %688, align 8
  %753 = fadd double %751, %752
  %754 = load double, double addrspace(1)* %693, align 8
  %755 = fadd double %753, %754
  %756 = load double, double addrspace(1)* %698, align 8
  %757 = fadd double %755, %756
  %758 = load double, double addrspace(1)* %703, align 8
  %759 = fadd double %757, %758
  %760 = load double, double addrspace(1)* %708, align 8
  %761 = fadd double %759, %760
  %762 = load double, double addrspace(1)* %713, align 8
  %763 = fadd double %761, %762
  %764 = load double, double addrspace(1)* %718, align 8
  %765 = fadd double %763, %764
  %766 = load double, double addrspace(1)* %723, align 8
  %767 = fadd double %765, %766
  %768 = load double, double addrspace(1)* %728, align 8
  %769 = fadd double %767, %768
  %770 = load double, double addrspace(1)* %733, align 8
  %771 = fadd double %769, %770
  %772 = load double, double addrspace(1)* %738, align 8
  %773 = fadd double %771, %772
  %774 = load double, double addrspace(1)* %743, align 8
  %775 = fadd double %773, %774
  %776 = fadd double %775, %746
  %777 = fmul double %749, %458
  %778 = fdiv double %777, %776
  store double %778, double addrspace(1)* %678, align 8
  %779 = load double, double addrspace(1)* %683, align 8
  %780 = fmul double %779, %458
  %781 = fdiv double %780, %776
  store double %781, double addrspace(1)* %683, align 8
  %782 = load double, double addrspace(1)* %688, align 8
  %783 = fmul double %782, %458
  %784 = fdiv double %783, %776
  store double %784, double addrspace(1)* %688, align 8
  %785 = load double, double addrspace(1)* %693, align 8
  %786 = fmul double %785, %458
  %787 = fdiv double %786, %776
  store double %787, double addrspace(1)* %693, align 8
  %788 = load double, double addrspace(1)* %698, align 8
  %789 = fmul double %788, %458
  %790 = fdiv double %789, %776
  store double %790, double addrspace(1)* %698, align 8
  %791 = load double, double addrspace(1)* %703, align 8
  %792 = fmul double %791, %458
  %793 = fdiv double %792, %776
  store double %793, double addrspace(1)* %703, align 8
  %794 = load double, double addrspace(1)* %708, align 8
  %795 = fmul double %794, %458
  %796 = fdiv double %795, %776
  store double %796, double addrspace(1)* %708, align 8
  %797 = load double, double addrspace(1)* %713, align 8
  %798 = fmul double %797, %458
  %799 = fdiv double %798, %776
  store double %799, double addrspace(1)* %713, align 8
  %800 = load double, double addrspace(1)* %718, align 8
  %801 = fmul double %800, %458
  %802 = fdiv double %801, %776
  store double %802, double addrspace(1)* %718, align 8
  %803 = load double, double addrspace(1)* %723, align 8
  %804 = fmul double %803, %458
  %805 = fdiv double %804, %776
  store double %805, double addrspace(1)* %723, align 8
  %806 = load double, double addrspace(1)* %728, align 8
  %807 = fmul double %806, %458
  %808 = fdiv double %807, %776
  store double %808, double addrspace(1)* %728, align 8
  %809 = load double, double addrspace(1)* %733, align 8
  %810 = fmul double %809, %458
  %811 = fdiv double %810, %776
  store double %811, double addrspace(1)* %733, align 8
  %812 = load double, double addrspace(1)* %738, align 8
  %813 = fmul double %812, %458
  %814 = fdiv double %813, %776
  store double %814, double addrspace(1)* %738, align 8
  %815 = load double, double addrspace(1)* %743, align 8
  %816 = fmul double %815, %458
  %817 = fdiv double %816, %776
  store double %817, double addrspace(1)* %743, align 8
  %818 = load double, double addrspace(1)* %748, align 8
  %819 = fmul double %818, %458
  %820 = fdiv double %819, %776
  store double %820, double addrspace(1)* %748, align 8
  %821 = add i64 %344, 17
  br label %822

822:                                              ; preds = %822, %393
  %823 = phi i32 [ 0, %393 ], [ %841, %822 ]
  %824 = phi double [ 0.000000e+00, %393 ], [ %840, %822 ]
  %825 = phi double [ 0.000000e+00, %393 ], [ %837, %822 ]
  %826 = phi double [ 0.000000e+00, %393 ], [ %834, %822 ]
  %827 = sext i32 %823 to i64
  %828 = mul i64 %827, %3
  %829 = mul i64 %828, %4
  %830 = add i64 %829, %821
  %831 = add i64 %830, 2
  %832 = getelementptr inbounds double, double addrspace(1)* %0, i64 %831
  %833 = load double, double addrspace(1)* %832, align 8
  %834 = fadd double %826, %833
  %835 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 %827
  %836 = load double, double addrspace(1)* %835, align 8
  %837 = call spir_func double @_Z15__spirv_ocl_madddd(double %836, double %833, double %825) #0
  %838 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 %827
  %839 = load double, double addrspace(1)* %838, align 8
  %840 = call spir_func double @_Z15__spirv_ocl_madddd(double %839, double %833, double %824) #0
  %841 = add nuw nsw i32 %823, 1
  %842 = icmp eq i32 %841, 37
  br i1 %842, label %843, label %822

843:                                              ; preds = %822
  %844 = fdiv double 1.000000e+00, %834
  %845 = fmul double %837, %844
  %846 = fmul double %840, %844
  br label %847

847:                                              ; preds = %847, %843
  %848 = phi i32 [ 0, %843 ], [ %867, %847 ]
  %849 = phi double [ 0.000000e+00, %843 ], [ %866, %847 ]
  %850 = sext i32 %848 to i64
  %851 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 %850
  %852 = load double, double addrspace(1)* %851, align 8
  %853 = fsub double %852, %845
  %854 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 %850
  %855 = load double, double addrspace(1)* %854, align 8
  %856 = fsub double %855, %846
  %857 = fmul double %856, %856
  %858 = call spir_func double @_Z15__spirv_ocl_madddd(double %853, double %853, double %857) #0
  %859 = fmul double %858, 5.000000e-01
  %860 = mul i64 %850, %3
  %861 = mul i64 %860, %4
  %862 = add i64 %861, %821
  %863 = add i64 %862, 2
  %864 = getelementptr inbounds double, double addrspace(1)* %0, i64 %863
  %865 = load double, double addrspace(1)* %864, align 8
  %866 = call spir_func double @_Z15__spirv_ocl_madddd(double %859, double %865, double %849) #0
  %867 = add nuw nsw i32 %848, 1
  %868 = icmp eq i32 %867, 37
  br i1 %868, label %869, label %847

869:                                              ; preds = %847
  %870 = fmul double %834, 0xBEC23E3A5A7D3718
  %871 = fmul double %866, %844
  %872 = call spir_func double @_Z15__spirv_ocl_madddd(double %870, double %870, double 0.000000e+00) #0
  %873 = fmul double %872, %844
  %874 = fmul double %873, %844
  %875 = fmul double %874, 1.250000e-01
  %876 = fadd double %871, %875
  %877 = add i64 %21, %821
  %878 = getelementptr inbounds double, double addrspace(1)* %2, i64 %877
  %879 = load double, double addrspace(1)* %878, align 8
  %880 = add i64 %23, %821
  %881 = getelementptr inbounds double, double addrspace(1)* %2, i64 %880
  %882 = load double, double addrspace(1)* %881, align 8
  %883 = fadd double %879, %882
  %884 = add i64 %25, %821
  %885 = getelementptr inbounds double, double addrspace(1)* %2, i64 %884
  %886 = load double, double addrspace(1)* %885, align 8
  %887 = fadd double %883, %886
  %888 = add i64 %27, %821
  %889 = getelementptr inbounds double, double addrspace(1)* %2, i64 %888
  %890 = load double, double addrspace(1)* %889, align 8
  %891 = fadd double %887, %890
  %892 = add i64 %29, %821
  %893 = getelementptr inbounds double, double addrspace(1)* %2, i64 %892
  %894 = load double, double addrspace(1)* %893, align 8
  %895 = fadd double %891, %894
  %896 = add i64 %31, %821
  %897 = getelementptr inbounds double, double addrspace(1)* %2, i64 %896
  %898 = load double, double addrspace(1)* %897, align 8
  %899 = fadd double %895, %898
  %900 = add i64 %33, %821
  %901 = getelementptr inbounds double, double addrspace(1)* %2, i64 %900
  %902 = load double, double addrspace(1)* %901, align 8
  %903 = fadd double %899, %902
  %904 = add i64 %35, %821
  %905 = getelementptr inbounds double, double addrspace(1)* %2, i64 %904
  %906 = load double, double addrspace(1)* %905, align 8
  %907 = fadd double %903, %906
  %908 = add i64 %342, %821
  %909 = getelementptr inbounds double, double addrspace(1)* %0, i64 %908
  %910 = load double, double addrspace(1)* %909, align 8
  %911 = fadd double %907, %910
  %912 = add i64 %324, %821
  %913 = getelementptr inbounds double, double addrspace(1)* %0, i64 %912
  %914 = load double, double addrspace(1)* %913, align 8
  %915 = fadd double %911, %914
  %916 = add i64 %270, %821
  %917 = getelementptr inbounds double, double addrspace(1)* %0, i64 %916
  %918 = load double, double addrspace(1)* %917, align 8
  %919 = fadd double %915, %918
  %920 = add i64 %216, %821
  %921 = getelementptr inbounds double, double addrspace(1)* %0, i64 %920
  %922 = load double, double addrspace(1)* %921, align 8
  %923 = fadd double %919, %922
  %924 = add i64 %243, %821
  %925 = getelementptr inbounds double, double addrspace(1)* %0, i64 %924
  %926 = load double, double addrspace(1)* %925, align 8
  %927 = fadd double %923, %926
  %928 = add i64 %306, %821
  %929 = getelementptr inbounds double, double addrspace(1)* %0, i64 %928
  %930 = load double, double addrspace(1)* %929, align 8
  %931 = fadd double %927, %930
  %932 = add i64 %333, %821
  %933 = getelementptr inbounds double, double addrspace(1)* %0, i64 %932
  %934 = load double, double addrspace(1)* %933, align 8
  %935 = fadd double %931, %934
  %936 = add i64 %49, %821
  %937 = getelementptr inbounds double, double addrspace(1)* %0, i64 %936
  %938 = load double, double addrspace(1)* %937, align 8
  %939 = fadd double %935, %938
  %940 = add i64 %51, %821
  %941 = getelementptr inbounds double, double addrspace(1)* %0, i64 %940
  %942 = load double, double addrspace(1)* %941, align 8
  %943 = fadd double %939, %942
  %944 = add i64 %53, %821
  %945 = getelementptr inbounds double, double addrspace(1)* %0, i64 %944
  %946 = load double, double addrspace(1)* %945, align 8
  %947 = fadd double %943, %946
  %948 = add i64 %55, %821
  %949 = getelementptr inbounds double, double addrspace(1)* %0, i64 %948
  %950 = load double, double addrspace(1)* %949, align 8
  %951 = fadd double %947, %950
  %952 = add i64 %57, %821
  %953 = getelementptr inbounds double, double addrspace(1)* %0, i64 %952
  %954 = load double, double addrspace(1)* %953, align 8
  %955 = fadd double %951, %954
  %956 = add i64 %58, %821
  %957 = getelementptr inbounds double, double addrspace(1)* %0, i64 %956
  %958 = load double, double addrspace(1)* %957, align 8
  %959 = fadd double %955, %958
  %960 = add i64 %37, %821
  %961 = getelementptr inbounds double, double addrspace(1)* %0, i64 %960
  %962 = load double, double addrspace(1)* %961, align 8
  %963 = fadd double %959, %962
  %964 = add i64 %39, %821
  %965 = getelementptr inbounds double, double addrspace(1)* %0, i64 %964
  %966 = load double, double addrspace(1)* %965, align 8
  %967 = fadd double %963, %966
  %968 = add i64 %41, %821
  %969 = getelementptr inbounds double, double addrspace(1)* %0, i64 %968
  %970 = load double, double addrspace(1)* %969, align 8
  %971 = fadd double %967, %970
  %972 = add i64 %43, %821
  %973 = getelementptr inbounds double, double addrspace(1)* %0, i64 %972
  %974 = load double, double addrspace(1)* %973, align 8
  %975 = fadd double %971, %974
  %976 = add i64 %45, %821
  %977 = getelementptr inbounds double, double addrspace(1)* %0, i64 %976
  %978 = load double, double addrspace(1)* %977, align 8
  %979 = fadd double %975, %978
  %980 = add i64 %47, %821
  %981 = getelementptr inbounds double, double addrspace(1)* %0, i64 %980
  %982 = load double, double addrspace(1)* %981, align 8
  %983 = fadd double %979, %982
  %984 = getelementptr inbounds double, double addrspace(1)* %0, i64 %821
  %985 = load double, double addrspace(1)* %984, align 8
  %986 = fadd double %983, %985
  %987 = getelementptr inbounds double, double addrspace(1)* %0, i64 %888
  %988 = load double, double addrspace(1)* %987, align 8
  %989 = fadd double %986, %988
  %990 = getelementptr inbounds double, double addrspace(1)* %0, i64 %892
  %991 = load double, double addrspace(1)* %990, align 8
  %992 = fadd double %989, %991
  %993 = getelementptr inbounds double, double addrspace(1)* %0, i64 %896
  %994 = load double, double addrspace(1)* %993, align 8
  %995 = fadd double %992, %994
  %996 = getelementptr inbounds double, double addrspace(1)* %0, i64 %900
  %997 = load double, double addrspace(1)* %996, align 8
  %998 = fadd double %995, %997
  %999 = getelementptr inbounds double, double addrspace(1)* %0, i64 %904
  %1000 = load double, double addrspace(1)* %999, align 8
  %1001 = fadd double %998, %1000
  %1002 = getelementptr inbounds double, double addrspace(1)* %0, i64 %880
  %1003 = load double, double addrspace(1)* %1002, align 8
  %1004 = fadd double %1001, %1003
  %1005 = getelementptr inbounds double, double addrspace(1)* %0, i64 %877
  %1006 = load double, double addrspace(1)* %1005, align 8
  %1007 = fadd double %1004, %1006
  %1008 = getelementptr inbounds double, double addrspace(1)* %0, i64 %884
  %1009 = load double, double addrspace(1)* %1008, align 8
  %1010 = fadd double %1007, %1009
  %1011 = add i64 %60, %821
  %1012 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1011
  %1013 = load double, double addrspace(1)* %1012, align 8
  %1014 = fadd double %1010, %1013
  %1015 = fmul double %1014, 0.000000e+00
  %1016 = fmul double %1014, 0xBEB5D62B1A5FFD97
  %1017 = fdiv double %1016, 0xBFF326D4427CFD50
  %1018 = call spir_func double @_Z15__spirv_ocl_madddd(double %1014, double 0.000000e+00, double %1017) #0
  %1019 = fmul double %1018, %1018
  %1020 = call spir_func double @_Z15__spirv_ocl_madddd(double %1015, double %1015, double %1019) #0
  %1021 = fmul double %1020, 5.000000e-01
  %1022 = fdiv double %1021, %1014
  %1023 = call spir_func double @_Z15__spirv_ocl_madddd(double %876, double %1014, double %1022) #0
  %1024 = fmul double %317, %914
  %1025 = call spir_func double @_Z15__spirv_ocl_madddd(double %335, double %910, double %1024) #0
  %1026 = call spir_func double @_Z15__spirv_ocl_madddd(double %263, double %918, double %1025) #0
  %1027 = call spir_func double @_Z15__spirv_ocl_madddd(double %209, double %922, double %1026) #0
  %1028 = call spir_func double @_Z15__spirv_ocl_madddd(double %236, double %926, double %1027) #0
  %1029 = call spir_func double @_Z15__spirv_ocl_madddd(double %299, double %930, double %1028) #0
  %1030 = call spir_func double @_Z15__spirv_ocl_madddd(double %326, double %934, double %1029) #0
  %1031 = call spir_func double @_Z15__spirv_ocl_madddd(double %62, double %938, double %1030) #0
  %1032 = call spir_func double @_Z15__spirv_ocl_madddd(double %64, double %942, double %1031) #0
  %1033 = call spir_func double @_Z15__spirv_ocl_madddd(double %66, double %946, double %1032) #0
  %1034 = call spir_func double @_Z15__spirv_ocl_madddd(double %68, double %950, double %1033) #0
  %1035 = call spir_func double @_Z15__spirv_ocl_madddd(double %70, double %954, double %1034) #0
  %1036 = call spir_func double @_Z15__spirv_ocl_madddd(double %72, double %958, double %1035) #0
  %1037 = call spir_func double @_Z15__spirv_ocl_madddd(double %74, double %962, double %1036) #0
  %1038 = call spir_func double @_Z15__spirv_ocl_madddd(double %76, double %966, double %1037) #0
  %1039 = call spir_func double @_Z15__spirv_ocl_madddd(double %78, double %970, double %1038) #0
  %1040 = call spir_func double @_Z15__spirv_ocl_madddd(double %80, double %974, double %1039) #0
  %1041 = call spir_func double @_Z15__spirv_ocl_madddd(double %82, double %978, double %1040) #0
  %1042 = call spir_func double @_Z15__spirv_ocl_madddd(double %84, double %982, double %1041) #0
  %1043 = call spir_func double @_Z15__spirv_ocl_madddd(double %86, double %985, double %1042) #0
  %1044 = call spir_func double @_Z15__spirv_ocl_madddd(double %88, double %988, double %1043) #0
  %1045 = call spir_func double @_Z15__spirv_ocl_madddd(double %90, double %991, double %1044) #0
  %1046 = call spir_func double @_Z15__spirv_ocl_madddd(double %92, double %994, double %1045) #0
  %1047 = call spir_func double @_Z15__spirv_ocl_madddd(double %94, double %997, double %1046) #0
  %1048 = call spir_func double @_Z15__spirv_ocl_madddd(double %96, double %1000, double %1047) #0
  %1049 = call spir_func double @_Z15__spirv_ocl_madddd(double %98, double %1003, double %1048) #0
  %1050 = call spir_func double @_Z15__spirv_ocl_madddd(double %100, double %1006, double %1049) #0
  %1051 = call spir_func double @_Z15__spirv_ocl_madddd(double %102, double %1009, double %1050) #0
  %1052 = fmul double %319, %914
  %1053 = call spir_func double @_Z15__spirv_ocl_madddd(double %337, double %910, double %1052) #0
  %1054 = call spir_func double @_Z15__spirv_ocl_madddd(double %265, double %918, double %1053) #0
  %1055 = call spir_func double @_Z15__spirv_ocl_madddd(double %211, double %922, double %1054) #0
  %1056 = call spir_func double @_Z15__spirv_ocl_madddd(double %238, double %926, double %1055) #0
  %1057 = call spir_func double @_Z15__spirv_ocl_madddd(double %301, double %930, double %1056) #0
  %1058 = call spir_func double @_Z15__spirv_ocl_madddd(double %328, double %934, double %1057) #0
  %1059 = call spir_func double @_Z15__spirv_ocl_madddd(double %104, double %938, double %1058) #0
  %1060 = call spir_func double @_Z15__spirv_ocl_madddd(double %106, double %942, double %1059) #0
  %1061 = call spir_func double @_Z15__spirv_ocl_madddd(double %108, double %946, double %1060) #0
  %1062 = call spir_func double @_Z15__spirv_ocl_madddd(double %110, double %950, double %1061) #0
  %1063 = call spir_func double @_Z15__spirv_ocl_madddd(double %112, double %954, double %1062) #0
  %1064 = call spir_func double @_Z15__spirv_ocl_madddd(double %114, double %958, double %1063) #0
  %1065 = call spir_func double @_Z15__spirv_ocl_madddd(double %116, double %962, double %1064) #0
  %1066 = call spir_func double @_Z15__spirv_ocl_madddd(double %118, double %966, double %1065) #0
  %1067 = call spir_func double @_Z15__spirv_ocl_madddd(double %120, double %970, double %1066) #0
  %1068 = call spir_func double @_Z15__spirv_ocl_madddd(double %122, double %974, double %1067) #0
  %1069 = call spir_func double @_Z15__spirv_ocl_madddd(double %124, double %978, double %1068) #0
  %1070 = call spir_func double @_Z15__spirv_ocl_madddd(double %126, double %982, double %1069) #0
  %1071 = call spir_func double @_Z15__spirv_ocl_madddd(double %128, double %985, double %1070) #0
  %1072 = call spir_func double @_Z15__spirv_ocl_madddd(double %130, double %988, double %1071) #0
  %1073 = call spir_func double @_Z15__spirv_ocl_madddd(double %132, double %991, double %1072) #0
  %1074 = call spir_func double @_Z15__spirv_ocl_madddd(double %134, double %994, double %1073) #0
  %1075 = call spir_func double @_Z15__spirv_ocl_madddd(double %136, double %997, double %1074) #0
  %1076 = call spir_func double @_Z15__spirv_ocl_madddd(double %138, double %1000, double %1075) #0
  %1077 = call spir_func double @_Z15__spirv_ocl_madddd(double %140, double %1003, double %1076) #0
  %1078 = call spir_func double @_Z15__spirv_ocl_madddd(double %142, double %1006, double %1077) #0
  %1079 = call spir_func double @_Z15__spirv_ocl_madddd(double %144, double %1009, double %1078) #0
  %1080 = fmul double %322, %914
  %1081 = call spir_func double @_Z15__spirv_ocl_madddd(double %340, double %910, double %1080) #0
  %1082 = call spir_func double @_Z15__spirv_ocl_madddd(double %268, double %918, double %1081) #0
  %1083 = call spir_func double @_Z15__spirv_ocl_madddd(double %214, double %922, double %1082) #0
  %1084 = call spir_func double @_Z15__spirv_ocl_madddd(double %241, double %926, double %1083) #0
  %1085 = call spir_func double @_Z15__spirv_ocl_madddd(double %304, double %930, double %1084) #0
  %1086 = call spir_func double @_Z15__spirv_ocl_madddd(double %331, double %934, double %1085) #0
  %1087 = call spir_func double @_Z15__spirv_ocl_madddd(double %147, double %938, double %1086) #0
  %1088 = call spir_func double @_Z15__spirv_ocl_madddd(double %150, double %942, double %1087) #0
  %1089 = call spir_func double @_Z15__spirv_ocl_madddd(double %153, double %946, double %1088) #0
  %1090 = call spir_func double @_Z15__spirv_ocl_madddd(double %156, double %950, double %1089) #0
  %1091 = call spir_func double @_Z15__spirv_ocl_madddd(double %159, double %954, double %1090) #0
  %1092 = call spir_func double @_Z15__spirv_ocl_madddd(double %162, double %958, double %1091) #0
  %1093 = call spir_func double @_Z15__spirv_ocl_madddd(double %165, double %962, double %1092) #0
  %1094 = call spir_func double @_Z15__spirv_ocl_madddd(double %168, double %966, double %1093) #0
  %1095 = call spir_func double @_Z15__spirv_ocl_madddd(double %171, double %970, double %1094) #0
  %1096 = call spir_func double @_Z15__spirv_ocl_madddd(double %174, double %974, double %1095) #0
  %1097 = call spir_func double @_Z15__spirv_ocl_madddd(double %177, double %978, double %1096) #0
  %1098 = call spir_func double @_Z15__spirv_ocl_madddd(double %180, double %982, double %1097) #0
  %1099 = call spir_func double @_Z15__spirv_ocl_madddd(double %183, double %985, double %1098) #0
  %1100 = call spir_func double @_Z15__spirv_ocl_madddd(double %186, double %988, double %1099) #0
  %1101 = call spir_func double @_Z15__spirv_ocl_madddd(double %189, double %991, double %1100) #0
  %1102 = call spir_func double @_Z15__spirv_ocl_madddd(double %192, double %994, double %1101) #0
  %1103 = call spir_func double @_Z15__spirv_ocl_madddd(double %195, double %997, double %1102) #0
  %1104 = call spir_func double @_Z15__spirv_ocl_madddd(double %198, double %1000, double %1103) #0
  %1105 = call spir_func double @_Z15__spirv_ocl_madddd(double %201, double %1003, double %1104) #0
  %1106 = call spir_func double @_Z15__spirv_ocl_madddd(double %204, double %1006, double %1105) #0
  %1107 = call spir_func double @_Z15__spirv_ocl_madddd(double %207, double %1009, double %1106) #0
  %1108 = fsub double %1015, %1051
  %1109 = fmul double %1108, 1.900000e+01
  %1110 = fmul double %1109, 0x3FF326D4427CFD50
  %1111 = fmul double %907, -1.200000e+01
  %1112 = fmul double %1111, 0x3FF326D4427CFD50
  %1113 = fmul double %1112, 0x3FF326D4427CFD50
  %1114 = fmul double %1108, 2.950000e+01
  %1115 = fmul double %1114, 0x3FF326D4427CFD50
  %1116 = fmul double %1115, 0x3FF326D4427CFD50
  %1117 = fmul double %1108, 8.000000e+00
  %1118 = fsub double %1018, %1079
  %1119 = fmul double %1118, 1.900000e+01
  %1120 = fmul double %907, 4.700000e+01
  %1121 = fmul double %1120, 0x3FF326D4427CFD50
  %1122 = fmul double %1121, 0xBFF326D4427CFD50
  %1123 = call spir_func double @_Z15__spirv_ocl_madddd(double %1119, double 0x3FF326D4427CFD50, double %1122) #0
  %1124 = fmul double %1118, 2.950000e+01
  %1125 = fmul double %1124, 0x3FF326D4427CFD50
  %1126 = fmul double %907, 7.350000e+01
  %1127 = fmul double %1126, 0x3FF326D4427CFD50
  %1128 = fmul double %1127, 0x3FF326D4427CFD50
  %1129 = fmul double %1128, 0xBFF326D4427CFD50
  %1130 = call spir_func double @_Z15__spirv_ocl_madddd(double %1125, double 0x3FF326D4427CFD50, double %1129) #0
  %1131 = fmul double %907, 1.900000e+01
  %1132 = fmul double %1131, 0xBFF326D4427CFD50
  %1133 = call spir_func double @_Z15__spirv_ocl_madddd(double %1118, double 8.000000e+00, double %1132) #0
  %1134 = fsub double %1023, %1107
  %1135 = fmul double %1134, 1.900000e+01
  %1136 = call spir_func double @_Z15__spirv_ocl_madddd(double %1135, double 0x3FF326D4427CFD50, double %1129) #0
  %1137 = fmul double %1134, 2.950000e+01
  %1138 = fmul double %1137, 0x3FF326D4427CFD50
  %1139 = fmul double %907, 0x3FF326D4427CFD50
  %1140 = fmul double %1139, 0x3FF326D4427CFD50
  %1141 = fmul double %1140, 0x3FF326D4427CFD50
  %1142 = fmul double %1141, 0x3FF326D4427CFD50
  %1143 = fmul double %1142, 4.750000e+02
  %1144 = fmul double %1143, -2.500000e-01
  %1145 = call spir_func double @_Z15__spirv_ocl_madddd(double %1138, double 0x3FF326D4427CFD50, double %1144) #0
  %1146 = fmul double %907, 2.950000e+01
  %1147 = fmul double %1146, 0x3FF326D4427CFD50
  %1148 = fmul double %1147, 0xBFF326D4427CFD50
  %1149 = call spir_func double @_Z15__spirv_ocl_madddd(double %1134, double 8.000000e+00, double %1148) #0
  %1150 = fneg double %1145
  %1151 = fmul double %1130, %1149
  %1152 = call spir_func double @_Z15__spirv_ocl_madddd(double %1150, double %1133, double %1151) #0
  %1153 = fneg double %1136
  %1154 = fmul double %1123, %1145
  %1155 = call spir_func double @_Z15__spirv_ocl_madddd(double %1153, double %1130, double %1154) #0
  %1156 = fdiv double %1152, %1155
  %1157 = fneg double %1123
  %1158 = fmul double %1116, %1157
  %1159 = fmul double %1158, %1149
  %1160 = call spir_func double @_Z15__spirv_ocl_madddd(double %1154, double %1117, double %1159) #0
  %1161 = fmul double %1130, %1153
  %1162 = call spir_func double @_Z15__spirv_ocl_madddd(double %1161, double %1117, double %1160) #0
  %1163 = fmul double %1110, %1150
  %1164 = call spir_func double @_Z15__spirv_ocl_madddd(double %1163, double %1133, double %1162) #0
  %1165 = fmul double %1116, %1136
  %1166 = call spir_func double @_Z15__spirv_ocl_madddd(double %1165, double %1133, double %1164) #0
  %1167 = fmul double %1110, %1130
  %1168 = call spir_func double @_Z15__spirv_ocl_madddd(double %1167, double %1149, double %1166) #0
  %1169 = fneg double %1154
  %1170 = call spir_func double @_Z15__spirv_ocl_madddd(double %1136, double %1130, double %1169) #0
  %1171 = fmul double %1113, %1170
  %1172 = fdiv double %1168, %1171
  %1173 = fmul double %1123, %1149
  %1174 = call spir_func double @_Z15__spirv_ocl_madddd(double %1153, double %1133, double %1173) #0
  %1175 = fmul double %1145, %1157
  %1176 = call spir_func double @_Z15__spirv_ocl_madddd(double %1136, double %1130, double %1175) #0
  %1177 = fdiv double %1174, %1176
  %1178 = call spir_func double @_Z15__spirv_ocl_madddd(double %218, double %1172, double 1.000000e+00) #0
  %1179 = call spir_func double @_Z15__spirv_ocl_madddd(double %220, double %1156, double %1178) #0
  %1180 = call spir_func double @_Z15__spirv_ocl_madddd(double %223, double %1177, double %1179) #0
  %1181 = add i64 %225, %821
  %1182 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1181
  store double %1180, double addrspace(1)* %1182, align 8
  %1183 = call spir_func double @_Z15__spirv_ocl_madddd(double %227, double %1172, double 1.000000e+00) #0
  %1184 = call spir_func double @_Z15__spirv_ocl_madddd(double %229, double %1156, double %1183) #0
  %1185 = call spir_func double @_Z15__spirv_ocl_madddd(double %232, double %1177, double %1184) #0
  %1186 = add i64 %234, %821
  %1187 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1186
  store double %1185, double addrspace(1)* %1187, align 8
  %1188 = call spir_func double @_Z15__spirv_ocl_madddd(double %245, double %1172, double 1.000000e+00) #0
  %1189 = call spir_func double @_Z15__spirv_ocl_madddd(double %247, double %1156, double %1188) #0
  %1190 = call spir_func double @_Z15__spirv_ocl_madddd(double %250, double %1177, double %1189) #0
  %1191 = add i64 %252, %821
  %1192 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1191
  store double %1190, double addrspace(1)* %1192, align 8
  %1193 = call spir_func double @_Z15__spirv_ocl_madddd(double %254, double %1172, double 1.000000e+00) #0
  %1194 = call spir_func double @_Z15__spirv_ocl_madddd(double %256, double %1156, double %1193) #0
  %1195 = call spir_func double @_Z15__spirv_ocl_madddd(double %259, double %1177, double %1194) #0
  %1196 = add i64 %261, %821
  %1197 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1196
  store double %1195, double addrspace(1)* %1197, align 8
  %1198 = call spir_func double @_Z15__spirv_ocl_madddd(double %272, double %1172, double 1.000000e+00) #0
  %1199 = call spir_func double @_Z15__spirv_ocl_madddd(double %274, double %1156, double %1198) #0
  %1200 = call spir_func double @_Z15__spirv_ocl_madddd(double %277, double %1177, double %1199) #0
  %1201 = add i64 %279, %821
  %1202 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1201
  store double %1200, double addrspace(1)* %1202, align 8
  %1203 = call spir_func double @_Z15__spirv_ocl_madddd(double %281, double %1172, double 1.000000e+00) #0
  %1204 = call spir_func double @_Z15__spirv_ocl_madddd(double %283, double %1156, double %1203) #0
  %1205 = call spir_func double @_Z15__spirv_ocl_madddd(double %286, double %1177, double %1204) #0
  %1206 = add i64 %288, %821
  %1207 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1206
  store double %1205, double addrspace(1)* %1207, align 8
  %1208 = call spir_func double @_Z15__spirv_ocl_madddd(double %290, double %1172, double 1.000000e+00) #0
  %1209 = call spir_func double @_Z15__spirv_ocl_madddd(double %292, double %1156, double %1208) #0
  %1210 = call spir_func double @_Z15__spirv_ocl_madddd(double %295, double %1177, double %1209) #0
  %1211 = add i64 %297, %821
  %1212 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1211
  store double %1210, double addrspace(1)* %1212, align 8
  %1213 = call spir_func double @_Z15__spirv_ocl_madddd(double %308, double %1172, double 1.000000e+00) #0
  %1214 = call spir_func double @_Z15__spirv_ocl_madddd(double %310, double %1156, double %1213) #0
  %1215 = call spir_func double @_Z15__spirv_ocl_madddd(double %313, double %1177, double %1214) #0
  %1216 = add i64 %315, %821
  %1217 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1216
  store double %1215, double addrspace(1)* %1217, align 8
  %1218 = load double, double addrspace(1)* %1182, align 8
  %1219 = load double, double addrspace(1)* %1187, align 8
  %1220 = fadd double %1218, %1219
  %1221 = load double, double addrspace(1)* %1192, align 8
  %1222 = fadd double %1220, %1221
  %1223 = load double, double addrspace(1)* %1197, align 8
  %1224 = fadd double %1222, %1223
  %1225 = load double, double addrspace(1)* %1202, align 8
  %1226 = fadd double %1224, %1225
  %1227 = load double, double addrspace(1)* %1207, align 8
  %1228 = fadd double %1226, %1227
  %1229 = load double, double addrspace(1)* %1212, align 8
  %1230 = fadd double %1228, %1229
  %1231 = fadd double %1230, %1215
  %1232 = fmul double %1218, %907
  %1233 = fdiv double %1232, %1231
  store double %1233, double addrspace(1)* %1182, align 8
  %1234 = load double, double addrspace(1)* %1187, align 8
  %1235 = fmul double %1234, %907
  %1236 = fdiv double %1235, %1231
  store double %1236, double addrspace(1)* %1187, align 8
  %1237 = load double, double addrspace(1)* %1192, align 8
  %1238 = fmul double %1237, %907
  %1239 = fdiv double %1238, %1231
  store double %1239, double addrspace(1)* %1192, align 8
  %1240 = load double, double addrspace(1)* %1197, align 8
  %1241 = fmul double %1240, %907
  %1242 = fdiv double %1241, %1231
  store double %1242, double addrspace(1)* %1197, align 8
  %1243 = load double, double addrspace(1)* %1202, align 8
  %1244 = fmul double %1243, %907
  %1245 = fdiv double %1244, %1231
  store double %1245, double addrspace(1)* %1202, align 8
  %1246 = load double, double addrspace(1)* %1207, align 8
  %1247 = fmul double %1246, %907
  %1248 = fdiv double %1247, %1231
  store double %1248, double addrspace(1)* %1207, align 8
  %1249 = load double, double addrspace(1)* %1212, align 8
  %1250 = fmul double %1249, %907
  %1251 = fdiv double %1250, %1231
  store double %1251, double addrspace(1)* %1212, align 8
  %1252 = load double, double addrspace(1)* %1217, align 8
  %1253 = fmul double %1252, %907
  %1254 = fdiv double %1253, %1231
  store double %1254, double addrspace(1)* %1217, align 8
  %1255 = add i64 %344, 18
  br label %1256

1256:                                             ; preds = %1256, %869
  %1257 = phi i32 [ 0, %869 ], [ %1275, %1256 ]
  %1258 = phi double [ 0.000000e+00, %869 ], [ %1274, %1256 ]
  %1259 = phi double [ 0.000000e+00, %869 ], [ %1271, %1256 ]
  %1260 = phi double [ 0.000000e+00, %869 ], [ %1268, %1256 ]
  %1261 = sext i32 %1257 to i64
  %1262 = mul i64 %1261, %3
  %1263 = mul i64 %1262, %4
  %1264 = add i64 %1263, %1255
  %1265 = add i64 %1264, 1
  %1266 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1265
  %1267 = load double, double addrspace(1)* %1266, align 8
  %1268 = fadd double %1260, %1267
  %1269 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 %1261
  %1270 = load double, double addrspace(1)* %1269, align 8
  %1271 = call spir_func double @_Z15__spirv_ocl_madddd(double %1270, double %1267, double %1259) #0
  %1272 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 %1261
  %1273 = load double, double addrspace(1)* %1272, align 8
  %1274 = call spir_func double @_Z15__spirv_ocl_madddd(double %1273, double %1267, double %1258) #0
  %1275 = add nuw nsw i32 %1257, 1
  %1276 = icmp eq i32 %1275, 37
  br i1 %1276, label %1277, label %1256

1277:                                             ; preds = %1256
  %1278 = fdiv double 1.000000e+00, %1268
  %1279 = fmul double %1271, %1278
  %1280 = fmul double %1274, %1278
  br label %1281

1281:                                             ; preds = %1281, %1277
  %1282 = phi i32 [ 0, %1277 ], [ %1301, %1281 ]
  %1283 = phi double [ 0.000000e+00, %1277 ], [ %1300, %1281 ]
  %1284 = sext i32 %1282 to i64
  %1285 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 1, i64 %1284
  %1286 = load double, double addrspace(1)* %1285, align 8
  %1287 = fsub double %1286, %1279
  %1288 = getelementptr inbounds %struct.par_t, %struct.par_t addrspace(1)* %1, i64 0, i32 2, i64 %1284
  %1289 = load double, double addrspace(1)* %1288, align 8
  %1290 = fsub double %1289, %1280
  %1291 = fmul double %1290, %1290
  %1292 = call spir_func double @_Z15__spirv_ocl_madddd(double %1287, double %1287, double %1291) #0
  %1293 = fmul double %1292, 5.000000e-01
  %1294 = mul i64 %1284, %3
  %1295 = mul i64 %1294, %4
  %1296 = add i64 %1295, %1255
  %1297 = add i64 %1296, 1
  %1298 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1297
  %1299 = load double, double addrspace(1)* %1298, align 8
  %1300 = call spir_func double @_Z15__spirv_ocl_madddd(double %1293, double %1299, double %1283) #0
  %1301 = add nuw nsw i32 %1282, 1
  %1302 = icmp eq i32 %1301, 37
  br i1 %1302, label %1303, label %1281

1303:                                             ; preds = %1281
  %1304 = fmul double %1268, 0xBEC23E3A5A7D3718
  %1305 = fmul double %1300, %1278
  %1306 = call spir_func double @_Z15__spirv_ocl_madddd(double %1304, double %1304, double 0.000000e+00) #0
  %1307 = fmul double %1306, %1278
  %1308 = fmul double %1307, %1278
  %1309 = fmul double %1308, 1.250000e-01
  %1310 = fadd double %1305, %1309
  %1311 = add i64 %315, %1255
  %1312 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1311
  %1313 = load double, double addrspace(1)* %1312, align 8
  %1314 = add i64 %279, %1255
  %1315 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1314
  %1316 = load double, double addrspace(1)* %1315, align 8
  %1317 = fmul double %274, %1316
  %1318 = call spir_func double @_Z15__spirv_ocl_madddd(double %310, double %1313, double %1317) #0
  %1319 = add i64 %225, %1255
  %1320 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1319
  %1321 = load double, double addrspace(1)* %1320, align 8
  %1322 = call spir_func double @_Z15__spirv_ocl_madddd(double %220, double %1321, double %1318) #0
  %1323 = add i64 %252, %1255
  %1324 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1323
  %1325 = load double, double addrspace(1)* %1324, align 8
  %1326 = call spir_func double @_Z15__spirv_ocl_madddd(double %247, double %1325, double %1322) #0
  %1327 = add i64 %297, %1255
  %1328 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1327
  %1329 = load double, double addrspace(1)* %1328, align 8
  %1330 = call spir_func double @_Z15__spirv_ocl_madddd(double %292, double %1329, double %1326) #0
  %1331 = add i64 %342, %1255
  %1332 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1331
  %1333 = load double, double addrspace(1)* %1332, align 8
  %1334 = call spir_func double @_Z15__spirv_ocl_madddd(double %337, double %1333, double %1330) #0
  %1335 = add i64 %324, %1255
  %1336 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1335
  %1337 = load double, double addrspace(1)* %1336, align 8
  %1338 = call spir_func double @_Z15__spirv_ocl_madddd(double %319, double %1337, double %1334) #0
  %1339 = add i64 %270, %1255
  %1340 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1339
  %1341 = load double, double addrspace(1)* %1340, align 8
  %1342 = call spir_func double @_Z15__spirv_ocl_madddd(double %265, double %1341, double %1338) #0
  %1343 = add i64 %216, %1255
  %1344 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1343
  %1345 = load double, double addrspace(1)* %1344, align 8
  %1346 = call spir_func double @_Z15__spirv_ocl_madddd(double %211, double %1345, double %1342) #0
  %1347 = add i64 %243, %1255
  %1348 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1347
  %1349 = load double, double addrspace(1)* %1348, align 8
  %1350 = call spir_func double @_Z15__spirv_ocl_madddd(double %238, double %1349, double %1346) #0
  %1351 = add i64 %306, %1255
  %1352 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1351
  %1353 = load double, double addrspace(1)* %1352, align 8
  %1354 = call spir_func double @_Z15__spirv_ocl_madddd(double %301, double %1353, double %1350) #0
  %1355 = add i64 %333, %1255
  %1356 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1355
  %1357 = load double, double addrspace(1)* %1356, align 8
  %1358 = call spir_func double @_Z15__spirv_ocl_madddd(double %328, double %1357, double %1354) #0
  %1359 = add i64 %49, %1255
  %1360 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1359
  %1361 = load double, double addrspace(1)* %1360, align 8
  %1362 = call spir_func double @_Z15__spirv_ocl_madddd(double %104, double %1361, double %1358) #0
  %1363 = add i64 %51, %1255
  %1364 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1363
  %1365 = load double, double addrspace(1)* %1364, align 8
  %1366 = call spir_func double @_Z15__spirv_ocl_madddd(double %106, double %1365, double %1362) #0
  %1367 = add i64 %53, %1255
  %1368 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1367
  %1369 = load double, double addrspace(1)* %1368, align 8
  %1370 = call spir_func double @_Z15__spirv_ocl_madddd(double %108, double %1369, double %1366) #0
  %1371 = add i64 %55, %1255
  %1372 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1371
  %1373 = load double, double addrspace(1)* %1372, align 8
  %1374 = call spir_func double @_Z15__spirv_ocl_madddd(double %110, double %1373, double %1370) #0
  %1375 = add i64 %57, %1255
  %1376 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1375
  %1377 = load double, double addrspace(1)* %1376, align 8
  %1378 = call spir_func double @_Z15__spirv_ocl_madddd(double %112, double %1377, double %1374) #0
  %1379 = add i64 %58, %1255
  %1380 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1379
  %1381 = load double, double addrspace(1)* %1380, align 8
  %1382 = call spir_func double @_Z15__spirv_ocl_madddd(double %114, double %1381, double %1378) #0
  %1383 = add i64 %37, %1255
  %1384 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1383
  %1385 = load double, double addrspace(1)* %1384, align 8
  %1386 = call spir_func double @_Z15__spirv_ocl_madddd(double %116, double %1385, double %1382) #0
  %1387 = add i64 %39, %1255
  %1388 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1387
  %1389 = load double, double addrspace(1)* %1388, align 8
  %1390 = call spir_func double @_Z15__spirv_ocl_madddd(double %118, double %1389, double %1386) #0
  %1391 = add i64 %41, %1255
  %1392 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1391
  %1393 = load double, double addrspace(1)* %1392, align 8
  %1394 = call spir_func double @_Z15__spirv_ocl_madddd(double %120, double %1393, double %1390) #0
  %1395 = add i64 %43, %1255
  %1396 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1395
  %1397 = load double, double addrspace(1)* %1396, align 8
  %1398 = call spir_func double @_Z15__spirv_ocl_madddd(double %122, double %1397, double %1394) #0
  %1399 = add i64 %45, %1255
  %1400 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1399
  %1401 = load double, double addrspace(1)* %1400, align 8
  %1402 = call spir_func double @_Z15__spirv_ocl_madddd(double %124, double %1401, double %1398) #0
  %1403 = add i64 %47, %1255
  %1404 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1403
  %1405 = load double, double addrspace(1)* %1404, align 8
  %1406 = call spir_func double @_Z15__spirv_ocl_madddd(double %126, double %1405, double %1402) #0
  %1407 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1255
  %1408 = load double, double addrspace(1)* %1407, align 8
  %1409 = call spir_func double @_Z15__spirv_ocl_madddd(double %128, double %1408, double %1406) #0
  %1410 = add i64 %27, %1255
  %1411 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1410
  %1412 = load double, double addrspace(1)* %1411, align 8
  %1413 = call spir_func double @_Z15__spirv_ocl_madddd(double %130, double %1412, double %1409) #0
  %1414 = add i64 %29, %1255
  %1415 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1414
  %1416 = load double, double addrspace(1)* %1415, align 8
  %1417 = call spir_func double @_Z15__spirv_ocl_madddd(double %132, double %1416, double %1413) #0
  %1418 = add i64 %31, %1255
  %1419 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1418
  %1420 = load double, double addrspace(1)* %1419, align 8
  %1421 = call spir_func double @_Z15__spirv_ocl_madddd(double %134, double %1420, double %1417) #0
  %1422 = add i64 %33, %1255
  %1423 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1422
  %1424 = load double, double addrspace(1)* %1423, align 8
  %1425 = call spir_func double @_Z15__spirv_ocl_madddd(double %136, double %1424, double %1421) #0
  %1426 = add i64 %35, %1255
  %1427 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1426
  %1428 = load double, double addrspace(1)* %1427, align 8
  %1429 = call spir_func double @_Z15__spirv_ocl_madddd(double %138, double %1428, double %1425) #0
  %1430 = add i64 %23, %1255
  %1431 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1430
  %1432 = load double, double addrspace(1)* %1431, align 8
  %1433 = call spir_func double @_Z15__spirv_ocl_madddd(double %140, double %1432, double %1429) #0
  %1434 = add i64 %21, %1255
  %1435 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1434
  %1436 = load double, double addrspace(1)* %1435, align 8
  %1437 = call spir_func double @_Z15__spirv_ocl_madddd(double %142, double %1436, double %1433) #0
  %1438 = add i64 %25, %1255
  %1439 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1438
  %1440 = load double, double addrspace(1)* %1439, align 8
  %1441 = call spir_func double @_Z15__spirv_ocl_madddd(double %144, double %1440, double %1437) #0
  %1442 = fadd double %1313, %1316
  %1443 = fadd double %1442, %1321
  %1444 = fadd double %1443, %1325
  %1445 = fadd double %1444, %1329
  %1446 = fadd double %1445, %1333
  %1447 = fadd double %1446, %1337
  %1448 = fadd double %1447, %1341
  %1449 = fadd double %1448, %1345
  %1450 = fadd double %1449, %1349
  %1451 = fadd double %1450, %1353
  %1452 = fadd double %1451, %1357
  %1453 = fadd double %1452, %1361
  %1454 = fadd double %1453, %1365
  %1455 = fadd double %1454, %1369
  %1456 = fadd double %1455, %1373
  %1457 = fadd double %1456, %1377
  %1458 = fadd double %1457, %1381
  %1459 = fadd double %1458, %1385
  %1460 = fadd double %1459, %1389
  %1461 = fadd double %1460, %1393
  %1462 = fadd double %1461, %1397
  %1463 = fadd double %1462, %1401
  %1464 = fadd double %1463, %1405
  %1465 = fadd double %1464, %1408
  %1466 = fadd double %1465, %1412
  %1467 = fadd double %1466, %1416
  %1468 = fadd double %1467, %1420
  %1469 = fadd double %1468, %1424
  %1470 = fadd double %1469, %1428
  %1471 = fadd double %1470, %1432
  %1472 = fadd double %1471, %1436
  %1473 = fadd double %1472, %1440
  %1474 = add i64 %60, %1255
  %1475 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1474
  %1476 = load double, double addrspace(1)* %1475, align 8
  %1477 = fadd double %1473, %1476
  %1478 = getelementptr inbounds double, double addrspace(1)* %2, i64 %1434
  %1479 = load double, double addrspace(1)* %1478, align 8
  %1480 = getelementptr inbounds double, double addrspace(1)* %2, i64 %1430
  %1481 = load double, double addrspace(1)* %1480, align 8
  %1482 = fadd double %1479, %1481
  %1483 = getelementptr inbounds double, double addrspace(1)* %2, i64 %1438
  %1484 = load double, double addrspace(1)* %1483, align 8
  %1485 = fadd double %1482, %1484
  %1486 = fadd double %1477, %1485
  %1487 = fdiv double %1441, 0xC00CBA3E63BB7BF8
  %1488 = fmul double %1486, 0xBEB23E3A5A7D3718
  %1489 = fdiv double %1488, 0x400CBA3E63BB7BF8
  %1490 = fsub double %1487, %1489
  %1491 = fsub double %1476, %1490
  %1492 = fadd double %1491, %1485
  store double %1492, double addrspace(1)* %1475, align 8
  %1493 = load double, double addrspace(1)* %1312, align 8
  %1494 = fadd double %1490, %1493
  %1495 = load double, double addrspace(1)* %1315, align 8
  %1496 = fadd double %1494, %1495
  %1497 = load double, double addrspace(1)* %1320, align 8
  %1498 = fadd double %1496, %1497
  %1499 = load double, double addrspace(1)* %1324, align 8
  %1500 = fadd double %1498, %1499
  %1501 = load double, double addrspace(1)* %1328, align 8
  %1502 = fadd double %1500, %1501
  %1503 = load double, double addrspace(1)* %1332, align 8
  %1504 = fadd double %1502, %1503
  %1505 = load double, double addrspace(1)* %1336, align 8
  %1506 = fadd double %1504, %1505
  %1507 = load double, double addrspace(1)* %1340, align 8
  %1508 = fadd double %1506, %1507
  %1509 = load double, double addrspace(1)* %1344, align 8
  %1510 = fadd double %1508, %1509
  %1511 = load double, double addrspace(1)* %1348, align 8
  %1512 = fadd double %1510, %1511
  %1513 = load double, double addrspace(1)* %1352, align 8
  %1514 = fadd double %1512, %1513
  %1515 = load double, double addrspace(1)* %1356, align 8
  %1516 = fadd double %1514, %1515
  %1517 = load double, double addrspace(1)* %1360, align 8
  %1518 = fadd double %1516, %1517
  %1519 = load double, double addrspace(1)* %1364, align 8
  %1520 = fadd double %1518, %1519
  %1521 = load double, double addrspace(1)* %1368, align 8
  %1522 = fadd double %1520, %1521
  %1523 = load double, double addrspace(1)* %1372, align 8
  %1524 = fadd double %1522, %1523
  %1525 = load double, double addrspace(1)* %1376, align 8
  %1526 = fadd double %1524, %1525
  %1527 = load double, double addrspace(1)* %1380, align 8
  %1528 = fadd double %1526, %1527
  %1529 = load double, double addrspace(1)* %1384, align 8
  %1530 = fadd double %1528, %1529
  %1531 = load double, double addrspace(1)* %1388, align 8
  %1532 = fadd double %1530, %1531
  %1533 = load double, double addrspace(1)* %1392, align 8
  %1534 = fadd double %1532, %1533
  %1535 = load double, double addrspace(1)* %1396, align 8
  %1536 = fadd double %1534, %1535
  %1537 = load double, double addrspace(1)* %1400, align 8
  %1538 = fadd double %1536, %1537
  %1539 = load double, double addrspace(1)* %1404, align 8
  %1540 = fadd double %1538, %1539
  %1541 = load double, double addrspace(1)* %1407, align 8
  %1542 = fadd double %1540, %1541
  %1543 = load double, double addrspace(1)* %1411, align 8
  %1544 = fadd double %1542, %1543
  %1545 = load double, double addrspace(1)* %1415, align 8
  %1546 = fadd double %1544, %1545
  %1547 = load double, double addrspace(1)* %1419, align 8
  %1548 = fadd double %1546, %1547
  %1549 = load double, double addrspace(1)* %1423, align 8
  %1550 = fadd double %1548, %1549
  %1551 = load double, double addrspace(1)* %1427, align 8
  %1552 = fadd double %1550, %1551
  %1553 = load double, double addrspace(1)* %1431, align 8
  %1554 = fadd double %1552, %1553
  %1555 = load double, double addrspace(1)* %1435, align 8
  %1556 = fadd double %1554, %1555
  %1557 = load double, double addrspace(1)* %1439, align 8
  %1558 = fadd double %1556, %1557
  %1559 = fadd double %1558, %1492
  %1560 = fmul double %1559, 0.000000e+00
  %1561 = fmul double %1490, 3.000000e+00
  %1562 = fmul double %310, %1493
  %1563 = call spir_func double @_Z15__spirv_ocl_madddd(double %1561, double 0x3FF326D4427CFD50, double %1562) #0
  %1564 = call spir_func double @_Z15__spirv_ocl_madddd(double %274, double %1495, double %1563) #0
  %1565 = call spir_func double @_Z15__spirv_ocl_madddd(double %220, double %1497, double %1564) #0
  %1566 = call spir_func double @_Z15__spirv_ocl_madddd(double %247, double %1499, double %1565) #0
  %1567 = call spir_func double @_Z15__spirv_ocl_madddd(double %292, double %1501, double %1566) #0
  %1568 = call spir_func double @_Z15__spirv_ocl_madddd(double %337, double %1503, double %1567) #0
  %1569 = call spir_func double @_Z15__spirv_ocl_madddd(double %319, double %1505, double %1568) #0
  %1570 = call spir_func double @_Z15__spirv_ocl_madddd(double %265, double %1507, double %1569) #0
  %1571 = call spir_func double @_Z15__spirv_ocl_madddd(double %211, double %1509, double %1570) #0
  %1572 = call spir_func double @_Z15__spirv_ocl_madddd(double %238, double %1511, double %1571) #0
  %1573 = call spir_func double @_Z15__spirv_ocl_madddd(double %301, double %1513, double %1572) #0
  %1574 = call spir_func double @_Z15__spirv_ocl_madddd(double %328, double %1515, double %1573) #0
  %1575 = call spir_func double @_Z15__spirv_ocl_madddd(double %104, double %1517, double %1574) #0
  %1576 = call spir_func double @_Z15__spirv_ocl_madddd(double %106, double %1519, double %1575) #0
  %1577 = call spir_func double @_Z15__spirv_ocl_madddd(double %108, double %1521, double %1576) #0
  %1578 = call spir_func double @_Z15__spirv_ocl_madddd(double %110, double %1523, double %1577) #0
  %1579 = call spir_func double @_Z15__spirv_ocl_madddd(double %112, double %1525, double %1578) #0
  %1580 = call spir_func double @_Z15__spirv_ocl_madddd(double %114, double %1527, double %1579) #0
  %1581 = call spir_func double @_Z15__spirv_ocl_madddd(double %116, double %1529, double %1580) #0
  %1582 = call spir_func double @_Z15__spirv_ocl_madddd(double %118, double %1531, double %1581) #0
  %1583 = call spir_func double @_Z15__spirv_ocl_madddd(double %120, double %1533, double %1582) #0
  %1584 = call spir_func double @_Z15__spirv_ocl_madddd(double %122, double %1535, double %1583) #0
  %1585 = call spir_func double @_Z15__spirv_ocl_madddd(double %124, double %1537, double %1584) #0
  %1586 = call spir_func double @_Z15__spirv_ocl_madddd(double %126, double %1539, double %1585) #0
  %1587 = call spir_func double @_Z15__spirv_ocl_madddd(double %128, double %1541, double %1586) #0
  %1588 = call spir_func double @_Z15__spirv_ocl_madddd(double %130, double %1543, double %1587) #0
  %1589 = call spir_func double @_Z15__spirv_ocl_madddd(double %132, double %1545, double %1588) #0
  %1590 = call spir_func double @_Z15__spirv_ocl_madddd(double %134, double %1547, double %1589) #0
  %1591 = call spir_func double @_Z15__spirv_ocl_madddd(double %136, double %1549, double %1590) #0
  %1592 = call spir_func double @_Z15__spirv_ocl_madddd(double %138, double %1551, double %1591) #0
  %1593 = call spir_func double @_Z15__spirv_ocl_madddd(double %140, double %1553, double %1592) #0
  %1594 = call spir_func double @_Z15__spirv_ocl_madddd(double %142, double %1555, double %1593) #0
  %1595 = call spir_func double @_Z15__spirv_ocl_madddd(double %144, double %1557, double %1594) #0
  %1596 = fmul double %1595, %1595
  %1597 = call spir_func double @_Z15__spirv_ocl_madddd(double %1560, double %1560, double %1596) #0
  %1598 = fmul double %1597, 5.000000e-01
  %1599 = fdiv double %1598, %1559
  %1600 = call spir_func double @_Z15__spirv_ocl_madddd(double %1310, double %1559, double %1599) #0
  %1601 = fmul double %272, %1495
  %1602 = call spir_func double @_Z15__spirv_ocl_madddd(double %308, double %1493, double %1601) #0
  %1603 = call spir_func double @_Z15__spirv_ocl_madddd(double %218, double %1497, double %1602) #0
  %1604 = call spir_func double @_Z15__spirv_ocl_madddd(double %245, double %1499, double %1603) #0
  %1605 = call spir_func double @_Z15__spirv_ocl_madddd(double %290, double %1501, double %1604) #0
  %1606 = call spir_func double @_Z15__spirv_ocl_madddd(double %335, double %1503, double %1605) #0
  %1607 = call spir_func double @_Z15__spirv_ocl_madddd(double %317, double %1505, double %1606) #0
  %1608 = call spir_func double @_Z15__spirv_ocl_madddd(double %263, double %1507, double %1607) #0
  %1609 = call spir_func double @_Z15__spirv_ocl_madddd(double %209, double %1509, double %1608) #0
  %1610 = call spir_func double @_Z15__spirv_ocl_madddd(double %236, double %1511, double %1609) #0
  %1611 = call spir_func double @_Z15__spirv_ocl_madddd(double %299, double %1513, double %1610) #0
  %1612 = call spir_func double @_Z15__spirv_ocl_madddd(double %326, double %1515, double %1611) #0
  %1613 = call spir_func double @_Z15__spirv_ocl_madddd(double %62, double %1517, double %1612) #0
  %1614 = call spir_func double @_Z15__spirv_ocl_madddd(double %64, double %1519, double %1613) #0
  %1615 = call spir_func double @_Z15__spirv_ocl_madddd(double %66, double %1521, double %1614) #0
  %1616 = call spir_func double @_Z15__spirv_ocl_madddd(double %68, double %1523, double %1615) #0
  %1617 = call spir_func double @_Z15__spirv_ocl_madddd(double %70, double %1525, double %1616) #0
  %1618 = call spir_func double @_Z15__spirv_ocl_madddd(double %72, double %1527, double %1617) #0
  %1619 = call spir_func double @_Z15__spirv_ocl_madddd(double %74, double %1529, double %1618) #0
  %1620 = call spir_func double @_Z15__spirv_ocl_madddd(double %76, double %1531, double %1619) #0
  %1621 = call spir_func double @_Z15__spirv_ocl_madddd(double %78, double %1533, double %1620) #0
  %1622 = call spir_func double @_Z15__spirv_ocl_madddd(double %80, double %1535, double %1621) #0
  %1623 = call spir_func double @_Z15__spirv_ocl_madddd(double %82, double %1537, double %1622) #0
  %1624 = call spir_func double @_Z15__spirv_ocl_madddd(double %84, double %1539, double %1623) #0
  %1625 = call spir_func double @_Z15__spirv_ocl_madddd(double %86, double %1541, double %1624) #0
  %1626 = call spir_func double @_Z15__spirv_ocl_madddd(double %88, double %1543, double %1625) #0
  %1627 = call spir_func double @_Z15__spirv_ocl_madddd(double %90, double %1545, double %1626) #0
  %1628 = call spir_func double @_Z15__spirv_ocl_madddd(double %92, double %1547, double %1627) #0
  %1629 = call spir_func double @_Z15__spirv_ocl_madddd(double %94, double %1549, double %1628) #0
  %1630 = call spir_func double @_Z15__spirv_ocl_madddd(double %96, double %1551, double %1629) #0
  %1631 = call spir_func double @_Z15__spirv_ocl_madddd(double %98, double %1553, double %1630) #0
  %1632 = call spir_func double @_Z15__spirv_ocl_madddd(double %100, double %1555, double %1631) #0
  %1633 = call spir_func double @_Z15__spirv_ocl_madddd(double %102, double %1557, double %1632) #0
  %1634 = fmul double %277, %1495
  %1635 = call spir_func double @_Z15__spirv_ocl_madddd(double %313, double %1493, double %1634) #0
  %1636 = call spir_func double @_Z15__spirv_ocl_madddd(double %223, double %1497, double %1635) #0
  %1637 = call spir_func double @_Z15__spirv_ocl_madddd(double %250, double %1499, double %1636) #0
  %1638 = call spir_func double @_Z15__spirv_ocl_madddd(double %295, double %1501, double %1637) #0
  %1639 = call spir_func double @_Z15__spirv_ocl_madddd(double %340, double %1503, double %1638) #0
  %1640 = call spir_func double @_Z15__spirv_ocl_madddd(double %322, double %1505, double %1639) #0
  %1641 = call spir_func double @_Z15__spirv_ocl_madddd(double %268, double %1507, double %1640) #0
  %1642 = call spir_func double @_Z15__spirv_ocl_madddd(double %214, double %1509, double %1641) #0
  %1643 = call spir_func double @_Z15__spirv_ocl_madddd(double %241, double %1511, double %1642) #0
  %1644 = call spir_func double @_Z15__spirv_ocl_madddd(double %304, double %1513, double %1643) #0
  %1645 = call spir_func double @_Z15__spirv_ocl_madddd(double %331, double %1515, double %1644) #0
  %1646 = call spir_func double @_Z15__spirv_ocl_madddd(double %147, double %1517, double %1645) #0
  %1647 = call spir_func double @_Z15__spirv_ocl_madddd(double %150, double %1519, double %1646) #0
  %1648 = call spir_func double @_Z15__spirv_ocl_madddd(double %153, double %1521, double %1647) #0
  %1649 = call spir_func double @_Z15__spirv_ocl_madddd(double %156, double %1523, double %1648) #0
  %1650 = call spir_func double @_Z15__spirv_ocl_madddd(double %159, double %1525, double %1649) #0
  %1651 = call spir_func double @_Z15__spirv_ocl_madddd(double %162, double %1527, double %1650) #0
  %1652 = call spir_func double @_Z15__spirv_ocl_madddd(double %165, double %1529, double %1651) #0
  %1653 = call spir_func double @_Z15__spirv_ocl_madddd(double %168, double %1531, double %1652) #0
  %1654 = call spir_func double @_Z15__spirv_ocl_madddd(double %171, double %1533, double %1653) #0
  %1655 = call spir_func double @_Z15__spirv_ocl_madddd(double %174, double %1535, double %1654) #0
  %1656 = call spir_func double @_Z15__spirv_ocl_madddd(double %177, double %1537, double %1655) #0
  %1657 = call spir_func double @_Z15__spirv_ocl_madddd(double %180, double %1539, double %1656) #0
  %1658 = call spir_func double @_Z15__spirv_ocl_madddd(double %183, double %1541, double %1657) #0
  %1659 = call spir_func double @_Z15__spirv_ocl_madddd(double %186, double %1543, double %1658) #0
  %1660 = call spir_func double @_Z15__spirv_ocl_madddd(double %189, double %1545, double %1659) #0
  %1661 = call spir_func double @_Z15__spirv_ocl_madddd(double %192, double %1547, double %1660) #0
  %1662 = call spir_func double @_Z15__spirv_ocl_madddd(double %195, double %1549, double %1661) #0
  %1663 = call spir_func double @_Z15__spirv_ocl_madddd(double %198, double %1551, double %1662) #0
  %1664 = call spir_func double @_Z15__spirv_ocl_madddd(double %201, double %1553, double %1663) #0
  %1665 = call spir_func double @_Z15__spirv_ocl_madddd(double %204, double %1555, double %1664) #0
  %1666 = call spir_func double @_Z15__spirv_ocl_madddd(double %207, double %1557, double %1665) #0
  %1667 = fmul double %1490, -2.000000e+00
  %1668 = fmul double %1667, 0x3FF326D4427CFD50
  %1669 = fmul double %1668, 0x3FF326D4427CFD50
  %1670 = fsub double %1560, %1633
  %1671 = fmul double %1670, 1.450000e+01
  %1672 = fmul double %1671, 0x3FF326D4427CFD50
  %1673 = fmul double %1672, 0x3FF326D4427CFD50
  %1674 = fsub double %1600, %1666
  %1675 = fmul double %1674, 1.450000e+01
  %1676 = fmul double %1675, 0x3FF326D4427CFD50
  %1677 = fmul double %1490, 7.025000e+01
  %1678 = fmul double %1677, 0x3FF326D4427CFD50
  %1679 = fmul double %1678, 0x3FF326D4427CFD50
  %1680 = fmul double %1679, 0x3FF326D4427CFD50
  %1681 = fmul double %1680, 0xBFF326D4427CFD50
  %1682 = call spir_func double @_Z15__spirv_ocl_madddd(double %1676, double 0x3FF326D4427CFD50, double %1681) #0
  %1683 = fmul double %1490, 1.450000e+01
  %1684 = fmul double %1683, 0x3FF326D4427CFD50
  %1685 = fmul double %1684, 0xBFF326D4427CFD50
  %1686 = call spir_func double @_Z15__spirv_ocl_madddd(double %1674, double 3.000000e+00, double %1685) #0
  %1687 = fneg double %1686
  %1688 = fdiv double %1687, %1682
  %1689 = fmul double %1670, -3.000000e+00
  %1690 = fmul double %1682, %1689
  %1691 = call spir_func double @_Z15__spirv_ocl_madddd(double %1673, double %1686, double %1690) #0
  %1692 = fmul double %1669, %1682
  %1693 = fdiv double %1691, %1692
  %1694 = call spir_func double @_Z15__spirv_ocl_madddd(double %227, double %1693, double 1.000000e+00) #0
  %1695 = call spir_func double @_Z15__spirv_ocl_madddd(double %232, double %1688, double %1694) #0
  %1696 = add i64 %234, %1255
  %1697 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1696
  store double %1695, double addrspace(1)* %1697, align 8
  %1698 = call spir_func double @_Z15__spirv_ocl_madddd(double %254, double %1693, double 1.000000e+00) #0
  %1699 = call spir_func double @_Z15__spirv_ocl_madddd(double %259, double %1688, double %1698) #0
  %1700 = add i64 %261, %1255
  %1701 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1700
  store double %1699, double addrspace(1)* %1701, align 8
  %1702 = call spir_func double @_Z15__spirv_ocl_madddd(double %281, double %1693, double 1.000000e+00) #0
  %1703 = call spir_func double @_Z15__spirv_ocl_madddd(double %286, double %1688, double %1702) #0
  %1704 = add i64 %288, %1255
  %1705 = getelementptr inbounds double, double addrspace(1)* %0, i64 %1704
  store double %1703, double addrspace(1)* %1705, align 8
  %1706 = load double, double addrspace(1)* %1697, align 8
  %1707 = load double, double addrspace(1)* %1701, align 8
  %1708 = fadd double %1706, %1707
  %1709 = fadd double %1708, %1703
  %1710 = fmul double %1706, %1490
  %1711 = fdiv double %1710, %1709
  store double %1711, double addrspace(1)* %1697, align 8
  %1712 = load double, double addrspace(1)* %1701, align 8
  %1713 = fmul double %1712, %1490
  %1714 = fdiv double %1713, %1709
  store double %1714, double addrspace(1)* %1701, align 8
  %1715 = load double, double addrspace(1)* %1705, align 8
  %1716 = fmul double %1715, %1490
  %1717 = fdiv double %1716, %1709
  store double %1717, double addrspace(1)* %1705, align 8
  br label %1718

1718:                                             ; preds = %1303, %14, %9
  ret void
}

; Function Attrs: nounwind readnone
declare spir_func double @_Z15__spirv_ocl_madddd(double, double, double) #2

; uselistorder directives
uselistorder double (double, double, double)* @_Z15__spirv_ocl_madddd, { 438, 437, 436, 435, 434, 433, 432, 431, 430, 429, 428, 427, 426, 425, 424, 423, 422, 421, 420, 419, 418, 417, 416, 415, 414, 413, 412, 411, 410, 409, 408, 407, 406, 405, 404, 403, 402, 401, 400, 399, 398, 397, 396, 395, 394, 393, 392, 391, 390, 389, 388, 387, 386, 385, 384, 383, 382, 381, 380, 379, 378, 377, 376, 375, 374, 373, 372, 371, 370, 369, 368, 367, 366, 365, 364, 363, 362, 361, 360, 359, 358, 357, 356, 355, 354, 353, 352, 351, 350, 349, 348, 347, 346, 345, 344, 343, 342, 341, 340, 339, 338, 337, 336, 335, 334, 333, 332, 331, 330, 329, 328, 327, 326, 325, 324, 323, 322, 321, 320, 319, 318, 317, 316, 315, 314, 313, 312, 311, 310, 309, 308, 307, 306, 305, 304, 303, 302, 301, 300, 299, 298, 297, 296, 295, 294, 293, 292, 291, 290, 289, 288, 287, 286, 285, 284, 283, 282, 281, 280, 279, 278, 277, 276, 275, 274, 273, 272, 271, 270, 269, 268, 267, 266, 265, 264, 263, 262, 261, 260, 259, 258, 257, 256, 255, 254, 253, 252, 251, 250, 249, 248, 247, 246, 245, 244, 243, 242, 241, 240, 239, 238, 237, 236, 235, 234, 233, 232, 231, 230, 229, 228, 227, 226, 225, 224, 223, 222, 221, 220, 219, 218, 217, 216, 215, 214, 213, 212, 211, 210, 209, 208, 207, 206, 205, 204, 203, 202, 201, 200, 199, 198, 197, 196, 195, 194, 193, 192, 191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 181, 180, 179, 178, 177, 176, 175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 158, 157, 156, 155, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 130, 129, 128, 127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 }

attributes #0 = { nounwind }
attributes #1 = { noinline nounwind }
attributes #2 = { nounwind readnone }
