# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_StepVector')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_StepVector')
    _StepVector = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_StepVector', [dirname(__file__)])
        except ImportError:
            import _StepVector
            return _StepVector
        try:
            _mod = imp.load_module('_StepVector', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _StepVector = swig_import_helper()
    del swig_import_helper
else:
    import _StepVector
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class _Pair_int_float(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Pair_int_float, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Pair_int_float, name)
    __repr__ = _swig_repr
    __swig_setmethods__["first"] = _StepVector._Pair_int_float_first_set
    __swig_getmethods__["first"] = _StepVector._Pair_int_float_first_get
    if _newclass:
        first = _swig_property(_StepVector._Pair_int_float_first_get, _StepVector._Pair_int_float_first_set)
    __swig_setmethods__["second"] = _StepVector._Pair_int_float_second_set
    __swig_getmethods__["second"] = _StepVector._Pair_int_float_second_get
    if _newclass:
        second = _swig_property(_StepVector._Pair_int_float_second_get, _StepVector._Pair_int_float_second_set)

    def __init__(self, first_, second_):
        this = _StepVector.new__Pair_int_float(first_, second_)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StepVector.delete__Pair_int_float
    __del__ = lambda self: None
_Pair_int_float_swigregister = _StepVector._Pair_int_float_swigregister
_Pair_int_float_swigregister(_Pair_int_float)

class _StepVector_Iterator_float(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _StepVector_Iterator_float, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _StepVector_Iterator_float, name)
    __repr__ = _swig_repr

    def __init__(self, first, last_):
        this = _StepVector.new__StepVector_Iterator_float(first, last_)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def next(self):
        return _StepVector._StepVector_Iterator_float_next(self)

    def __iter__(self):
        return _StepVector._StepVector_Iterator_float___iter__(self)
    __swig_destroy__ = _StepVector.delete__StepVector_Iterator_float
    __del__ = lambda self: None
_StepVector_Iterator_float_swigregister = _StepVector._StepVector_Iterator_float_swigregister
_StepVector_Iterator_float_swigregister(_StepVector_Iterator_float)

class _StepVector_float(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _StepVector_float, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _StepVector_float, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _StepVector.new__StepVector_float()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def set_value(self, arg2, to, value):
        return _StepVector._StepVector_float_set_value(self, arg2, to, value)

    def add_value(self, arg2, to, value):
        return _StepVector._StepVector_float_add_value(self, arg2, to, value)

    def get_all_values_pystyle(self):
        return _StepVector._StepVector_float_get_all_values_pystyle(self)

    def get_values_pystyle(self, arg2):
        return _StepVector._StepVector_float_get_values_pystyle(self, arg2)

    def num_values(self):
        return _StepVector._StepVector_float_num_values(self)
    __swig_destroy__ = _StepVector.delete__StepVector_float
    __del__ = lambda self: None
_StepVector_float_swigregister = _StepVector._StepVector_float_swigregister
_StepVector_float_swigregister(_StepVector_float)
cvar = _StepVector.cvar
_StepVector_float.min_index = _StepVector.cvar._StepVector_float_min_index
_StepVector_float.max_index = _StepVector.cvar._StepVector_float_max_index

class _Pair_int_int(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Pair_int_int, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Pair_int_int, name)
    __repr__ = _swig_repr
    __swig_setmethods__["first"] = _StepVector._Pair_int_int_first_set
    __swig_getmethods__["first"] = _StepVector._Pair_int_int_first_get
    if _newclass:
        first = _swig_property(_StepVector._Pair_int_int_first_get, _StepVector._Pair_int_int_first_set)
    __swig_setmethods__["second"] = _StepVector._Pair_int_int_second_set
    __swig_getmethods__["second"] = _StepVector._Pair_int_int_second_get
    if _newclass:
        second = _swig_property(_StepVector._Pair_int_int_second_get, _StepVector._Pair_int_int_second_set)

    def __init__(self, first_, second_):
        this = _StepVector.new__Pair_int_int(first_, second_)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StepVector.delete__Pair_int_int
    __del__ = lambda self: None
_Pair_int_int_swigregister = _StepVector._Pair_int_int_swigregister
_Pair_int_int_swigregister(_Pair_int_int)

class _StepVector_Iterator_int(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _StepVector_Iterator_int, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _StepVector_Iterator_int, name)
    __repr__ = _swig_repr

    def __init__(self, first, last_):
        this = _StepVector.new__StepVector_Iterator_int(first, last_)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def next(self):
        return _StepVector._StepVector_Iterator_int_next(self)

    def __iter__(self):
        return _StepVector._StepVector_Iterator_int___iter__(self)
    __swig_destroy__ = _StepVector.delete__StepVector_Iterator_int
    __del__ = lambda self: None
_StepVector_Iterator_int_swigregister = _StepVector._StepVector_Iterator_int_swigregister
_StepVector_Iterator_int_swigregister(_StepVector_Iterator_int)

class _StepVector_int(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _StepVector_int, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _StepVector_int, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _StepVector.new__StepVector_int()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def set_value(self, arg2, to, value):
        return _StepVector._StepVector_int_set_value(self, arg2, to, value)

    def add_value(self, arg2, to, value):
        return _StepVector._StepVector_int_add_value(self, arg2, to, value)

    def get_all_values_pystyle(self):
        return _StepVector._StepVector_int_get_all_values_pystyle(self)

    def get_values_pystyle(self, arg2):
        return _StepVector._StepVector_int_get_values_pystyle(self, arg2)

    def num_values(self):
        return _StepVector._StepVector_int_num_values(self)
    __swig_destroy__ = _StepVector.delete__StepVector_int
    __del__ = lambda self: None
_StepVector_int_swigregister = _StepVector._StepVector_int_swigregister
_StepVector_int_swigregister(_StepVector_int)
_StepVector_int.min_index = _StepVector.cvar._StepVector_int_min_index
_StepVector_int.max_index = _StepVector.cvar._StepVector_int_max_index

class _Pair_int_bool(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Pair_int_bool, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Pair_int_bool, name)
    __repr__ = _swig_repr
    __swig_setmethods__["first"] = _StepVector._Pair_int_bool_first_set
    __swig_getmethods__["first"] = _StepVector._Pair_int_bool_first_get
    if _newclass:
        first = _swig_property(_StepVector._Pair_int_bool_first_get, _StepVector._Pair_int_bool_first_set)
    __swig_setmethods__["second"] = _StepVector._Pair_int_bool_second_set
    __swig_getmethods__["second"] = _StepVector._Pair_int_bool_second_get
    if _newclass:
        second = _swig_property(_StepVector._Pair_int_bool_second_get, _StepVector._Pair_int_bool_second_set)

    def __init__(self, first_, second_):
        this = _StepVector.new__Pair_int_bool(first_, second_)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StepVector.delete__Pair_int_bool
    __del__ = lambda self: None
_Pair_int_bool_swigregister = _StepVector._Pair_int_bool_swigregister
_Pair_int_bool_swigregister(_Pair_int_bool)

class _StepVector_Iterator_bool(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _StepVector_Iterator_bool, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _StepVector_Iterator_bool, name)
    __repr__ = _swig_repr

    def __init__(self, first, last_):
        this = _StepVector.new__StepVector_Iterator_bool(first, last_)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def next(self):
        return _StepVector._StepVector_Iterator_bool_next(self)

    def __iter__(self):
        return _StepVector._StepVector_Iterator_bool___iter__(self)
    __swig_destroy__ = _StepVector.delete__StepVector_Iterator_bool
    __del__ = lambda self: None
_StepVector_Iterator_bool_swigregister = _StepVector._StepVector_Iterator_bool_swigregister
_StepVector_Iterator_bool_swigregister(_StepVector_Iterator_bool)

class _StepVector_bool(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _StepVector_bool, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _StepVector_bool, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _StepVector.new__StepVector_bool()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def set_value(self, arg2, to, value):
        return _StepVector._StepVector_bool_set_value(self, arg2, to, value)

    def add_value(self, arg2, to, value):
        return _StepVector._StepVector_bool_add_value(self, arg2, to, value)

    def get_all_values_pystyle(self):
        return _StepVector._StepVector_bool_get_all_values_pystyle(self)

    def get_values_pystyle(self, arg2):
        return _StepVector._StepVector_bool_get_values_pystyle(self, arg2)

    def num_values(self):
        return _StepVector._StepVector_bool_num_values(self)
    __swig_destroy__ = _StepVector.delete__StepVector_bool
    __del__ = lambda self: None
_StepVector_bool_swigregister = _StepVector._StepVector_bool_swigregister
_StepVector_bool_swigregister(_StepVector_bool)
_StepVector_bool.min_index = _StepVector.cvar._StepVector_bool_min_index
_StepVector_bool.max_index = _StepVector.cvar._StepVector_bool_max_index

class _Pair_int_obj(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Pair_int_obj, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Pair_int_obj, name)
    __repr__ = _swig_repr
    __swig_setmethods__["first"] = _StepVector._Pair_int_obj_first_set
    __swig_getmethods__["first"] = _StepVector._Pair_int_obj_first_get
    if _newclass:
        first = _swig_property(_StepVector._Pair_int_obj_first_get, _StepVector._Pair_int_obj_first_set)
    __swig_setmethods__["second"] = _StepVector._Pair_int_obj_second_set
    __swig_getmethods__["second"] = _StepVector._Pair_int_obj_second_get
    if _newclass:
        second = _swig_property(_StepVector._Pair_int_obj_second_get, _StepVector._Pair_int_obj_second_set)

    def __init__(self, first_, second_):
        this = _StepVector.new__Pair_int_obj(first_, second_)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StepVector.delete__Pair_int_obj
    __del__ = lambda self: None
_Pair_int_obj_swigregister = _StepVector._Pair_int_obj_swigregister
_Pair_int_obj_swigregister(_Pair_int_obj)

class _StepVector_Iterator_obj(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _StepVector_Iterator_obj, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _StepVector_Iterator_obj, name)
    __repr__ = _swig_repr

    def __init__(self, first, last_):
        this = _StepVector.new__StepVector_Iterator_obj(first, last_)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def next(self):
        return _StepVector._StepVector_Iterator_obj_next(self)

    def __iter__(self):
        return _StepVector._StepVector_Iterator_obj___iter__(self)
    __swig_destroy__ = _StepVector.delete__StepVector_Iterator_obj
    __del__ = lambda self: None
_StepVector_Iterator_obj_swigregister = _StepVector._StepVector_Iterator_obj_swigregister
_StepVector_Iterator_obj_swigregister(_StepVector_Iterator_obj)

class _StepVector_obj(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _StepVector_obj, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _StepVector_obj, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _StepVector.new__StepVector_obj()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def set_value(self, arg2, to, value):
        return _StepVector._StepVector_obj_set_value(self, arg2, to, value)

    def add_value(self, arg2, to, value):
        return _StepVector._StepVector_obj_add_value(self, arg2, to, value)

    def get_all_values_pystyle(self):
        return _StepVector._StepVector_obj_get_all_values_pystyle(self)

    def get_values_pystyle(self, arg2):
        return _StepVector._StepVector_obj_get_values_pystyle(self, arg2)

    def num_values(self):
        return _StepVector._StepVector_obj_num_values(self)
    __swig_destroy__ = _StepVector.delete__StepVector_obj
    __del__ = lambda self: None
_StepVector_obj_swigregister = _StepVector._StepVector_obj_swigregister
_StepVector_obj_swigregister(_StepVector_obj)
_StepVector_obj.min_index = _StepVector.cvar._StepVector_obj_min_index
_StepVector_obj.max_index = _StepVector.cvar._StepVector_obj_max_index



import sys

class StepVector( object ):

   """A step vector is a vector with integer indices that is able to store
   data efficiently if it is piece-wise constant, i.e., if the values change
   in "steps". So, if a number of adjacent vectort elements have the same
   value, this values will be stored only once.

   The data can be either one of a number of elementary types, or any object.

   Usage example:

   >>> sv = StepVector.StepVector( 20 )
   >>> sv[5:17] = 13
   >>> sv[12]
   13.0
   >>> list( sv )
   [0.0, 0.0, 0.0, 0.0, 0.0, 13.0, 13.0, 13.0, 13.0, 13.0, 13.0, 13.0, 13.0, 13.0, 13.0, 13.0, 13.0, 0.0, 0.0, 0.0]
   >>> list( sv.get_steps() )
   [(0, 5, 0.0), (5, 17, 13.0), (17, 20, 0.0)]

   """

   @classmethod
   def create( cls, length = sys.maxint, typecode = 'd', start_index = 0 ):
      """Construct a StepVector of the given length, with indices starting
      at the given start_index and counting up to (but not including)
      start_index + length.

      The typecode may be:
        'd' for float values (C type 'double'),
        'i' for int values,
        'b' for Boolean values,
        'O' for arbitrary Python objects as value.

      The vector is initialized with the value zero (or, for typecode 'O',
      with None).
      """
      if typecode == 'd':
         swigclass = _StepVector_float
      elif typecode == 'i':
         swigclass = _StepVector_int
      elif typecode == 'b':
         swigclass = _StepVector_bool
      elif typecode == 'O':
         swigclass = _StepVector_obj
      else:
         raise ValueError, "unsupported typecode"
      obj = cls()
      obj._typecode = typecode
      obj._swigobj = swigclass( )    
      obj.start = start_index
      obj.stop = start_index + length
      return obj

   def __setitem__( self, index, value ):
      """To set element i of StepVector sv to the value v, write
         sv[i] = v
      If you want to set a whole step, say, all values from i to j (not
      including j), write
         sv[i:j] = v
      Note that the StepVector class will only notice that all the values
      from i to j are equal if you assign them in this fashion. Assigning each
      item individually in a loop from i to j will result in the value v being
      stored many times.
      """
      if isinstance( value, StepVector ):
         if self._swigobj is value._swigobj and \
               value.start == index.start and value.stop == index.stop:
            return
         else:
            raise NotImplemented, "Stepvector-to-Stepvector assignment still missing"
      if isinstance( index, slice ):
         if index.step is not None and index.step != 1:
             raise ValueError, "Striding slices (i.e., step != 1) are not supported"
         if index.start is None:
            start = self.start
         else:
            if index.start < self.start:
               raise IndexError, "start too small"
            start = index.start
         if index.stop is None:
            stop = self.stop
         else:
            if index.stop > self.stop:
               raise IndexError, "stop too large"
            stop = index.stop
         self._swigobj.set_value( start, stop-1, value )
# Note the "-1": The C++ object uses closed intervals, but we follow
# Python convention here and use half-open ones.
      else:
         self._swigobj.set_value( index, index, value )

   def get_steps( self, values_only = False, merge_steps=True ):
      """To get a succinct representation of the StepVector's content, call
      the 'get_steps' method. It returns an iterator that generates triples
      of values. Each triple contains one step, giving first the start index
      of the step, then the stop index (i.e., one more than the index of the 
      last element), and as third element the value of the step.

      If you want to see only a part of the StepVector, use the 'start' and
      'stop' parameters of 'get_steps' to specify a window.

      Sometimes, one might only be interested in the values, not the step
      boundaries. Then, set 'values_only' to true, and the iterator generates
      only the values insted of the triples.
      """
      startvals = self._swigobj.get_values_pystyle( self.start )
      prevstart = self.start
      prevval = startvals.next().second
      for pair in startvals:
         stepstart, value = pair.first, pair.second
         if merge_steps and value == prevval:
            continue
         if self.stop is not None and stepstart >= self.stop:
            if not values_only:
               yield prevstart, self.stop, prevval
            else:
               yield prevval
            return
         if not values_only:
            yield prevstart, stepstart, prevval
         else:
            yield prevval
         prevstart, prevval = stepstart, value
      else:
         if not values_only:
            yield prevstart, min( self.stop, self._swigobj.max_index+1), prevval
         else:
            yield prevval

   def __getitem__( self, index ):
      """Given a StepVector sv, writing sv[i] returns sv's element i (where i
      is an integer). 

      If you use a slice, i.e., 'sv[i:j]', you get a view on the StepVector,
      i.e., the same data, but changed boundaries.
      """
      if isinstance( index, slice ):
         if index.step is not None and index.step != 1:
             raise ValueError, "Striding slices (i.e., step != 1) are not supported"
         if index.start is None:
            start = self.start
         else:
            if index.start < self.start:
               raise IndexError, "start too small"
            start = index.start
         if index.stop is None:
            stop = self.stop
         else:
            if index.stop > self.stop:
               raise IndexError, "stop too large"
            stop = index.stop
         res = self.__class__()
         res._typecode = self.typecode
         res._swigobj = self._swigobj
         res.start = start
         res.stop = stop
         return res
      else:
         return self._swigobj.get_values_pystyle( index ).next().second

   def __iter__( self ):
      """When asked to provide an iterator, a StepVector will yield all its
      value, repeating each value according to the length of the step.
      Hence, calling, e.g., 'list( sv )' will transform the StepVector 'sv'
      into an ordinary list.
      """
      for start, stop, value in self.get_steps():
         for i in xrange( start, stop ):
            yield value

   def __repr__( self ):
      if self.start == -sys.maxint - 1:
         start_s = "-inf"
      else:
         start_s = str( self.start )
      if self.stop == sys.maxint:
         stop_s = "inf"
      else:
         stop_s = str( self.stop )
      return "<%s object, type '%s', index range %s:%s, %d step(s)>" % (
         self.__class__.__name__, self.typecode(), start_s,
         stop_s, self.num_steps() )

   def typecode( self ):
      "Returns the typecode."
      return self._typecode

   def __len__( self ):
      """The length of a StepVector is defined by its index range, not by
      the number of steps.
      """
      return self.stop - self.start

   def num_steps( self ):
      """Returns the number of steps, i.e., the number of triples that get_steps
      returns.
      """
      return self._swigobj.num_values()

   def __eq__( self, other ):
      """StepVectors can be compared for equality. This is conceptually done
      element for element, but, for performance, taking steps in one go.
      """
      if self.start_index() != other.start_index() or len(self) != len(other) or \
            self.typecode() != other.typecode():
         print "Mark A"
         return False
      selfsteps = self.get_steps()
      othrsteps = other.get_steps()
      selfstart, selfstop, selfval = selfsteps.next()
      othrstart, othrstop, othrval = othrsteps.next()
      while selfstop < self.start_index() + len(self) and \
            othrstop < other.start_index() + len(other):
         assert selfstart < othrstop and othrstart < selfstop
         if not( selfval == othrval ):
            return False
         if selfstop < othrstop:
            selfstart, selfstop, selfval = selfsteps.next()
         elif othrstop < selfstop:
            othrstart, othrstop, othrval = othrsteps.next()
         else:
            selfstart, selfstop, selfval = selfsteps.next()
            othrstart, othrstop, othrval = othrsteps.next()
      return True

   def __neq__( self, other ):
      return not ( self == other )

   def __reduce__( self ):
      if self.__class__ is not StepVector:
         raise NotImplemented, "Attempting to pickle a subclass of StepVector without redefined __reduce__."
      return ( 
         _StepVector_unpickle, 
         ( self.stop - self.start, self._typecode, self.start ),
         None,
         None,
         ( ( slice( start, stop ), val ) for start, stop, val in self.get_steps() ) )

   def __iadd__( self, value ):
      self._swigobj.add_value( self.start, self.stop-1, value )
      return self

   def apply( self, func, start = None, stop = None ):
# TODO: check!
      for stepstart, stepstop, value in self.get_steps( start, stop ):
         self[ stepstart : stepstop ] = func( value )

def _StepVector_unpickle( length, typecode, start ):
   return StepVector.create( length, typecode, start )


# This file is compatible with both classic and new-style classes.


