# Frontend Development [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

**Manually curated collection of resources for frontend web developers.**

You are viewing a browseable version, split by category in many small files. There is also a really huge file with every single resource on one page. Proceed to the [totally gigantic file](TOTALLY-GIGANTIC-FILE.md) if you are into this kind of thing.

This is the current version, which receives ongoing updates. If you want the good old bookmarks, please use the tag v.1.0. Keep in mind, that the old version has many outdated links.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)


---------------------------------------------------------

## Appearance

The outward or visible aspect of a website.

+ **[Animation](appearance/animation.md)**: The process of creating motion and shape change.
+ **[Typography](appearance/typography.md)**: The style, arrangement, or appearance of typeset matter.
+ **[Visualization](appearance/visualization.md)**: Placing data in a visual context.

## Architecture

High level structure of the frontend code and the discipline of creating such structures.

+ **[Algorithms](architecture/algorithms.md)**: A self-contained step-by-step set of operations to be performed. Algorithms perform calculation, data processing, and/or automated reasoning tasks.
+ **[Design Patterns](architecture/design-patterns.md)**: Best practices that the programmer can use to solve common problems when designing an application or system.
+ **[Designs](architecture/designs.md)**: Ready to use and well documented structures and frameworks for frontend development.
+ **[Event-Driven Programming](architecture/event-driven-programming.md)**: Event-driven programming is a programming paradigm in which the flow of the program is determined by events such as user actions, sensor outputs, or messages from other programs/threads.
+ **[Functional Programming](architecture/functional-programming.md)**: Functional programming is a programming paradigm, that treats computation as the evaluation of mathematical functions and avoids changing-state and mutable data.
+ **[Functional Reactive Programming (FRP)](architecture/functional-reactive-programming-frp.md)**: FRP is a programming paradigm for asynchronous dataflow programming using the building blocks of functional programming.

## Compatibility

Ability of a product to work with different input/output devices and rendering software. Including printers, email, mobile devices and different browsers.

+ **[Cross Browser](compatibility/cross-browser.md)**: Cross-browser refers to the ability of a website, web application, HTML construct or client-side script to function in environments that provide its required features and to bow out or degrade gracefully when features are absent or lacking.
+ **[E-Mail](compatibility/e-mail.md)**: Preparing HTML based electronic mail.
+ **[Keyboard](compatibility/keyboard.md)**: Working with keyboard input in a web browser.
+ **[Mobile](compatibility/mobile.md)**: Development of websites optimized for viewing on smartphone and tablet devices.
+ **[Printers](compatibility/printers.md)**: Manipulation of printer output through CSS.
+ **[Responsive Web Design (RWD)](compatibility/responsive-web-design-rwd.md)**: RWD responds to the needs of the users and the devices they’re using. The layout changes based on the size and capabilities of the device.
+ **[Web Accessibility](compatibility/web-accessibility.md)**: Web accessibility means that people with disabilities can perceive, understand, navigate, and interact with the Web, and that they can contribute to the Web.

## Ecosystem

Important developers, companies, organizations and news sources.

+ **[Communities Around Projects](ecosystem/communities-around-projects.md)**: Successful open source projects attract many developers who produce plugins, libraries, tutorials and other resources. This section collects such resources.
+ **[News](ecosystem/news.md)**: Websites & newsletters which provide daily and weekly news related to frontend web development.
+ **[Notable Community Members](ecosystem/notable-community-members.md)**: Important engineers, evangelists, architects and other celebrities.
+ **[Organizations](ecosystem/organizations.md)**: Commercial companies and nonprofit organizations around web development.
+ **[Podcasts](ecosystem/podcasts.md)**: A podcast is a form of digital media that consists of an episodic series of audio, video, digital radio, PDF, or ePub files subscribed to and downloaded automatically through web syndication or streamed online to a computer or mobile device.

## Languages, Protocols, Browser APIs

Programming/mark-up languages and web related standards.

+ **[Cascading Style Sheets (CSS)](languages-protocols-browser-apis/cascading-style-sheets-css.md)**: CSS are a stylesheet language used to describe the presentation of a document written in HTML or XML. It describes how elements should be rendered on screen, on paper, in speech, or on other media.
+ **[Document Object Model (DOM)](languages-protocols-browser-apis/document-object-model-dom.md)**: The DOM is a programming interface for HTML, XML and SVG documents. It defines methods that allow access to the tree, so that they can change the document structure, style and content.
+ **[HyperText Markup Language (HTML)](languages-protocols-browser-apis/hypertext-markup-language-html.md)**: HTML is the standard markup language used to create web pages and its elements form the building blocks of all websites.
+ **[Hypertext Transfer Protocol (HTTP)](languages-protocols-browser-apis/hypertext-transfer-protocol-http.md)**: The Hypertext Transfer Protocol (HTTP) is an application protocol for distributed, collaborative, hypermedia information systems. HTTP is the foundation of data communication for the World Wide Web.
+ **[JavaScript (EcmaScript)](languages-protocols-browser-apis/javascript-ecmascript.md)**: JavaScript is a full-fledged dynamic programming language that, when applied to an HTML document, can provide dynamic interactivity on websites. It is defined by ECMAScript standard.
+ **[JavaScript Object Notation (JSON)](languages-protocols-browser-apis/javascript-object-notation-json.md)**: JSON (JavaScript Object Notation) is a lightweight data-interchange format. It is easy for humans to read and write. It is easy for machines to parse and generate. It is based on a subset of the JavaScript Programming Language.
+ **[Scalable Vector Graphics (SVG)](languages-protocols-browser-apis/scalable-vector-graphics-svg.md)**: An XML-based vector image format for two-dimensional graphics with support for interactivity and animation.
+ **[Service Workers](languages-protocols-browser-apis/service-workers.md)**: A method that enables applications to take advantage of persistent background processing, including hooks to enable bootstrapping of web applications while offline.
+ **[Templating Languages and Engines](languages-protocols-browser-apis/templating-languages-and-engines.md)**: Template engines are tools to separate program-logic and presentation into two independent parts. This makes the development of both logic and presentation easier, improves flexibility and eases modification and maintenance.
+ **[Transpiled Languages](languages-protocols-browser-apis/transpiled-languages.md)**: Abstract languages converted to native, browser supported standards like JavaScript or CSS.
+ **[Uniform Resource Identifier (URI)](languages-protocols-browser-apis/uniform-resource-identifier-uri.md)**: URI is a string of characters used to identify a resource. The most common form of URI is the Uniform Resource Locator (URL).
+ **[Web Animations API](animation/web-animations-api.md)**: Web Animations is a new JavaScript API for driving animated content on the web. By unifying the animation features of SVG and CSS, Web Animations unlocks features previously only usable declaratively, and exposes powerful, high-performance animation capabilities to developers.
+ **[WebAssembly](languages-protocols-browser-apis/webassembly.md)**: WebAssembly is meant to fill a place that JavaScript has been forced to occupy up to now: a low-level code representation that can serve as a compiler target.

## User Interface Components

Drop-in UI components for web sites and applications.

+ **[Buttons](user-interface-components/buttons.md)**: The term button refers to any graphical control element that provides the user a simple way to trigger an event, like searching for a query at a search engine, or to interact with dialog boxes, like confirming an action.
+ **[Code](user-interface-components/code.md)**: Code viewers and editors designed for embedding inside a website.
+ **[Forms](user-interface-components/forms.md)**: A HTML form on a web page allows a user to enter data that is sent to a server for processing. Web users fill out the forms using checkboxes, radio buttons, or text fields.
+ **[Galeries & Image Sliders](user-interface-components/galeries-and-image-sliders.md)**: A sophisticated way to present a collection of images on your website.
+ **[Grid](user-interface-components/grid.md)**: CSS Grid Layout Systems.
+ **[Rich Text Editors](user-interface-components/rich-text-editors.md)**: A rich text editor is the interface for editing rich text within web browsers. The aim is to reduce the effort for users trying to express their formatting directly as valid HTML markup.
+ **[Table Of Contents](user-interface-components/table-of-contents.md)**: Components for automatic table of contents generation.
+ **[UI Kits](user-interface-components/ui-kits.md)**: Collections of ready to use components.
+ **[Video & Audio](user-interface-components/video-and-audio.md)**: Components for playing audio and video files on a website.

## Workflow

Task automation and asset delivery.

+ **[Automated Testing](workflow/automated-testing.md)**: Automated software testing is a process in which software tools execute pre-scripted tests on a software application before it is released into production.
+ **[Build Tools](workflow/build-tools.md)**: Toolkits and their ecosystems, that help you automate painful and repeated tasks.
+ **[CSS Tools](workflow/css-tools.md)**: Tools for analysis, pre and post processing of CSS files.
+ **[Code Editors](workflow/code-editors.md)**: Text editor programs designed specifically for editing source code of a website.
+ **[Documentation](workflow/documentation.md)**: Writing, generating, publishing and consuming documentation for web deliverables.
+ **[Fonts for Programmers](workflow/fonts-for-programmers.md)**: Programmers need special fonts, which help align the code and distinguish between characters, that look alike.
+ **[Getting Started](workflow/getting-started.md)**: Step by step guides for setting up a frontend development workflow.
+ **[HTML Tools](workflow/html-tools.md)**: Tools for pre and post processing of the HTML source code.
+ **[Image Post Processing](workflow/image-post-processing.md)**: Tools for image conversion and optimization.
+ **[JavaScript Tools](workflow/javascript-tools.md)**: Tools for static analysis, pre and post processing of JavaScript files.
+ **[Package Management](workflow/package-management.md)**: A package manager or package management system is a collection of software tools that automates the process of installing, upgrading, configuring, and removing reusable libraries and components in a consistent manner.
+ **[Sourcemaps](workflow/sourcemaps.md)**: Sourcemap is a way to map a combined/minified file back to an unbuilt state.
+ **[Version Control](workflow/version-control.md)**: Version control or source control is a system that records changes to a file or set of files over time so that you can recall specific versions later.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.