package kubernetesconfiguration

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/kubernetesconfiguration/mgmt/2021-09-01/kubernetesconfiguration"

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Extension the Extension object.
type Extension struct {
	autorest.Response `json:"-"`
	// ExtensionProperties - Properties of an Extension resource
	*ExtensionProperties `json:"properties,omitempty"`
	// Identity - Identity of the Extension resource
	Identity *Identity `json:"identity,omitempty"`
	// SystemData - Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Extension.
func (e Extension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.ExtensionProperties != nil {
		objectMap["properties"] = e.ExtensionProperties
	}
	if e.Identity != nil {
		objectMap["identity"] = e.Identity
	}
	if e.SystemData != nil {
		objectMap["systemData"] = e.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Extension struct.
func (e *Extension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extensionProperties ExtensionProperties
				err = json.Unmarshal(*v, &extensionProperties)
				if err != nil {
					return err
				}
				e.ExtensionProperties = &extensionProperties
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				e.Identity = &identity
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				e.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtensionProperties properties of an Extension resource
type ExtensionProperties struct {
	// ExtensionType - Type of the Extension, of which this resource is an instance of.  It must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the Extension publisher.
	ExtensionType *string `json:"extensionType,omitempty"`
	// AutoUpgradeMinorVersion - Flag to note if this extension participates in auto upgrade of minor version, or not.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// ReleaseTrain - ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
	ReleaseTrain *string `json:"releaseTrain,omitempty"`
	// Version - Version of the extension for this extension, if it is 'pinned' to a specific version. autoUpgradeMinorVersion must be 'false'.
	Version *string `json:"version,omitempty"`
	// Scope - Scope at which the extension is installed.
	Scope *Scope `json:"scope,omitempty"`
	// ConfigurationSettings - Configuration settings, as name-value pairs for configuring this extension.
	ConfigurationSettings map[string]*string `json:"configurationSettings"`
	// ConfigurationProtectedSettings - Configuration settings that are sensitive, as name-value pairs for configuring this extension.
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings"`
	// ProvisioningState - Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Statuses - Status from this extension.
	Statuses  *[]ExtensionStatus `json:"statuses,omitempty"`
	ErrorInfo *ErrorDetail       `json:"errorInfo,omitempty"`
	// CustomLocationSettings - READ-ONLY; Custom Location settings properties.
	CustomLocationSettings map[string]*string `json:"customLocationSettings"`
	// PackageURI - READ-ONLY; Uri of the Helm package
	PackageURI *string `json:"packageUri,omitempty"`
	// AksAssignedIdentity - Identity of the Extension resource in an AKS cluster
	AksAssignedIdentity *ExtensionPropertiesAksAssignedIdentity `json:"aksAssignedIdentity,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionProperties.
func (e ExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.ExtensionType != nil {
		objectMap["extensionType"] = e.ExtensionType
	}
	if e.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = e.AutoUpgradeMinorVersion
	}
	if e.ReleaseTrain != nil {
		objectMap["releaseTrain"] = e.ReleaseTrain
	}
	if e.Version != nil {
		objectMap["version"] = e.Version
	}
	if e.Scope != nil {
		objectMap["scope"] = e.Scope
	}
	if e.ConfigurationSettings != nil {
		objectMap["configurationSettings"] = e.ConfigurationSettings
	}
	if e.ConfigurationProtectedSettings != nil {
		objectMap["configurationProtectedSettings"] = e.ConfigurationProtectedSettings
	}
	if e.ProvisioningState != "" {
		objectMap["provisioningState"] = e.ProvisioningState
	}
	if e.Statuses != nil {
		objectMap["statuses"] = e.Statuses
	}
	if e.ErrorInfo != nil {
		objectMap["errorInfo"] = e.ErrorInfo
	}
	if e.AksAssignedIdentity != nil {
		objectMap["aksAssignedIdentity"] = e.AksAssignedIdentity
	}
	return json.Marshal(objectMap)
}

// ExtensionPropertiesAksAssignedIdentity identity of the Extension resource in an AKS cluster
type ExtensionPropertiesAksAssignedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionPropertiesAksAssignedIdentity.
func (eAi ExtensionPropertiesAksAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eAi.Type != "" {
		objectMap["type"] = eAi.Type
	}
	return json.Marshal(objectMap)
}

// ExtensionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (Extension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsCreateFuture.Result.
func (future *ExtensionsCreateFuture) result(client ExtensionsClient) (e Extension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.ExtensionsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsCreateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExtensionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsDeleteFuture.Result.
func (future *ExtensionsDeleteFuture) result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.ExtensionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExtensionsList result of the request to list Extensions.  It contains a list of Extension objects and a
// URL link to get the next set of results.
type ExtensionsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Extensions within a Kubernetes cluster.
	Value *[]Extension `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of extension objects, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionsList.
func (el ExtensionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExtensionsListIterator provides access to a complete listing of Extension values.
type ExtensionsListIterator struct {
	i    int
	page ExtensionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtensionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtensionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtensionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtensionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtensionsListIterator) Response() ExtensionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtensionsListIterator) Value() Extension {
	if !iter.page.NotDone() {
		return Extension{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtensionsListIterator type.
func NewExtensionsListIterator(page ExtensionsListPage) ExtensionsListIterator {
	return ExtensionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (el ExtensionsList) IsEmpty() bool {
	return el.Value == nil || len(*el.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (el ExtensionsList) hasNextLink() bool {
	return el.NextLink != nil && len(*el.NextLink) != 0
}

// extensionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (el ExtensionsList) extensionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !el.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(el.NextLink)))
}

// ExtensionsListPage contains a page of Extension values.
type ExtensionsListPage struct {
	fn func(context.Context, ExtensionsList) (ExtensionsList, error)
	el ExtensionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtensionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtensionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.el)
		if err != nil {
			return err
		}
		page.el = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtensionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtensionsListPage) NotDone() bool {
	return !page.el.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtensionsListPage) Response() ExtensionsList {
	return page.el
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtensionsListPage) Values() []Extension {
	if page.el.IsEmpty() {
		return nil
	}
	return *page.el.Value
}

// Creates a new instance of the ExtensionsListPage type.
func NewExtensionsListPage(cur ExtensionsList, getNextPage func(context.Context, ExtensionsList) (ExtensionsList, error)) ExtensionsListPage {
	return ExtensionsListPage{
		fn: getNextPage,
		el: cur,
	}
}

// ExtensionStatus status from the extension.
type ExtensionStatus struct {
	// Code - Status code provided by the Extension
	Code *string `json:"code,omitempty"`
	// DisplayStatus - Short description of status of the extension.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Level - Level of the status. Possible values include: 'LevelTypeError', 'LevelTypeWarning', 'LevelTypeInformation'
	Level LevelType `json:"level,omitempty"`
	// Message - Detailed message of the status from the Extension.
	Message *string `json:"message,omitempty"`
	// Time - DateLiteral (per ISO8601) noting the time of installation status.
	Time *string `json:"time,omitempty"`
}

// ExtensionsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (Extension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsUpdateFuture.Result.
func (future *ExtensionsUpdateFuture) result(client ExtensionsClient) (e Extension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.ExtensionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.UpdateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsUpdateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// OperationStatusList the async operations in progress, in the cluster.
type OperationStatusList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of async operations in progress, in the cluster.
	Value *[]OperationStatusResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of Operation Result objects, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusList.
func (osl OperationStatusList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationStatusListIterator provides access to a complete listing of OperationStatusResult values.
type OperationStatusListIterator struct {
	i    int
	page OperationStatusListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationStatusListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationStatusListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationStatusListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationStatusListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationStatusListIterator) Response() OperationStatusList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationStatusListIterator) Value() OperationStatusResult {
	if !iter.page.NotDone() {
		return OperationStatusResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationStatusListIterator type.
func NewOperationStatusListIterator(page OperationStatusListPage) OperationStatusListIterator {
	return OperationStatusListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (osl OperationStatusList) IsEmpty() bool {
	return osl.Value == nil || len(*osl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (osl OperationStatusList) hasNextLink() bool {
	return osl.NextLink != nil && len(*osl.NextLink) != 0
}

// operationStatusListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (osl OperationStatusList) operationStatusListPreparer(ctx context.Context) (*http.Request, error) {
	if !osl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(osl.NextLink)))
}

// OperationStatusListPage contains a page of OperationStatusResult values.
type OperationStatusListPage struct {
	fn  func(context.Context, OperationStatusList) (OperationStatusList, error)
	osl OperationStatusList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationStatusListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationStatusListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.osl)
		if err != nil {
			return err
		}
		page.osl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationStatusListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationStatusListPage) NotDone() bool {
	return !page.osl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationStatusListPage) Response() OperationStatusList {
	return page.osl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationStatusListPage) Values() []OperationStatusResult {
	if page.osl.IsEmpty() {
		return nil
	}
	return *page.osl.Value
}

// Creates a new instance of the OperationStatusListPage type.
func NewOperationStatusListPage(cur OperationStatusList, getNextPage func(context.Context, OperationStatusList) (OperationStatusList, error)) OperationStatusListPage {
	return OperationStatusListPage{
		fn:  getNextPage,
		osl: cur,
	}
}

// OperationStatusResult the current status of an async operation.
type OperationStatusResult struct {
	autorest.Response `json:"-"`
	// ID - Fully qualified ID for the async operation.
	ID *string `json:"id,omitempty"`
	// Name - Name of the async operation.
	Name *string `json:"name,omitempty"`
	// Status - Operation status.
	Status *string `json:"status,omitempty"`
	// Properties - Additional information, if available.
	Properties map[string]*string `json:"properties"`
	Error      *ErrorDetail       `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusResult.
func (osr OperationStatusResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if osr.ID != nil {
		objectMap["id"] = osr.ID
	}
	if osr.Name != nil {
		objectMap["name"] = osr.Name
	}
	if osr.Status != nil {
		objectMap["status"] = osr.Status
	}
	if osr.Properties != nil {
		objectMap["properties"] = osr.Properties
	}
	if osr.Error != nil {
		objectMap["error"] = osr.Error
	}
	return json.Marshal(objectMap)
}

// PatchExtension the Extension Patch Request object.
type PatchExtension struct {
	// PatchExtensionProperties - Updatable properties of an Extension Patch Request
	*PatchExtensionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchExtension.
func (peVar PatchExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if peVar.PatchExtensionProperties != nil {
		objectMap["properties"] = peVar.PatchExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PatchExtension struct.
func (peVar *PatchExtension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var patchExtensionProperties PatchExtensionProperties
				err = json.Unmarshal(*v, &patchExtensionProperties)
				if err != nil {
					return err
				}
				peVar.PatchExtensionProperties = &patchExtensionProperties
			}
		}
	}

	return nil
}

// PatchExtensionProperties updatable properties of an Extension Patch Request
type PatchExtensionProperties struct {
	// AutoUpgradeMinorVersion - Flag to note if this extension participates in auto upgrade of minor version, or not.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// ReleaseTrain - ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
	ReleaseTrain *string `json:"releaseTrain,omitempty"`
	// Version - Version of the extension for this extension, if it is 'pinned' to a specific version. autoUpgradeMinorVersion must be 'false'.
	Version *string `json:"version,omitempty"`
	// ConfigurationSettings - Configuration settings, as name-value pairs for configuring this extension.
	ConfigurationSettings map[string]*string `json:"configurationSettings"`
	// ConfigurationProtectedSettings - Configuration settings that are sensitive, as name-value pairs for configuring this extension.
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings"`
}

// MarshalJSON is the custom marshaler for PatchExtensionProperties.
func (peVar PatchExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if peVar.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = peVar.AutoUpgradeMinorVersion
	}
	if peVar.ReleaseTrain != nil {
		objectMap["releaseTrain"] = peVar.ReleaseTrain
	}
	if peVar.Version != nil {
		objectMap["version"] = peVar.Version
	}
	if peVar.ConfigurationSettings != nil {
		objectMap["configurationSettings"] = peVar.ConfigurationSettings
	}
	if peVar.ConfigurationProtectedSettings != nil {
		objectMap["configurationProtectedSettings"] = peVar.ConfigurationProtectedSettings
	}
	return json.Marshal(objectMap)
}

// Plan plan for the resource.
type Plan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySet the resource model definition containing the full set of allowed
// properties for a resource. Except properties bag, there cannot be a top level property outside of this
// set.
type ResourceModelWithAllowedPropertySet struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ManagedBy - The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Kind - Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
	Kind *string `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags     map[string]*string                           `json:"tags"`
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`
	Sku      *ResourceModelWithAllowedPropertySetSku      `json:"sku,omitempty"`
	Plan     *ResourceModelWithAllowedPropertySetPlan     `json:"plan,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySet.
func (rmwaps ResourceModelWithAllowedPropertySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Location != nil {
		objectMap["location"] = rmwaps.Location
	}
	if rmwaps.ManagedBy != nil {
		objectMap["managedBy"] = rmwaps.ManagedBy
	}
	if rmwaps.Kind != nil {
		objectMap["kind"] = rmwaps.Kind
	}
	if rmwaps.Tags != nil {
		objectMap["tags"] = rmwaps.Tags
	}
	if rmwaps.Identity != nil {
		objectMap["identity"] = rmwaps.Identity
	}
	if rmwaps.Sku != nil {
		objectMap["sku"] = rmwaps.Sku
	}
	if rmwaps.Plan != nil {
		objectMap["plan"] = rmwaps.Plan
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetIdentity ...
type ResourceModelWithAllowedPropertySetIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySetIdentity.
func (rmwaps ResourceModelWithAllowedPropertySetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Type != "" {
		objectMap["type"] = rmwaps.Type
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetPlan ...
type ResourceModelWithAllowedPropertySetPlan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// ResourceModelWithAllowedPropertySetSku ...
type ResourceModelWithAllowedPropertySetSku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ResourceProviderOperation supported operation of this resource provider.
type ResourceProviderOperation struct {
	// Name - Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`
	// IsDataAction - READ-ONLY; The flag that indicates whether the operation applies to data plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Origin - READ-ONLY; Origin of the operation
	Origin *string `json:"origin,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceProviderOperation.
func (rpo ResourceProviderOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpo.Name != nil {
		objectMap["name"] = rpo.Name
	}
	if rpo.Display != nil {
		objectMap["display"] = rpo.Display
	}
	return json.Marshal(objectMap)
}

// ResourceProviderOperationDisplay display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Provider - Resource provider: Microsoft KubernetesConfiguration.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of this operation.
	Description *string `json:"description,omitempty"`
}

// ResourceProviderOperationList result of the request to list operations.
type ResourceProviderOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by this resource provider.
	Value *[]ResourceProviderOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceProviderOperationList.
func (rpol ResourceProviderOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpol.Value != nil {
		objectMap["value"] = rpol.Value
	}
	return json.Marshal(objectMap)
}

// ResourceProviderOperationListIterator provides access to a complete listing of ResourceProviderOperation
// values.
type ResourceProviderOperationListIterator struct {
	i    int
	page ResourceProviderOperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceProviderOperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceProviderOperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceProviderOperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceProviderOperationListIterator) Response() ResourceProviderOperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceProviderOperationListIterator) Value() ResourceProviderOperation {
	if !iter.page.NotDone() {
		return ResourceProviderOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceProviderOperationListIterator type.
func NewResourceProviderOperationListIterator(page ResourceProviderOperationListPage) ResourceProviderOperationListIterator {
	return ResourceProviderOperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rpol ResourceProviderOperationList) IsEmpty() bool {
	return rpol.Value == nil || len(*rpol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rpol ResourceProviderOperationList) hasNextLink() bool {
	return rpol.NextLink != nil && len(*rpol.NextLink) != 0
}

// resourceProviderOperationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rpol ResourceProviderOperationList) resourceProviderOperationListPreparer(ctx context.Context) (*http.Request, error) {
	if !rpol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rpol.NextLink)))
}

// ResourceProviderOperationListPage contains a page of ResourceProviderOperation values.
type ResourceProviderOperationListPage struct {
	fn   func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)
	rpol ResourceProviderOperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceProviderOperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rpol)
		if err != nil {
			return err
		}
		page.rpol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceProviderOperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceProviderOperationListPage) NotDone() bool {
	return !page.rpol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceProviderOperationListPage) Response() ResourceProviderOperationList {
	return page.rpol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceProviderOperationListPage) Values() []ResourceProviderOperation {
	if page.rpol.IsEmpty() {
		return nil
	}
	return *page.rpol.Value
}

// Creates a new instance of the ResourceProviderOperationListPage type.
func NewResourceProviderOperationListPage(cur ResourceProviderOperationList, getNextPage func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)) ResourceProviderOperationListPage {
	return ResourceProviderOperationListPage{
		fn:   getNextPage,
		rpol: cur,
	}
}

// Scope scope of the extension. It can be either Cluster or Namespace; but not both.
type Scope struct {
	Cluster   *ScopeCluster   `json:"cluster,omitempty"`
	Namespace *ScopeNamespace `json:"namespace,omitempty"`
}

// ScopeCluster specifies that the scope of the extension is Cluster
type ScopeCluster struct {
	// ReleaseNamespace - Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
	ReleaseNamespace *string `json:"releaseNamespace,omitempty"`
}

// ScopeNamespace specifies that the scope of the extension is Namespace
type ScopeNamespace struct {
	// TargetNamespace - Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}
