/* GIMP Dimage color plugin
 * Copyright (C) 2002 Laurent HOUDARD <lhoudard@netcourrier.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgimp/gimp.h>
#include <libgimp/gimpmatrix.h>

#include "config.h"
#include "profile.h"

/* sRGB color primaries (see http://www.srgb.com) */

GimpMatrix3 srgb_prim =   { { 0.436066, 0.385147, 0.143066 },
			    { 0.222488, 0.716873, 0.060608 },
			    { 0.013916, 0.097076, 0.714096 } };

/* Color primaries, gamma and 'iTRC' tag taken from the ICC profile
   provided by Minolta */

GimpMatrix3 dimage_prim = { { 0.528580, 0.412567, 0.023010 },
			    { 0.280212, 0.827759,-0.107986 },
			    { 0.060455,-0.034973, 0.799408 } };

double dimage_gamma[512] = {
  0.000000, 0.000412, 0.000839, 0.001251, 0.001663, 0.002075, 0.002502, 
  0.002914, 0.003326, 0.003723, 0.004135, 0.004547, 0.004959, 0.005356, 
  0.005768, 0.006165, 0.006577, 0.006973, 0.007385, 0.007782, 0.008179, 
  0.008591, 0.008988, 0.009384, 0.009781, 0.010178, 0.010575, 0.010971, 
  0.011368, 0.011765, 0.012161, 0.012558, 0.012955, 0.013352, 0.013748, 
  0.014130, 0.014527, 0.014923, 0.015320, 0.015702, 0.016098, 0.016495, 
  0.016892, 0.017273, 0.017670, 0.018067, 0.018448, 0.018845, 0.019242, 
  0.019623, 0.020020, 0.020417, 0.020813, 0.021195, 0.021592, 0.021988, 
  0.022370, 0.022766, 0.023163, 0.023560, 0.023957, 0.024338, 0.024735, 
  0.025132, 0.025528, 0.025925, 0.026322, 0.026719, 0.027115, 0.027512, 
  0.027909, 0.028305, 0.028717, 0.029114, 0.029511, 0.029908, 0.030320, 
  0.030716, 0.031128, 0.031525, 0.031937, 0.032334, 0.032746, 0.033158, 
  0.033555, 0.033967, 0.034379, 0.034791, 0.035203, 0.035615, 0.036042, 
  0.036454, 0.036866, 0.037293, 0.037705, 0.038132, 0.038544, 0.038972, 
  0.039399, 0.039826, 0.040253, 0.040681, 0.041108, 0.041535, 0.041962, 
  0.042405, 0.042832, 0.043275, 0.043717, 0.044160, 0.044587, 0.045029, 
  0.045487, 0.045930, 0.046372, 0.046830, 0.047272, 0.047730, 0.048188, 
  0.048646, 0.049104, 0.049561, 0.050019, 0.050492, 0.050950, 0.051423, 
  0.051881, 0.052354, 0.052827, 0.053315, 0.053788, 0.054261, 0.054749, 
  0.055238, 0.055726, 0.056214, 0.056703, 0.057191, 0.057694, 0.058183, 
  0.058686, 0.059190, 0.059693, 0.060197, 0.060716, 0.061219, 0.061738, 
  0.062257, 0.062776, 0.063310, 0.063828, 0.064363, 0.064897, 0.065431, 
  0.065965, 0.066499, 0.067048, 0.067597, 0.068132, 0.068696, 0.069245, 
  0.069795, 0.070359, 0.070924, 0.071489, 0.072053, 0.072618, 0.073182, 
  0.073762, 0.074342, 0.074922, 0.075502, 0.076081, 0.076677, 0.077256, 
  0.077852, 0.078447, 0.079042, 0.079652, 0.080247, 0.080858, 0.081468, 
  0.082078, 0.082689, 0.083299, 0.083925, 0.084535, 0.085161, 0.085786, 
  0.086412, 0.087053, 0.087678, 0.088319, 0.088960, 0.089601, 0.090242, 
  0.090883, 0.091539, 0.092195, 0.092851, 0.093507, 0.094163, 0.094820, 
  0.095491, 0.096147, 0.096818, 0.097490, 0.098161, 0.098848, 0.099519, 
  0.100206, 0.100893, 0.101579, 0.102266, 0.102953, 0.103655, 0.104341, 
  0.105043, 0.105745, 0.106447, 0.107164, 0.107866, 0.108583, 0.109285, 
  0.110002, 0.110719, 0.111452, 0.112169, 0.112902, 0.113634, 0.114351, 
  0.115099, 0.115831, 0.116564, 0.117311, 0.118044, 0.118807, 0.119554, 
  0.120317, 0.121096, 0.121874, 0.122652, 0.123445, 0.124239, 0.125032, 
  0.125841, 0.126665, 0.127474, 0.128298, 0.129137, 0.129976, 0.130816, 
  0.131670, 0.132525, 0.133379, 0.134249, 0.135119, 0.136004, 0.136889, 
  0.137774, 0.138659, 0.139559, 0.140459, 0.141375, 0.142290, 0.143206, 
  0.144121, 0.145052, 0.145983, 0.146929, 0.147875, 0.148821, 0.149767, 
  0.150729, 0.151675, 0.152651, 0.153613, 0.154589, 0.155566, 0.156542, 
  0.157534, 0.158511, 0.159503, 0.160510, 0.161501, 0.162509, 0.163516, 
  0.164523, 0.165545, 0.166552, 0.167575, 0.168597, 0.169635, 0.170657, 
  0.171695, 0.172732, 0.173770, 0.174807, 0.175860, 0.176913, 0.177966, 
  0.179034, 0.180102, 0.181186, 0.182269, 0.183368, 0.184482, 0.185595, 
  0.186709, 0.187839, 0.188983, 0.190127, 0.191272, 0.192432, 0.193606, 
  0.194781, 0.195956, 0.197147, 0.198352, 0.199557, 0.200763, 0.201984, 
  0.203204, 0.204425, 0.205661, 0.206912, 0.208164, 0.209415, 0.210681, 
  0.211948, 0.213230, 0.214496, 0.215793, 0.217075, 0.218372, 0.219684, 
  0.220996, 0.222309, 0.223621, 0.224949, 0.226276, 0.227619, 0.228962, 
  0.230304, 0.231647, 0.233005, 0.234363, 0.235737, 0.237095, 0.238468, 
  0.239857, 0.241230, 0.242618, 0.244022, 0.245411, 0.246830, 0.248234, 
  0.249668, 0.251102, 0.252537, 0.253986, 0.255451, 0.256916, 0.258396, 
  0.259892, 0.261387, 0.262898, 0.264439, 0.265965, 0.267521, 0.269093, 
  0.270680, 0.272267, 0.273884, 0.275517, 0.277150, 0.278813, 0.280491, 
  0.282185, 0.283894, 0.285634, 0.287373, 0.289143, 0.290929, 0.292744, 
  0.294575, 0.296437, 0.298329, 0.300252, 0.302205, 0.304204, 0.306233, 
  0.308278, 0.310384, 0.312505, 0.314656, 0.316838, 0.319066, 0.321309, 
  0.323598, 0.325917, 0.328267, 0.330648, 0.333059, 0.335500, 0.337972, 
  0.340475, 0.343008, 0.345586, 0.348180, 0.350805, 0.353460, 0.356207, 
  0.359060, 0.361990, 0.365011, 0.368124, 0.371298, 0.374533, 0.377844, 
  0.381186, 0.384573, 0.387991, 0.391455, 0.394919, 0.398398, 0.401892, 
  0.405386, 0.408865, 0.412314, 0.415793, 0.419287, 0.422797, 0.426337, 
  0.429908, 0.433509, 0.437140, 0.440787, 0.444465, 0.448173, 0.451911, 
  0.455695, 0.459495, 0.463325, 0.467201, 0.471092, 0.475029, 0.478996, 
  0.483009, 0.487053, 0.491142, 0.495262, 0.499428, 0.503639, 0.507897, 
  0.512184, 0.516533, 0.520928, 0.525383, 0.529870, 0.534417, 0.539025, 
  0.543679, 0.548394, 0.553185, 0.558022, 0.562951, 0.567941, 0.572992, 
  0.578134, 0.583352, 0.588647, 0.593957, 0.599237, 0.604562, 0.609964, 
  0.615534, 0.621286, 0.627314, 0.633646, 0.640360, 0.647486, 0.655665, 
  0.665034, 0.675181, 0.685725, 0.696254, 0.706340, 0.716121, 0.725917, 
  0.735698, 0.745480, 0.755261, 0.765057, 0.774548, 0.783734, 0.792920, 
  0.802441, 0.812634, 0.823804, 0.836881, 0.851774, 0.867369, 0.882582, 
  0.897261, 0.911940, 0.926619, 0.941299, 0.955962, 0.970642, 0.985321, 
  1.000000
};

double dimage_itrc[512] = {
  0.000000, 0.001450, 0.002838, 0.004196, 0.005524, 0.006821, 0.008087, 
  0.009323, 0.010544, 0.011765, 0.012970, 0.014176, 0.015381, 0.016587, 
  0.017807, 0.019043, 0.020310, 0.021592, 0.022889, 0.024247, 0.025620, 
  0.027054, 0.028519, 0.030045, 0.031632, 0.033280, 0.034989, 0.036774, 
  0.038636, 0.040574, 0.042603, 0.044709, 0.046921, 0.049210, 0.051575, 
  0.053986, 0.056489, 0.059037, 0.061646, 0.064302, 0.067033, 0.069810, 
  0.072648, 0.075532, 0.078462, 0.081437, 0.084459, 0.087526, 0.090639, 
  0.093782, 0.096971, 0.100206, 0.103456, 0.106752, 0.110079, 0.113436, 
  0.116808, 0.120226, 0.123659, 0.127108, 0.130587, 0.134081, 0.137591, 
  0.141115, 0.144656, 0.148226, 0.151843, 0.155520, 0.159243, 0.163012, 
  0.166842, 0.170703, 0.174594, 0.178531, 0.182513, 0.186511, 0.190555, 
  0.194614, 0.198703, 0.202823, 0.206943, 0.211093, 0.215259, 0.219440, 
  0.223621, 0.227817, 0.232013, 0.236225, 0.240421, 0.244617, 0.248814, 
  0.252995, 0.257176, 0.261341, 0.265492, 0.269627, 0.273732, 0.277852, 
  0.281987, 0.286168, 0.290379, 0.294606, 0.298863, 0.303136, 0.307424, 
  0.311727, 0.316045, 0.320363, 0.324681, 0.329015, 0.333333, 0.337636, 
  0.341955, 0.346242, 0.350515, 0.354772, 0.359014, 0.363226, 0.367391, 
  0.371542, 0.375662, 0.379736, 0.383764, 0.387762, 0.391699, 0.395590, 
  0.399420, 0.403204, 0.406928, 0.410575, 0.414176, 0.417716, 0.421195, 
  0.424628, 0.428016, 0.431357, 0.434668, 0.437934, 0.441154, 0.444343, 
  0.447517, 0.450645, 0.453758, 0.456855, 0.459922, 0.462974, 0.466011, 
  0.469047, 0.472068, 0.475090, 0.478111, 0.481132, 0.484154, 0.487175, 
  0.490211, 0.493263, 0.496330, 0.499413, 0.502525, 0.505653, 0.508812, 
  0.511986, 0.515190, 0.518425, 0.521660, 0.524926, 0.528191, 0.531472, 
  0.534768, 0.538064, 0.541360, 0.544656, 0.547967, 0.551263, 0.554559, 
  0.557839, 0.561120, 0.564401, 0.567651, 0.570901, 0.574121, 0.577325, 
  0.580514, 0.583673, 0.586801, 0.589914, 0.592996, 0.596033, 0.599039, 
  0.602014, 0.604959, 0.607843, 0.610697, 0.613519, 0.616281, 0.619028, 
  0.621744, 0.624414, 0.627070, 0.629694, 0.632288, 0.634867, 0.637400, 
  0.639933, 0.642420, 0.644892, 0.647349, 0.649790, 0.652201, 0.654612, 
  0.656992, 0.659358, 0.661707, 0.664042, 0.666377, 0.668681, 0.671000, 
  0.673289, 0.675578, 0.677867, 0.680140, 0.682414, 0.684672, 0.686946, 
  0.689204, 0.691463, 0.693706, 0.695949, 0.698161, 0.700359, 0.702556, 
  0.704723, 0.706889, 0.709041, 0.711177, 0.713313, 0.715435, 0.717525, 
  0.719631, 0.721706, 0.723781, 0.725841, 0.727901, 0.729946, 0.731975, 
  0.734005, 0.736034, 0.738048, 0.740047, 0.742046, 0.744045, 0.746029, 
  0.748013, 0.749981, 0.751949, 0.753918, 0.755886, 0.757839, 0.759792, 
  0.761746, 0.763699, 0.765652, 0.767605, 0.769543, 0.771481, 0.773419, 
  0.775341, 0.777264, 0.779187, 0.781094, 0.782986, 0.784878, 0.786755, 
  0.788617, 0.790463, 0.792309, 0.794141, 0.795956, 0.797757, 0.799542, 
  0.801297, 0.803052, 0.804791, 0.806500, 0.808194, 0.809873, 0.811536, 
  0.813169, 0.814786, 0.816373, 0.817945, 0.819486, 0.820996, 0.822492, 
  0.823957, 0.825406, 0.826841, 0.828260, 0.829648, 0.831022, 0.832395, 
  0.833738, 0.835065, 0.836393, 0.837705, 0.839002, 0.840299, 0.841581, 
  0.842863, 0.844129, 0.845396, 0.846647, 0.847913, 0.849165, 0.850431, 
  0.851682, 0.852949, 0.854200, 0.855467, 0.856748, 0.858015, 0.859297, 
  0.860594, 0.861875, 0.863172, 0.864469, 0.865766, 0.867048, 0.868345, 
  0.869642, 0.870924, 0.872221, 0.873503, 0.874784, 0.876051, 0.877317, 
  0.878584, 0.879835, 0.881086, 0.882322, 0.883558, 0.884779, 0.885985, 
  0.887175, 0.888365, 0.889540, 0.890700, 0.891844, 0.892973, 0.894072, 
  0.895171, 0.896254, 0.897322, 0.898360, 0.899382, 0.900389, 0.901381, 
  0.902358, 0.903304, 0.904250, 0.905180, 0.906081, 0.906981, 0.907881, 
  0.908751, 0.909621, 0.910460, 0.911315, 0.912154, 0.912978, 0.913802, 
  0.914611, 0.915419, 0.916213, 0.917021, 0.917815, 0.918593, 0.919387, 
  0.920165, 0.920958, 0.921736, 0.922530, 0.923308, 0.924102, 0.924895, 
  0.925689, 0.926482, 0.927260, 0.928054, 0.928832, 0.929610, 0.930388, 
  0.931151, 0.931914, 0.932677, 0.933440, 0.934188, 0.934936, 0.935683, 
  0.936431, 0.937163, 0.937896, 0.938628, 0.939361, 0.940078, 0.940810, 
  0.941527, 0.942229, 0.942947, 0.943648, 0.944350, 0.945037, 0.945739, 
  0.946426, 0.947112, 0.947799, 0.948470, 0.949142, 0.949813, 0.950484, 
  0.951141, 0.951797, 0.952453, 0.953109, 0.953750, 0.954391, 0.955032, 
  0.955673, 0.956298, 0.956939, 0.957565, 0.958175, 0.958801, 0.959411, 
  0.960021, 0.960616, 0.961227, 0.961822, 0.962417, 0.962997, 0.963592, 
  0.964172, 0.964752, 0.965332, 0.965896, 0.966461, 0.967025, 0.967590, 
  0.968139, 0.968688, 0.969238, 0.969772, 0.970306, 0.970825, 0.971344, 
  0.971847, 0.972351, 0.972854, 0.973342, 0.973831, 0.974319, 0.974792, 
  0.975280, 0.975753, 0.976226, 0.976699, 0.977157, 0.977630, 0.978103, 
  0.978561, 0.979034, 0.979507, 0.979980, 0.980453, 0.980926, 0.981399, 
  0.981888, 0.982361, 0.982849, 0.983337, 0.983841, 0.984344, 0.984848, 
  0.985351, 0.985870, 0.986374, 0.986893, 0.987411, 0.987930, 0.988449, 
  0.988968, 0.989487, 0.990005, 0.990539, 0.991058, 0.991577, 0.992111, 
  0.992630, 0.993164, 0.993683, 0.994217, 0.994751, 0.995270, 0.995804, 
  0.996323, 0.996857, 0.997375, 0.997910, 0.998428, 0.998947, 0.999481, 
  1.000000
};
