'''OpenGL extension ARB.vertex_type_2_10_10_10_rev

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.vertex_type_2_10_10_10_rev to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds the following data formats:
	
	Two new vertex attribute data formats: a signed 2.10.10.10 and an
	unsigned 2.10.10.10 vertex data format. These vertex data formats
	describe a 4 component stream which can be used to store normals or
	other attributes in a quantized form. Normals, tangents, binormals
	and other vertex attributes can often be specified at reduced
	precision without introducing noticeable artifacts, reducing the
	amount of memory and memory bandwidth they consume.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/vertex_type_2_10_10_10_rev.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.vertex_type_2_10_10_10_rev import *
from OpenGL.raw.GL.ARB.vertex_type_2_10_10_10_rev import _EXTENSION_NAME

def glInitVertexType2101010RevARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION