// Copyright 2004 "Gilles Degottex"

// This file is part of "fmit"

// "fmit" is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// "fmit" is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "GLVolumeHistory.h"

static const unsigned char g_icon_volume_graph[] = {
	0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
	0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20,
	0x08, 0x06, 0x00, 0x00, 0x00, 0x73, 0x7a, 0x7a, 0xf4, 0x00, 0x00, 0x06,
	0x83, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xb5, 0xd7, 0x59, 0x6c, 0x54,
	0xd7, 0x19, 0xc0, 0xf1, 0xff, 0xdd, 0xe6, 0xce, 0xcc, 0x9d, 0x19, 0x8f,
	0xf7, 0xb1, 0xf1, 0xd8, 0x9e, 0xc1, 0x6b, 0xcd, 0x62, 0x23, 0x4c, 0x1c,
	0xc4, 0x52, 0x9a, 0x84, 0xf2, 0x10, 0x08, 0x52, 0x17, 0x1e, 0xaa, 0x54,
	0xed, 0x43, 0xd3, 0x36, 0x7d, 0x69, 0xd4, 0x3e, 0xa4, 0xd0, 0xb7, 0xbe,
	0xb4, 0x51, 0x53, 0xa9, 0x8d, 0xaa, 0x34, 0x95, 0x1a, 0x35, 0x0f, 0x88,
	0x2c, 0x6a, 0x4a, 0x24, 0xa8, 0x4a, 0x94, 0x02, 0x0d, 0x34, 0x21, 0xec,
	0x9b, 0x31, 0x06, 0x4c, 0x60, 0xa8, 0xf7, 0xf1, 0x78, 0x9b, 0xed, 0xee,
	0x7d, 0x00, 0x13, 0x63, 0x3c, 0xb6, 0x83, 0xe8, 0x27, 0x8d, 0x34, 0x73,
	0x74, 0xbe, 0xf3, 0xfd, 0x74, 0xee, 0x39, 0xf7, 0x9c, 0x11, 0x78, 0xf4,
	0xf0, 0x03, 0xdf, 0x02, 0x9a, 0x45, 0x49, 0x2a, 0x77, 0x6c, 0xbb, 0x1b,
	0x38, 0x71, 0xef, 0xb3, 0xe4, 0x10, 0x1e, 0xa5, 0xb2, 0x2c, 0x2b, 0xbb,
	0x81, 0xdd, 0x15, 0xd5, 0xb5, 0xb4, 0xac, 0xee, 0xf4, 0x04, 0x42, 0x61,
	0x25, 0x71, 0xb3, 0x37, 0xdb, 0x7b, 0xe1, 0x94, 0xe8, 0x38, 0xf6, 0x09,
	0x3d, 0x9f, 0xfb, 0x1e, 0x70, 0xfb, 0xff, 0x01, 0xf0, 0x7b, 0x54, 0xef,
	0x15, 0x2d, 0x58, 0x54, 0xf9, 0xc3, 0x5f, 0xbc, 0xe2, 0x8d, 0xb7, 0xac,
	0xe4, 0xd3, 0x7f, 0x1d, 0xa4, 0xf7, 0xe2, 0x19, 0x04, 0x51, 0x42, 0x14,
	0x05, 0xb2, 0xe9, 0x49, 0xeb, 0xc2, 0x89, 0xa3, 0xa6, 0x65, 0x59, 0xbb,
	0xc1, 0xfd, 0x03, 0xe0, 0x3c, 0x36, 0x80, 0xac, 0x7a, 0x4f, 0x95, 0x57,
	0x54, 0xad, 0x7d, 0xf9, 0xd5, 0xb7, 0x90, 0x24, 0x99, 0xbf, 0xfe, 0xfe,
	0x57, 0x34, 0xac, 0x5a, 0x4f, 0xb4, 0xa1, 0x0d, 0x00, 0xdb, 0xb6, 0xe8,
	0x3e, 0x79, 0x98, 0xa9, 0xe4, 0x20, 0x7d, 0x3d, 0xe7, 0x32, 0x13, 0x63,
	0x23, 0x57, 0x0d, 0x3d, 0xbf, 0x09, 0xc8, 0x16, 0x1a, 0x53, 0x5a, 0x6a,
	0x71, 0xc5, 0xab, 0xfd, 0x40, 0xc0, 0x7d, 0xe1, 0xc7, 0x7b, 0x5e, 0x15,
	0xaa, 0xa2, 0x31, 0xf6, 0xfe, 0xf1, 0xd7, 0xb4, 0x6f, 0xda, 0x4e, 0x79,
	0x75, 0xdd, 0xfd, 0x3e, 0xa2, 0x28, 0x52, 0x19, 0x5d, 0x8e, 0x1a, 0x08,
	0x91, 0x99, 0x4e, 0x79, 0x64, 0x59, 0x2e, 0xcd, 0xa6, 0xa7, 0x9b, 0x1c,
	0xdb, 0xfe, 0x5b, 0xa1, 0x71, 0xc5, 0x25, 0xd6, 0x6f, 0x94, 0x15, 0xe5,
	0x77, 0xcd, 0xab, 0x3a, 0x85, 0xc6, 0xb6, 0x0e, 0x86, 0xfb, 0x6f, 0xa3,
	0xf8, 0x03, 0x04, 0xc3, 0xa5, 0xf3, 0x76, 0xae, 0x5c, 0x16, 0xe7, 0xab,
	0x3b, 0xbe, 0x4f, 0x51, 0x69, 0x44, 0x55, 0x14, 0xcf, 0x4e, 0x04, 0xe1,
	0x85, 0x42, 0x03, 0x2f, 0x65, 0x06, 0xfc, 0xbe, 0x60, 0xf8, 0xb8, 0xa5,
	0xe7, 0x22, 0x2f, 0xee, 0xf9, 0x2d, 0xa1, 0x70, 0x09, 0x1f, 0xec, 0xfd,
	0x33, 0x2b, 0x9e, 0x78, 0x06, 0x59, 0xf1, 0x14, 0x4c, 0x92, 0x64, 0x85,
	0xb2, 0xaa, 0x3a, 0x2c, 0x23, 0x2b, 0x8f, 0xf4, 0xdf, 0xfa, 0xba, 0xeb,
	0x38, 0x07, 0x81, 0xa1, 0xb9, 0xfd, 0x16, 0x9d, 0x01, 0x5f, 0x30, 0xfc,
	0x4e, 0x65, 0x7d, 0x4b, 0xbc, 0x79, 0x55, 0x27, 0xcb, 0xea, 0x1b, 0x48,
	0x4f, 0x4f, 0x62, 0x18, 0x26, 0xaa, 0x4f, 0x5b, 0x54, 0x1e, 0x2e, 0x8b,
	0x50, 0x51, 0xd3, 0x48, 0xd7, 0x96, 0x67, 0x15, 0xc5, 0xa3, 0x1e, 0x00,
	0x02, 0x5f, 0x0a, 0xe0, 0xd5, 0x42, 0x3f, 0xaf, 0x6b, 0x5b, 0xb7, 0x11,
	0xd7, 0x15, 0xeb, 0x1a, 0x5a, 0x00, 0x18, 0x4c, 0xdc, 0xa4, 0x34, 0x12,
	0x5d, 0xb4, 0xf8, 0x4c, 0xac, 0x78, 0xe2, 0x6b, 0xe4, 0xf2, 0x39, 0x21,
	0x52, 0x13, 0x0b, 0x03, 0xdf, 0x5d, 0x32, 0x40, 0x94, 0xa4, 0xce, 0x50,
	0x59, 0xe4, 0x67, 0xcb, 0x3b, 0x36, 0x16, 0xe5, 0xd3, 0x13, 0x44, 0x6a,
	0x62, 0x00, 0x8c, 0x27, 0x87, 0xd1, 0x42, 0x25, 0x4b, 0x06, 0x00, 0xac,
	0xd9, 0xb4, 0x9d, 0xaa, 0xda, 0xb8, 0x5f, 0xf5, 0xfa, 0x7e, 0xba, 0x54,
	0x40, 0x89, 0x3f, 0x54, 0xba, 0xaf, 0xe3, 0x99, 0x6f, 0x47, 0x00, 0xd2,
	0x13, 0x49, 0x22, 0xd1, 0x7a, 0x00, 0x52, 0xa3, 0xc3, 0x04, 0x42, 0xc5,
	0x5f, 0x0a, 0x50, 0x5c, 0x5e, 0x8d, 0x65, 0xda, 0x20, 0x08, 0x51, 0x60,
	0xdd, 0x62, 0x00, 0xc1, 0x17, 0x0c, 0xef, 0x5f, 0xb3, 0x75, 0x57, 0x5c,
	0x56, 0x54, 0x6c, 0xcb, 0x24, 0x3d, 0x99, 0x22, 0x52, 0x73, 0x17, 0x30,
	0x9e, 0x1c, 0x26, 0x50, 0x54, 0x72, 0xef, 0xfb, 0x10, 0xbd, 0x17, 0x4f,
	0x92, 0xcf, 0x65, 0x16, 0x45, 0x44, 0xea, 0x9a, 0x58, 0xd9, 0xb9, 0x41,
	0x96, 0x15, 0xcf, 0x4f, 0x16, 0x04, 0x78, 0xb5, 0xd0, 0x2b, 0x4d, 0x9d,
	0x4f, 0x75, 0x04, 0x4b, 0x2a, 0x04, 0x00, 0x3d, 0x3b, 0x8d, 0xaa, 0xfa,
	0xf0, 0x6b, 0x41, 0x00, 0x4c, 0xd3, 0x44, 0x92, 0x15, 0x06, 0xef, 0xdc,
	0xe4, 0xc4, 0x27, 0xc7, 0x48, 0x8c, 0x4e, 0x71, 0xe4, 0xd0, 0x07, 0x24,
	0x87, 0xfe, 0xbb, 0x20, 0xa0, 0x71, 0x75, 0x17, 0x92, 0xe4, 0x91, 0x5d,
	0xc7, 0xd9, 0x05, 0x04, 0xe7, 0x05, 0xc8, 0x1e, 0x75, 0x5b, 0x59, 0xcd,
	0xf2, 0xe7, 0x6b, 0x9a, 0xdb, 0xef, 0xaf, 0x56, 0xd5, 0x17, 0x40, 0xcf,
	0x67, 0x31, 0x0d, 0x1d, 0x80, 0x70, 0x71, 0x29, 0x99, 0xa9, 0x09, 0x6e,
	0xf4, 0x5e, 0x46, 0x09, 0x94, 0x22, 0x08, 0x22, 0x4a, 0x28, 0xc2, 0x95,
	0x8b, 0xa7, 0x17, 0x04, 0x78, 0x54, 0x1f, 0x08, 0x12, 0x91, 0x68, 0xcc,
	0x04, 0xbe, 0x31, 0x1f, 0xa0, 0xdc, 0x1f, 0x2a, 0x79, 0x7d, 0xe5, 0xe6,
	0x1d, 0x95, 0xb3, 0x13, 0x25, 0xc5, 0x83, 0x57, 0x0b, 0x92, 0x1c, 0x1e,
	0x00, 0x20, 0x12, 0x8d, 0x31, 0x9e, 0x1c, 0x98, 0x6b, 0x27, 0x6b, 0x49,
	0xdc, 0xf9, 0xbc, 0x77, 0x41, 0x44, 0x79, 0x75, 0x3d, 0x55, 0xd1, 0x98,
	0x1f, 0x68, 0x7b, 0x08, 0xe0, 0x0d, 0x14, 0xbd, 0xd4, 0xba, 0x7e, 0x5b,
	0x9d, 0x28, 0xc9, 0x0f, 0x25, 0x6a, 0xa1, 0x12, 0x46, 0x07, 0xef, 0x4e,
	0x71, 0xa4, 0xa6, 0x8e, 0xc9, 0xe4, 0x30, 0x82, 0xf8, 0x20, 0x40, 0xf6,
	0x6a, 0xf4, 0xf5, 0x76, 0x2f, 0x08, 0x28, 0x2a, 0xab, 0x42, 0x56, 0x3c,
	0xa2, 0xea, 0xf3, 0xb7, 0xce, 0x05, 0x08, 0xb2, 0xe2, 0xf9, 0x66, 0x69,
	0x75, 0x6c, 0xde, 0xc3, 0xc9, 0x17, 0x2c, 0xba, 0xff, 0x8c, 0x2b, 0xaa,
	0x6b, 0x99, 0x4c, 0x0d, 0xcd, 0x7b, 0x8a, 0xe9, 0x86, 0xb5, 0x20, 0xa0,
	0xb8, 0x3c, 0x82, 0x6d, 0x5b, 0x08, 0x82, 0xb0, 0x7c, 0x2e, 0xa0, 0xae,
	0x38, 0x52, 0x1b, 0x12, 0x84, 0xf9, 0x0f, 0x47, 0x8f, 0x3f, 0xc4, 0xe8,
	0x50, 0x3f, 0x00, 0x5e, 0x9f, 0x1f, 0x3d, 0x97, 0xc1, 0xa3, 0x3c, 0xfc,
	0x16, 0x77, 0x1c, 0x77, 0x41, 0x80, 0x4f, 0x0b, 0x61, 0x59, 0x16, 0x96,
	0x69, 0x2e, 0x9b, 0x0b, 0x48, 0x99, 0xf9, 0x9c, 0x5d, 0x28, 0xd1, 0x1f,
	0x2a, 0xa1, 0xaf, 0xe7, 0xe2, 0x17, 0xbf, 0x35, 0x8d, 0xc6, 0xb6, 0x0e,
	0x8c, 0xe9, 0xe1, 0x39, 0x3d, 0x17, 0x06, 0x00, 0xc8, 0xb2, 0x07, 0xcb,
	0x34, 0x82, 0x80, 0x36, 0x1b, 0x30, 0x65, 0xe4, 0xb3, 0x05, 0xe7, 0x2f,
	0x12, 0x6b, 0xe5, 0xf3, 0x6b, 0x97, 0x18, 0x19, 0xb8, 0x03, 0xc0, 0x86,
	0xad, 0xcf, 0x91, 0xb8, 0x7a, 0x9e, 0xb2, 0xe2, 0x62, 0x5c, 0xe7, 0x8b,
	0xfb, 0x46, 0xa1, 0x19, 0x7c, 0x20, 0x04, 0x11, 0xc5, 0xa3, 0x9a, 0x40,
	0x74, 0x36, 0x00, 0x53, 0xcf, 0xa5, 0x5d, 0x77, 0xfe, 0xcb, 0x8b, 0xea,
	0x0f, 0x50, 0x15, 0x6f, 0xe3, 0xd8, 0xa1, 0xf7, 0x01, 0x58, 0xde, 0xb2,
	0x8a, 0xd1, 0xc1, 0x5b, 0x74, 0x74, 0x6d, 0xc1, 0xcd, 0x8c, 0xe0, 0x3a,
	0x0e, 0x96, 0x9e, 0xa5, 0xb2, 0xb2, 0x62, 0x09, 0x00, 0x30, 0x0d, 0x5d,
	0x06, 0xc6, 0x1e, 0x00, 0x18, 0xf9, 0xcc, 0x9b, 0x83, 0x37, 0xba, 0xf5,
	0x42, 0x79, 0x35, 0x2d, 0x6b, 0x38, 0x76, 0x68, 0x3f, 0x8e, 0x7d, 0xf7,
	0x49, 0xd5, 0x37, 0x34, 0x33, 0x3d, 0x9e, 0xe4, 0xe9, 0x67, 0x77, 0x11,
	0x2d, 0xd3, 0x68, 0x8a, 0x45, 0xe9, 0xe8, 0xda, 0xb2, 0x68, 0x7d, 0xcb,
	0xd0, 0x91, 0x65, 0x25, 0x07, 0x8c, 0x3e, 0x00, 0xd0, 0xb3, 0xe9, 0xd7,
	0xae, 0x7e, 0xf6, 0xe1, 0xf9, 0xf1, 0xa1, 0xc4, 0xbc, 0xd3, 0x50, 0xba,
	0x2c, 0x0e, 0x08, 0x5c, 0x3a, 0xfd, 0x1f, 0x00, 0x36, 0x6c, 0xdd, 0xc9,
	0x95, 0x33, 0x47, 0x11, 0x25, 0x89, 0x96, 0xf6, 0x27, 0x89, 0xb7, 0xac,
	0x5e, 0xb4, 0xb8, 0x6d, 0x5b, 0xd8, 0x96, 0x89, 0xa2, 0xaa, 0x89, 0x99,
	0xb6, 0xd9, 0x9b, 0xd9, 0xc8, 0x4d, 0x4f, 0x3c, 0x75, 0xee, 0xa3, 0xf7,
	0x0e, 0x5e, 0x3f, 0x7d, 0x24, 0xe5, 0xba, 0x0f, 0x2e, 0x28, 0x41, 0x10,
	0xa8, 0x6e, 0x6e, 0xe7, 0xe8, 0xc1, 0x77, 0x01, 0x28, 0x2a, 0x2e, 0xa5,
	0xb2, 0xaa, 0x8a, 0x81, 0x5b, 0xd7, 0x16, 0x2d, 0x3c, 0x13, 0xe9, 0x89,
	0x31, 0x70, 0x5d, 0x5c, 0xc7, 0xb9, 0x32, 0xd3, 0x36, 0x77, 0x2f, 0x99,
	0x96, 0x91, 0xdf, 0x37, 0x3d, 0x3e, 0x32, 0xd6, 0x7f, 0xfd, 0x62, 0x9b,
	0xc7, 0xab, 0xf9, 0x03, 0xc5, 0xe5, 0xf2, 0xcc, 0xe2, 0xd2, 0x8a, 0xca,
	0x38, 0x73, 0x78, 0x3f, 0xd5, 0xd1, 0x18, 0x55, 0xb5, 0x71, 0x1a, 0xbf,
	0xd2, 0xce, 0xa1, 0xf7, 0xfe, 0x42, 0x4d, 0xc3, 0x0a, 0xa4, 0x79, 0x5e,
	0x60, 0x73, 0xe3, 0xf2, 0xa9, 0xc3, 0x64, 0xa6, 0x52, 0xf6, 0xc0, 0xed,
	0xbe, 0x77, 0x81, 0x7f, 0xcf, 0x07, 0x00, 0xc0, 0xb6, 0xcc, 0x73, 0x46,
	0x2e, 0xfd, 0x46, 0x6a, 0xf0, 0x96, 0xde, 0x7f, 0xed, 0x42, 0xcc, 0xe3,
	0xd3, 0xfc, 0x81, 0x70, 0xb9, 0x2c, 0x7b, 0x54, 0xb4, 0x70, 0x19, 0xff,
	0xdc, 0xf7, 0x3a, 0xeb, 0x36, 0x6f, 0x23, 0x10, 0x0a, 0x53, 0xdb, 0xd8,
	0xc2, 0xd1, 0x03, 0x6f, 0x13, 0x6d, 0x58, 0xb1, 0x60, 0x71, 0xc7, 0xb6,
	0xb9, 0x76, 0xee, 0x18, 0xdd, 0xa7, 0x8f, 0xdb, 0x8e, 0x63, 0xef, 0x01,
	0xfa, 0x0b, 0x02, 0x66, 0x1c, 0xb6, 0x69, 0x1c, 0x9f, 0x0b, 0x89, 0xc4,
	0x5a, 0x65, 0x23, 0x9f, 0xe1, 0x93, 0x0f, 0xdf, 0x67, 0xc3, 0xd6, 0x9d,
	0x84, 0xc2, 0x25, 0xa4, 0x27, 0xc6, 0xe8, 0xeb, 0x3e, 0x47, 0x65, 0x6d,
	0x43, 0xc1, 0xc1, 0x7a, 0xce, 0x1e, 0x63, 0x7a, 0x6c, 0xc8, 0x49, 0x0e,
	0x0f, 0x7c, 0x64, 0x5b, 0xe6, 0x6f, 0x66, 0xda, 0x97, 0x72, 0x29, 0x9d,
	0x05, 0xb9, 0xad, 0xf7, 0x5f, 0xbb, 0x10, 0xab, 0x6e, 0x58, 0xe9, 0x1f,
	0x1b, 0x4c, 0xc8, 0xc3, 0x77, 0x6e, 0xd2, 0xde, 0xb5, 0x99, 0xba, 0x86,
	0x56, 0x04, 0xc1, 0xe5, 0xe3, 0x7f, 0xbc, 0x4d, 0xa4, 0xb6, 0xf1, 0xa1,
	0xcb, 0x6a, 0x72, 0x30, 0xc1, 0x8d, 0x4b, 0x9f, 0x72, 0xe1, 0xc4, 0x51,
	0xcb, 0x34, 0xf5, 0xe7, 0xb8, 0xb7, 0x05, 0x97, 0x0a, 0x78, 0x08, 0x32,
	0x3e, 0x94, 0xd0, 0x5d, 0xc7, 0x6d, 0x4c, 0xf4, 0xf5, 0x14, 0xdd, 0xbe,
	0xd1, 0x23, 0x34, 0xaf, 0x5a, 0x4b, 0x4d, 0xac, 0x91, 0xa6, 0x15, 0x77,
	0xd7, 0x44, 0x6a, 0x74, 0x08, 0x51, 0x94, 0x98, 0x4a, 0x8d, 0xd2, 0x73,
	0xf6, 0x63, 0x52, 0x43, 0xb7, 0xc8, 0x65, 0xa6, 0x8c, 0xb1, 0x91, 0x81,
	0xbd, 0xb6, 0x6d, 0xbd, 0x39, 0x7b, 0xd0, 0x47, 0xfa, 0x6f, 0x78, 0x2f,
	0x54, 0xc5, 0xab, 0xfd, 0x52, 0x96, 0xc4, 0x97, 0x5c, 0xd7, 0xd5, 0xbe,
	0xf3, 0xe2, 0xcb, 0xac, 0x7f, 0x7a, 0x07, 0x00, 0x03, 0x89, 0x9b, 0x5c,
	0xbf, 0x7c, 0x16, 0x45, 0x55, 0x89, 0xc6, 0x9a, 0xf9, 0xfb, 0x5b, 0xaf,
	0xe9, 0x3d, 0xe7, 0x3f, 0x1b, 0x30, 0xf4, 0x7c, 0x17, 0x30, 0xf2, 0xb8,
	0x00, 0xf7, 0x21, 0x92, 0xe2, 0x79, 0x43, 0x14, 0xc4, 0xe7, 0xa3, 0xf1,
	0x26, 0x67, 0xed, 0xc6, 0xad, 0x72, 0x75, 0x5d, 0x9c, 0xcc, 0xf4, 0x24,
	0x89, 0x1b, 0x57, 0xed, 0x23, 0x07, 0xde, 0xb1, 0x81, 0x93, 0x86, 0x9e,
	0xdf, 0x0e, 0x4c, 0xcc, 0x4d, 0x7e, 0x1c, 0x80, 0x99, 0x28, 0x03, 0x7e,
	0xe4, 0xf5, 0x69, 0x4f, 0x0a, 0x82, 0xd0, 0x2a, 0x88, 0x42, 0xca, 0x32,
	0xcd, 0xab, 0x86, 0x9e, 0xff, 0x13, 0x70, 0xbc, 0x50, 0xd2, 0xff, 0x00,
	0x3c, 0x39, 0x7b, 0xa0, 0x73, 0xfc, 0x63, 0xd4, 0x00, 0x00, 0x00, 0x00,
	0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

#include <iostream>
using namespace std;
#include <GL/glut.h>
#include <qtimer.h>
#include <qimage.h>
#include <Music/Music.h>

GLVolumeHistory::Note::Note(int h)
: ht(h)
{
}
GLVolumeHistory::Note::Note(int h, int num, int den)
: ht(h)
{
	factor = QString::number(num)+"/"+QString::number(den);
}
GLVolumeHistory::Note::Note(int h, float cents)
: ht(h)
{
	factor = QString::number(cents);
}
QString GLVolumeHistory::Note::getName() const
{
	return QString::fromStdString(Music::h2n(ht))+factor;
}

GLVolumeHistory::GLVolumeHistory(QWidget* parent)
: QGLWidget(parent)
, View(tr("Volume history"), this)
{
	QPixmap img;
	setting_show->setCheckable(true);
	img.loadFromData(g_icon_volume_graph, sizeof(g_icon_volume_graph), "PNG");
	setting_show->setIcon(QIcon(img));
	setting_show->setChecked(false);
	hide();

	m_volume_treshold = -100;

	setting_keep = new QAction(tr("Keep previous notes"), this);
	setting_keep->setCheckable(true);
	setting_keep->setChecked(false);
	connect(setting_keep, SIGNAL(toggled(bool)), this, SLOT(keepPreviousNotes(bool)));
    m_popup_menu.addAction(setting_keep);
}

void GLVolumeHistory::save()
{
	s_settings->setValue("keep", setting_keep->isChecked());
}
void GLVolumeHistory::load()
{
	setting_keep->setChecked(s_settings->value("keep", setting_keep->isChecked()).toBool());
}
void GLVolumeHistory::clearSettings()
{
	s_settings->remove("keep");
}

void GLVolumeHistory::addNote(GLVolumeHistory::Note note)
{
	m_notes.push_back(note);

	if(!setting_keep->isChecked())
		while(m_notes.size()>1)
			m_notes.pop_front();
}
void GLVolumeHistory::addVolume(float vol)
{
	m_notes.back().volumes.push_back(vol);
}

void GLVolumeHistory::keepPreviousNotes(bool keep)
{
	if(!keep)
		while(m_notes.size()>1)
			m_notes.pop_front();
}

void GLVolumeHistory::setVolumeTreshold(int treshold)
{
	m_volume_treshold = treshold;
}

void GLVolumeHistory::initializeGL()
{
	// Set the clear color to black
	glClearColor(1.0, 1.0, 1.0, 0.0);

	// glShadeModel( GL_FLAT );
	glShadeModel( GL_SMOOTH );

	glLoadIdentity();
}

void GLVolumeHistory::paintGL()
{
// 	cerr << "GLVolumeHistory::paintGL " << m_notes.size() << endl;

	glClear(GL_COLOR_BUFFER_BIT);

	glLineWidth(1.0f);

	// name
	string str = tr("Volume").toStdString();
	glColor3f(0.75,0.75,0.75);
	glRasterPos2i(2, height()-20);
	for(size_t i = 0; i < str.length(); i++)
		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, (unsigned char)str[i]);

	int s = 2+fontMetrics().width("50%");

	// horiz lines
	if(2*height()/50>2)
	{
		glBegin(GL_LINES);
		float gray = 0.875;
		glColor3f(gray, gray, gray);
		for(int h=2; h<50; h+=2)
		{
			glVertex2i(s, h*height()/50);
			glVertex2i(width(), h*height()/50);
		}
		glEnd();
	}
	if(10*height()/50>2)
	{
		glBegin(GL_LINES);
		float gray = 0.75;
		glColor3f(gray, gray, gray);
		for(int h=10; h<50; h+=10)
		{
			glVertex2i(s, h*height()/50);
			glVertex2i(width(), h*height()/50);
		}
		glEnd();
	}

	int dy = 3;
	glColor3f(0.5f,0.5f,0.5f);
	string sfraq = "-10";
	glRasterPos2i(2, height()-10*height()/50-dy);
	for(size_t i = 0; i < sfraq.size(); i++)
		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, (unsigned char)sfraq[i]);
	sfraq = "-20";
	glRasterPos2i(2, height()-20*height()/50-dy);
	for(size_t i = 0; i < sfraq.size(); i++)
		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, (unsigned char)sfraq[i]);
	sfraq = "-30";
	glRasterPos2i(2, height()-30*height()/50-dy);
	for(size_t i = 0; i < sfraq.size(); i++)
		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, (unsigned char)sfraq[i]);
	sfraq = "-40";
	glRasterPos2i(2, height()-40*height()/50-dy);
	for(size_t i = 0; i < sfraq.size(); i++)
		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, (unsigned char)sfraq[i]);

	glColor3f(1.0,0.5,0.5);
	glLineWidth(2.0f);
	glBegin(GL_LINES);
	glVertex2f(s, height()+height()*m_volume_treshold/50);
	glVertex2f(width(), height()+height()*m_volume_treshold/50);
	glEnd();

	// volumes
	if(!m_notes.empty())
	{
		int total_size = 0;
		for(size_t i=0; i<m_notes.size(); i++)
			total_size += m_notes[i].volumes.size()-1;

		float step = float(width()-s)/total_size;

//		cerr << "total_size=" << total_size << " step=" << step << endl;

		int curr_total = 0;
		for(size_t i=0; i<m_notes.size(); i++)
		{
			float x = s+step*curr_total;

			// if it's not the first, add a separation
			if(i>0)
			{
				glColor3f(0.75,0.75,0.75);
				glLineWidth(1.0f);
				glBegin(GL_LINES);
				glVertex2f(x, 0);	glVertex2f(x, height());
				glEnd();
			}

			// the note name
			string str = Music::h2n(m_notes[i].ht);
			glColor3f(0.0,0.0,1.0);
			glRasterPos2f(x+2, 2);
			for(size_t c=0; c<str.length(); c++)
				glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, (unsigned char)str[c]);

			// draw the volume graph
			if(!m_notes[i].volumes.empty())
			{
// 				glColor3f(0.33,0.33,1.0);
				glColor3f(0.0f,0.0f,0.0f);
				glLineWidth(2.0f);
				glBegin(GL_LINE_STRIP);
				for(int j=0; j<int(m_notes[i].volumes.size()); j++)
					glVertex2f(x+j*step, height()+height()*m_notes[i].volumes[j]/50.0);
				glEnd();
			}

			curr_total += m_notes[i].volumes.size()-1;
		}
	}

	glFlush();
}

void GLVolumeHistory::resizeGL( int w, int h )
{
	// Set the new viewport size
	glViewport(0, 0, (GLint)w, (GLint)h);

	// Choose the projection matrix to be the matrix
	// manipulated by the following calls
	glMatrixMode(GL_PROJECTION);

	// Set the projection matrix to be the identity matrix
	glLoadIdentity();

	// Define the dimensions of the Orthographic Viewing Volume
	glOrtho(0.0, w, 0.0, h, 0.0, 1.0);

	// Choose the modelview matrix to be the matrix
	// manipulated by further calls
	glMatrixMode(GL_MODELVIEW);
}

