/*
 * $Id: conn_cardbus.c,v 1.6 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "conn_cardbus.h"

#define CHIP_(x) conn_cardbus_ ## x

struct cpssp {
	struct sig_boolean *port_conn;
	unsigned int state_power;
	unsigned int state_reset_hash_;
	struct sig_boolean_or *port_int_hash_;
	unsigned int state_int_hash_;
	struct sig_cardbus *port_dev;
	struct sig_pci_bus_main *port_main;
};

void *
CHIP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_cardbus *port_dev,
	struct sig_boolean *port_power,
	struct sig_boolean *port_reset_hash_,
	struct sig_pci_bus_main *port_main,
	struct sig_boolean *port_conn,
	struct sig_boolean_or *port_int_hash_
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* FIXME */

	/* Call */
	/* Out */
	/* In */

	return cpssp;
}

void
CHIP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	/* FIXME */

	shm_free(cpssp);
}

void
CHIP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
CHIP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
