#
# Copyright 2024 Centreon (http://www.centreon.com/)
#
# Centreon is a full-fledged industry-strength solution that meets
# the needs in IT infrastructure and application monitoring for
# service performance.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

package centreon::common::ibm::tapelibrary::snmp::mode::hardware;

use base qw(centreon::plugins::templates::hardware);

use strict;
use warnings;

sub set_system {
    my ($self, %options) = @_;
    
    $self->{cb_hook2} = 'snmp_execute';
    
    $self->{thresholds} = {
        status => [
            ['notinstalled', 'OK'],
            ['notok', 'CRITICAL'],
            ['ok', 'OK'],
        ],        
        operational => [
            ['unknown', 'UNKNOWN'],
            ['other', 'UNKNOWN'],
            ['ok', 'OK'],
            ['degraded', 'WARNING'],
            ['stressed', 'WARNING'],
            ['predictiveFailure', 'WARNING'],
            ['error', 'CRITICAL'],
            ['non-RecoverableError', 'CRITICAL'],
            ['starting', 'OK'],
            ['stopping', 'OK'],
            ['stopped', 'OK'],
            ['inService', 'CRITICAL'],
            ['noContact', 'WARNING'],
            ['lostCommunication', 'WARNING'],
            ['aborted', 'OK'],
            ['dormant', 'OK'],
            ['supportingEntityInError', 'CRITICAL'],
            ['completed', 'OK'],
            ['powerMode', 'OK'],
        ],
    };
    
    $self->{components_path} = 'centreon::common::ibm::tapelibrary::snmp::mode::components';
    $self->{components_module} = ['chassis', 'drive', 'changer', 'psu'];
}

sub snmp_execute {
    my ($self, %options) = @_;
    
    $self->{snmp} = $options{snmp};
    $self->{results} = $self->{snmp}->get_multiple_table(oids => $self->{request});
}

sub new {
    my ($class, %options) = @_;
    my $self = $class->SUPER::new(package => __PACKAGE__, %options, no_absent => 1, no_performance => 1);
    bless $self, $class;
    
    $options{options}->add_options(arguments => { 
    });
    
    return $self;
}

1;

__END__

=head1 MODE

Check hardware.

=over 8

=item B<--component>

Which component to check (default: '.*').
Can be: 'chassis', 'drive', 'changer', 'psu'.

=item B<--filter>

Exclude the items given as a comma-separated list (example: --filter=drive).
You can also exclude items from specific instances: --filter=drive,1

=item B<--no-component>

Define the expected status if no components are found (default: critical).


=item B<--threshold-overload>

Use this option to override the status returned by the plugin when the status label matches a regular expression (syntax: section,[instance,]status,regexp).
Example: --threshold-overload='chassis,CRITICAL,degraded'

=back

=cut
