// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "Font.pypp.hpp"

namespace bp = boost::python;

struct Font_wrapper : CEGUI::Font, bp::wrapper< CEGUI::Font > {

    virtual void notifyDisplaySizeChanged( ::CEGUI::Size const & size ) {
        if( bp::override func_notifyDisplaySizeChanged = this->get_override( "notifyDisplaySizeChanged" ) )
            func_notifyDisplaySizeChanged( boost::ref(size) );
        else{
            this->CEGUI::Font::notifyDisplaySizeChanged( boost::ref(size) );
        }
    }
    
    void default_notifyDisplaySizeChanged( ::CEGUI::Size const & size ) {
        CEGUI::Font::notifyDisplaySizeChanged( boost::ref(size) );
    }

    virtual void updateFont(  ){
        bp::override func_updateFont = this->get_override( "updateFont" );
        func_updateFont(  );
    }

    virtual void writeXMLToStream_impl( ::CEGUI::XMLSerializer & xml_stream ) const {
        bp::override func_writeXMLToStream_impl = this->get_override( "writeXMLToStream_impl" );
        func_writeXMLToStream_impl( boost::ref(xml_stream) );
    }

};

void register_Font_class(){

    { //::CEGUI::Font
        typedef bp::class_< Font_wrapper, bp::bases< CEGUI::PropertySet >, boost::noncopyable > Font_exposer_t;
        Font_exposer_t Font_exposer = Font_exposer_t( "Font", "*!\n\
        \n\
            Class that encapsulates a typeface.\n\
        \n\
            A Font object is created for each unique typeface required.\n\
            The Font class provides methods for loading typefaces from various sources,\n\
            and then for outputting text via the Renderer object.\n\
        \n\
            This class is not specific to any font renderer, it just provides the\n\
            basic interfaces needed to manage fonts.\n\
        *\n", bp::no_init );
        bp::scope Font_scope( Font_exposer );
        { //::CEGUI::Font::drawText
        
            typedef void ( ::CEGUI::Font::*drawText_function_type )( ::CEGUI::GeometryBuffer &,::CEGUI::String const &,::CEGUI::Vector2 const &,::CEGUI::Rect const *,::CEGUI::ColourRect const &,float const,float const,float const ) ;
            
            Font_exposer.def( 
                "drawText"
                , drawText_function_type( &::CEGUI::Font::drawText )
                , ( bp::arg("buffer"), bp::arg("text"), bp::arg("position"), bp::arg("clip_rect"), bp::arg("colours"), bp::arg("space_extra")=0.0f, bp::arg("x_scale")=1.0e+0f, bp::arg("y_scale")=1.0e+0f ) );
        
        }
        { //::CEGUI::Font::getBaseline
        
            typedef float ( ::CEGUI::Font::*getBaseline_function_type )( float ) const;
            
            Font_exposer.def( 
                "getBaseline"
                , getBaseline_function_type( &::CEGUI::Font::getBaseline )
                , ( bp::arg("y_scale")=1.0e+0f )
                , "*!\n\
                \n\
                    Return the number of pixels from the top of the highest glyph\n\
                    to the baseline\n\
            \n\
                @param y_scale\n\
                    Scaling factor to be applied to the baseline distance, where 1.0f\n\
                    is considered to be 'normal'.\n\
            \n\
                @return\n\
                    pixel spacing from top of front glyphs to baseline\n\
                *\n" );
        
        }
        { //::CEGUI::Font::getCharAtPixel
        
            typedef ::size_t ( ::CEGUI::Font::*getCharAtPixel_function_type )( ::CEGUI::String const &,float,float ) const;
            
            Font_exposer.def( 
                "getCharAtPixel"
                , getCharAtPixel_function_type( &::CEGUI::Font::getCharAtPixel )
                , ( bp::arg("text"), bp::arg("pixel"), bp::arg("x_scale")=1.0e+0f )
                , "*!\n\
                \n\
                    Return the index of the closest text character in String  text\n\
                    that corresponds to pixel location  pixel if the text were rendered.\n\
            \n\
                @param text\n\
                    String object containing the text.\n\
            \n\
                @param pixel\n\
                    Specifies the (horizontal) pixel offset to return the character\n\
                    index for.\n\
            \n\
                @param x_scale\n\
                    Scaling factor to be applied to each glyph's x axis when measuring\n\
                    the text extent, where 1.0f is considered to be 'normal'.\n\
            \n\
                @return\n\
                    Returns a character index into String  text for the character that\n\
                    would be rendered closest to horizontal pixel offset  pixel if the\n\
                    text were to be rendered via this Font.  Range of the return is from\n\
                    0 to text.length(), so may actually return an index past the end of\n\
                    the string, which indicates  pixel was beyond the last character.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::getCharAtPixel
        
            typedef ::size_t ( ::CEGUI::Font::*getCharAtPixel_function_type )( ::CEGUI::String const &,::size_t,float,float ) const;
            
            Font_exposer.def( 
                "getCharAtPixel"
                , getCharAtPixel_function_type( &::CEGUI::Font::getCharAtPixel )
                , ( bp::arg("text"), bp::arg("start_char"), bp::arg("pixel"), bp::arg("x_scale")=1.0e+0f )
                , "*!\n\
                \n\
                    Return the index of the closest text character in String  text,\n\
                    starting at character index  start_char, that corresponds\n\
                    to pixel location  pixel if the text were to be rendered.\n\
            \n\
                @param text\n\
                    String object containing the text.\n\
            \n\
                @param start_char\n\
                    index of the first character to consider.  This is the lowest\n\
                    value that will be returned from the call.\n\
            \n\
                @param pixel\n\
                    Specifies the (horizontal) pixel offset to return the character\n\
                    index for.\n\
            \n\
                @param x_scale\n\
                    Scaling factor to be applied to each glyph's x axis when measuring\n\
                    the text extent, where 1.0f is considered to be 'normal'.\n\
            \n\
                @return\n\
                    Returns a character index into String  text for the character that\n\
                    would be rendered closest to horizontal pixel offset  pixel if the\n\
                    text were to be rendered via this Font.  Range of the return is from\n\
                    0 to text.length(), so may actually return an index past the end of\n\
                    the string, which indicates  pixel was beyond the last character.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::getDefaultResourceGroup
        
            typedef ::CEGUI::String const & ( *getDefaultResourceGroup_function_type )(  );
            
            Font_exposer.def( 
                "getDefaultResourceGroup"
                , getDefaultResourceGroup_function_type( &::CEGUI::Font::getDefaultResourceGroup )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Returns the default resource group currently set for Fonts.\n\
            \n\
                @return\n\
                    String describing the default resource group identifier that will be\n\
                    used when loading font data.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::getFontHeight
        
            typedef float ( ::CEGUI::Font::*getFontHeight_function_type )( float ) const;
            
            Font_exposer.def( 
                "getFontHeight"
                , getFontHeight_function_type( &::CEGUI::Font::getFontHeight )
                , ( bp::arg("y_scale")=1.0e+0f )
                , "*!\n\
                \n\
                    return the exact pixel height of the font.\n\
            \n\
                @param y_scale\n\
                    Scaling factor to be applied to the height, where 1.0f\n\
                    is considered to be 'normal'.\n\
            \n\
                @return\n\
                    float value describing the pixel height of the font without\n\
                    any additional padding.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::getGlyphData
        
            typedef ::CEGUI::FontGlyph const * ( ::CEGUI::Font::*getGlyphData_function_type )( ::CEGUI::utf32 ) const;
            
            Font_exposer.def( 
                "getGlyphData"
                , getGlyphData_function_type( &::CEGUI::Font::getGlyphData )
                , ( bp::arg("codepoint") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return a pointer to the glyphDat struct for the given codepoint,\n\
                    or 0 if the codepoint does not have a glyph defined.\n\
            \n\
                @param codepoint\n\
                    utf32 codepoint to return the glyphDat structure for.\n\
            \n\
                @return\n\
                    Pointer to the glyphDat struct for  codepoint, or 0 if no glyph\n\
                    is defined for  codepoint.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::getLineSpacing
        
            typedef float ( ::CEGUI::Font::*getLineSpacing_function_type )( float ) const;
            
            Font_exposer.def( 
                "getLineSpacing"
                , getLineSpacing_function_type( &::CEGUI::Font::getLineSpacing )
                , ( bp::arg("y_scale")=1.0e+0f )
                , "*!\n\
                \n\
                    Return the pixel line spacing value for.\n\
            \n\
                @param y_scale\n\
                    Scaling factor to be applied to the line spacing, where 1.0f\n\
                    is considered to be 'normal'.\n\
            \n\
                @return\n\
                    Number of pixels between vertical base lines, i.e. The minimum\n\
                    pixel space between two lines of text.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::getName
        
            typedef ::CEGUI::String const & ( ::CEGUI::Font::*getName_function_type )(  ) const;
            
            Font_exposer.def( 
                "getName"
                , getName_function_type( &::CEGUI::Font::getName )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! Return the string holding the font name.\n" );
        
        }
        { //::CEGUI::Font::getNativeResolution
        
            typedef ::CEGUI::Size ( ::CEGUI::Font::*getNativeResolution_function_type )(  ) const;
            
            Font_exposer.def( 
                "getNativeResolution"
                , getNativeResolution_function_type( &::CEGUI::Font::getNativeResolution )
                , "*!\n\
                \n\
                    Return the native display size for this Font.  This is only relevant if\n\
                    the Font is being auto-scaled.\n\
            \n\
                @return\n\
                    Size object describing the native display size for this Font.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::getTextExtent
        
            typedef float ( ::CEGUI::Font::*getTextExtent_function_type )( ::CEGUI::String const &,float ) const;
            
            Font_exposer.def( 
                "getTextExtent"
                , getTextExtent_function_type( &::CEGUI::Font::getTextExtent )
                , ( bp::arg("text"), bp::arg("x_scale")=1.0e+0f )
                , "*!\n\
                \n\
                    Return the pixel width of the specified text if rendered with\n\
                    this Font.\n\
            \n\
                @param text\n\
                    String object containing the text to return the rendered pixel\n\
                    width for.\n\
            \n\
                @param x_scale\n\
                    Scaling factor to be applied to each glyph's x axis when\n\
                    measuring the extent, where 1.0f is considered to be 'normal'.\n\
            \n\
                @return\n\
                    Number of pixels that  text will occupy when rendered with\n\
                    this Font.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::getTypeName
        
            typedef ::CEGUI::String const & ( ::CEGUI::Font::*getTypeName_function_type )(  ) const;
            
            Font_exposer.def( 
                "getTypeName"
                , getTypeName_function_type( &::CEGUI::Font::getTypeName )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! Return the type of the font.\n" );
        
        }
        { //::CEGUI::Font::isAutoScaled
        
            typedef bool ( ::CEGUI::Font::*isAutoScaled_function_type )(  ) const;
            
            Font_exposer.def( 
                "isAutoScaled"
                , isAutoScaled_function_type( &::CEGUI::Font::isAutoScaled )
                , "*!\n\
                \n\
                    Return whether this Font is auto-scaled.\n\
            \n\
                @return\n\
                    - true if Font is auto-scaled.\n\
                    - false if Font is not auto-scaled.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::isCodepointAvailable
        
            typedef bool ( ::CEGUI::Font::*isCodepointAvailable_function_type )( ::CEGUI::utf32 ) const;
            
            Font_exposer.def( 
                "isCodepointAvailable"
                , isCodepointAvailable_function_type( &::CEGUI::Font::isCodepointAvailable )
                , ( bp::arg("cp") )
                , "*!\n\
                \n\
                    Return whether this Font can draw the specified code-point\n\
            \n\
                @param cp\n\
                    utf32 code point that is the subject of the query.\n\
            \n\
                @return\n\
                    true if the font contains a mapping for code point  cp,\n\
                    false if it does not contain a mapping for  cp.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::notifyDisplaySizeChanged
        
            typedef void ( ::CEGUI::Font::*notifyDisplaySizeChanged_function_type )( ::CEGUI::Size const & ) ;
            typedef void ( Font_wrapper::*default_notifyDisplaySizeChanged_function_type )( ::CEGUI::Size const & ) ;
            
            Font_exposer.def( 
                "notifyDisplaySizeChanged"
                , notifyDisplaySizeChanged_function_type(&::CEGUI::Font::notifyDisplaySizeChanged)
                , default_notifyDisplaySizeChanged_function_type(&Font_wrapper::default_notifyDisplaySizeChanged)
                , ( bp::arg("size") ) );
        
        }
        { //::CEGUI::Font::setAutoScaled
        
            typedef void ( ::CEGUI::Font::*setAutoScaled_function_type )( bool const ) ;
            
            Font_exposer.def( 
                "setAutoScaled"
                , setAutoScaled_function_type( &::CEGUI::Font::setAutoScaled )
                , ( bp::arg("auto_scaled") )
                , "*!\n\
                \n\
                    Enable or disable auto-scaling for this Font.\n\
            \n\
                @param auto_scaled\n\
                    - true to enable auto-scaling.\n\
                    - false to disable auto-scaling.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::setDefaultResourceGroup
        
            typedef void ( *setDefaultResourceGroup_function_type )( ::CEGUI::String const & );
            
            Font_exposer.def( 
                "setDefaultResourceGroup"
                , setDefaultResourceGroup_function_type( &::CEGUI::Font::setDefaultResourceGroup )
                , ( bp::arg("resourceGroup") )
                , "*!\n\
                \n\
                    Sets the default resource group to be used when loading font data\n\
            \n\
                @param resourceGroup\n\
                    String describing the default resource group identifier to be used.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::setNativeResolution
        
            typedef void ( ::CEGUI::Font::*setNativeResolution_function_type )( ::CEGUI::Size const & ) ;
            
            Font_exposer.def( 
                "setNativeResolution"
                , setNativeResolution_function_type( &::CEGUI::Font::setNativeResolution )
                , ( bp::arg("size") )
                , "*!\n\
                \n\
                    Set the native resolution for this Font\n\
            \n\
                @param size\n\
                    Size object describing the new native screen resolution for this Font.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::updateFont
        
            typedef void ( Font_wrapper::*updateFont_function_type )(  ) ;
            
            Font_exposer.def( 
                "updateFont"
                , updateFont_function_type( &Font_wrapper::updateFont )
                , "! Update the font as needed, according to the current parameters.\n" );
        
        }
        { //::CEGUI::Font::writeXMLToStream
        
            typedef void ( ::CEGUI::Font::*writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            Font_exposer.def( 
                "writeXMLToStream"
                , writeXMLToStream_function_type( &::CEGUI::Font::writeXMLToStream )
                , ( bp::arg("xml_stream") )
                , "*!\n\
                \n\
                    Writes an xml representation of this Font to  out_stream.\n\
            \n\
                @param xml_stream\n\
                    Stream where xml data should be output.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Font::writeXMLToStream_impl
        
            typedef void ( Font_wrapper::*writeXMLToStream_impl_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            Font_exposer.def( 
                "writeXMLToStream_impl"
                , writeXMLToStream_impl_function_type( &Font_wrapper::writeXMLToStream_impl )
                , ( bp::arg("xml_stream") )
                , "! implementaion version of writeXMLToStream.\n" );
        
        }
        Font_exposer.def_readonly( "DefaultColour", CEGUI::Font::DefaultColour, "! Colour value used whenever a colour is not specified.\n" );
        Font_exposer.staticmethod( "getDefaultResourceGroup" );
        Font_exposer.staticmethod( "setDefaultResourceGroup" );
    }

}
