#
# Script designed to be tested from inside the CamiTK Python interpreter using PythonManager::runScript
# See TestPythonScript.cpp
# 
# The requirements (if any) must defined in the the QRC file
#
import camitk

count = len(camitk.Application.getTopLevelComponents())
assert count == 0, 'There should be not component opened yet'

camitk.Application.open(camitk.Core.getTestDataDir() + "/amos_0336.camitk")

assert len(camitk.Application.getTopLevelComponents()) == 16, f"There should 16 top level components in amos_0336 not {camitk.Application.getTopLevelComponents()}"
assert camitk.Application.getTopLevelComponents()[0].getName() == "amos_0336", f"The first top level component should be amos_0336 not {camitk.Application.getTopLevelComponents()[0].getName()}"

assert camitk.Application.closeAll(), f"Close all should return true as no components have been modified"
