// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "NamespaceAC.h"
#include "CFlow.h"
#ifdef ACMODEL
#include "Elements.h"
#endif

// Puma includes
#include "Puma/CTypeInfo.h"
using namespace Puma;

// C++ includes
#include <sstream>
using std::ostringstream;
using std::endl;


string NamespaceAC::def (string size_type) {
  string acdef;
#ifdef ACMODEL
  ostringstream execnum, callnum, consnum, destnum;
  execnum << JPT_Execution;
  callnum << JPT_Call;
  consnum << JPT_Construction;
  destnum << JPT_Destruction;
#endif

  acdef += 
    "\n"
    "#ifndef __ac_h_\n"
    "#define __ac_h_\n"
    "#ifdef __cplusplus\n"
    "namespace AC {\n"
    "  typedef const char* Type;\n"
#ifdef ACMODEL
    "  enum JPType { CALL = " + callnum.str() +
    ", EXECUTION = " + execnum.str() +  ", CONSTRUCTION = " + consnum.str() +
    ", DESTRUCTION = " + destnum.str() + " };\n"
#else
    "  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, "
    "CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };\n"
#endif
    "  enum Protection { PROT_NONE, PROT_PRIVATE, PROT_PROTECTED, PROT_PUBLIC };\n"
    "  enum Specifiers { SPEC_NONE = 0x0 , SPEC_STATIC = 0x1, SPEC_MUTABLE = 0x2, SPEC_VIRTUAL = 0x4 };\n"
    "  struct Action {\n"
    "    void **_args; void *_result; void *_target; void *_that; void *_fptr;\n"
    "    void (*_wrapper)(Action &);\n"
    "    inline void trigger () { _wrapper (*this); }\n"
    "  };\n"
    "  struct AnyResultBuffer {};\n"
    "  template <typename T> struct ResultBuffer : "
    "public AnyResultBuffer {\n"
    "    struct { char _array[sizeof (T)]; } _data;\n"
    "    ~ResultBuffer () { ((T&)_data).T::~T(); }\n"
    "    operator T& () const { return (T&)_data; }\n"
    "  };\n"
    "  template <typename T, typename N> struct TL {\n"
    "    typedef T type; typedef N next; enum { ARGS = next::ARGS + 1 };\n"
    "  };\n"
    "  struct TLE { enum { ARGS = 0 }; };\n"
    "  template <typename T> struct Referred { typedef T type; };\n"
    "  template <typename T> struct Referred<T &> { typedef T type; };\n"
    "  template <typename TL, int I> struct Arg {\n"
    "    typedef typename Arg<typename TL::next, I - 1>::Type Type;\n"
    "    typedef typename Referred<Type>::type ReferredType;\n"
    "  };\n"
    "  template <typename TL> struct Arg<TL, 0> {\n"
    "    typedef typename TL::type Type;\n"
    "    typedef typename Referred<Type>::type ReferredType;\n"
    "  };\n"
    "  template <typename T> int ttest(...);\n"
    "  template <typename T> char ttest(typename T::__TI const volatile *);\n"
    "  template<typename T> struct HasTypeInfo {\n" 
    "    enum { RET=((sizeof(ttest<T>(0))==1)?1:0) };\n"
    "  };\n"
    "  template<typename T, int HAVE = HasTypeInfo<T>::RET> struct TypeInfo {\n"
    "    enum { AVAILABLE = 0 };\n"
    "  };\n"
		"  template<typename T> struct TypeInfo<T, 1> : T::__TI {\n"
    "    enum { AVAILABLE = 1 };\n"
		"	 };\n"
    "  template<typename T> struct RT {};\n"
    "  template<typename T> RT<T> rt_deduce (const T&) { return RT<T>(); }\n"
    "  struct Cnv { template<typename T> operator RT<T>() const { return RT<T>(); }};\n"
    "  #define __AC_TYPEOF(expr) (1?AC::Cnv():AC::rt_deduce(expr))\n";

  // class(es) needed to implement CFlows
  acdef += CFlow::ac_namespace_contributions ();
  
  acdef +=
    "}\n"
    "inline void * operator new (";
    
  if (size_type == "") {
    ostringstream size_type_stream;
    size_type_stream << *CTypeInfo::CTYPE_SIZE_T;
    acdef += size_type_stream.str ();
  }
  else
    acdef += size_type;

  acdef +=
    ", AC::AnyResultBuffer *p) { return p; }\n"
    "inline void operator delete "
    "(void *, AC::AnyResultBuffer *) { } // for VC++\n"
    "#endif // __cplusplus\n"
    "#endif // __ac_h_\n";

  return acdef;
}
