# Contributing to ArrayFire #

## Reporting Issues ##

We both value and encourage the community to provide feedback about using ArrayFire and the issues they are facing.
The more detailed the information, the easier it is for the developers to resolve the issue.

Issues can span a variety of topics including:
- Feature requests
- Bug reports
- Build Issues
- Performance improvements
- New hardware / backend support

We use the github [issue tracker](https://github.com/arrayfire/arrayfire/issues?state=open) to track our issues. Technical issues can also be discussed on our [user forum](https://groups.google.com/forum/#!forum/arrayfire-users).

## Contributing Code ##

If you want to contribute code, we suggest you use the one of the following methods.

- [Using Github](https://github.com/arrayfire/arrayfire/wiki/Contribute-code-using-github)
- [Using Email](https://github.com/arrayfire/arrayfire/wiki/Contribute-code-using-email)

Key areas of code contributions include:
- [New features](https://github.com/arrayfire/arrayfire/issues?q=is%3Aopen+is%3Aissue+label%3Afeature)
    - You can refer to [this](https://github.com/arrayfire/arrayfire/wiki/How-to-Add-a-New-Function-to-ArrayFire) wiki page to get started on how to add a new function to the library.
- [Bug fixes](https://github.com/arrayfire/arrayfire/labels/bug)
- [Style changes](https://github.com/arrayfire/arrayfire/labels/style)
- [Performance improvements](https://github.com/arrayfire/arrayfire/labels/style)
- [New tests](https://github.com/arrayfire/arrayfire/labels/test)
- New examples!

##ArrayFire Based Projects##

You can also contribute to ArrayFire by helping out projects that use ArrayFire! For our part, in addition to the ArrayFire library we are also in the process of adding native bindings for numerous language. We currently support

- [Java](https://github.com/arrayfire/arrayfire_java)
- [R](https://github.com/arrayfire/arrayfire_r)
- [Fortran](https://github.com/arrayfire/arrayfire_fortran)

If you are experienced in any of these languages, you can help us improve these language bindings. If you prefer a different language that is not in the list, dive in and create a new repo!
