; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

; PR30281 - https://llvm.org/bugs/show_bug.cgi?id=30281

; All of these tests contain foldable division-by-constant instructions, but we
; can't assert that those folds have occurred before we process the later icmp.

define i32 @icmp_div(i16 %a, i16 %c) {
; CHECK-LABEL: @icmp_div(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i16 %a, 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label %then, label %exit
; CHECK:       then:
; CHECK-NEXT:    [[NOT_CMP:%.*]] = icmp eq i16 %c, 0
; CHECK-NEXT:    [[PHITMP1:%.*]] = sext i1 [[NOT_CMP]] to i32
; CHECK-NEXT:    br label %exit
; CHECK:       exit:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ -1, %entry ], [ [[PHITMP1]], %then ]
; CHECK-NEXT:    ret i32 [[PHI]]
;
entry:
  %tobool = icmp eq i16 %a, 0
  br i1 %tobool, label %then, label %exit

then:
  %div = sdiv i16 %c, -1
  %cmp = icmp ne i16 %div, 0
  br label %exit

exit:
  %phi = phi i1 [ false, %entry ], [ %cmp, %then ]
  %zext = zext i1 %phi to i32
  %add = add nsw i32 %zext, -1
  ret i32 %add
}

define i32 @icmp_div2(i16 %a, i16 %c) {
; CHECK-LABEL: @icmp_div2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i16 %a, 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label %then, label %exit
; CHECK:       then:
; CHECK-NEXT:    br label %exit
; CHECK:       exit:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ -1, %entry ], [ 0, %then ]
; CHECK-NEXT:    ret i32 [[PHI]]
;
entry:
  %tobool = icmp eq i16 %a, 0
  br i1 %tobool, label %then, label %exit

then:
  %div = sdiv i16 %c, 0
  %cmp = icmp ne i16 %div, 0
  br label %exit

exit:
  %phi = phi i1 [ false, %entry ], [ %cmp, %then ]
  %zext = zext i1 %phi to i32
  %add = add nsw i32 %zext, -1
  ret i32 %add
}

define i32 @icmp_div3(i16 %a, i16 %c) {
; CHECK-LABEL: @icmp_div3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i16 %a, 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label %then, label %exit
; CHECK:       then:
; CHECK-NEXT:    [[NOT_CMP:%.*]] = icmp eq i16 %c, 0
; CHECK-NEXT:    [[PHITMP1:%.*]] = sext i1 [[NOT_CMP]] to i32
; CHECK-NEXT:    br label %exit
; CHECK:       exit:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ -1, %entry ], [ [[PHITMP1]], %then ]
; CHECK-NEXT:    ret i32 [[PHI]]
;
entry:
  %tobool = icmp eq i16 %a, 0
  br i1 %tobool, label %then, label %exit

then:
  %div = sdiv i16 %c, 1
  %cmp = icmp ne i16 %div, 0
  br label %exit

exit:
  %phi = phi i1 [ false, %entry ], [ %cmp, %then ]
  %zext = zext i1 %phi to i32
  %add = add nsw i32 %zext, -1
  ret i32 %add
}

