/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoServerException;
import com.mongodb.ServerAddress;
import java.io.StringWriter;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.json.JsonWriter;

public class MongoCommandException
extends MongoServerException {
    private static final long serialVersionUID = 8160676451944215078L;
    private final BsonDocument response;

    public MongoCommandException(BsonDocument response, ServerAddress address) {
        super(MongoCommandException.extractErrorCode(response), String.format("Command failed with error %s: '%s' on server %s. The full response is %s", MongoCommandException.extractErrorCode(response), MongoCommandException.extractErrorMessage(response), address, MongoCommandException.getResponseAsJson(response)), address);
        this.response = response;
    }

    public int getErrorCode() {
        return this.getCode();
    }

    public String getErrorMessage() {
        return MongoCommandException.extractErrorMessage(this.response);
    }

    public BsonDocument getResponse() {
        return this.response;
    }

    private static String getResponseAsJson(BsonDocument commandResponse) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(writer);
        new BsonDocumentCodec().encode((BsonWriter)jsonWriter, commandResponse, EncoderContext.builder().build());
        return writer.toString();
    }

    private static int extractErrorCode(BsonDocument response) {
        return response.getNumber("code", new BsonInt32(-1)).intValue();
    }

    private static String extractErrorMessage(BsonDocument response) {
        return response.getString("errmsg", new BsonString("")).getValue();
    }
}

