#include <string_view>
#include <memory>
using namespace std;

#include "functor_json.h"
#include "functioncolumn.h"
#include "rowgroup.h"
using namespace execplan;
using namespace rowgroup;

#include "dataconvert.h"

#include "jsonhelpers.h"
using namespace funcexp::helpers;

namespace funcexp
{
CalpontSystemCatalog::ColType Func_json_equals::operationType(FunctionParm& fp,
                                                              CalpontSystemCatalog::ColType& resultType)
{
  return fp[0]->data()->resultType();
}

/**
 * getBoolVal API definition
 */
bool Func_json_equals::getBoolVal(Row& row, FunctionParm& fp, bool& isNull,
                                  CalpontSystemCatalog::ColType& type)
{
#if MYSQL_VERSION_ID >= 120100
  json_engine_t je;
  MEM_ROOT_DYNAMIC_ARRAY array;
  int je_stack[JSON_DEPTH_LIMIT], buffer_array[JSON_DEPTH_LIMIT];

  mem_root_dynamic_array_init(NULL, PSI_INSTRUMENT_MEM | MY_INIT_BUFFER_USED | MY_BUFFER_NO_RESIZE,
                              &je.stack, sizeof(int), &je_stack,
                              JSON_DEPTH_DEFAULT, 0, MYF(0));
  mem_root_dynamic_array_init(NULL, PSI_INSTRUMENT_MEM | MY_INIT_BUFFER_USED | MY_BUFFER_NO_RESIZE,
                              &array, sizeof(int), &buffer_array,
                              JSON_DEPTH_DEFAULT, 0, MYF(0));
#endif

  // auto release the DYNAMIC_STRING
  using DynamicString = unique_ptr<DYNAMIC_STRING, decltype(&dynstr_free)>;

  DynamicString str1{new DYNAMIC_STRING(), dynstr_free};
  if (init_dynamic_string(str1.get(), NULL, 0, 0))
  {
    isNull = true;
    return true;
  }

  DynamicString str2{new DYNAMIC_STRING(), dynstr_free};
  if (init_dynamic_string(str2.get(), NULL, 0, 0))
  {
    isNull = true;
    return true;
  }

  const auto js1_ns = fp[0]->data()->getStrVal(row, isNull);
  if (isNull)
    return false;

  const auto js2_ns = fp[1]->data()->getStrVal(row, isNull);
  if (isNull)
    return false;

  const string_view js1 = js1_ns.unsafeStringRef();
  const string_view js2 = js2_ns.unsafeStringRef();
  
  bool result = false;

#if MYSQL_VERSION_ID >= 120100
  if (json_normalize(str1.get(), js1.data(), js1.size(), getCharset(fp[0]), NULL, &je, &array))
#else
  if (json_normalize(str1.get(), js1.data(), js1.size(), getCharset(fp[0])))
#endif
  {
    isNull = true;
    return result;
  }

#if MYSQL_VERSION_ID >= 120100
  memset(je_stack, 0, sizeof(je_stack));
  memset(buffer_array, 0, sizeof(buffer_array));
#endif

#if MYSQL_VERSION_ID >= 120100
  if (json_normalize(str2.get(), js2.data(), js2.size(), getCharset(fp[1]), NULL, &je, &array))
#else
  if (json_normalize(str2.get(), js2.data(), js2.size(), getCharset(fp[1])))
#endif
  {
    isNull = true;
    return result;
  }

  result = strcmp(str1->str, str2->str) ? false : true;
  return result;
}
}  // namespace funcexp
