/*
 * Decompiled with CFR 0.152.
 */
package wrappers;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import wrappers.ApacheInterface;
import wrappers.JdbcInterface;
import wrappers.MariadbInterface;
import wrappers.MysqlInterface;
import wrappers.OracleInterface;
import wrappers.PostgresqlInterface;

public class Client {
    static boolean DEBUG = true;
    static final Console c = System.console();
    static JdbcInterface jdi = null;

    public static void main(String[] args) {
        int i2 = 0;
        int fsize = 0;
        boolean scrollable = false;
        String[] parms = new String[4];
        if (args.length > 0) {
            try {
                i2 = Integer.parseInt(args[i2]);
            }
            catch (NumberFormatException e2) {
                i2 = 0;
            }
        }
        switch (i2) {
            case 1: {
                jdi = new ApacheInterface(DEBUG);
                break;
            }
            case 2: {
                jdi = new MysqlInterface(DEBUG);
                break;
            }
            case 3: {
                jdi = new MariadbInterface(DEBUG);
                break;
            }
            case 4: {
                jdi = new OracleInterface(DEBUG);
                break;
            }
            case 5: {
                jdi = new PostgresqlInterface(DEBUG);
                break;
            }
            default: {
                jdi = new JdbcInterface(DEBUG);
            }
        }
        parms[0] = Client.getLine("Driver: ", false);
        parms[1] = Client.getLine("URL: ", false);
        parms[2] = Client.getLine("User: ", false);
        parms[3] = Client.getLine("Password: ", true);
        String s2 = Client.getLine("Fsize: ", false);
        fsize = s2 != null ? Integer.parseInt(s2) : 0;
        s2 = Client.getLine("Scrollable: ", false);
        scrollable = s2 != null ? s2.toLowerCase().charAt(0) != 'n' : false;
        int rc = jdi.JdbcConnect(parms, fsize, scrollable);
        if (rc == 0) {
            String query;
            System.out.println("Successfully connected to " + parms[1]);
            while ((query = Client.getLine("Query: ", false)) != null) {
                int n2 = jdi.Execute(query);
                System.out.println("Returned n = " + n2);
                int ncol = jdi.GetResult();
                if (ncol > 0) {
                    Client.PrintResult(ncol);
                    continue;
                }
                System.out.println("Affected rows = " + n2);
            }
            rc = jdi.JdbcDisconnect();
            System.out.println("Disconnect returned " + rc);
        } else {
            System.out.println(String.valueOf(jdi.GetErrmsg()) + " rc=" + rc);
        }
    }

    private static void PrintResult(int ncol) {
        Date date = new Date(0L);
        Time time = new Time(0L);
        Timestamp tsp = new Timestamp(0L);
        int i2 = 1;
        while (i2 <= ncol) {
            String columnName = jdi.ColumnName(i2);
            if (columnName == null) {
                return;
            }
            if (i2 > 1) {
                System.out.print("\t");
            }
            System.out.print(columnName);
            ++i2;
        }
        System.out.println();
        while (jdi.ReadNext() > 0) {
            i2 = 1;
            while (i2 <= ncol) {
                if (i2 > 1) {
                    System.out.print("\t");
                }
                if (DEBUG) {
                    System.out.print("(" + jdi.ColumnType(i2, null) + ")");
                }
                switch (jdi.ColumnType(i2, null)) {
                    case -1: 
                    case 1: 
                    case 12: {
                        System.out.print(jdi.StringField(i2, null));
                        break;
                    }
                    case 4: {
                        System.out.print(jdi.IntField(i2, null));
                        break;
                    }
                    case -5: {
                        System.out.print(jdi.BigintField(i2, null));
                        break;
                    }
                    case 92: {
                        time.setTime(jdi.TimeField(i2, null) * 1000);
                        System.out.print(time);
                        break;
                    }
                    case 91: {
                        date.setTime(jdi.DateField(i2, null) * 1000);
                        System.out.print(date);
                        break;
                    }
                    case 93: {
                        tsp.setTime(jdi.TimestampField(i2, null) * 1000);
                        System.out.print(tsp);
                        break;
                    }
                    case 5: {
                        System.out.print(jdi.IntField(i2, null));
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        System.out.print(jdi.DoubleField(i2, null));
                        break;
                    }
                    case 16: {
                        System.out.print(jdi.BooleanField(i2, null));
                    }
                }
                ++i2;
            }
            System.out.println();
        }
    }

    private static String getLine(String p2, boolean b2) {
        String response;
        if (c != null) {
            response = b2 ? new String(c.readPassword(p2, new Object[0])) : c.readLine(p2, new Object[0]);
        } else {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(p2);
            try {
                response = in.readLine();
            }
            catch (IOException e2) {
                response = "";
            }
        }
        return response.isEmpty() ? null : response;
    }
}

