#ifndef CRC32_CONSTANTS_H
#define CRC32_CONSTANTS_H

#ifdef __powerpc__

#define MAX_SIZE	32768
CONSTANTS:

	/* Reduce 262144 kbits to 1024 bits */
	/* x^261120 mod p(x)` << 1, x^261184 mod p(x)` << 1 */
	.octa 0x00000001651797d20000000099ea94a8

	/* x^260096 mod p(x)` << 1, x^260160 mod p(x)` << 1 */
	.octa 0x0000000021e0d56c00000000945a8420

	/* x^259072 mod p(x)` << 1, x^259136 mod p(x)` << 1 */
	.octa 0x000000000f95ecaa0000000030762706

	/* x^258048 mod p(x)` << 1, x^258112 mod p(x)` << 1 */
	.octa 0x00000001ebd224ac00000001a52fc582

	/* x^257024 mod p(x)` << 1, x^257088 mod p(x)` << 1 */
	.octa 0x000000000ccb97ca00000001a4a7167a

	/* x^256000 mod p(x)` << 1, x^256064 mod p(x)` << 1 */
	.octa 0x00000001006ec8a8000000000c18249a

	/* x^254976 mod p(x)` << 1, x^255040 mod p(x)` << 1 */
	.octa 0x000000014f58f19600000000a924ae7c

	/* x^253952 mod p(x)` << 1, x^254016 mod p(x)` << 1 */
	.octa 0x00000001a7192ca600000001e12ccc12

	/* x^252928 mod p(x)` << 1, x^252992 mod p(x)` << 1 */
	.octa 0x000000019a64bab200000000a0b9d4ac

	/* x^251904 mod p(x)` << 1, x^251968 mod p(x)` << 1 */
	.octa 0x0000000014f4ed2e0000000095e8ddfe

	/* x^250880 mod p(x)` << 1, x^250944 mod p(x)` << 1 */
	.octa 0x000000011092b6a200000000233fddc4

	/* x^249856 mod p(x)` << 1, x^249920 mod p(x)` << 1 */
	.octa 0x00000000c8a1629c00000001b4529b62

	/* x^248832 mod p(x)` << 1, x^248896 mod p(x)` << 1 */
	.octa 0x000000017bf32e8e00000001a7fa0e64

	/* x^247808 mod p(x)` << 1, x^247872 mod p(x)` << 1 */
	.octa 0x00000001f8cc658200000001b5334592

	/* x^246784 mod p(x)` << 1, x^246848 mod p(x)` << 1 */
	.octa 0x000000008631ddf0000000011f8ee1b4

	/* x^245760 mod p(x)` << 1, x^245824 mod p(x)` << 1 */
	.octa 0x000000007e5a76d0000000006252e632

	/* x^244736 mod p(x)` << 1, x^244800 mod p(x)` << 1 */
	.octa 0x000000002b09b31c00000000ab973e84

	/* x^243712 mod p(x)` << 1, x^243776 mod p(x)` << 1 */
	.octa 0x00000001b2df1f84000000007734f5ec

	/* x^242688 mod p(x)` << 1, x^242752 mod p(x)` << 1 */
	.octa 0x00000001d6f56afc000000007c547798

	/* x^241664 mod p(x)` << 1, x^241728 mod p(x)` << 1 */
	.octa 0x00000001b9b5e70c000000007ec40210

	/* x^240640 mod p(x)` << 1, x^240704 mod p(x)` << 1 */
	.octa 0x0000000034b626d200000001ab1695a8

	/* x^239616 mod p(x)` << 1, x^239680 mod p(x)` << 1 */
	.octa 0x000000014c53479a0000000090494bba

	/* x^238592 mod p(x)` << 1, x^238656 mod p(x)` << 1 */
	.octa 0x00000001a6d179a400000001123fb816

	/* x^237568 mod p(x)` << 1, x^237632 mod p(x)` << 1 */
	.octa 0x000000015abd16b400000001e188c74c

	/* x^236544 mod p(x)` << 1, x^236608 mod p(x)` << 1 */
	.octa 0x00000000018f985200000001c2d3451c

	/* x^235520 mod p(x)` << 1, x^235584 mod p(x)` << 1 */
	.octa 0x000000001fb3084a00000000f55cf1ca

	/* x^234496 mod p(x)` << 1, x^234560 mod p(x)` << 1 */
	.octa 0x00000000c53dfb0400000001a0531540

	/* x^233472 mod p(x)` << 1, x^233536 mod p(x)` << 1 */
	.octa 0x00000000e10c9ad60000000132cd7ebc

	/* x^232448 mod p(x)` << 1, x^232512 mod p(x)` << 1 */
	.octa 0x0000000025aa994a0000000073ab7f36

	/* x^231424 mod p(x)` << 1, x^231488 mod p(x)` << 1 */
	.octa 0x00000000fa3a74c40000000041aed1c2

	/* x^230400 mod p(x)` << 1, x^230464 mod p(x)` << 1 */
	.octa 0x0000000033eb3f400000000136c53800

	/* x^229376 mod p(x)` << 1, x^229440 mod p(x)` << 1 */
	.octa 0x000000017193f2960000000126835a30

	/* x^228352 mod p(x)` << 1, x^228416 mod p(x)` << 1 */
	.octa 0x0000000043f6c86a000000006241b502

	/* x^227328 mod p(x)` << 1, x^227392 mod p(x)` << 1 */
	.octa 0x000000016b513ec600000000d5196ad4

	/* x^226304 mod p(x)` << 1, x^226368 mod p(x)` << 1 */
	.octa 0x00000000c8f25b4e000000009cfa769a

	/* x^225280 mod p(x)` << 1, x^225344 mod p(x)` << 1 */
	.octa 0x00000001a45048ec00000000920e5df4

	/* x^224256 mod p(x)` << 1, x^224320 mod p(x)` << 1 */
	.octa 0x000000000c4410040000000169dc310e

	/* x^223232 mod p(x)` << 1, x^223296 mod p(x)` << 1 */
	.octa 0x000000000e17cad60000000009fc331c

	/* x^222208 mod p(x)` << 1, x^222272 mod p(x)` << 1 */
	.octa 0x00000001253ae964000000010d94a81e

	/* x^221184 mod p(x)` << 1, x^221248 mod p(x)` << 1 */
	.octa 0x00000001d7c88ebc0000000027a20ab2

	/* x^220160 mod p(x)` << 1, x^220224 mod p(x)` << 1 */
	.octa 0x00000001e7ca913a0000000114f87504

	/* x^219136 mod p(x)` << 1, x^219200 mod p(x)` << 1 */
	.octa 0x0000000033ed078a000000004b076d96

	/* x^218112 mod p(x)` << 1, x^218176 mod p(x)` << 1 */
	.octa 0x00000000e1839c7800000000da4d1e74

	/* x^217088 mod p(x)` << 1, x^217152 mod p(x)` << 1 */
	.octa 0x00000001322b267e000000001b81f672

	/* x^216064 mod p(x)` << 1, x^216128 mod p(x)` << 1 */
	.octa 0x00000000638231b6000000009367c988

	/* x^215040 mod p(x)` << 1, x^215104 mod p(x)` << 1 */
	.octa 0x00000001ee7f16f400000001717214ca

	/* x^214016 mod p(x)` << 1, x^214080 mod p(x)` << 1 */
	.octa 0x0000000117d9924a000000009f47d820

	/* x^212992 mod p(x)` << 1, x^213056 mod p(x)` << 1 */
	.octa 0x00000000e1a9e0c4000000010d9a47d2

	/* x^211968 mod p(x)` << 1, x^212032 mod p(x)` << 1 */
	.octa 0x00000001403731dc00000000a696c58c

	/* x^210944 mod p(x)` << 1, x^211008 mod p(x)` << 1 */
	.octa 0x00000001a5ea9682000000002aa28ec6

	/* x^209920 mod p(x)` << 1, x^209984 mod p(x)` << 1 */
	.octa 0x0000000101c5c57800000001fe18fd9a

	/* x^208896 mod p(x)` << 1, x^208960 mod p(x)` << 1 */
	.octa 0x00000000dddf6494000000019d4fc1ae

	/* x^207872 mod p(x)` << 1, x^207936 mod p(x)` << 1 */
	.octa 0x00000000f1c3db2800000001ba0e3dea

	/* x^206848 mod p(x)` << 1, x^206912 mod p(x)` << 1 */
	.octa 0x000000013112fb9c0000000074b59a5e

	/* x^205824 mod p(x)` << 1, x^205888 mod p(x)` << 1 */
	.octa 0x00000000b680b90600000000f2b5ea98

	/* x^204800 mod p(x)` << 1, x^204864 mod p(x)` << 1 */
	.octa 0x000000001a2829320000000187132676

	/* x^203776 mod p(x)` << 1, x^203840 mod p(x)` << 1 */
	.octa 0x0000000089406e7e000000010a8c6ad4

	/* x^202752 mod p(x)` << 1, x^202816 mod p(x)` << 1 */
	.octa 0x00000001def6be8c00000001e21dfe70

	/* x^201728 mod p(x)` << 1, x^201792 mod p(x)` << 1 */
	.octa 0x000000007525872800000001da0050e4

	/* x^200704 mod p(x)` << 1, x^200768 mod p(x)` << 1 */
	.octa 0x000000019536090a00000000772172ae

	/* x^199680 mod p(x)` << 1, x^199744 mod p(x)` << 1 */
	.octa 0x00000000f2455bfc00000000e47724aa

	/* x^198656 mod p(x)` << 1, x^198720 mod p(x)` << 1 */
	.octa 0x000000018c40baf4000000003cd63ac4

	/* x^197632 mod p(x)` << 1, x^197696 mod p(x)` << 1 */
	.octa 0x000000004cd390d400000001bf47d352

	/* x^196608 mod p(x)` << 1, x^196672 mod p(x)` << 1 */
	.octa 0x00000001e4ece95a000000018dc1d708

	/* x^195584 mod p(x)` << 1, x^195648 mod p(x)` << 1 */
	.octa 0x000000001a3ee918000000002d4620a4

	/* x^194560 mod p(x)` << 1, x^194624 mod p(x)` << 1 */
	.octa 0x000000007c652fb80000000058fd1740

	/* x^193536 mod p(x)` << 1, x^193600 mod p(x)` << 1 */
	.octa 0x000000011c67842c00000000dadd9bfc

	/* x^192512 mod p(x)` << 1, x^192576 mod p(x)` << 1 */
	.octa 0x00000000254f759c00000001ea2140be

	/* x^191488 mod p(x)` << 1, x^191552 mod p(x)` << 1 */
	.octa 0x000000007ece94ca000000009de128ba

	/* x^190464 mod p(x)` << 1, x^190528 mod p(x)` << 1 */
	.octa 0x0000000038f258c2000000013ac3aa8e

	/* x^189440 mod p(x)` << 1, x^189504 mod p(x)` << 1 */
	.octa 0x00000001cdf17b000000000099980562

	/* x^188416 mod p(x)` << 1, x^188480 mod p(x)` << 1 */
	.octa 0x000000011f882c1600000001c1579c86

	/* x^187392 mod p(x)` << 1, x^187456 mod p(x)` << 1 */
	.octa 0x0000000100093fc80000000068dbbf94

	/* x^186368 mod p(x)` << 1, x^186432 mod p(x)` << 1 */
	.octa 0x00000001cd684f16000000004509fb04

	/* x^185344 mod p(x)` << 1, x^185408 mod p(x)` << 1 */
	.octa 0x000000004bc6a70a00000001202f6398

	/* x^184320 mod p(x)` << 1, x^184384 mod p(x)` << 1 */
	.octa 0x000000004fc7e8e4000000013aea243e

	/* x^183296 mod p(x)` << 1, x^183360 mod p(x)` << 1 */
	.octa 0x0000000130103f1c00000001b4052ae6

	/* x^182272 mod p(x)` << 1, x^182336 mod p(x)` << 1 */
	.octa 0x0000000111b0024c00000001cd2a0ae8

	/* x^181248 mod p(x)` << 1, x^181312 mod p(x)` << 1 */
	.octa 0x000000010b3079da00000001fe4aa8b4

	/* x^180224 mod p(x)` << 1, x^180288 mod p(x)` << 1 */
	.octa 0x000000010192bcc200000001d1559a42

	/* x^179200 mod p(x)` << 1, x^179264 mod p(x)` << 1 */
	.octa 0x0000000074838d5000000001f3e05ecc

	/* x^178176 mod p(x)` << 1, x^178240 mod p(x)` << 1 */
	.octa 0x000000001b20f5200000000104ddd2cc

	/* x^177152 mod p(x)` << 1, x^177216 mod p(x)` << 1 */
	.octa 0x0000000050c3590a000000015393153c

	/* x^176128 mod p(x)` << 1, x^176192 mod p(x)` << 1 */
	.octa 0x00000000b41cac8e0000000057e942c6

	/* x^175104 mod p(x)` << 1, x^175168 mod p(x)` << 1 */
	.octa 0x000000000c72cc78000000012c633850

	/* x^174080 mod p(x)` << 1, x^174144 mod p(x)` << 1 */
	.octa 0x0000000030cdb03200000000ebcaae4c

	/* x^173056 mod p(x)` << 1, x^173120 mod p(x)` << 1 */
	.octa 0x000000013e09fc32000000013ee532a6

	/* x^172032 mod p(x)` << 1, x^172096 mod p(x)` << 1 */
	.octa 0x000000001ed624d200000001bf0cbc7e

	/* x^171008 mod p(x)` << 1, x^171072 mod p(x)` << 1 */
	.octa 0x00000000781aee1a00000000d50b7a5a

	/* x^169984 mod p(x)` << 1, x^170048 mod p(x)` << 1 */
	.octa 0x00000001c4d8348c0000000002fca6e8

	/* x^168960 mod p(x)` << 1, x^169024 mod p(x)` << 1 */
	.octa 0x0000000057a40336000000007af40044

	/* x^167936 mod p(x)` << 1, x^168000 mod p(x)` << 1 */
	.octa 0x00000000855449400000000016178744

	/* x^166912 mod p(x)` << 1, x^166976 mod p(x)` << 1 */
	.octa 0x000000019cd21e80000000014c177458

	/* x^165888 mod p(x)` << 1, x^165952 mod p(x)` << 1 */
	.octa 0x000000013eb95bc0000000011b6ddf04

	/* x^164864 mod p(x)` << 1, x^164928 mod p(x)` << 1 */
	.octa 0x00000001dfc9fdfc00000001f3e29ccc

	/* x^163840 mod p(x)` << 1, x^163904 mod p(x)` << 1 */
	.octa 0x00000000cd028bc20000000135ae7562

	/* x^162816 mod p(x)` << 1, x^162880 mod p(x)` << 1 */
	.octa 0x0000000090db8c440000000190ef812c

	/* x^161792 mod p(x)` << 1, x^161856 mod p(x)` << 1 */
	.octa 0x000000010010a4ce0000000067a2c786

	/* x^160768 mod p(x)` << 1, x^160832 mod p(x)` << 1 */
	.octa 0x00000001c8f4c72c0000000048b9496c

	/* x^159744 mod p(x)` << 1, x^159808 mod p(x)` << 1 */
	.octa 0x000000001c26170c000000015a422de6

	/* x^158720 mod p(x)` << 1, x^158784 mod p(x)` << 1 */
	.octa 0x00000000e3fccf6800000001ef0e3640

	/* x^157696 mod p(x)` << 1, x^157760 mod p(x)` << 1 */
	.octa 0x00000000d513ed2400000001006d2d26

	/* x^156672 mod p(x)` << 1, x^156736 mod p(x)` << 1 */
	.octa 0x00000000141beada00000001170d56d6

	/* x^155648 mod p(x)` << 1, x^155712 mod p(x)` << 1 */
	.octa 0x000000011071aea000000000a5fb613c

	/* x^154624 mod p(x)` << 1, x^154688 mod p(x)` << 1 */
	.octa 0x000000012e19080a0000000040bbf7fc

	/* x^153600 mod p(x)` << 1, x^153664 mod p(x)` << 1 */
	.octa 0x0000000100ecf826000000016ac3a5b2

	/* x^152576 mod p(x)` << 1, x^152640 mod p(x)` << 1 */
	.octa 0x0000000069b0941200000000abf16230

	/* x^151552 mod p(x)` << 1, x^151616 mod p(x)` << 1 */
	.octa 0x0000000122297bac00000001ebe23fac

	/* x^150528 mod p(x)` << 1, x^150592 mod p(x)` << 1 */
	.octa 0x00000000e9e4b068000000008b6a0894

	/* x^149504 mod p(x)` << 1, x^149568 mod p(x)` << 1 */
	.octa 0x000000004b38651a00000001288ea478

	/* x^148480 mod p(x)` << 1, x^148544 mod p(x)` << 1 */
	.octa 0x00000001468360e2000000016619c442

	/* x^147456 mod p(x)` << 1, x^147520 mod p(x)` << 1 */
	.octa 0x00000000121c24080000000086230038

	/* x^146432 mod p(x)` << 1, x^146496 mod p(x)` << 1 */
	.octa 0x00000000da7e7d08000000017746a756

	/* x^145408 mod p(x)` << 1, x^145472 mod p(x)` << 1 */
	.octa 0x00000001058d76520000000191b8f8f8

	/* x^144384 mod p(x)` << 1, x^144448 mod p(x)` << 1 */
	.octa 0x000000014a098a90000000008e167708

	/* x^143360 mod p(x)` << 1, x^143424 mod p(x)` << 1 */
	.octa 0x0000000020dbe72e0000000148b22d54

	/* x^142336 mod p(x)` << 1, x^142400 mod p(x)` << 1 */
	.octa 0x000000011e7323e80000000044ba2c3c

	/* x^141312 mod p(x)` << 1, x^141376 mod p(x)` << 1 */
	.octa 0x00000000d5d4bf9400000000b54d2b52

	/* x^140288 mod p(x)` << 1, x^140352 mod p(x)` << 1 */
	.octa 0x0000000199d8746c0000000005a4fd8a

	/* x^139264 mod p(x)` << 1, x^139328 mod p(x)` << 1 */
	.octa 0x00000000ce9ca8a00000000139f9fc46

	/* x^138240 mod p(x)` << 1, x^138304 mod p(x)` << 1 */
	.octa 0x00000000136edece000000015a1fa824

	/* x^137216 mod p(x)` << 1, x^137280 mod p(x)` << 1 */
	.octa 0x000000019b92a068000000000a61ae4c

	/* x^136192 mod p(x)` << 1, x^136256 mod p(x)` << 1 */
	.octa 0x0000000071d622060000000145e9113e

	/* x^135168 mod p(x)` << 1, x^135232 mod p(x)` << 1 */
	.octa 0x00000000dfc50158000000006a348448

	/* x^134144 mod p(x)` << 1, x^134208 mod p(x)` << 1 */
	.octa 0x00000001517626bc000000004d80a08c

	/* x^133120 mod p(x)` << 1, x^133184 mod p(x)` << 1 */
	.octa 0x0000000148d1e4fa000000014b6837a0

	/* x^132096 mod p(x)` << 1, x^132160 mod p(x)` << 1 */
	.octa 0x0000000094d8266e000000016896a7fc

	/* x^131072 mod p(x)` << 1, x^131136 mod p(x)` << 1 */
	.octa 0x00000000606c5e34000000014f187140

	/* x^130048 mod p(x)` << 1, x^130112 mod p(x)` << 1 */
	.octa 0x000000019766beaa000000019581b9da

	/* x^129024 mod p(x)` << 1, x^129088 mod p(x)` << 1 */
	.octa 0x00000001d80c506c00000001091bc984

	/* x^128000 mod p(x)` << 1, x^128064 mod p(x)` << 1 */
	.octa 0x000000001e73837c000000001067223c

	/* x^126976 mod p(x)` << 1, x^127040 mod p(x)` << 1 */
	.octa 0x0000000064d587de00000001ab16ea02

	/* x^125952 mod p(x)` << 1, x^126016 mod p(x)` << 1 */
	.octa 0x00000000f4a507b0000000013c4598a8

	/* x^124928 mod p(x)` << 1, x^124992 mod p(x)` << 1 */
	.octa 0x0000000040e342fc00000000b3735430

	/* x^123904 mod p(x)` << 1, x^123968 mod p(x)` << 1 */
	.octa 0x00000001d5ad9c3a00000001bb3fc0c0

	/* x^122880 mod p(x)` << 1, x^122944 mod p(x)` << 1 */
	.octa 0x0000000094a691a400000001570ae19c

	/* x^121856 mod p(x)` << 1, x^121920 mod p(x)` << 1 */
	.octa 0x00000001271ecdfa00000001ea910712

	/* x^120832 mod p(x)` << 1, x^120896 mod p(x)` << 1 */
	.octa 0x000000009e54475a0000000167127128

	/* x^119808 mod p(x)` << 1, x^119872 mod p(x)` << 1 */
	.octa 0x00000000c9c099ee0000000019e790a2

	/* x^118784 mod p(x)` << 1, x^118848 mod p(x)` << 1 */
	.octa 0x000000009a2f736c000000003788f710

	/* x^117760 mod p(x)` << 1, x^117824 mod p(x)` << 1 */
	.octa 0x00000000bb9f499600000001682a160e

	/* x^116736 mod p(x)` << 1, x^116800 mod p(x)` << 1 */
	.octa 0x00000001db688050000000007f0ebd2e

	/* x^115712 mod p(x)` << 1, x^115776 mod p(x)` << 1 */
	.octa 0x00000000e9b10af4000000002b032080

	/* x^114688 mod p(x)` << 1, x^114752 mod p(x)` << 1 */
	.octa 0x000000012d4545e400000000cfd1664a

	/* x^113664 mod p(x)` << 1, x^113728 mod p(x)` << 1 */
	.octa 0x000000000361139c00000000aa1181c2

	/* x^112640 mod p(x)` << 1, x^112704 mod p(x)` << 1 */
	.octa 0x00000001a5a1a3a800000000ddd08002

	/* x^111616 mod p(x)` << 1, x^111680 mod p(x)` << 1 */
	.octa 0x000000006844e0b000000000e8dd0446

	/* x^110592 mod p(x)` << 1, x^110656 mod p(x)` << 1 */
	.octa 0x00000000c3762f2800000001bbd94a00

	/* x^109568 mod p(x)` << 1, x^109632 mod p(x)` << 1 */
	.octa 0x00000001d26287a200000000ab6cd180

	/* x^108544 mod p(x)` << 1, x^108608 mod p(x)` << 1 */
	.octa 0x00000001f6f0bba80000000031803ce2

	/* x^107520 mod p(x)` << 1, x^107584 mod p(x)` << 1 */
	.octa 0x000000002ffabd620000000024f40b0c

	/* x^106496 mod p(x)` << 1, x^106560 mod p(x)` << 1 */
	.octa 0x00000000fb4516b800000001ba1d9834

	/* x^105472 mod p(x)` << 1, x^105536 mod p(x)` << 1 */
	.octa 0x000000018cfa961c0000000104de61aa

	/* x^104448 mod p(x)` << 1, x^104512 mod p(x)` << 1 */
	.octa 0x000000019e588d520000000113e40d46

	/* x^103424 mod p(x)` << 1, x^103488 mod p(x)` << 1 */
	.octa 0x00000001180f0bbc00000001415598a0

	/* x^102400 mod p(x)` << 1, x^102464 mod p(x)` << 1 */
	.octa 0x00000000e1d9177a00000000bf6c8c90

	/* x^101376 mod p(x)` << 1, x^101440 mod p(x)` << 1 */
	.octa 0x0000000105abc27c00000001788b0504

	/* x^100352 mod p(x)` << 1, x^100416 mod p(x)` << 1 */
	.octa 0x00000000972e4a580000000038385d02

	/* x^99328 mod p(x)` << 1, x^99392 mod p(x)` << 1 */
	.octa 0x0000000183499a5e00000001b6c83844

	/* x^98304 mod p(x)` << 1, x^98368 mod p(x)` << 1 */
	.octa 0x00000001c96a8cca0000000051061a8a

	/* x^97280 mod p(x)` << 1, x^97344 mod p(x)` << 1 */
	.octa 0x00000001a1a5b60c000000017351388a

	/* x^96256 mod p(x)` << 1, x^96320 mod p(x)` << 1 */
	.octa 0x00000000e4b6ac9c0000000132928f92

	/* x^95232 mod p(x)` << 1, x^95296 mod p(x)` << 1 */
	.octa 0x00000001807e7f5a00000000e6b4f48a

	/* x^94208 mod p(x)` << 1, x^94272 mod p(x)` << 1 */
	.octa 0x000000017a7e3bc80000000039d15e90

	/* x^93184 mod p(x)` << 1, x^93248 mod p(x)` << 1 */
	.octa 0x00000000d73975da00000000312d6074

	/* x^92160 mod p(x)` << 1, x^92224 mod p(x)` << 1 */
	.octa 0x000000017375d038000000017bbb2cc4

	/* x^91136 mod p(x)` << 1, x^91200 mod p(x)` << 1 */
	.octa 0x00000000193680bc000000016ded3e18

	/* x^90112 mod p(x)` << 1, x^90176 mod p(x)` << 1 */
	.octa 0x00000000999b06f600000000f1638b16

	/* x^89088 mod p(x)` << 1, x^89152 mod p(x)` << 1 */
	.octa 0x00000001f685d2b800000001d38b9ecc

	/* x^88064 mod p(x)` << 1, x^88128 mod p(x)` << 1 */
	.octa 0x00000001f4ecbed2000000018b8d09dc

	/* x^87040 mod p(x)` << 1, x^87104 mod p(x)` << 1 */
	.octa 0x00000000ba16f1a000000000e7bc27d2

	/* x^86016 mod p(x)` << 1, x^86080 mod p(x)` << 1 */
	.octa 0x0000000115aceac400000000275e1e96

	/* x^84992 mod p(x)` << 1, x^85056 mod p(x)` << 1 */
	.octa 0x00000001aeff629200000000e2e3031e

	/* x^83968 mod p(x)` << 1, x^84032 mod p(x)` << 1 */
	.octa 0x000000009640124c00000001041c84d8

	/* x^82944 mod p(x)` << 1, x^83008 mod p(x)` << 1 */
	.octa 0x0000000114f41f0200000000706ce672

	/* x^81920 mod p(x)` << 1, x^81984 mod p(x)` << 1 */
	.octa 0x000000009c5f3586000000015d5070da

	/* x^80896 mod p(x)` << 1, x^80960 mod p(x)` << 1 */
	.octa 0x00000001878275fa0000000038f9493a

	/* x^79872 mod p(x)` << 1, x^79936 mod p(x)` << 1 */
	.octa 0x00000000ddc42ce800000000a3348a76

	/* x^78848 mod p(x)` << 1, x^78912 mod p(x)` << 1 */
	.octa 0x0000000181d2c73a00000001ad0aab92

	/* x^77824 mod p(x)` << 1, x^77888 mod p(x)` << 1 */
	.octa 0x0000000141c9320a000000019e85f712

	/* x^76800 mod p(x)` << 1, x^76864 mod p(x)` << 1 */
	.octa 0x000000015235719a000000005a871e76

	/* x^75776 mod p(x)` << 1, x^75840 mod p(x)` << 1 */
	.octa 0x00000000be27d804000000017249c662

	/* x^74752 mod p(x)` << 1, x^74816 mod p(x)` << 1 */
	.octa 0x000000006242d45a000000003a084712

	/* x^73728 mod p(x)` << 1, x^73792 mod p(x)` << 1 */
	.octa 0x000000009a53638e00000000ed438478

	/* x^72704 mod p(x)` << 1, x^72768 mod p(x)` << 1 */
	.octa 0x00000001001ecfb600000000abac34cc

	/* x^71680 mod p(x)` << 1, x^71744 mod p(x)` << 1 */
	.octa 0x000000016d7c2d64000000005f35ef3e

	/* x^70656 mod p(x)` << 1, x^70720 mod p(x)` << 1 */
	.octa 0x00000001d0ce46c00000000047d6608c

	/* x^69632 mod p(x)` << 1, x^69696 mod p(x)` << 1 */
	.octa 0x0000000124c907b4000000002d01470e

	/* x^68608 mod p(x)` << 1, x^68672 mod p(x)` << 1 */
	.octa 0x0000000018a555ca0000000158bbc7b0

	/* x^67584 mod p(x)` << 1, x^67648 mod p(x)` << 1 */
	.octa 0x000000006b0980bc00000000c0a23e8e

	/* x^66560 mod p(x)` << 1, x^66624 mod p(x)` << 1 */
	.octa 0x000000008bbba96400000001ebd85c88

	/* x^65536 mod p(x)` << 1, x^65600 mod p(x)` << 1 */
	.octa 0x00000001070a5a1e000000019ee20bb2

	/* x^64512 mod p(x)` << 1, x^64576 mod p(x)` << 1 */
	.octa 0x000000002204322a00000001acabf2d6

	/* x^63488 mod p(x)` << 1, x^63552 mod p(x)` << 1 */
	.octa 0x00000000a27524d000000001b7963d56

	/* x^62464 mod p(x)` << 1, x^62528 mod p(x)` << 1 */
	.octa 0x0000000020b1e4ba000000017bffa1fe

	/* x^61440 mod p(x)` << 1, x^61504 mod p(x)` << 1 */
	.octa 0x0000000032cc27fc000000001f15333e

	/* x^60416 mod p(x)` << 1, x^60480 mod p(x)` << 1 */
	.octa 0x0000000044dd22b8000000018593129e

	/* x^59392 mod p(x)` << 1, x^59456 mod p(x)` << 1 */
	.octa 0x00000000dffc9e0a000000019cb32602

	/* x^58368 mod p(x)` << 1, x^58432 mod p(x)` << 1 */
	.octa 0x00000001b7a0ed140000000142b05cc8

	/* x^57344 mod p(x)` << 1, x^57408 mod p(x)` << 1 */
	.octa 0x00000000c784248800000001be49e7a4

	/* x^56320 mod p(x)` << 1, x^56384 mod p(x)` << 1 */
	.octa 0x00000001c02a4fee0000000108f69d6c

	/* x^55296 mod p(x)` << 1, x^55360 mod p(x)` << 1 */
	.octa 0x000000003c273778000000006c0971f0

	/* x^54272 mod p(x)` << 1, x^54336 mod p(x)` << 1 */
	.octa 0x00000001d63f8894000000005b16467a

	/* x^53248 mod p(x)` << 1, x^53312 mod p(x)` << 1 */
	.octa 0x000000006be557d600000001551a628e

	/* x^52224 mod p(x)` << 1, x^52288 mod p(x)` << 1 */
	.octa 0x000000006a7806ea000000019e42ea92

	/* x^51200 mod p(x)` << 1, x^51264 mod p(x)` << 1 */
	.octa 0x000000016155aa0c000000012fa83ff2

	/* x^50176 mod p(x)` << 1, x^50240 mod p(x)` << 1 */
	.octa 0x00000000908650ac000000011ca9cde0

	/* x^49152 mod p(x)` << 1, x^49216 mod p(x)` << 1 */
	.octa 0x00000000aa5a808400000000c8e5cd74

	/* x^48128 mod p(x)` << 1, x^48192 mod p(x)` << 1 */
	.octa 0x0000000191bb500a0000000096c27f0c

	/* x^47104 mod p(x)` << 1, x^47168 mod p(x)` << 1 */
	.octa 0x0000000064e9bed0000000002baed926

	/* x^46080 mod p(x)` << 1, x^46144 mod p(x)` << 1 */
	.octa 0x000000009444f302000000017c8de8d2

	/* x^45056 mod p(x)` << 1, x^45120 mod p(x)` << 1 */
	.octa 0x000000019db07d3c00000000d43d6068

	/* x^44032 mod p(x)` << 1, x^44096 mod p(x)` << 1 */
	.octa 0x00000001359e3e6e00000000cb2c4b26

	/* x^43008 mod p(x)` << 1, x^43072 mod p(x)` << 1 */
	.octa 0x00000001e4f10dd20000000145b8da26

	/* x^41984 mod p(x)` << 1, x^42048 mod p(x)` << 1 */
	.octa 0x0000000124f5735e000000018fff4b08

	/* x^40960 mod p(x)` << 1, x^41024 mod p(x)` << 1 */
	.octa 0x0000000124760a4c0000000150b58ed0

	/* x^39936 mod p(x)` << 1, x^40000 mod p(x)` << 1 */
	.octa 0x000000000f1fc18600000001549f39bc

	/* x^38912 mod p(x)` << 1, x^38976 mod p(x)` << 1 */
	.octa 0x00000000150e4cc400000000ef4d2f42

	/* x^37888 mod p(x)` << 1, x^37952 mod p(x)` << 1 */
	.octa 0x000000002a6204e800000001b1468572

	/* x^36864 mod p(x)` << 1, x^36928 mod p(x)` << 1 */
	.octa 0x00000000beb1d432000000013d7403b2

	/* x^35840 mod p(x)` << 1, x^35904 mod p(x)` << 1 */
	.octa 0x0000000135f3f1f000000001a4681842

	/* x^34816 mod p(x)` << 1, x^34880 mod p(x)` << 1 */
	.octa 0x0000000074fe22320000000167714492

	/* x^33792 mod p(x)` << 1, x^33856 mod p(x)` << 1 */
	.octa 0x000000001ac6e2ba00000001e599099a

	/* x^32768 mod p(x)` << 1, x^32832 mod p(x)` << 1 */
	.octa 0x0000000013fca91e00000000fe128194

	/* x^31744 mod p(x)` << 1, x^31808 mod p(x)` << 1 */
	.octa 0x0000000183f4931e0000000077e8b990

	/* x^30720 mod p(x)` << 1, x^30784 mod p(x)` << 1 */
	.octa 0x00000000b6d9b4e400000001a267f63a

	/* x^29696 mod p(x)` << 1, x^29760 mod p(x)` << 1 */
	.octa 0x00000000b518865600000001945c245a

	/* x^28672 mod p(x)` << 1, x^28736 mod p(x)` << 1 */
	.octa 0x0000000027a81a840000000149002e76

	/* x^27648 mod p(x)` << 1, x^27712 mod p(x)` << 1 */
	.octa 0x000000012569925800000001bb8310a4

	/* x^26624 mod p(x)` << 1, x^26688 mod p(x)` << 1 */
	.octa 0x00000001b23de796000000019ec60bcc

	/* x^25600 mod p(x)` << 1, x^25664 mod p(x)` << 1 */
	.octa 0x00000000fe4365dc000000012d8590ae

	/* x^24576 mod p(x)` << 1, x^24640 mod p(x)` << 1 */
	.octa 0x00000000c68f497a0000000065b00684

	/* x^23552 mod p(x)` << 1, x^23616 mod p(x)` << 1 */
	.octa 0x00000000fbf521ee000000015e5aeadc

	/* x^22528 mod p(x)` << 1, x^22592 mod p(x)` << 1 */
	.octa 0x000000015eac337800000000b77ff2b0

	/* x^21504 mod p(x)` << 1, x^21568 mod p(x)` << 1 */
	.octa 0x0000000134914b900000000188da2ff6

	/* x^20480 mod p(x)` << 1, x^20544 mod p(x)` << 1 */
	.octa 0x0000000016335cfe0000000063da929a

	/* x^19456 mod p(x)` << 1, x^19520 mod p(x)` << 1 */
	.octa 0x000000010372d10c00000001389caa80

	/* x^18432 mod p(x)` << 1, x^18496 mod p(x)` << 1 */
	.octa 0x000000015097b908000000013db599d2

	/* x^17408 mod p(x)` << 1, x^17472 mod p(x)` << 1 */
	.octa 0x00000001227a75720000000122505a86

	/* x^16384 mod p(x)` << 1, x^16448 mod p(x)` << 1 */
	.octa 0x000000009a8f75c0000000016bd72746

	/* x^15360 mod p(x)` << 1, x^15424 mod p(x)` << 1 */
	.octa 0x00000000682c77a200000001c3faf1d4

	/* x^14336 mod p(x)` << 1, x^14400 mod p(x)` << 1 */
	.octa 0x00000000231f091c00000001111c826c

	/* x^13312 mod p(x)` << 1, x^13376 mod p(x)` << 1 */
	.octa 0x000000007d4439f200000000153e9fb2

	/* x^12288 mod p(x)` << 1, x^12352 mod p(x)` << 1 */
	.octa 0x000000017e221efc000000002b1f7b60

	/* x^11264 mod p(x)` << 1, x^11328 mod p(x)` << 1 */
	.octa 0x0000000167457c3800000000b1dba570

	/* x^10240 mod p(x)` << 1, x^10304 mod p(x)` << 1 */
	.octa 0x00000000bdf081c400000001f6397b76

	/* x^9216 mod p(x)` << 1, x^9280 mod p(x)` << 1 */
	.octa 0x000000016286d6b00000000156335214

	/* x^8192 mod p(x)` << 1, x^8256 mod p(x)` << 1 */
	.octa 0x00000000c84f001c00000001d70e3986

	/* x^7168 mod p(x)` << 1, x^7232 mod p(x)` << 1 */
	.octa 0x0000000064efe7c0000000003701a774

	/* x^6144 mod p(x)` << 1, x^6208 mod p(x)` << 1 */
	.octa 0x000000000ac2d90400000000ac81ef72

	/* x^5120 mod p(x)` << 1, x^5184 mod p(x)` << 1 */
	.octa 0x00000000fd226d140000000133212464

	/* x^4096 mod p(x)` << 1, x^4160 mod p(x)` << 1 */
	.octa 0x000000011cfd42e000000000e4e45610

	/* x^3072 mod p(x)` << 1, x^3136 mod p(x)` << 1 */
	.octa 0x000000016e5a5678000000000c1bd370

	/* x^2048 mod p(x)` << 1, x^2112 mod p(x)` << 1 */
	.octa 0x00000001d888fe2200000001a7b9e7a6

	/* x^1024 mod p(x)` << 1, x^1088 mod p(x)` << 1 */
	.octa 0x00000001af77fcd4000000007d657a10

SHORT_CONSTANTS:

	/* Reduce final 1024-2048 bits to 64 bits, shifting 32 bits to include the trailing 32 bits of zeros */
	/* x^1952 mod p(x)`, x^1984 mod p(x)`, x^2016 mod p(x)`, x^2048 mod p(x)` */
	.octa 0xed837b2613e8221e99168a18ec447f11

	/* x^1824 mod p(x)`, x^1856 mod p(x)`, x^1888 mod p(x)`, x^1920 mod p(x)` */
	.octa 0xc8acdd8147b9ce5ae23e954e8fd2cd3c

	/* x^1696 mod p(x)`, x^1728 mod p(x)`, x^1760 mod p(x)`, x^1792 mod p(x)` */
	.octa 0xd9ad6d87d4277e2592f8befe6b1d2b53

	/* x^1568 mod p(x)`, x^1600 mod p(x)`, x^1632 mod p(x)`, x^1664 mod p(x)` */
	.octa 0xc10ec5e033fbca3bf38a3556291ea462

	/* x^1440 mod p(x)`, x^1472 mod p(x)`, x^1504 mod p(x)`, x^1536 mod p(x)` */
	.octa 0xc0b55b0e82e02e2f974ac56262b6ca4b

	/* x^1312 mod p(x)`, x^1344 mod p(x)`, x^1376 mod p(x)`, x^1408 mod p(x)` */
	.octa 0x71aa1df0e172334d855712b3784d2a56

	/* x^1184 mod p(x)`, x^1216 mod p(x)`, x^1248 mod p(x)`, x^1280 mod p(x)` */
	.octa 0xfee3053e3969324da5abe9f80eaee722

	/* x^1056 mod p(x)`, x^1088 mod p(x)`, x^1120 mod p(x)`, x^1152 mod p(x)` */
	.octa 0xf44779b93eb2bd081fa0943ddb54814c

	/* x^928 mod p(x)`, x^960 mod p(x)`, x^992 mod p(x)`, x^1024 mod p(x)` */
	.octa 0xf5449b3f00cc3374a53ff440d7bbfe6a

	/* x^800 mod p(x)`, x^832 mod p(x)`, x^864 mod p(x)`, x^896 mod p(x)` */
	.octa 0x6f8346e1d777606eebe7e3566325605c

	/* x^672 mod p(x)`, x^704 mod p(x)`, x^736 mod p(x)`, x^768 mod p(x)` */
	.octa 0xe3ab4f2ac0b95347c65a272ce5b592b8

	/* x^544 mod p(x)`, x^576 mod p(x)`, x^608 mod p(x)`, x^640 mod p(x)` */
	.octa 0xaa2215ea329ecc115705a9ca4721589f

	/* x^416 mod p(x)`, x^448 mod p(x)`, x^480 mod p(x)`, x^512 mod p(x)` */
	.octa 0x1ed8f66ed95efd26e3720acb88d14467

	/* x^288 mod p(x)`, x^320 mod p(x)`, x^352 mod p(x)`, x^384 mod p(x)` */
	.octa 0x78ed02d5a700e96aba1aca0315141c31

	/* x^160 mod p(x)`, x^192 mod p(x)`, x^224 mod p(x)`, x^256 mod p(x)` */
	.octa 0xba8ccbe832b39da3ad2a31b3ed627dae

	/* x^32 mod p(x)`, x^64 mod p(x)`, x^96 mod p(x)`, x^128 mod p(x)` */
	.octa 0xedb88320b1e6b0926655004fa06a2517


BARRETT_CONSTANTS:
	/* 33 bit reflected Barrett constant m - (4^32)/n */
	.octa 0x000000000000000000000001f7011641	/* x^64 div p(x)` */
	/* 33 bit reflected Barrett constant n */
	.octa 0x000000000000000000000001db710641

#endif /* __powerpc__ */

#endif
