/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.CachedRowElement;
import oracle.jdbc.driver.ClassRef;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ScrollableResultSet
extends BaseResultSet {
    PhysicalConnection connection;
    OracleResultSetImpl resultSet;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData metadata;
    private int rsetType;
    private int rsetConcurency;
    private int beginColumnIndex;
    private int columnCount;
    private int wasNull;
    OracleResultSetCache rsetCache;
    int currentRow;
    private int numRowsCached;
    private boolean allRowsCached;
    private int lastRefetchSz;
    private Vector refetchRowids;
    private OraclePreparedStatement refetchStmt;
    private int usrFetchDirection;
    private static final ClassRef XMLTYPE_CLASS;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;

    ScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        this.connection = ((OracleStatement)scrollRsetStatement).connection;
        this.resultSet = oracleResultSetImpl;
        this.metadata = null;
        this.scrollStmt = scrollRsetStatement;
        this.rsetType = n2;
        this.rsetConcurency = n3;
        this.beginColumnIndex = ScrollableResultSet.needIdentifier(n2, n3) ? 1 : 0;
        this.columnCount = 0;
        this.wasNull = -1;
        this.rsetCache = scrollRsetStatement.getResultSetCache();
        if (this.rsetCache == null) {
            this.rsetCache = new OracleResultSetCacheImpl();
        } else {
            try {
                this.rsetCache.clear();
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        this.currentRow = 0;
        this.numRowsCached = 0;
        this.allRowsCached = false;
        this.lastRefetchSz = 0;
        this.refetchRowids = null;
        this.refetchStmt = null;
        this.usrFetchDirection = 1000;
        this.getInternalMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                return;
            }
            super.close();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.refetchStmt != null) {
                this.refetchStmt.close();
            }
            if (this.scrollStmt != null) {
                this.scrollStmt.notifyCloseRset();
            }
            if (this.refetchRowids != null) {
                this.refetchRowids.removeAllElements();
            }
            this.resultSet = null;
            this.scrollStmt = null;
            this.refetchStmt = null;
            this.refetchRowids = null;
            this.metadata = null;
            try {
                if (this.rsetCache != null) {
                    this.rsetCache.clear();
                    this.rsetCache.close();
                }
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                this.rsetCache = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.wasNull == -1) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.wasNull == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return (Statement)((Object)this.scrollStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBeginColumnIndex() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.beginColumnIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet getResultSet() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeRowInCache(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (!this.isEmptyResultSet() && this.isValidRow(n2)) {
                this.removeCachedRowAt(n2);
                --this.numRowsCached;
                if (n2 >= this.currentRow) {
                    --this.currentRow;
                }
                return 1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int refreshRowsInCache(int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = null;
            int n5 = 0;
            n5 = this.get_refetch_size(n2, n3, n4);
            try {
                if (n5 > 0) {
                    if (n5 != this.lastRefetchSz) {
                        if (this.refetchStmt != null) {
                            this.refetchStmt.close();
                        }
                        this.refetchStmt = this.prepare_refetch_statement(n5);
                        this.refetchStmt.setQueryTimeout(((OracleStatement)this.scrollStmt).getQueryTimeout());
                        this.lastRefetchSz = n5;
                    }
                    this.prepare_refetch_binds(this.refetchStmt, n5);
                    oracleResultSetImpl = (OracleResultSetImpl)this.refetchStmt.executeQuery();
                    this.save_refetch_results(oracleResultSetImpl, n2, n5, n4);
                }
            }
            finally {
                if (oracleResultSetImpl != null) {
                    oracleResultSetImpl.close();
                }
            }
            return n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isEmptyResultSet()) {
                return false;
            }
            this.currentRow = this.currentRow < 1 ? 1 : ++this.currentRow;
            return this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return !this.isEmptyResultSet() && this.currentRow < 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return !this.isEmptyResultSet() && this.currentRow > 0 && !this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.currentRow == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return !this.isEmptyResultSet() && this.isValidRow(this.currentRow) && !this.isValidRow(this.currentRow + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.isEmptyResultSet()) {
                this.currentRow = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.isEmptyResultSet()) {
                this.currentRow = this.getLastRow() + 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isEmptyResultSet()) {
                return false;
            }
            this.currentRow = 1;
            return this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isEmptyResultSet()) {
                return false;
            }
            this.currentRow = this.getLastRow();
            return this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isValidRow(this.currentRow)) {
                return this.currentRow;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 == 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "absolute(" + n2 + ")");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isEmptyResultSet()) {
                return false;
            }
            if (n2 > 0) {
                this.currentRow = n2;
            } else if (n2 < 0) {
                this.currentRow = this.getLastRow() + 1 + n2;
            }
            return this.isValidRow(this.currentRow);
        }
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isEmptyResultSet()) {
                return false;
            }
            if (this.isValidRow(this.currentRow)) {
                this.currentRow += n2;
                return this.isValidRow(this.currentRow);
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "relative");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isEmptyResultSet()) {
                return false;
            }
            this.currentRow = this.isAfterLast() ? this.getLastRow() : --this.currentRow;
            return this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.wasNull = -1;
            if (!this.isValidRow(this.currentRow)) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Datum datum = this.getCachedDatumValueAt(this.currentRow, n2 + this.beginColumnIndex);
            this.wasNull = datum == null ? 1 : 0;
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                switch (this.getInternalMetadata().getColumnType(n2 + this.beginColumnIndex)) {
                    case 2005: 
                    case 2011: {
                        CLOB cLOB = (CLOB)datum;
                        return cLOB.getSubString(1L, (int)cLOB.length());
                    }
                    case 91: {
                        if (this.connection.mapDateToTimestamp) {
                            return datum.toJdbc().toString();
                        }
                        return datum.dateValue().toString();
                    }
                    case 93: {
                        if (datum instanceof DATE) {
                            if (this.connection.mapDateToTimestamp) {
                                return datum.toJdbc().toString();
                            }
                            return datum.dateValue().toString();
                        }
                        if (this.connection.j2ee13Compliant) {
                            return datum.toJdbc().toString();
                        }
                        return datum.stringValue(this.connection);
                    }
                }
                return datum.stringValue(this.connection);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.booleanValue();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (!this.isValidRow(this.currentRow)) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            CachedRowElement cachedRowElement = null;
            OracleResultSet.AuthorizationIndicator authorizationIndicator = null;
            try {
                cachedRowElement = (CachedRowElement)this.rsetCache.get(this.currentRow, n2);
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (cachedRowElement != null) {
                authorizationIndicator = cachedRowElement.getIndicator();
            }
            return authorizationIndicator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.byteValue();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long l2 = this.getLong(n2);
            if (l2 > 65537L || l2 < -65538L) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return (short)l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.intValue();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.longValue();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.floatValue();
            }
            return 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.doubleValue();
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.bigDecimalValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte[] byArray = null;
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    byArray = ((RAW)datum).shareBytes();
                } else if (datum instanceof BLOB) {
                    BLOB bLOB = (BLOB)datum;
                    long l2 = bLOB.length();
                    if (l2 > Integer.MAX_VALUE) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    byArray = bLOB.getBytes(1L, (int)l2);
                    if (bLOB.isTemporary()) {
                        this.resultSet.statement.addToTempLobsToFree(bLOB);
                    }
                } else {
                    byArray = datum.getBytes();
                }
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Date date = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case -101: {
                        date = ((TIMESTAMPTZ)datum).dateValue(this.connection);
                        break;
                    }
                    case -102: {
                        date = ((TIMESTAMPLTZ)datum).dateValue(this.connection);
                        break;
                    }
                    default: {
                        date = datum.dateValue();
                    }
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Time time = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case -101: {
                        time = ((TIMESTAMPTZ)datum).timeValue(this.connection);
                        break;
                    }
                    case -102: {
                        time = ((TIMESTAMPLTZ)datum).timeValue(this.connection, this.connection.getDbTzCalendar());
                        break;
                    }
                    default: {
                        time = datum.timeValue();
                    }
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Timestamp timestamp = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case -101: {
                        timestamp = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                        break;
                    }
                    case -102: {
                        timestamp = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, this.connection.getDbTzCalendar());
                        break;
                    }
                    default: {
                        timestamp = datum.timestampValue();
                    }
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                int n3 = this.getInternalMetadata().getColumnType(n2 + this.beginColumnIndex);
                if (datum instanceof CHAR && (n3 == -15 || n3 == -9)) {
                    DBConversion dBConversion = this.connection.conversion;
                    byte[] byArray = datum.shareBytes();
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 12);
                }
                return datum.asciiStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DBConversion dBConversion = this.connection.conversion;
                byte[] byArray = datum.shareBytes();
                if (datum instanceof RAW) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                }
                if (datum instanceof CHAR) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.binaryStreamValue();
            }
            return null;
        }
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        return this.getObject(n2, this.connection.getTypeMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.characterStreamValue();
            }
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.getBigDecimal(n2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object = null;
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                int n3 = this.getInternalMetadata().getColumnType(n2 + this.beginColumnIndex);
                switch (n3) {
                    case 2002: {
                        object = ((STRUCT)datum).toJdbc(map);
                        break;
                    }
                    case 91: {
                        if (this.connection.mapDateToTimestamp) {
                            object = datum.toJdbc();
                            break;
                        }
                        object = datum.dateValue();
                        break;
                    }
                    case 93: {
                        if (datum instanceof DATE) {
                            if (this.connection.mapDateToTimestamp) {
                                object = datum.toJdbc();
                                break;
                            }
                            object = datum.dateValue();
                            break;
                        }
                        if (this.connection.j2ee13Compliant) {
                            object = datum.toJdbc();
                            break;
                        }
                        object = datum;
                        break;
                    }
                    case -102: 
                    case -101: {
                        object = datum;
                        break;
                    }
                    case 2007: {
                        object = ((OPAQUE)datum).toJdbc(map);
                        break;
                    }
                    default: {
                        object = datum.toJdbc();
                    }
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getREF(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getCLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getARRAY(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Date date = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case -101: {
                        date = new Date(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                        break;
                    }
                    case -102: {
                        Calendar calendar2 = this.connection.getDbTzCalendar();
                        date = new Date(((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar2 == null ? calendar : calendar2).getTime());
                        break;
                    }
                    default: {
                        date = new Date(datum.timestampValue(calendar).getTime());
                    }
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Time time = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case -101: {
                        time = new Time(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                        break;
                    }
                    case -102: {
                        Calendar calendar2 = this.connection.getDbTzCalendar();
                        time = new Time(((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar2 == null ? calendar : calendar2).getTime());
                        break;
                    }
                    default: {
                        time = new Time(datum.timestampValue(calendar).getTime());
                    }
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Timestamp timestamp = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case -101: {
                        timestamp = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                        break;
                    }
                    case -102: {
                        Calendar calendar2 = this.connection.getDbTzCalendar();
                        timestamp = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar2 == null ? calendar : calendar2);
                        break;
                    }
                    default: {
                        timestamp = datum.timestampValue(calendar);
                    }
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            URL uRL = null;
            int n3 = this.getInternalMetadata().getColumnType(n2 + this.beginColumnIndex);
            int n4 = SQLUtil.getInternalType(n3);
            if (n4 == 96 || n4 == 1 || n4 == 8) {
                try {
                    String string = this.getString(n2);
                    if (string == null) {
                        uRL = null;
                    }
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Conversion to java.net.URL not supported.");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return uRL;
        }
    }

    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ROWID) {
                    return (ROWID)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof NUMBER) {
                    return (NUMBER)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof DATE) {
                    return (DATE)datum;
                }
                if (datum instanceof TIMESTAMP) {
                    return TIMESTAMP.toDATE(datum.getBytes());
                }
                if (datum instanceof TIMESTAMPLTZ) {
                    return TIMESTAMPLTZ.toDATE(this.connection, datum.getBytes());
                }
                if (datum instanceof TIMESTAMPTZ) {
                    return TIMESTAMPTZ.toDATE(this.connection, datum.getBytes());
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMP) {
                    return (TIMESTAMP)datum;
                }
                if (datum instanceof TIMESTAMPLTZ) {
                    return TIMESTAMPLTZ.toTIMESTAMP(this.connection, datum.getBytes());
                }
                if (datum instanceof TIMESTAMPTZ) {
                    return TIMESTAMPTZ.toTIMESTAMP(this.connection, datum.getBytes());
                }
                if (datum instanceof DATE) {
                    return new TIMESTAMP((DATE)datum);
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ) {
                    return (TIMESTAMPTZ)datum;
                }
                if (datum instanceof TIMESTAMPLTZ) {
                    return TIMESTAMPLTZ.toTIMESTAMPTZ(this.connection, datum.getBytes());
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPLTZ) {
                    return (TIMESTAMPLTZ)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALDS) {
                    return (INTERVALDS)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALYM) {
                    return (INTERVALYM)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ARRAY) {
                    return (ARRAY)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return (STRUCT)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof OPAQUE) {
                    return (OPAQUE)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof REF) {
                    return (REF)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CHAR) {
                    return (CHAR)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return (RAW)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BLOB) {
                    return (BLOB)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CLOB) {
                    return (CLOB)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCLOB getNCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof NCLOB) {
                    return (NCLOB)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BFILE) {
                    return (BFILE)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBFILE(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            return customDatumFactory.create(datum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            return oRADataFactory.create(datum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return oracleDataFactory.create(this.getObject(n2), 0);
        }
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        NCLOB nCLOB = this.getNCLOB(n2);
        if (nCLOB == null) {
            return null;
        }
        if (!(nCLOB instanceof NClob)) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return nCLOB;
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this.getString(n2);
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        return this.getCharacterStream(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        return this.getROWID(n2);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof SQLXML) {
                return (SQLXML)((Object)datum);
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSQLXML");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, this.beginColumnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.resultSet.findColumn(string) - this.beginColumnIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 == 1000) {
                this.usrFetchDirection = n2;
            } else if (n2 == 1001 || n2 == 1002) {
                this.usrFetchDirection = n2;
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.resultSet.setFetchSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.resultSet.getFetchSize();
        }
    }

    @Override
    public int getType() throws SQLException {
        return this.rsetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.rsetConcurency;
    }

    @Override
    public void refreshRow() throws SQLException {
        if (!ScrollableResultSet.needIdentifier(this.rsetType, this.rsetConcurency)) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "refreshRow");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.isValidRow(this.currentRow)) {
            int n2 = this.getFetchDirection();
            try {
                this.refreshRowsInCache(this.currentRow, this.getFetchSize(), n2);
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), sQLException, 90, "Unsupported syntax for refreshRow()");
                sQLException2.fillInStackTrace();
                throw sQLException2;
            }
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "refreshRow");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.numRowsCached != 0) {
            return false;
        }
        if (this.numRowsCached == 0 && this.allRowsCached) {
            return true;
        }
        return !this.isValidRow(1);
    }

    boolean isValidRow(int n2) throws SQLException {
        if (n2 > 0 && n2 <= this.numRowsCached) {
            return true;
        }
        if (n2 <= 0) {
            return false;
        }
        return this.cacheRowAt(n2);
    }

    private void cacheCurrentRow(OracleResultSetImpl oracleResultSetImpl, int n2) throws SQLException {
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            DatumWithConnection datumWithConnection;
            byte[] byArray = oracleResultSetImpl.privateGetBytes(i2 + 1);
            OracleResultSet.AuthorizationIndicator authorizationIndicator = oracleResultSetImpl.getAuthorizationIndicator(i2 + 1);
            CachedRowElement cachedRowElement = new CachedRowElement(n2, i2 + 1, authorizationIndicator, byArray);
            int n3 = oracleResultSetImpl.statement.accessors[i2].internalType;
            if (n3 == 112) {
                datumWithConnection = oracleResultSetImpl.getCLOB(i2 + 1);
                cachedRowElement.setData(datumWithConnection);
            } else if (n3 == 113) {
                datumWithConnection = oracleResultSetImpl.getBLOB(i2 + 1);
                cachedRowElement.setData(datumWithConnection);
            }
            this.putCachedValueAt(n2, i2 + 1, cachedRowElement);
        }
    }

    private boolean cacheRowAt(int n2) throws SQLException {
        while (this.numRowsCached < n2 && this.resultSet.next()) {
            this.cacheCurrentRow(this.resultSet, ++this.numRowsCached);
        }
        if (this.numRowsCached < n2) {
            this.allRowsCached = true;
            return false;
        }
        return true;
    }

    private int cacheAllRows() throws SQLException {
        while (this.resultSet.next()) {
            this.cacheCurrentRow(this.resultSet, ++this.numRowsCached);
        }
        this.allRowsCached = true;
        return this.numRowsCached;
    }

    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            int n2 = this.resultSet.statement.numberOfDefinePositions;
            this.columnCount = this.resultSet.statement.accessors != null && n2 > 0 ? n2 : this.getInternalMetadata().getColumnCount();
        }
        return this.columnCount;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.metadata == null) {
            this.metadata = this.resultSet.getMetaData();
        }
        return this.metadata;
    }

    private int getLastRow() throws SQLException {
        if (!this.allRowsCached) {
            this.cacheAllRows();
        }
        return this.numRowsCached;
    }

    private int get_refetch_size(int n2, int n3, int n4) throws SQLException {
        int n5 = n4 == 1001 ? -1 : 1;
        int n6 = 0;
        if (this.refetchRowids == null) {
            this.refetchRowids = new Vector(10);
        } else {
            this.refetchRowids.removeAllElements();
        }
        while (n6 < n3 && this.isValidRow(n2 + n6 * n5)) {
            this.refetchRowids.addElement(this.getCachedDatumValueAt(n2 + n6 * n5, 1));
            ++n6;
        }
        return n6;
    }

    private OraclePreparedStatement prepare_refetch_statement(int n2) throws SQLException {
        if (n2 < 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getRefetchSqlForScrollableResultSet(this, n2));
        return (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
    }

    private void prepare_refetch_binds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        int n3 = this.scrollStmt.copyBinds(oraclePreparedStatement, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            oraclePreparedStatement.setROWID(n3 + i2 + 1, (ROWID)this.refetchRowids.elementAt(i2));
        }
    }

    private void save_refetch_results(OracleResultSetImpl oracleResultSetImpl, int n2, int n3, int n4) throws SQLException {
        int n5;
        int n6 = n5 = n4 == 1001 ? -1 : 1;
        while (oracleResultSetImpl.next()) {
            ROWID rOWID = oracleResultSetImpl.getROWID(1);
            boolean bl = false;
            int n7 = n2;
            while (!bl && n7 < n2 + n3 * n5) {
                if (((ROWID)this.getCachedDatumValueAt(n7, 1)).stringValue(this.connection).equals(rOWID.stringValue(this.connection))) {
                    bl = true;
                    continue;
                }
                n7 += n5;
            }
            if (!bl) continue;
            this.cacheCurrentRow(oracleResultSetImpl, n7);
        }
    }

    private Datum getCachedDatumValueAt(int n2, int n3) throws SQLException {
        CachedRowElement cachedRowElement = null;
        try {
            cachedRowElement = (CachedRowElement)this.rsetCache.get(n2, n3);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Datum datum = null;
        if (cachedRowElement != null) {
            datum = cachedRowElement.getDataAsDatum();
            byte[] byArray = cachedRowElement.getData();
            if (datum == null && byArray != null && byArray.length > 0) {
                short s2;
                int n4 = this.getInternalMetadata().getColumnType(n3);
                int n5 = this.getInternalMetadata().getColumnDisplaySize(n3);
                int n6 = ((OracleResultSetMetaData)this.getInternalMetadata()).getDescription()[n3 - 1].internalType;
                int n7 = this.scrollStmt.getMaxFieldSize();
                if (n7 > 0 && n7 < n5) {
                    n5 = n7;
                }
                String string = null;
                if (n4 == 2006 || n4 == 2002 || n4 == 2008 || n4 == 2007 || n4 == 2003 || n4 == 2009) {
                    string = this.getInternalMetadata().getColumnTypeName(n3);
                }
                datum = (s2 = this.resultSet.statement.accessors[n3 - 1].formOfUse) == 2 && (n6 == 96 || n6 == 1 || n6 == 8 || n6 == 112) ? SQLUtil.makeNDatum(this.connection, byArray, n6, string, s2, n5) : SQLUtil.makeDatum((OracleConnection)this.connection, byArray, n6, string, n5);
                cachedRowElement.setData(datum);
            }
        }
        return datum;
    }

    private void putCachedValueAt(int n2, int n3, CachedRowElement cachedRowElement) throws SQLException {
        try {
            this.rsetCache.put(n2, n3, cachedRowElement);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private void removeCachedRowAt(int n2) throws SQLException {
        try {
            this.rsetCache.remove(n2);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public static boolean needIdentifier(int n2, int n3) {
        return (n2 != 1003 || n3 != 1007) && (n2 != 1004 || n3 != 1007);
    }

    public static boolean needCache(int n2, int n3) {
        return n2 != 1003 && (n2 != 1004 || n3 != 1007);
    }

    public static boolean supportRefreshRow(int n2, int n3) {
        return n2 != 1003 && (n2 != 1004 || n3 != 1007);
    }

    @Override
    int getFirstUserColumnIndex() {
        return this.beginColumnIndex;
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        return this.resultSet == null ? null : this.resultSet.getOracleStatement();
    }

    static {
        ClassRef classRef = null;
        try {
            classRef = ClassRef.newInstance("oracle.xdb.XMLType");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        XMLTYPE_CLASS = classRef;
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

