/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */
#line 25 "/home/buildbot/git/sql/sql_yacc.yy" /* yacc.c:339  */

#define YYLIP  (& thd->m_parser_state->m_lip)
#define YYPS   (& thd->m_parser_state->m_yacc)
#define YYCSCL (thd->variables.character_set_client)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (thd->lex)

#define Select Lex->current_select
#include <my_global.h>
#include "sql_priv.h"
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "rpl_mi.h"
#include "lex_token.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(thd, (char*) (A));              \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(thd);  \
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, strlen(yytext), thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label(current_thd, empty_lex_str, lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !MY_TEST(i) ||
         sp->push_backpatch(i, ctx->push_label(current_thd, empty_lex_str, 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!MY_TEST(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->default_value)
    it= spv->default_value;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param  thd         The current thread.
  @param  name        The SP variable name.
  @param  spvar       The SP variable (optional).
  @param  start_in_q  Start position of the SP variable name in the query.
  @param  end_in_q    End position of the SP variable name in the query.

  @remark If spvar is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal*
create_item_for_sp_var(THD *thd, LEX_STRING name, sp_variable *spvar,
                       const char *start_in_q, const char *end_in_q)
{
  Item_splocal *item;
  LEX *lex= thd->lex;
  uint pos_in_q, len_in_q;
  sp_pcontext *spc = lex->spcont;

  /* If necessary, look for the variable. */
  if (spc && !spvar)
    spvar= spc->find_variable(name, false);

  if (!spvar)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(spc && spvar);

  /* Position and length of the SP variable name in the query. */
  pos_in_q= start_in_q - lex->sphead->m_tmp_query;
  len_in_q= end_in_q - start_in_q;

  item= new (thd->mem_root)
    Item_splocal(name, spvar->offset, spvar->type, pos_in_q, len_in_q);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  lex->option_list= NULL;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list, lex->option_list, lex->check_exists);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}


/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  QQ: May be we should simply prohibit group assignments in SP?

  @see sp_create_assignment_instr

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead
*/

static void sp_create_assignment_lex(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    Lex_input_stream *lip= &thd->m_parser_state->m_lip;
    LEX *old_lex= lex;
    lex->sphead->reset_lex(thd);
    lex= thd->lex;

    /* Set new LEX as if we at start of set rule. */
    lex->sql_command= SQLCOM_SET_OPTION;
    mysql_init_select(lex);
    lex->var_list.empty();
    lex->autocommit= 0;
    /* get_ptr() is only correct with no lookahead. */
    DBUG_ASSERT(no_lookahead);
    lex->sphead->m_tmp_query= lip->get_ptr();
    /* Inherit from outer lex. */
    lex->option_type= old_lex->option_type;
  }
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    sp_head *sp= lex->sphead;

    if (!lex->var_list.is_empty())
    {
      /*
        We have assignment to user or system variable or
        option setting, so we should construct sp_instr_stmt
        for it.
      */
      LEX_STRING qbuff;
      sp_instr_stmt *i;
      Lex_input_stream *lip= &thd->m_parser_state->m_lip;

      if (!(i= new sp_instr_stmt(sp->instructions(), lex->spcont,
                                 lex)))
        return true;

      /*
        Extract the query statement from the tokenizer.  The
        end is either lip->ptr, if there was no lookahead,
        lip->tok_end otherwise.
      */
      if (no_lookahead)
        qbuff.length= lip->get_ptr() - sp->m_tmp_query;
      else
        qbuff.length= lip->get_tok_end() - sp->m_tmp_query;

      if (!(qbuff.str= (char*) alloc_root(thd->mem_root,
                                          qbuff.length + 5)))
        return true;

      strmake(strmake(qbuff.str, "SET ", 4), sp->m_tmp_query,
              qbuff.length);
      qbuff.length+= 4;
      i->m_query= qbuff;
      if (sp->add_instr(i))
        return true;
    }
    enum_var_type inner_option_type= lex->option_type;
    if (lex->sphead->restore_lex(thd))
      return true;
    /* Copy option_type to outer lex in case it has changed. */
    thd->lex->option_type= inner_option_type;
  }
  return false;
}



#line 945 "/home/buildbot/git/mkdist/sql/sql_yacc.cc" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "sql_yacc.h".  */
#ifndef YY_MYSQL_HOME_BUILDBOT_GIT_MKDIST_SQL_SQL_YACC_H_INCLUDED
# define YY_MYSQL_HOME_BUILDBOT_GIT_MKDIST_SQL_SQL_YACC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int MYSQLdebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    ABORT_SYM = 258,
    ACCESSIBLE_SYM = 259,
    ACTION = 260,
    ADD = 261,
    ADMIN_SYM = 262,
    ADDDATE_SYM = 263,
    AFTER_SYM = 264,
    AGAINST = 265,
    AGGREGATE_SYM = 266,
    ALGORITHM_SYM = 267,
    ALL = 268,
    ALTER = 269,
    ALWAYS_SYM = 270,
    ANALYZE_SYM = 271,
    AND_AND_SYM = 272,
    AND_SYM = 273,
    ANY_SYM = 274,
    AS = 275,
    ASC = 276,
    ASCII_SYM = 277,
    ASENSITIVE_SYM = 278,
    AT_SYM = 279,
    AUTHORS_SYM = 280,
    AUTOEXTEND_SIZE_SYM = 281,
    AUTO_INC = 282,
    AUTO_SYM = 283,
    AVG_ROW_LENGTH = 284,
    AVG_SYM = 285,
    BACKUP_SYM = 286,
    BEFORE_SYM = 287,
    BEGIN_SYM = 288,
    BETWEEN_SYM = 289,
    BIGINT = 290,
    BINARY = 291,
    BINLOG_SYM = 292,
    BIN_NUM = 293,
    BIT_AND = 294,
    BIT_OR = 295,
    BIT_SYM = 296,
    BIT_XOR = 297,
    BLOB_SYM = 298,
    BLOCK_SYM = 299,
    BOOLEAN_SYM = 300,
    BOOL_SYM = 301,
    BOTH = 302,
    BTREE_SYM = 303,
    BY = 304,
    BYTE_SYM = 305,
    CACHE_SYM = 306,
    CALL_SYM = 307,
    CASCADE = 308,
    CASCADED = 309,
    CASE_SYM = 310,
    CAST_SYM = 311,
    CATALOG_NAME_SYM = 312,
    CHAIN_SYM = 313,
    CHANGE = 314,
    CHANGED = 315,
    CHARSET = 316,
    CHAR_SYM = 317,
    CHECKPOINT_SYM = 318,
    CHECKSUM_SYM = 319,
    CHECK_SYM = 320,
    CIPHER_SYM = 321,
    CLASS_ORIGIN_SYM = 322,
    CLIENT_SYM = 323,
    CLIENT_STATS_SYM = 324,
    CLOSE_SYM = 325,
    COALESCE = 326,
    CODE_SYM = 327,
    COLLATE_SYM = 328,
    COLLATION_SYM = 329,
    COLUMNS = 330,
    COLUMN_ADD_SYM = 331,
    COLUMN_CHECK_SYM = 332,
    COLUMN_CREATE_SYM = 333,
    COLUMN_DELETE_SYM = 334,
    COLUMN_GET_SYM = 335,
    COLUMN_SYM = 336,
    COLUMN_NAME_SYM = 337,
    COMMENT_SYM = 338,
    COMMITTED_SYM = 339,
    COMMIT_SYM = 340,
    COMPACT_SYM = 341,
    COMPLETION_SYM = 342,
    COMPRESSED_SYM = 343,
    CONCURRENT = 344,
    CONDITION_SYM = 345,
    CONNECTION_SYM = 346,
    CONSISTENT_SYM = 347,
    CONSTRAINT = 348,
    CONSTRAINT_CATALOG_SYM = 349,
    CONSTRAINT_NAME_SYM = 350,
    CONSTRAINT_SCHEMA_SYM = 351,
    CONTAINS_SYM = 352,
    CONTEXT_SYM = 353,
    CONTINUE_SYM = 354,
    CONTRIBUTORS_SYM = 355,
    CONVERT_SYM = 356,
    COUNT_SYM = 357,
    CPU_SYM = 358,
    CREATE = 359,
    CROSS = 360,
    CUBE_SYM = 361,
    CURDATE = 362,
    CURRENT_SYM = 363,
    CURRENT_USER = 364,
    CURRENT_ROLE = 365,
    CURRENT_POS_SYM = 366,
    CURSOR_SYM = 367,
    CURSOR_NAME_SYM = 368,
    CURTIME = 369,
    DATABASE = 370,
    DATABASES = 371,
    DATAFILE_SYM = 372,
    DATA_SYM = 373,
    DATETIME = 374,
    DATE_ADD_INTERVAL = 375,
    DATE_SUB_INTERVAL = 376,
    DATE_SYM = 377,
    DAY_HOUR_SYM = 378,
    DAY_MICROSECOND_SYM = 379,
    DAY_MINUTE_SYM = 380,
    DAY_SECOND_SYM = 381,
    DAY_SYM = 382,
    DEALLOCATE_SYM = 383,
    DECIMAL_NUM = 384,
    DECIMAL_SYM = 385,
    DECLARE_SYM = 386,
    DEFAULT = 387,
    DEFINER_SYM = 388,
    DELAYED_SYM = 389,
    DELAY_KEY_WRITE_SYM = 390,
    DELETE_SYM = 391,
    DESC = 392,
    DESCRIBE = 393,
    DES_KEY_FILE = 394,
    DETERMINISTIC_SYM = 395,
    DIAGNOSTICS_SYM = 396,
    DIRECTORY_SYM = 397,
    DISABLE_SYM = 398,
    DISCARD = 399,
    DISK_SYM = 400,
    DISTINCT = 401,
    DIV_SYM = 402,
    DOUBLE_SYM = 403,
    DO_SYM = 404,
    DROP = 405,
    DUAL_SYM = 406,
    DUMPFILE = 407,
    DUPLICATE_SYM = 408,
    DYNAMIC_SYM = 409,
    EACH_SYM = 410,
    ELSE = 411,
    ELSEIF_SYM = 412,
    ENABLE_SYM = 413,
    ENCLOSED = 414,
    END = 415,
    ENDS_SYM = 416,
    END_OF_INPUT = 417,
    ENGINES_SYM = 418,
    ENGINE_SYM = 419,
    ENUM = 420,
    EQUAL_SYM = 421,
    ERROR_SYM = 422,
    ERRORS = 423,
    ESCAPED = 424,
    ESCAPE_SYM = 425,
    EVENTS_SYM = 426,
    EVENT_SYM = 427,
    EVERY_SYM = 428,
    EXCHANGE_SYM = 429,
    EXAMINED_SYM = 430,
    EXECUTE_SYM = 431,
    EXISTS = 432,
    EXIT_SYM = 433,
    EXPANSION_SYM = 434,
    EXPORT_SYM = 435,
    EXTENDED_SYM = 436,
    EXTENT_SIZE_SYM = 437,
    EXTRACT_SYM = 438,
    FALSE_SYM = 439,
    FAST_SYM = 440,
    FAULTS_SYM = 441,
    FETCH_SYM = 442,
    FILE_SYM = 443,
    FIRST_SYM = 444,
    FIXED_SYM = 445,
    FLOAT_NUM = 446,
    FLOAT_SYM = 447,
    FLUSH_SYM = 448,
    FORCE_SYM = 449,
    FOREIGN = 450,
    FOR_SYM = 451,
    FOUND_SYM = 452,
    FROM = 453,
    FULL = 454,
    FULLTEXT_SYM = 455,
    FUNCTION_SYM = 456,
    GE = 457,
    GENERAL = 458,
    GENERATED_SYM = 459,
    GEOMETRYCOLLECTION = 460,
    GEOMETRY_SYM = 461,
    GET_FORMAT = 462,
    GET_SYM = 463,
    GLOBAL_SYM = 464,
    GRANT = 465,
    GRANTS = 466,
    GROUP_SYM = 467,
    GROUP_CONCAT_SYM = 468,
    HANDLER_SYM = 469,
    HARD_SYM = 470,
    HASH_SYM = 471,
    HAVING = 472,
    HELP_SYM = 473,
    HEX_NUM = 474,
    HEX_STRING = 475,
    HIGH_PRIORITY = 476,
    HOST_SYM = 477,
    HOSTS_SYM = 478,
    HOUR_MICROSECOND_SYM = 479,
    HOUR_MINUTE_SYM = 480,
    HOUR_SECOND_SYM = 481,
    HOUR_SYM = 482,
    ID_SYM = 483,
    IDENT = 484,
    IDENTIFIED_SYM = 485,
    IDENT_QUOTED = 486,
    IF = 487,
    IGNORE_SYM = 488,
    IGNORE_SERVER_IDS_SYM = 489,
    IMPORT = 490,
    INDEXES = 491,
    INDEX_SYM = 492,
    INDEX_STATS_SYM = 493,
    INFILE = 494,
    INITIAL_SIZE_SYM = 495,
    INNER_SYM = 496,
    INOUT_SYM = 497,
    INSENSITIVE_SYM = 498,
    INSERT = 499,
    INSERT_METHOD = 500,
    INSTALL_SYM = 501,
    INTERVAL_SYM = 502,
    INTO = 503,
    INT_SYM = 504,
    INVOKER_SYM = 505,
    IN_SYM = 506,
    IO_SYM = 507,
    IPC_SYM = 508,
    IS = 509,
    ISOLATION = 510,
    ISSUER_SYM = 511,
    ITERATE_SYM = 512,
    JOIN_SYM = 513,
    KEYS = 514,
    KEY_BLOCK_SIZE = 515,
    KEY_SYM = 516,
    KILL_SYM = 517,
    LANGUAGE_SYM = 518,
    LAST_SYM = 519,
    LAST_VALUE = 520,
    LE = 521,
    LEADING = 522,
    LEAVES = 523,
    LEAVE_SYM = 524,
    LEFT = 525,
    LESS_SYM = 526,
    LEVEL_SYM = 527,
    LEX_HOSTNAME = 528,
    LIKE = 529,
    LIMIT = 530,
    LINEAR_SYM = 531,
    LINES = 532,
    LINESTRING = 533,
    LIST_SYM = 534,
    LOAD = 535,
    LOCAL_SYM = 536,
    LOCATOR_SYM = 537,
    LOCKS_SYM = 538,
    LOCK_SYM = 539,
    LOGFILE_SYM = 540,
    LOGS_SYM = 541,
    LONGBLOB = 542,
    LONGTEXT = 543,
    LONG_NUM = 544,
    LONG_SYM = 545,
    LOOP_SYM = 546,
    LOW_PRIORITY = 547,
    MASTER_CONNECT_RETRY_SYM = 548,
    MASTER_GTID_POS_SYM = 549,
    MASTER_HOST_SYM = 550,
    MASTER_LOG_FILE_SYM = 551,
    MASTER_LOG_POS_SYM = 552,
    MASTER_PASSWORD_SYM = 553,
    MASTER_PORT_SYM = 554,
    MASTER_SERVER_ID_SYM = 555,
    MASTER_SSL_CAPATH_SYM = 556,
    MASTER_SSL_CA_SYM = 557,
    MASTER_SSL_CERT_SYM = 558,
    MASTER_SSL_CIPHER_SYM = 559,
    MASTER_SSL_CRL_SYM = 560,
    MASTER_SSL_CRLPATH_SYM = 561,
    MASTER_SSL_KEY_SYM = 562,
    MASTER_SSL_SYM = 563,
    MASTER_SSL_VERIFY_SERVER_CERT_SYM = 564,
    MASTER_SYM = 565,
    MASTER_USER_SYM = 566,
    MASTER_USE_GTID_SYM = 567,
    MASTER_HEARTBEAT_PERIOD_SYM = 568,
    MATCH = 569,
    MAX_CONNECTIONS_PER_HOUR = 570,
    MAX_QUERIES_PER_HOUR = 571,
    MAX_ROWS = 572,
    MAX_SIZE_SYM = 573,
    MAX_SYM = 574,
    MAX_UPDATES_PER_HOUR = 575,
    MAX_USER_CONNECTIONS_SYM = 576,
    MAX_VALUE_SYM = 577,
    MEDIUMBLOB = 578,
    MEDIUMINT = 579,
    MEDIUMTEXT = 580,
    MEDIUM_SYM = 581,
    MEMORY_SYM = 582,
    MERGE_SYM = 583,
    MESSAGE_TEXT_SYM = 584,
    MICROSECOND_SYM = 585,
    MIGRATE_SYM = 586,
    MINUTE_MICROSECOND_SYM = 587,
    MINUTE_SECOND_SYM = 588,
    MINUTE_SYM = 589,
    MIN_ROWS = 590,
    MIN_SYM = 591,
    MODE_SYM = 592,
    MODIFIES_SYM = 593,
    MODIFY_SYM = 594,
    MOD_SYM = 595,
    MONTH_SYM = 596,
    MULTILINESTRING = 597,
    MULTIPOINT = 598,
    MULTIPOLYGON = 599,
    MUTEX_SYM = 600,
    MYSQL_SYM = 601,
    MYSQL_ERRNO_SYM = 602,
    NAMES_SYM = 603,
    NAME_SYM = 604,
    NATIONAL_SYM = 605,
    NATURAL = 606,
    NCHAR_STRING = 607,
    NCHAR_SYM = 608,
    NDBCLUSTER_SYM = 609,
    NE = 610,
    NEG = 611,
    NEW_SYM = 612,
    NEXT_SYM = 613,
    NODEGROUP_SYM = 614,
    NONE_SYM = 615,
    NOT2_SYM = 616,
    NOT_SYM = 617,
    NOW_SYM = 618,
    NO_SYM = 619,
    NO_WAIT_SYM = 620,
    NO_WRITE_TO_BINLOG = 621,
    NULL_SYM = 622,
    NUM = 623,
    NUMBER_SYM = 624,
    NUMERIC_SYM = 625,
    NVARCHAR_SYM = 626,
    OFFSET_SYM = 627,
    OLD_PASSWORD = 628,
    ON = 629,
    ONE_SYM = 630,
    ONLY_SYM = 631,
    ONLINE_SYM = 632,
    OPEN_SYM = 633,
    OPTIMIZE = 634,
    OPTIONS_SYM = 635,
    OPTION = 636,
    OPTIONALLY = 637,
    OR2_SYM = 638,
    ORDER_SYM = 639,
    OR_OR_SYM = 640,
    OR_SYM = 641,
    OUTER = 642,
    OUTFILE = 643,
    OUT_SYM = 644,
    OWNER_SYM = 645,
    PACK_KEYS_SYM = 646,
    PAGE_SYM = 647,
    PAGE_CHECKSUM_SYM = 648,
    PARAM_MARKER = 649,
    PARSER_SYM = 650,
    PARSE_VCOL_EXPR_SYM = 651,
    PARTIAL = 652,
    PARTITION_SYM = 653,
    PARTITIONS_SYM = 654,
    PARTITIONING_SYM = 655,
    PASSWORD = 656,
    PERSISTENT_SYM = 657,
    PHASE_SYM = 658,
    PLUGINS_SYM = 659,
    PLUGIN_SYM = 660,
    POINT_SYM = 661,
    POLYGON = 662,
    PORT_SYM = 663,
    POSITION_SYM = 664,
    PRECISION = 665,
    PREPARE_SYM = 666,
    PRESERVE_SYM = 667,
    PREV_SYM = 668,
    PRIMARY_SYM = 669,
    PRIVILEGES = 670,
    PROCEDURE_SYM = 671,
    PROCESS = 672,
    PROCESSLIST_SYM = 673,
    PROFILE_SYM = 674,
    PROFILES_SYM = 675,
    PROXY_SYM = 676,
    PURGE = 677,
    QUARTER_SYM = 678,
    QUERY_SYM = 679,
    QUICK = 680,
    RANGE_SYM = 681,
    READS_SYM = 682,
    READ_ONLY_SYM = 683,
    READ_SYM = 684,
    READ_WRITE_SYM = 685,
    REAL = 686,
    REBUILD_SYM = 687,
    RECOVER_SYM = 688,
    REDOFILE_SYM = 689,
    REDO_BUFFER_SIZE_SYM = 690,
    REDUNDANT_SYM = 691,
    REFERENCES = 692,
    REGEXP = 693,
    RELAY = 694,
    RELAYLOG_SYM = 695,
    RELAY_LOG_FILE_SYM = 696,
    RELAY_LOG_POS_SYM = 697,
    RELAY_THREAD = 698,
    RELEASE_SYM = 699,
    RELOAD = 700,
    REMOVE_SYM = 701,
    RENAME = 702,
    REORGANIZE_SYM = 703,
    REPAIR = 704,
    REPEATABLE_SYM = 705,
    REPEAT_SYM = 706,
    REPLACE = 707,
    REPLICATION = 708,
    REQUIRE_SYM = 709,
    RESET_SYM = 710,
    RESIGNAL_SYM = 711,
    RESOURCES = 712,
    RESTORE_SYM = 713,
    RESTRICT = 714,
    RESUME_SYM = 715,
    RETURNED_SQLSTATE_SYM = 716,
    RETURNING_SYM = 717,
    RETURNS_SYM = 718,
    RETURN_SYM = 719,
    REVERSE_SYM = 720,
    REVOKE = 721,
    RIGHT = 722,
    ROLE_SYM = 723,
    ROLLBACK_SYM = 724,
    ROLLUP_SYM = 725,
    ROUTINE_SYM = 726,
    ROWS_SYM = 727,
    ROW_FORMAT_SYM = 728,
    ROW_SYM = 729,
    ROW_COUNT_SYM = 730,
    RTREE_SYM = 731,
    SAVEPOINT_SYM = 732,
    SCHEDULE_SYM = 733,
    SCHEMA_NAME_SYM = 734,
    SECOND_MICROSECOND_SYM = 735,
    SECOND_SYM = 736,
    SECURITY_SYM = 737,
    SELECT_SYM = 738,
    SENSITIVE_SYM = 739,
    SEPARATOR_SYM = 740,
    SERIALIZABLE_SYM = 741,
    SERIAL_SYM = 742,
    SESSION_SYM = 743,
    SERVER_SYM = 744,
    SERVER_OPTIONS = 745,
    SET = 746,
    SET_VAR = 747,
    SHARE_SYM = 748,
    SHIFT_LEFT = 749,
    SHIFT_RIGHT = 750,
    SHOW = 751,
    SHUTDOWN = 752,
    SIGNAL_SYM = 753,
    SIGNED_SYM = 754,
    SIMPLE_SYM = 755,
    SLAVE = 756,
    SLAVES = 757,
    SLAVE_POS_SYM = 758,
    SLOW = 759,
    SMALLINT = 760,
    SNAPSHOT_SYM = 761,
    SOCKET_SYM = 762,
    SOFT_SYM = 763,
    SONAME_SYM = 764,
    SOUNDS_SYM = 765,
    SOURCE_SYM = 766,
    SPATIAL_SYM = 767,
    SPECIFIC_SYM = 768,
    SQLEXCEPTION_SYM = 769,
    SQLSTATE_SYM = 770,
    SQLWARNING_SYM = 771,
    SQL_BIG_RESULT = 772,
    SQL_BUFFER_RESULT = 773,
    SQL_CACHE_SYM = 774,
    SQL_CALC_FOUND_ROWS = 775,
    SQL_NO_CACHE_SYM = 776,
    SQL_SMALL_RESULT = 777,
    SQL_SYM = 778,
    SQL_THREAD = 779,
    SSL_SYM = 780,
    STARTING = 781,
    STARTS_SYM = 782,
    START_SYM = 783,
    STATS_AUTO_RECALC_SYM = 784,
    STATS_PERSISTENT_SYM = 785,
    STATS_SAMPLE_PAGES_SYM = 786,
    STATUS_SYM = 787,
    STDDEV_SAMP_SYM = 788,
    STD_SYM = 789,
    STOP_SYM = 790,
    STORAGE_SYM = 791,
    STRAIGHT_JOIN = 792,
    STRING_SYM = 793,
    SUBCLASS_ORIGIN_SYM = 794,
    SUBDATE_SYM = 795,
    SUBJECT_SYM = 796,
    SUBPARTITIONS_SYM = 797,
    SUBPARTITION_SYM = 798,
    SUBSTRING = 799,
    SUM_SYM = 800,
    SUPER_SYM = 801,
    SUSPEND_SYM = 802,
    SWAPS_SYM = 803,
    SWITCHES_SYM = 804,
    SYSDATE = 805,
    TABLES = 806,
    TABLESPACE = 807,
    TABLE_REF_PRIORITY = 808,
    TABLE_STATS_SYM = 809,
    TABLE_SYM = 810,
    TABLE_CHECKSUM_SYM = 811,
    TABLE_NAME_SYM = 812,
    TEMPORARY = 813,
    TEMPTABLE_SYM = 814,
    TERMINATED = 815,
    TEXT_STRING = 816,
    TEXT_SYM = 817,
    THAN_SYM = 818,
    THEN_SYM = 819,
    TIMESTAMP = 820,
    TIMESTAMP_ADD = 821,
    TIMESTAMP_DIFF = 822,
    TIME_SYM = 823,
    TINYBLOB = 824,
    TINYINT = 825,
    TINYTEXT = 826,
    TO_SYM = 827,
    TRAILING = 828,
    TRANSACTION_SYM = 829,
    TRANSACTIONAL_SYM = 830,
    TRIGGERS_SYM = 831,
    TRIGGER_SYM = 832,
    TRIM = 833,
    TRUE_SYM = 834,
    TRUNCATE_SYM = 835,
    TYPES_SYM = 836,
    TYPE_SYM = 837,
    UDF_RETURNS_SYM = 838,
    ULONGLONG_NUM = 839,
    UNCOMMITTED_SYM = 840,
    UNDEFINED_SYM = 841,
    UNDERSCORE_CHARSET = 842,
    UNDOFILE_SYM = 843,
    UNDO_BUFFER_SIZE_SYM = 844,
    UNDO_SYM = 845,
    UNICODE_SYM = 846,
    UNINSTALL_SYM = 847,
    UNION_SYM = 848,
    UNIQUE_SYM = 849,
    UNKNOWN_SYM = 850,
    UNLOCK_SYM = 851,
    UNSIGNED = 852,
    UNTIL_SYM = 853,
    UPDATE_SYM = 854,
    UPGRADE_SYM = 855,
    USAGE = 856,
    USER = 857,
    USER_STATS_SYM = 858,
    USE_FRM = 859,
    USE_SYM = 860,
    USING = 861,
    UTC_DATE_SYM = 862,
    UTC_TIMESTAMP_SYM = 863,
    UTC_TIME_SYM = 864,
    VALUES = 865,
    VALUE_SYM = 866,
    VARBINARY = 867,
    VARCHAR = 868,
    VARIABLES = 869,
    VARIANCE_SYM = 870,
    VARYING = 871,
    VAR_SAMP_SYM = 872,
    VIA_SYM = 873,
    VIEW_SYM = 874,
    VIRTUAL_SYM = 875,
    WAIT_SYM = 876,
    WARNINGS = 877,
    WEEK_SYM = 878,
    WEIGHT_STRING_SYM = 879,
    WHEN_SYM = 880,
    WHERE = 881,
    WHILE_SYM = 882,
    WITH = 883,
    WITH_CUBE_SYM = 884,
    WITH_ROLLUP_SYM = 885,
    WORK_SYM = 886,
    WRAPPER_SYM = 887,
    WRITE_SYM = 888,
    X509_SYM = 889,
    XA_SYM = 890,
    XML_SYM = 891,
    XOR = 892,
    YEAR_MONTH_SYM = 893,
    YEAR_SYM = 894,
    ZEROFILL = 895,
    IMPOSSIBLE_ACTION = 896
  };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADMIN_SYM 262
#define ADDDATE_SYM 263
#define AFTER_SYM 264
#define AGAINST 265
#define AGGREGATE_SYM 266
#define ALGORITHM_SYM 267
#define ALL 268
#define ALTER 269
#define ALWAYS_SYM 270
#define ANALYZE_SYM 271
#define AND_AND_SYM 272
#define AND_SYM 273
#define ANY_SYM 274
#define AS 275
#define ASC 276
#define ASCII_SYM 277
#define ASENSITIVE_SYM 278
#define AT_SYM 279
#define AUTHORS_SYM 280
#define AUTOEXTEND_SIZE_SYM 281
#define AUTO_INC 282
#define AUTO_SYM 283
#define AVG_ROW_LENGTH 284
#define AVG_SYM 285
#define BACKUP_SYM 286
#define BEFORE_SYM 287
#define BEGIN_SYM 288
#define BETWEEN_SYM 289
#define BIGINT 290
#define BINARY 291
#define BINLOG_SYM 292
#define BIN_NUM 293
#define BIT_AND 294
#define BIT_OR 295
#define BIT_SYM 296
#define BIT_XOR 297
#define BLOB_SYM 298
#define BLOCK_SYM 299
#define BOOLEAN_SYM 300
#define BOOL_SYM 301
#define BOTH 302
#define BTREE_SYM 303
#define BY 304
#define BYTE_SYM 305
#define CACHE_SYM 306
#define CALL_SYM 307
#define CASCADE 308
#define CASCADED 309
#define CASE_SYM 310
#define CAST_SYM 311
#define CATALOG_NAME_SYM 312
#define CHAIN_SYM 313
#define CHANGE 314
#define CHANGED 315
#define CHARSET 316
#define CHAR_SYM 317
#define CHECKPOINT_SYM 318
#define CHECKSUM_SYM 319
#define CHECK_SYM 320
#define CIPHER_SYM 321
#define CLASS_ORIGIN_SYM 322
#define CLIENT_SYM 323
#define CLIENT_STATS_SYM 324
#define CLOSE_SYM 325
#define COALESCE 326
#define CODE_SYM 327
#define COLLATE_SYM 328
#define COLLATION_SYM 329
#define COLUMNS 330
#define COLUMN_ADD_SYM 331
#define COLUMN_CHECK_SYM 332
#define COLUMN_CREATE_SYM 333
#define COLUMN_DELETE_SYM 334
#define COLUMN_GET_SYM 335
#define COLUMN_SYM 336
#define COLUMN_NAME_SYM 337
#define COMMENT_SYM 338
#define COMMITTED_SYM 339
#define COMMIT_SYM 340
#define COMPACT_SYM 341
#define COMPLETION_SYM 342
#define COMPRESSED_SYM 343
#define CONCURRENT 344
#define CONDITION_SYM 345
#define CONNECTION_SYM 346
#define CONSISTENT_SYM 347
#define CONSTRAINT 348
#define CONSTRAINT_CATALOG_SYM 349
#define CONSTRAINT_NAME_SYM 350
#define CONSTRAINT_SCHEMA_SYM 351
#define CONTAINS_SYM 352
#define CONTEXT_SYM 353
#define CONTINUE_SYM 354
#define CONTRIBUTORS_SYM 355
#define CONVERT_SYM 356
#define COUNT_SYM 357
#define CPU_SYM 358
#define CREATE 359
#define CROSS 360
#define CUBE_SYM 361
#define CURDATE 362
#define CURRENT_SYM 363
#define CURRENT_USER 364
#define CURRENT_ROLE 365
#define CURRENT_POS_SYM 366
#define CURSOR_SYM 367
#define CURSOR_NAME_SYM 368
#define CURTIME 369
#define DATABASE 370
#define DATABASES 371
#define DATAFILE_SYM 372
#define DATA_SYM 373
#define DATETIME 374
#define DATE_ADD_INTERVAL 375
#define DATE_SUB_INTERVAL 376
#define DATE_SYM 377
#define DAY_HOUR_SYM 378
#define DAY_MICROSECOND_SYM 379
#define DAY_MINUTE_SYM 380
#define DAY_SECOND_SYM 381
#define DAY_SYM 382
#define DEALLOCATE_SYM 383
#define DECIMAL_NUM 384
#define DECIMAL_SYM 385
#define DECLARE_SYM 386
#define DEFAULT 387
#define DEFINER_SYM 388
#define DELAYED_SYM 389
#define DELAY_KEY_WRITE_SYM 390
#define DELETE_SYM 391
#define DESC 392
#define DESCRIBE 393
#define DES_KEY_FILE 394
#define DETERMINISTIC_SYM 395
#define DIAGNOSTICS_SYM 396
#define DIRECTORY_SYM 397
#define DISABLE_SYM 398
#define DISCARD 399
#define DISK_SYM 400
#define DISTINCT 401
#define DIV_SYM 402
#define DOUBLE_SYM 403
#define DO_SYM 404
#define DROP 405
#define DUAL_SYM 406
#define DUMPFILE 407
#define DUPLICATE_SYM 408
#define DYNAMIC_SYM 409
#define EACH_SYM 410
#define ELSE 411
#define ELSEIF_SYM 412
#define ENABLE_SYM 413
#define ENCLOSED 414
#define END 415
#define ENDS_SYM 416
#define END_OF_INPUT 417
#define ENGINES_SYM 418
#define ENGINE_SYM 419
#define ENUM 420
#define EQUAL_SYM 421
#define ERROR_SYM 422
#define ERRORS 423
#define ESCAPED 424
#define ESCAPE_SYM 425
#define EVENTS_SYM 426
#define EVENT_SYM 427
#define EVERY_SYM 428
#define EXCHANGE_SYM 429
#define EXAMINED_SYM 430
#define EXECUTE_SYM 431
#define EXISTS 432
#define EXIT_SYM 433
#define EXPANSION_SYM 434
#define EXPORT_SYM 435
#define EXTENDED_SYM 436
#define EXTENT_SIZE_SYM 437
#define EXTRACT_SYM 438
#define FALSE_SYM 439
#define FAST_SYM 440
#define FAULTS_SYM 441
#define FETCH_SYM 442
#define FILE_SYM 443
#define FIRST_SYM 444
#define FIXED_SYM 445
#define FLOAT_NUM 446
#define FLOAT_SYM 447
#define FLUSH_SYM 448
#define FORCE_SYM 449
#define FOREIGN 450
#define FOR_SYM 451
#define FOUND_SYM 452
#define FROM 453
#define FULL 454
#define FULLTEXT_SYM 455
#define FUNCTION_SYM 456
#define GE 457
#define GENERAL 458
#define GENERATED_SYM 459
#define GEOMETRYCOLLECTION 460
#define GEOMETRY_SYM 461
#define GET_FORMAT 462
#define GET_SYM 463
#define GLOBAL_SYM 464
#define GRANT 465
#define GRANTS 466
#define GROUP_SYM 467
#define GROUP_CONCAT_SYM 468
#define HANDLER_SYM 469
#define HARD_SYM 470
#define HASH_SYM 471
#define HAVING 472
#define HELP_SYM 473
#define HEX_NUM 474
#define HEX_STRING 475
#define HIGH_PRIORITY 476
#define HOST_SYM 477
#define HOSTS_SYM 478
#define HOUR_MICROSECOND_SYM 479
#define HOUR_MINUTE_SYM 480
#define HOUR_SECOND_SYM 481
#define HOUR_SYM 482
#define ID_SYM 483
#define IDENT 484
#define IDENTIFIED_SYM 485
#define IDENT_QUOTED 486
#define IF 487
#define IGNORE_SYM 488
#define IGNORE_SERVER_IDS_SYM 489
#define IMPORT 490
#define INDEXES 491
#define INDEX_SYM 492
#define INDEX_STATS_SYM 493
#define INFILE 494
#define INITIAL_SIZE_SYM 495
#define INNER_SYM 496
#define INOUT_SYM 497
#define INSENSITIVE_SYM 498
#define INSERT 499
#define INSERT_METHOD 500
#define INSTALL_SYM 501
#define INTERVAL_SYM 502
#define INTO 503
#define INT_SYM 504
#define INVOKER_SYM 505
#define IN_SYM 506
#define IO_SYM 507
#define IPC_SYM 508
#define IS 509
#define ISOLATION 510
#define ISSUER_SYM 511
#define ITERATE_SYM 512
#define JOIN_SYM 513
#define KEYS 514
#define KEY_BLOCK_SIZE 515
#define KEY_SYM 516
#define KILL_SYM 517
#define LANGUAGE_SYM 518
#define LAST_SYM 519
#define LAST_VALUE 520
#define LE 521
#define LEADING 522
#define LEAVES 523
#define LEAVE_SYM 524
#define LEFT 525
#define LESS_SYM 526
#define LEVEL_SYM 527
#define LEX_HOSTNAME 528
#define LIKE 529
#define LIMIT 530
#define LINEAR_SYM 531
#define LINES 532
#define LINESTRING 533
#define LIST_SYM 534
#define LOAD 535
#define LOCAL_SYM 536
#define LOCATOR_SYM 537
#define LOCKS_SYM 538
#define LOCK_SYM 539
#define LOGFILE_SYM 540
#define LOGS_SYM 541
#define LONGBLOB 542
#define LONGTEXT 543
#define LONG_NUM 544
#define LONG_SYM 545
#define LOOP_SYM 546
#define LOW_PRIORITY 547
#define MASTER_CONNECT_RETRY_SYM 548
#define MASTER_GTID_POS_SYM 549
#define MASTER_HOST_SYM 550
#define MASTER_LOG_FILE_SYM 551
#define MASTER_LOG_POS_SYM 552
#define MASTER_PASSWORD_SYM 553
#define MASTER_PORT_SYM 554
#define MASTER_SERVER_ID_SYM 555
#define MASTER_SSL_CAPATH_SYM 556
#define MASTER_SSL_CA_SYM 557
#define MASTER_SSL_CERT_SYM 558
#define MASTER_SSL_CIPHER_SYM 559
#define MASTER_SSL_CRL_SYM 560
#define MASTER_SSL_CRLPATH_SYM 561
#define MASTER_SSL_KEY_SYM 562
#define MASTER_SSL_SYM 563
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 564
#define MASTER_SYM 565
#define MASTER_USER_SYM 566
#define MASTER_USE_GTID_SYM 567
#define MASTER_HEARTBEAT_PERIOD_SYM 568
#define MATCH 569
#define MAX_CONNECTIONS_PER_HOUR 570
#define MAX_QUERIES_PER_HOUR 571
#define MAX_ROWS 572
#define MAX_SIZE_SYM 573
#define MAX_SYM 574
#define MAX_UPDATES_PER_HOUR 575
#define MAX_USER_CONNECTIONS_SYM 576
#define MAX_VALUE_SYM 577
#define MEDIUMBLOB 578
#define MEDIUMINT 579
#define MEDIUMTEXT 580
#define MEDIUM_SYM 581
#define MEMORY_SYM 582
#define MERGE_SYM 583
#define MESSAGE_TEXT_SYM 584
#define MICROSECOND_SYM 585
#define MIGRATE_SYM 586
#define MINUTE_MICROSECOND_SYM 587
#define MINUTE_SECOND_SYM 588
#define MINUTE_SYM 589
#define MIN_ROWS 590
#define MIN_SYM 591
#define MODE_SYM 592
#define MODIFIES_SYM 593
#define MODIFY_SYM 594
#define MOD_SYM 595
#define MONTH_SYM 596
#define MULTILINESTRING 597
#define MULTIPOINT 598
#define MULTIPOLYGON 599
#define MUTEX_SYM 600
#define MYSQL_SYM 601
#define MYSQL_ERRNO_SYM 602
#define NAMES_SYM 603
#define NAME_SYM 604
#define NATIONAL_SYM 605
#define NATURAL 606
#define NCHAR_STRING 607
#define NCHAR_SYM 608
#define NDBCLUSTER_SYM 609
#define NE 610
#define NEG 611
#define NEW_SYM 612
#define NEXT_SYM 613
#define NODEGROUP_SYM 614
#define NONE_SYM 615
#define NOT2_SYM 616
#define NOT_SYM 617
#define NOW_SYM 618
#define NO_SYM 619
#define NO_WAIT_SYM 620
#define NO_WRITE_TO_BINLOG 621
#define NULL_SYM 622
#define NUM 623
#define NUMBER_SYM 624
#define NUMERIC_SYM 625
#define NVARCHAR_SYM 626
#define OFFSET_SYM 627
#define OLD_PASSWORD 628
#define ON 629
#define ONE_SYM 630
#define ONLY_SYM 631
#define ONLINE_SYM 632
#define OPEN_SYM 633
#define OPTIMIZE 634
#define OPTIONS_SYM 635
#define OPTION 636
#define OPTIONALLY 637
#define OR2_SYM 638
#define ORDER_SYM 639
#define OR_OR_SYM 640
#define OR_SYM 641
#define OUTER 642
#define OUTFILE 643
#define OUT_SYM 644
#define OWNER_SYM 645
#define PACK_KEYS_SYM 646
#define PAGE_SYM 647
#define PAGE_CHECKSUM_SYM 648
#define PARAM_MARKER 649
#define PARSER_SYM 650
#define PARSE_VCOL_EXPR_SYM 651
#define PARTIAL 652
#define PARTITION_SYM 653
#define PARTITIONS_SYM 654
#define PARTITIONING_SYM 655
#define PASSWORD 656
#define PERSISTENT_SYM 657
#define PHASE_SYM 658
#define PLUGINS_SYM 659
#define PLUGIN_SYM 660
#define POINT_SYM 661
#define POLYGON 662
#define PORT_SYM 663
#define POSITION_SYM 664
#define PRECISION 665
#define PREPARE_SYM 666
#define PRESERVE_SYM 667
#define PREV_SYM 668
#define PRIMARY_SYM 669
#define PRIVILEGES 670
#define PROCEDURE_SYM 671
#define PROCESS 672
#define PROCESSLIST_SYM 673
#define PROFILE_SYM 674
#define PROFILES_SYM 675
#define PROXY_SYM 676
#define PURGE 677
#define QUARTER_SYM 678
#define QUERY_SYM 679
#define QUICK 680
#define RANGE_SYM 681
#define READS_SYM 682
#define READ_ONLY_SYM 683
#define READ_SYM 684
#define READ_WRITE_SYM 685
#define REAL 686
#define REBUILD_SYM 687
#define RECOVER_SYM 688
#define REDOFILE_SYM 689
#define REDO_BUFFER_SIZE_SYM 690
#define REDUNDANT_SYM 691
#define REFERENCES 692
#define REGEXP 693
#define RELAY 694
#define RELAYLOG_SYM 695
#define RELAY_LOG_FILE_SYM 696
#define RELAY_LOG_POS_SYM 697
#define RELAY_THREAD 698
#define RELEASE_SYM 699
#define RELOAD 700
#define REMOVE_SYM 701
#define RENAME 702
#define REORGANIZE_SYM 703
#define REPAIR 704
#define REPEATABLE_SYM 705
#define REPEAT_SYM 706
#define REPLACE 707
#define REPLICATION 708
#define REQUIRE_SYM 709
#define RESET_SYM 710
#define RESIGNAL_SYM 711
#define RESOURCES 712
#define RESTORE_SYM 713
#define RESTRICT 714
#define RESUME_SYM 715
#define RETURNED_SQLSTATE_SYM 716
#define RETURNING_SYM 717
#define RETURNS_SYM 718
#define RETURN_SYM 719
#define REVERSE_SYM 720
#define REVOKE 721
#define RIGHT 722
#define ROLE_SYM 723
#define ROLLBACK_SYM 724
#define ROLLUP_SYM 725
#define ROUTINE_SYM 726
#define ROWS_SYM 727
#define ROW_FORMAT_SYM 728
#define ROW_SYM 729
#define ROW_COUNT_SYM 730
#define RTREE_SYM 731
#define SAVEPOINT_SYM 732
#define SCHEDULE_SYM 733
#define SCHEMA_NAME_SYM 734
#define SECOND_MICROSECOND_SYM 735
#define SECOND_SYM 736
#define SECURITY_SYM 737
#define SELECT_SYM 738
#define SENSITIVE_SYM 739
#define SEPARATOR_SYM 740
#define SERIALIZABLE_SYM 741
#define SERIAL_SYM 742
#define SESSION_SYM 743
#define SERVER_SYM 744
#define SERVER_OPTIONS 745
#define SET 746
#define SET_VAR 747
#define SHARE_SYM 748
#define SHIFT_LEFT 749
#define SHIFT_RIGHT 750
#define SHOW 751
#define SHUTDOWN 752
#define SIGNAL_SYM 753
#define SIGNED_SYM 754
#define SIMPLE_SYM 755
#define SLAVE 756
#define SLAVES 757
#define SLAVE_POS_SYM 758
#define SLOW 759
#define SMALLINT 760
#define SNAPSHOT_SYM 761
#define SOCKET_SYM 762
#define SOFT_SYM 763
#define SONAME_SYM 764
#define SOUNDS_SYM 765
#define SOURCE_SYM 766
#define SPATIAL_SYM 767
#define SPECIFIC_SYM 768
#define SQLEXCEPTION_SYM 769
#define SQLSTATE_SYM 770
#define SQLWARNING_SYM 771
#define SQL_BIG_RESULT 772
#define SQL_BUFFER_RESULT 773
#define SQL_CACHE_SYM 774
#define SQL_CALC_FOUND_ROWS 775
#define SQL_NO_CACHE_SYM 776
#define SQL_SMALL_RESULT 777
#define SQL_SYM 778
#define SQL_THREAD 779
#define SSL_SYM 780
#define STARTING 781
#define STARTS_SYM 782
#define START_SYM 783
#define STATS_AUTO_RECALC_SYM 784
#define STATS_PERSISTENT_SYM 785
#define STATS_SAMPLE_PAGES_SYM 786
#define STATUS_SYM 787
#define STDDEV_SAMP_SYM 788
#define STD_SYM 789
#define STOP_SYM 790
#define STORAGE_SYM 791
#define STRAIGHT_JOIN 792
#define STRING_SYM 793
#define SUBCLASS_ORIGIN_SYM 794
#define SUBDATE_SYM 795
#define SUBJECT_SYM 796
#define SUBPARTITIONS_SYM 797
#define SUBPARTITION_SYM 798
#define SUBSTRING 799
#define SUM_SYM 800
#define SUPER_SYM 801
#define SUSPEND_SYM 802
#define SWAPS_SYM 803
#define SWITCHES_SYM 804
#define SYSDATE 805
#define TABLES 806
#define TABLESPACE 807
#define TABLE_REF_PRIORITY 808
#define TABLE_STATS_SYM 809
#define TABLE_SYM 810
#define TABLE_CHECKSUM_SYM 811
#define TABLE_NAME_SYM 812
#define TEMPORARY 813
#define TEMPTABLE_SYM 814
#define TERMINATED 815
#define TEXT_STRING 816
#define TEXT_SYM 817
#define THAN_SYM 818
#define THEN_SYM 819
#define TIMESTAMP 820
#define TIMESTAMP_ADD 821
#define TIMESTAMP_DIFF 822
#define TIME_SYM 823
#define TINYBLOB 824
#define TINYINT 825
#define TINYTEXT 826
#define TO_SYM 827
#define TRAILING 828
#define TRANSACTION_SYM 829
#define TRANSACTIONAL_SYM 830
#define TRIGGERS_SYM 831
#define TRIGGER_SYM 832
#define TRIM 833
#define TRUE_SYM 834
#define TRUNCATE_SYM 835
#define TYPES_SYM 836
#define TYPE_SYM 837
#define UDF_RETURNS_SYM 838
#define ULONGLONG_NUM 839
#define UNCOMMITTED_SYM 840
#define UNDEFINED_SYM 841
#define UNDERSCORE_CHARSET 842
#define UNDOFILE_SYM 843
#define UNDO_BUFFER_SIZE_SYM 844
#define UNDO_SYM 845
#define UNICODE_SYM 846
#define UNINSTALL_SYM 847
#define UNION_SYM 848
#define UNIQUE_SYM 849
#define UNKNOWN_SYM 850
#define UNLOCK_SYM 851
#define UNSIGNED 852
#define UNTIL_SYM 853
#define UPDATE_SYM 854
#define UPGRADE_SYM 855
#define USAGE 856
#define USER 857
#define USER_STATS_SYM 858
#define USE_FRM 859
#define USE_SYM 860
#define USING 861
#define UTC_DATE_SYM 862
#define UTC_TIMESTAMP_SYM 863
#define UTC_TIME_SYM 864
#define VALUES 865
#define VALUE_SYM 866
#define VARBINARY 867
#define VARCHAR 868
#define VARIABLES 869
#define VARIANCE_SYM 870
#define VARYING 871
#define VAR_SAMP_SYM 872
#define VIA_SYM 873
#define VIEW_SYM 874
#define VIRTUAL_SYM 875
#define WAIT_SYM 876
#define WARNINGS 877
#define WEEK_SYM 878
#define WEIGHT_STRING_SYM 879
#define WHEN_SYM 880
#define WHERE 881
#define WHILE_SYM 882
#define WITH 883
#define WITH_CUBE_SYM 884
#define WITH_ROLLUP_SYM 885
#define WORK_SYM 886
#define WRAPPER_SYM 887
#define WRITE_SYM 888
#define X509_SYM 889
#define XA_SYM 890
#define XML_SYM 891
#define XOR 892
#define YEAR_MONTH_SYM 893
#define YEAR_SYM 894
#define ZEROFILL 895
#define IMPOSSIBLE_ACTION 896

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 897 "/home/buildbot/git/sql/sql_yacc.yy" /* yacc.c:355  */

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  LEX_TYPE lex_type;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  DYNCALL_CREATE_DEF *dyncol_def;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  bool is_not_empty;

#line 2328 "/home/buildbot/git/mkdist/sql/sql_yacc.cc" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif



int MYSQLparse (THD *thd);

#endif /* !YY_MYSQL_HOME_BUILDBOT_GIT_MKDIST_SQL_SQL_YACC_H_INCLUDED  */

/* Copy the second part of user declarations.  */
#line 958 "/home/buildbot/git/sql/sql_yacc.yy" /* yacc.c:358  */

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);

#line 2345 "/home/buildbot/git/mkdist/sql/sql_yacc.cc" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  623
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   65755

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  664
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1003
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2831
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4803

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   896

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   657,     2,     2,     2,   651,   646,     2,
     654,   655,   649,   648,   656,   647,   662,   650,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   663,   660,
     644,   642,   643,     2,   661,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   652,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   658,   645,   659,   653,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1937,  1937,  1949,  1948,  1973,  1980,  1982,  1986,  1987,
    1992,  1993,  1994,  1995,  1996,  1997,  1998,  1999,  2000,  2001,
    2002,  2003,  2004,  2005,  2006,  2007,  2008,  2009,  2010,  2011,
    2012,  2013,  2014,  2015,  2016,  2017,  2018,  2019,  2020,  2021,
    2022,  2023,  2024,  2025,  2026,  2027,  2028,  2029,  2030,  2031,
    2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,  2041,
    2042,  2043,  2044,  2045,  2046,  2050,  2059,  2060,  2064,  2073,
    2079,  2089,  2088,  2098,  2100,  2104,  2105,  2109,  2122,  2121,
    2141,  2140,  2149,  2150,  2154,  2158,  2162,  2166,  2170,  2174,
    2179,  2183,  2187,  2191,  2195,  2199,  2204,  2208,  2213,  2244,
    2249,  2252,  2254,  2255,  2259,  2265,  2269,  2285,  2289,  2295,
    2305,  2315,  2328,  2332,  2336,  2352,  2351,  2396,  2401,  2395,
    2408,  2413,  2406,  2420,  2425,  2418,  2431,  2430,  2443,  2442,
    2458,  2462,  2466,  2470,  2474,  2481,  2494,  2495,  2499,  2503,
    2507,  2511,  2515,  2519,  2523,  2531,  2530,  2561,  2560,  2567,
    2574,  2575,  2581,  2587,  2597,  2603,  2609,  2611,  2618,  2619,
    2623,  2629,  2638,  2639,  2647,  2647,  2703,  2704,  2705,  2706,
    2707,  2708,  2709,  2710,  2711,  2712,  2713,  2714,  2715,  2720,
    2734,  2750,  2768,  2769,  2773,  2774,  2779,  2781,  2783,  2785,
    2787,  2789,  2791,  2797,  2798,  2799,  2803,  2807,  2815,  2814,
    2827,  2829,  2832,  2834,  2838,  2842,  2849,  2851,  2855,  2856,
    2861,  2881,  2909,  2911,  2915,  2916,  2920,  2947,  2948,  2949,
    2950,  2954,  2955,  2959,  2960,  2965,  2968,  2995,  2994,  3058,
    3074,  3073,  3129,  3155,  3155,  3178,  3179,  3184,  3186,  3191,
    3213,  3224,  3228,  3250,  3251,  3255,  3259,  3268,  3274,  3280,
    3289,  3303,  3326,  3332,  3333,  3339,  3342,  3346,  3354,  3374,
    3376,  3394,  3400,  3402,  3404,  3406,  3408,  3410,  3412,  3414,
    3416,  3418,  3420,  3422,  3427,  3442,  3458,  3459,  3464,  3470,
    3479,  3485,  3494,  3502,  3511,  3520,  3522,  3531,  3536,  3542,
    3551,  3559,  3561,  3563,  3565,  3567,  3569,  3571,  3573,  3575,
    3577,  3579,  3581,  3583,  3588,  3606,  3627,  3628,  3632,  3633,
    3634,  3635,  3636,  3637,  3638,  3639,  3640,  3641,  3642,  3643,
    3644,  3649,  3648,  3655,  3655,  3710,  3709,  3738,  3738,  3753,
    3806,  3849,  3870,  3869,  3891,  3910,  3912,  3913,  3917,  3937,
    3960,  3962,  3978,  3960,  3997,  3999,  4000,  4004,  4005,  4010,
    4016,  4009,  4037,  4036,  4052,  4053,  4057,  4058,  4063,  4067,
    4062,  4088,  4092,  4087,  4111,  4121,  4126,  4125,  4160,  4161,
    4166,  4165,  4197,  4197,  4212,  4211,  4248,  4260,  4262,  4259,
    4289,  4288,  4309,  4311,  4316,  4318,  4320,  4337,  4342,  4348,
    4355,  4356,  4364,  4370,  4379,  4385,  4391,  4392,  4396,  4396,
    4401,  4402,  4403,  4407,  4408,  4409,  4413,  4417,  4418,  4419,
    4423,  4424,  4425,  4426,  4427,  4428,  4429,  4430,  4434,  4438,
    4439,  4440,  4444,  4445,  4446,  4447,  4448,  4452,  4456,  4457,
    4458,  4462,  4463,  4464,  4465,  4466,  4467,  4468,  4472,  4476,
    4477,  4478,  4482,  4483,  4484,  4489,  4497,  4505,  4513,  4525,
    4537,  4542,  4547,  4555,  4563,  4571,  4579,  4587,  4595,  4603,
    4616,  4629,  4642,  4644,  4648,  4653,  4666,  4667,  4721,  4720,
    4723,  4729,  4729,  4730,  4744,  4745,  4749,  4751,  4750,  4754,
    4753,  4759,  4796,  4797,  4802,  4801,  4820,  4839,  4838,  4855,
    4859,  4867,  4866,  4869,  4871,  4873,  4875,  4880,  4881,  4887,
    4888,  4905,  4906,  4910,  4911,  4915,  4934,  4944,  4955,  4964,
    4965,  4981,  4983,  4982,  4987,  4985,  4996,  4997,  5001,  5019,
    5035,  5036,  5052,  5067,  5089,  5090,  5095,  5094,  5118,  5130,
    5152,  5151,  5169,  5168,  5188,  5210,  5214,  5243,  5255,  5256,
    5261,  5272,  5260,  5297,  5298,  5302,  5315,  5336,  5349,  5375,
    5376,  5381,  5380,  5417,  5426,  5427,  5431,  5432,  5436,  5438,
    5444,  5450,  5452,  5454,  5456,  5458,  5460,  5470,  5485,  5469,
    5499,  5500,  5504,  5505,  5509,  5510,  5514,  5515,  5519,  5520,
    5524,  5525,  5529,  5534,  5538,  5546,  5550,  5556,  5558,  5562,
    5563,  5567,  5568,  5569,  5573,  5578,  5583,  5588,  5593,  5598,
    5603,  5608,  5623,  5629,  5644,  5649,  5664,  5670,  5688,  5693,
    5698,  5703,  5708,  5713,  5719,  5718,  5744,  5745,  5746,  5751,
    5756,  5761,  5763,  5765,  5767,  5773,  5778,  5783,  5789,  5795,
    5801,  5810,  5818,  5835,  5858,  5872,  5873,  5874,  5875,  5876,
    5877,  5878,  5882,  5883,  5884,  5888,  5889,  5893,  5894,  5895,
    5896,  5901,  5908,  5909,  5913,  5914,  5918,  5919,  5927,  5926,
    5935,  5933,  5943,  5941,  5951,  5949,  5957,  5978,  5984,  5986,
    5990,  5994,  5995,  5999,  6004,  6003,  6029,  6032,  6031,  6041,
    6043,  6048,  6051,  6055,  6062,  6063,  6067,  6068,  6072,  6078,
    6084,  6088,  6104,  6120,  6121,  6122,  6123,  6128,  6132,  6137,
    6142,  6146,  6151,  6156,  6162,  6167,  6173,  6177,  6182,  6187,
    6205,  6207,  6209,  6222,  6224,  6229,  6234,  6246,  6251,  6256,
    6261,  6263,  6265,  6267,  6269,  6271,  6273,  6275,  6278,  6277,
    6282,  6281,  6285,  6287,  6296,  6297,  6298,  6304,  6305,  6306,
    6307,  6308,  6312,  6316,  6317,  6321,  6322,  6326,  6327,  6328,
    6329,  6330,  6334,  6335,  6336,  6337,  6338,  6342,  6347,  6349,
    6355,  6356,  6358,  6363,  6372,  6373,  6377,  6378,  6382,  6383,
    6384,  6388,  6389,  6390,  6391,  6394,  6395,  6399,  6400,  6404,
    6405,  6409,  6410,  6414,  6415,  6416,  6417,  6424,  6425,  6431,
    6437,  6443,  6449,  6450,  6463,  6469,  6475,  6481,  6490,  6511,
    6517,  6522,  6523,  6527,  6535,  6539,  6540,  6544,  6545,  6549,
    6558,  6562,  6563,  6567,  6575,  6576,  6580,  6581,  6585,  6586,
    6591,  6592,  6596,  6603,  6612,  6617,  6625,  6626,  6627,  6628,
    6629,  6630,  6635,  6643,  6644,  6649,  6648,  6661,  6662,  6666,
    6669,  6670,  6671,  6672,  6676,  6684,  6691,  6692,  6696,  6706,
    6707,  6711,  6712,  6715,  6717,  6721,  6733,  6734,  6738,  6745,
    6758,  6759,  6761,  6763,  6769,  6774,  6780,  6786,  6793,  6803,
    6804,  6805,  6806,  6807,  6811,  6815,  6816,  6820,  6821,  6825,
    6826,  6830,  6831,  6832,  6836,  6837,  6841,  6845,  6858,  6870,
    6871,  6875,  6876,  6880,  6881,  6885,  6886,  6890,  6891,  6895,
    6896,  6900,  6901,  6905,  6906,  6910,  6912,  6913,  6919,  6925,
    6931,  6939,  6940,  6944,  6948,  6949,  6962,  6963,  6964,  6968,
    6969,  6973,  6979,  6993,  6994,  6998,  7010,  7011,  7015,  7016,
    7024,  7042,  7023,  7062,  7061,  7075,  7087,  7086,  7105,  7104,
    7123,  7122,  7141,  7135,  7155,  7154,  7187,  7192,  7197,  7202,
    7207,  7217,  7218,  7219,  7220,  7224,  7225,  7237,  7238,  7242,
    7243,  7246,  7248,  7256,  7264,  7266,  7268,  7269,  7277,  7278,
    7282,  7291,  7289,  7302,  7315,  7314,  7327,  7325,  7338,  7345,
    7355,  7356,  7383,  7390,  7394,  7399,  7398,  7414,  7416,  7421,
    7429,  7428,  7444,  7448,  7447,  7459,  7460,  7464,  7479,  7480,
    7484,  7493,  7497,  7502,  7508,  7507,  7519,  7530,  7518,  7546,
    7555,  7564,  7574,  7583,  7589,  7595,  7604,  7613,  7632,  7650,
    7660,  7664,  7669,  7670,  7673,  7675,  7676,  7677,  7678,  7681,
    7686,  7697,  7702,  7713,  7714,  7718,  7719,  7723,  7723,  7726,
    7728,  7732,  7733,  7737,  7738,  7746,  7747,  7748,  7752,  7753,
    7758,  7766,  7767,  7768,  7769,  7774,  7773,  7783,  7782,  7789,
    7796,  7806,  7823,  7826,  7833,  7837,  7844,  7848,  7852,  7859,
    7859,  7865,  7866,  7870,  7871,  7872,  7876,  7877,  7890,  7897,
    7898,  7903,  7902,  7914,  7915,  7916,  7920,  7921,  7921,  7926,
    7925,  7946,  7947,  7951,  7952,  7956,  7957,  7958,  7962,  7963,
    7968,  7967,  7988,  7989,  7993,  7998,  7999,  8006,  8008,  8012,
    8014,  8013,  8025,  8027,  8026,  8039,  8040,  8045,  8054,  8055,
    8056,  8060,  8066,  8075,  8083,  8084,  8084,  8088,  8087,  8113,
    8114,  8118,  8119,  8123,  8124,  8125,  8126,  8127,  8128,  8132,
    8133,  8138,  8137,  8158,  8159,  8160,  8165,  8164,  8170,  8177,
    8182,  8190,  8191,  8195,  8209,  8208,  8221,  8222,  8226,  8227,
    8231,  8241,  8251,  8252,  8257,  8256,  8267,  8268,  8272,  8273,
    8277,  8287,  8298,  8297,  8305,  8305,  8314,  8315,  8320,  8321,
    8330,  8339,  8340,  8344,  8349,  8354,  8359,  8364,  8363,  8383,
    8391,  8383,  8398,  8399,  8400,  8401,  8402,  8406,  8413,  8420,
    8422,  8433,  8434,  8438,  8439,  8467,  8497,  8499,  8506,  8517,
    8518,  8519,  8533,  8538,  8563,  8569,  8575,  8576,  8577,  8578,
    8579,  8583,  8584,  8585,  8589,  8590,  8591,  8595,  8596,  8601,
    8652,  8659,  8702,  8708,  8714,  8720,  8726,  8732,  8738,  8744,
    8748,  8754,  8760,  8766,  8772,  8778,  8782,  8788,  8797,  8803,
    8811,  8817,  8827,  8833,  8842,  8852,  8858,  8868,  8874,  8883,
    8887,  8893,  8899,  8905,  8911,  8917,  8923,  8929,  8935,  8941,
    8947,  8953,  8959,  8965,  8971,  8975,  8976,  8980,  8981,  8985,
    8986,  8990,  8991,  8995,  8996,  8997,  8998,  8999,  9000,  9004,
    9005,  9010,  9016,  9020,  9027,  9034,  9041,  9048,  9055,  9060,
    9066,  9073,  9080,  9088,  9099,  9121,  9128,  9136,  9137,  9138,
    9139,  9140,  9141,  9152,  9153,  9154,  9155,  9156,  9162,  9166,
    9172,  9178,  9184,  9190,  9192,  9199,  9206,  9212,  9236,  9245,
    9252,  9260,  9266,  9273,  9279,  9293,  9300,  9316,  9322,  9328,
    9336,  9344,  9350,  9356,  9362,  9368,  9382,  9393,  9399,  9405,
    9411,  9417,  9423,  9429,  9435,  9441,  9447,  9453,  9459,  9465,
    9471,  9477,  9483,  9489,  9497,  9518,  9525,  9531,  9538,  9545,
    9552,  9559,  9565,  9571,  9578,  9584,  9591,  9597,  9603,  9609,
    9615,  9621,  9639,  9645,  9651,  9658,  9665,  9673,  9680,  9687,
    9694,  9701,  9718,  9724,  9730,  9736,  9742,  9749,  9755,  9761,
    9767,  9773,  9779,  9790,  9796,  9802,  9808,  9814,  9822,  9828,
    9839,  9845,  9851,  9859,  9869,  9875,  9891,  9897,  9904,  9911,
    9918,  9925,  9932,  9936,  9956,  9955, 10027, 10068, 10070, 10075,
   10076, 10080, 10081, 10085, 10086, 10090, 10097, 10105, 10132, 10138,
   10144, 10150, 10156, 10162, 10171, 10178, 10180, 10177, 10187, 10198,
   10204, 10210, 10216, 10222, 10228, 10234, 10240, 10246, 10253, 10252,
   10272, 10271, 10286, 10296, 10304, 10320, 10321, 10326, 10331, 10334,
   10337, 10336, 10353, 10355, 10361, 10360, 10377, 10379, 10381, 10383,
   10385, 10387, 10389, 10391, 10393, 10395, 10401, 10407, 10410, 10409,
   10415, 10416, 10420, 10427, 10435, 10436, 10440, 10447, 10455, 10456,
   10460, 10461, 10465, 10473, 10484, 10485, 10497, 10508, 10509, 10515,
   10516, 10536, 10540, 10538, 10556, 10554, 10565, 10575, 10573, 10591,
   10590, 10600, 10611, 10609, 10628, 10627, 10638, 10650, 10651, 10652,
   10656, 10657, 10665, 10666, 10670, 10685, 10685, 10700, 10740, 10825,
   10836, 10841, 10833, 10860, 10880, 10888, 10880, 10897, 10896, 10919,
   10936, 10919, 10943, 10947, 10973, 10974, 10979, 10982, 10983, 10984,
   10988, 10989, 10994, 10993, 10999, 10998, 11006, 11007, 11010, 11012,
   11012, 11016, 11016, 11021, 11022, 11026, 11028, 11033, 11034, 11038,
   11049, 11062, 11063, 11064, 11065, 11066, 11067, 11068, 11069, 11070,
   11071, 11072, 11073, 11077, 11078, 11079, 11080, 11081, 11082, 11083,
   11084, 11085, 11089, 11090, 11091, 11092, 11095, 11097, 11098, 11102,
   11103, 11111, 11113, 11117, 11119, 11118, 11132, 11135, 11134, 11149,
   11155, 11169, 11171, 11175, 11177, 11182, 11183, 11203, 11228, 11232,
   11233, 11237, 11249, 11251, 11256, 11255, 11290, 11292, 11297, 11298,
   11299, 11304, 11311, 11315, 11316, 11320, 11327, 11331, 11338, 11345,
   11352, 11362, 11395, 11399, 11405, 11411, 11420, 11428, 11432, 11439,
   11440, 11444, 11445, 11446, 11450, 11451, 11452, 11453, 11454, 11455,
   11459, 11460, 11461, 11462, 11463, 11467, 11468, 11469, 11470, 11471,
   11475, 11476, 11477, 11478, 11479, 11483, 11488, 11489, 11493, 11494,
   11497, 11500, 11499, 11542, 11543, 11547, 11548, 11552, 11562, 11562,
   11572, 11573, 11577, 11596, 11629, 11628, 11641, 11649, 11640, 11651,
   11663, 11675, 11674, 11692, 11691, 11702, 11702, 11718, 11725, 11747,
   11767, 11779, 11783, 11788, 11787, 11797, 11803, 11810, 11815, 11820,
   11830, 11831, 11835, 11846, 11859, 11860, 11864, 11876, 11880, 11888,
   11889, 11897, 11905, 11896, 11915, 11922, 11914, 11932, 11940, 11941,
   11949, 11953, 11954, 11965, 11966, 11970, 11979, 11980, 11981, 11983,
   11982, 11993, 11994, 11998, 11999, 12001, 12000, 12004, 12003, 12009,
   12010, 12014, 12015, 12019, 12029, 12030, 12034, 12035, 12040, 12039,
   12053, 12054, 12058, 12063, 12071, 12072, 12080, 12082, 12082, 12090,
   12098, 12089, 12120, 12121, 12125, 12133, 12134, 12138, 12148, 12149,
   12156, 12155, 12171, 12182, 12170, 12185, 12184, 12196, 12195, 12208,
   12210, 12214, 12215, 12219, 12232, 12248, 12249, 12253, 12254, 12258,
   12259, 12260, 12265, 12264, 12285, 12287, 12290, 12292, 12295, 12296,
   12299, 12303, 12307, 12311, 12315, 12319, 12323, 12327, 12331, 12339,
   12342, 12352, 12351, 12367, 12374, 12382, 12390, 12398, 12406, 12414,
   12421, 12428, 12434, 12436, 12438, 12447, 12451, 12456, 12455, 12461,
   12460, 12465, 12474, 12481, 12486, 12491, 12496, 12498, 12500, 12502,
   12504, 12506, 12513, 12521, 12523, 12531, 12538, 12545, 12552, 12558,
   12564, 12572, 12580, 12584, 12589, 12596, 12601, 12608, 12615, 12622,
   12629, 12636, 12643, 12649, 12656, 12663, 12668, 12673, 12678, 12688,
   12690, 12692, 12697, 12698, 12701, 12703, 12707, 12708, 12712, 12713,
   12717, 12718, 12722, 12723, 12727, 12728, 12731, 12733, 12740, 12751,
   12750, 12766, 12765, 12775, 12776, 12777, 12778, 12779, 12783, 12784,
   12788, 12789, 12790, 12794, 12795, 12796, 12811, 12810, 12823, 12822,
   12833, 12837, 12838, 12851, 12854, 12853, 12865, 12866, 12871, 12873,
   12875, 12877, 12879, 12881, 12892, 12894, 12896, 12898, 12904, 12906,
   12917, 12919, 12921, 12923, 12925, 12927, 12929, 12934, 12935, 12939,
   12940, 12944, 12943, 12953, 12954, 12958, 12958, 12961, 12962, 12966,
   12967, 12972, 12971, 12982, 12986, 12990, 13003, 13002, 13017, 13018,
   13019, 13022, 13023, 13024, 13025, 13033, 13037, 13046, 13052, 13064,
   13075, 13085, 13095, 13063, 13103, 13104, 13108, 13109, 13113, 13114,
   13122, 13126, 13127, 13128, 13131, 13133, 13137, 13138, 13142, 13147,
   13154, 13159, 13166, 13168, 13172, 13173, 13177, 13182, 13190, 13191,
   13194, 13196, 13204, 13206, 13210, 13211, 13212, 13216, 13218, 13223,
   13224, 13233, 13234, 13238, 13239, 13243, 13256, 13279, 13291, 13298,
   13317, 13325, 13330, 13342, 13350, 13365, 13385, 13386, 13387, 13395,
   13396, 13397, 13398, 13412, 13418, 13424, 13430, 13436, 13442, 13459,
   13469, 13479, 13485, 13494, 13506, 13512, 13518, 13534, 13535, 13539,
   13548, 13563, 13567, 13613, 13617, 13634, 13638, 13716, 13740, 13770,
   13771, 13787, 13797, 13801, 13807, 13813, 13823, 13829, 13838, 13848,
   13849, 13877, 13891, 13905, 13920, 13921, 13931, 13932, 13942, 13943,
   13944, 13948, 13963, 13995, 14005, 14005, 14007, 14017, 14018, 14019,
   14020, 14021, 14022, 14023, 14024, 14025, 14026, 14027, 14028, 14029,
   14030, 14031, 14032, 14033, 14034, 14035, 14036, 14037, 14038, 14039,
   14040, 14041, 14042, 14043, 14044, 14045, 14046, 14047, 14048, 14049,
   14050, 14051, 14052, 14053, 14054, 14055, 14056, 14057, 14058, 14059,
   14060, 14061, 14062, 14063, 14064, 14065, 14066, 14067, 14068, 14069,
   14070, 14071, 14072, 14073, 14074, 14075, 14076, 14086, 14087, 14088,
   14089, 14090, 14091, 14092, 14093, 14094, 14095, 14096, 14097, 14098,
   14099, 14100, 14101, 14102, 14103, 14104, 14105, 14106, 14107, 14108,
   14109, 14110, 14111, 14112, 14113, 14114, 14115, 14116, 14117, 14118,
   14119, 14120, 14121, 14122, 14123, 14124, 14125, 14126, 14127, 14128,
   14129, 14130, 14131, 14132, 14133, 14134, 14135, 14140, 14141, 14142,
   14143, 14144, 14145, 14146, 14147, 14148, 14149, 14150, 14151, 14152,
   14153, 14154, 14155, 14156, 14157, 14158, 14159, 14160, 14161, 14162,
   14163, 14164, 14165, 14166, 14167, 14168, 14169, 14170, 14171, 14172,
   14173, 14174, 14175, 14176, 14177, 14178, 14179, 14180, 14181, 14182,
   14183, 14184, 14185, 14186, 14187, 14188, 14189, 14190, 14191, 14192,
   14193, 14194, 14195, 14196, 14197, 14198, 14199, 14200, 14201, 14202,
   14203, 14204, 14205, 14206, 14207, 14208, 14209, 14210, 14211, 14212,
   14213, 14214, 14215, 14216, 14217, 14218, 14219, 14220, 14221, 14222,
   14223, 14224, 14225, 14226, 14227, 14228, 14229, 14230, 14231, 14232,
   14233, 14234, 14235, 14236, 14237, 14238, 14239, 14240, 14241, 14242,
   14243, 14244, 14245, 14246, 14247, 14248, 14249, 14250, 14251, 14252,
   14253, 14254, 14255, 14256, 14257, 14258, 14259, 14260, 14261, 14262,
   14263, 14264, 14265, 14266, 14267, 14268, 14269, 14270, 14271, 14272,
   14273, 14274, 14275, 14276, 14277, 14278, 14279, 14280, 14281, 14282,
   14283, 14284, 14285, 14286, 14287, 14288, 14289, 14290, 14291, 14292,
   14293, 14294, 14295, 14296, 14297, 14298, 14299, 14300, 14301, 14302,
   14303, 14304, 14305, 14306, 14307, 14308, 14309, 14310, 14311, 14312,
   14313, 14314, 14315, 14316, 14317, 14318, 14319, 14320, 14321, 14322,
   14323, 14324, 14325, 14326, 14327, 14328, 14329, 14330, 14331, 14332,
   14333, 14334, 14335, 14336, 14337, 14338, 14339, 14340, 14341, 14342,
   14343, 14344, 14345, 14346, 14347, 14348, 14349, 14350, 14351, 14352,
   14353, 14354, 14355, 14356, 14357, 14358, 14359, 14360, 14361, 14362,
   14363, 14364, 14365, 14366, 14367, 14368, 14369, 14370, 14371, 14372,
   14373, 14374, 14375, 14376, 14377, 14378, 14379, 14380, 14381, 14382,
   14383, 14384, 14385, 14386, 14387, 14388, 14389, 14390, 14391, 14392,
   14393, 14394, 14395, 14396, 14397, 14398, 14399, 14400, 14412, 14411,
   14429, 14428, 14435, 14434, 14444, 14443, 14454, 14453, 14459, 14467,
   14469, 14474, 14474, 14483, 14482, 14496, 14495, 14500, 14504, 14505,
   14506, 14510, 14511, 14512, 14513, 14517, 14518, 14519, 14520, 14525,
   14549, 14575, 14586, 14598, 14611, 14626, 14645, 14651, 14676, 14689,
   14715, 14758, 14772, 14773, 14774, 14775, 14779, 14796, 14813, 14814,
   14818, 14819, 14820, 14821, 14825, 14826, 14835, 14846, 14847, 14848,
   14854, 14860, 14872, 14871, 14887, 14888, 14892, 14893, 14897, 14912,
   14913, 14914, 14919, 14920, 14925, 14924, 14944, 14956, 14969, 14968,
   15002, 15003, 15007, 15008, 15012, 15013, 15014, 15015, 15017, 15016,
   15029, 15030, 15031, 15032, 15033, 15039, 15044, 15050, 15061, 15072,
   15076, 15083, 15092, 15094, 15099, 15104, 15111, 15123, 15135, 15142,
   15154, 15155, 15158, 15159, 15162, 15167, 15175, 15186, 15209, 15212,
   15214, 15218, 15219, 15226, 15228, 15232, 15233, 15238, 15237, 15241,
   15240, 15244, 15243, 15247, 15246, 15249, 15250, 15251, 15252, 15253,
   15254, 15255, 15256, 15257, 15258, 15259, 15260, 15261, 15262, 15263,
   15264, 15265, 15266, 15267, 15268, 15269, 15270, 15271, 15272, 15273,
   15274, 15278, 15279, 15283, 15284, 15288, 15298, 15308, 15321, 15336,
   15349, 15362, 15374, 15379, 15387, 15392, 15400, 15405, 15412, 15412,
   15413, 15413, 15416, 15445, 15450, 15456, 15462, 15468, 15472, 15476,
   15477, 15481, 15508, 15510, 15514, 15518, 15522, 15529, 15530, 15534,
   15535, 15539, 15540, 15544, 15545, 15551, 15557, 15563, 15573, 15572,
   15582, 15583, 15588, 15589, 15590, 15595, 15596, 15597, 15601, 15602,
   15606, 15618, 15627, 15637, 15646, 15660, 15661, 15666, 15665, 15681,
   15682, 15683, 15687, 15688, 15692, 15692, 15714, 15715, 15719, 15720,
   15721, 15725, 15729, 15736, 15739, 15737, 15753, 15760, 15781, 15805,
   15807, 15811, 15812, 15816, 15817, 15825, 15826, 15827, 15828, 15834,
   15840, 15850, 15852, 15854, 15859, 15860, 15861, 15862, 15863, 15867,
   15868, 15869, 15870, 15871, 15872, 15882, 15883, 15888, 15901, 15914,
   15916, 15918, 15924, 15925, 15927, 15933, 15932, 15949, 15950, 15954,
   15959, 15967, 15967, 15991, 15992, 15997, 15998, 16000, 16002, 16020,
   16026, 16031, 16013, 16092, 16109, 16133, 16164, 16168, 16177, 16200,
   16129, 16263, 16287, 16296, 16303, 16262, 16323, 16327, 16331, 16335,
   16339, 16343, 16350, 16357, 16364, 16374, 16375, 16379, 16380, 16381,
   16385, 16386, 16391, 16393, 16392, 16398, 16399, 16403, 16410, 16420,
   16426, 16437
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADMIN_SYM", "ADDDATE_SYM", "AFTER_SYM", "AGAINST",
  "AGGREGATE_SYM", "ALGORITHM_SYM", "ALL", "ALTER", "ALWAYS_SYM",
  "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC",
  "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM", "AUTHORS_SYM",
  "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AUTO_SYM", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKPOINT_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLIENT_STATS_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CHECK_SYM", "COLUMN_CREATE_SYM",
  "COLUMN_DELETE_SYM", "COLUMN_GET_SYM", "COLUMN_SYM", "COLUMN_NAME_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM", "CONSTRAINT_SCHEMA_SYM",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURRENT_ROLE",
  "CURRENT_POS_SYM", "CURSOR_SYM", "CURSOR_NAME_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXAMINED_SYM", "EXECUTE_SYM",
  "EXISTS", "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM",
  "FETCH_SYM", "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM",
  "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM",
  "FROM", "FULL", "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL",
  "GENERATED_SYM", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GET_FORMAT",
  "GET_SYM", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM",
  "GROUP_CONCAT_SYM", "HANDLER_SYM", "HARD_SYM", "HASH_SYM", "HAVING",
  "HELP_SYM", "HEX_NUM", "HEX_STRING", "HIGH_PRIORITY", "HOST_SYM",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "ID_SYM", "IDENT", "IDENTIFIED_SYM",
  "IDENT_QUOTED", "IF", "IGNORE_SYM", "IGNORE_SERVER_IDS_SYM", "IMPORT",
  "INDEXES", "INDEX_SYM", "INDEX_STATS_SYM", "INFILE", "INITIAL_SIZE_SYM",
  "INNER_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD",
  "INSTALL_SYM", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM",
  "KILL_SYM", "LANGUAGE_SYM", "LAST_SYM", "LAST_VALUE", "LE", "LEADING",
  "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD",
  "LOCAL_SYM", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM",
  "LOGS_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "MASTER_CONNECT_RETRY_SYM", "MASTER_GTID_POS_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_USE_GTID_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEG", "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM",
  "NOT2_SYM", "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM",
  "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM",
  "NVARCHAR_SYM", "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM",
  "ONLY_SYM", "ONLINE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM",
  "OPTION", "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM",
  "OUTER", "OUTFILE", "OUT_SYM", "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM",
  "PAGE_CHECKSUM_SYM", "PARAM_MARKER", "PARSER_SYM", "PARSE_VCOL_EXPR_SYM",
  "PARTIAL", "PARTITION_SYM", "PARTITIONS_SYM", "PARTITIONING_SYM",
  "PASSWORD", "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM",
  "POINT_SYM", "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION",
  "PREPARE_SYM", "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES",
  "PROCEDURE_SYM", "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM",
  "PROFILES_SYM", "PROXY_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM",
  "QUICK", "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM",
  "READ_WRITE_SYM", "REAL", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY",
  "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM",
  "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "REMOVE_SYM", "RENAME",
  "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESIGNAL_SYM", "RESOURCES",
  "RESTORE_SYM", "RESTRICT", "RESUME_SYM", "RETURNED_SQLSTATE_SYM",
  "RETURNING_SYM", "RETURNS_SYM", "RETURN_SYM", "REVERSE_SYM", "REVOKE",
  "RIGHT", "ROLE_SYM", "ROLLBACK_SYM", "ROLLUP_SYM", "ROUTINE_SYM",
  "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "ROW_COUNT_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLAVES",
  "SLAVE_POS_SYM", "SLOW", "SMALLINT", "SNAPSHOT_SYM", "SOCKET_SYM",
  "SOFT_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM",
  "STATS_AUTO_RECALC_SYM", "STATS_PERSISTENT_SYM",
  "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM", "STDDEV_SAMP_SYM", "STD_SYM",
  "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN", "STRING_SYM",
  "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBPARTITIONS_SYM",
  "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM",
  "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE",
  "TABLE_REF_PRIORITY", "TABLE_STATS_SYM", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM",
  "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USER_STATS_SYM", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VAR_SAMP_SYM", "VIA_SYM", "VIEW_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM",
  "WHERE", "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM",
  "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM",
  "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "IMPOSSIBLE_ACTION",
  "'='", "'>'", "'<'", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'",
  "'^'", "'~'", "'('", "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'",
  "'.'", "':'", "$accept", "query", "$@1", "opt_end_of_input",
  "verb_clause", "statement", "deallocate", "deallocate_or_drop",
  "prepare", "prepare_src", "execute", "$@2", "execute_using",
  "execute_var_list", "execute_var_ident", "help", "$@3", "change", "$@4",
  "master_defs", "master_def", "ignore_server_id_list", "ignore_server_id",
  "master_file_def", "optional_connection_name", "connection_name",
  "create", "$@5", "$@6", "$@7", "$@8", "$@9", "$@10", "$@11", "$@12",
  "$@13", "server_def", "server_options_list", "server_option",
  "event_tail", "$@14", "ev_schedule_time", "$@15", "opt_ev_status",
  "ev_starts", "ev_ends", "opt_ev_on_completion", "ev_on_completion",
  "opt_ev_comment", "ev_sql_stmt", "$@16", "ev_sql_stmt_inner",
  "clear_privileges", "sp_name", "sp_a_chistics", "sp_c_chistics",
  "sp_chistic", "sp_c_chistic", "sp_suid", "call", "$@17",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "$@18", "$@19",
  "sp_cursor_stmt", "$@20", "sp_handler_type", "sp_hcond_list",
  "sp_hcond_element", "sp_cond", "sqlstate", "opt_value", "sp_hcond",
  "signal_stmt", "signal_value", "opt_signal_value",
  "opt_set_signal_information", "signal_information_item_list",
  "signal_allowed_expr", "signal_condition_information_item_name",
  "resignal_stmt", "get_diagnostics", "which_area",
  "diagnostics_information", "statement_information",
  "statement_information_item", "simple_target_specification",
  "statement_information_item_name", "condition_number",
  "condition_information", "condition_information_item",
  "condition_information_item_name", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "sp_proc_stmt_if", "$@21", "sp_proc_stmt_statement",
  "$@22", "sp_proc_stmt_return", "$@23", "sp_proc_stmt_unlabeled", "$@24",
  "sp_proc_stmt_leave", "sp_proc_stmt_iterate", "sp_proc_stmt_open",
  "sp_proc_stmt_fetch", "$@25", "sp_proc_stmt_close", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "$@26", "$@27", "$@28", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "$@29", "$@30",
  "searched_case_stmt", "$@31", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "$@32", "$@33",
  "searched_when_clause", "$@34", "$@35", "else_clause_opt",
  "sp_labeled_control", "$@36", "sp_opt_label", "sp_labeled_block", "$@37",
  "sp_unlabeled_block", "$@38", "sp_block_content", "$@39",
  "sp_unlabeled_control", "$@40", "$@41", "$@42", "trg_action_time",
  "trg_event", "change_tablespace_access", "change_tablespace_info",
  "tablespace_info", "opt_logfile_group_name", "alter_tablespace_info",
  "logfile_group_info", "alter_logfile_group_info", "add_log_file",
  "change_ts_option_list", "$@43", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create_body",
  "$@44", "$@45", "create_like", "opt_create_select", "$@46", "$@47",
  "opt_create_partitioning", "opt_partitioning", "partitioning", "$@48",
  "have_partitioning", "partition_entry", "$@49", "partition",
  "part_type_def", "$@50", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@51",
  "$@52", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@53", "part_name", "opt_part_values", "$@54", "$@55", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@56", "$@57",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@58", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@59", "$@60", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "create_or_replace", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "$@61", "default_charset", "default_collation",
  "storage_engines", "known_storage_engines", "row_types",
  "merge_insert_types", "opt_select_from", "udf_type", "create_field_list",
  "field_list", "field_list_item", "column_def", "key_def", "$@62", "$@63",
  "$@64", "$@65", "opt_check_constraint", "check_constraint",
  "opt_constraint", "constraint", "field_spec", "$@66", "field_def", "@67",
  "opt_generated_always", "vcol_opt_specifier", "vcol_opt_attribute",
  "vcol_opt_attribute_list", "vcol_attribute", "parse_vcol_expr",
  "virtual_column_func", "type", "$@68", "$@69", "spatial_type", "char",
  "nchar", "varchar", "nvarchar", "int_type", "real_type", "float_options",
  "precision", "field_options", "field_opt_list", "field_option",
  "field_length", "opt_field_length", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "type_with_opt_collate",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "ws_nweights", "$@70", "ws_level_flag_desc", "ws_level_flag_reverse",
  "ws_level_flags", "ws_level_number", "ws_level_list_item",
  "ws_level_list", "ws_level_range", "ws_level_list_or_range",
  "opt_ws_levels", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_if_not_exists_ident", "opt_component", "string_list", "alter",
  "$@71", "$@72", "$@73", "$@74", "$@75", "$@76", "$@77", "$@78",
  "ev_alter_on_schedule_completion", "opt_ev_rename_to", "opt_ev_sql_stmt",
  "ident_or_empty", "alter_commands", "$@79", "$@80", "$@81",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "$@82", "add_part_extra", "reorg_partition_rule", "$@83",
  "reorg_parts_rule", "$@84", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item", "$@85", "$@86", "$@87",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "alter_options", "$@88",
  "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@89", "$@90", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_thread_opts", "$@91",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@92", "opt_checksum_type",
  "repair_table_or_view", "$@93", "repair", "$@94", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "opt_view_repair_type", "analyze",
  "$@95", "analyze_table_list", "analyze_table_elem_spec",
  "opt_persistent_stat_clause", "persistent_stat_spec",
  "persistent_column_stat_spec", "$@96", "persistent_index_stat_spec",
  "$@97", "table_column_list", "table_index_list", "table_index_name",
  "binlog_base64_event", "check_view_or_table", "$@98", "check", "$@99",
  "opt_mi_check_type", "mi_check_types", "mi_check_type",
  "opt_view_check_type", "optimize", "$@100", "opt_no_write_to_binlog",
  "rename", "$@101", "rename_list", "table_to_table_list",
  "table_to_table", "keycache", "$@102", "keycache_list_or_parts",
  "keycache_list", "assign_to_keycache", "assign_to_keycache_parts",
  "key_cache_name", "preload", "$@103", "preload_list_or_parts",
  "preload_list", "preload_keys", "preload_keys_parts", "adm_partition",
  "$@104", "cache_keys_spec", "$@105", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_paren_derived", "select_init2", "$@106", "select_part2", "$@107",
  "$@108", "select_into", "select_from", "select_options",
  "select_option_list", "select_option", "select_lock_type",
  "select_item_list", "select_item", "remember_name", "remember_end",
  "select_alias", "opt_default_time_precision", "opt_time_precision",
  "optional_braces", "expr", "bool_pri", "predicate", "bit_expr", "or",
  "and", "not", "not2", "comp_op", "all_or_any", "opt_dyncol_type",
  "dyncol_type", "dyncall_create_element", "dyncall_create_list",
  "simple_expr", "function_call_keyword", "function_call_nonkeyword",
  "function_call_conflict", "geometry_function", "function_call_generic",
  "@109", "fulltext_options", "opt_natural_language_mode",
  "opt_query_expansion", "opt_udf_expr_list", "udf_expr_list", "udf_expr",
  "sum_expr", "$@110", "$@111", "$@112", "variable", "$@113",
  "variable_aux", "opt_distinct", "opt_gconcat_separator",
  "opt_gorder_clause", "$@114", "gorder_list", "in_sum_expr", "$@115",
  "cast_type", "$@116", "opt_expr_list", "expr_list", "ident_list_arg",
  "ident_list", "opt_expr", "opt_else", "when_list", "table_ref",
  "join_table_list", "esc_table_ref", "derived_table_list", "join_table",
  "$@117", "$@118", "$@119", "$@120", "$@121", "$@122", "inner_join",
  "normal_join", "opt_use_partition", "use_partition", "table_factor",
  "$@123", "select_derived_union", "$@124", "$@125",
  "select_init2_derived", "select_part2_derived", "$@126", "$@127",
  "select_derived", "$@128", "select_derived2", "$@129", "$@130",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@131",
  "$@132", "index_hints_list", "opt_index_hints_list", "$@133",
  "opt_key_definition", "$@134", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@135", "having_clause", "$@136", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@137", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "limit_rows_option",
  "delete_limit_clause", "int_num", "ulong_num", "real_ulong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "procedure_clause", "$@138", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@139",
  "select_var_list", "select_var_ident", "into", "$@140",
  "into_destination", "$@141", "$@142", "do", "$@143", "drop", "$@144",
  "$@145", "$@146", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "opt_if_exists", "opt_temporary", "insert", "$@147",
  "$@148", "replace", "$@149", "$@150", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@151", "fields", "insert_values", "$@152", "$@153", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@154", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@155", "update", "$@156", "$@157", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@158", "single_multi", "$@159", "$@160", "$@161", "$@162",
  "opt_select_expressions", "table_wild_list", "table_wild_one",
  "opt_wild", "opt_delete_options", "opt_delete_option", "truncate",
  "$@163", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@164", "show_param",
  "$@165", "$@166", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@167", "$@168", "explainable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@169", "flush_options", "$@170", "opt_flush_lock",
  "flush_lock", "$@171", "flush_options_list", "flush_option",
  "opt_table_list", "optional_flush_tables_arguments", "reset", "$@172",
  "reset_options", "reset_option", "$@173", "slave_reset_options", "purge",
  "$@174", "purge_options", "purge_option", "kill", "$@175", "kill_type",
  "kill_option", "kill_expr", "shutdown", "use", "load", "$@176", "$@177",
  "$@178", "$@179", "data_or_xml", "opt_local", "load_data_lock",
  "opt_duplicate", "opt_field_term", "field_term_list", "field_term",
  "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "hex_or_bin_String", "param_marker",
  "signed_literal", "literal", "NUM_literal", "temporal_literal",
  "insert_ident", "table_wild", "order_ident", "simple_ident",
  "simple_ident_nospvar", "simple_ident_q", "field_ident", "table_ident",
  "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user_maybe_role",
  "user_or_role", "user", "keyword", "keyword_sp", "set", "$@180",
  "start_option_value_list", "$@181", "$@182", "$@183",
  "start_option_value_list_following_option_type", "$@184",
  "option_value_list_continued", "option_value_list", "$@185", "$@186",
  "option_value", "$@187", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "internal_variable_name",
  "transaction_characteristics", "transaction_access_mode",
  "isolation_level", "transaction_access_mode_types", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@188",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@189", "handler", "$@190", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@191",
  "handler_rkey_mode", "revoke", "revoke_command", "admin_option_for_role",
  "grant", "grant_command", "opt_with_admin", "opt_with_admin_option",
  "role_list", "current_role", "grant_role", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "$@192", "$@193", "$@194", "$@195", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "user_and_role_list", "via_or_with", "using_or_as",
  "grant_user", "opt_column_list", "column_list", "column_list_id",
  "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@196", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@197",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@198",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@199", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_algorithm", "view_suid",
  "view_tail", "$@200", "view_list_opt", "view_list", "view_select",
  "$@201", "view_select_aux", "view_check_option", "trigger_tail", "$@202",
  "$@203", "$@204", "udf_tail", "sf_tail", "$@205", "$@206", "$@207",
  "$@208", "$@209", "sp_tail", "$@210", "$@211", "$@212", "$@213", "xa",
  "xid", "begin_or_start", "opt_join_or_resume", "opt_one_phase",
  "opt_suspend", "$@214", "opt_migrate", "install", "uninstall",
  "keep_gcc_happy", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,    61,    62,    60,   124,    38,    45,    43,    42,
      47,    37,    94,   126,    40,    41,    44,    33,   123,   125,
      59,    64,    46,    58
};
# endif

#define YYPACT_NINF -4104

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-4104)))

#define YYTABLE_NINF -2773

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
    6117,  2462,   763, -4104,  -155,   910, 57520,   110,  1296, -4104,
     585,  3795, -4104, -4104, -4104, -4104, -4104,  3487, -4104, 57520,
     763,  1151, -4104, 25808, -4104, -4104,   -37, -4104,    72,  1296,
     763,   790, -4104, 57520, -4104,  1144,  1454,   763, -4104, -4104,
   50557, -4104,   585, 57520, -4104, -4104, -4104, -4104, 50557,   194,
     192,  1114,  1214, -4104, -4104, 57520,  2107, -4104,  -158,  1696,
    1193, -4104, -4104,  1335, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104,  1491, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, 26447,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104,  1071, 57520,  1149, 57520,  1632, 57520, 48658, 57520,
   -4104,  1629, -4104, -4104,  1721, -4104, -4104,  1296,   585, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,  1207, -4104, -4104,  -155,
   -4104, -4104, -4104,  -181, -4104,  1856,  1644, -4104,  1684,  1448,
   -4104, 48658, -4104, 57520, -4104, -4104, -4104,  1665,  1678,  1730,
     121, 12164,  1741,  1741,  1741,  1741,  1785,  1741, -4104,  1741,
   57520, -4104,  1741, -4104,  1741,  1296, -4104, -4104, -4104,  1844,
   37264, 57520,  1621,   240,   -96, 48658,   183, 57520,  -155,    60,
   -4104,  1756, -4104, -4104, -4104,  1296, -4104,  1973,  1836,   242,
   57520, -4104, -4104, -4104,   987,    -2,  1427, -4104, -4104,  1556,
   -4104, 37897,   154, -4104, -4104, -4104,  2407, 28364,  6774,  1556,
    1575,  -155,  -127,  1584,  -155, -4104, -4104, 57520,  -155,  1296,
    1806, -4104, -4104,   209,   209,   209, -4104,   209, -4104,   209,
   -4104,  -158,  1446, -4104, -4104,  1443, 57520, -4104,   338,  1553,
   -4104,  1554,   949,  1404, -4104, -4104,  1457,   866, -4104,  1534,
   41062, -4104, 57520, -4104, -4104, -4104, -4104,  1744, -4104, -4104,
   -4104,  2790, -4104,  1583,   104, 57520,  1627, -4104, -4104, -4104,
   25808,  1500, 57520,  1569, -4104, -4104, 25808, -4104, -4104, 25808,
     230,  1294,  1269, 57520, 57520, -4104, 45493,  1964, -4104,  2162,
   41062,  1644,  1644,  1644, -4104, -4104, -4104, 51190,   121,  1533,
    1535,  1544, 17428, -4104,  1549,  1567,  1594, 12164,  1603,  1609,
    1612,  1614,  1623,  1637,  1639,  1643,  1645,  1650,  1656,  1673,
    1694,  1707,  1707,  1707,  1719,  1746,  1750,  1752,  -184,  1755,
   -4104,  1761,  1763,  1774, -4104, -4104,  1797,  1808,  1810, -4104,
   -4104,  1812,  1814,  1819, 12822,  1828,  1832,  1837, -4104, 22601,
    1840,  1843,  1865,  1869,  1871,  1874,  1878,  1892,  1894, -4104,
   -4104, 12164,  1719, -4104, -4104,  1897, -4104,  1903,  1913,  1928,
    1936,  1940,  1957,  1967,  1969,  1971,  1979,  1989,  1991,  1994,
    1996,  2006,  2017,  2019,  1719, -4104,   875,  2029,  2041,   995,
    2043, -4104,  2046, -4104,   285,  2048,  1707,  1719,  1719,  2057,
    2068,  2076,  2082,  2092,  2095, 17428, 17428, 17428, 12164, -4104,
   57520, -4104, 57520,  1183,  2732, -4104,  3267, 17428,   916, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,  1538,  1649, -4104, -4104,
   -4104, -4104, -4104, -4104,  2105,  1590,  2052, 57520, 57520, 57520,
   57520, 57520, 57520, 45493, 48658,  1687, 57520, 46126, -4104,  1741,
    1666,  3683, 31554,  1835,  1815,  1611,  1707, -4104, -4104,   -93,
     756,   779,  1921, -4104, -4104,  1787,   804,  2072, -4104,   871,
     422, -4104,    79,   883,   886, -4104, -4104, -4104, -4104, -4104,
   -4104,  1771,  2096,  1740, -4104, -4104,   169, -4104, -4104, 57520,
   -4104, -4104, -4104, -4104,  2144,  1993, -4104, -4104, -4104,   940,
    2425,   215, 25808, -4104,  1946, 12164,  1850, -4104,  -202, -4104,
   -4104,  2332, -4104, -4104, 46126, 25808,  -179, -4104, -4104, 23242,
   -4104, -4104,  2611, -4104,  2013, -4104, -4104,  1649,  3867, -4104,
    2393,  1835,  2402, -4104,  2581, -4104,  2412,  2311,  1294,  2202,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
    2149,  2407, -4104, -4104,   590,  2318,  2142,   669,  1040, 36628,
     501, 48658,  1366,    50, 29002, 41695,  2154, -4104, -4104, -4104,
     704,  2320, -4104,  2658, -4104, -4104,   735, -4104,  2181,  1529,
     735, 46759,  2566,   180, -4104,   167, -4104,  2652, -4104, -4104,
   -4104, -4104, -4104,  2322,  2300,  2347, -4104,   324,  2431, -4104,
    -155, -4104,  1027, -4104, -4104,  2342, -4104,  2566,   735,   180,
   -4104,  2572,  2731,   628,  2701,  -165, -4104, -4104, -4104,   -91,
    2809, -4104,  2265, -4104, -4104, -4104, 25808, -4104, -4104, -4104,
    2144, -4104, -4104, -4104, -4104,  2274, -4104, -4104,  2548,  2386,
   -4104, -4104,    63, -4104,  2284,   -13,  2779, -4104, -4104,   268,
    -109,  1721,  1644, -4104,  2031, 42328, -4104, -4104, -4104,  2811,
    2828,  1707,  2303, -4104, -4104, -4104, -4104, -4104,  2955, -4104,
   -4104,  2312,  2859,  2859,  2859,  2966, -4104, -4104, -4104, 25808,
   -4104, -4104, -4104,   104, -4104, -4104,  2502,  2391, -4104,  1627,
   25808,  2777,  2349, -4104, -4104,  2639, 12164, -4104, -4104, -4104,
     226, -4104, -4104, 25808,   118, -4104,  2982,  2602, -4104, -4104,
   -4104, -4104,  2871, -4104, -4104,  2955,   893, -4104,  2935,  2859,
    2825, -4104,  2836,  2413, -4104, 57520, 57520, 57520, 25808, -4104,
    2419, -4104,  2415, -4104, 12164, 12164,   317,  3020,  3082,  3082,
    3082,  1183,  2478, 12164, 12164, 12164, 12164, 12164, 12164, 12164,
   12164, 12164, 12164, 12164, 12164,   323,  2450, -4104, -4104, -4104,
     326, -4104,  2459, 12164, 12164, -4104, 12164, 12164, 27086, -4104,
    3718, 12164,   825,  2974, 12164, 12164, 12164, 12164,  2986, 12164,
   12164, 12164, 27086,  3116,  2472, -4104,  2468,  1537, 12164, 12164,
    1551, 12164, 12164, 12164, 12164, 12164, -4104, -4104, 12164, 12164,
   12164, 12164, 17428, 12164, 12164, 12164, 12164, 12164, 12164,  2488,
   12164,  3082,  3082, 12164, 12164,  1597, -4104, -4104, 12164,  2853,
    2853, -4104, 12164,  8874, 12164, -4104, -4104,  2490, -4104, -4104,
   -4104, 27086,  3082,  3082, 12164, 12164, 12164,  3020,  3020,  3020,
     206,  2494,   927, 12164, 29640,  2493, -4104, -4104, -4104, -4104,
   12164, 12164, 12164, 17428, -4104,  1845, -4104, -4104, -4104, -4104,
   -4104, 13480, 17428, 17428,  2504, 17428, 17428, 17428, 17428, 17428,
    2888, 17428, 17428, 18086, 18744, 17428, 17428, 17428, 17428,  1054,
    3020, 48658, 17428, 12164, -4104, -4104, 57520, -4104, -4104, -4104,
    2503,  2796,  1687, -4104,  2522, -4104,   685,  3021, -4104, -4104,
   -4104,  2530, 25808, -4104,  2527, -4104,  2909, -4104, -4104,  2912,
    2915,  2917, -4104, -4104, -4104, -4104, -4104,  3153,  2922, -4104,
    -155,  2930, -4104, -4104, -4104, -4104,  2561, -4104, -4104, 19402,
   48658, -4104,  2565, -4104,  2580, -4104, -4104, -4104, -4104, -4104,
   -4104,  2673, -4104, -4104, -4104, -4104,  2575, -4104, 46126,  2575,
   -4104, -4104,  2575, -4104, -4104,  2575, 41062,   802,  3618, -4104,
   -4104, 57520, -4104, 58153, -4104, -4104, 23242,  -155, -4104,  3002,
   14138, -4104, -4104, -4104,  2957,   200,  2583, -4104, 25808, -4104,
    1183, -4104,   108,   108,  2837,   178, 48658, -4104, -4104,   187,
    2585,  2671,  2590, -4104,  2678, -4104, -4104, 25808, 25808, -4104,
   -4104, -4104,  2855, -4104,  -155,    -2, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,  2599,
    2614,  3063,  2610, 46126, 41062,   878, -4104, 57520, -4104,  1599,
   -4104, -4104, -4104,  2616, -4104, 12164, -4104, -4104, 57520, -4104,
   -4104, -4104, -4104, -4104,  3194, 12164, -4104, 46126,   -46, -4104,
      73,  1018,   704, -4104, -4104, -4104, -4104, -4104, 57520, 51823,
    2618,  9532,  2738,  3026,  -155, 12164, -4104,  2632,  1644, 57520,
   57520, 57520, 25808, 57520, 25808, -4104,   806,   806, -4104, 42961,
   -4104, -4104, -4104, -4104,   735, 57520, 57520,   735, 41062, -4104,
     180,   701, 57520,   735, -4104,  3031,  2736, -4104, -4104, -4104,
    3100, -4104, -4104,  3093,  2634, -4104,  3121, -4104, -4104,  2761,
     180, -4104, -4104, 25808, -4104, -4104,   180, -4104,   180,   180,
   12164,   735,   735, -4104,   -81, -4104, -4104, -4104,  2793,  -127,
   -4104, -4104, -4104,  1141,   209,  2893, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,    81, -4104, -4104, -4104,
   -4104, -4104, -4104,   229, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104,  1309, -4104, -4104, -4104, -4104, -4104,  1627, 25808, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,    74,
   -4104, -4104, -4104,  2008,  3158, -4104, 48658,  2734,  -105,  1488,
    2734,  2278,  -155,   171, -4104,   171, -4104, -4104, -4104,  2929,
     212, 25808, -4104,  2654, -4104,  2919, 52456, 25808, -4104, -4104,
   -4104,  1032,  2662,  2666,  1183,  4192, -4104, -4104, 25808, -4104,
     207, -4104, -4104, -4104,  2725, -4104, -4104, -4104, -4104,  2696,
   -4104, -4104, -4104,    76,  1447,  3321, 45493, -4104,  2699,  2728,
     216, 41062, -4104, -4104, -4104,  2679, -4104,  2855, -4104,  1618,
   57520,  3141, 34096, -4104,   276,   748, -4104,  3082,  2688, -4104,
    2692,  2693,  2694, 12164,    92,  1254,   934,  1230,  1302,   980,
     369,  1168,   401, -4104,  1336,   434,   467,   521,   204, -4104,
    2695,  2702, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
    2700, -4104, -4104, -4104,   553,   587,  1212,  1291,  2713,  2715,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
    3169, -4104,  1438, -4104, -4104, -4104, -4104,  2723, -4104, -4104,
    1298,   759,   851,   228,  2735,  1455,   853,  1477,  1524,  2726,
   27086, 57520,  3082,  2737,  1325,  1351,  3082,  2739,   861,  1356,
    1526,  1686,  1712,  1361,  1380,   863,  1715,  2712,  1428,   897,
     904,  1462,   909,   924, -4104,  1476,  2740,  2741,   970,   252,
    3082,  2743,   256,  2745,  2748,  1540, 10190, 10848, 11506,   217,
    1019, -4104,  2751, -4104,  2468,  2752,  2757,   269,   181,  1596,
   -4104, 12164, -4104, -4104,   979,   976,  2797,   136,  1018, -4104,
    2899, 57520,  2370,   175, -4104, -4104, -4104, -4104, -4104, -4104,
     929, -4104,  2759, -4104,  2762,  2118,  2766, 12164,  1083,  2766,
    3001,  1589,  1589, 17428,  2307,  2256, 12822,  1126, 12822,  1126,
    2766,  2766,  2766, -4104, 17428,  2768, 17428, 17428, -4104,  3020,
    1183,  2765,  1078, 57520, 25808,   685, -4104, -4104, -4104, -4104,
     704, 46126,   184, 25808, 48658,  2767, -4104, -4104, -4104, -4104,
   -4104, -4104,  -155, -4104, -4104,  3864, 25808,  2832,  2863,  2865,
   -4104, 32192, -4104, -4104, -4104, -4104, 32192,   -18, -4104, 57520,
   -4104,  2857, -4104, -4104, -4104,  1035, 23881, 23881, -4104, 23881,
   -4104, -4104, -4104, -4104, -4104,   422, -4104, -4104, -4104, -4104,
     259,   294,  2589,  2814, -4104, -4104, -4104, -4104, 33463,  1183,
   -4104, 25808, -4104,  3204,   832, 25808,  2789, -4104,  2792, -4104,
   -4104, -4104, -4104, -4104,   718,  2904, -4104,  3438, -4104, 12164,
    -155, -4104, 46126, 46126, 25808, 25808, 25808,   783, -4104,  1773,
    2794, -4104, -4104,  3439, -4104,  3867, 19402, 45493,  3244,  3259,
   -4104,  2802, 23881, 23881, 23881, -4104, -4104, -4104, -4104, -4104,
     151,  1183, -4104,  2799, -4104, 47392, -4104,  1183,   704,  2817,
    2819, -4104, -4104,  3196,   -80, -4104,  2813,  2818, -4104,  2816,
    2820,  2824, 53089, 12164, -4104,    73, -4104, -4104,   704, -4104,
   -4104, -4104, 17428,  1761, -4104,  1183, -4104, -4104,  -155,  3277,
   -4104,  1183,  2834, 57520, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104,  3315, -4104,  3027,
     -77, -4104, -4104, -4104, -4104, -4104, -4104, -4104,   735, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,  3069,  2566,  2431,  3026,
   -4104,   735,   180, 25808,   735,   735,  1183, -4104, -4104, -4104,
   -4104, -4104,  2845, -4104,  2908, -4104, -4104, -4104, -4104, 57520,
    3037,  3011, -4104,  2847, -4104, -4104, 25808, -4104,  2856, -4104,
    3317,  3462,  2566, -4104, -4104,  3314, 57520, 57520,  1644, 57520,
   57520, -4104, -4104, -4104,   704,   704,  3167, -4104,  -155,  2994,
    2997,  2998,  3005,  3008,  3044, -4104, -4104,  -155,  -155, -4104,
   -4104,   704, -4104,  1136, -4104, -4104, -4104, -4104,  -155,  -155,
    -155,  -155,  1530,  -155,  -155,  1767, -4104, -4104,   704,   704,
   -4104,  1286, -4104, -4104, -4104, -4104, -4104, -4104, -4104,   238,
   -4104,  5011,   163, -4104,  3085, -4104, -4104, -4104, 25808,  3337,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
    2880, -4104, -4104, 12164,  2896,  2900,  2902,  2903,  2907,  2910,
    2911,  2924,  2925,  2931,  2940,  2942,  2943,  2944,  2945,  2948,
    2950,  2953,  2956,  2961,  2962,  2890, -4104, -4104, -4104,  2951,
   -4104, -4104, -4104, -4104,   101,   704,   704,   704,   704, -4104,
    2709, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, 41062,
   -4104, 48658,  3263,  2113,   641, -4104, -4104, 48658, -4104,   962,
    3176,  3187,  3190, 57520,  2991, -4104, 34096, -4104, -4104,  1141,
   -4104,  2918, 14796, -4104,  2958, -4104, 12164, -4104, -4104, -4104,
     787, 12164, 12164,  3412,  2192, -4104, 48025, -4104, -4104, -4104,
   12164, -4104, 12164, -4104, 12164, 12164, 12164, 12164, 48025,  2192,
   12164, -4104,  2960, -4104,  3358,  3359, -4104, -4104, -4104, -4104,
   12164, -4104, 12164, 12164, -4104, 12164, 12164, 12164, 12164, -4104,
   12164, -4104, -4104, 17428, -4104,  2946,  2971, -4104, -4104, -4104,
    2972, -4104, 12164, -4104, -4104, -4104, -4104, -4104, -4104, 12164,
   -4104, 12164, -4104, 12164, 12164, -4104, 12164, 12164, -4104, -4104,
   -4104, 15454, 12164, 12164,  2975, -4104, -4104, 12164, 12164, 12164,
   -4104, 12164,  1306, 12164,  1588, 12164,  2003, 12164, -4104, 12164,
   -4104, -4104, -4104, -4104, 12164,   364,   718,  1530,  2976, -4104,
    1770, -4104, -4104,  2063, -4104,   979,  2978, -4104, -4104,  1599,
   -4104, -4104, 48658, 12164, -4104, -4104, -4104, -4104, -4104, -4104,
   17428,   363,  2979, 17428, -4104,  3001,  2986,  2986,  2267, 12164,
    1083,  3001, 12164,  2980,  2954, -4104, 12164, 57520, -4104, -4104,
   -4104, -4104, 48658, -4104, -4104, -4104, -4104,   184, -4104,  2527,
   -4104, -4104,  2789,    47,  2969,  2981, -4104, -4104, -4104, -4104,
   -4104, -4104,  1824, -4104, 41062,  3605, -4104,  2983, -4104,  2995,
    3066,  3070,  3071, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104,  2566,  1773, -4104, -4104,  2985,
   -4104, -4104,  2639,  3055,  3025,  3379,  3572, -4104, -4104, 57520,
   17428, -4104,  3613,  3009,  3010,  3024,  3015,  1183, -4104,  3098,
   -4104, -4104, -4104,    32, -4104, -4104, -4104, -4104, -4104,    75,
   -4104, -4104,  3017,  3017, 21321, -4104, -4104, -4104, 57520, -4104,
   -4104,  3030, -4104, -4104,  3293, 46126, 41062,  3477,  3478,  3479,
    1096, -4104,   479, -4104,   177,  3430,  2566, -4104,  3481, 49291,
   -4104, 34729, -4104, -4104, -4104, -4104,   -46,  3123,  3124,  1484,
   -4104, -4104,  3427,  3257, -4104, -4104, -4104,   704,  1183, -4104,
    2618,  9532,  3033, 30278, -4104,  1134, -4104,    64, -4104, 43594,
    3512, 43594, 43594, -4104,  3322, -4104, -4104,  3277, -4104,  2814,
     180, -4104, -4104,   -81,  2821, -4104, -4104,  1110,  3433,  3434,
   -4104,  3307,  1559,  3307, -4104, -4104,  1110, 27086,  1141,  2855,
   -4104,  1530,  3367, -4104, -4104, -4104, 57520, -4104,   393, 57520,
    3045,  -148,  5390, 47392, 44227, -4104, -4104, -4104, -4104,  3582,
   -4104,  3583,  1512, -4104, -4104,  3113,  1488, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104,  2278,  3113,  3113,   171, -4104,   158, -4104, -4104,
   -4104, -4104,  2538,   704,  3622,  3306,   704,   704,  3622,   704,
    3309,  3310,   704,   704,  3137,  3568,   704,  3452,  3161,  1905,
    3456,   704,  3318, -4104,  3165,  3586,   704,   704,   704,   704,
     704,  3622,  3331,  3682,   704,   704, -4104,   704,  3334,  3333,
     141,  3336,  3339,   704,   704,   704,   704,   161, 57520,   704,
     704,  3342,   704, -4104, -4104,  7169, -4104, -4104, -4104, -4104,
   -4104, -4104,  1049, 24526, -4104, -4104, -4104, -4104,   704,    33,
     309,  3171,  1222,  3090, -4104,   362,  3091, 53722,  1183,  3094,
    1530,  -155,  -155,  1134,  -155,  1530,  -155,  -155,  -155,  -155,
    -155,  -155,  -155,  1530,  1530,  -155,   988,  1723,  -155,  1530,
    4192, -4104,  -155,   718,  3113,  3113,  1447, -4104, -4104,  3370,
    3535,   704, -4104,  2475, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104,  3195, -4104,   197,  1060,  1060, -4104, 25808,
   25808, 25808, -4104,  3089,  1141,  2814,  1638,  2814,  3106, -4104,
   12822,  1598, -4104,  1183, 12164,  1183,  1317, -4104,  3103,  3103,
    3103, -4104,  3109, -4104, -4104,  3103,  3515,  3103,  3516,  3111,
    3112,  1852,  2024, -4104,  1861,  2035,  1624,  3114,  3115,  1538,
   -4104, 12164, 12164,  1668,  1676,   721,  1023,  1034,   365, -4104,
    1692,  2785, -4104, -4104,  1702,  1709,  1735,  1737,  1043,  1742,
    1888, 12822,  1779,   335,   367, -4104,  1792,  1051,  1137,  1816,
   12164,  1822, 12164,  1848, 12164,  1872,  1876,  1904,  3119,  3119,
     152, -4104,  3120, -4104, -4104, -4104,  3122, -4104, -4104,  2149,
    2063, -4104, -4104,  3125, -4104, -4104,  3117,  1183,  3126, -4104,
   -4104, 12164, -4104,   916, -4104, -4104, 17428,   371,  3127, -4104,
    1183, -4104, -4104,  3128,  1538, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104,  3346, -4104, -4104,  2905, 32192, -4104, 57520,  1128,
    3403,  3138, 35362, 41062, 41062, 41062,  3132, 12164, -4104, -4104,
    3415, 25808, -4104,  3558, -4104, -4104, -4104, -4104, -4104,  3144,
    3136, -4104, -4104, -4104,  3001,  3517,  3402, -4104, -4104,   718,
   57520, 46126,  3457, -4104, -4104,  2407, 27086, -4104,  3146, -4104,
    3146,  1171,  3149,  1900, -4104, -4104, -4104,  3143,  2202,  1909,
   -4104, 19402,  3609,  2530, -4104, 41062, 41062, 41062, -4104,  2814,
    2814,   159,  3212,  3561, -4104, -4104, -4104, -4104, 54355, -4104,
   -4104, -4104, -4104,  1107, -4104,  3159,  3160,   234,  3384, -4104,
   -4104, -4104, -4104,  9532, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,  2566, -4104, -4104, -4104,
   -4104, 43594, -4104, -4104, -4104, -4104, -4104,   735, -4104,  3174,
   -4104,  3163,  -214,   976, -4104,  2141, -4104, -4104, -4104,  3559,
    3307,  3307,  1110,  3560,  1044,  3164, -4104,   704, -4104,  2609,
   -4104,  2407, -4104, -4104, 12164,  3361,  3179, -4104, -4104,    78,
   -4104, -4104,  1264, 25808, 20043, -4104, -4104,  3423, -4104,  3436,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,   238,
   -4104, -4104, 27725,  1644, -4104,   300, -4104,  1644, -4104,  1032,
    1032,  1644, 54988, 27725,   763,  1134,  1530,  1741,  1530, 55621,
     763,  -155,  -155,  2511,   704,  1530, -4104, -4104,  3569,  1741,
    3574,  1741,  1741, -4104, 48658, 57520, -4104,   704,   955,  1530,
   56254,  1134,  1134,  1741,   763, 27086,  1689,  2754, -4104,  -155,
     763, -4104, -4104, -4104, -4104, 25808,   763,   763,  2558,  2938,
    3035,  3096, -4104, -4104, -4104,  1530,  2754, 55621, -4104, -4104,
    7491, -4104, -4104, -4104, 20682, 57520,  1429,   227, -4104,  3177,
   39163,  3428, -4104, 12164, 12164,  3474, 57520,  3480, -4104,  3769,
   57520,  3839, -4104,   139, -4104, 55621, -4104,  3206, -4104,  3207,
   -4104,  1530, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
    3210, 57520,  3113,  2113, -4104, -4104, -4104, -4104,  -155, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, 34096,  2814,  3482,
   -4104, -4104,  2986, -4104,  1183, 12164,   857, -4104, -4104,   190,
   -4104,   887, -4104, -4104, -4104,  3211, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104,  2444, -4104, -4104,  2192, -4104, -4104, -4104,
    3213,  2986,  2986, -4104, -4104,  3820,  3386, 12164, 12164, -4104,
   12164, -4104,   245,  3218,  3246, -4104, -4104, -4104, -4104, 12164,
   -4104, -4104,  2986, -4104, 12164, -4104, -4104, 12164, -4104, 12164,
   12164, -4104,  1915, -4104,  1923, -4104,  1934, -4104, -4104, -4104,
     718,  3221,  3607, -4104, -4104, -4104,   718,  3418, -4104, -4104,
     718,  1530,  2616, -4104, -4104,   927, 57520, -4104, -4104,  1931,
   -4104, -4104, 12164, -4104, 49291, -4104, -4104,  3697,  3600, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104,  3675, -4104, -4104, -4104, -4104,
    -130,  -130,  -130, 16112,  1183,  3734, -4104, -4104, -4104,  3558,
    3620, -4104,    68, -4104, 57520,  3234,   911, -4104,  1943, -4104,
   -4104,  3236, -4104, -4104,  2149,  3237, -4104,   704, 16112,  3017,
    3411, -4104, -4104,  1171, 27086, 34729, -4104, -4104, 57520, -4104,
   41062,  2802,  2802,  2802,  2566,  3684,  3055,  3055, -4104, 30916,
   -4104, -4104,  3404, -4104, -4104, 35995, -4104, -4104, -4104, -4104,
   -4104, -4104, 30278, 53089, -4104, -4104,  2566, -4104,  -155,  2730,
    1599,  2240, -4104,  1141, -4104,  1110,  3637,  3641, -4104,  1110,
   -4104, -4104, 27086,  2814, 16112, -4104,  2149,  1183,  3245,   327,
    1264, -4104, -4104, -4104, -4104,  3530,  3531, 57520, -4104, -4104,
   -4104, -4104,  3399, -4104, 25808,  3256,  3271,  3272, -4104, -4104,
   -4104,   179, -4104,  4219, -4104, -4104, -4104, -4104,   763,  3273,
    3668,  3671,  1032, -4104,  1644, 27725, -4104, -4104,  1644,  1644,
   -4104, -4104, -4104,   800, 55621, -4104, -4104, 27725, -4104, -4104,
   -4104,  3281, -4104, -4104,   718, -4104, -4104, 44227,  -155, -4104,
    1741, 57520, -4104, 27725, 27725, -4104,  3312,  -155, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, 27725, 55621,  3282,
   -4104,   327, -4104, -4104, -4104, -4104, -4104,  1973, -4104, 55621,
   -4104, -4104, 55621, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
    3292,  2615,  1511, -4104,  3295, -4104, 57520, -4104, -4104, 25808,
   -4104, -4104, -4104,  7125, 57520, -4104, -4104, -4104, -4104, -4104,
    1183,  2986,  3860, -4104, -4104,  3447,  -155,  3803, -4104,  1949,
   -4104, -4104, -4104,  3717,  3299, -4104, 53722,  1999, -4104, -4104,
    2278, -4104, -4104, -4104, -4104,  3302,  3303,  3304,  2918, -4104,
    3685,   459,  1183,  3313,  3316,  3319,  3320,  3928,   258, -4104,
    3937, 48025, -4104, -4104, -4104,  2010,  3610, -4104, -4104, -4104,
    3103, -4104,  3109, -4104, -4104, -4104,  3915, -4104, -4104,  3103,
    3730,   190, -4104, -4104,  3326, -4104,  3327,  3329, -4104,   209,
    3330,  1938,  1142,  2026,  3650,  3726, -4104,  3566, -4104,  1942,
    1125,  1947,  1951,  1972,  1983, -4104, -4104, -4104, -4104, -4104,
    3344, -4104, -4104,   473, -4104,  3335,   922,   976, -4104, -4104,
    2085, -4104, -4104,  3976,  3616,   350,  3372,  3372,  3372,  1761,
    1183,  2117, -4104, -4104, -4104, -4104, -4104, -4104,  3754, -4104,
   -4104,  3350,  3438, 57520, -4104,  3402, -4104,  2616, 27086, 16112,
    3351,  3349, -4104,   -13, -4104, -4104,  3345, -4104, -4104,  2802,
   -4104,  3961,  3796, -4104, -4104, 48658,  3356, -4104, -4104,  3677,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,  2847,  2815,
    3409,  1110,  1110,  3003,  3410, 12164,  3363, -4104,  3482, -4104,
   -4104,   424,  2616, 12164, -4104, -4104, -4104,  3509,   941, -4104,
    3542,  3366,  3368, -4104, -4104,  -155,  3371, -4104, -4104, 20682,
   -4104,  4002, -4104, -4104, 12164,  1644, -4104, -4104, -4104, -4104,
    3369, -4104, -4104,  3893,  3895, -4104, -4104,  2696, 57520, -4104,
    3194, -4104, 27725,  3281, -4104,   512,  3475, -4104, -4104, -4104,
   27086, -4104, -4104, -4104, 57520, -4104, 25808, -4104, -4104,  3382,
   -4104,  3103,  3103,  3103, -4104, -4104,  3103, -4104,  3109,  3623,
   -4104,  3109,  3109, -4104, -4104, -4104, -4104, -4104,   190,  1561,
   -4104, -4104,   190, -4104, -4104, -4104,   134,  1248,  3109, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,  3103,  3103,  3103, -4104,
   -4104,   190,  3103, -4104,  3103, -4104,  3464, -4104,   222,   155,
    3103,  3103,  3103,  3211,  3375, -4104, -4104, -4104, -4104, -4104,
   -4104, 57520, -4104,  1116, 57520,   147, -4104, -4104, -4104,  1530,
    2128, 57520, 57520, 57520, 44860, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, 48025, -4104,  4005,  3676,  3387, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, 12164, -4104,
   -4104, -4104, 12164, -4104, -4104,  3710,  3874, -4104, -4104, -4104,
   -4104, -4104, -4104,  3401, -4104,  1530,   177,   177, -4104, -4104,
   -4104,  3911, -4104, -4104,  3499,  3500, -4104, -4104,  3501, -4104,
   -4104,   115,  2140, -4104, -4104, -4104, -4104, 16112,  3805,  3513,
   -4104, -4104,  3419,  3465, -4104, -4104,   922, -4104, -4104, -4104,
   -4104, 12164, -4104,  3482,  2511, -4104, 30916, -4104,   927, -4104,
    3466, -4104, -4104, -4104,  3468,  1183, 57520,  3685, -4104,   736,
     922,   327,  -155, -4104, -4104, -4104,  3421,  3426, -4104, -4104,
   -4104,   309, -4104, 57520,  7125, -4104, -4104,   -13,  7169, -4104,
   -4104,  1117,   695,  2015,  3429,  3431, 57520,  3432,  3437, -4104,
    3288, 27725, -4104, -4104, -4104, -4104, -4104, 25808,  7125,   763,
   -4104, -4104,  3281,    75,  3422, 57520,  3770, -4104, -4104, -4104,
   -4104,  1648, -4104,  3441,  1648,  1648, -4104,  2318, -4104,  3472,
     190, -4104, -4104,  3483, -4104, -4104, -4104,  1648,  3446,   190,
   -4104, -4104, -4104, -4104,  1648, -4104, 48658,  -155,  3162,  4075,
   -4104,  3504, -4104,  3972,  3844,  4089, -4104,  3809, -4104,  3849,
    3744,   704, -4104,   190, -4104, -4104,  4005, -4104,   190,  4005,
    1648,  1648, 57520,  3585, -4104, 63850, -4104, -4104,  -158,  3485,
    2152, -4104, -4104, -4104, -4104, -4104, -4104,  2156,   327,  3463,
    2158,  2169,  3941,  3646,  3657, -4104, -4104,  3469,  3470,   327,
    2022, -4104, -4104, -4104,  3473, -4104, -4104,  4057, -4104, -4104,
   -4104, -4104,   392,  3740,  1530,  1530,  1530,   781,  2140, -4104,
   -4104,  3526, 25808, 17428,  3587, 57520,  1480,  3222, -4104,  -221,
     327, 12164,  2566, 44227, -4104, -4104, -4104, 12164,  3476, 12164,
    3484,  2172, -4104, -4104, -4104,  1032,  1032, -4104,   736, -4104,
   -4104, -4104, -4104,  1419, 57520, 25808,  3474,  3664, -4104,  3194,
   -4104, -4104,  3423,  3411, -4104,   718,  3402, -4104, -4104, 57520,
   57520,  2188, 57520, 57520,  2832,  2863,  2865,  1723,  1723, -4104,
   -4104,  1429, -4104, -4104, -4104,  3883, -4104, -4104,  2205, -4104,
     892,  3758, -4104, -4104, -4104, -4104,  1648, -4104,   209, -4104,
   -4104, -4104, -4104, -4104,   209, -4104, -4104, -4104, -4104,  3488,
   -4104, -4104, -4104,  3771,  3522, -4104, -4104, -4104, -4104, -4104,
   39796, -4104, -4104, -4104, -4104, -4104, -4104, -4104, 12164,  3974,
    3511, 57520,  1025, -4104, 65116, 65116, 57520, -4104, -4104, -4104,
   -4104,  6583, -4104, -4104,   744, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,  4104, -4104,  3486, -4104,
   -4104,  3490,  1431, -4104, -4104, 57520, 56887,  2131, 57520, -4104,
    3775,   132,  1646, -4104,  3964,  2149, -4104, -4104, 12164, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,    80,
   -4104, -4104, 27086,  2855, -4104,   718, -4104,  2207, -4104, -4104,
   -4104,  3584,   704,   704,  4004,  4009,   704,   704,   704,   704,
    3505,  3222, -4104,  3989, -4104, -4104, 12164, -4104, -4104,  1183,
    3738, -4104,  4083,   976,  1183, 57520,  1183, 57520, -4104,  3965,
    3965, -4104, -4104, -4104,  7125,  3966,  1222, -4104, -4104, -4104,
     179,  3508,  2202, -4104,  2216,  2255,  2313, -4104,  2319,  2326,
   -4104, -4104, -4104, -4104,  1429,  3518, -4104, 57520, -4104, -4104,
   -4104,   105, -4104, -4104,  2333, -4104,  2336,  1284, -4104,  3488,
   -4104,  3519, -4104, -4104, -4104, -4104,  1183, 12164, -4104, 12164,
    3540, -4104, -4104,  3968, 57520, -4104, -4104, -4104, -4104, 12164,
   -4104, 63850, 63850, -4104, -4104, -4104, -4104,  4134,   -13,  4110,
    3788,  4112, -4104, -4104,  2340, -4104, -4104,  -155,   704, -4104,
    2131, -4104, -4104, -4104,   704,   327,  3524,  3785, -4104,   132,
   -4104, -4104, -4104,  1646, -4104, -4104, -4104,  2616,   327, -4104,
   -4104,  3529, -4104,   704, -4104,  3527, -4104, -4104, 57520,  3532,
   -4104,  -155,  -155,   704,   704,  2718,  2718,   718, 48658,  3645,
   -4104, -4104,   704,   327, 57520, -4104,  1095,  3914, -4104,  2353,
    2364,  1163, -4104, -4104,  3496, -4104, -4104,  3769,  7125, -4104,
   -4104, -4104, -4104,  3756, -4104,  2131, -4104, -4104, -4104,  3402,
   -4104,  1173,  1173,   190,   209,   190, -4104,  3545, -4104, -4104,
    1183,  1183, -4104,    97, -4104, -4104,  3949,  4041, 12164,  1183,
   60685,  3543, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, 64483, 12164, -4104,   744,  4104,
   -4104,  3821, -4104,  3823, -4104, 56887, -4104,  1530,  1156, -4104,
   40429, -4104, -4104,  1355,  1156, -4104,  1156, -4104, -4104, 27086,
   16112,  2511, -4104,  3587, -4104,  3551, -4104, -4104,   -68, -4104,
   -4104,  -155,  -155, -4104, -4104, -4104, -4104, -4104,  2375, -4104,
   48658, -4104, -4104,  4157,  4159,  4050,  4161,  1095, -4104,  -133,
   -4104, -4104, -4104,  4163, -4104,  4164,  3564,  3567, -4104, -4104,
   -4104,  4080, 63850, -4104,  4073, -4104,   -13, -4104,  2131, -4104,
     132,  1646,  2377, -4104,  4221, -4104,   165,  3850,  3853, -4104,
   -4104, -4104, -4104,  3573,  3604, 12164, 63850, -4104,  4070, -4104,
    3999,  2153,  3942,  3575, -4104,  3576,  1382,  4101, 65116, 65116,
   -4104, -4104, -4104, -4104, -4104,  3952,  4228, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,  2379,
   -4104, 16770, -4104, -4104, -4104, -4104, -4104, 48658, -4104,  3645,
   -4104,  3588,   209,   209,  4194,   209, -4104,  4195,  4196,  -133,
   -4104, -4104, -4104, 53722, 53722, -4104, -4104,  4086, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,  3651,  4116,
    -104, -4104,    99, -4104,  1183, 61318,  4198, 57520, -4104, -4104,
   -4104, -4104, 12164, -4104, 49924, 61951,  3594, -4104, -4104, -4104,
   -4104, -4104,  3790, -4104,  3551, -4104,  3608, -4104,  3001,  3222,
   -4104, -4104,  3611, -4104, -4104,   209, -4104,   209,   209, -4104,
    3614,  2405,  3786, -4104,  3496,  1173,  1173, -4104, -4104,   148,
   12164, -4104,  4105,  3704, -4104,  3615, -4104, 63850,  2062, 63850,
   -4104, -4104,  4056,  3617,   320, -4104,  3612, -4104,  4044,  4083,
   -4104, 16770,  3621, -4104, 12164,  3625,  3629, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, 63850, -4104, -4104,  -155,  4016, -4104,
     148, -4104,  1183,  4223, 63850, 57520, 58786,  3836, 62584,  4093,
   57520,  7125,  4094,  4095, -4104,  4243,  3914, -4104, -4104,  1183,
   -4104, -4104, 63850, -4104, -4104, -4104, -4104,  3729, -4104, 59419,
   -4104,  2906, -4104,  3667, -4104, -4104,  4165,  3286, -4104,   209,
    4062, -4104, -4104, -4104, 63850, 63850, -4104, -4104, -4104, 38530,
   12164, -4104, -4104, -4104, -4104, -4104,  1096, -4104,  3930,  3647,
   60052, 63217, -4104, -4104, -4104, 32830, -4104, -4104, -4104,  4102,
   -4104,  1183, -4104,   812, 21960,  3813, 38530, -4104, -4104, -4104,
   -4104, -4104, -4104, 48658,  2409, -4104, -4104, 27086, -4104, -4104,
   -4104, -4104, 25167,  3644, -4104,   704, -4104, 27086, -4104, -4104,
   16112, -4104, -4104
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   930,  1143,  2698,     0,     0,     0,     0,     0,  1127,
    2700,   585,    66,  1800,  1928,  1929,  1711,  1739,     2,     0,
    1143,   276,   179,     0,    78,  1741,     0,  1986,     0,     0,
    1143,     0,   487,     0,  1981,     0,     0,  1143,  1744,  1971,
     253,   179,  2700,     0,  1189,  2488,  1841,  1997,     0,     0,
       0,  1824,     0,  2564,  1789,     0,     0,  2831,     0,     0,
       3,     8,    19,     0,    41,    24,    29,    14,    18,    13,
      54,    48,    26,    39,   128,    38,    10,    57,    58,    16,
      45,    11,    12,    15,    37,    44,    33,    40,    52,  1180,
      22,    23,    30,    46,    62,    20,    59,    55,    21,  1930,
      25,    47,    42,    34,    56,    63,    35,    53,    36,    61,
      28,    49,    27,     9,    17,    50,    51,    43,    64,    31,
      60,    32,     0,   959,     0,     0,     0,     0,     0,     0,
    1037,   942,  2765,  2766,  2767,  1145,  1144,     0,  2700,  2101,
    1123,  1154,  2177,  2179,  2178,  2180,  2181,  2182,  2183,  2184,
    2185,  2118,  2186,  2187,  2189,  2188,  2190,  2191,  2192,  2119,
    2120,  2193,  2194,  2195,  2197,  2196,  2198,  2121,  2122,  2199,
    2200,  2201,  2202,  2123,  2125,  2124,  2203,  2206,  2205,  2204,
    2126,  2207,  2208,  2209,  2211,  2127,  2128,  2129,  2130,  2131,
    2210,  2132,  2212,  2133,  2213,  2214,  2215,  2216,  2217,  2218,
    2219,  2221,  2220,  2134,  2222,  2223,  2225,  2226,  2227,  2224,
    2228,  2230,  2229,  2231,  2232,  2233,  2135,  2234,  2235,  2236,
    2237,  2238,  2239,  2240,  2241,  2136,  2242,  2243,  2244,  2263,
    2137,  2245,  2248,  2247,  2246,  2249,  2250,  2251,  2253,  2252,
    2254,  2255,  2138,  2139,  2256,  2257,  2258,  2259,  2261,  2260,
    2265,  2266,  2267,  2140,  2262,  2264,  2465,  2268,  2269,  2271,
    2270,  2272,  2141,  2274,  2273,  2142,  2276,  2275,  2143,  2144,
    2277,  2278,  2279,  2099,  2280,  2100,  2281,  2284,  2285,  2282,
    2286,  2291,  2145,  2283,  2287,  2288,  2289,  2290,  2292,  2146,
    2294,  2293,  2295,  2296,  2297,  2298,  2299,  2300,  2301,  2302,
    2303,  2316,  2307,  2308,  2310,  2311,  2314,  2309,  2315,  2319,
    2318,  2320,  2321,  2322,  2323,  2324,  2317,  2305,  2312,  2313,
    2306,  2325,  2326,  2304,  2327,  2328,  2329,  2330,  2331,  2332,
    2333,  2334,  2335,  2336,  2337,  2339,  2338,  2340,  2341,  2342,
    2343,  2344,  2345,  2346,  2348,  2347,  2349,  2350,  2351,  2353,
    2352,  2355,  2356,  2147,  2354,  2357,  2358,  2359,  2360,  2361,
    2363,  2362,  2148,  2150,  2149,  2151,  2364,  2365,  2152,  2366,
    2368,  2367,  2369,  2370,  2371,  2373,  2372,  2374,  2375,  2153,
    2154,  2376,  2377,  2378,  2379,  2380,  2381,  2382,  2383,  2384,
    2385,  2386,  2387,  2388,  2389,  2391,  2390,  2392,  2393,  2394,
    2395,  2396,  2397,  2398,  2155,  2399,  2156,  2400,  2401,  2157,
    2402,  2158,  2403,  2404,  2405,  2406,  2407,  2159,  2408,  2409,
    2410,  2412,  2413,  2411,  2414,  2160,  2415,  2416,  2417,  2161,
    2419,  2418,  2420,  2162,  2422,  2163,  2164,  2421,  2166,  2167,
    2423,  2424,  2425,  2165,  2426,  2168,  2427,  2428,  2430,  2429,
    2431,  2432,  2433,  2169,  2434,  2170,  2435,  2436,  2437,  2438,
    2439,  2441,  2440,  2442,  2443,  2444,  2445,  2448,  2450,  2447,
    2449,  2446,  2451,  2452,  2453,  2454,  2458,  2459,  2460,  2461,
    2455,  2456,  2457,  2171,  2462,  2463,  2464,  2466,  2467,  2469,
    2468,  2172,  2173,  2470,  2471,  2176,  2472,  2473,  2474,  2478,
    2475,  2487,  2476,  2477,  2480,  2479,  2481,  2482,  2483,  2174,
    2484,  2175,  2485,  2486,   198,  2104,   181,  2105,  2117,   112,
    2555,  2554,  1081,     0,  2701,  2702,   583,   886,     0,     0,
     179,     0,   887,     0,   885,   179,   134,     0,     0,     0,
    1817,     0,  1737,  1737,  1737,  1737,     0,  1737,   179,  1737,
       0,  1740,  1737,   179,  1737,     0,    71,  1936,   277,     0,
       0,     0,     0,     0,  2098,     0,  1747,     0,     0,  1988,
    2004,     0,  2005,  1999,  2552,     0,  1214,     0,     0,     0,
       0,   179,  1146,  1089,  1798,     0,   243,   252,   254,   255,
     251,     0,  2702,  2713,  1181,  1187,  1199,     0,  1908,   255,
       0,   112,  1062,     0,   112,  1825,  1822,     0,     0,     0,
    1798,  1998,  2815,     0,     0,     0,  2811,     0,  2816,     0,
    1189,     0,     0,     1,     5,     0,     0,   582,  2767,     0,
     579,   580,  2258,  2368,  1921,  1919,  2093,     0,   933,   960,
       0,   938,     0,   936,  2110,  2109,  2108,     0,   949,   948,
     946,     0,   448,     0,  1039,     0,  2772,   940,  1100,  2699,
       0,   200,     0,     0,   113,   114,     0,  1125,  1128,     0,
       0,  2705,     0,     0,     0,   586,     0,     0,   133,     0,
       0,   583,   583,   583,  1821,  1820,  1819,     0,  1817,  2178,
    2118,  2192,     0,  2067,     0,     0,     0,  1498,     0,  2123,
       0,  2207,  2209,  2127,  2128,  2129,  2130,  2131,  2134,     0,
       0,  1227,  1227,  1227,  1224,     0,     0,     0,  2232,  2233,
    2072,     0,     0,     0,  2063,  2073,  2271,  2272,     0,  2065,
    2066,  2278,     0,     0,     0,  2293,     0,  2298,  2070,     0,
       0,  2334,  2336,     0,     0,  2340,  2341,  2342,  2343,  2047,
    1282,     0,  1224,  2062,  2069,  2360,  2055,  2369,  2374,  2375,
       0,  2384,     0,     0,  2406,     0,  2413,  2411,  2417,     0,
       0,  2438,     0,     0,  1224,  2046,  2458,  2459,  2460,  2461,
       0,  2064,  2171,  2071,     0,  2472,  1227,  1224,  1224,     0,
       0,     0,  2481,  2482,  2486,     0,     0,     0,  2737,  1281,
       0,  1460,     0,  1492,  1239,  1245,  1259,     0,  1274,  1308,
    1309,  1311,  1415,  1310,  1316,  1315,  1712,  2059,  1314,  1313,
    2060,  2061,  1307,  2083,  2104,  2082,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1904,     0,     0,  1723,  1737,
      73,     0,     0,  2613,  2628,  2629,  1227,  2625,  2630,  2252,
    2139,  2265,     0,  2627,  2619,     0,  2379,  2383,  2623,  2398,
    2401,  2617,     0,  2163,  2442,  2649,  2621,  2626,  2607,  2594,
    2608,     0,     0,  2611,  2615,  2095,  1606,  2567,  2568,     0,
      79,  1749,  1750,  1748,  1035,     0,  2828,  1989,  1990,  1991,
       0,  2008,     0,  1141,     0,     0,   497,   488,     0,  1903,
    1902,     0,  1982,  2714,     0,     0,     0,  1752,  1799,     0,
    1751,  1977,     0,  1975,  1972,  1974,   244,     0,     0,   274,
    2179,  2613,  2383,  2585,     0,  2593,     0,  2708,  2705,  2715,
    2750,  2745,  2744,  2747,  2748,  1205,  2749,  1204,  2746,  2743,
    1214,  1200,  1202,  1203,   802,     0,     0,  2508,  2509,  2348,
    2369,  2407,  2510,  2455,     0,     0,  2529,  2489,  2494,  2490,
       0,     0,  1863,     0,   802,  1886,  1916,  1864,     0,     0,
    1916,     0,  1641,  1906,  1909,     0,  2512,  1877,   883,   882,
    1889,   881,  2513,  1902,     0,  1849,  1865,     0,  1826,  1870,
     112,  2514,     0,  1905,  1888,     0,  1887,  1641,  1916,     0,
    1842,     0,     0,     0,     0,     0,   250,  1069,  1069,     0,
       0,  1061,  1063,  1064,  1069,  1069,     0,  2829,  2830,  2565,
    1035,  2054,  2052,  2053,  2102,  2812,  2051,  2050,  2820,  2822,
    2808,  2810,  2817,  1183,     0,  2719,     6,    65,   129,  1214,
    1214,  2767,   583,   581,     0,  1933,  2770,  2771,  2769,   818,
       0,  1227,  2111,  2114,  2768,  2115,   182,   947,     0,   449,
     182,     0,     0,     0,     0,     0,   450,   451,   387,     0,
    1043,  1044,  1038,  1040,  1042,   944,     0,     0,   943,  2772,
       0,     0,  1156,  1158,  1157,  1174,   202,   199,   180,    80,
    1083,  1730,  1732,     0,  1129,  2704,     0,     0,  2706,  2710,
    1280,  1279,     0,   126,   132,     0,  2600,  2604,     0,     0,
    2114,  2676,     0,   130,  2664,     0,     0,     0,     0,  1801,
    1805,  1811,  1815,  1818,     0,     0,  1611,  1329,  1611,  1611,
    1611,  1499,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1611,     0,  1367,  1339,  1340,
       0,  1368,     0,     0,     0,  2074,     0,     0,     0,  2737,
       0,     0,     0,  1465,     0,     0,     0,  2737,     0,     0,
       0,     0,     0,     0,  1494,  1496,  2082,  1611,     0,     0,
    1611,     0,     0,     0,     0,     0,  1232,  1373,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1611,  1611,     0,     0,  1611,  1381,  2076,     0,     0,
       0,  2075,     0,     0,     0,  2048,  2068,     0,  1384,  1386,
    1385,     0,  1611,  1611,     0,     0,     0,  1319,  1318,  1320,
       0,     0,     0,     0,     0,     0,  1278,  1277,  1276,  1275,
       0,     0,     0,     0,  1284,     0,  1286,  1288,  1283,  1285,
    1287,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1321,     0,     0,     0,  2049,  1424,     0,  1738,  1717,  1725,
    1719,     0,  1904,  1720,  1722,  1729,   462,     0,  1726,  2116,
    2662,  1721,     0,  1713,     0,    72,     0,  1960,  1965,     0,
       0,     0,  1955,  1963,  1957,  1964,  1956,     0,     0,  1966,
     112,     0,  1958,  1962,  1961,  1937,  1940,  1947,  1938,     0,
       0,   275,   278,   280,     0,   283,  2614,  2612,  2646,  2645,
    2650,     0,  2647,  2643,  2606,  2636,  2677,  2640,     0,  2677,
    2642,  2641,  2677,  2637,  2644,  2677,     0,  2609,     0,  1607,
    1608,     0,  2566,     0,  2094,  1036,     0,     0,  1992,  1993,
       0,  1164,  2009,  2010,  2006,  1606,  2553,  2556,     0,   691,
    1215,   498,     0,     0,   509,     0,     0,    68,    69,     0,
    1148,     0,  1147,  1151,     0,  1087,  1090,     0,     0,  1755,
    1745,  1754,  1532,  1978,   112,     0,   242,   267,   262,   270,
     264,   266,   265,   271,   272,   273,   268,   263,   269,   256,
       0,     0,  2612,     0,     0,  2609,  2709,     0,  2711,  2728,
    1188,  2716,  1211,  1190,  1210,     0,  1201,   801,     0,   804,
     806,  1775,  1774,   805,   814,     0,   803,     0,     0,  2526,
       0,  2515,     0,   810,   812,   811,  2523,   809,     0,     0,
    2499,     0,     0,  1912,     0,     0,  1876,     0,   583,     0,
       0,     0,     0,     0,     0,  1843,     0,     0,   634,     0,
    1869,  1642,  1910,  1911,  1916,     0,     0,  1916,     0,  1882,
    1906,  1916,     0,  1916,  1838,     0,     0,  1830,  1835,  1831,
       0,  1837,  1836,  1839,  1827,  1828,     0,  1856,  1884,     0,
    1906,  1868,  1875,     0,  1855,  1862,     0,  1873,  1906,  1906,
       0,  1916,  1916,  1057,  1073,  1055,  1067,  1068,     0,     0,
    1060,  1059,  1823,  1535,     0,     0,  2809,  2823,  2807,  2818,
    2819,  2806,  1184,  2720,  1182,  2721,     0,     7,     4,  1214,
    1214,  1214,  2764,     0,  2752,  2759,  2760,  2763,  2762,  2761,
    2758,     0,  2751,  2754,  2755,  2757,  2756,  2772,     0,  1923,
    1924,  1925,  1926,  1927,  1922,  1920,  1934,  1935,   819,   818,
     574,   577,   576,     0,     0,  2113,     0,   939,     0,  1904,
     937,     0,     0,  1904,   398,  1904,   452,   931,  1041,   951,
       0,     0,   941,  1101,  1102,  1105,     0,     0,   486,  1174,
    1160,  1176,     0,   203,   205,     0,  1085,  1084,     0,  1082,
    1139,  1137,  1136,  1134,     0,  1135,  1133,  1124,  1130,  1131,
    2703,  2707,   584,   818,  1904,     0,     0,   131,     0,   390,
       0,     0,   888,   888,   888,  1807,  1734,  1532,  1736,  2093,
       0,     0,     0,  1813,     0,     0,  1612,  1611,     0,  1474,
       0,     0,     0,     0,  1500,     0,     0,     0,     0,     0,
       0,     0,     0,  1305,     0,     0,     0,     0,     0,  1445,
       0,  1474,  1228,  1686,  1687,  1671,  1672,  1670,  1673,  1225,
       0,  1674,  1685,  1396,     0,     0,     0,     0,     0,     0,
    1582,  1583,  1584,  1585,  1593,  1586,  1587,  1588,  1595,  1600,
    1589,  1590,  1596,  1597,  1598,  1591,  1599,  1594,  1592,  1601,
       0,  1581,     0,  1604,  1602,  1605,  1603,     0,  1466,  1458,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1611,     0,     0,     0,  1611,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1407,     0,     0,     0,     0,     0,
    1611,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1363,     0,  2085,  2084,     0,     0,     0,   851,     0,
    1323,     0,  1322,  1544,     0,  2722,  2738,     0,  2515,  1461,
    1463,     0,  1230,  1229,  1231,  1242,  1235,  1240,  1233,  1237,
       0,  1289,  2185,  1243,     0,     0,  1271,  2737,  1620,  1272,
    1257,  1262,  1263,     0,  1260,  1261,     0,  1265,     0,  1264,
    1268,  1269,  1270,  1273,     0,     0,     0,     0,  1312,  1317,
    1493,  1214,  2086,     0,     0,   462,   465,   464,  1727,   463,
    1776,     0,  1045,     0,     0,    74,    76,  1952,  1949,  1948,
    1950,  1954,   112,  1959,  1951,     0,  1967,  2232,  2458,  2461,
     287,     0,   260,   259,   261,   284,     0,     0,  2639,     0,
    2620,     0,  2624,  2618,  2622,  2602,     0,     0,  2610,     0,
    2648,  2631,  2635,  2634,  2632,     0,  2633,  2638,  2616,  1610,
    2266,  2352,     0,  1613,  2570,  1742,  2827,  1994,  2472,  1995,
    1987,     0,  2007,     0,     0,     0,  1142,   692,     0,  1214,
     496,   495,   494,   493,     0,   511,   491,   499,    70,     0,
       0,  1983,     0,     0,     0,     0,     0,  1091,  1753,     0,
       0,  1733,  1533,  1979,  1973,     0,     0,     0,     0,     0,
    2666,  2591,     0,     0,     0,  2712,  2730,  2729,  2717,  1214,
    1632,  1215,  1215,  2082,  2531,     0,  2525,  2524,     0,     0,
       0,  2544,  2527,     0,     0,  2493,  2532,  2533,  2536,     0,
       0,     0,     0,     0,  2530,  2455,  2495,  2496,     0,  2501,
    2491,  2550,  2551,  2548,  2549,  2547,  2520,  1883,     0,  1914,
    1917,  1918,     0,     0,  1897,  1891,  1890,  1880,  1892,  1881,
    1901,  1900,  1899,  1853,  1852,  1654,  1655,  2410,  1653,  1645,
    1648,  1652,  1651,  1846,  1907,  1896,  1894,  1878,  1916,  1851,
    1850,  1895,  1893,  1832,  1833,  1834,     0,  1641,     0,  1912,
    1885,  1916,  1906,     0,  1916,  1916,  1898,  1872,  1874,  1058,
    1075,  1074,  1070,  1071,  1076,  1066,  1065,  1553,  1552,     0,
    1507,     0,  1509,  1506,  1505,  1504,     0,  1552,  2813,  2821,
    2825,     0,  1641,  2727,  2725,     0,     0,     0,   583,     0,
       0,  2753,   115,   575,  1776,  1776,     0,  2112,     0,     0,
       0,     0,     0,     0,     0,   183,   192,     0,     0,   396,
     397,  1776,   395,   438,   439,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,     0,   136,   445,  1776,  1776,
     392,   418,   419,   422,   423,   424,   425,   426,   388,     0,
     393,   818,     0,   953,   955,  2773,  2774,  2775,     0,     0,
    1104,  1163,  1155,  1162,  1159,  1174,  1172,  1161,   878,   877,
       0,  1175,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,   100,  1731,     0,
    1126,  1138,  1132,   127,   818,  1776,  1776,  1776,  1776,   394,
     427,   428,   431,   432,   433,   434,   437,   435,   436,     0,
    2605,     0,     0,  1904,     0,  2668,  2669,     0,  2665,   889,
       0,     0,     0,     0,     0,  1802,     0,  2096,  1812,  1535,
    1816,  1815,     0,  1392,     0,  1438,     0,  1440,  1441,  1442,
       0,     0,     0,     0,     0,  1393,     0,  1337,  1394,  1395,
       0,  1389,     0,  1390,     0,     0,     0,     0,     0,     0,
       0,  1444,     0,  1226,     0,     0,  1341,  1342,  1334,  1326,
       0,  1417,     0,     0,  1343,     0,     0,     0,     0,  1398,
       0,  1418,  1495,     0,  1497,  2086,     0,  1450,  1399,  1348,
       0,  1448,     0,  1349,  1419,  1420,  1421,  1401,  1402,     0,
    1423,     0,  1403,     0,     0,  1406,     0,     0,  1351,  1454,
    1452,     0,     0,     0,     0,  1456,  1353,     0,     0,     0,
    1352,     0,     0,     0,     0,     0,     0,     0,  1355,     0,
    1335,  1453,  1455,  1409,     0,     0,     0,     0,     0,  1364,
       0,  2731,  1543,  2739,  1544,     0,     0,  2733,  2723,  2728,
    2736,  1327,     0,     0,  2087,  1236,  1241,  1234,  1238,  2737,
       0,     0,     0,     0,  1255,  1254,     0,     0,     0,  2737,
    1620,  1258,     0,     0,  1434,  1435,  1490,     0,  1718,  1715,
    1728,  1777,     0,  2663,  1047,  1046,  1724,  1045,    77,     0,
    1953,  1946,  1968,  1941,     0,   279,   288,   281,   285,   286,
     282,  2681,     0,  2680,     0,     0,  2599,  2658,  2661,  2093,
       0,     0,     0,  2574,  2581,  2577,  2582,  2575,  2576,  2580,
    2583,  2584,  2571,  2578,  1614,  1643,     0,  1996,  1165,  1167,
    1168,  1166,  1174,     0,     0,  2559,  2560,  2558,  2557,   501,
       0,   510,     0,   522,     0,     0,     0,  1985,  1984,     0,
    1149,  1152,  1153,  1098,  1096,  1095,  1097,  1086,  1092,  1093,
     567,  1759,     0,     0,     0,  1765,  1746,  1756,     0,  1980,
    1976,     0,   257,  2592,     0,     0,     0,     0,     0,     0,
       0,  1209,  1535,  1704,  1206,  1194,  1643,  1633,  1193,  1216,
    1212,     0,   817,   816,   815,   813,     0,     0,     0,     0,
    2538,  2539,     0,     0,  2516,  2517,  2518,     0,  2521,  2498,
    2499,     0,  2500,     0,  1913,     0,  1857,     0,  1879,     0,
       0,     0,     0,  1848,     0,  1871,  1829,  1914,  1847,  1613,
    1906,  1844,  1845,  1073,     0,  1056,  1552,  1535,     0,     0,
    1527,  1554,     0,  1554,  1529,  1530,  1535,     0,  1535,  1532,
    1549,     0,     0,  2824,  1634,  2726,     0,  2801,     0,     0,
       0,   181,   587,     0,     0,   935,   186,   189,   187,     0,
     188,     0,     0,   447,   446,     0,  1904,   440,   140,   139,
     141,   142,  1668,  1669,  1665,  1666,  1664,  1667,   144,   143,
     138,   950,     0,     0,     0,  1904,   420,   399,   400,   403,
     404,   405,  1033,  1776,  1033,     0,  1776,  1776,  1033,  1776,
       0,     0,  1776,  1776,     0,     0,  1776,     0,     0,  1033,
       0,  1776,     0,  1020,     0,     0,  1776,  1776,  1776,  1776,
    1776,  1033,     0,     0,  1776,  1776,   486,  1776,     0,     0,
    1051,     0,     0,  1776,  1776,  1776,  1776,     0,     0,  1776,
    1776,     0,  1776,   967,  1019,   589,   616,   617,   932,   966,
     968,   980,   482,     0,   998,  1022,  1023,  1021,     0,     0,
       0,     0,   150,  2777,  1103,     0,     0,  1573,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,  1904,   429,  2601,     0,
       0,  1776,   389,   406,   407,   410,   411,   412,   413,   414,
     417,   415,   416,     0,  2672,  2674,     0,     0,   890,     0,
       0,     0,  1735,  1815,  1535,  1613,  2094,  1613,     0,  1814,
       0,     0,  1439,  1475,     0,  1501,     0,  1331,   775,   775,
     775,  1484,   760,  1488,  1479,   775,  1480,   775,  1482,     0,
       0,     0,  1291,  1306,     0,     0,     0,     0,     0,  1446,
    1443,     0,     0,     0,     0,  1469,     0,     0,     0,  1336,
       0,  1429,  1451,  1449,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1457,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     840,   846,   849,   850,   852,   844,     0,  1411,  1324,  1214,
    2740,  2742,  1185,     0,  2732,  2734,   926,  1462,     0,  1252,
    1248,     0,  1246,  1619,  1267,  1266,     0,     0,     0,  1256,
    1215,  1425,  1214,     0,  1491,  2088,  1716,   461,   633,  1714,
      75,  1944,     0,  1939,  1942,     0,     0,  2678,     0,  2689,
       0,     0,     0,     0,     0,     0,     0,     0,  2569,  1644,
    1786,     0,  1174,  1178,  2103,  2000,  2562,  2563,  2561,     0,
     502,   503,   505,  1215,   519,   497,     0,   489,   492,     0,
     501,     0,     0,  1088,  1094,  1199,     0,  1778,  1763,  1770,
    1764,     0,     0,     0,  1762,  2078,  2077,  2084,  2715,     0,
    1579,     0,     0,  2590,  2667,     0,     0,     0,  2718,  1613,
    1613,  1698,     0,     0,  1191,  1196,  1192,  1195,     0,  1213,
    1220,  1219,  2079,  2086,  2528,     0,     0,     0,     0,  2543,
    2537,  2534,  2535,     0,  2497,  2519,  2503,  2502,  2505,  2507,
    1678,  1679,  1677,  1675,  1676,  1915,  1641,  1867,  1866,  1656,
    1647,     0,  1650,  1649,  1840,  1859,  1861,  1916,  1072,     0,
    1079,  1077,     0,  2722,  1547,     0,  1531,  1528,  1555,     0,
    1554,  1554,  1535,     0,  1511,  1790,  1793,     0,  1510,  1606,
    1537,  1199,  2814,  2826,     0,     0,     0,   383,   382,     0,
     145,  2795,     0,     0,   671,   116,   473,   482,   588,   591,
     632,   631,   191,   190,   196,   197,  1682,  1683,  1680,  1681,
     453,   466,  1684,   467,   441,   137,   454,   455,   421,     0,
     401,  1034,   923,   583,  1002,     0,   672,   583,   874,   879,
     879,   583,     0,     0,  1143,     0,     0,  1737,     0,     0,
    1143,     0,     0,     0,  1776,     0,  1013,   962,     0,  1737,
       0,  1737,  1737,  1014,     0,     0,   963,  1776,     0,     0,
       0,     0,     0,  1737,  1143,     0,     0,     0,   484,     0,
    1143,   982,  1054,  1052,  1053,     0,  1143,  1143,     0,     0,
       0,     0,   622,   623,   621,     0,     0,     0,   614,   590,
     818,   964,   483,   965,   671,     0,  1048,   668,   674,  2089,
       0,     0,   160,     0,     0,   952,     0,   153,   151,   162,
       0,     0,  1107,     0,  1106,     0,  1576,     0,  1577,  1574,
    1575,   101,    88,    84,   105,   106,    86,    87,    91,    90,
      92,    93,    96,    97,    94,    89,    95,    85,   109,   111,
     110,    98,   107,   108,    83,   460,   459,   458,   457,   430,
       0,     0,     0,  1904,   408,  2673,  2671,  2670,     0,   916,
     918,   917,   904,   903,   117,   120,   123,     0,  1613,  1632,
    2097,  1806,     0,  1365,  1502,     0,     0,   776,  1476,   826,
    1486,     0,  1487,   762,   761,   777,  1478,  1481,  1485,  1483,
    1330,  1338,  1387,     0,  1304,  1388,     0,  1416,  1333,  1332,
       0,     0,     0,  1371,  1372,     0,  1467,     0,     0,  1345,
       0,  1347,     0,     0,  1431,  1400,  1422,  1374,  1404,     0,
    1350,  1325,     0,  1375,     0,  1380,  1378,     0,  1354,     0,
       0,  1361,     0,  1359,     0,  1360,     0,  1362,  1408,  1410,
       0,     0,   851,   837,   838,   839,     0,   841,   843,   845,
       0,     0,  1545,  2741,  1186,     0,     0,  1464,  1244,     0,
    1253,  1250,     0,  1247,  1216,  1436,  1426,     0,     0,   296,
     291,   299,   293,   295,   294,   300,   301,   302,   303,   297,
     292,   298,   290,   289,  2679,     0,  2598,  2603,  2660,  2659,
    2682,  2682,  2682,     0,  1615,     0,  1743,  1169,  1174,  1178,
       0,  1170,  2011,   506,     0,     0,     0,   526,     0,   524,
     500,     0,  1150,  1099,  1214,  1760,  1772,     0,  1780,     0,
       0,  1757,  1767,     0,     0,     0,  1766,   486,     0,   258,
       0,  2587,  2588,  2586,  1643,  1621,     0,     0,  1710,     0,
    1705,  1207,     0,  1218,  1217,     0,  2546,  2545,  2541,  2540,
    2542,  2522,     0,     0,  1858,  1646,  1641,  1854,     0,     0,
    2728,  1606,  1539,  1535,  1508,  1535,     0,     0,  1516,  1535,
    1512,  1514,     0,  1613,     0,  1571,  1214,  2081,  1635,  1638,
       0,  2802,   386,   384,   385,     0,     0,   206,   649,   650,
     648,   647,     0,   474,     0,     0,     0,   651,   652,   654,
     655,  2011,   481,   818,   592,   402,   673,   924,  1143,     0,
       0,     0,   879,   667,   583,   923,   888,   880,   583,   583,
    1000,  1029,  1030,     0,     0,   600,   597,     0,   609,   983,
     974,   984,   995,   997,     0,   599,   624,     0,     0,   612,
    1737,     0,  1011,     0,     0,   594,     0,     0,   643,   644,
     642,   618,   625,  1031,  1032,   595,   596,     0,     0,  1628,
    1630,  1638,   602,   601,  1689,  1688,   611,     0,   598,     0,
    1017,   990,     0,   640,   638,   635,   637,   636,   641,   639,
     613,   604,   603,   606,   605,   608,   607,   610,   626,   979,
       0,  1033,  1033,   999,     0,  2092,     0,  1050,  1001,     0,
     656,   669,   657,     0,     0,   630,   629,   627,   628,   161,
     149,     0,     0,   954,   956,     0,     0,   957,  2779,     0,
    2781,  1109,  1110,     0,     0,  1177,     0,     0,   102,   104,
       0,   391,   456,   409,  2675,     0,     0,     0,  1815,  1808,
    1657,     0,  1503,     0,     0,     0,     0,   820,   831,   829,
     823,     0,   827,   828,  1477,     0,     0,   778,  1489,   742,
     775,  1301,   760,  1295,  1297,  1293,     0,   743,  1296,   775,
       0,   826,  1300,  1292,     0,  1447,     0,     0,  1470,     0,
       0,     0,     0,     0,     0,     0,  1328,     0,  1427,     0,
       0,     0,     0,     0,     0,  1358,  1356,  1357,   835,  1413,
       0,   848,   842,   840,   847,     0,  1643,  2722,   927,  1249,
       0,  1437,  1945,  1969,     0,     0,  2687,  2687,  2687,  1785,
    1784,     0,  1783,  1787,  1171,  1179,  2013,  2012,     0,   504,
     507,     0,   499,     0,   523,     0,   490,   568,     0,     0,
       0,  1781,  1769,  2719,  1758,  1761,  2086,  1534,  1580,  2589,
    1198,     0,  1616,  1709,  1706,     0,  1699,  1701,  1703,     0,
    2080,  2504,  2506,  1860,  1078,  1080,  1540,  1538,  1548,     0,
    1504,  1535,  1535,     0,  1504,     0,     0,  1792,  1632,  1794,
    1536,  1568,  1550,     0,  1639,  1640,  1637,     0,   217,  1214,
       0,     0,   207,   209,   210,     0,     0,   471,   468,   671,
     470,   570,   593,   985,     0,   583,   875,   876,   888,   925,
       0,   888,   888,     0,     0,   973,  1004,  1129,     0,   978,
     814,   619,     0,   969,  1012,  1045,     0,   620,  1006,   971,
       0,  1631,   485,   970,   992,   976,  1967,  1003,  1049,   856,
     756,   705,   696,   775,   699,   698,   775,   710,   760,   758,
     728,   760,   760,   735,   734,   752,   738,   718,   826,   826,
     717,   755,   826,   739,   737,   741,     0,   743,   760,   748,
     736,   740,   757,   733,   730,   754,   775,   775,   775,   714,
     753,   826,     0,   746,   775,   675,   779,   716,   826,   833,
       0,     0,   775,   777,  2091,   147,   152,   163,   164,   945,
    2778,     0,  2776,     0,  1115,     0,  1173,  1578,    99,     0,
       0,     0,     0,     0,     0,  1803,  1366,   773,   771,   774,
     772,   822,   821,   825,     0,   824,   833,     0,     0,  1303,
    1298,   744,  1302,  1294,  1299,  1391,  1369,  1370,     0,  1468,
    1459,  1397,     0,  1346,  1428,     0,     0,  1405,  1376,  1379,
    1377,  1382,  1383,     0,  1412,     0,  1206,  1206,   645,  2735,
    1251,     0,  1943,  2690,     0,     0,  2686,  2684,     0,  2685,
    2683,  2651,     0,  2596,  2597,  2595,  2579,     0,     0,     0,
    1214,   512,     0,   529,   528,   525,  1643,  1771,  1773,  1779,
    1768,     0,  1617,  1632,   807,  1702,     0,  1208,     0,  1517,
       0,  1521,  1526,  1522,     0,  1513,     0,  1657,  1572,     0,
    1643,  1638,     0,   220,   218,   219,     0,   213,   215,   210,
    2789,     0,  2796,     0,     0,  2794,   475,  2719,   587,   653,
     571,     0,   987,     0,     0,     0,     0,     0,     0,  1016,
       0,     0,   975,   996,  1018,  1010,  1009,     0,     0,  1143,
    1629,   991,   993,  1091,     0,     0,   860,   704,   697,   715,
     713,   764,   759,     0,   764,   764,   724,   742,   719,     0,
     826,   732,   723,   744,   747,   749,   751,   764,     0,   826,
     712,   711,   721,   708,   764,   787,     0,     0,     0,     0,
     783,     0,   854,     0,   790,     0,   676,   780,   782,     0,
       0,     0,   745,   826,   701,   834,   833,   703,   826,   833,
     764,   764,     0,   154,   958,   323,  2780,  1189,     0,  2785,
       0,  1116,  1112,  1113,  1108,   103,   135,     0,  1638,   921,
       0,     0,  2410,  1658,  1809,   832,   830,     0,  1471,  1638,
       0,  1430,  1432,   836,     0,  1546,   646,     0,  2657,  2656,
    2655,  2652,     0,     0,     0,     0,     0,     0,  2688,  2692,
    1782,     0,     0,     0,   520,     0,     0,   554,   569,  1625,
    1638,     0,  1643,     0,  1707,  1700,  1541,     0,     0,     0,
       0,     0,  1791,  1560,  1561,     0,     0,  1566,  1570,  1551,
    1636,  2793,  2803,   217,     0,     0,   158,     0,   208,   814,
     211,   472,   482,     0,   477,     0,     0,   986,   670,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1015,
    2056,  1048,   486,  1007,   972,     0,   977,   615,     0,   859,
       0,   864,   768,   769,   770,   725,   765,   767,     0,   727,
     695,   720,   750,   726,     0,   722,   709,   793,   792,  1221,
     785,   800,   680,     0,     0,   791,   677,   781,   789,   784,
       0,   700,   702,   706,   707,   693,   694,  2090,     0,   156,
     349,     0,   335,   321,     0,     0,     0,   325,   165,   168,
     166,     0,   167,   173,     0,   174,   175,   176,   177,   178,
     169,   347,   348,   172,   170,   171,     0,  2106,     0,  2107,
    2783,     0,     0,  2782,  1111,     0,  1118,   891,     0,   920,
       0,   893,   895,  1659,     0,  1214,  1804,   763,     0,  1473,
    1344,  1414,  1970,  2653,  2693,  2696,  2694,  2695,  1661,     0,
    2697,  2691,     0,  1532,  1215,     0,   513,     0,   516,   518,
     532,     0,  1776,  1776,     0,     0,  1776,  1776,  1776,  1776,
     547,   555,   557,     0,  1626,  1627,     0,  1622,  1624,  1618,
    1690,   808,  2014,  2722,  1518,     0,  1523,     0,  1515,  1556,
    1556,  1567,   184,   214,     0,     0,   150,   159,  2797,   798,
    2011,     0,  2715,   989,     0,     0,     0,   658,     0,     0,
    2058,  2057,  1005,   981,  1048,     0,   857,     0,   861,   862,
     863,     0,   855,   766,     0,   928,     0,     0,   799,  1221,
     788,     0,   797,   796,   794,   795,   155,     0,   148,     0,
       0,   334,   337,     0,     0,   340,   330,   329,   331,     0,
     324,   323,   323,   377,   328,   374,   373,   366,  2719,     0,
       0,     0,  1117,  1122,     0,  1119,  1121,     0,  1776,   118,
     892,   912,   911,   897,     0,  1638,     0,     0,   121,   894,
     914,   901,   124,   896,   913,   899,  1660,  1810,  1638,  1663,
    1662,  1788,  1796,     0,  2001,     0,   521,   514,     0,     0,
     530,     0,     0,  1776,  1776,     0,     0,     0,     0,     0,
     527,   556,  1776,  1638,     0,  1197,     0,  2022,  1542,     0,
       0,     0,  1564,  1562,  2804,   216,  1214,   162,     0,   469,
     479,   478,   988,     0,   664,   891,   660,   662,  1008,     0,
     858,     0,     0,   826,     0,   826,  1222,     0,   786,  1214,
     157,   350,   361,   364,   356,   336,     0,     0,     0,   326,
     323,     0,   310,   308,   309,   315,   316,   317,   318,   319,
     320,   311,   314,   312,   313,   323,     0,   225,     0,     0,
    2784,     0,  2786,     0,  1114,     0,   906,     0,  1024,   898,
       0,   919,   922,     0,  1024,   902,  1024,   900,  1472,     0,
       0,   807,   508,   520,   517,   540,   533,   536,     0,   566,
     560,     0,     0,   562,   563,   561,   558,   551,     0,   549,
       0,  1623,  1691,     0,     0,     0,     0,  2015,  2017,     0,
    1708,  1520,  1525,     0,  1557,     0,     0,     0,   194,   193,
     185,     0,   323,  2790,     0,  2798,  2719,   666,   891,   659,
     893,   895,     0,   870,     0,   869,     0,   866,   865,   729,
     929,   731,  1223,     0,     0,     0,   323,   357,     0,   332,
       0,     0,     0,     0,   223,   380,     0,   221,   368,   368,
    2787,  2788,  1120,   905,   119,  1026,  1025,   910,   909,   907,
     908,   915,   122,   125,  1795,  1797,  2002,   515,   540,     0,
     538,     0,   534,   531,   535,   564,   565,     0,   548,     0,
     559,     0,     0,     0,     0,     0,  2016,     0,     0,  2023,
    2025,  1559,  1558,  1573,     0,   195,  2805,     0,   164,   184,
     480,   665,   661,   663,   994,   872,   873,   871,     0,     0,
     681,   358,   364,   354,   362,   323,     0,     0,   322,   341,
     376,   224,     0,   378,     0,   323,     0,   367,   369,   371,
    1028,  1027,  2028,   537,     0,   545,   541,   543,   546,   554,
     553,   550,  1214,  2020,  2021,     0,  2018,     0,     0,  2024,
       0,     0,     0,   146,  2799,     0,     0,   683,   682,   684,
       0,   355,     0,     0,   353,   333,   338,   323,     0,   323,
     236,   235,     0,   227,   304,   375,     0,   226,     0,  2014,
     539,     0,     0,   552,     0,     0,  1694,  1696,  2019,  2027,
    2026,  1565,  1563,  2791,   323,   868,   867,     0,   688,   678,
     685,   687,   359,     0,   323,     0,   323,     0,   323,     0,
       0,     0,     0,     0,   222,     0,  2022,   544,   542,  1215,
    1692,  1214,   323,  2800,   690,   689,   686,     0,   351,   323,
     339,   344,   381,     0,   230,   305,   306,     0,   233,     0,
    2030,  1697,  1695,  2792,   323,   323,   340,   343,   379,     0,
       0,   228,   229,   241,   240,   232,     0,  2029,     0,  2034,
     323,   323,   345,   249,   247,   323,   237,   245,   239,     0,
     246,   307,   234,     0,     0,  2041,     0,   231,   248,  2032,
    2033,  2031,  2036,     0,     0,  2038,  2039,     0,  2003,   238,
    2040,  2035,     0,  2042,  2044,     0,  2037,     0,  1214,  2043,
       0,  1215,  2045
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4104, -4104, -4104, -4104, -4104,   135, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104,  1948, -4104, -4104, -4104, -4104, -4104,
    1625, -4104,   510, -2403,  -504,  3323, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104,   792,  1739,  3276,
   -4104,   408, -4104,    54, -4104, -4104, -4104, -3006,   -75,  -275,
   -4104, -4104,   791,    23,  3265,  -273, -4103, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,   418,   415, -4104, -4104,
     246, -4104, -4104, -1565, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104,  -445,  -407,  1776, -4104, -4104, -4104,  4284, -4104,
    3735, -4104, -1824,  2398, -4104, -4104, -4104, -4104, -4104,  2469,
   -1771, -4104, -4104, -4104,  1502, -4104, -4104, -4104,  -447,   331,
   -4104,   334, -4104,   337, -4104,   339, -4104,   340,   343,   344,
     345, -4104,   347, -4104, -4104,  -406, -4104, -4104, -4104, -4104,
     348, -4104, -4104, -4104, -4104, -4104, -4104, -4104,  -269, -4104,
   -4104,   -65, -4104, -4104,  -253,   355, -4104,  -188,   358, -4104,
     359, -4104,   -83, -4104,   -79, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104,  3262, -4104, -4104,
   -4104, -2143, -4104, -4104, -2247,  2786, -4104, -1835, -4104, -4104,
   -1923, -4104, -4104, -1827,  -673, -4104, -4104,   525,   444, -4104,
   -1408, -2027, -2017, -4104, -4104, -4104, -2095, -2084,  -789,  2535,
   -1219, -2345, -4104, -4104, -4104, -4104,   103, -4104, -4104,   282,
    1733,  2258, -4104, -2550, -4104, -4104,   919, -4104, -4104,  1515,
     755,  1514, -4104,  1087,  3012, -1285, -4104, -4104, -4104, -4104,
   -4104, -4104,    14,   333,   -86, -4104, -3837,   765, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -2802, -4104, -4104, -4104,
    -293, -4104, -4104,  -187, -4104, -4104,  -248, -4104,   157, -2376,
   -4104, -4104, -4104, -4104,  2770, -1405, -4104,  3764, -4104,  -501,
   -4104,   481,  1765, -2722, -2016, -4104,  -943,  -941, -2972, -4104,
   -4104, -4104, -2178,  1031,  1318, -4104,   715,  1762, -2468, -4104,
   -4104, -4104, -4104, -4104,  1320, -4104, -4104,   477, -4104,   471,
   -4104, -4104, -4104, -4104, -4104,  -290, -4104,    -8, -3020, -4104,
   -4104, -4104, -3008,  1229,   664, -4104, -4104, -4104, -1406, -2981,
    -431, -4104,   288, -2567, -2526,   632, -4104, -4104,   429, -3752,
   -4104,  -590, -2157, -2469,   -52, -4104, -4104,   441, -3442,  1877,
   -4104, -4104, -4104, -3436, -3478,  1633, -4104, -4104,  1184, -4104,
   -1352,  1185, -4104, -4104, -4104,  1191, -4104,    24, -4104, -4104,
   -4104, -4104, -3297, -4104, -4104, -1571, -2749, -4104, -4104,  4419,
    4420, -1586, -2395, -4071,   -88,   -87, -4104, -4104, -4104,  2234,
   -1633,    95,    84,    89,  1732,  -364,   243,  1037, -1621, -4104,
     306, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,  1801,  -761,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -2436, -2919, -4104,
   -4104,  1364, -4104, -4104, -4104, -2651, -2089, -2086, -2437,  3425,
   -4104, -4104, -4104, -4104,  3373, -2285, -3096, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104,  2928,  -591, -4104, -4104,  1939, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,   508,  2014,
   -4104, -4104, -4104, -4104, -4104,  2327, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104,     2, -4104, -4104, -4104, -4104, -4104,
     751,  2840, -4104, -4104, -4104, -4104,    -9, -4104, -4104, -4104,
   -4104,  2536, -4104, -4104, -4104, -4104,  2864, -4104, -4104, -4104,
   -4104, -4104, -4104,  1615, -4104,  2050, -4104, -1555, -4104, -4104,
    1176, -1035,  2009,  -611,  2143,   463, -4104,  3851, -4104, -4104,
   -4104, -1740, -2529, -4104,  3533,  -764, -2716,  2523,  -573, -1932,
    1219,   176,  1607,  1503,  4173, -4104, -1178, -1122, -4104, -4104,
    -668, -4104, -4104, -4104, -4104, -4104,  2242,  2247,  -628, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
    1658, -4104, -4104, -4104, -4104, -1263, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104,  1487, -4104, -2132, -4104, -4104,  -446, -4104,
    3311, -4104, -4104, -4104, -2399, -1982,  1950,  1129, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104,  1959, -4104, -1613, -4104, -2846,
   -4104, -4104, -4104, -4104, -4104,  2168, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -1624, -4104, -2032,   247, -4104,   428, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,  -107,   986,   -85, -3256,
   -1125,  1882, -4104, -4104, -1326,  3365, -2351, -4104, -4104, -4104,
    2161, -4104, -4104, -4104, -4104, -4104,   788, -3035,  2977, -4104,
   -4104, -3302,  -961, -2346,  -934, -4104, -1424,  1571,   617, -4104,
   -1973, -1128, -1443, -2987, -2497, -4104,  1439, -4104, -4104, -4104,
   -4104,  -205, -4104, -4104, -4104,   633,  2053, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104,  -510,  -925, -4104,
   -4104,  2317,  -492, -4104,  3489, -4104, -4104,  3491, -4104, -4104,
   -4104, -4104,  3166,  3133,  2119, -4104, -4104, -2378, -4104, -4104,
    2081, -4104,   898,  -944,   567,  1218, -4104, -4104,  1220, -3286,
   -4104, -4104,  3493, -4104, -4104, -4104,  1167, -4104,    61,  3921,
    3497, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,  2892,
   -1089,  3846, -4104, -4104, -4104, -4104, -4104, -4104,  2512, -4104,
   -4104, -4104, -4104, -4104, -4104,  3075,  3945,  -597, -1323, -4104,
    -750,  2515,  2038,  -899, -4104, -4104, -4104, -4104,  3950, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,  2697,
     821, -4104, -4104, -4104, -4104,  3154, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104,  1258,  -128, -4104,
      56,  -161, -4104,   -33, -4104, -4104, -4104, -4104, -4104,  -235,
   -4104, -4104,  -239, -4104, -1027,  3776, -1429,   581, -1304, -2592,
   -4104,  1247,  3139, -3341,  -698, -1198, -1209, -2810,    71, -4104,
   -4104,  3460,    57,   289,  -203,    -6, -2883,   -54,  -626,  -614,
    -741, -4104, -2518, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104,  2073, -4104, -4104, -4104,  1223, -4104,  3969, -4104,  2774,
    1224,  3971, -1399,  2594,  2087,  2090, -4104, -4104,  2097, -1983,
   -4104, -4104,   189, -4104,  2669, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104,  3742,  -476,  -459,  3168,  3985,  3656, -4104,  3230,
   -4104, -4104, -4104, -4104, -4104,   537, -4104,   876,  2125, -1267,
   -2367, -4104, -4104,  2959,   973, -4104,  1743,  -144,  -467, -4104,
   -4104,   534, -4104, -4104,   316,  3994,  3661, -4104, -4104, -4104,
   -4104, -4104, -2808,  -927, -4104, -3520, -2867, -1754, -4104, -4104,
   -2225, -3117, -4104, -4104, -1072, -4104, -4104, -4104, -4104, -2081,
   -4104, -4104, -4104,   -24,  3963,  3977,  3978, -4104,  -779, -4104,
   -4104, -4104, -4104, -4104, -4104, -4104,  3552, -4104, -4104, -4104,
   -4104,  3579, -4104, -4104, -4104, -4104, -4104,  3592, -4104, -4104,
   -4104, -4104, -4104,  1818, -4104, -4104, -4104, -4104, -4104, -4104,
   -4104, -4104, -4104
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    59,   625,  1538,    60,    61,    62,    63,    64,  1377,
      65,   840,  1295,  1845,  1846,    66,   565,    67,  1605,  2165,
    2166,  3517,  3518,  2167,   663,   664,    68,  2542,  3525,  4458,
    3526,  4464,  3527,  4466,  1623,   628,   536,  2105,  2106,  1542,
    3376,  3095,  4003,  3099,  4159,  4308,  4266,  2123,  3507,  4004,
    4005,  4168,   560,  2540,  1577,  4394,  2085,  4510,  2086,    69,
     661,  1087,  1602,  1603,  3681,  3682,  3914,  3683,  3906,  3907,
    3908,  3909,  4625,  4430,  4547,  4626,  4711,  4749,  4755,  4756,
    4672,  4765,  4766,  4767,  4753,   917,  4768,    70,   588,   589,
     919,  1409,  1860,  1410,    71,    72,   559,  1321,  1322,  1323,
    1324,  2380,  1861,  2375,  2376,  3272,  4673,  4751,  4431,  4432,
    4315,  4433,  4171,  4434,  4319,  4435,  4174,  4436,  4437,  4438,
    4439,  4617,  4440,  4314,  4665,  4427,  4428,  4667,  4731,  4747,
    4441,  4181,  4309,  4534,  4182,  4310,  4612,  4423,  4613,  4660,
    4727,  4424,  4535,  4663,  4538,  4442,  4448,  4627,  4443,  4449,
    4444,  4186,  4326,  4447,  4324,  4446,  4669,  4622,  2979,  3375,
     648,   649,   678,  2193,   650,  1104,  1057,  1579,  2118,  2119,
    2577,  2578,  2692,  2693,  2694,  2110,  2111,  2112,  2179,  2180,
    2181,  2092,  2093,  2094,  1583,  2089,  2090,   651,  1058,  1068,
    2113,  2114,  2115,  2698,  2183,  2184,  2185,  2186,  2116,  1838,
    2117,  3000,  2985,  3918,  3917,  2986,  3690,  4272,  4516,  3391,
    3392,  3082,  3457,  2136,    73,   577,   897,  1374,  2424,  1375,
    2426,  2859,  2860,  2861,  1910,  1911,  3871,  1915,  2423,  4054,
    4473,  4227,  4228,  2863,  4226,  2867,  3298,  3299,  3623,  3873,
    4057,  4478,  4369,  4573,  4476,  4569,  4477,  4571,  4682,  4636,
    4637,  4380,  4488,  4489,  4577,  4639,  4240,  4241,  4242,  2445,
    2875,  3876,  3921,  2173,  1569,  1570,   629,   630,   631,  3405,
      74,  2987,  2634,  2988,  2989,  3480,  2636,  2637,  2827,  1467,
    3470,  3441,  3846,  3382,  3386,  3387,  3388,  3389,  3390,  4405,
    4520,  4521,  4518,  3490,  3403,  3015,  3016,  3087,  3493,  3775,
    4301,  3985,  4659,  4699,  4700,  4701,    75,   894,  4089,  3953,
    3968,  3777,  3778,  3779,  3780,  3781,  3782,  3783,  3172,  3173,
    4125,  4126,  4127,  3167,  3168,  3548,  3986,  3987,  3988,  4090,
    4140,  3541,  1433,  1434,  4064,  1445,  1446,  2473,  1956,  2474,
    1573,  3542,  3543,  3544,  3997,  3231,  3843,  3237,  3238,  3239,
    2790,  2791,  2792,  2793,  2794,  2318,  3989,  3492,  3946,  4118,
    4121,  4292,  4527,  3017,  3404,  3018,  3408,   999,   537,  3019,
    3020,  2199,  2200,  4339,  4348,  4352,  4340,  4353,  4349,  4341,
    4342,  4343,  4355,  4351,  3152,  4017,  4018,  3396,  3406,  3247,
    4294,    76,   130,  2121,  1049,  1060,  1056,  1079,   656,  1589,
    2124,  2652,  3789,   638,  2638,  3939,  3707,  3943,  2639,  3420,
    2640,  3922,  4097,  2641,  3724,  3941,  4115,  3421,  3422,  2642,
    2643,  2644,  3931,  3938,  4284,  4554,  4555,  4556,  3021,  1356,
     653,   654,  1072,  1073,  1074,  2366,  3488,  3065,    77,  2044,
    2039,    78,  1011,  1012,  1013,  1513,  1514,  2042,  2043,  2515,
    2951,    79,   666,  1609,  1386,  1926,    80,   906,  2437,  2438,
    2439,  2873,    81,  1080,  1593,  1594,  2130,  3104,  3513,  3794,
    4014,  4196,  4010,  4334,  4335,    82,   668,  1093,    83,   523,
    1617,  1618,  1619,  2170,    84,  1368,   137,    85,   905,  1380,
    1382,  1383,    86,   660,  1081,  1082,  1083,  1084,  2132,    87,
    1901,  2408,  2409,  2410,  2411,  1599,  2656,  1600,  1601,  2141,
    3291,    88,    89,   622,  2326,   594,   929,   595,   596,  1950,
    2464,  3847,   940,   941,   942,  2904,  1423,  1424,  1425,  1907,
    2909,  4298,  1151,  1147,   803,   804,   805,   806,  1241,  1242,
    3990,   807,  1251,  1804,  3184,  3563,  1663,  1664,   808,   809,
     810,   811,   812,   813,  1831,  3203,  3204,  3578,  2353,  2354,
    2355,   814,  2240,  3190,  2253,   815,  1234,  1789,  1719,  3570,
    3196,  3828,  4028,  1648,  2216,  2739,  3175,  2823,  2320,  1173,
    1174,  1132,  2223,  1654,  2050,  2051,  2052,  2053,  2054,  3665,
    3666,  4067,  3890,  4069,  3894,  2525,  2526,  1931,  1932,  2055,
    2056,  2952,  3888,  4253,  2321,  2322,  2323,  3596,  2953,  3353,
    2970,  2971,  3900,  2516,  2057,  2959,  4392,  4076,  4077,  4507,
    4506,  4078,  3898,  3899,  3670,  3671,  3107,  3108,  3109,  2889,
    1710,  1711,  1717,  1351,  1352,  1649,  2405,  2847,  3883,  4061,
    2344,  3642,  4059,  4247,  2647,  3449,  3450,  2466,  2467,  2974,
    3368,  3676,  1470,  3848,  2849,  2009,  2939,  2940,  3805,  4220,
    4754,  2795,  2935,  3001,  1681,  1682,  3456,  4385,  4581,  4685,
    4686,  4687,  3328,  3329,  3646,  3647,  2468,  2901,  3330,  3884,
    4252,    90,   541,    91,  1843,  2826,  1292,  2372,  1091,  1389,
    1635,  1636,   827,   555,    92,   566,  2406,    93,   584,  1929,
     884,   909,  1390,  1391,  2446,  2876,  2883,  2447,  2888,  3633,
    2878,  3305,  3306,  2361,  2362,  2879,  3308,  3630,  3611,  3612,
    3286,  3868,    94,   610,  3363,  2965,  2966,  4361,  4362,   910,
      95,   540,  1119,  2715,  4024,  1641,  2204,  4206,  1120,  1121,
    2207,   687,   688,    96,  1016,   606,  1493,  1494,  1495,  2027,
      97,   598,  1000,  2936,  3346,  2003,   901,  1287,  1474,  1003,
    1475,  1989,  2496,  1456,    98,  1045,  1044,  1564,    99,   634,
    1565,   100,   841,  1315,  1856,  2833,  2834,  3257,  1316,  1317,
    2373,  3852,   101,   585,   914,   915,  1394,  2450,   102,   579,
     902,  1921,   103,   569,   889,  1360,  1900,   104,   105,   106,
     891,  3292,  4471,  4632,   573,  1903,  1364,  3691,  4387,  4497,
    4498,  4500,  4589,  4590,  4679,  4759,  4781,  4775,  4784,  4785,
    4788,  4793,  4794,   817,  1025,  1026,   818,  4109,   819,   820,
     821,  2884,  2885,  3369,   822,  2886,   823,  3088,  1092,  1638,
     563,   515,   645,  1027,  2855,   825,  4188,  1052,  1289,  1111,
    1112,   517,   518,   107,   597,   957,  1450,  1440,  1449,  1976,
    2490,  1980,  2492,  2493,  3342,  2927,  3343,  2928,  1005,  1972,
    1977,  2929,   960,  1965,  1966,  1967,  1968,  2920,  1962,  1986,
     108,   892,   522,  1366,  1367,  2417,   109,   609,   110,  1353,
    1893,  1894,  2402,  2846,  2403,   111,   923,   924,   112,   869,
    1627,  2386,  1106,  1055,  1107,  1879,   872,  1327,   873,   874,
    1342,  1336,  1345,  1339,  4042,  3860,  3861,  2390,  1291,  1113,
    1941,  2197,  3148,  1114,  1870,  2382,  2383,  3606,  3863,  3276,
    4048,  4049,   113,   138,   525,   671,  1099,  1417,   114,   115,
     116,   117,  1420,  1533,  2460,  1534,  2327,  1535,  1536,  2064,
    1948,  1785,  1786,  3245,  1231,  1232,  2330,  2799,  2800,   943,
    1038,  1552,  1544,   131,   132,   133,   134,  1077,  1078,  2653,
    3101,  3509,  3792,  3793,  4009,  4193,  1546,  4085,  4597,  4722,
    1547,  1548,  3377,  4087,  4398,  4599,  4694,  1549,  2976,  3678,
    4262,  4512,   118,  1028,   619,  1531,  1526,  1528,  2060,  2533,
     119,   120,   121
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     516,  1002,  1421,   895,  1102,  1435,  1438,   955,   998,  1559,
    1034,   557,  1773,   556,  1053,  1863,  1451,   564,  1566,  2469,
    2470,   575,  1680,  1772,  2205,   673,  1054,   578,   583,   514,
    2140,  2328,  2645,  1643,   590,  2646,  1501,   593,  1471,  1904,
    2011,  1175,   590,  1724,  2137,  2010,  1286,  2201,  2202,   611,
    1978,   828,   829,   830,  1110,   832,  1862,   834,  3002,  2848,
     836,   140,   838,  1471,  1127,  1795,  3058,  1839,  2882,  2740,
    1747,  1465,  3435,  1803,   647,  2991,  3002,  3002,  3669,  1875,
    3316,  2747,  2829,  3242,   870,  3131,  3352,  1689,  1913,  3503,
    2374,  1522,  2580,   636,   562,   816,  1290,  1008,  2699,  1502,
    1015,   871,  2581,  3496,  2805,  2635,  1571,  2748,  1572,  2700,
     657,  2950,  2452,  3880,  3014,   870,  3358,   639,  2955,   516,
    2906,   516,   646,   652,  3530,  3824,  3436,  2964,  3597,  2568,
    1805,  1806,   925,  4041,  1809,  1810,  1811,  1812,  1269,  1814,
    1815,  1817,  1819,  1820,  1821,  1822,  1823,  3023,   641,  3721,
     643,  3027,  3511,  1236,  1237,  1595,  1090,  2018,  2946,  1094,
    4012,  3062,  3042,  1381,  2073,  3174,  2696,  1227,  1228,  1229,
     635,  2095,   670,  3233,  3053,  3561,  2697,  2031,  1611,  1270,
    1115,  1116,  1117,  1908,  2108,  2034,  2035,  3002,  3002,  1349,
     570,  3995,  1236,  1237,  3547,  1343,  3963,  2108,  1236,  1237,
     870,  2315,  3397,  3169,  3170,   603,  1568,   600,  1568,  3176,
    2465,  3178,  3537,  3413,  3372,  4337,  2182,  3146,   574,  1919,
    1349,  1236,  1237,  1236,  1237,   582,  3538,  2717,  3006,  3007,
    2872,  4697,  2937,  1568,  1236,  1237,  -934,  2364,  -572,  1476,
    3539,  4411,  2801,  2831,  3537,  1236,  1237,  1021,  2221,  1503,
    2649,   964,   945,  4536,  4572,  4536,  2434,  2687,  3538,  4274,
    1545,  1553, -2724,  -573,  2108,  2194,  2557,  3394,  3934,  1236,
    1237,  3409,  3539,  1236,  1237,   887,  2576, -2654,   899,  1539,
    3812, -2648, -2093,   964,   945,  1516,  1236,  1237,  1095,  3234,
    3574,  4509,  3399,  1236,  1237,  2501,  2480,  4606,  4657,  1612,
    1592,  3616,  1009,  1613,  1362, -2492,  3072,  1540,   911,   571,
     877,  3326,  3956,  3961,  1614,  2982,  3962,   881,  3338,   964,
     945,  1529,  3373,  1021,  3605,   620,   658,  1959,  1963,  2087,
    1646, -1609,  3901,  3093,  4519,  3972,  1646,  1070,  4026,  3137,
    3138,  -476,  3994,  3878,  2796,  2125,  3304,  1293,  3674,  2462,
     122,  2378,  1236,  1237,   684,  1960,  1469,   870,   592,   139,
    2097,   273,  2040,   275,  3159,  3399,  3161,  1511,   567,  4359,
     520, -2724,   520,  2902,   521,  3102,   521,  1155,  1472,  3350,
    1236,  1237,  1236,  1237,  1236,  1237,  1236,  1237,  1236,  1237,
    1584,  1585,  4338,  4587,  1916,  3091,  1482,  4091,  2091,  2463,
    2788,  2068,  2977,  2169,   882,  2188,   139,  1606,  4244,  4245,
    4712,  2091,  3616,   685,  1076,  2307,  3854,  1515,  1236,  1237,
     519, -2572,   912,  1520,  1521,  2978,  2789,  4588,  1022,  1023,
    2069,  1473,  4713,  2530,  3010,  4246,  1629,  3103,   667,  1917,
    1385,  3351,  3366,  2041,  1615,  3092,  3144,  4601,  4360,  1512,
    2292,  1236,  1237,  2316,   659,  1673, -2573,  2379,  3854,  1376,
    1688,  2903,  2126,  1647,  3675,  2061,  1543,  1551,  1541,  1669,
    1156,   124,   568,  3776,  1175,   883,  2109,   677,  2091, -2492,
    2900,  1071,  3094,  2088,  1236,  1237,  1496,  4029,  3073,  2109,
    1340,  2963, -1609,  1835,  3233,  3400,   621,  2058,  1973,   913,
    2435,  1010,  1964,  3311,  1022,  1023,   868,  1363,  2925,  3660,
   -2772,   880,  4395,  3664,   662,  1961,  4658,  1674,  4152,  1238,
    3617,  4154,  1239,  1530,  4131,   646,  1631,   652,  3321,  3322,
    3323,  3214,  4607,  4135, -2572,  2061,  1836,   868,  1236,  1237,
    4060,  1558,  1517,  1616,   652,  1675,   686,  3327,  3324,  3325,
    2580,  4509,   900,  2481,   646,   875,  2109,  4151,  2972,   646,
    2581,   885,  4153, -2648,  1238,  2364,   879,  1239,   888, -2573,
    1236,  1237,  4522,  2487,   903,  2013,   665,  1800,  2016,  2502,
    1419,  4050,  2019,  1610,  2022,   646,  4568,  1238,  3627,  1238,
    1239,   956,  1239,  3002,  1096,  3397,  3575,  1871,  2699,  4080,
    1238,  1017,  2063,  1239,  1236,  1237,  3855,  3706,  3385,  2700,
    3234,  1238,  2037,  2038,  1239,  1676,  1839,  3235, -1569,  2635,
    1037,  1864,   868,  3714,  3715,   886,  1571,  1808,  1572, -1609,
    2899,  3617,  1863,  3897,   646,  1238,  1059,  3718,  1239,  1238,
    4071,  2650,  1239,  2365,  1829,  3002,  4515,  4269,  3855,   516,
    3672,  1607,  1238,  3697,   636,  1239,  1088, -1569,   665,  1238,
     636,   665,  1239,   636,  3489,  1018,  2696,  1103,  1059,   878,
     646,  3692,  1939,  1862,   646,  2832,  2697,  3374,  1075,  2436,
    1571,  1122,  1572,  2168,  1540,  2095,  2938,  3112,  1608,  1657,
    1658,  2345,  3117,   604,  1677,   601,  1958,  1437,  1344,  1477,
    3125,  3126,  2348,  1506,  4412,  2351,  3133,   993,   572,  2509,
    3856,  2579,   669,  3063,  3401,  1712,  4199,  2222,  1238,  3243,
    1110,  1239,  4422,  1725,  4611,  1727,   927,  4209,  2907,  3004,
    3849,  1085,  3158,  1176,  -934,  2342,  -572,  1740,  1741,  1742,
    3008,  3959,  4698, -2654,   839,  1746,  1238,  3964,  1238,  1239,
    1238,  1239,  1238,  1239,  1238,  1239,  2033,  1239,  4248,  1920,
    4347,  -573,  1909,  3139,   893,  1236,  1237,  3637,   602,  2073,
    1024,  4066,  2182,  1240,  1608, -2654,  1236,  1237,  2071,   868,
    1285,  3540,  1842,  3064,  1238,  2695,  2421,  1239,  1053,  3933,
    2096,  1076,  1837,  3512,  1233,  2331,  1235,  3522,  1019,  3236,
    1940,  4013,  3547,  3147,  1236,  1237,  1853,  3529,  4450,  3166,
    2238,  1350,  1240,  3540,  3009,  3891,  3892,  1238,  1240,  3339,
    1239,  1278,   516,  1280,  1281,  1059,   516,   646,   646, -1609,
     516,   646,   591, -1609,  2195,  2187,  1325,  2317,  3992,  -476,
    1608,  1240,  1350,  1240,  2196,  1541,  1215,  1673,  4062,  3813,
    1238,  1279,  1053,  1239,  1240,  1283,  1483,  2853,  1906,  1288,
    2239,  1780,  1781,  1608,  2017,  1240,  3395,  4358,  1236,  1237,
    1236,  1237,  2308,  1354,  2097,  3857,  3166,  1927,  1236,  1237,
    1236,  1237,  1608,  1780,  2257, -2572,   636, -2772,  3254,  1240,
    1933,  3858,  2954,  1240,  3402,  1436,  3523,  1439,   646,   636,
    1442,  1447,  3935,   636,  1238,  4383,  1240,  1239,  2293,  1674,
    1678,  2296,  2297,  1240,  1236,  1237,  2969,  1468,  3776, -2572,
   -2573,  1236,  1237,  1341,  2313,  2314,  1236,  1237,  3356,  3357,
    4073,  3295,  2212,  3858,  2882,  3634,  1238,  1675,  3235,  1239,
    3341,  1236,  1237,   646,  1713,   646,  3655,  1714,   646,   646,
    3703,  1236,  1237,  3639, -2573,  1378,  3659,  1993,  3710,  4736,
    3663,  2188,  2047,  1365,  2434,   646,  2065,  2066,  2067,  4074,
    1238,  2365,  1240,  1239,  2702,  1454,  1384,  4529,  3640,  4531,
    1392,  1679,  2580,  2075,  3859,  3174,  3533,  1236,  1237,  1271,
    3215,  2645,  2581,  1431,  2646,  3713,  4600,  1236,  1237,  4389,
    1240,  4390,  1240,  1876,  1240,  1110,  1240,  1676,  1240,  1454,
     636,  3700,  3668,  3014,  2476,  4282,  3533,  1557,  2810,  2811,
    3199,  3200,  3216,  3217,  3819,  2230,  3251,  3252,  3041, -1569,
    1318,  1358,  2264,  3822,  2491,  4321,  1236,  1237,  1240,  1567,
    1236,  1237,  2703,  4461,   135,  3042,  1507,   665,  2699,   665,
    1836,  1236,  1237,  3416,  3564,  3418,  4468,  2232,   679,  2700,
    1236,  1237,  3429,   636,  2635,  2374,  2505,  3319,  1236,  1237,
    2011,  1240,  2011,  2011,   636,   835,  3442,  2942,  2943,  1942,
    4267,  4491, -2123,  3453,  3455, -1931,  1677,   636,  1824,  4779,
    2235,  4288,  2000,  1471,  4095,  1387,  3472,  3474,  3476,  3128,
    2363,  2535,  3477,  3455,  1240,  3195,  1274,  2258,  3149,  1632,
    1633,  1634,  1639,  2335,  3806,  4528,  2696,  2839,  1105,  2503,
    2462,   907,  2719,  2236,  2414,  3656,  2697,  3621,  1471,   136,
   -2631,  1238,  2508,  2048,  1239,  2511,  2512,  2049,  3519,  2868,
    1587,  2761,  1238,  1432,  3438,  1239,  3534,   141,  2095,  4218,
     870,  2001,  1176, -2635,  1236,  1237,  1271,  2407,  1240,  1236,
    1237, -2274,  2809,  4303,  3947,  3948,  1176,  2190,  2583,  2579,
    1238,  3174,  3622,  1239,  3174,  3174,  3534,  2237, -2634,  1508,
    1790,  2429,  2430,  3903,  4565,  1236,  1237,  2947,  4408,  1637,
    1240,  3174,  3904, -1931,  1046,  4322,  1431,  1469,  2350,  2328,
    1236,  1237,  2704,  1595,  1509,  3973,  1396,  3949,  2435,  2244,
    3950,  3993,  3996,  3998,  3999,  1774,   524,  1828,  1877,  3439,
    3115,  2814,  2815,  4312,  1240,  3535,  4523,  1969,   646,  1236,
    1237,  1571, -2123,  1572,  1238,  1773,  1238,  1239,  1864,  1239,
    3969,  3970,  3971,  2245,  1238, -2632,  1238,  1239,  3974,  1239,
    1497, -2724, -2123,  2343,  4493,  3545,  4000, -2633,  2352,   558,
   -2638,  2415,   139,  2930,  4494,   646,  1865,  2808,  3595,  2138,
    1832,  1236,  1237,  1253,  2224,  1282,  3150,  2818,  2182,   908,
    1238,  4316,  4317,  1239,  4780,  2695,   636,  1238,  3942,  4289,
    1239,  3704,  1238,  2139,  1943,  1239,  2336,  3289,  2864,  1970,
   -1904,  1272,  1678,  3925,  2096,  1825,  1837,  1238,  1236,  1237,
    1239, -2274,  2108,  1176,   646,  1236,  1237,  1238,  1773,  3440,
    1239,   676,  1918,  1236,  1237,  2931,   680,  1455,  1826,  2967,
    3905, -2274,   646,  2367,  1236,  1237,  2420,  2097,  2002,   833,
     646,  4075,  1236,  1237,   837,  1889,  1432,  1892,  2370,  4096,
     636,  2724,  3129,  1238,  1127,   624,  1239,  1878,  4695,  4696,
   -2724,  1455,   636,  1238,  1359,  3097,  1239,   665,  1236,  1237,
     646,  4323,   904,  1236,  1237,  4503,  2091,  1273,  1236,  1237,
    3098,   636,   636,  4313,  3816,  1240,  4388,  2436,  4483,  4484,
    1715,  2187,  4290,  1716,  3378,  2522,  1240,  1236,  1237,  1236,
    1237, -1931,  1238,  2213,  2701,  1239,  1238,   646,   646,  1239,
    1783,  1945, -2631,  1673,  1896,  2255,  2433,  1238,  3360,  1953,
    1239,  4504,  1954,  2932,  1240,  1047,  1238,  1392,  4219,  1239,
    3936,   646, -1931,  1878,  1238, -2635,  1207,  1239,  3486,  1608,
    2608,  3536,  1974,   956,   576,  1236,  1237,  2616,  3407,  3407,
   -1904,   665,  1048,   516,   516,   516,   636,   516,   636,  1392,
   -2634,   870,  2324,  2012,  4401,  2416,  1256,  2188,  1272,  2014,
     516,  3536,   646,  4558,  2702,  1674,   516,  4495,  2453,  1236,
    1237,  2068,  1994,  1995,  1996,  4329,  1998,  4189,  1240,  4357,
    1240,  3130,  1827,  1236,  1237,  2619,  4330,   636,  1240,  2015,
    1240,  1836,  2933,  1675,  2780,  2021,  1971,  2256,  2337,  2260,
    2070,  1990,  2011,  3379,  4801,  4280,  4281,  2272,  4580,  2279,
    1238,  1625,  2077,  1239,  2338,  1238,  2091, -2632,  1239,  1208,
    2175,  4623, -2300,  1997,  1240,  1999,  3151,  4524,  2020, -2633,
   -1932,  1240, -2638,  2923,  2706,  4094,  1240,  4505, -1931,  1626,
    1646,  1238,   636,  2283,  1239,  3136,  1211,  1236,  1237,  1498,
    2284,  1240,  4283,  1053,  1646,  2286,  1238,  2539,  2707,  1239,
     646,  1240,   868,  1676,  2032,  2688,  3280,  3281,  3282,    44,
    2287,  1784,  3415,  3537,   273,   636,   275,  1863,   139,  2225,
    2133,   636,  3011,  2047,  4251,  1238,  -212,  3538,  1239,  4007,
    2440,  2579,   636, -1931,  2109,  1236,  1237,  1240,  3445,  3446,
    1646,  3539,  1946,  1236,  1237,  1236,  1237,  1240,  3487,   607,
     646,   580,   964,  3957,  2047,   646,  2291,  3160,  1862,  2072,
    1100,  1101,  4525,  2325,  1122,  2229,  2211,  1238,  3250,  2107,
    1239,  1236,  1237,  3365,  1458,  2994,  4189,  4189, -1932,  1212,
    3361,  1836,  1677,  3002,  2440,  4496,  1240,  4025,  1097,  2562,
    1240,  3903,  2127,  2385,  4526,  4628,  4628,  1773,  2135,   605,
    3904,  1240,   993,  4570,  1238,  2309,  4574,  1239,  3307,  3197,
    1240,  1238, -2300,  1732,  1239,  1236,  1237,  2091,  1240,  1238,
    3198,  1631,  1239,  1236,  1237,  3380,   623,  1736,  4058,  3209,
    1238,  1459, -2300,  1239,  3090,  3080,  3038,  3219,  1238,  1236,
    1237,  1239,  4331,   637,  1290,  2813,  4250,  4271,  2934,  1236,
    1237,  2563,  4079,   608,  1176,  2265,  1236,  1237,  2091,  4337,
    1460,  4230,  2356,  2853,  1238,  2695,  1253,  1239,  1098,  1238,
    2357,  3300,  1239,  1760,  1238,  1947,   626,  1239,  2138,  2564,
      58,  4231,  1236,  1237,  1236,  1237,  3275,  1837,  1110,  1236,
    1237,  2356,  2995,  1238,  2048,  1238,  1239,  2096,  1239,  3335,
    4008,  4093,  2139,  2258,  1240,  1265,  1266,  1267,  1268,  1240,
    3838,  2442,  2443,  3698,  1631,  2334,  2782,  3701,  3702,  2744,
    2368,   640,  2556,  3220,  2749,  2048,  1236,  1237,  3832,  2049,
    2519,   655,  3381,  4189,  4189,  1240,  2176,  2755,  3905,  1236,
    1237,  1238,  1836,  4562,  1239,  4563,   587,  2520,  2562,  2565,
    1240,  3452,   993,  2231,   587,  3310,  3519,  2358,   636,  2960,
    1053,  3407,  4680,  1236,  1237,   646,  2226,   636,   646,  1236,
    1237,  2770,  2894,  2328,   642,  1238,  1773,   520,  1239,  1240,
     636,   521,   720,  1836,   124,  1325, -1932,  3451, -2420,  1238,
    1325,  3965,  1239,  2381,  3966,  1236,  1237,  2246,  1678,   662,
    2389,  2389,  4034,  2389,   670,   273,   672,   275,  3002,  3002,
    2563,  3165,  2177,   868,  3591,  2227,  1273, -1932,  3593,  1236,
    1237,  1240,   646,  1236,  1237,   636,   674,  2187,  2566,   636,
     675,  2475,   681,   955,  2701,  2359,  4338,  1837,  2564,   665,
    2824,  3041,  4189,  2917,   725,   682,   646,   646,   636,   636,
     636,  1236,  1237,  1238,  2702,  3040,  1239,  4189,  1240,  1256,
    1176,   646,  1236,  1237,  2918,  1240,  2389,  2389,  2389,  4416,
    1236,  1237,  2575,  1240,  1978,  1461,  2247,  2388,  2388,   646,
    2388,  1236,  1237,  2254,  1240,  1236,  1237,  2228,  1273,  1236,
    1237,  1421,  1240,  3002,  1236,  1237,   956,   683,  1236,  1237,
    2919,  1238,  2412,   826,  1239,  3344,  1365,  2428,  2565,  1238,
    2268,  1238,  1239,   993,  1239,   842,  3011,  2498,  1240,  1236,
    1237,  2233,  2234,  1240,  4189,  1384,  2432,   831,  1240,   876,
    1236,  1237,  1471, -1932,   890,   520,  2269,  1238, -2420,   521,
    1239,  2273,   738,  2388,  2388,  2388,  2277,  1240,  4189,  1240,
    1236,  1237,   896,  3364,   993,  3657,  2961,   636, -2420,  1796,
    4189,  4189,  1236,  1237,   898,  2278,  2178,  3531,   916,  1236,
    1237,  1236,  1237,  2517,  3183,  2494,  -578,   918,  3347,   627,
     636,  1238,  1236,  1237,  1239,  3186,   581,  2566, -1932,  1238,
     516,   516,  1239,  2541,   516,  1240,  3566,  3567,  1837,   964,
     945,  4215,  4216,  4217,  3924,  1238,   930,  1007,  1239,  1236,
    1237,  2074,  1329,  2282,  1462,  1238,  1014,  3580,  1239,  2537,
    2538,   754,  1238,  2251,  1273,  1239,  2524,  4189,   908,  1240,
    3038,  1035,  3588,  1036,  2510,  1773,  1463,  4189,  1042,  1837,
    2259,  1273,   627,  1240,  2567,  3927,  3928,  2285,  1238,   879,
    1238,  1239,   636,  1239,  1061,  1238,  1371,  2529,  1239,  1372,
    3302,  2288,  2261,  1273,  1050,  2546,  2340,  2689,  1069,  2108,
     612,  1089,  2138,  2705,  2553,  2554,  3820,  4122,  1464,  4189,
    1076,  4189,  3540,  1773,  1086,  2558,  2559,  2560,  2561,  1108,
    2569,  2570,  1238,  1330,  2967,  1239,  2139,    13,  1109,  1331,
    1236,  1237,  1436,  3958,  3773,  1238,  4189,  1240,  1239,  2262,
    1730,  2274,  1273,   646,  1436,   646,  4189,  1124,  4189,  1125,
    4189,   646,   613,  1864,  1273,  2300,  2175,  2713,  1126,  1238,
    2716,  2784,  1239,  1128,  4189,  1238,  1100,  1101,  1239,   931,
    1024,  4189,  1797,  1332,  4337,  1148,  1149,  1110,  1110,  1110,
     646,  1129,  4707,   993, -1815,  1240,  4189,  4189,  2728,  1277,
    1333,  1238,   646,  1240,  1239,  1240,  1263,  1264,  1265,  1266,
    1267,  1268,  4189,  4189, -1815,  4123,  2518,  4189,  1130,  2352,
    1326,  2319,  1276,  3163,  2729,  1238,  2440,  1133,  1239,  1238,
    1349,  1240,  1239,  1134,  2441,  1253,  1135,   614,  1136,  1053,
    1053,  1053,  1294,  2567, -1815,    25,  1373,  1137,  2806,  3187,
    2206,  1940,  1940,  1940,   932,  2816,  1328,  1238,  4124,  1218,
    1239,  1138,  4365,  1139, -1815,  2691,  3709,  1140,  1238,  1141,
    2718,  1239,  1335,  3039,  1142,  1240,  1238,   783,  2828,  1239,
    1143,  2730,  1872,  1240,  2731,  1873,  3479,  1238,  1874,  3040,
    1239,  1238,  2732,  3193,  1239,  1238,   646,  1144,  1239,  1240,
    1238,  3194,  3951,  1239,  1238,  3954,  3955,  1239,  1337,  1240,
    2733,  2275,  1273,  1346,  3514, -1609,  1240,  3201,  1145,  1334,
    4043,  2825,  3967,  2091,  2701,  1238,   646,  3205,  1239,  1187,
     273,  1146,   275,  3629,  3206,  3249,  1238,  2276,  1273,  1239,
    2280,  1273,  1240,  1150,  1240,  2011,  3785,  1355,   646,  1240,
    4023,  1206,  2519,  2442,  2443,  3653,  1238,  1236,  1237,  1239,
    3207,  4338,  3208,  2098,  1219,  1220,  1348,  3210,  1238,  2520,
    1152,  1239, -1609,  1253,  1153,  1238,  1154,  1238,  1239,  1157,
    1239,  2521,  1471,  2862,  1253,  1158,  1240,  1159,  1238,  1773,
     930,  1239,  2571,  2572,  1798,  2798,  1273,  2444,  1160,  1240,
    3307,  2109,  1029,  1030,  3213,  1031, -1609,  1032,  2887,  3160,
    1799,  2734,  2890,  3427,  1484,  1238,  1338,  3218,  1239,   646,
     646,  1161, -1609,  1240,  1253,  4044,  4045, -1609,  1256,  1240,
    4046,  4047,  1162,  2911,  1163,  2913,  1164,  4631,  1165,  4630,
    1347,  3221,  2176,  1166,   122,  1485,  1361,  3223,  1836,  2837,
    2838, -1609,  1169,    38,  4553,  1240,  1170,   956, -1609,  2475,
    1436,  1171,  2522,  2012,  1177,  2012,  2012,  1178, -1609,  2328,
    2099,  2108,  1357,  3225,  4259,  4260,  3549,  3182,  2234,  1240,
   -1609,  1773,  3398,  1240,    44, -1609,  3185,  1273,   615,  1179,
    3410,  1774,  3451,  1180, -1609,  1181,  2910,  3227,  1182,  1486,
    2975,  3228,  1183,   516,  1487,  3417,  1238,   646,   646,  1239,
     616,  1240,  3829,  3211,  1273,  2735,  1184,  3431,  1185,  3433,
    3434,  1188,  1240,   931,  1575,  3313,  3314,  1189,  2175,  3229,
    1240,  3447,  2980,  3550,  3317,  3318,  3551,  1190,  4350,  4354,
    3585,  1240,   964,   945,  3552,  1240,   617,   123,  3586,  1240,
     933,   934,  1191,   936,  1240,   938,  3599,  1273,  1240,  3587,
    1192, -1609,  3553,  3831,  1193,   124,  1256,  3837,  3624,  3625,
     939,  1369,  3839,  -671,  3790,  3791,  3840,  1256,  2523,  1240,
    4364,  1194,  1258,  1259, -1609,  1650,  1651,  1652,  1379,  3011,
    1240,  1195,  3074,  1196, -1609,  1197,  4110,  3841,   932,  1349,
      54,  3012,  1670,  1198, -2767,   618,  3554,  3089,  3842, -1904,
    1240,  2543,  2544,  1199,  3463,  1200,  3464,  1256,  1201,   993,
    1202,  3110,  1240,  3705,  3798,  3799, -1609,  2691,  2555,  1240,
    1203,  1240,  1393,   125,  1733,  3809,  3817,  1737,  2100,  1395,
    4098,  1204,  1240,  1205,  4110,  2573,  2574,  4210,  2524,  2101,
    -671,  3833,  1273,  1209,  1488,    58,  2102,  3719,  1756,  1757,
    3465,  2736,  1761,  3555,  1053,  1210,  3011,  1213,  3723,  1240,
    1214,  3725,  1217,   636,   636,   636,  1940, -1609,  3012,  1775,
    1776,  1221,  3466,  2706, -1609,  2091,  4350,  4619,  3113,  3114,
    4354,  3116,  1222,  3118,  3119,  3120,  3121,  3122,  3123,  3124,
    1223, -1609,  3127,  -671,  1837,  3132,  1224,  2707,   527,  3135,
    3850,  1273,  2682,  2683,  2684,  2685,  1225,   126,  3467,  1226,
    1258,  1259,   955,  2391,  3573,  2392,  1611,  4445,  1489,  1275,
    2737,  1258,  1259,  1261,  1262,  1263,  1264,  1265,  1266,  1267,
    1268, -1609,  3866,  3867,  1411,  2138,  1413, -1609,  2393,  1414,
    3154,  3155,  3156,  4016,  2572,  2103,  1415,  4741,  1416,  2738,
    1240,  2394,  2175,  2109,  3556,  1419,  1062,  3557,  1422,  2139,
    3354,  1258,  1259, -1609,  1428, -1609,  3600,  4194,  4195,  1427,
    -671,  4197,  4198,  4201,  4198,   527,  1448,  2078,  2457,  2458,
    2459, -1609,  1452,  1490,  4202,  4198, -1609,  4258,  3318,  1453,
    1325,  2079,  2381, -1609,  2176,  1457,  1354,   646,   646,   646,
    1836,  1469, -1609,  4277,  4198,   636, -1609,  1673,  1478,  1063,
   -1609,  1480,  2138,  2395,  1479,  2396,  1481, -1609,  1504,  1253,
    4286,  4287,  4367,  4368,  2862,   646, -1609, -1609, -1609,  4802,
    1774,  4402,  3625, -1904,  1500,  3558,  2139,  1612,   127, -1609,
    2104,  1613,  1350,  2562, -1609,  1176,  3454,  4350,  4354,   646,
     646,   646,  1614, -1609,  1505, -1609, -1609,  1510,  1243, -1609,
   -1609,  1518,  3334,  1263,  1264,  1265,  1266,  1267,  1268,  1674,
    4403,  4198,  1261,  1262,  1263,  1264,  1265,  1266,  1267,  1268,
    2518,  1519,  3288,  1525,   933,   934,   935,   936,   937,   938,
    1524,  2864,  1253,  1527,  1244,  2012,  3013,  2996,  3712,  1532,
    1064,  1537,  1491,  1568,   939,  2563,  1574,  2397,  3814,  2091,
    3468,   128,  -671,  1262,  1263,  1264,  1265,  1266,  1267,  1268,
   -1609,  1578,  3259,  2281,  1576,  3333,  1581,  4273,  4404,  4198,
    1586,  4615,  3260,  2564,  4406,  4198,  1582,   636,  3089,  1492,
    1694,  4407,  4198, -1609,  1590, -2767,  1245,  3261,  4413,  4414,
    2828,  4415,  4414, -1609,  3469,  4454,  4455,  2080,  1246,  3262,
    3263,  3264,  2398,  1236,  1237,  1597,  3089,  2997,  4501,  3318,
    1591,   993,  3559,  1773,   129,  3414,  3412,  3089,  3265,  4502,
    3318,  3424,  1615,  3423,  4363, -1609,  2147,  2148,  1596,  -671,
    4578,  4579,  4604,  3625,  4633,  4634,  3202,  1598,   646,  3423,
    1620,  3560,  2161,  2565,  3444,  3448,  1621,  4150,  1622,  1774,
     532,  3459,  1256,  1628,  3383, -2116,  2519,  3461,  3462,   636,
    4692,  3516,  4745,  4746,  4791,  4792,  1630,  2562,  2176,  1631,
    3471,  3423,  2081,  2520,  1836,  1640, -1609,  1642,  3089,  3485,
    1698, -2767,  4035,  4036,  3498,  2521,  2998,  1247,  3425,  3426,
     516,  1763,  1764,  1271,  3508,  1646,  1837,  4366,  2082,  3423,
   -1609,  4295,  4706,  1653,  4708,  1672,  3910,  4295,  2518,  1690,
    1691,  1692,  1693,  1694,  1683,  2949,  3458,  2147,  2148,  3504,
    1718,  1616,  2566,  3643,  3644,  1256,  1729,   532,  1730,  2563,
    1731,  3143,  -671,  2161,  2214,  3521,  3460,  3607,  3608,  4729,
    3864,  3865,  2518,  1754,  2177,  1771, -1609,  3497,  1253,  1782,
    3022,  3528,  1065,  3025,  3026,  1791,  3028,  2564,  1807,  3031,
    3032,  2083,  1813,  3035,  2562,  1833,  2522,  3473,  3044,  4417,
    1834,  2163,  2164,  3048,  3049,  3050,  3051,  3052,  1626,  4760,
    4761,  3056,  3057,  1699,  3059,  1840,  1841,  1702,  1844,  3889,
    3068,  3069,  3070,  3071,  1703,  1847,  3075,  3076,  1848,  3078,
     693,  1849, -1609,  1850,  1851,  3524,  1258,  1259,  1852,  -671,
    1695,  1696,  1697,  1698, -1609, -1609,  1854,  1855,  1066,  2266,
    1067,  1866,  1867,  2270,  1868,  2562,  2563,  2565,  3475,  1869,
    1897,  2399,  2400,  2401,  3266, -1609,  1914, -1609,  1902,  1905,
    3598,  1922,  1673,  1923,  2519,   993,  1924,  2294,  2911,  4485,
    1925,  1350,  3267,  1930,  2564,  1935,  1936,  2084,  3142,  1937,
    1773,  2520,  2163,  2164, -1609, -1609,  1938,  1955, -1609, -1609,
    1987,  4363,  1949,  2521,  1979,  3648,  1704,  1988,  2519,  1258,
    1259,  1992,  2523,  2023,  4104,  2024,  2025,  2563,  2862,  2026,
    2028,   720,  2029,  2030,  4063,  2520,  2059,  4053,  2178,  2045,
    2076,  1252,  2999,  2122,  1674,  4232,  2566,  2521,  2887,  3636,
    2128,  2910,  3638,  4233,   646,  2564,  1699,  2142,  1700,  1701,
    1702,  2129,  2143,   646,  2565,  2171,   693,  1703,  2189,  2825,
    1837,  2191,  2996,  2192,  1706,  2203,   956,   956,  2567,  2209,
    4234,  1256,   273,  2215,   275,  1421,   724,  2217,  2218,  2219,
    2241,  2242,  2524,   725,  2522,  2243,  1774,  1261,  1262,  1263,
    1264,  1265,  1266,  1267,  1268,  2686,  3268,  2250,  2248,  1238,
    2249,  3684,  1239,  1436,  1248,  1249,  1250,  3893,   636,  2252,
    2263,   729,   730,  2258,  3269,  2565, -1904,  4530,  2522,  3693,
    2329,  2333,  2267,  1155,  2271,  2289,  2290,  4191,  2295,  3089,
    4460,  2298,  2997,  2566,  2299,  3654,  2310,  2311,  3423,  1704,
    4104,  3089,  2312, -1290,  1253,  2562,  2339,   720,  1268,  4470,
   -1433,   646,  2349,  2369,  1207,  3423,  1211,  3089,  3089,  2384,
    1261,  1262,  1263,  1264,  1265,  1266,  1267,  1268,  4020,  4021,
    2404,  3089,  3423,  2413,  3270,  1608,  2419,  2422,  2448,  4638,
    2425,   738,  2449,  3423,  2454,  3686,  3423,  2455,  2456,  4235,
    4243,  2471,  3271,  2586,  2566,  2587,  1705,  1706,  2479,  2482,
    2523,  2477,   724,  2478,  2483,  2495,  1707,  2563,  2484,   725,
    3728,  2998,  2485,   636,  -679,  3711,  2486,  1436,  3784,  2497,
    2499,  3975,  1709,  2504,  3717,  1258,  1259,  -818,  -818,  2500,
    2589,  2513,  2527,  2528,  2523,  2564,  2514,   729,   730,  -818,
    3110,  2534,  2531,  2532,   749,  2536,  2545,  2547,  1254,  2592,
    2548,  2549,  2567,  4129,  4130,  4139,  2552,  2593,  2550,   753,
     754,  2551,  2651,  2655,  2657,   646,  4133,  3976,  2659,  4236,
    2524,  1255,  2660,  4136,  2661,  2662,  2680,  3977,  2690,  2663,
    2709,  2681,  2664,  2665,  2595,  4643,  4644,  4237,  4646,  4638,
    3729,  2710,  4101,  3787,  2711,  1773,  2666,  2667,  1568,  4155,
    4156,  2596,  2727,  2668,  2524,  2565,  4786,   738,  1773,  2078,
    2718,  4238,  2669,  1773,  2670,  2671,  2672,  2673,  1773,  4795,
    2674,  3885,  2675,  2079,  4786,  2676,  3978,  2714,  2677,  4795,
    2601,  3428,   542,  2678,  2679,  2751,  2752,  1256,  2357,  1707,
    2822,  2835,  2840,  2722,  3437,  2750,  2854,  3874,  4688,  2567,
    4689,  4690,  1774,  1240,  1708,  1709,  2762,  2763,  1100,  1101,
    2775,  2797,   844,  2804,  2812,  2821,  4508,  2836,  2843,   646,
     749,  2851,  2844,  2845,  4243,  2841,  1261,  1262,  1263,  1264,
    1265,  1266,  1267,  1268,  2566,   753,   754,  2842,  2856,   543,
    2857,  2858,  2865,  2866,  1909,   273,  2869,   275,  3979,  2870,
    2871,  2877,  2891,  2605,  2892,  2895,  2896,  2897,  2463,  2462,
    2567,  2606,  1963,  3089,  2915,  2916,  1964,  2941,   544,  2926,
    2944,  2956,  2957,   273,  2958,   275,  2607,  2999,  2973,  2981,
    2992,  2993,  3423,  3011,  3024,  1257,  3089,  3029,  3030,  3033,
    3034,  3036,  4757,  3037,  1774,  3043,  3045,  3046,  3423,  1296,
     636,  4772,   845,   775,   545,  -853,  4511,  4105,  3047,  3054,
    4106,  3055,  3060,  3061,  3066,  4275,  4276,  3067,  4278,  4279,
    3077,   781,  3915,  3096,  3100,  3105,   783,  3141,  3111,   784,
    3140,  3157,  1297,  2609,   847,  2210,  3145,  3166,   993,  2080,
    1436,  1258,  1259,  3171,  3177,  3179,  3180,  3181,   848,  3188,
    3189,  2610,   546,  3230,  4239,  3258,  3240,  1260,  3241,  3246,
    3244,  3248,  3253,  3256,  3277,  4006,  3283,  3278,  4011,  3285,
    1880,  3290,  3294,  1371,  1881,  4019,  4019,  4019,  2012,  3293,
    3297,   586,  3309,  3303,  3312,  3315,  1882,  3320,   646,  4107,
    4108,  3331,  3332,  3340,  3336,  3337,  3348,  3355,  3359,  3349,
    3362,  2616,  1298,  4513,  3370,  1100,  1101,  2614,   852,  2615,
    3430,  3980,  3648,  3371,  2081,  3432,  3975,  2617,  3981,  3494,
    3499,  1690,  1691,  1692,  1693,  1694,   895,  1299,  3502,   775,
    1300,  4798,  3506,  4105,  3505,   853,  4106,  1100,  1101,  3510,
    2082,  3515,   854,  3516,  3520,  3546,  2061,   781,  3565,  3568,
    2567,  3569,   783,  3576,  3577,   784,  3589,  3602,  3982,  2316,
     646,  4063,  3976,  3235,  3603,  3604,  1301,  3613,  3615,  3620,
    2890,  3626,  3977,  3628,  2440,  3661,  3641,  3649,   -67,  3662,
    1296,  3673,   855,   547,  3679,  3680,  1302,  3684,  3685,  2623,
     526,  3687,  1261,  1262,  1263,  1264,  1265,  1266,  1267,  1268,
    4019,  1303,  2475,  2083,  1397,  3089,  3688,  3694,  3689,  3695,
    4114,   636,  3696,  1297,  1398,  4107,  4108,  3708,  3720,  4119,
    3716,  3978,  1695,  1696,  1697,  1698,  3726,  2649,  3786,  1399,
    3727,  3983,  3788,  3795,  3796,   548,  3801,  3802,  3803,  4081,
    3804,  1400,  1401,  1402,  3811,  2624,  2625,  2626,  3807,  1304,
     646,  3808,  2627,  3815,  3809,  3810,   549,  3821,  3818,  3823,
    1403,  3825,  3826,  4543,  3827,  3830,  4511,  3834,  2628,  3835,
    3836,  3845,  2629,  1305,  3851,   527,  4157,  3853,  4543,  3844,
    3862,   824,  3869,  1298,  3870,  3867,  3879,  3335,  4112,  1436,
    3881,  2630,  3886,  3882,  3887, -1519, -1524,  3896,  3902,  2084,
    3911,  3912,  3920,  3926,  3913,  3929,  3916,  3930,  1299,  2632,
    3937,  1300,  -884,  3952,  4138,  1883,  3945,  4002,   273,   550,
     275,  3995,  4243,  3817,  4027,   551,   636,  4031,  1699,  4229,
    1700,  1701,  1702,  4032,  4037,   858,  4033,   646,  3984,  1703,
    4038,  4039,  4040,  1884,   552,  4596,  4051,  1301,  4052,  4684,
    -853,  1885,  4068,  4055,  4070,  4056,  4082,  4117,  4264,   636,
     528,  4769,  4083,  4099,  4120,  4100,  4102,  1302,  3992,   553,
    4142,  4103,  3393,  4019,  4019,  4128,  4019,  4019,  1306,  4132,
    4134,   861,  1303,  4143,  4144,  4145,   554,  1307,  4769,  4146,
    4148,  4149,  4158,  4192,   862,  1886,  4203,  4200,  4204,  4205,
    4212,  4214,  1308,  4223,  4207,  4222,  4208,  4268,  4211,  4225,
    4255,  4285,  4291,  4300,  4299,  4307,  -352,  4325,  4257,  4356,
    1309,  1704,  4297,  4346,  4305,  4328,  4373,  4370,  4684,  4327,
    1304,  4374,   824,  4382,  4384,  4311,  4265,   824,  4386,  4379,
    4318,  4391,  4396,  4400,  1887,  4422,  4425,  -370,  4543,  4452,
    1100,  1101,  4409,  4419,  1305,  4451,  3980,  4453,  4676,  4462,
    4463,   529,  4472,  3981,  1310,  4469,  4475,  1311,  4487,  4332,
    4336,  4499,  4019,  3489,   824,   865,  1404,  4539,  1705,  1706,
    4532,  4540,  4550,  4544,  4551,  4568,  4582,  4304,  4583,  4584,
    4585,   824,  4591,  4592,  1405,  1312,  1774,   866,  4593,   867,
    4595,  4594,  4598,  3982,  4608,  4800,  4605,  4609,  4610,  4611,
    4616,  4618,  4624,  4620,   520,  4621,  2608,  1313,   521, -2471,
    2583,  4652,  4642,  4645,  4647,  4648,  2586,  4723,  2587,  2890,
    4655,  2890,  4656,  4664,  4677,   824,   824,   824,   824,  4543,
    4693,  4543,  4678,   530,  4681,  4703, -1693,   824,  4704,  4691,
    4709,  4705,  4714,  4710,  4715,  4743,  4718,  4725,  4728,  1306,
    4720,  4410,  4543,  2589,   531,  4721,  1314,  4732,  1307,  4734,
    4737,  4738,  4739,  4744,  4748,  4758,  3983,  4750,  4773,  4778,
    4797,  4774,  2592,  1308,  4787,  3134,  4320,   532,  4426,  4015,
    2593,  3005,  3800,  4543,  4543,  1499,  1550,  2830,  4777,  4086,
    4397,  1309,  4514,  4653,  4486,  1580,  4654,  4084,  4088,  4263,
    4752,  4789,   599,  2451,  1006,  2377,  4169,  2595,  3273,  4170,
    4762,  1707,  4172,  4661,  4173,  4175,  1406,   533,  4176,  4177,
    4178,  1568,  4179,  4180,  2596,   824,  1708,  1709,  4537,  4662,
    4183,  4629,  4229,  4184,  4185,  1310,  4549,  1624,  1311,  4548,
    2360,  2120,   646,  4399,  4270,  3081,  3722,  3872,  4492,  2633,
    3296,  3619,  4474,  2601,  3301,  1912,  4224,  4567,  4717,   534,
    3875,  4683,  4641,  2174,  4456,  1043,  1312,   535,  4381,  4092,
    3079,  3677,  3484,  3984,  3919,  3086,  1407,  3491,  4111,  4113,
    4726,  4533,  3562,  3960,  4293,  4001,  4147,  4137,  1313,  4566,
    2990,  3592,  3232,  3590,  1408,  3594,  2144,  4517,  4479,  4480,
     538,   539,  4602,  2708,  4603,  4459,  2828,  4467,  4465,  3153,
    4296,  4345,  3699,  3083,  3483,  1523,  1588,  2046,   273,  4336,
     275,  4116,  2948,  2874,  4560,  2654,  2605,  4552,  3932,  2172,
    2431,  2134,  2852,  1774,  2606,  3614,  3287,  1314,  2803,  2898,
    4190,  1033,  2461,  3601,  1426,  4418,  2743,  2741,  2968,  2607,
    3255,  2962,  3658,  1728,   646,  2145,  4650,  2146,  2147,  2148,
    2149,  2150,  2802,  2151,  2152,  2153,  2154,  2155,  2156,  2157,
    2158,  2159,  3797,  2160,  2161,  2162,  4261,  4393,  3940,  4651,
    1671,  2819,  3345,  2062,  4072,  3478,  4742,  4559,  2905,  4065,
    2712,  1928,  1895,  4640,  2880,  2850,  3877,  3632,  3631,  3667,
    4564,  1020,  2208,  1560,  1123,  1561,  2609,  1562,  4575,  4576,
    2506,  1563,  2004,  1001,  2507,  2945,   824,  3944,  1004,  1934,
    3618,  4716,  2371,  4586,  2610,  4740,  4649,  4796,  4799,  4141,
    1216,  3635,  2332,  2924,  1952,  3651,   958,  3652,   959,  2489,
    2922,   646,  2921,  2914,  2418,  1284,   926,  1412,  1888,  4213,
    2893,  3274,  4221,  1944,   824,   824,   928,  3110,  3110,  1418,
    2198,  1039,  1554,   824,   824,   824,   824,   824,   824,   824,
     824,   824,   824,   824,   824,  1040,  1041,     0,     0,     0,
    2614,  4666,  2615,   824,   824,     0,   824,   824,  4674,  1555,
    2617,   824,     0,     0,   824,   824,   824,   824,     0,   824,
     824,   824,  1556,  2163,  2164,     0,     0,     0,   824,   824,
       0,   824,   824,   824,   824,   824,     0,     0,   824,   824,
     824,   824,   824,   824,   824,   824,   824,   824,   824,     0,
     824,     0,     0,   824,   824,     0,     0,     0,   824,     0,
       0,     0,   824,   824,   824,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   824,   824,   824,     0,     0,     0,
       0,     0,  2623,   824,     0,     0,     0,     0,     0,  4730,
     824,   824,   824,   824,  4735,     0,     0,     0,     0,     0,
       0,   824,   824,   824,     0,   824,   824,   824,   824,   824,
       0,   824,   824,   824,   824,   824,   824,   824,   824,  4790,
       0,     0,   824,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4770,     0,     0,     0,     0,  2624,  2625,
    2626,     0,     0,     0,  4724,  2627,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1774,     0,
    4770,  2628,     0,     0,     0,  2629,     0,   646,     0,     0,
       0,  1774,     0,     0,     0,     0,  1774,     0,     0,     0,
       0,  1774,     0,     0,  2630,     0,     0,     0,     0,  4371,
    4372,     0,     0,  4375,  4376,  4377,  4378,     0,     0,     0,
       0,     0,  2632,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1131,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4457,     0,  1168,     0,     0,
       0,   824,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4481,  4482,     0,     0,     0,     0,     0,     0,     0,  4490,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,  1230,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2582,     0,     0,
       0,     0,     0,  2583,     0,  2584,     0,  2585,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2586,     0,
    2587,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1370,     0,
    2588,     0,     0,     0,     0,  2589,  2590,     0,     0,     0,
       0,     0,  2591,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2592,     0,     0,     0,     0,     0,
       0,     0,  2593,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2594,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2595,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1568,     0,     0,  2596,     0,     0,     0,
       0,     0,     0,     0,  2597,  2598,     0,     0,     0,     0,
       0,  2599,     0,     0,     0,     0,     0,     0,     0,  2600,
       0,     0,     0,  -961,     0,  2601,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2602,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2603,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   824,   824,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     273,   824,   275,     0,     0,     0,  2604,     0,  2605,     0,
       0,     0,     0,     0,     0,     0,  2606,     0,     0,  1604,
       0,     0,     0,     0,     0,     0,     0,   824,     0,     0,
       0,  2607,     0,   824,     0,     0,   824,     0,   824,     0,
       0,     0,     0,     0,   824,     0,   824,   824,     0,     0,
       0,     0,     0,     0,     0,  2608,     0,  1644,  1645,     0,
       0,     0,     0,     0,     0,     0,  1655,  1656,     0,     0,
    1659,  1660,  1661,  1662,  1665,  1666,  1667,  1668,     0,     0,
       0,     0,     0,     0,     0,     0,  1684,  1685,  2609,  1686,
    1687,     0,     0,     0,     0,     0,     0,  1720,  1721,  1722,
    1723,     0,     0,  1726,     0,     0,  2610,     0,     0,     0,
    2611,  1734,  1735,     0,  1738,  1739,     0,     0,     0,     0,
       0,  1743,  1744,  1745,     0,     0,  1748,  1749,  1750,  1751,
    1752,  1753,     0,  1755,     0,     0,  1758,  1759,     0,   824,
       0,  1762,     0,     0,     0,  1765,  1769,  1770,     0,     0,
    2612,     0,     0,     0,     0,  2613,     0,  1777,  1778,  1779,
       0,     0,  2614,     0,  2615,     0,  1787,     0,     0,  2616,
       0,     0,  2617,  1792,  1793,  1794,     0,  2586,     0,  2587,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,   824,  2618,     0,     0,  1830,     0,     0,     0,
       0,  -818,  -818,     0,  2589,     0,     0,  2619,  2620,  2621,
    2622,     0,     0,  -818,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2592,     0,     0,     0,     0,     0,     0,
       0,  2593,     0,     0,  2623,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2595,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1568,     0,     0,  2596,     0,     0,     0,     0,
       0,     0,     0,  1899,     0,     0,     0,     0,     0,     0,
    2624,  2625,  2626,     0,     0,     0,     0,  2627,     0,     0,
       0,     0,     0,     0,  2601,     0,     0,     0,     0,     0,
       0,     0,     0,  2628,     0,     0,     0,  2629,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2648,     0,     0,     0,     0,  2630,     0,     0,     0,
       0,  2631,     0,     0,     0,     0,     0,     0,  1951,     0,
       0,     0,     0,   824,  2632,     0,     0,     0,  1957,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   273,
       0,   275,     0,     0,  1985,     0,     0,  2605,  1991,     0,
       0,     0,     0,     0,     0,  2606,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2607,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2983,     0,     0,     0,     0,     0,
       0,  -961,   824,     0,     0,     0,   824,     0,     0,     0,
       0,   824,   824,  2036,     0,     0,     0,     0,     0,     0,
     824,     0,   824,     0,   824,   824,   824,   824,     0,     0,
     824,     0,     0,     0,     0,     0,     0,  2609,     0,     0,
     824,     0,   824,   824,     0,   824,   824,   824,   824,     0,
     824,     0,     0,   824,     0,  2610,     0,     0,     0,     0,
       0,     0,   824,     0,     0,     0,     0,     0,     0,   824,
       0,   824,     0,   824,   824,     0,   824,   824,     0,     0,
       0,   824,   824,   824,     0,     0,     0,   824,   824,   824,
       0,   824,     0,   824,     0,   824,     0,   824,     0,   824,
       0,     0,     0,     0,   824,     0,     0,     0,     0,     0,
       0,  2614,     0,  2615,     0,     0,     0,     0,     0,     0,
       0,  2617,     0,   824,     0,     0,     0,     0,     0,     0,
     824,     0,     0,   824,     0,     0,     0,     0,     0,   824,
       0,     0,   824,     0,     0,     0,   824,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2623,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2624,
    2625,  2626,     0,     0,     0,     0,  2627,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2302,
    2304,  2306,  2628,     0,     0,     0,  2629,     0,     0,     0,
       0,   824,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2630,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2341,     0,     0,  2632,     0,     0,     0,     0,     0,  2346,
       0,  2347,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2648,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3003,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3003,  3003,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2984,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2427,     0,     0,  2648,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     1,     0,     2,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3003,  3003,  2488,     0,     0,     0,
       3,     0,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     6,
       0,     0,     0,     0,     0,     0,     7,     0,     0,     0,
     824,     8,     9,     0,   824,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    10,     0,     0,     0,     0,     0,     0,     0,
       0,   824,   824,     0,     0,     0,     0,     0,     0,     0,
       0,    11,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,   824,     0,   824,    12,     0,     0,     0,     0,
       0,     0,     0,    13,    14,    15,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    16,    17,     0,     0,
       0,   824,     0,     0,     0,     0,   824,     0,     0,    18,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    19,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   824,     0,     0,
      20,     0,     0,     0,     0,     0,  2658,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,    22,     0,     0,
       0,    23,     0,     0,     0,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    25,     0,    26,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    27,
       0,     0,     0,   824,     0,  2721,     0,     0,     0,  2723,
       0,     0,     0,     0,  2725,  2726,     0,    28,     0,     0,
       0,    29,     0,  1662,     0,  2742,     0,  1662,     0,  2745,
    2746,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2753,     0,  2754,     0,     0,  2756,  2757,
    2758,  2759,     0,  2760,   824,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2764,     0,     0,     0,  2648,
       0,     0,  2765,     0,  2766,     0,  2767,  2768,     0,  2769,
       0,     0,     0,     0,  2772,  2773,  2774,     0,     0,     0,
    2776,  2777,  2778,     0,  2779,     0,  2781,     0,  2783,     0,
    2785,     0,  2786,     0,     0,     0,     0,  2787,     0,     0,
       0,     0,     0,     0,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2807,     0,     0,     0,
       0,     0,     0,    31,     0,    32,     0,     0,     0,     0,
       0,     0,  2817,     0,     0,  2820,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    34,
    2648,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,   824,     0,     0,     0,     0,     0,
       0,    35,     0,     0,    36,     0,    37,     0,     0,    38,
       0,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,    42,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     1,     0,     2,
      44,     0,  3003,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,    46,    47,    48,     0,     0,     0,     0,
       4,     0,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     6,     0,     0,     0,     0,
       0,     0,     7,     0,     0,    49,     0,     8,     9,     0,
       0,     0,    50,     0,     0,     0,     0,   824,   824,     0,
     824,     0,     0,     0,  1985,     0,     0,     0,    10,   824,
       0,     0,     0,     0,   824,     0,     0,   824,     0,   824,
     824,     0,     0,     0,     0,     0,     0,    11,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    51,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    52,
       0,    12,   824,    53,     0,     0,    54,     0,     0,    13,
      14,    15,    55,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    16,    17,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,    56,     0,     0,     0,     0,     0,    57,    19,
       0,     0,     0,     0,     0,     0,     0,     0,   824,     0,
       0,    58,     0,     0,     0,     0,    20,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   961,     0,     0,
       0,    21,     0,    22,     0,     0,     0,    23,     0,   962,
       0,    24,     0,     0,     0,     0,     0,     0,     0,     0,
     899,   963,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   824,     0,     0,    25,     0,    26,
       0,     0,     0,     0,     0,   964,   945,     0,     0,     0,
       0,     0,     0,   965,     0,    27,     0,     0,   966,     0,
       0,     0,     0,  2648,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    28,     0,     0,     0,    29,     0,     0,
       0,     0,     0,     0,   967,     0,   968,     0,   969,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     970,     0,     0,  3162,     0,     0,     0,  3164,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    14,    15,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3191,  3192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1904,   971,     0,
       0,     0,   972,     0,  3212,   973,     0,     0,     0,     0,
       0,     0,     0,  3222,     0,  3224,     0,  3226,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   974,     0,   975,     0,     0,     0,    31,
       0,    32,     0,   976,     0,   977,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    34,     0,     0,     0,     0,
     978,   979,   980,     0,     0,     0,     0,     0,     0,     0,
    3284,     0,     0,     0,     0,     0,     0,    35,     0,     0,
      36,     0,    37,   981,     0,    38,     0,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,    42,     0,     0,   982,     0,     0,     0,     0,
      43,     0,     0,     0,     0,     0,    44,     0,     0,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,    46,
      47,    48,     0,     0,   983,     0,     0,     0,     0,   824,
       0,     0,     0,     0,     0,     0,  1985,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,    50,     0,
       0,     0,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3367,     0,     0,
       0,     0,   984,     0,   824,     0,     0,     0,     0,     0,
    3730,  3731,     0,    51,     0,     0,  3732,     0,  3733,     0,
    3734,  3735,     0,     0,     0,    52,     0,     0,   985,    53,
       0,     0,    54,     0,     0,     0,     0,  3549,    55,   986,
     987,     0,     0,   988,   989,     0,  2586,     0,  2587,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   990,     0,     0,     0,    56,     0,
       0,     0,     0,     0,    57,     0,     0,     0,     0,     0,
    -818,  -818,     0,  2589,     0,     0,  3991,    58,     0,     0,
       0,     0,  -818,     0,  3736,     0,     0,  3737,     0,     0,
       0,     0,  2592,     0,     0,  3738,     0,     0,     0,     0,
    2593,     0,   991,     0,     0,     0,  3500,  3501,     0,     0,
       0,     0,     0,  3739,     0,   992,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2595,   824,     0,
    3740,     0,   824,     0,     0,     0,     0,     0,     0,     0,
       0,  1568,     0,     0,  2596,     0, -2511,     0,     0,     0,
     993,     0,     0,     0,     0,  3741,     0,  3742,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   824,   994,   995,
    3743,  3744,     0,  2601,     0,     0,     0,     0,  3532,     0,
       0,   824,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3571,  3572,     0,     0,  3745,     0,     0,   996,  2648,     0,
       0,     0,  3579,     0,     0,     0,     0,  3581, -2511,     0,
    3582,     0,  3583,  3584,     0,     0,   997,     0,   273,     0,
     275,     0,     0,  3746,     0,     0,  2605,     0,     0,     0,
       0,     0,  3747,  3748,  2606,  3749,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2607,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3991,  3750,  3751,
    3752,     0,     0,     0,     0,     0,  3610,     0,     0,     0,
       0,     0,     0,     0,     0,  4187,     0,  3753,  3754,  3755,
       0,     0,     0,     0,     0,  3756,     0,     0,  3757,     0,
       0,  3610,     0,     0,     0,     0,  2609,     0,     0,     0,
       0,     0,     0,     0,     0,  3758,  3759,  3481,     0,     0,
       0,     0,     0,  2583,  2610,  2584,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,     0,  2586,     0,
    2587,   824,     0,     0,     0,     0,     0,   824,     0,   824,
       0,  3760,  3761,     0,     0,     0,     0,  3610,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2588,     0,     0,     0,     0,  2589,  3762,     0,     0,     0,
    2614,     0,  2615,     0,     0,     0,     0,     0,     0,     0,
    2617,     0,     0,     0,  2592,     0,     0,     0,     0,     0,
       0,     0,  2593,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2594,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2595,
       0,     0,  3763,     0,     0,     0,  3764,     0,   824,     0,
       0,     0,     0,  1568,  4187,  4187,  2596,     0,     0,     0,
    3765,     0,     0,     0,  2597,     0,     0,     0,     0,     0,
       0,  3482,  2623,     0,     0,     0,     0,     0,     0,  2600,
       0,     0,     0,     0,     0,  2601,     0,  4344,     0,     0,
       0,  4344,  4344,     0,     0,     0,     0,     0,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2603,     0,  3766,     0,     0,
    3767,     0,     0,  3768,  3769,  3770,  3771,     0,  2624,  2625,
    2626,     0,     0,     0,     0,  2627,   824,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     273,  2628,   275,     0,     0,  2629,     0,     0,  2605,     0,
       0,     0,     0,     0,     0,     0,  2606,  3772,  3773,     0,
       0,     0,     0,     0,  2630,     0,     0,     0,     0,     0,
       0,  2607,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2632,     0,  3774,     0,     0,   824,     0,   824,
       0,     0,     0,     0,     0,  2608,     0,     0,     0,   824,
       0,  4187,  4187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4344,     0,  3610,     0,     0,     0,     0,     0,  2609,  4344,
       0,     0,     0,  4344,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2610,     0,     0,     0,
    2611,     0,     0,     0,     0,     0,     0,     0,  3895,     0,
       0,     0,     0,     0,     0,     0,  3367,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4344,     0,  3923,     0,     0,
       0,     0,     0,     0,     0,  2613,     0,     0,     0,     0,
       0,     0,  2614,     0,  2615,     0,     0,     0,   824,     0,
    4187,     0,  2617,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4187,   824,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4561,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,     0,  2620,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2623,     0,     0,     0,     0,     0,
       0,     0,  4187,     0,     0,     0,     0,     0,  4344,     0,
    4344,  4344,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,  4187,     0,     0,     0,
       0,  3367,     0,     0,     0,  4030,     0,     0,  4187,  4187,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2624,  2625,  2626,     0,     0,     0,     0,  2627,     0,     0,
       0,   824,     0,     0,     0,     0,     0,     0,     0,     0,
    3610,     0,     0,  2628,     0,     0,     0,  2629,     0,     0,
       0,     0,     0,     0,  3367,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2630,     0,     0,     0,
       0,     0,     0,     0,     0,  4187,     0,     0,     0,     0,
       0,     0,   824,     0,  2632,  4187,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,  4187,     0,  4187,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,     0,     0,   824,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4187,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4187,     0,  4187,     0,  4187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4187,     0,     0,     0,     0,     0,     0,  4187,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4187,  4187,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4187,  4187,     0,     0,     0,  4187,     0,     0,     0,     0,
       0,     0,     0,     0,  4249,     0,     0,     0,     0,     0,
    4254,     0,  4256,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4306,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3367,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3367,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4420,     0,  4421,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4429,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4541,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4546,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3610,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4614,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4668,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4702,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4719,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   142,
       0,   143,   689,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   690,     0,   152,   153,
     154,   155,   156,   157,   691,   159,     0,   160,     0,     0,
     692,   161,   693,   694,   695,   162,   696,     0,   163,   164,
     165,  1766,   166,  4771,   167,   168,     0,     0,   169,   697,
     698,   170,   171,     0,   172,   699,   700,   174,   175,     0,
     176,   177,   178,   179,   180,   701,   182,     0,   702,   184,
     703,   704,   705,   706,   707,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   708,   204,  3610,   205,   709,   710,   206,     0,     0,
     207,   711,   208,   712,   713,   209,     0,   210,   714,   715,
       0,   211,   212,   213,   716,   717,   718,     0,     0,     0,
       0,   719,   216,   720,     0,     0,   721,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,   265,   266,
     267,     0,   268,   729,   730,     0,   269,   270,     0,     0,
       0,   731,   272,   273,   274,   275,   732,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,   733,   281,
     282,   734,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   735,
       0,  1767,   292,     0,   736,   293,   294,     0,     0,     0,
       0,     0,   737,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   738,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,   751,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,  1768,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   785,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,     0,     0,
       0,   795,   796,     0,     0,     0,     0,   797,   798,     0,
       0,   799,   800,     0,     0,   801,   802,   142,     0,   143,
     689,   145,   146,   147,   148,  1981,     0,   149,     0,     0,
       0,   150,     0,     0,   690,     0,   152,   153,   154,   155,
     156,   157,   691,   159,     0,   160,     0,     0,  1982,   161,
     693,   694,   695,   162,   696,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,   697,   698,   170,
     171,     0,   172,   699,   700,   174,   175,     0,   176,   177,
     178,   179,   180,   701,   182,     0,   702,   184,   703,   704,
     705,   706,   707,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   708,
     204,     0,   205,   709,   710,   206,     0,     0,   207,   711,
     208,   712,   713,   209,     0,   210,   714,   715,     0,   211,
     212,   213,   716,   717,   718,     0,     0,     0,     0,   719,
     216,   720,     0,     0,  1983,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   722,
       0,   244,   245,   246,   247,   723,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   726,   260,   727,
     262,   263,     0,   264,     0,   728,   265,   266,   267,     0,
     268,   729,   730,     0,   269,   270,     0,     0,     0,   731,
     272,   273,   274,   275,   732,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,   733,   281,   282,   734,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   735,     0,     0,
     292,     0,   736,   293,   294,     0,     0,     0,     0,     0,
     737,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,   738,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   739,   321,   322,   323,
     324,   740,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   741,   332,     0,     0,   742,   334,   743,   335,
       0,   336,   744,   745,   746,   747,   748,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,   750,   751,   752,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   755,  1984,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,   756,   368,     0,   369,
       0,   370,   371,   757,   373,   374,   375,   376,   758,   759,
     379,   760,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   761,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,   762,   763,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   764,     0,   765,
     416,   417,   418,   419,   420,   421,   766,   767,   424,   425,
     426,   427,     0,   768,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,   769,   770,   455,   456,     0,
     457,   458,   771,   460,   461,   462,   772,   773,   463,   464,
     465,   466,   774,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,   776,   777,   778,
     779,     0,     0,     0,     0,     0,   480,   481,   482,     0,
     780,   781,   782,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   785,   497,   498,     0,     0,   786,
     787,   788,   789,   499,     0,     0,   500,   790,     0,   791,
     501,   502,   503,   504,   505,   792,   793,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   794,     0,     0,     0,     0,     0,     0,     0,   795,
     796,     0,     0,     0,     0,   797,   798,     0,     0,   799,
     800,     0,     0,   801,   802,   142,     0,   143,   689,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   690,     0,   152,   153,   154,   155,   156,   157,
     691,   159,     0,   160,     0,     0,   692,   161,   693,   694,
     695,   162,   696,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,   697,   698,   170,   171,     0,
     172,   699,   700,   174,   175,     0,   176,   177,   178,   179,
     180,   701,   182,     0,   702,   184,   703,   704,   705,   706,
     707,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   708,   204,     0,
     205,   709,   710,   206,     0,     0,   207,   711,   208,   712,
     713,   209,     0,   210,   714,   715,     0,   211,   212,   213,
     716,   717,   718,     0,     0,     0,     0,   719,   216,   720,
       0,     0,   721,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   722,     0,   244,
     245,   246,   247,   723,   724,   248,   249,     0,   250,   251,
     252,   725,     0,   253,     0,     0,     0,   254,  2301,   255,
       0,   256,     0,   257,   258,   726,   260,   727,   262,   263,
       0,   264,     0,   728,   265,   266,   267,     0,   268,   729,
     730,     0,   269,   270,     0,     0,     0,   731,   272,   273,
     274,   275,   732,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,   733,   281,   282,   734,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   735,     0,     0,   292,     0,
     736,   293,   294,     0,     0,     0,     0,     0,   737,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,   738,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,   751,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,     0,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,     0,     0,     0,   795,   796,     0,
       0,     0,     0,   797,   798,     0,     0,   799,   800,     0,
       0,   801,   802,   142,     0,   143,   689,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     690,     0,   152,   153,   154,   155,   156,   157,   691,   159,
       0,   160,     0,     0,   692,   161,   693,   694,   695,   162,
     696,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,   697,   698,   170,   171,     0,   172,   699,
     700,   174,   175,     0,   176,   177,   178,   179,   180,   701,
     182,     0,   702,   184,   703,   704,   705,   706,   707,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   708,   204,     0,   205,   709,
     710,   206,     0,     0,   207,   711,   208,   712,   713,   209,
       0,   210,   714,   715,     0,   211,   212,   213,   716,   717,
     718,     0,     0,     0,     0,   719,   216,   720,     0,     0,
     721,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,  2303,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,   265,   266,   267,     0,   268,   729,   730,     0,
     269,   270,     0,     0,     0,   731,   272,   273,   274,   275,
     732,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,   733,   281,   282,   734,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   735,     0,     0,   292,     0,   736,   293,
     294,     0,     0,     0,     0,     0,   737,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,   738,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   739,   321,   322,   323,   324,   740,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   741,   332,
       0,     0,   742,   334,   743,   335,     0,   336,   744,   745,
     746,   747,   748,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,   750,
     751,   752,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   755,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,   756,   368,     0,   369,     0,   370,   371,   757,
     373,   374,   375,   376,   758,   759,   379,   760,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   761,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,   762,
     763,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   764,     0,   765,   416,   417,   418,   419,
     420,   421,   766,   767,   424,   425,   426,   427,     0,   768,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,   769,   770,   455,   456,     0,   457,   458,   771,   460,
     461,   462,   772,   773,   463,   464,   465,   466,   774,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,   776,   777,   778,   779,     0,     0,     0,
       0,     0,   480,   481,   482,     0,   780,   781,   782,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     785,   497,   498,     0,     0,   786,   787,   788,   789,   499,
       0,     0,   500,   790,     0,   791,   501,   502,   503,   504,
     505,   792,   793,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   794,     0,     0,
       0,     0,     0,     0,     0,   795,   796,     0,     0,     0,
       0,   797,   798,     0,     0,   799,   800,     0,     0,   801,
     802,   142,     0,   143,   689,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   690,     0,
     152,   153,   154,   155,   156,   157,   691,   159,     0,   160,
       0,     0,   692,   161,   693,   694,   695,   162,   696,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,   697,   698,   170,   171,     0,   172,   699,   700,   174,
     175,     0,   176,   177,   178,   179,   180,   701,   182,     0,
     702,   184,   703,   704,   705,   706,   707,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   708,   204,     0,   205,   709,   710,   206,
       0,     0,   207,   711,   208,   712,   713,   209,     0,   210,
     714,   715,     0,   211,   212,   213,   716,   717,   718,     0,
       0,     0,     0,   719,   216,   720,     0,     0,   721,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   722,     0,   244,   245,   246,   247,   723,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,  2305,   255,     0,   256,     0,   257,
     258,   726,   260,   727,   262,   263,     0,   264,     0,   728,
     265,   266,   267,     0,   268,   729,   730,     0,   269,   270,
       0,     0,     0,   731,   272,   273,   274,   275,   732,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
     733,   281,   282,   734,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   735,     0,     0,   292,     0,   736,   293,   294,     0,
       0,     0,     0,     0,   737,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,   738,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     739,   321,   322,   323,   324,   740,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   741,   332,     0,     0,
     742,   334,   743,   335,     0,   336,   744,   745,   746,   747,
     748,   341,   342,   343,   344,   345,   346,     0,   749,   347,
     348,     0,     0,   349,   350,   351,   352,   750,   751,   752,
     353,   354,     0,   753,   754,   355,     0,   356,   357,   755,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
     756,   368,     0,   369,     0,   370,   371,   757,   373,   374,
     375,   376,   758,   759,   379,   760,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   761,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,   762,   763,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   764,     0,   765,   416,   417,   418,   419,   420,   421,
     766,   767,   424,   425,   426,   427,     0,   768,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,   769,
     770,   455,   456,     0,   457,   458,   771,   460,   461,   462,
     772,   773,   463,   464,   465,   466,   774,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   775,   474,   475,
       0,   776,   777,   778,   779,     0,     0,     0,     0,     0,
     480,   481,   482,     0,   780,   781,   782,   484,   485,   486,
     783,   487,   488,   784,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   785,   497,
     498,     0,     0,   786,   787,   788,   789,   499,     0,     0,
     500,   790,     0,   791,   501,   502,   503,   504,   505,   792,
     793,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   794,     0,     0,     0,     0,
       0,     0,     0,   795,   796,     0,     0,     0,     0,   797,
     798,     0,     0,   799,   800,     0,     0,   801,   802,   142,
       0,   143,   689,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   690,     0,   152,   153,
     154,   155,   156,   157,   691,   159,     0,   160,     0,     0,
     692,   161,   693,   694,   695,   162,   696,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,   697,
     698,   170,   171,     0,   172,   699,   700,   174,   175,     0,
     176,   177,   178,   179,   180,   701,   182,     0,   702,   184,
     703,   704,   705,   706,   707,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   708,   204,     0,   205,   709,   710,   206,     0,     0,
     207,   711,   208,   712,   713,   209,     0,   210,   714,   715,
       0,   211,   212,   213,   716,   717,   718,     0,     0,     0,
       0,   719,   216,   720,     0,     0,   721,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,   265,   266,
     267,     0,   268,   729,   730,     0,   269,   270,     0,     0,
       0,   731,   272,   273,   274,   275,   732,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,   733,   281,
     282,   734,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   735,
       0,     0,   292,     0,   736,   293,   294,     0,     0,     0,
       0,     0,   737,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   738,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,   751,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,     0,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   785,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,     0,     0,
       0,   795,   796,     0,     0,     0,     0,   797,   798,     0,
       0,   799,   800,     0,     0,   801,   802,   142,     0,   143,
     689,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   690,     0,   152,   153,   154,   155,
     156,   157,   691,   159,     0,   160,     0,     0,   692,   161,
     693,   694,   695,   162,   696,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,   697,   698,   170,
     171,     0,   172,   699,   700,   174,   175,     0,   176,   177,
     178,   179,   180,   701,   182,     0,   702,   184,   703,   704,
     705,   706,   707,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   708,
     204,     0,   205,   709,   710,   206,     0,     0,   207,   711,
     208,   712,   713,   209,     0,   210,   714,   715,     0,   211,
     212,   213,   716,   717,   718,     0,     0,     0,     0,   719,
     216,   720,     0,     0,   721,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   722,
       0,   244,   245,   246,   247,   723,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   726,   260,   727,
     262,   263,     0,   264,     0,   728,   265,   266,   267,     0,
     268,   729,   730,     0,   269,   270,     0,     0,     0,   731,
     272,   273,   274,   275,   732,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,   733,   281,   282,   734,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   735,     0,     0,
     292,     0,   736,   293,   294,     0,     0,     0,     0,     0,
     737,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,   738,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   739,   321,   322,   323,
     324,   740,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   741,   332,     0,     0,   742,   334,   743,   335,
       0,   336,   744,   745,   746,   747,   748,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,   750,   751,   752,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   755,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,   756,   368,     0,   369,
       0,   370,   371,   757,   373,   374,   375,   376,   758,   759,
     379,   760,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   761,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,   762,   763,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   764,     0,   765,
     416,   417,   418,   419,   420,   421,   766,   767,   424,   425,
     426,   427,     0,   768,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,   769,   770,   455,   456,     0,
     457,   458,   771,   460,   461,   462,   772,   773,   463,   464,
     465,   466,   774,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,   776,   777,   778,
     779,     0,     0,     0,     0,     0,   480,   481,   482,     0,
     780,   781,   782,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   785,   497,   498,     0,     0,   786,
     787,   788,   789,   499,     0,     0,   500,   790,     0,   791,
     501,   502,   503,   504,   505,   792,   793,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   794,     0,     0,     0,     0,     0,     0,     0,   795,
     796,     0,     0,     0,     0,   797,  1167,     0,     0,   799,
     800,     0,     0,   801,   802,   142,     0,   143,   689,   145,
     146,   147,   148,  1801,     0,   149,     0,     0,     0,  1802,
       0,     0,   690,     0,   152,   153,   154,   155,   156,   157,
     691,   159,     0,   160,     0,     0,   692,   161,   693,   694,
     695,   162,   696,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,   697,   698,   170,   171,     0,
     172,   699,   700,   174,   175,     0,   176,   177,   178,   179,
     180,   701,   182,     0,   702,   184,   703,   704,   705,   706,
     707,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   708,   204,     0,
     205,   709,   710,   206,     0,     0,   207,   711,   208,   712,
     713,   209,     0,   210,   714,   715,     0,   211,   212,   213,
     716,   717,   718,     0,     0,     0,     0,   719,   216,   720,
       0,     0,   721,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   722,     0,   244,
     245,   246,   247,   723,   724,   248,   249,     0,   250,   251,
     252,   725,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   726,   260,   727,   262,   263,
       0,   264,     0,   728,   265,   266,   267,     0,   268,   729,
     730,     0,   269,   270,     0,     0,     0,   731,   272,   273,
     274,   275,   732,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,   733,   281,   282,   734,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   735,     0,     0,   292,     0,
     736,   293,   294,     0,     0,     0,     0,     0,   737,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,   738,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,     0,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,     0,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,     0,     0,     0,   795,   796,     0,
       0,     0,     0,   797,   798,     0,     0,   799,   800,     0,
       0,   801,   802,   142,     0,   143,   689,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     690,     0,   152,   153,   154,   155,   156,   157,   691,   159,
       0,   160,     0,     0,   692,   161,   693,   694,   695,   162,
     696,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,   697,   698,   170,   171,     0,   172,   699,
     700,   174,   175,     0,   176,   177,   178,   179,   180,   701,
     182,     0,   702,   184,   703,   704,   705,   706,   707,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   708,   204,     0,   205,   709,
     710,   206,     0,     0,   207,   711,   208,   712,   713,   209,
       0,   210,   714,   715,     0,   211,   212,   213,   716,   717,
     718,     0,     0,     0,     0,   719,   216,   720,     0,     0,
     721,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,   265,   266,   267,     0,   268,   729,   730,     0,
     269,   270,     0,     0,     0,   731,   272,   273,   274,   275,
     732,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,   733,   281,   282,   734,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   735,     0,     0,   292,     0,   736,   293,
     294,     0,     0,     0,     0,     0,   737,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,   738,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   739,   321,   322,   323,   324,   740,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   741,   332,
       0,     0,   742,   334,   743,   335,     0,   336,   744,   745,
     746,   747,   748,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,   750,
     751,   752,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   755,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,   756,   368,     0,   369,     0,   370,   371,   757,
     373,   374,   375,   376,   758,   759,   379,   760,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   761,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,   762,
     763,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   764,     0,   765,   416,   417,   418,   419,
     420,   421,   766,   767,   424,   425,   426,   427,     0,   768,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,   769,   770,   455,   456,     0,   457,   458,   771,   460,
     461,   462,   772,   773,   463,   464,   465,   466,   774,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,   776,   777,   778,   779,     0,     0,     0,
       0,     0,   480,   481,   482,     0,   780,   781,   782,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
    1898,   497,   498,     0,     0,   786,   787,   788,   789,   499,
       0,     0,   500,   790,     0,   791,   501,   502,   503,   504,
     505,   792,   793,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   794,     0,     0,
       0,     0,     0,     0,     0,   795,   796,     0,     0,     0,
       0,   797,   798,     0,     0,   799,   800,     0,     0,   801,
     802,   142,     0,   143,   689,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   690,     0,
     152,   153,   154,   155,   156,   157,   691,   159,     0,   160,
       0,     0,   692,   161,   693,   694,   695,   162,   696,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,   697,   698,   170,   171,     0,   172,   699,   700,   174,
     175,     0,   176,   177,   178,   179,   180,   701,   182,     0,
     702,   184,   703,   704,   705,   706,   707,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   708,   204,     0,   205,   709,   710,   206,
       0,     0,   207,   711,   208,   712,   713,   209,     0,   210,
     714,   715,     0,   211,   212,   213,   716,   717,   718,     0,
       0,     0,     0,   719,   216,   720,     0,     0,   721,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   722,     0,   244,   245,   246,   247,   723,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   726,   260,   727,   262,   263,     0,   264,     0,   728,
     265,   266,   267,     0,   268,   729,   730,     0,   269,   270,
       0,     0,     0,   731,   272,   273,   274,   275,   732,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
     733,   281,   282,  2720,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   735,     0,     0,   292,     0,   736,   293,   294,     0,
       0,     0,     0,     0,   737,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,   738,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     739,   321,   322,   323,   324,   740,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   741,   332,     0,     0,
     742,   334,   743,   335,     0,   336,   744,   745,   746,   747,
     748,   341,   342,   343,   344,   345,   346,     0,   749,   347,
     348,     0,     0,   349,   350,   351,   352,   750,   751,   752,
     353,   354,     0,   753,   754,   355,     0,   356,   357,   755,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
     756,   368,     0,   369,     0,   370,   371,   757,   373,   374,
     375,   376,   758,   759,   379,   760,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   761,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,   762,   763,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   764,     0,   765,   416,   417,   418,   419,   420,   421,
     766,   767,   424,   425,   426,   427,     0,   768,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,   769,
     770,   455,   456,     0,   457,   458,   771,   460,   461,   462,
     772,   773,   463,   464,   465,   466,   774,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   775,   474,   475,
       0,   776,   777,   778,   779,     0,     0,     0,     0,     0,
     480,   481,   482,     0,   780,   781,   782,   484,   485,   486,
     783,   487,   488,   784,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   785,   497,
     498,     0,     0,   786,   787,   788,   789,   499,     0,     0,
     500,   790,     0,   791,   501,   502,   503,   504,   505,   792,
     793,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   794,     0,     0,     0,     0,
       0,     0,     0,   795,   796,     0,     0,     0,     0,   797,
     798,     0,     0,   799,   800,     0,     0,   801,   802,   142,
       0,   143,   689,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   690,     0,   152,   153,
     154,   155,   156,   157,   691,   159,     0,   160,     0,     0,
     692,   161,   693,   694,   695,   162,   696,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,   697,
     698,   170,   171,     0,   172,   699,   700,   174,   175,     0,
     176,   177,   178,   179,   180,   701,   182,     0,   702,   184,
     703,   704,   705,   706,   707,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   708,   204,     0,   205,   709,   710,   206,     0,     0,
     207,   711,   208,   712,   713,   209,     0,   210,   714,   715,
       0,   211,   212,   213,   716,   717,   718,     0,     0,     0,
       0,   719,   216,   720,     0,     0,   721,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,   265,   266,
     267,     0,   268,   729,   730,     0,   269,   270,     0,     0,
       0,   731,   272,   273,   274,   275,   732,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,   733,   281,
     282,  2771,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   735,
       0,     0,   292,     0,   736,   293,   294,     0,     0,     0,
       0,     0,   737,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   738,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,   751,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,     0,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   785,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,     0,     0,
       0,   795,   796,     0,     0,     0,     0,   797,   798,     0,
       0,   799,   800,     0,     0,   801,   802,   142,     0,   143,
     689,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   690,     0,   152,   153,   154,   155,
     156,   157,   691,   159,     0,   160,     0,     0,   692,   161,
     693,   694,   695,   162,   696,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,   697,   698,   170,
     171,     0,   172,   699,   700,   174,   175,     0,   176,   177,
     178,   179,   180,   701,   182,     0,   702,   184,   703,   704,
     705,   706,   707,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   708,
     204,     0,   205,   709,   710,   206,     0,     0,   207,   711,
     208,   712,   713,   209,     0,   210,   714,   715,     0,   211,
     212,   213,   716,   717,   718,     0,     0,     0,     0,   719,
     216,   720,     0,     0,  3609,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   722,
       0,   244,   245,   246,   247,   723,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   726,   260,   727,
     262,   263,     0,   264,     0,   728,   265,   266,   267,     0,
     268,   729,   730,     0,   269,   270,     0,     0,     0,   731,
     272,   273,   274,   275,   732,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,   733,   281,   282,   734,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   735,     0,     0,
     292,     0,   736,   293,   294,     0,     0,     0,     0,     0,
     737,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,   738,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   739,   321,   322,   323,
     324,   740,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   741,   332,     0,     0,   742,   334,   743,   335,
       0,   336,   744,   745,   746,   747,   748,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,   750,   751,   752,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   755,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,   756,   368,     0,   369,
       0,   370,   371,   757,   373,   374,   375,   376,   758,   759,
     379,   760,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   761,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,   762,   763,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   764,     0,   765,
     416,   417,   418,   419,   420,   421,   766,   767,   424,   425,
     426,   427,     0,   768,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,   769,   770,   455,   456,     0,
     457,   458,   771,   460,   461,   462,   772,   773,   463,   464,
     465,   466,   774,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,   776,   777,   778,
     779,     0,     0,     0,     0,     0,   480,   481,   482,     0,
     780,   781,   782,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   785,   497,   498,     0,     0,   786,
     787,   788,   789,   499,     0,     0,   500,   790,     0,   791,
     501,   502,   503,   504,   505,   792,   793,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   794,     0,     0,     0,     0,     0,     0,     0,   795,
     796,     0,     0,     0,     0,   797,   798,     0,     0,   799,
     800,     0,     0,   801,   802,   142,     0,   143,   689,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   690,     0,   152,   153,   154,   155,   156,   157,
     691,   159,     0,   160,     0,     0,   692,   161,   693,   694,
     695,   162,   696,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,   697,   698,   170,   171,     0,
     172,   699,   700,   174,   175,     0,   176,   177,   178,   179,
     180,   701,   182,     0,   702,   184,   703,   704,   705,   706,
     707,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   708,   204,     0,
     205,   709,   710,   206,     0,     0,   207,   711,   208,   712,
     713,   209,     0,   210,   714,   715,     0,   211,   212,   213,
     716,   717,   718,     0,     0,     0,     0,   719,   216,   720,
       0,     0,   721,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   722,     0,   244,
     245,   246,   247,   723,   724,   248,   249,     0,   250,   251,
     252,   725,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   726,   260,   727,   262,   263,
       0,   264,     0,   728,   265,   266,   267,     0,   268,   729,
     730,     0,   269,   270,     0,     0,     0,   731,   272,   273,
     274,   275,   732,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,   733,   281,   282,   734,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   735,     0,     0,   292,     0,
     736,   293,   294,     0,     0,     0,     0,     0,   737,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,   738,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,  4635,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,     0,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,     0,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,     0,     0,     0,   795,   796,     0,
       0,     0,     0,   797,   798,     0,     0,   799,   800,     0,
       0,   801,   802,   142,     0,   143,   689,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     690,     0,   152,   153,   154,   155,   156,   157,   691,   159,
       0,   160,     0,     0,   692,   161,   693,   694,   695,   162,
     696,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,   697,   698,   170,   171,     0,   172,   699,
     700,   174,   175,     0,   176,   177,   178,   179,   180,   701,
     182,     0,   702,   184,   703,   704,   705,   706,   707,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   708,   204,     0,   205,   709,
     710,   206,     0,     0,   207,   711,   208,   712,   713,   209,
       0,   210,   714,   715,     0,   211,   212,   213,   716,   717,
     718,     0,     0,     0,     0,   719,   216,   720,     0,     0,
     721,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,   265,   266,   267,     0,   268,   729,   730,     0,
     269,   270,     0,     0,     0,   731,   272,   273,   274,   275,
     732,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,   733,   281,   282,   734,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   735,     0,     0,   292,     0,   736,   293,
     294,     0,     0,     0,     0,     0,   737,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,   738,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   739,   321,   322,   323,   324,   740,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   741,   332,
       0,     0,   742,   334,   743,   335,     0,   336,   744,   745,
     746,   747,   748,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,   750,
       0,   752,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   755,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,   756,   368,     0,   369,     0,   370,   371,   757,
     373,   374,   375,   376,   758,   759,   379,   760,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   761,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,   762,
     763,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   764,     0,   765,   416,   417,   418,   419,
     420,   421,   766,   767,   424,   425,   426,   427,     0,   768,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,   769,   770,   455,   456,     0,   457,   458,   771,   460,
     461,   462,   772,   773,   463,   464,   465,   466,   774,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,   776,   777,   778,   779,     0,     0,     0,
       0,     0,   480,   481,   482,     0,   780,   781,   782,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     785,   497,   498,     0,     0,   786,   787,   788,   789,   499,
       0,     0,   500,   790,     0,   791,   501,   502,   503,   504,
     505,   792,   793,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   794,     0,     0,
       0,     0,     0,     0,     0,   795,   796,     0,     0,     0,
       0,   797,   798,     0,     0,   799,   800,     0,     0,   801,
     802,   142,     0,   143,   689,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   690,     0,
     152,   153,   154,   155,   156,   157,   691,   159,     0,   160,
       0,     0,   692,   161,   693,   694,   695,   162,   696,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,   697,   698,   170,   171,     0,   172,   699,   700,   174,
     175,     0,   176,   177,   178,   179,   180,   701,   182,     0,
     702,   184,   703,   704,   705,   706,   707,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   708,   204,     0,   205,   709,   710,   206,
       0,     0,   207,   711,   208,   712,   713,   209,     0,   210,
     714,   715,     0,   211,   212,   213,   716,   717,   718,     0,
       0,     0,     0,   719,   216,   720,     0,     0,   721,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   722,     0,   244,   245,   246,   247,   723,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   726,   260,   727,   262,   263,     0,   264,     0,   728,
     265,   266,   267,     0,   268,   729,   730,     0,   269,   270,
       0,     0,     0,   731,   272,   273,   274,   275,   732,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
     733,   281,   282,  1816,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   735,     0,     0,   292,     0,   736,   293,   294,     0,
       0,     0,     0,     0,   737,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,   738,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     739,   321,   322,   323,   324,   740,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   741,   332,     0,     0,
     742,   334,   743,   335,     0,   336,   744,   745,   746,   747,
     748,   341,   342,   343,   344,   345,   346,     0,   749,   347,
     348,     0,     0,   349,   350,   351,   352,   750,     0,   752,
     353,   354,     0,   753,   754,   355,     0,   356,   357,   755,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
     756,   368,     0,   369,     0,   370,   371,   757,   373,   374,
     375,   376,   758,   759,   379,   760,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   761,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,   762,   763,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   764,     0,   765,   416,   417,   418,   419,   420,   421,
     766,   767,   424,   425,   426,   427,     0,   768,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,   769,
     770,   455,   456,     0,   457,   458,   771,   460,   461,   462,
     772,   773,   463,   464,   465,   466,   774,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   775,   474,   475,
       0,   776,   777,   778,   779,     0,     0,     0,     0,     0,
     480,   481,   482,     0,   780,   781,   782,   484,   485,   486,
     783,   487,   488,   784,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   785,   497,
     498,     0,     0,   786,   787,   788,   789,   499,     0,     0,
     500,   790,     0,   791,   501,   502,   503,   504,   505,   792,
     793,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   794,     0,     0,     0,     0,
       0,     0,     0,   795,   796,     0,     0,     0,     0,   797,
     798,     0,     0,   799,   800,     0,     0,   801,   802,   142,
       0,   143,   689,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   690,     0,   152,   153,
     154,   155,   156,   157,   691,   159,     0,   160,     0,     0,
     692,   161,   693,   694,   695,   162,   696,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,   697,
     698,   170,   171,     0,   172,   699,   700,   174,   175,     0,
     176,   177,   178,   179,   180,   701,   182,     0,   702,   184,
     703,   704,   705,   706,   707,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   708,   204,     0,   205,   709,   710,   206,     0,     0,
     207,   711,   208,   712,   713,   209,     0,   210,   714,   715,
       0,   211,   212,   213,   716,   717,   718,     0,     0,     0,
       0,   719,   216,   720,     0,     0,   721,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,   265,   266,
     267,     0,   268,   729,   730,     0,   269,   270,     0,     0,
       0,   731,   272,   273,   274,   275,   732,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,   733,   281,
     282,  1818,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   735,
       0,     0,   292,     0,   736,   293,   294,     0,     0,     0,
       0,     0,   737,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   738,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,     0,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,     0,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   785,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,     0,     0,
       0,   795,   796,     0,     0,     0,     0,   797,   798,     0,
       0,   799,   800,     0,     0,   801,   802,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
     693,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,  1857,     0,     0,     0,     0,   215,
     216,   720,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,   265,   266,   267,     0,
     268,   729,   730,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,   738,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,  1858,   477,   478,
    1859,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,   781,   483,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,     0,     0,     0,     0,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,   801,   802,   151,     0,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,  3012,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,   527,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
    2138,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,  2139,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,  3384,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,  2440,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,   532,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,     0,   513,     0,     0,     0,     0,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,  3085,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,  3012,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,   527,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,  2138,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,  2139,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,   532,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,     0,     0,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,  3085,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,  2440,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,     0,
     513,     0,     0,     0,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,  2881,     0,     0,   150,
       0,     0,   151,   802,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   513,
       0,     0,     0,     0,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,     0,  4782,   149,     0,     0,     0,
     150,  4783,   802,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,     0,
     513,     0,     0,     0,     0,     0,     0,   142,     0,   143,
     144,   145,   146,   147,   148,  1172,     0,   149,     0,     0,
       0,   150,     0,   802,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
    1388,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,     0,     0,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,   561,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,     0,
     513,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2387,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,   561,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   513,     0,     0,     0,     0,
       0,     0,   142,     0,   143,   144,   145,   146,   147,   148,
    3084,     0,   149,     0,     0,     0,   150,     0,  3085,   151,
       0,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,     0,   513,     0,     0,     0,
       0,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,  4783,   802,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,     0,     0,
       0,     0,   142,     0,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   151,
     561,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   632,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   633,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,     0,   513,     0,     0,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,   561,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   513,     0,     0,     0,     0,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,   802,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,     0,   513,     0,     0,     0,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,  3085,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   944,   945,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,   946,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   947,     0,   264,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   948,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   949,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   950,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   951,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   952,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   953,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   513,     0,     0,     0,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,   954,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   644,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   139,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,     0,     0,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,  1441,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   644,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   139,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   513,
       0,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,  1788,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   944,
     945,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
     946,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   947,     0,   264,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   948,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   949,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   950,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   951,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   952,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,     0,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,   954,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   644,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   139,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   513,     0,     0,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,  3645,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,  1319,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   513,     0,     0,     0,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,  1320,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,     0,     0,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,  1320,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4160,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4161,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
       0,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,     0,     0,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,  4162,   250,   251,
     252,     0,     0,     0,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,     0,   263,
       0,   264,     0,     0,     0,   266,   267,     0,     0,     0,
       0,     0,     0,   270,     0,     0,     0,   271,   272,   273,
     274,   275,  4163,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,     0,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,  4164,     0,     0,
     288,     0,     0,     0,   290,   291,     0,     0,   292,  4165,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,  -327,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,     0,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,  4166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   366,   367,     0,     0,     0,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,     0,     0,
       0,     0,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,     0,     0,   405,     0,
     407,  -327,     0,   408,     0,     0,     0,   410,     0,     0,
     412,   413,     0,   414,  4167,   415,     0,     0,   416,     0,
     418,   419,   420,   421,   422,   423,   424,     0,   426,   427,
       0,   428,     0,     0,     0,     0,   430,   431,   432,     0,
       0,     0,     0,   434,     0,     0,     0,     0,     0,     0,
     437,     0,     0,   440,   441,     0,   442,     0,   444,     0,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,     0,     0,
       0,     0,   454,     0,     0,     0,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,     0,     0,     0,     0,   493,     0,     0,   494,     0,
       0,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,  -327,     0,     0,
       0,   508,     0,     0,   510,     0,   512,     0,   142,   513,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   151,  4776,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,  1051,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,   644,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,   139,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,  1217,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,   142,   513,   143,   144,   145,   146,
     147,   148,     0,     0,   149,  2210,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,  2912,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
     142,   513,   143,   144,   145,   146,   147,   148,     0,     0,
     149,  3279,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,  3650,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,  1429,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
    1430,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   644,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
    1431,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   139,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,     0,   142,
    1432,   143,   144,   145,   146,   147,   148,   843,   844,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,   845,     0,
     207,     0,   208,     0,   846,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
     847,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,   848,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   849,   240,   241,   242,
     850,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   851,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,   852,   264,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,   853,   279,     0,   280,     0,     0,     0,   854,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   644,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,   855,   299,
     300,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   856,   385,   386,   387,   857,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,   858,     0,   398,   399,   400,   401,   402,     0,   859,
     404,     0,   405,   406,   407,     0,     0,   860,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,   861,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
     862,   863,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     864,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   139,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,   865,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,   866,   495,   867,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,   142,   513,   920,   144,   145,   146,   147,   148,
     921,   844,   149,     0,     0,     0,   150,     0,     0,   151,
       0,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,   845,     0,   207,     0,   208,     0,   846,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,   847,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,   848,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,   235,   236,     0,   237,   238,   849,
     240,   241,   242,   850,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   851,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,   852,   264,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,   853,   279,     0,   280,     0,     0,
       0,   854,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     644,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,   855,   299,   300,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   856,   385,   386,   387,   922,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,   858,     0,   398,   399,   400,   401,
     402,     0,   859,   404,     0,   405,   406,   407,     0,     0,
     860,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
     861,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,   862,   863,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   864,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,   865,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,   866,   495,   867,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,  2562,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,  2563,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,   265,   266,   267,     0,   268,  2564,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,  2565,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,  1100,  1101,     0,   353,   354,     0,     0,  2566,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,  4763,   586,  4764,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,  2567,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,   142,   513,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   151,     0,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,  1673,     0,     0,  3495,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,  1674,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,   265,   266,   267,
       0,   268,  2996,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,  2997,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,  2998,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,   139,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,  2999,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,  1673,     0,     0,  4302,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,  1674,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
     265,   266,   267,     0,   268,  2996,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,  2997,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,  2998,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   139,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
    2999,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,   142,   513,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,  1673,     0,
       0,  4557,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
    1674,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,   265,   266,   267,     0,   268,  2996,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,  2997,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,  2998,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,  2999,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,  1051,   846,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   644,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   139,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
     142,   513,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,  1443,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,  1444,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,   644,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,   139,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,  1021,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,   265,   266,   267,     0,   268,  1022,  1023,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,  1024,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,   142,   513,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
    2005,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,  2006,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,   756,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,  2007,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,  2008,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,  2005,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,  2006,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,  2008,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,   142,   513,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   151,
       0,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,  1429,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,  1430,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     644,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,  2005,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,  2006,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,  4022,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,  2008,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,   142,   513,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   151,     0,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,   846,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,   644,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,   139,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,  1051,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   644,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   139,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,   142,   513,   143,   144,   145,   146,
     147,   148,  1466,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,   644,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,  2472,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   644,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   139,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
     142,   513,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,  1429,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,   644,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,   139,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   644,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   139,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,   142,   513,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,  2908,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,   139,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,  4670,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,  4671,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,   142,   513,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   151,
       0,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,   586,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,  1118,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,   142,   513,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   151,     0,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,   946,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,  1975,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,  2131,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,   142,   513,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,   946,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,  3106,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
     142,   513,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,   139,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
    3411,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,   142,   513,   143,   144,
     145,   146,   147,   148,  3419,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,  3443,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,   142,   513,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   151,
       0,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,  4333,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,   142,   513,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   151,     0,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,  1890,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,  1891,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4160,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4161,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,  -342,  -342,   229,     0,  -342,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,     0,     0,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,  4162,   250,   251,   252,     0,     0,     0,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,     0,   263,     0,   264,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4163,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4164,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4165,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
       0,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,  4166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   366,   367,     0,
       0,     0,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,     0,     0,     0,     0,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,     0,     0,   405,     0,   407,  -327,     0,   408,
       0,     0,     0,   410,     0,     0,   412,   413,     0,   414,
    4167,   415,     0,     0,   416,     0,   418,   419,   420,   421,
     422,   423,   424,     0,   426,   427,     0,   428,     0,     0,
       0,     0,   430,   431,   432,     0,     0,     0,     0,   434,
       0,     0,     0,     0,     0,     0,   437,     0,     0,   440,
     441,     0,   442,     0,   444,     0,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,     0,     0,     0,     0,   454,     0,
       0,     0,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,     0,     0,     0,
       0,   493,     0,     0,   494,     0,     0,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,  -327,     0,     0,     0,   508,     0,     0,
     510,     0,   512,     0,   142,   513,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,     0,     0,   152,   153,   154,   155,   156,   157,   158,
       0,     0,  -372,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,     0,
       0,     0,     0,   169,  4160,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,   176,   177,   178,   179,  4161,
     181,   182,     0,   183,   184,     0,     0,     0,     0,     0,
       0,   190,     0,   192,     0,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,     0,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,   228,     0,  -363,     0,   229,     0,  -363,
     231,     0,   232,   233,   234,     0,   235,   236,     0,   237,
     238,   239,   240,   241,     0,     0,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,  4162,   250,   251,   252,
       0,     0,     0,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,     0,   263,     0,
     264,     0,     0,     0,   266,   267,     0,     0,     0,     0,
       0,     0,   270,     0,     0,     0,   271,   272,   273,   274,
     275,  4163,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,     0,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,  4164,     0,     0,   288,
       0,     0,     0,   290,   291,     0,     0,   292,  4165,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
    -327,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,     0,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,  4166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     366,   367,     0,     0,     0,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,     0,
       0,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,     0,     0,   405,     0,   407,
    -327,     0,   408,     0,     0,     0,   410,     0,     0,   412,
     413,     0,   414,  4167,   415,     0,     0,   416,     0,   418,
     419,   420,   421,   422,   423,   424,     0,   426,   427,     0,
     428,     0,     0,     0,     0,   430,   431,   432,     0,     0,
       0,     0,   434,     0,     0,     0,     0,     0,     0,   437,
       0,     0,   440,   441,     0,   442,     0,   444,     0,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,     0,     0,     0,
       0,   454,     0,     0,     0,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
       0,     0,     0,     0,   493,     0,     0,   494,     0,     0,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,  -363,     0,  -327,     0,     0,     0,
     508,     0,     0,   510,     0,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,     0,     0,   152,   153,   154,   155,
     156,   157,   158,     0,     0,  -372,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,     0,     0,     0,     0,   169,  4160,     0,   170,
     171,     0,   172,     0,     0,     0,     0,     0,   176,   177,
     178,   179,  4161,   181,   182,     0,   183,   184,     0,     0,
       0,     0,     0,     0,   190,     0,   192,     0,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,     0,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   226,   227,   228,     0,  -360,     0,
     229,     0,  -360,   231,     0,   232,   233,   234,     0,   235,
     236,     0,   237,   238,   239,   240,   241,     0,     0,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,  4162,
     250,   251,   252,     0,     0,     0,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
       0,   263,     0,   264,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4163,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4164,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4165,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,     0,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
    4166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   366,   367,     0,     0,     0,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,     0,     0,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,     0,     0,
     405,     0,   407,  -327,     0,   408,     0,     0,     0,   410,
       0,     0,   412,   413,     0,   414,  4167,   415,     0,     0,
     416,     0,   418,   419,   420,   421,   422,   423,   424,     0,
     426,   427,     0,   428,     0,     0,     0,     0,   430,   431,
     432,     0,     0,     0,     0,   434,     0,     0,     0,     0,
       0,     0,   437,     0,     0,   440,   441,     0,   442,     0,
     444,     0,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
       0,     0,     0,     0,   454,     0,     0,     0,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,     0,     0,     0,     0,   493,     0,     0,
     494,     0,     0,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,  -360,     0,  -327,
       0,     0,     0,   508,     0,     0,   510,     0,   512,     0,
     142,   513,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,     0,     0,   152,
     153,   154,   155,   156,   157,   158,     0,     0,  -372,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,     0,     0,     0,     0,   169,
    4160,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,   176,   177,   178,   179,  4161,   181,   182,     0,   183,
     184,     0,     0,     0,     0,     0,     0,   190,     0,   192,
       0,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,     0,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,  4542,   231,     0,   232,   233,
     234,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4162,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
     266,   267,     0,     0,     0,     0,     0,     0,   270,     0,
       0,     0,   271,   272,   273,   274,   275,  4163,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,     0,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,  4164,     0,     0,   288,     0,     0,     0,   290,
     291,     0,     0,   292,  4165,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,  -327,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,     0,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,  4166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   366,   367,     0,     0,
       0,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,     0,     0,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,     0,     0,   405,     0,   407,  -327,     0,   408,     0,
       0,     0,   410,     0,     0,   412,   413,     0,   414,  4167,
     415,     0,     0,   416,     0,   418,   419,   420,   421,   422,
     423,   424,     0,   426,   427,     0,   428,     0,     0,     0,
       0,   430,   431,   432,     0,     0,     0,     0,   434,     0,
       0,     0,     0,     0,     0,   437,     0,     0,   440,   441,
       0,   442,     0,   444,     0,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,     0,     0,     0,     0,   454,     0,     0,
       0,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,     0,     0,     0,     0,
     493,     0,     0,   494,     0,     0,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,  -327,     0,     0,     0,   508,     0,     0,   510,
       0,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
       0,     0,   152,   153,   154,   155,   156,   157,   158,     0,
       0,  -372,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,     0,     0,
       0,     0,   169,  4160,     0,   170,   171,     0,   172,     0,
       0,     0,     0,     0,   176,   177,   178,   179,  4161,   181,
     182,     0,   183,   184,     0,     0,     0,     0,     0,     0,
     190,     0,   192,     0,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,     0,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,     0,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,  -365,   231,
       0,   232,   233,   234,     0,   235,   236,     0,   237,   238,
     239,   240,   241,     0,     0,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,  4162,   250,   251,   252,     0,
       0,     0,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,     0,   263,     0,   264,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4163,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4164,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4165,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,     0,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,  4166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   366,
     367,     0,     0,     0,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,     0,     0,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,     0,     0,   405,     0,   407,  -327,
       0,   408,     0,     0,     0,   410,     0,     0,   412,   413,
       0,   414,  4167,   415,     0,     0,   416,     0,   418,   419,
     420,   421,   422,   423,   424,     0,   426,   427,     0,   428,
       0,     0,     0,     0,   430,   431,   432,     0,     0,     0,
       0,   434,     0,     0,     0,     0,     0,     0,   437,     0,
       0,   440,   441,     0,   442,     0,   444,     0,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,     0,     0,     0,     0,
     454,     0,     0,     0,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,     0,
       0,     0,     0,   493,     0,     0,   494,     0,     0,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,  -327,     0,     0,     0,   508,
       0,     0,   510,     0,   512,     0,   142,   513,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,     0,     0,   152,   153,   154,   155,   156,
     157,   158,     0,     0,  -372,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,     0,     0,     0,     0,   169,  4160,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,   176,   177,   178,
     179,  4161,   181,   182,     0,   183,   184,     0,     0,     0,
       0,     0,     0,   190,     0,   192,     0,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,     0,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,  4675,   231,     0,   232,   233,   234,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4162,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,   266,   267,     0,     0,
       0,     0,     0,     0,   270,     0,     0,     0,   271,   272,
     273,   274,   275,  4163,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,     0,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,  4164,     0,
       0,   288,     0,     0,     0,   290,   291,     0,     0,   292,
    4165,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,  -327,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,     0,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,  4166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   366,   367,     0,     0,     0,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,     0,     0,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,     0,     0,   405,
       0,   407,  -327,     0,   408,     0,     0,     0,   410,     0,
       0,   412,   413,     0,   414,  4167,   415,     0,     0,   416,
       0,   418,   419,   420,   421,   422,   423,   424,     0,   426,
     427,     0,   428,     0,     0,     0,     0,   430,   431,   432,
       0,     0,     0,     0,   434,     0,     0,     0,     0,     0,
       0,   437,     0,     0,   440,   441,     0,   442,     0,   444,
       0,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,     0,
       0,     0,     0,   454,     0,     0,     0,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,     0,     0,     0,     0,   493,     0,     0,   494,
       0,     0,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,  -327,     0,
       0,     0,   508,     0,     0,   510,     0,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4160,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4161,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,  4733,   231,     0,   232,   233,   234,
       0,   235,   236,     0,   237,   238,   239,   240,   241,     0,
       0,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,  4162,   250,   251,   252,     0,     0,     0,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,     0,   263,     0,   264,     0,     0,     0,   266,
     267,     0,     0,     0,     0,     0,     0,   270,     0,     0,
       0,   271,   272,   273,   274,   275,  4163,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
       0,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,  4164,     0,     0,   288,     0,     0,     0,   290,   291,
       0,     0,   292,  4165,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,  -327,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,     0,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,  4166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   366,   367,     0,     0,     0,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,     0,     0,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
       0,     0,   405,     0,   407,  -327,     0,   408,     0,     0,
       0,   410,     0,     0,   412,   413,     0,   414,  4167,   415,
       0,     0,   416,     0,   418,   419,   420,   421,   422,   423,
     424,     0,   426,   427,     0,   428,     0,     0,     0,     0,
     430,   431,   432,     0,     0,     0,     0,   434,     0,     0,
       0,     0,     0,     0,   437,     0,     0,   440,   441,     0,
     442,     0,   444,     0,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,     0,     0,     0,     0,   454,     0,     0,     0,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,     0,     0,     0,     0,   493,
       0,     0,   494,     0,     0,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,  -327,     0,     0,     0,   508,     0,     0,   510,     0,
     512,     0,   142,   513,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,     0,
       0,   152,   153,   154,   155,   156,   157,   158,     0,     0,
    -372,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,     0,     0,     0,
       0,   169,  4160,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,   176,   177,   178,   179,  4161,   181,   182,
       0,   183,   184,     0,     0,     0,     0,     0,     0,   190,
       0,   192,     0,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,     0,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,     0,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,  -346,   231,     0,
     232,   233,   234,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4162,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,   266,   267,     0,     0,     0,     0,     0,     0,
     270,     0,     0,     0,   271,   272,   273,   274,   275,  4163,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,     0,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,  4164,     0,     0,   288,     0,     0,
       0,   290,   291,     0,     0,   292,  4165,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,  -327,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,     0,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,  4166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   366,   367,
       0,     0,     0,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,     0,     0,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,     0,     0,   405,     0,   407,  -327,     0,
     408,     0,     0,     0,   410,     0,     0,   412,   413,     0,
     414,  4167,   415,     0,     0,   416,     0,   418,   419,   420,
     421,   422,   423,   424,     0,   426,   427,     0,   428,     0,
       0,     0,     0,   430,   431,   432,     0,     0,     0,     0,
     434,     0,     0,     0,     0,     0,     0,   437,     0,     0,
     440,   441,     0,   442,     0,   444,     0,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,     0,     0,     0,     0,   454,
       0,     0,     0,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,     0,     0,
       0,     0,   493,     0,     0,   494,     0,     0,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,  -327,     0,     0,     0,   508,     0,
       0,   510,     0,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4160,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4161,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
       0,   231,     0,   232,   233,   234,     0,   235,   236,     0,
     237,   238,   239,   240,   241,     0,     0,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,  4162,   250,   251,
     252,     0,     0,     0,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,     0,   263,
       0,   264,     0,     0,     0,   266,   267,     0,     0,     0,
       0,     0,     0,   270,     0,     0,     0,   271,   272,   273,
     274,   275,  4163,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,     0,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,  4164,     0,     0,
     288,     0,     0,     0,   290,   291,     0,     0,   292,  4165,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,  -327,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,     0,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,  4166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   366,   367,     0,     0,     0,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,     0,     0,
       0,     0,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,     0,     0,   405,     0,
     407,  -327,     0,   408,     0,     0,     0,   410,     0,     0,
     412,   413,     0,   414,  4167,   415,     0,     0,   416,     0,
     418,   419,   420,   421,   422,   423,   424,     0,   426,   427,
       0,   428,     0,     0,     0,     0,   430,   431,   432,     0,
       0,     0,     0,   434,     0,     0,     0,     0,     0,     0,
     437,     0,     0,   440,   441,     0,   442,     0,   444,     0,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,     0,     0,
       0,     0,   454,     0,     0,     0,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,     0,     0,     0,     0,   493,     0,     0,   494,     0,
       0,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,  -327,     0,     0,
       0,   508,     0,     0,   510,     0,   512,     0,   142,   513,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,     0,     0,   152,   153,   154,
     155,   156,   157,   158,     0,     0,  -372,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,     0,     0,     0,     0,   169,  4160,     0,
     170,   171,     0,   172,     0,     0,     0,     0,     0,   176,
     177,   178,   179,  4161,   181,   182,     0,   183,   184,     0,
       0,     0,     0,     0,     0,   190,     0,   192,     0,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
       0,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,     0,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,     0,   231,     0,   232,   233,   234,     0,
     235,   236,     0,   237,   238,   239,   240,   241,     0,     0,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
    4162,   250,   251,   252,     0,     0,     0,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,     0,   263,     0,   264,     0,     0,     0,   266,   267,
       0,     0,     0,     0,     0,     0,   270,     0,     0,     0,
     271,   272,   273,   274,   275,  4163,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,     0,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
    4164,     0,     0,   288,     0,     0,     0,   290,   291,     0,
       0,   292,  4165,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,  -327,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,     0,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,  4166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   366,   367,     0,     0,     0,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,     0,     0,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,     0,
       0,   405,     0,   407,  -327,     0,   408,     0,     0,     0,
     410,     0,     0,   412,   413,     0,   414,  4167,   415,     0,
       0,   416,     0,   418,   419,   420,   421,   422,   423,   424,
       0,   426,   427,     0,   428,     0,     0,     0,     0,   430,
     431,   432,     0,     0,     0,     0,   434,     0,     0,     0,
       0,     0,     0,   437,     0,     0,   440,   441,     0,   442,
       0,   444,     0,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,     0,     0,     0,     0,   454,     0,     0,     0,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,     0,     0,     0,     0,   493,     0,
       0,  4545,     0,     0,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
    -327,     0,     0,     0,   508,     0,     0,   510,     0,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,     0,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,     0,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,     0,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,     0,   231,     0,   232,
     233,   234,     0,   235,   236,     0,   237,   238,   239,   240,
     241,     0,     0,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,     0,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,     0,   263,     0,   264,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
       0,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   366,   367,     0,
       0,     0,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,     0,     0,     0,     0,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,     0,     0,   405,     0,   407,     0,     0,   408,
       0,     0,     0,   410,     0,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,     0,   418,   419,   420,   421,
     422,   423,   424,     0,   426,   427,     0,   428,     0,     0,
       0,     0,   430,   431,   432,     0,     0,     0,     0,   434,
       0,     0,     0,     0,     0,     0,   437,     0,     0,   440,
     441,     0,   442,     0,   444,     0,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,     0,     0,     0,     0,   454,     0,
       0,     0,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,     0,     0,     0,
       0,   493,     0,     0,   494,     0,     0,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,     0,     0,
     510,     0,   512,     0,     0,   513
};

static const yytype_int16 yycheck[] =
{
       6,   598,   929,   576,   672,   949,   950,   597,   598,  1044,
     621,    20,  1221,    19,   640,  1319,   960,    23,  1045,  1951,
    1952,    30,  1150,  1221,  1637,   526,   640,    33,    37,     6,
    1601,  1785,  2121,  1122,    40,  2121,   997,    43,   972,  1365,
    1469,   739,    48,  1168,  1599,  1469,   835,  1633,  1634,    55,
    1449,   543,   544,   545,   680,   547,  1319,   549,  2555,  2405,
     552,     4,   554,   997,   692,  1243,  2616,  1286,  2444,  2226,
    1192,   970,  3044,  1251,   128,  2544,  2573,  2574,  3364,  1346,
    2888,  2238,  2367,  2799,   560,  2677,  2953,  1159,  1373,  3095,
    1861,  1016,  2119,    99,    23,   541,   837,   601,  2193,   998,
     604,   560,  2119,  3090,  2329,  2121,  1049,  2239,  1049,  2193,
     134,  2514,  1936,  3633,  2582,   591,  2962,   123,  2517,   125,
    2466,   127,   128,   129,  3159,  3561,  3045,  2526,  3245,  2102,
    1252,  1253,   591,    18,  1256,  1257,  1258,  1259,   806,  1261,
    1262,  1263,  1264,  1265,  1266,  1267,  1268,  2584,   125,  3451,
     127,  2588,    13,    17,    18,  1080,   666,  1480,  2509,   669,
      13,    20,  2599,   904,  1569,  2732,  2193,   795,   796,   797,
      99,  1579,    18,    21,  2611,  3183,  2193,  1500,    60,   807,
     681,   682,   683,    75,    26,  1508,  1509,  2684,  2685,    20,
     118,    36,    17,    18,  3175,   116,    62,    26,    17,    18,
     676,    20,  3012,  2729,  2730,    13,   132,    13,   132,  2735,
    1950,  2737,    22,  3023,   136,    83,  1624,    20,    29,    32,
      20,    17,    18,    17,    18,    36,    36,  2209,  2573,  2574,
     198,    83,   168,   132,    17,    18,   162,    53,   162,    72,
      50,   136,  2323,   196,    22,    17,    18,    38,   156,   999,
      87,    61,    62,   156,   322,   156,   181,  2180,    36,  4096,
    1039,  1040,   275,   162,    26,    49,  2093,  2989,  3710,    17,
      18,  3020,    50,    17,    18,   215,  2111,   162,    36,    11,
      22,   374,   378,    61,    62,   376,    17,    18,    58,   137,
      45,  4394,    65,    17,    18,   372,   376,   132,   402,   181,
    1079,   233,   429,   185,    89,   255,   145,   416,   310,   237,
      70,   152,  3748,  3749,   196,   463,  3752,   134,    84,    61,
      62,   258,   244,    38,   454,   483,   137,   373,   255,   434,
      13,   162,  3673,    24,  4405,  3771,    13,   233,  3816,  2684,
    2685,   162,  3778,  3629,  2317,   133,  2875,   839,    21,   198,
      12,   369,    17,    18,   233,   401,   275,   833,    42,   561,
    1579,   229,   443,   231,  2715,    65,  2717,   532,   405,   289,
     551,   384,   551,   196,   555,    13,   555,   561,   198,   593,
      17,    18,    17,    18,    17,    18,    17,    18,    17,    18,
    1063,  1064,   260,   526,   216,   362,    72,  3917,   240,   248,
      36,   172,     9,   196,   221,  1624,   561,   181,   629,   630,
      90,   240,   233,   292,   523,   198,    66,  1008,    17,    18,
     310,   162,   424,  1014,  1015,    32,    62,   560,   219,   220,
     201,   251,   112,  2057,  2577,   656,  1109,    75,   619,   261,
     619,   655,  2971,   524,   326,   412,  2693,  4518,   368,   614,
     198,    17,    18,   272,   138,   129,   162,   475,    66,   661,
    1158,   284,   250,   146,   137,   384,  1039,  1040,   577,   146,
     654,   133,   509,  3493,  1172,   292,   318,   531,   240,   429,
    2462,   377,   173,   588,    17,    18,   990,  3828,   327,   318,
      68,  2523,   292,  1282,    21,   195,   654,  1524,  1442,   501,
     425,   628,   429,  2881,   219,   220,   560,   292,  2491,  3355,
     619,   565,  4264,  3359,   662,   561,   620,   191,  3996,   383,
     452,  3999,   386,   460,  3960,   531,   656,   533,  2895,  2896,
    2897,   196,   367,  3969,   275,   384,   365,   591,    17,    18,
    3881,  1042,   633,   425,   550,   219,   425,   388,  2899,  2900,
    2577,  4654,   310,   633,   560,   561,   318,  3993,  2531,   565,
    2577,   567,  3998,   656,   383,    53,   662,   386,   508,   275,
      17,    18,  4409,  1972,   580,  1474,   519,  1245,  1477,   656,
     593,  3867,  1481,  1093,  1483,   591,   654,   383,  3304,   383,
     386,   597,   386,  3090,   364,  3405,   351,  1338,  2693,  3901,
     383,   607,  1536,   386,    17,    18,   256,  3417,  2984,  2693,
     137,   383,  1511,  1512,   386,   289,  1835,   465,   194,  2635,
     626,  1319,   676,  3433,  3434,   568,  1569,  1255,  1569,   429,
     151,   452,  1936,  3668,   640,   383,   642,  3447,   386,   383,
    3896,   478,   386,   459,  1272,  3142,  4398,  4089,   256,   655,
    3366,   425,   383,  3402,   660,   386,   662,   233,   601,   383,
     666,   604,   386,   669,   437,   608,  2693,   673,   674,   429,
     676,  3393,  1413,  1936,   680,   628,  2693,   599,   655,   604,
    1623,   687,  1623,  1608,   416,  2093,   622,  2660,   656,  1135,
    1136,  1813,  2665,   501,   368,   501,  1437,   196,   619,   532,
    2673,  2674,  1824,    75,   599,  1827,  2679,   536,   636,  2032,
     360,  2119,   523,   572,   414,  1161,  4018,   625,   383,  2800,
    1346,   386,   625,  1169,   625,  1171,   572,  4029,  2468,  2556,
    3597,   660,  2714,   739,   660,  1807,   660,  1183,  1184,  1185,
    2575,  3749,   594,   628,   555,  1191,   383,   613,   383,   386,
     383,   386,   383,   386,   383,   386,  1506,   386,  4060,   572,
     628,   660,   654,  2686,   575,    17,    18,  3317,   574,  2174,
     561,  3888,  2180,   637,   656,   660,    17,    18,  1557,   833,
     834,   591,  1292,   642,   383,  2193,  1914,   386,  1414,  3708,
    1579,   523,   621,   654,   800,   659,   802,  3142,   609,   647,
    1414,   654,  3783,   606,    17,    18,  1310,  3158,  4328,   654,
     606,   642,   637,   591,   656,  3661,  3662,   383,   637,   585,
     386,   827,   828,   829,   830,   831,   832,   833,   834,   660,
     836,   837,    41,   633,   618,  1624,   842,   656,   616,   660,
     656,   637,   642,   637,   628,   577,   561,   129,  3883,   591,
     383,   828,  1478,   386,   637,   832,   532,  2412,  1368,   836,
     656,   655,   656,   656,  1478,   637,  3009,  4208,    17,    18,
      17,    18,   655,   879,  2093,   525,   654,  1387,    17,    18,
      17,    18,   656,   655,   656,   626,   892,   619,  2820,   637,
    1394,   541,  2516,   637,   594,   949,  3143,   951,   904,   905,
     954,   955,  3712,   909,   383,  4246,   637,   386,   656,   191,
     584,   655,   656,   637,    17,    18,  2529,   971,  3938,   660,
     626,    17,    18,   501,   655,   656,    17,    18,  2960,  2961,
     194,  2863,   656,   541,  3310,  3313,   383,   219,   465,   386,
    2923,    17,    18,   949,   119,   951,  3349,   122,   954,   955,
     150,    17,    18,  3320,   660,   898,  3355,  1458,  3427,  4711,
    3359,  2180,   483,   892,   181,   971,  1539,  1540,  1541,   233,
     383,   459,   637,   386,  2193,   274,   905,  4413,  3324,  4415,
     909,   655,  3009,  1573,   634,  3552,   129,    17,    18,    73,
     655,  3080,  3009,   492,  3080,  3431,  4516,    17,    18,  4255,
     637,  4257,   637,   201,   637,  1631,   637,   289,   637,   274,
    1016,  3406,  3363,  3481,  1958,  4111,   129,  1041,   655,   656,
     655,   656,   655,   656,  3550,   656,   655,   656,  2599,   605,
     841,    91,  1730,  3559,  1978,   291,    17,    18,   637,  1045,
      17,    18,   401,  4345,   281,  3482,   418,   990,  3143,   992,
     365,    17,    18,  3026,  3186,  3028,  4358,   656,   533,  3143,
      17,    18,  3035,  1069,  3080,  2836,  2027,  2891,    17,    18,
    2499,   637,  2501,  2502,  1080,   550,  3049,  2501,  2502,   201,
    4086,  4383,   492,  3056,  3057,   136,   368,  1093,    34,   277,
     656,   199,   286,  2027,   399,   906,  3069,  3070,  3071,   111,
    1841,  2062,  3075,  3076,   637,   384,   817,   648,    48,  1115,
    1116,  1117,  1118,   184,   655,  4412,  3143,  2384,   674,  2018,
     198,   134,  2211,   656,   292,  3350,  3143,   216,  2062,   366,
     374,   383,  2031,   654,   386,  2034,  2035,   658,  3111,  2424,
    1069,  2263,   383,   642,   189,   386,   289,   237,  2556,   368,
    1626,   345,  1158,   374,    17,    18,    73,  1898,   637,    17,
      18,   492,  2340,  4150,  3731,  3732,  1172,  1626,    12,  2577,
     383,  3738,   261,   386,  3741,  3742,   289,   656,   374,   551,
    1234,  1922,  1923,   242,  4470,    17,    18,  2510,  4284,  1118,
     637,  3758,   251,   244,   328,   451,   492,   275,  1826,  2953,
      17,    18,   561,  2128,   576,  3772,   917,  3733,   425,   656,
    3736,  3778,  3779,  3780,  3781,  1221,   631,  1271,   416,   264,
    2663,  2346,  2347,   198,   637,   368,    53,   209,  1234,    17,
      18,  2174,   642,  2174,   383,  2444,   383,   386,  1936,   386,
    3766,  3767,  3768,   656,   383,   374,   383,   386,  3774,   386,
     223,   275,   662,   170,   159,   368,  3782,   374,  1831,   108,
     374,   429,   561,   129,   169,  1271,  1320,  2339,  3241,   237,
    1276,    17,    18,   147,    20,   831,   216,  2349,  2686,   292,
     383,  4164,  4165,   386,   472,  2693,  1292,   383,  3724,   397,
     386,   491,   383,   261,   416,   386,   367,  2852,  2420,   281,
     164,   385,   584,  3698,  2093,   251,   621,   383,    17,    18,
     386,   642,    26,  1319,  1320,    17,    18,   383,  2527,   364,
     386,   530,  1376,    17,    18,   191,   535,   626,   274,  2527,
     389,   662,  1338,  1843,    17,    18,  1909,  2556,   532,   548,
    1346,   605,    17,    18,   553,  1351,   642,  1353,  1852,   654,
    1356,   564,   364,   383,  1982,   162,   386,   555,  4655,  4656,
     384,   626,  1368,   383,   424,   143,   386,  1310,    17,    18,
    1376,   627,   581,    17,    18,   212,   240,   656,    17,    18,
     158,  1387,  1388,   358,  3541,   637,  4253,   604,  4375,  4376,
     565,  2180,   500,   568,   130,   351,   637,    17,    18,    17,
      18,   452,   383,   655,  2193,   386,   383,  1413,  1414,   386,
     483,  1417,   656,   129,  1357,   656,  1926,   383,   374,  1425,
     386,   258,  1428,   289,   637,   559,   383,  1356,   647,   386,
    3715,  1437,   483,   555,   383,   656,   561,   386,     9,   656,
     284,   584,  1448,  1449,   654,    17,    18,   398,  3019,  3020,
     164,  1394,   586,  1459,  1460,  1461,  1462,  1463,  1464,  1388,
     656,  1937,   483,  1469,  4272,   633,   340,  2686,   385,  1475,
    1476,   584,  1478,  4460,  2693,   191,  1482,   382,  1937,    17,
      18,   172,  1459,  1460,  1461,    54,  1463,  4005,   637,  4205,
     637,   503,   438,    17,    18,   446,    65,  1503,   637,  1476,
     637,   365,   368,   219,   198,  1482,   488,   656,   579,   656,
     201,  1454,  2941,   249,  4800,  4107,  4108,   656,  4490,   656,
     383,   628,  1576,   386,   595,   383,   240,   656,   386,   654,
      83,   149,   492,  1462,   637,  1464,   476,   364,  1481,   656,
     136,   637,   656,  2487,   582,  3921,   637,   384,   599,   656,
      13,   383,  1558,   656,   386,  2683,   561,    17,    18,   532,
     656,   637,  4112,  2189,    13,   656,   383,  2068,   606,   386,
    1576,   637,  1626,   289,  1503,  2189,  2843,  2844,  2845,   483,
     656,   654,  3025,    22,   229,  1591,   231,  2891,   561,   655,
    1596,  1597,    81,   483,  4063,   383,   655,    36,   386,   483,
     483,  3009,  1608,   654,   318,    17,    18,   637,  3051,  3052,
      13,    50,    13,    17,    18,    17,    18,   637,   189,   405,
    1626,   477,    61,    62,   483,  1631,   656,  2716,  2891,  1558,
     361,   362,   459,   654,  1640,   655,  1642,   383,  2816,  1582,
     386,    17,    18,  2969,   115,   133,  4164,  4165,   244,   654,
     606,   365,   368,  4150,   483,   560,   637,  3814,   364,   129,
     637,   242,  1591,   628,   491,  4548,  4549,  2876,  1597,   555,
     251,   637,   536,  4475,   383,   656,  4478,   386,  2876,   656,
     637,   383,   642,   146,   386,    17,    18,   240,   637,   383,
     656,   656,   386,    17,    18,   431,     0,   146,  3876,   656,
     383,   172,   662,   386,  2648,   656,   195,   656,   383,    17,
      18,   386,   281,   642,  2455,  2343,  4062,  4093,   584,    17,
      18,   191,  3900,   509,  1730,  1731,    17,    18,   240,    83,
     201,   251,   654,  3288,   383,  3143,   147,   386,   444,   383,
     662,  2869,   386,   146,   383,   146,   411,   386,   237,   219,
     654,   271,    17,    18,    17,    18,   628,   621,  2384,    17,
      18,   654,   250,   383,   654,   383,   386,  2556,   386,   662,
     654,   654,   261,   648,   637,   649,   650,   651,   652,   637,
     655,   610,   611,  3404,   656,  1791,   198,  3408,  3409,  2235,
    1844,   642,   656,   656,  2240,   654,    17,    18,   656,   658,
     241,   172,   538,  4321,  4322,   637,   359,  2253,   389,    17,
      18,   383,   365,  4464,   386,  4466,    40,   258,   129,   289,
     637,   132,   536,   655,    48,   654,  3799,  1833,  1834,   270,
    2456,  3402,  4634,    17,    18,  1841,   606,  1843,  1844,    17,
      18,  2287,  2456,  3597,   212,   383,  3055,   551,   386,   637,
    1856,   555,   129,   365,   133,  1861,   452,  3055,   492,   383,
    1866,   613,   386,  1869,   616,    17,    18,   655,   584,   662,
    1876,  1877,  3845,  1879,    18,   229,   232,   231,  4375,  4376,
     191,   564,   435,  1937,  3236,   655,   656,   483,  3240,    17,
      18,   637,  1898,    17,    18,  1901,   212,  2686,   368,  1905,
     452,  1955,   237,  2493,  2693,  1834,   260,   621,   219,  1852,
    2356,  3482,  4430,   429,   191,   237,  1922,  1923,  1924,  1925,
    1926,    17,    18,   383,  3143,   414,   386,  4445,   637,   340,
    1936,  1937,    17,    18,   450,   637,  1942,  1943,  1944,   655,
      17,    18,   656,   637,  3343,   416,   655,  1876,  1877,  1955,
    1879,    17,    18,   655,   637,    17,    18,   655,   656,    17,
      18,  2888,   637,  4460,    17,    18,  1972,   237,    17,    18,
     486,   383,  1901,   232,   386,  2936,  1905,  1920,   289,   383,
     655,   383,   386,   536,   386,   141,    81,  1993,   637,    17,
      18,   655,   656,   637,  4512,  1924,  1925,   212,   637,   378,
      17,    18,  2936,   599,   248,   551,   655,   383,   642,   555,
     386,   655,   289,  1942,  1943,  1944,   655,   637,  4536,   637,
      17,    18,    49,  2967,   536,  3351,   467,  2033,   662,   184,
    4548,  4549,    17,    18,   198,   655,   589,  3162,   611,    17,
      18,    17,    18,  2049,    20,  1988,   555,   491,  2947,   558,
    2056,   383,    17,    18,   386,    20,   602,   368,   654,   383,
    2066,  2067,   386,  2069,  2070,   637,  3191,  3192,   621,    61,
      62,  4044,  4045,  4046,  3695,   383,    13,   502,   386,    17,
      18,    73,   471,   655,   555,   383,   502,  3212,   386,  2066,
    2067,   368,   383,   655,   656,   386,   537,  4615,   292,   637,
     195,   655,  3230,   660,  2033,  3314,   577,  4625,   555,   621,
     655,   656,   558,   637,   584,  3701,  3702,   655,   383,   662,
     383,   386,  2128,   386,   380,   383,   276,  2056,   386,   279,
    2871,   655,   655,   656,   600,  2078,    18,  2191,   555,    26,
      33,   572,   237,  2197,  2087,  2088,  3552,   499,   619,  4667,
     523,  4669,   591,  3362,   654,  2098,  2099,  2100,  2101,   195,
    2103,  2104,   383,   552,  3362,   386,   261,   136,     6,   558,
      17,    18,  2226,   612,   613,   383,  4694,   637,   386,   655,
     656,   655,   656,  2189,  2238,  2191,  4704,   654,  4706,   654,
    4708,  2197,    85,  2891,   656,   655,    83,  2203,   654,   383,
    2206,   198,   386,   654,  4722,   383,   361,   362,   386,   146,
     561,  4729,   367,   602,    83,   712,   713,  2843,  2844,  2845,
    2226,   654,   160,   536,   606,   637,  4744,  4745,    36,   177,
     619,   383,  2238,   637,   386,   637,   647,   648,   649,   650,
     651,   652,  4760,  4761,   606,   597,   105,  4765,   654,  2822,
     415,   655,   662,   655,    62,   383,   483,   654,   386,   383,
      20,   637,   386,   654,   491,   147,   654,   160,   654,  2895,
    2896,  2897,   606,   584,   656,   244,   426,   654,  2332,   655,
     662,  2895,  2896,  2897,   221,    18,   471,   383,   640,   786,
     386,   654,  4224,   654,   656,   182,  3424,   654,   383,   654,
     662,   386,   381,   398,   654,   637,   383,   584,  2362,   386,
     654,   119,  1339,   637,   122,  1342,  3077,   383,  1345,   414,
     386,   383,   130,   655,   386,   383,  2332,   654,   386,   637,
     383,   655,  3738,   386,   383,  3741,  3742,   386,   551,   637,
     148,   655,   656,   572,  3105,   105,   637,   655,   654,   846,
     210,  2357,  3758,   240,  3143,   383,  2362,   655,   386,   752,
     229,   654,   231,  3307,   655,  2811,   383,   655,   656,   386,
     655,   656,   637,   654,   637,  3804,  3501,   233,  2384,   637,
    3804,   774,   241,   610,   611,  3346,   383,    17,    18,   386,
     655,   260,   655,   115,   787,   788,   656,   655,   383,   258,
     654,   386,   162,   147,   654,   383,   654,   383,   386,   654,
     386,   270,  3346,  2419,   147,   654,   637,   654,   383,  3628,
      13,   386,   655,   656,   579,   655,   656,   654,   654,   637,
    3628,   318,   614,   615,   655,   617,   196,   619,  2444,  3528,
     595,   249,  2448,  3033,    13,   383,   374,   655,   386,  2455,
    2456,   654,   212,   637,   147,   315,   316,   217,   340,   637,
     320,   321,   654,  2469,   654,  2471,   654,  4556,   654,  4555,
     374,   655,   359,   654,    12,    44,    51,   655,   365,   655,
     656,   241,   654,   452,  4457,   637,   654,  2493,   248,  2543,
    2544,   654,   351,  2499,   654,  2501,  2502,   654,   258,  4253,
     222,    26,   509,   655,  4075,  4076,    62,   655,   656,   637,
     270,  3720,  3013,   637,   483,   275,   655,   656,   411,   654,
    3021,  2527,  3720,   654,   284,   654,  2469,   655,   654,    98,
    2536,   655,   654,  2539,   103,  3027,   383,  2543,  2544,   386,
     433,   637,  3569,   655,   656,   353,   654,  3039,   654,  3041,
    3042,   654,   637,   146,  1051,   655,   656,   654,    83,   655,
     637,  3053,  2539,   119,   655,   656,   122,   654,  4201,  4202,
     655,   637,    61,    62,   130,   637,   469,   115,   655,   637,
     517,   518,   654,   520,   637,   522,   655,   656,   637,   655,
     654,   351,   148,   655,   654,   133,   340,   655,   655,   656,
     537,   655,   655,    65,   655,   656,   655,   340,   467,   637,
    4223,   654,   494,   495,   374,  1128,  1129,  1130,   286,    81,
     637,   654,  2628,   654,   384,   654,  3930,   655,   221,    20,
     599,    93,  1145,   654,   172,   528,   192,  2643,   655,   164,
     637,  2074,  2075,   654,    86,   654,    88,   340,   654,   536,
     654,  2657,   637,  3414,   655,   656,   416,   182,  2091,   637,
     654,   637,    51,   201,  1177,   655,   656,  1180,   390,   656,
     655,   654,   637,   654,  3978,  2108,  2109,   655,   537,   401,
      65,   655,   656,   654,   253,   654,   408,  3448,  1201,  1202,
     132,   499,  1205,   249,  3320,   654,    81,   654,  3459,   637,
     654,  3462,   654,  2709,  2710,  2711,  3320,   467,    93,  1222,
    1223,   654,   154,   582,   105,   240,  4349,   564,  2661,  2662,
    4353,  2664,   654,  2666,  2667,  2668,  2669,  2670,  2671,  2672,
     654,   491,  2675,   195,   621,  2678,   654,   606,   200,  2682,
     655,   656,  2175,  2176,  2177,  2178,   654,   285,   190,   654,
     494,   495,  3342,  1877,  3200,  1879,    60,  4322,   327,   654,
     568,   494,   495,   645,   646,   647,   648,   649,   650,   651,
     652,   162,   655,   656,   381,   237,   374,   537,   189,   198,
    2709,  2710,  2711,   655,   656,   507,   374,  4719,   477,   597,
     637,   202,    83,   318,   350,   593,     6,   353,   649,   261,
     659,   494,   495,   194,   662,   196,  3252,   655,   656,   491,
     195,   655,   656,   655,   656,   200,   662,    83,  1942,  1943,
    1944,   212,   502,   392,   655,   656,   217,   655,   656,   171,
    2836,    97,  2838,   593,   359,   654,  2842,  2843,  2844,  2845,
     365,   275,   233,   655,   656,  2851,   606,   129,   196,    59,
     241,   551,   237,   264,   532,   266,   509,   248,   286,   147,
     655,   656,   655,   656,  2870,  2871,   626,   258,   628,  4801,
    2876,   655,   656,   164,   532,   431,   261,   181,   416,   270,
     602,   185,   642,   129,   275,  2891,   132,  4520,  4521,  2895,
    2896,  2897,   196,   284,   163,   655,   656,   196,   166,   659,
     660,    92,  2908,   647,   648,   649,   650,   651,   652,   191,
     655,   656,   645,   646,   647,   648,   649,   650,   651,   652,
     105,   656,  2851,   375,   517,   518,   519,   520,   521,   522,
     656,  4053,   147,   547,   202,  2941,   398,   219,  3430,   655,
     150,   162,   511,   132,   537,   191,   118,   358,  3538,   240,
     392,   489,   414,   646,   647,   648,   649,   650,   651,   652,
     351,     6,    57,   251,   661,  2908,   654,  4095,   655,   656,
       4,  4536,    67,   219,   655,   656,   117,  2983,  2984,   548,
     127,   655,   656,   374,   482,   523,   254,    82,   655,   656,
    3044,   655,   656,   384,   436,   655,   656,   263,   266,    94,
      95,    96,   413,    17,    18,   656,  3012,   289,   655,   656,
     619,   536,   568,  4222,   552,  3024,  3022,  3023,   113,   655,
     656,  3030,   326,  3029,  4222,   416,   296,   297,   251,   414,
     655,   656,   655,   656,   655,   656,   251,   398,  3044,  3045,
      58,   597,   312,   289,  3050,  3054,   444,  3991,   177,  3055,
     512,  3060,   340,   118,  2983,   230,   241,  3066,  3067,  3065,
     655,   656,   156,   157,   655,   656,   230,   129,   359,   656,
     132,  3077,   338,   258,   365,   656,   467,   662,  3084,  3085,
     227,   619,  3846,  3847,  3090,   270,   368,   355,  3031,  3032,
    3096,  1209,  1210,    73,  3100,    13,   621,  4225,   364,  3105,
     491,  4128,  4667,   625,  4669,   655,  3679,  4134,   105,   123,
     124,   125,   126,   127,   655,   294,  3059,   296,   297,  3096,
     146,   425,   368,  3326,  3327,   340,    10,   512,   656,   191,
     662,   656,   594,   312,  1647,  3141,  3065,  3281,  3282,  4704,
    3607,  3608,   105,   655,   435,   655,   537,  3090,   147,   655,
    2583,  3157,   362,  2586,  2587,   662,  2589,   219,   654,  2592,
    2593,   427,   274,  2596,   129,   662,   351,   132,  2601,  4297,
     374,   441,   442,  2606,  2607,  2608,  2609,  2610,   656,  4744,
    4745,  2614,  2615,   330,  2617,   164,   656,   334,   661,   374,
    2623,  2624,  2625,  2626,   341,   286,  2629,  2630,   286,  2632,
      38,   286,   593,   286,    51,  3148,   494,   495,   286,   594,
     224,   225,   226,   227,   605,   606,   286,   656,   428,  1732,
     430,   656,   642,  1736,   551,   129,   191,   289,   132,   654,
     228,   642,   643,   644,   329,   626,   399,   628,   281,   656,
    3246,   656,   129,   572,   241,   536,   656,  1760,  3254,  4377,
     572,   642,   347,   398,   219,   656,   642,   523,  2691,   196,
    4469,   258,   441,   442,   655,   656,   656,    73,   659,   660,
     532,  4469,   656,   270,   656,  3329,   423,   251,   241,   494,
     495,   649,   467,   252,   122,   549,   186,   191,  3294,   196,
     656,   129,   171,   532,  3884,   258,   403,  3870,   589,   506,
     142,    34,   584,   374,   191,    83,   368,   270,  3314,  3315,
     656,  3254,  3318,    91,  3320,   219,   330,   655,   332,   333,
     334,   402,   656,  3329,   289,   600,    38,   341,     7,  3335,
     621,   632,   219,   605,   481,   656,  3342,  3343,   584,   198,
     118,   340,   229,   655,   231,  4272,   184,   655,   655,   655,
     655,   649,   537,   191,   351,   655,  3362,   645,   646,   647,
     648,   649,   650,   651,   652,   656,   461,   198,   655,   383,
     655,  3377,   386,  3427,   642,   643,   644,   374,  3384,   656,
     654,   219,   220,   648,   479,   289,   164,  4414,   351,  3398,
     593,   492,   655,   561,   655,   655,   655,  4008,   655,  3405,
    4344,   656,   289,   368,   656,  3348,   655,   655,  3414,   423,
     122,  3417,   655,   654,   147,   129,   654,   129,   652,  4363,
     655,  3427,   654,   656,   561,  3431,   561,  3433,  3434,   572,
     645,   646,   647,   648,   649,   650,   651,   652,  3802,  3803,
     626,  3447,  3448,   239,   539,   656,   654,   543,   654,  4571,
      12,   289,    13,  3459,   210,  3384,  3462,   198,   656,   237,
    4057,   662,   557,    27,   368,    29,   480,   481,   272,   656,
     467,   654,   184,   654,   656,   198,   623,   191,   662,   191,
    3486,   368,   662,  3489,    20,  3428,   662,  3541,  3494,   655,
     175,    27,   639,   424,  3437,   494,   495,    61,    62,   472,
      64,   656,   491,   656,   467,   219,   598,   219,   220,    73,
    3516,    49,   656,   196,   352,   201,   349,   523,   251,    83,
     523,   523,   584,  3954,  3955,   363,   482,    91,   523,   367,
     368,   523,   447,   196,   654,  3541,  3967,    73,   642,   317,
     537,   274,   642,  3974,   642,   642,   656,    83,   285,   642,
     374,   600,   642,   642,   118,  4582,  4583,   335,  4585,  4681,
    3489,   374,  3926,  3506,   374,  4774,   642,   642,   132,  4000,
    4001,   135,   160,   642,   537,   289,  4774,   289,  4787,    83,
     662,   359,   642,  4792,   642,   642,   642,   642,  4797,  4787,
     642,  3645,   642,    97,  4792,   642,   132,   606,   642,  4797,
     164,  3034,   115,   642,   642,   247,   247,   340,   662,   623,
     656,   642,     7,   655,  3047,   655,   561,  3623,  4645,   584,
    4647,  4648,  3628,   637,   638,   639,   655,   655,   361,   362,
     655,   655,    14,   655,   655,   655,   140,   656,   572,  3645,
     352,   656,   572,   572,  4241,   662,   645,   646,   647,   648,
     649,   650,   651,   652,   368,   367,   368,   662,   633,   172,
     281,    89,    49,   654,   654,   229,   642,   231,   204,   654,
     572,   654,   642,   237,   381,   198,   198,   198,   248,   198,
     584,   245,   255,  3689,   561,   561,   429,   175,   201,   656,
     368,   258,   258,   229,   387,   231,   260,   584,   331,   654,
     118,   118,  3708,    81,   398,   438,  3712,   398,   398,   572,
     142,   259,  4739,   552,  3720,   259,   398,   552,  3724,    36,
    3726,  4756,   104,   561,   237,   261,  4394,   565,   142,   398,
     568,    49,   398,   400,   398,  4099,  4100,   398,  4102,  4103,
     398,   579,  3685,   572,   654,   654,   584,   212,   654,   587,
     380,   662,    69,   317,   136,   649,   561,   654,   536,   263,
    3814,   494,   495,   654,   249,   249,   655,   655,   150,   655,
     655,   335,   285,   654,   552,   429,   656,   510,   656,   662,
     655,   655,   655,   655,   381,  3791,   654,   649,  3794,   374,
     172,   233,   656,   276,   176,  3801,  3802,  3803,  3804,   655,
     398,   515,   656,   346,   655,   662,   188,   198,  3814,   647,
     648,   599,   251,   429,   655,   655,   642,   258,   258,   656,
     656,   398,   139,  4396,   463,   361,   362,   391,   210,   393,
     261,   367,  3886,   654,   338,   261,    27,   401,   374,   662,
     412,   123,   124,   125,   126,   127,  4419,   164,   374,   561,
     167,  4795,    83,   565,   374,   237,   568,   361,   362,    20,
     364,   655,   244,   656,   654,   654,   384,   579,   655,    49,
     584,   485,   584,   655,   628,   587,   655,   180,   414,   272,
    3886,  4471,    73,   465,   284,   210,   203,   153,   268,   655,
    3896,   655,    83,   656,   483,   258,   212,   493,   411,   258,
      36,   656,   284,   416,   374,   374,   223,  3913,   509,   473,
     115,   655,   645,   646,   647,   648,   649,   650,   651,   652,
    3926,   238,  3976,   427,    57,  3931,   655,   654,   656,   261,
    3939,  3937,   261,    69,    67,   647,   648,   656,   656,  3945,
     628,   132,   224,   225,   226,   227,   654,    87,   501,    82,
     655,   487,   149,   236,   655,   468,   654,   654,   654,  3902,
     275,    94,    95,    96,    36,   529,   530,   531,   655,   286,
    3976,   655,   536,    36,   655,   655,   489,    62,   368,   249,
     113,   655,   655,  4430,   655,   655,  4654,   337,   552,   263,
     424,   656,   556,   310,    18,   200,  4002,   381,  4445,   655,
     628,   541,   248,   139,   654,   656,   655,   662,  3937,  4063,
      49,   575,   656,   217,   337,   606,   606,   654,   509,   523,
     478,   655,    20,   654,   656,   132,   655,   132,   164,   593,
     555,   167,   237,   410,  3977,   417,   654,   662,   229,   552,
     231,    36,  4639,   656,   368,   558,  4052,   337,   330,  4055,
     332,   333,   334,   179,   143,   437,   655,  4063,   594,   341,
     561,   561,   561,   445,   577,  4512,   261,   203,   555,  4642,
     261,   453,   606,   654,   606,   610,   655,   655,  4084,  4085,
     285,  4749,   656,   654,   314,   654,   654,   223,   616,   602,
      15,   654,   656,  4099,  4100,   654,  4102,  4103,   415,   616,
     654,   483,   238,   599,   132,   261,   619,   424,  4776,    20,
     261,   367,   527,   628,   496,   497,   175,   654,   472,   462,
      63,   381,   439,  4052,   655,   599,   656,   463,   655,   542,
     654,   248,   374,   611,   363,   161,   625,    33,   654,   175,
     457,   423,   654,   368,  4150,   655,   142,   563,  4721,   663,
     286,   142,   692,   164,   416,  4161,  4085,   697,    75,   654,
    4166,   196,   196,   655,   546,   625,   198,    33,  4615,   381,
     361,   362,   654,   654,   310,    65,   367,    65,  4625,   655,
     395,   386,   655,   374,   501,   656,   654,   504,   543,  4195,
    4196,   277,  4198,   437,   734,   577,   329,   248,   480,   481,
     655,   160,   381,   660,   381,   654,    49,  4150,    49,   159,
      49,   751,    49,    49,   347,   532,  4222,   599,   654,   601,
     140,   654,   149,   414,   374,  4798,     5,   374,   655,   625,
     160,   232,   131,   291,   551,   660,   284,   554,   555,   663,
      12,   155,   654,    49,    49,    49,    27,  4694,    29,  4255,
     599,  4257,   136,    55,   660,   795,   796,   797,   798,  4706,
     474,  4708,   472,   468,   656,   160,   655,   807,   564,   655,
     214,   656,   660,   656,   230,  4722,   655,   261,    55,   415,
     655,  4287,  4729,    64,   489,   656,   603,   451,   424,   196,
     196,   196,    49,   564,   627,   233,   487,   132,   368,   197,
     656,   654,    83,   439,   491,  2680,  4171,   512,  4314,  3799,
      91,  2572,  3520,  4760,  4761,   992,  1040,  2369,  4765,  3911,
    4266,   457,  4397,  4598,  4378,  1060,  4599,  3909,  3913,  4083,
    4737,  4776,    48,  1935,   599,  1866,  4005,   118,  2836,  4005,
    4746,   623,  4005,  4612,  4005,  4005,   479,   552,  4005,  4005,
    4005,   132,  4005,  4005,   135,   895,   638,   639,  4423,  4612,
    4005,  4549,  4368,  4005,  4005,   501,  4449,  1105,   504,  4448,
    1835,  1585,  4378,  4270,  4092,  2642,  3457,  3622,  4384,  2121,
    2865,  3294,  4368,   164,  2870,  1373,  4053,  4473,  4681,   594,
    3625,  4639,  4579,  1623,  4337,   631,   532,   602,  4241,  3918,
    2635,  3370,  3084,   594,  3689,  2643,   539,  3087,  3931,  3938,
    4700,  4419,  3183,  3749,  4126,  3783,  3987,  3976,   554,  4471,
    2543,  3237,  2789,  3232,   557,  3240,   234,  4403,  4371,  4372,
      11,    11,  4520,  2199,  4521,  4340,  4490,  4353,  4349,  2707,
    4134,  4198,  3405,  2642,  3080,  1020,  1073,  1519,   229,  4455,
     231,  3943,  2513,  2439,  4460,  2128,   237,  4455,  3707,  1619,
    1924,  1597,  2412,  4469,   245,  3289,  2851,   603,  2325,  2460,
    4007,   620,  1949,  3254,   941,  4299,  2234,  2230,  2528,   260,
    2822,  2522,  3353,  1172,  4490,   293,  4593,   295,   296,   297,
     298,   299,  2324,   301,   302,   303,   304,   305,   306,   307,
     308,   309,  3516,   311,   312,   313,  4078,  4260,  3720,  4594,
    1145,  2350,  2941,  1536,  3897,  3076,  4721,  4460,  2465,  3886,
    2203,  1388,  1356,  4577,  2443,  2406,  3628,  3309,  3308,  3362,
    4469,   610,  1640,  1044,   688,  1044,   317,  1044,  4481,  4482,
    2028,  1044,  1467,   598,  2029,  2507,  1086,  3726,   598,  1395,
    3292,  4679,  1855,  4497,   335,  4716,  4589,  4792,  4797,  3978,
     784,  3314,  1788,  2490,  1425,  3342,   597,  3343,   597,  1975,
    2483,  4577,  2482,  2476,  1905,   833,   591,   921,  1348,  4042,
    2455,  2838,  4048,  1415,  1124,  1125,   592,  4593,  4594,   928,
    1631,   628,  1040,  1133,  1134,  1135,  1136,  1137,  1138,  1139,
    1140,  1141,  1142,  1143,  1144,   628,   628,    -1,    -1,    -1,
     391,  4617,   393,  1153,  1154,    -1,  1156,  1157,  4624,  1040,
     401,  1161,    -1,    -1,  1164,  1165,  1166,  1167,    -1,  1169,
    1170,  1171,  1040,   441,   442,    -1,    -1,    -1,  1178,  1179,
      -1,  1181,  1182,  1183,  1184,  1185,    -1,    -1,  1188,  1189,
    1190,  1191,  1192,  1193,  1194,  1195,  1196,  1197,  1198,    -1,
    1200,    -1,    -1,  1203,  1204,    -1,    -1,    -1,  1208,    -1,
      -1,    -1,  1212,  1213,  1214,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1224,  1225,  1226,    -1,    -1,    -1,
      -1,    -1,   473,  1233,    -1,    -1,    -1,    -1,    -1,  4705,
    1240,  1241,  1242,  1243,  4710,    -1,    -1,    -1,    -1,    -1,
      -1,  1251,  1252,  1253,    -1,  1255,  1256,  1257,  1258,  1259,
      -1,  1261,  1262,  1263,  1264,  1265,  1266,  1267,  1268,  4783,
      -1,    -1,  1272,  1273,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4749,    -1,    -1,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,  4697,   536,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4774,    -1,
    4776,   552,    -1,    -1,    -1,   556,    -1,  4783,    -1,    -1,
      -1,  4787,    -1,    -1,    -1,    -1,  4792,    -1,    -1,    -1,
      -1,  4797,    -1,    -1,   575,    -1,    -1,    -1,    -1,  4232,
    4233,    -1,    -1,  4236,  4237,  4238,  4239,    -1,    -1,    -1,
      -1,    -1,   593,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1360,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     697,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1425,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1435,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4338,    -1,   734,    -1,    -1,
      -1,  1451,    -1,    -1,    -1,  1455,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   751,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4373,  4374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4382,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1510,   798,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,    -1,    -1,
      -1,    -1,    -1,    12,    -1,    14,    -1,    16,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   895,    -1,
      59,    -1,    -1,    -1,    -1,    64,    65,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,  1653,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   135,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   143,   144,    -1,    -1,    -1,    -1,
      -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   158,
      -1,    -1,    -1,   162,    -1,   164,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   194,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1766,  1767,  1768,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     229,  1781,   231,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   245,    -1,    -1,  1086,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1807,    -1,    -1,
      -1,   260,    -1,  1813,    -1,    -1,  1816,    -1,  1818,    -1,
      -1,    -1,    -1,    -1,  1824,    -1,  1826,  1827,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   284,    -1,  1124,  1125,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1133,  1134,    -1,    -1,
    1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1153,  1154,   317,  1156,
    1157,    -1,    -1,    -1,    -1,    -1,    -1,  1164,  1165,  1166,
    1167,    -1,    -1,  1170,    -1,    -1,   335,    -1,    -1,    -1,
     339,  1178,  1179,    -1,  1181,  1182,    -1,    -1,    -1,    -1,
      -1,  1188,  1189,  1190,    -1,    -1,  1193,  1194,  1195,  1196,
    1197,  1198,    -1,  1200,    -1,    -1,  1203,  1204,    -1,  1919,
      -1,  1208,    -1,    -1,    -1,  1212,  1213,  1214,    -1,    -1,
     379,    -1,    -1,    -1,    -1,   384,    -1,  1224,  1225,  1226,
      -1,    -1,   391,    -1,   393,    -1,  1233,    -1,    -1,   398,
      -1,    -1,   401,  1240,  1241,  1242,    -1,    27,    -1,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1973,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1982,   432,    -1,    -1,  1273,    -1,    -1,    -1,
      -1,    61,    62,    -1,    64,    -1,    -1,   446,   447,   448,
     449,    -1,    -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    -1,    -1,   473,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,    -1,   135,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1360,    -1,    -1,    -1,    -1,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,    -1,
      -1,    -1,    -1,    -1,   164,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   552,    -1,    -1,    -1,   556,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2121,    -1,    -1,    -1,    -1,   575,    -1,    -1,    -1,
      -1,   580,    -1,    -1,    -1,    -1,    -1,    -1,  1425,    -1,
      -1,    -1,    -1,  2143,   593,    -1,    -1,    -1,  1435,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   229,
      -1,   231,    -1,    -1,  1451,    -1,    -1,   237,  1455,    -1,
      -1,    -1,    -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   274,    -1,    -1,    -1,    -1,    -1,
      -1,   660,  2212,    -1,    -1,    -1,  2216,    -1,    -1,    -1,
      -1,  2221,  2222,  1510,    -1,    -1,    -1,    -1,    -1,    -1,
    2230,    -1,  2232,    -1,  2234,  2235,  2236,  2237,    -1,    -1,
    2240,    -1,    -1,    -1,    -1,    -1,    -1,   317,    -1,    -1,
    2250,    -1,  2252,  2253,    -1,  2255,  2256,  2257,  2258,    -1,
    2260,    -1,    -1,  2263,    -1,   335,    -1,    -1,    -1,    -1,
      -1,    -1,  2272,    -1,    -1,    -1,    -1,    -1,    -1,  2279,
      -1,  2281,    -1,  2283,  2284,    -1,  2286,  2287,    -1,    -1,
      -1,  2291,  2292,  2293,    -1,    -1,    -1,  2297,  2298,  2299,
      -1,  2301,    -1,  2303,    -1,  2305,    -1,  2307,    -1,  2309,
      -1,    -1,    -1,    -1,  2314,    -1,    -1,    -1,    -1,    -1,
      -1,   391,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   401,    -1,  2333,    -1,    -1,    -1,    -1,    -1,    -1,
    2340,    -1,    -1,  2343,    -1,    -1,    -1,    -1,    -1,  2349,
      -1,    -1,  2352,    -1,    -1,    -1,  2356,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1653,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   473,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2420,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1766,
    1767,  1768,   552,    -1,    -1,    -1,   556,    -1,    -1,    -1,
      -1,  2491,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   575,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1807,    -1,    -1,   593,    -1,    -1,    -1,    -1,    -1,  1816,
      -1,  1818,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2542,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2555,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2573,  2574,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   654,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1919,    -1,    -1,  2635,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    14,    -1,    16,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2684,  2685,  1973,    -1,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,    -1,    -1,
    2720,    64,    65,    -1,  2724,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    85,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2751,  2752,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2771,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2780,    -1,  2782,    -1,  2784,   128,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,   137,   138,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,    -1,
      -1,  2811,    -1,    -1,    -1,    -1,  2816,    -1,    -1,   162,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   176,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2847,    -1,    -1,
     193,    -1,    -1,    -1,    -1,    -1,  2143,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   208,    -1,   210,    -1,    -1,
      -1,   214,    -1,    -1,    -1,   218,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   244,    -1,   246,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,
      -1,    -1,    -1,  2923,    -1,  2212,    -1,    -1,    -1,  2216,
      -1,    -1,    -1,    -1,  2221,  2222,    -1,   280,    -1,    -1,
      -1,   284,    -1,  2230,    -1,  2232,    -1,  2234,    -1,  2236,
    2237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2250,    -1,  2252,    -1,    -1,  2255,  2256,
    2257,  2258,    -1,  2260,  2974,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2272,    -1,    -1,    -1,  2989,
      -1,    -1,  2279,    -1,  2281,    -1,  2283,  2284,    -1,  2286,
      -1,    -1,    -1,    -1,  2291,  2292,  2293,    -1,    -1,    -1,
    2297,  2298,  2299,    -1,  2301,    -1,  2303,    -1,  2305,    -1,
    2307,    -1,  2309,    -1,    -1,    -1,    -1,  2314,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2333,    -1,    -1,    -1,
      -1,    -1,    -1,   396,    -1,   398,    -1,    -1,    -1,    -1,
      -1,    -1,  2349,    -1,    -1,  2352,    -1,    -1,   411,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   422,
    3080,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3093,  3094,    -1,    -1,    -1,    -1,    -1,
      -1,   444,    -1,    -1,   447,    -1,   449,    -1,    -1,   452,
      -1,    -1,   455,   456,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   466,    -1,    -1,   469,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   477,    -1,    -1,    14,    -1,    16,
     483,    -1,  3142,    -1,    -1,    -1,    -1,    -1,   491,    -1,
      -1,    -1,    -1,   496,   497,   498,    -1,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    -1,  3165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      -1,    -1,    59,    -1,    -1,   528,    -1,    64,    65,    -1,
      -1,    -1,   535,    -1,    -1,    -1,    -1,  3197,  3198,    -1,
    3200,    -1,    -1,    -1,  2491,    -1,    -1,    -1,    85,  3209,
      -1,    -1,    -1,    -1,  3214,    -1,    -1,  3217,    -1,  3219,
    3220,    -1,    -1,    -1,    -1,    -1,    -1,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   592,
      -1,   128,  3252,   596,    -1,    -1,   599,    -1,    -1,   136,
     137,   138,   605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3283,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   635,    -1,    -1,    -1,    -1,    -1,   641,   176,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3308,    -1,
      -1,   654,    -1,    -1,    -1,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,    -1,    -1,
      -1,   208,    -1,   210,    -1,    -1,    -1,   214,    -1,    25,
      -1,   218,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      36,    37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3364,    -1,    -1,   244,    -1,   246,
      -1,    -1,    -1,    -1,    -1,    61,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    69,    -1,   262,    -1,    -1,    74,    -1,
      -1,    -1,    -1,  3393,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   280,    -1,    -1,    -1,   284,    -1,    -1,
      -1,    -1,    -1,    -1,   100,    -1,   102,    -1,   104,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     116,    -1,    -1,  2720,    -1,    -1,    -1,  2724,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   137,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2751,  2752,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   163,   164,    -1,
      -1,    -1,   168,    -1,  2771,   171,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2780,    -1,  2782,    -1,  2784,    -1,    -1,
      -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   199,    -1,   201,    -1,    -1,    -1,   396,
      -1,   398,    -1,   209,    -1,   211,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   411,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   422,    -1,    -1,    -1,    -1,
     236,   237,   238,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2847,    -1,    -1,    -1,    -1,    -1,    -1,   444,    -1,    -1,
     447,    -1,   449,   259,    -1,   452,    -1,    -1,   455,   456,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   466,
      -1,    -1,   469,    -1,    -1,   281,    -1,    -1,    -1,    -1,
     477,    -1,    -1,    -1,    -1,    -1,   483,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   491,    -1,    -1,    -1,    -1,   496,
     497,   498,    -1,    -1,   310,    -1,    -1,    -1,    -1,  3629,
      -1,    -1,    -1,    -1,    -1,    -1,  2923,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   528,    -1,    -1,    -1,    -1,    -1,    -1,   535,    -1,
      -1,    -1,    -1,    -1,    -1,  3665,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3673,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2974,    -1,    -1,
      -1,    -1,   378,    -1,  3694,    -1,    -1,    -1,    -1,    -1,
      35,    36,    -1,   580,    -1,    -1,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    -1,   592,    -1,    -1,   404,   596,
      -1,    -1,   599,    -1,    -1,    -1,    -1,    62,   605,   415,
     416,    -1,    -1,   419,   420,    -1,    27,    -1,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   440,    -1,    -1,    -1,   635,    -1,
      -1,    -1,    -1,    -1,   641,    -1,    -1,    -1,    -1,    -1,
      61,    62,    -1,    64,    -1,    -1,  3776,   654,    -1,    -1,
      -1,    -1,    73,    -1,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,    83,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      91,    -1,   488,    -1,    -1,    -1,  3093,  3094,    -1,    -1,
      -1,    -1,    -1,   148,    -1,   501,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,  3828,    -1,
     165,    -1,  3832,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,    -1,   532,    -1,    -1,    -1,
     536,    -1,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3867,   554,   555,
     205,   206,    -1,   164,    -1,    -1,    -1,    -1,  3165,    -1,
      -1,  3881,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3197,  3198,    -1,    -1,   249,    -1,    -1,   603,  3918,    -1,
      -1,    -1,  3209,    -1,    -1,    -1,    -1,  3214,   614,    -1,
    3217,    -1,  3219,  3220,    -1,    -1,   622,    -1,   229,    -1,
     231,    -1,    -1,   278,    -1,    -1,   237,    -1,    -1,    -1,
      -1,    -1,   287,   288,   245,   290,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   260,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3987,   323,   324,
     325,    -1,    -1,    -1,    -1,    -1,  3283,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4005,    -1,   342,   343,   344,
      -1,    -1,    -1,    -1,    -1,   350,    -1,    -1,   353,    -1,
      -1,  3308,    -1,    -1,    -1,    -1,   317,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   370,   371,     6,    -1,    -1,
      -1,    -1,    -1,    12,   335,    14,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4053,    -1,    -1,    -1,    -1,    27,    -1,
      29,  4061,    -1,    -1,    -1,    -1,    -1,  4067,    -1,  4069,
      -1,   406,   407,    -1,    -1,    -1,    -1,  3364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      59,    -1,    -1,    -1,    -1,    64,   431,    -1,    -1,    -1,
     391,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     401,    -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
      -1,    -1,   487,    -1,    -1,    -1,   491,    -1,  4158,    -1,
      -1,    -1,    -1,   132,  4164,  4165,   135,    -1,    -1,    -1,
     505,    -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,    -1,
      -1,   150,   473,    -1,    -1,    -1,    -1,    -1,    -1,   158,
      -1,    -1,    -1,    -1,    -1,   164,    -1,  4197,    -1,    -1,
      -1,  4201,  4202,    -1,    -1,    -1,    -1,    -1,  4208,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   194,    -1,   562,    -1,    -1,
     565,    -1,    -1,   568,   569,   570,   571,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,  4246,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     229,   552,   231,    -1,    -1,   556,    -1,    -1,   237,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   245,   612,   613,    -1,
      -1,    -1,    -1,    -1,   575,    -1,    -1,    -1,    -1,    -1,
      -1,   260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   593,    -1,   639,    -1,    -1,  4307,    -1,  4309,
      -1,    -1,    -1,    -1,    -1,   284,    -1,    -1,    -1,  4319,
      -1,  4321,  4322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4340,    -1,  3629,    -1,    -1,    -1,    -1,    -1,   317,  4349,
      -1,    -1,    -1,  4353,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   335,    -1,    -1,    -1,
     339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3665,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3673,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4405,    -1,  3694,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   384,    -1,    -1,    -1,    -1,
      -1,    -1,   391,    -1,   393,    -1,    -1,    -1,  4428,    -1,
    4430,    -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4445,  4446,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4463,    -1,    -1,    -1,    -1,    -1,    -1,
    4470,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   447,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   473,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4512,    -1,    -1,    -1,    -1,    -1,  4518,    -1,
    4520,  4521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4535,  4536,    -1,    -1,    -1,
      -1,  3828,    -1,    -1,    -1,  3832,    -1,    -1,  4548,  4549,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,    -1,
      -1,  4571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3867,    -1,    -1,   552,    -1,    -1,    -1,   556,    -1,    -1,
      -1,    -1,    -1,    -1,  3881,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   575,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4615,    -1,    -1,    -1,    -1,
      -1,    -1,  4622,    -1,   593,  4625,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4660,    -1,    -1,    -1,    -1,    -1,    -1,  4667,    -1,  4669,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4681,    -1,    -1,  4684,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4694,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4704,    -1,  4706,    -1,  4708,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4722,    -1,    -1,    -1,    -1,    -1,    -1,  4729,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4744,  4745,    -1,    -1,    -1,    -1,
    4750,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4760,  4761,    -1,    -1,    -1,  4765,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4061,    -1,    -1,    -1,    -1,    -1,
    4067,    -1,  4069,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4800,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4246,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4307,    -1,  4309,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4428,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4446,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4470,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4535,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4622,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4660,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4684,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    47,    48,  4750,    50,    51,    -1,    -1,    54,    55,
      56,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,  4800,   100,   101,   102,   103,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
      -1,   117,   118,   119,   120,   121,   122,    -1,    -1,    -1,
      -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,   167,   168,    -1,   170,   171,   172,   173,   174,   175,
     176,   177,    -1,   179,   180,   181,   182,   183,   184,   185,
     186,    -1,   188,   189,   190,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,    -1,   213,   214,   215,
     216,    -1,   218,   219,   220,    -1,   222,   223,    -1,    -1,
      -1,   227,   228,   229,   230,   231,   232,    -1,   234,   235,
     236,    -1,   238,    -1,   240,    -1,    -1,    -1,   244,   245,
     246,   247,    -1,    -1,   250,    -1,   252,   253,    -1,   255,
     256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,   265,
      -1,   267,   268,    -1,   270,   271,   272,    -1,    -1,    -1,
      -1,    -1,   278,   279,    -1,   281,    -1,   283,    -1,   285,
     286,    -1,    -1,   289,    -1,    -1,    -1,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,   329,   330,   331,    -1,    -1,   334,   335,
     336,   337,    -1,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,    -1,   352,   353,   354,    -1,
      -1,   357,   358,   359,   360,   361,   362,   363,   364,   365,
      -1,   367,   368,   369,    -1,   371,   372,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,   391,   392,    -1,   394,   395,
      -1,   397,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,   409,    -1,   411,   412,   413,    -1,   415,
      -1,   417,   418,   419,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
     436,    -1,    -1,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,   448,   449,   450,   451,   452,   453,    -1,   455,
      -1,   457,   458,    -1,   460,   461,    -1,   463,    -1,   465,
      -1,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,    -1,   481,   482,    -1,    -1,    -1,
     486,   487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,
      -1,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
     506,   507,   508,   509,   510,   511,    -1,    -1,    -1,    -1,
      -1,    -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,
      -1,   527,   528,    -1,    -1,    -1,   532,   533,   534,   535,
     536,    -1,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,    -1,   554,    -1,
     556,   557,   558,   559,    -1,   561,   562,   563,    -1,   565,
     566,   567,   568,    -1,    -1,    -1,    -1,   573,   574,   575,
     576,    -1,   578,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,    -1,   591,   592,    -1,    -1,   595,
      -1,    -1,   598,    -1,   600,    -1,   602,   603,   604,    -1,
      -1,   607,   608,   609,   610,   611,    -1,    -1,   614,   615,
      -1,   617,   618,   619,   620,   621,   622,   623,   624,    -1,
      -1,    -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,
     636,    -1,    -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,
      -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,     7,
       8,     9,    10,    11,    12,    13,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    36,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    55,    56,    57,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,   101,   102,   103,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,    -1,   117,
     118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,   177,
      -1,   179,   180,   181,   182,   183,   184,   185,   186,    -1,
     188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,   213,   214,   215,   216,    -1,
     218,   219,   220,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,   232,    -1,   234,   235,   236,    -1,
     238,    -1,   240,    -1,    -1,    -1,   244,   245,   246,   247,
      -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,   270,   271,   272,    -1,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,   289,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,   336,   337,
      -1,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,   352,   353,   354,    -1,    -1,   357,
     358,   359,   360,   361,   362,   363,   364,   365,    -1,   367,
     368,   369,    -1,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,   394,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,   409,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,   451,   452,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,   533,   534,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,   561,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
     578,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,   607,
     608,   609,   610,   611,    -1,    -1,   614,   615,    -1,   617,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
      -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   647,
     648,    -1,    -1,    -1,    -1,   653,   654,    -1,    -1,   657,
     658,    -1,    -1,   661,   662,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    36,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    55,    56,    57,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,   101,   102,   103,    -1,    -1,   106,   107,   108,   109,
     110,   111,    -1,   113,   114,   115,    -1,   117,   118,   119,
     120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,
      -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,   167,   168,    -1,
     170,   171,   172,   173,   174,   175,   176,   177,    -1,   179,
     180,   181,   182,   183,   184,   185,   186,    -1,   188,   189,
     190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,   199,
      -1,   201,    -1,   203,   204,   205,   206,   207,   208,   209,
      -1,   211,    -1,   213,   214,   215,   216,    -1,   218,   219,
     220,    -1,   222,   223,    -1,    -1,    -1,   227,   228,   229,
     230,   231,   232,    -1,   234,   235,   236,    -1,   238,    -1,
     240,    -1,    -1,    -1,   244,   245,   246,   247,    -1,    -1,
     250,    -1,   252,   253,    -1,   255,   256,    -1,    -1,    -1,
     260,    -1,    -1,   263,   264,   265,    -1,    -1,   268,    -1,
     270,   271,   272,    -1,    -1,    -1,    -1,    -1,   278,   279,
      -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,   289,
      -1,    -1,    -1,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,   329,
     330,   331,    -1,    -1,   334,   335,   336,   337,    -1,   339,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,    -1,   352,   353,   354,    -1,    -1,   357,   358,   359,
     360,   361,   362,   363,   364,   365,    -1,   367,   368,   369,
      -1,   371,   372,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     390,   391,   392,    -1,   394,   395,    -1,   397,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,   409,
      -1,   411,   412,   413,    -1,   415,    -1,   417,   418,   419,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,   448,   449,
     450,   451,   452,   453,    -1,   455,    -1,   457,   458,    -1,
     460,   461,    -1,   463,    -1,   465,    -1,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
      -1,   481,   482,    -1,    -1,    -1,   486,   487,   488,   489,
      -1,    -1,    -1,   493,    -1,    -1,    -1,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,   506,   507,   508,   509,
     510,   511,    -1,    -1,    -1,    -1,    -1,    -1,   518,   519,
      -1,   521,    -1,    -1,   524,    -1,    -1,   527,   528,    -1,
      -1,    -1,   532,   533,   534,   535,   536,    -1,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   548,   549,
     550,   551,   552,    -1,   554,    -1,   556,   557,   558,   559,
      -1,   561,   562,   563,    -1,   565,   566,   567,   568,    -1,
      -1,    -1,    -1,    -1,   574,   575,   576,    -1,   578,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
      -1,   591,   592,    -1,    -1,   595,    -1,    -1,   598,    -1,
     600,    -1,   602,   603,   604,    -1,    -1,   607,   608,   609,
     610,   611,    -1,    -1,   614,   615,    -1,   617,   618,   619,
     620,   621,   622,   623,   624,    -1,    -1,    -1,    -1,    -1,
      -1,   631,   632,    -1,   634,   635,   636,    -1,    -1,   639,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   647,   648,    -1,
      -1,    -1,    -1,   653,   654,    -1,    -1,   657,   658,    -1,
      -1,   661,   662,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    55,    56,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,   101,
     102,   103,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,    -1,   117,   118,   119,   120,   121,
     122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,   167,   168,    -1,   170,   171,
     172,   173,   174,   175,   176,   177,    -1,   179,   180,   181,
     182,   183,   184,   185,   186,    -1,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,   199,    -1,   201,
      -1,   203,   204,   205,   206,   207,   208,   209,    -1,   211,
      -1,   213,   214,   215,   216,    -1,   218,   219,   220,    -1,
     222,   223,    -1,    -1,    -1,   227,   228,   229,   230,   231,
     232,    -1,   234,   235,   236,    -1,   238,    -1,   240,    -1,
      -1,    -1,   244,   245,   246,   247,    -1,    -1,   250,    -1,
     252,   253,    -1,   255,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,   265,    -1,    -1,   268,    -1,   270,   271,
     272,    -1,    -1,    -1,    -1,    -1,   278,   279,    -1,   281,
      -1,   283,    -1,   285,   286,    -1,    -1,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,   329,   330,   331,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,    -1,
     352,   353,   354,    -1,    -1,   357,   358,   359,   360,   361,
     362,   363,   364,   365,    -1,   367,   368,   369,    -1,   371,
     372,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,   391,
     392,    -1,   394,   395,    -1,   397,    -1,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,   409,    -1,   411,
     412,   413,    -1,   415,    -1,   417,   418,   419,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,   436,    -1,    -1,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,   448,   449,   450,   451,
     452,   453,    -1,   455,    -1,   457,   458,    -1,   460,   461,
      -1,   463,    -1,   465,    -1,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,    -1,   481,
     482,    -1,    -1,    -1,   486,   487,   488,   489,    -1,    -1,
      -1,   493,    -1,    -1,    -1,   497,    -1,   499,   500,   501,
     502,   503,   504,    -1,   506,   507,   508,   509,   510,   511,
      -1,    -1,    -1,    -1,    -1,    -1,   518,   519,    -1,   521,
      -1,    -1,   524,    -1,    -1,   527,   528,    -1,    -1,    -1,
     532,   533,   534,   535,   536,    -1,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   548,   549,   550,   551,
     552,    -1,   554,    -1,   556,   557,   558,   559,    -1,   561,
     562,   563,    -1,   565,   566,   567,   568,    -1,    -1,    -1,
      -1,    -1,   574,   575,   576,    -1,   578,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,    -1,   591,
     592,    -1,    -1,   595,    -1,    -1,   598,    -1,   600,    -1,
     602,   603,   604,    -1,    -1,   607,   608,   609,   610,   611,
      -1,    -1,   614,   615,    -1,   617,   618,   619,   620,   621,
     622,   623,   624,    -1,    -1,    -1,    -1,    -1,    -1,   631,
     632,    -1,   634,   635,   636,    -1,    -1,   639,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,
      -1,   653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,
     662,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    36,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    55,    56,    57,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,   101,   102,   103,
      -1,    -1,   106,   107,   108,   109,   110,   111,    -1,   113,
     114,   115,    -1,   117,   118,   119,   120,   121,   122,    -1,
      -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,   167,   168,    -1,   170,   171,   172,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
     184,   185,   186,    -1,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,   199,    -1,   201,    -1,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,    -1,   213,
     214,   215,   216,    -1,   218,   219,   220,    -1,   222,   223,
      -1,    -1,    -1,   227,   228,   229,   230,   231,   232,    -1,
     234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,
     244,   245,   246,   247,    -1,    -1,   250,    -1,   252,   253,
      -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,   265,    -1,    -1,   268,    -1,   270,   271,   272,    -1,
      -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,
      -1,   285,   286,    -1,    -1,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,   329,   330,   331,    -1,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,    -1,   352,   353,
     354,    -1,    -1,   357,   358,   359,   360,   361,   362,   363,
     364,   365,    -1,   367,   368,   369,    -1,   371,   372,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,
     394,   395,    -1,   397,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,   409,    -1,   411,   412,   413,
      -1,   415,    -1,   417,   418,   419,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,   436,    -1,    -1,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,   448,   449,   450,   451,   452,   453,
      -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,   463,
      -1,   465,    -1,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,    -1,
      -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,
      -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,   506,   507,   508,   509,   510,   511,    -1,    -1,
      -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,
     524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,   533,
     534,   535,   536,    -1,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   548,   549,   550,   551,   552,    -1,
     554,    -1,   556,   557,   558,   559,    -1,   561,   562,   563,
      -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,
     574,   575,   576,    -1,   578,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,    -1,   591,   592,    -1,
      -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,
     604,    -1,    -1,   607,   608,   609,   610,   611,    -1,    -1,
     614,   615,    -1,   617,   618,   619,   620,   621,   622,   623,
     624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,
     634,   635,   636,    -1,    -1,   639,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,   653,
     654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,
      56,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,   101,   102,   103,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
      -1,   117,   118,   119,   120,   121,   122,    -1,    -1,    -1,
      -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,   167,   168,    -1,   170,   171,   172,   173,   174,   175,
     176,   177,    -1,   179,   180,   181,   182,   183,   184,   185,
     186,    -1,   188,   189,   190,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,    -1,   213,   214,   215,
     216,    -1,   218,   219,   220,    -1,   222,   223,    -1,    -1,
      -1,   227,   228,   229,   230,   231,   232,    -1,   234,   235,
     236,    -1,   238,    -1,   240,    -1,    -1,    -1,   244,   245,
     246,   247,    -1,    -1,   250,    -1,   252,   253,    -1,   255,
     256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,   265,
      -1,    -1,   268,    -1,   270,   271,   272,    -1,    -1,    -1,
      -1,    -1,   278,   279,    -1,   281,    -1,   283,    -1,   285,
     286,    -1,    -1,   289,    -1,    -1,    -1,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,   329,   330,   331,    -1,    -1,   334,   335,
     336,   337,    -1,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,    -1,   352,   353,   354,    -1,
      -1,   357,   358,   359,   360,   361,   362,   363,   364,   365,
      -1,   367,   368,   369,    -1,   371,   372,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,   391,   392,    -1,   394,   395,
      -1,   397,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,   409,    -1,   411,   412,   413,    -1,   415,
      -1,   417,   418,   419,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
     436,    -1,    -1,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,   448,   449,   450,   451,   452,   453,    -1,   455,
      -1,   457,   458,    -1,   460,   461,    -1,   463,    -1,   465,
      -1,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,    -1,   481,   482,    -1,    -1,    -1,
     486,   487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,
      -1,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
     506,   507,   508,   509,   510,   511,    -1,    -1,    -1,    -1,
      -1,    -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,
      -1,   527,   528,    -1,    -1,    -1,   532,   533,   534,   535,
     536,    -1,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,    -1,   554,    -1,
     556,   557,   558,   559,    -1,   561,   562,   563,    -1,   565,
     566,   567,   568,    -1,    -1,    -1,    -1,    -1,   574,   575,
     576,    -1,   578,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,    -1,   591,   592,    -1,    -1,   595,
      -1,    -1,   598,    -1,   600,    -1,   602,   603,   604,    -1,
      -1,   607,   608,   609,   610,   611,    -1,    -1,   614,   615,
      -1,   617,   618,   619,   620,   621,   622,   623,   624,    -1,
      -1,    -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,
     636,    -1,    -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,
      -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    36,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    55,    56,    57,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,   101,   102,   103,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,    -1,   117,
     118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,   177,
      -1,   179,   180,   181,   182,   183,   184,   185,   186,    -1,
     188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,   213,   214,   215,   216,    -1,
     218,   219,   220,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,   232,    -1,   234,   235,   236,    -1,
     238,    -1,   240,    -1,    -1,    -1,   244,   245,   246,   247,
      -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,   270,   271,   272,    -1,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,   289,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,   336,   337,
      -1,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,   352,   353,   354,    -1,    -1,   357,
     358,   359,   360,   361,   362,   363,   364,   365,    -1,   367,
     368,   369,    -1,   371,   372,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,   394,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,   409,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,   451,   452,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,   533,   534,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,   561,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
     578,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,   607,
     608,   609,   610,   611,    -1,    -1,   614,   615,    -1,   617,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
      -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   647,
     648,    -1,    -1,    -1,    -1,   653,   654,    -1,    -1,   657,
     658,    -1,    -1,   661,   662,     5,    -1,     7,     8,     9,
      10,    11,    12,    13,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    36,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    55,    56,    57,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,   101,   102,   103,    -1,    -1,   106,   107,   108,   109,
     110,   111,    -1,   113,   114,   115,    -1,   117,   118,   119,
     120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,
      -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,   167,   168,    -1,
     170,   171,   172,   173,   174,   175,   176,   177,    -1,   179,
     180,   181,   182,   183,   184,   185,   186,    -1,   188,   189,
     190,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,    -1,   203,   204,   205,   206,   207,   208,   209,
      -1,   211,    -1,   213,   214,   215,   216,    -1,   218,   219,
     220,    -1,   222,   223,    -1,    -1,    -1,   227,   228,   229,
     230,   231,   232,    -1,   234,   235,   236,    -1,   238,    -1,
     240,    -1,    -1,    -1,   244,   245,   246,   247,    -1,    -1,
     250,    -1,   252,   253,    -1,   255,   256,    -1,    -1,    -1,
     260,    -1,    -1,   263,   264,   265,    -1,    -1,   268,    -1,
     270,   271,   272,    -1,    -1,    -1,    -1,    -1,   278,   279,
      -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,   289,
      -1,    -1,    -1,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,   329,
     330,   331,    -1,    -1,   334,   335,   336,   337,    -1,   339,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,    -1,   352,   353,   354,    -1,    -1,   357,   358,   359,
     360,   361,    -1,   363,   364,   365,    -1,   367,   368,   369,
      -1,   371,   372,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     390,   391,   392,    -1,   394,   395,    -1,   397,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,   409,
      -1,   411,   412,   413,    -1,   415,    -1,   417,   418,   419,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,   448,   449,
     450,   451,   452,   453,    -1,   455,    -1,   457,   458,    -1,
     460,   461,    -1,   463,    -1,   465,    -1,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
      -1,   481,   482,    -1,    -1,    -1,   486,   487,   488,   489,
      -1,    -1,    -1,   493,    -1,    -1,    -1,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,   506,   507,   508,   509,
     510,   511,    -1,    -1,    -1,    -1,    -1,    -1,   518,   519,
      -1,   521,    -1,    -1,   524,    -1,    -1,   527,   528,    -1,
      -1,    -1,   532,   533,   534,   535,   536,    -1,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   548,   549,
     550,   551,   552,    -1,   554,    -1,   556,   557,   558,   559,
      -1,   561,   562,   563,    -1,   565,   566,   567,   568,    -1,
      -1,    -1,    -1,    -1,   574,   575,   576,    -1,   578,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
      -1,   591,   592,    -1,    -1,   595,    -1,    -1,   598,    -1,
     600,    -1,   602,   603,   604,    -1,    -1,   607,   608,   609,
     610,   611,    -1,    -1,   614,   615,    -1,   617,   618,   619,
     620,   621,   622,   623,   624,    -1,    -1,    -1,    -1,    -1,
      -1,   631,   632,    -1,   634,   635,   636,    -1,    -1,   639,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   647,   648,    -1,
      -1,    -1,    -1,   653,   654,    -1,    -1,   657,   658,    -1,
      -1,   661,   662,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    55,    56,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,   101,
     102,   103,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,    -1,   117,   118,   119,   120,   121,
     122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,   167,   168,    -1,   170,   171,
     172,   173,   174,   175,   176,   177,    -1,   179,   180,   181,
     182,   183,   184,   185,   186,    -1,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
      -1,   203,   204,   205,   206,   207,   208,   209,    -1,   211,
      -1,   213,   214,   215,   216,    -1,   218,   219,   220,    -1,
     222,   223,    -1,    -1,    -1,   227,   228,   229,   230,   231,
     232,    -1,   234,   235,   236,    -1,   238,    -1,   240,    -1,
      -1,    -1,   244,   245,   246,   247,    -1,    -1,   250,    -1,
     252,   253,    -1,   255,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,   265,    -1,    -1,   268,    -1,   270,   271,
     272,    -1,    -1,    -1,    -1,    -1,   278,   279,    -1,   281,
      -1,   283,    -1,   285,   286,    -1,    -1,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,   329,   330,   331,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,    -1,
     352,   353,   354,    -1,    -1,   357,   358,   359,   360,   361,
     362,   363,   364,   365,    -1,   367,   368,   369,    -1,   371,
     372,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,   391,
     392,    -1,   394,   395,    -1,   397,    -1,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,   409,    -1,   411,
     412,   413,    -1,   415,    -1,   417,   418,   419,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,   436,    -1,    -1,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,   448,   449,   450,   451,
     452,   453,    -1,   455,    -1,   457,   458,    -1,   460,   461,
      -1,   463,    -1,   465,    -1,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,    -1,   481,
     482,    -1,    -1,    -1,   486,   487,   488,   489,    -1,    -1,
      -1,   493,    -1,    -1,    -1,   497,    -1,   499,   500,   501,
     502,   503,   504,    -1,   506,   507,   508,   509,   510,   511,
      -1,    -1,    -1,    -1,    -1,    -1,   518,   519,    -1,   521,
      -1,    -1,   524,    -1,    -1,   527,   528,    -1,    -1,    -1,
     532,   533,   534,   535,   536,    -1,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   548,   549,   550,   551,
     552,    -1,   554,    -1,   556,   557,   558,   559,    -1,   561,
     562,   563,    -1,   565,   566,   567,   568,    -1,    -1,    -1,
      -1,    -1,   574,   575,   576,    -1,   578,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,    -1,   591,
     592,    -1,    -1,   595,    -1,    -1,   598,    -1,   600,    -1,
     602,   603,   604,    -1,    -1,   607,   608,   609,   610,   611,
      -1,    -1,   614,   615,    -1,   617,   618,   619,   620,   621,
     622,   623,   624,    -1,    -1,    -1,    -1,    -1,    -1,   631,
     632,    -1,   634,   635,   636,    -1,    -1,   639,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,
      -1,   653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,
     662,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    36,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    55,    56,    57,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,   101,   102,   103,
      -1,    -1,   106,   107,   108,   109,   110,   111,    -1,   113,
     114,   115,    -1,   117,   118,   119,   120,   121,   122,    -1,
      -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,   167,   168,    -1,   170,   171,   172,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
     184,   185,   186,    -1,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,    -1,   213,
     214,   215,   216,    -1,   218,   219,   220,    -1,   222,   223,
      -1,    -1,    -1,   227,   228,   229,   230,   231,   232,    -1,
     234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,
     244,   245,   246,   247,    -1,    -1,   250,    -1,   252,   253,
      -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,   265,    -1,    -1,   268,    -1,   270,   271,   272,    -1,
      -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,
      -1,   285,   286,    -1,    -1,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,   329,   330,   331,    -1,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,    -1,   352,   353,
     354,    -1,    -1,   357,   358,   359,   360,   361,   362,   363,
     364,   365,    -1,   367,   368,   369,    -1,   371,   372,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,
     394,   395,    -1,   397,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,   409,    -1,   411,   412,   413,
      -1,   415,    -1,   417,   418,   419,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,   436,    -1,    -1,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,   448,   449,   450,   451,   452,   453,
      -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,   463,
      -1,   465,    -1,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,    -1,
      -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,
      -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,   506,   507,   508,   509,   510,   511,    -1,    -1,
      -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,
     524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,   533,
     534,   535,   536,    -1,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   548,   549,   550,   551,   552,    -1,
     554,    -1,   556,   557,   558,   559,    -1,   561,   562,   563,
      -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,
     574,   575,   576,    -1,   578,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,    -1,   591,   592,    -1,
      -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,
     604,    -1,    -1,   607,   608,   609,   610,   611,    -1,    -1,
     614,   615,    -1,   617,   618,   619,   620,   621,   622,   623,
     624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,
     634,   635,   636,    -1,    -1,   639,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,   653,
     654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,
      56,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,   101,   102,   103,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
      -1,   117,   118,   119,   120,   121,   122,    -1,    -1,    -1,
      -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,   167,   168,    -1,   170,   171,   172,   173,   174,   175,
     176,   177,    -1,   179,   180,   181,   182,   183,   184,   185,
     186,    -1,   188,   189,   190,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,    -1,   213,   214,   215,
     216,    -1,   218,   219,   220,    -1,   222,   223,    -1,    -1,
      -1,   227,   228,   229,   230,   231,   232,    -1,   234,   235,
     236,    -1,   238,    -1,   240,    -1,    -1,    -1,   244,   245,
     246,   247,    -1,    -1,   250,    -1,   252,   253,    -1,   255,
     256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,   265,
      -1,    -1,   268,    -1,   270,   271,   272,    -1,    -1,    -1,
      -1,    -1,   278,   279,    -1,   281,    -1,   283,    -1,   285,
     286,    -1,    -1,   289,    -1,    -1,    -1,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,   329,   330,   331,    -1,    -1,   334,   335,
     336,   337,    -1,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,    -1,   352,   353,   354,    -1,
      -1,   357,   358,   359,   360,   361,   362,   363,   364,   365,
      -1,   367,   368,   369,    -1,   371,   372,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,   391,   392,    -1,   394,   395,
      -1,   397,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,   409,    -1,   411,   412,   413,    -1,   415,
      -1,   417,   418,   419,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
     436,    -1,    -1,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,   448,   449,   450,   451,   452,   453,    -1,   455,
      -1,   457,   458,    -1,   460,   461,    -1,   463,    -1,   465,
      -1,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,    -1,   481,   482,    -1,    -1,    -1,
     486,   487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,
      -1,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
     506,   507,   508,   509,   510,   511,    -1,    -1,    -1,    -1,
      -1,    -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,
      -1,   527,   528,    -1,    -1,    -1,   532,   533,   534,   535,
     536,    -1,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,    -1,   554,    -1,
     556,   557,   558,   559,    -1,   561,   562,   563,    -1,   565,
     566,   567,   568,    -1,    -1,    -1,    -1,    -1,   574,   575,
     576,    -1,   578,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,    -1,   591,   592,    -1,    -1,   595,
      -1,    -1,   598,    -1,   600,    -1,   602,   603,   604,    -1,
      -1,   607,   608,   609,   610,   611,    -1,    -1,   614,   615,
      -1,   617,   618,   619,   620,   621,   622,   623,   624,    -1,
      -1,    -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,
     636,    -1,    -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,
      -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    36,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    55,    56,    57,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,   101,   102,   103,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,    -1,   117,
     118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,   177,
      -1,   179,   180,   181,   182,   183,   184,   185,   186,    -1,
     188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,   213,   214,   215,   216,    -1,
     218,   219,   220,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,   232,    -1,   234,   235,   236,    -1,
     238,    -1,   240,    -1,    -1,    -1,   244,   245,   246,   247,
      -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,   270,   271,   272,    -1,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,   289,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,   336,   337,
      -1,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,   352,   353,   354,    -1,    -1,   357,
     358,   359,   360,   361,   362,   363,   364,   365,    -1,   367,
     368,   369,    -1,   371,   372,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,   394,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,   409,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,   451,   452,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,   533,   534,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,   561,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
     578,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,   607,
     608,   609,   610,   611,    -1,    -1,   614,   615,    -1,   617,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
      -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   647,
     648,    -1,    -1,    -1,    -1,   653,   654,    -1,    -1,   657,
     658,    -1,    -1,   661,   662,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    36,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    55,    56,    57,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,   101,   102,   103,    -1,    -1,   106,   107,   108,   109,
     110,   111,    -1,   113,   114,   115,    -1,   117,   118,   119,
     120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,
      -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,   167,   168,    -1,
     170,   171,   172,   173,   174,   175,   176,   177,    -1,   179,
     180,   181,   182,   183,   184,   185,   186,    -1,   188,   189,
     190,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,    -1,   203,   204,   205,   206,   207,   208,   209,
      -1,   211,    -1,   213,   214,   215,   216,    -1,   218,   219,
     220,    -1,   222,   223,    -1,    -1,    -1,   227,   228,   229,
     230,   231,   232,    -1,   234,   235,   236,    -1,   238,    -1,
     240,    -1,    -1,    -1,   244,   245,   246,   247,    -1,    -1,
     250,    -1,   252,   253,    -1,   255,   256,    -1,    -1,    -1,
     260,    -1,    -1,   263,   264,   265,    -1,    -1,   268,    -1,
     270,   271,   272,    -1,    -1,    -1,    -1,    -1,   278,   279,
      -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,   289,
      -1,    -1,    -1,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,    -1,    -1,   326,   327,   328,   329,
     330,   331,    -1,    -1,   334,   335,   336,   337,    -1,   339,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,    -1,   352,   353,   354,    -1,    -1,   357,   358,   359,
     360,   361,    -1,   363,   364,   365,    -1,   367,   368,   369,
      -1,   371,   372,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     390,   391,   392,    -1,   394,   395,    -1,   397,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,   409,
      -1,   411,   412,   413,    -1,   415,    -1,   417,   418,   419,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,   448,   449,
     450,   451,   452,   453,    -1,   455,    -1,   457,   458,    -1,
     460,   461,    -1,   463,    -1,   465,    -1,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
      -1,   481,   482,    -1,    -1,    -1,   486,   487,   488,   489,
      -1,    -1,    -1,   493,    -1,    -1,    -1,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,   506,   507,   508,   509,
     510,   511,    -1,    -1,    -1,    -1,    -1,    -1,   518,   519,
      -1,   521,    -1,    -1,   524,    -1,    -1,   527,   528,    -1,
      -1,    -1,   532,   533,   534,   535,   536,    -1,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   548,   549,
     550,   551,   552,    -1,   554,    -1,   556,   557,   558,   559,
      -1,   561,   562,   563,    -1,   565,   566,   567,   568,    -1,
      -1,    -1,    -1,    -1,   574,   575,   576,    -1,   578,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
      -1,   591,   592,    -1,    -1,   595,    -1,    -1,   598,    -1,
     600,    -1,   602,   603,   604,    -1,    -1,   607,   608,   609,
     610,   611,    -1,    -1,   614,   615,    -1,   617,   618,   619,
     620,   621,   622,   623,   624,    -1,    -1,    -1,    -1,    -1,
      -1,   631,   632,    -1,   634,   635,   636,    -1,    -1,   639,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   647,   648,    -1,
      -1,    -1,    -1,   653,   654,    -1,    -1,   657,   658,    -1,
      -1,   661,   662,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    55,    56,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,   101,
     102,   103,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,    -1,   117,   118,   119,   120,   121,
     122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,   167,   168,    -1,   170,   171,
     172,   173,   174,   175,   176,   177,    -1,   179,   180,   181,
     182,   183,   184,   185,   186,    -1,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
      -1,   203,   204,   205,   206,   207,   208,   209,    -1,   211,
      -1,   213,   214,   215,   216,    -1,   218,   219,   220,    -1,
     222,   223,    -1,    -1,    -1,   227,   228,   229,   230,   231,
     232,    -1,   234,   235,   236,    -1,   238,    -1,   240,    -1,
      -1,    -1,   244,   245,   246,   247,    -1,    -1,   250,    -1,
     252,   253,    -1,   255,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,   265,    -1,    -1,   268,    -1,   270,   271,
     272,    -1,    -1,    -1,    -1,    -1,   278,   279,    -1,   281,
      -1,   283,    -1,   285,   286,    -1,    -1,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,   329,   330,   331,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,    -1,
     352,   353,   354,    -1,    -1,   357,   358,   359,   360,   361,
      -1,   363,   364,   365,    -1,   367,   368,   369,    -1,   371,
     372,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,   391,
     392,    -1,   394,   395,    -1,   397,    -1,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,   409,    -1,   411,
     412,   413,    -1,   415,    -1,   417,   418,   419,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,   436,    -1,    -1,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,   448,   449,   450,   451,
     452,   453,    -1,   455,    -1,   457,   458,    -1,   460,   461,
      -1,   463,    -1,   465,    -1,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,    -1,   481,
     482,    -1,    -1,    -1,   486,   487,   488,   489,    -1,    -1,
      -1,   493,    -1,    -1,    -1,   497,    -1,   499,   500,   501,
     502,   503,   504,    -1,   506,   507,   508,   509,   510,   511,
      -1,    -1,    -1,    -1,    -1,    -1,   518,   519,    -1,   521,
      -1,    -1,   524,    -1,    -1,   527,   528,    -1,    -1,    -1,
     532,   533,   534,   535,   536,    -1,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   548,   549,   550,   551,
     552,    -1,   554,    -1,   556,   557,   558,   559,    -1,   561,
     562,   563,    -1,   565,   566,   567,   568,    -1,    -1,    -1,
      -1,    -1,   574,   575,   576,    -1,   578,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,    -1,   591,
     592,    -1,    -1,   595,    -1,    -1,   598,    -1,   600,    -1,
     602,   603,   604,    -1,    -1,   607,   608,   609,   610,   611,
      -1,    -1,   614,   615,    -1,   617,   618,   619,   620,   621,
     622,   623,   624,    -1,    -1,    -1,    -1,    -1,    -1,   631,
     632,    -1,   634,   635,   636,    -1,    -1,   639,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,
      -1,   653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,
     662,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    36,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    55,    56,    57,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,   101,   102,   103,
      -1,    -1,   106,   107,   108,   109,   110,   111,    -1,   113,
     114,   115,    -1,   117,   118,   119,   120,   121,   122,    -1,
      -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,   167,   168,    -1,   170,   171,   172,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
     184,   185,   186,    -1,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,    -1,   213,
     214,   215,   216,    -1,   218,   219,   220,    -1,   222,   223,
      -1,    -1,    -1,   227,   228,   229,   230,   231,   232,    -1,
     234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,
     244,   245,   246,   247,    -1,    -1,   250,    -1,   252,   253,
      -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,   265,    -1,    -1,   268,    -1,   270,   271,   272,    -1,
      -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,
      -1,   285,   286,    -1,    -1,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,   329,   330,   331,    -1,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,    -1,   352,   353,
     354,    -1,    -1,   357,   358,   359,   360,   361,    -1,   363,
     364,   365,    -1,   367,   368,   369,    -1,   371,   372,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,
     394,   395,    -1,   397,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,   409,    -1,   411,   412,   413,
      -1,   415,    -1,   417,   418,   419,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,   436,    -1,    -1,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,   448,   449,   450,   451,   452,   453,
      -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,   463,
      -1,   465,    -1,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,    -1,
      -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,
      -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,   506,   507,   508,   509,   510,   511,    -1,    -1,
      -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,
     524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,   533,
     534,   535,   536,    -1,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   548,   549,   550,   551,   552,    -1,
     554,    -1,   556,   557,   558,   559,    -1,   561,   562,   563,
      -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,
     574,   575,   576,    -1,   578,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,    -1,   591,   592,    -1,
      -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,
     604,    -1,    -1,   607,   608,   609,   610,   611,    -1,    -1,
     614,   615,    -1,   617,   618,   619,   620,   621,   622,   623,
     624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,
     634,   635,   636,    -1,    -1,   639,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,   653,
     654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,
      56,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,   101,   102,   103,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
      -1,   117,   118,   119,   120,   121,   122,    -1,    -1,    -1,
      -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,   167,   168,    -1,   170,   171,   172,   173,   174,   175,
     176,   177,    -1,   179,   180,   181,   182,   183,   184,   185,
     186,    -1,   188,   189,   190,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,    -1,   213,   214,   215,
     216,    -1,   218,   219,   220,    -1,   222,   223,    -1,    -1,
      -1,   227,   228,   229,   230,   231,   232,    -1,   234,   235,
     236,    -1,   238,    -1,   240,    -1,    -1,    -1,   244,   245,
     246,   247,    -1,    -1,   250,    -1,   252,   253,    -1,   255,
     256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,   265,
      -1,    -1,   268,    -1,   270,   271,   272,    -1,    -1,    -1,
      -1,    -1,   278,   279,    -1,   281,    -1,   283,    -1,   285,
     286,    -1,    -1,   289,    -1,    -1,    -1,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,   329,   330,   331,    -1,    -1,   334,   335,
     336,   337,    -1,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,    -1,   352,   353,   354,    -1,
      -1,   357,   358,   359,   360,   361,    -1,   363,   364,   365,
      -1,   367,   368,   369,    -1,   371,   372,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,   391,   392,    -1,   394,   395,
      -1,   397,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,   409,    -1,   411,   412,   413,    -1,   415,
      -1,   417,   418,   419,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
     436,    -1,    -1,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,   448,   449,   450,   451,   452,   453,    -1,   455,
      -1,   457,   458,    -1,   460,   461,    -1,   463,    -1,   465,
      -1,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,    -1,   481,   482,    -1,    -1,    -1,
     486,   487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,
      -1,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
     506,   507,   508,   509,   510,   511,    -1,    -1,    -1,    -1,
      -1,    -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,
      -1,   527,   528,    -1,    -1,    -1,   532,   533,   534,   535,
     536,    -1,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,    -1,   554,    -1,
     556,   557,   558,   559,    -1,   561,   562,   563,    -1,   565,
     566,   567,   568,    -1,    -1,    -1,    -1,    -1,   574,   575,
     576,    -1,   578,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,    -1,   591,   592,    -1,    -1,   595,
      -1,    -1,   598,    -1,   600,    -1,   602,   603,   604,    -1,
      -1,   607,   608,   609,   610,   611,    -1,    -1,   614,   615,
      -1,   617,   618,   619,   620,   621,   622,   623,   624,    -1,
      -1,    -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,
     636,    -1,    -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,
      -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      38,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,    -1,
      -1,   179,   180,   181,   182,    -1,   184,   185,   186,    -1,
     188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,
     218,   219,   220,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,    -1,    -1,   234,   235,   236,    -1,
     238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,
      -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,    -1,   271,   272,    -1,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,   289,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,    -1,   315,   316,   317,
     318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,    -1,   337,
      -1,   339,    -1,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,   352,   353,   354,    -1,    -1,   357,
     358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,   367,
     368,   369,    -1,   371,   372,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,    -1,    -1,   546,   547,
     548,   549,    -1,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,   561,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
      -1,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
      -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,   661,   662,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,
      57,    58,    -1,    60,    61,    -1,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    93,    94,    95,    96,
      97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,
      -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,
     117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,
     127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
     167,   168,    -1,   170,   171,   172,   173,   174,   175,   176,
      -1,    -1,   179,   180,   181,   182,    -1,    -1,   185,   186,
      -1,   188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,    -1,    -1,   214,   215,   216,
      -1,   218,    -1,    -1,    -1,   222,   223,    -1,    -1,    -1,
     227,   228,   229,   230,   231,    -1,    -1,   234,   235,   236,
     237,   238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,
      -1,    -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,
      -1,    -1,    -1,   260,   261,    -1,   263,   264,   265,    -1,
      -1,   268,    -1,    -1,   271,   272,    -1,   274,    -1,    -1,
      -1,   278,   279,    -1,   281,    -1,   283,    -1,   285,   286,
      -1,    -1,    -1,    -1,    -1,    -1,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,    -1,   310,   311,   312,   313,    -1,   315,   316,
     317,   318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,
     327,   328,   329,   330,   331,    -1,    -1,   334,   335,    -1,
     337,    -1,   339,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,    -1,    -1,   353,   354,    -1,    -1,
     357,   358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,
      -1,    -1,   369,    -1,   371,   372,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,
     397,    -1,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,
     417,   418,   419,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,   436,
      -1,    -1,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,   448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,
     457,   458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,
      -1,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,    -1,   481,   482,   483,    -1,    -1,   486,
     487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,   506,
     507,   508,   509,   510,   511,   512,    -1,    -1,    -1,    -1,
      -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,
     527,   528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,
      -1,   538,   539,   540,   541,   542,   543,    -1,    -1,   546,
     547,   548,   549,    -1,   551,   552,    -1,   554,    -1,   556,
     557,   558,   559,    -1,    -1,   562,   563,    -1,   565,   566,
     567,   568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,
      -1,    -1,    -1,   580,   581,   582,   583,    -1,   585,   586,
      -1,   588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,
      -1,   598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,
      -1,   618,   619,   620,   621,   622,   623,   624,    -1,    -1,
      -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,
      -1,    -1,   639,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,   662,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    93,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,    -1,
      -1,   179,   180,   181,   182,    -1,    -1,   185,   186,    -1,
     188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,    -1,    -1,   234,   235,   236,   237,
     238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,
      -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,   261,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,    -1,   271,   272,    -1,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,    -1,   315,   316,   317,
     318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,    -1,   337,
      -1,   339,    -1,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,    -1,   353,   354,    -1,    -1,   357,
     358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,    -1,
      -1,   369,    -1,   371,   372,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,   512,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,    -1,    -1,   546,   547,
     548,   549,    -1,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,    -1,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
      -1,    -1,   580,   581,   582,   583,    -1,   585,   586,    -1,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
      -1,   639,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,   662,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,
      -1,    60,    61,    -1,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,
      -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,
     119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,
      -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,   167,   168,
      -1,   170,   171,   172,   173,   174,   175,   176,    -1,    -1,
     179,   180,   181,   182,    -1,    -1,   185,   186,    -1,   188,
     189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,    -1,
     199,    -1,   201,    -1,   203,   204,   205,   206,   207,   208,
     209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,   218,
      -1,    -1,    -1,   222,   223,    -1,    -1,    -1,   227,   228,
     229,   230,   231,    -1,    -1,   234,   235,   236,    -1,   238,
      -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,    -1,
      -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,    -1,
      -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,   268,
      -1,    -1,   271,   272,    -1,    -1,    -1,    -1,    -1,   278,
     279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,
      -1,    -1,    -1,    -1,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
      -1,   310,   311,   312,   313,    -1,   315,   316,   317,   318,
      -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,
     329,   330,   331,    -1,    -1,   334,   335,    -1,   337,    -1,
     339,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,    -1,    -1,   353,   354,    -1,    -1,   357,   358,
     359,   360,    -1,    -1,    -1,   364,   365,    -1,    -1,    -1,
     369,    -1,   371,   372,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,    -1,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
      -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,   418,
     419,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,   448,
     449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,   458,
      -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,    -1,    -1,   486,   487,   488,
     489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,   506,   507,   508,
     509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,   518,
     519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,   528,
      -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,   538,
     539,   540,   541,   542,   543,    -1,    -1,   546,   547,   548,
     549,    -1,   551,   552,    -1,   554,    -1,   556,   557,   558,
     559,    -1,    -1,   562,   563,    -1,   565,   566,   567,   568,
      -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,    -1,
      -1,   580,   581,   582,   583,    -1,   585,   586,    -1,   588,
     589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,   598,
      -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,   618,
     619,   620,   621,   622,   623,   624,    -1,    -1,    -1,    -1,
      -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,    -1,
     639,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,   655,    -1,    -1,    19,
      -1,    -1,    22,   662,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,   167,   168,    -1,
     170,   171,   172,   173,   174,   175,   176,    -1,    -1,   179,
     180,   181,   182,    -1,    -1,   185,   186,    -1,   188,   189,
     190,    -1,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,    -1,   203,   204,   205,   206,   207,   208,   209,
      -1,   211,    -1,    -1,   214,   215,   216,    -1,   218,    -1,
      -1,    -1,   222,   223,    -1,    -1,    -1,   227,   228,   229,
     230,   231,    -1,    -1,   234,   235,   236,    -1,   238,    -1,
     240,    -1,    -1,    -1,    -1,   245,   246,    -1,    -1,    -1,
     250,    -1,   252,   253,    -1,   255,   256,    -1,    -1,    -1,
     260,    -1,    -1,   263,   264,   265,    -1,    -1,   268,    -1,
      -1,   271,   272,    -1,    -1,    -1,    -1,    -1,   278,   279,
      -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,    -1,
      -1,    -1,    -1,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,    -1,   315,   316,   317,   318,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,   329,
     330,   331,    -1,    -1,   334,   335,    -1,   337,    -1,   339,
      -1,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,    -1,    -1,   353,   354,    -1,    -1,   357,   358,   359,
     360,    -1,    -1,    -1,   364,   365,    -1,    -1,    -1,   369,
      -1,   371,   372,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     390,   391,   392,    -1,    -1,   395,    -1,   397,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,    -1,
      -1,   411,   412,   413,    -1,   415,    -1,   417,   418,   419,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,   448,   449,
     450,    -1,    -1,   453,    -1,   455,    -1,   457,   458,    -1,
     460,   461,    -1,   463,    -1,   465,    -1,    -1,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
      -1,   481,   482,    -1,    -1,    -1,   486,   487,   488,   489,
      -1,    -1,    -1,   493,    -1,    -1,    -1,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,   506,   507,   508,   509,
     510,   511,    -1,    -1,    -1,    -1,    -1,    -1,   518,   519,
      -1,   521,    -1,    -1,   524,    -1,    -1,   527,   528,    -1,
      -1,    -1,   532,    -1,    -1,   535,   536,    -1,   538,   539,
     540,   541,   542,   543,    -1,    -1,   546,   547,   548,   549,
      -1,   551,   552,    -1,   554,    -1,   556,   557,   558,   559,
      -1,    -1,   562,   563,    -1,   565,   566,   567,   568,    -1,
      -1,    -1,    -1,    -1,   574,   575,   576,    -1,    -1,    -1,
     580,   581,   582,   583,    -1,   585,   586,    -1,   588,   589,
      -1,   591,   592,    -1,    -1,   595,    -1,    -1,   598,    -1,
     600,    -1,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,    -1,    -1,   614,    -1,    -1,    -1,   618,   619,
     620,   621,   622,   623,   624,    -1,    -1,    -1,    -1,    -1,
      -1,   631,   632,    -1,   634,   635,   636,    -1,    -1,   639,
      -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,   655,    15,    -1,    -1,    -1,
      19,   661,   662,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,
      -1,    60,    61,    -1,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,
      -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,
     119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,
      -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,   167,   168,
      -1,   170,   171,   172,   173,   174,   175,   176,    -1,    -1,
     179,   180,   181,   182,    -1,    -1,   185,   186,    -1,   188,
     189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,    -1,
     199,    -1,   201,    -1,   203,   204,   205,   206,   207,   208,
     209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,   218,
      -1,    -1,    -1,   222,   223,    -1,    -1,    -1,   227,   228,
     229,   230,   231,    -1,    -1,   234,   235,   236,    -1,   238,
      -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,    -1,
      -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,    -1,
      -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,   268,
      -1,    -1,   271,   272,    -1,    -1,    -1,    -1,    -1,   278,
     279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,
      -1,    -1,    -1,    -1,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
      -1,   310,   311,   312,   313,    -1,   315,   316,   317,   318,
      -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,
     329,   330,   331,    -1,    -1,   334,   335,    -1,   337,    -1,
     339,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,    -1,    -1,   353,   354,    -1,    -1,   357,   358,
     359,   360,    -1,    -1,    -1,   364,   365,    -1,    -1,    -1,
     369,    -1,   371,   372,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,    -1,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
      -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,   418,
     419,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,   448,
     449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,   458,
      -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,   488,
     489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,   506,   507,   508,
     509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,   518,
     519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,   528,
      -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,   538,
     539,   540,   541,   542,   543,    -1,    -1,   546,   547,   548,
     549,    -1,   551,   552,    -1,   554,    -1,   556,   557,   558,
     559,    -1,    -1,   562,   563,    -1,   565,   566,   567,   568,
      -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,    -1,
      -1,   580,   581,   582,   583,    -1,   585,   586,    -1,   588,
     589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,   598,
      -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,   618,
     619,   620,   621,   622,   623,   624,    -1,    -1,    -1,    -1,
      -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,    -1,
     639,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    12,   654,    -1,    15,    -1,    -1,
      -1,    19,    -1,   662,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,    -1,
      -1,   179,   180,   181,   182,    -1,    -1,   185,   186,    -1,
     188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,    -1,    -1,   234,   235,   236,    -1,
     238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,    -1,   271,   272,    -1,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,    -1,   315,   316,   317,
     318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,    -1,   337,
      -1,   339,    -1,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,    -1,   353,   354,    -1,    -1,   357,
     358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,    -1,
      -1,   369,    -1,   371,   372,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,    -1,    -1,   546,   547,
     548,   549,    -1,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,    -1,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
      -1,    -1,   580,   581,   582,   583,    -1,   585,   586,    -1,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
      -1,   639,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,   662,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,
      -1,    60,    61,    -1,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,
      -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,
     119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,
      -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,   167,   168,
      -1,   170,   171,   172,   173,   174,   175,   176,    -1,    -1,
     179,   180,   181,   182,    -1,    -1,   185,   186,    -1,   188,
     189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,    -1,
     199,    -1,   201,    -1,   203,   204,   205,   206,   207,   208,
     209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,   218,
      -1,    -1,    -1,   222,   223,    -1,    -1,    -1,   227,   228,
     229,   230,   231,    -1,    -1,   234,   235,   236,    -1,   238,
      -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,    -1,
      -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,    -1,
      -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,   268,
      -1,    -1,   271,   272,    -1,    -1,    -1,    -1,    -1,   278,
     279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,
      -1,    -1,    -1,    -1,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
      -1,   310,   311,   312,   313,    -1,   315,   316,   317,   318,
      -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,
     329,   330,   331,    -1,    -1,   334,   335,    -1,   337,    -1,
     339,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,    -1,    -1,   353,   354,    -1,    -1,   357,   358,
     359,   360,    -1,    -1,    -1,   364,   365,    -1,    -1,    -1,
     369,    -1,   371,   372,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,    -1,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
      -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,   418,
     419,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,   448,
     449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,   458,
      -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,   488,
     489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,   506,   507,   508,
     509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,   518,
     519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,   528,
      -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,   538,
     539,   540,   541,   542,   543,    -1,    -1,   546,   547,   548,
     549,    -1,   551,   552,    -1,   554,    -1,   556,   557,   558,
     559,    -1,    -1,   562,   563,    -1,   565,   566,   567,   568,
      -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,    -1,
      -1,   580,   581,   582,   583,    -1,   585,   586,    -1,   588,
     589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,   598,
      -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,   618,
     619,   620,   621,   622,   623,   624,    -1,    -1,    -1,    -1,
      -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,    -1,
     639,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     649,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,   662,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,   167,   168,    -1,   170,   171,   172,   173,
     174,   175,   176,    -1,    -1,   179,   180,   181,   182,    -1,
      -1,   185,   186,    -1,   188,   189,   190,    -1,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,    -1,    -1,
     214,   215,   216,    -1,   218,    -1,    -1,    -1,   222,   223,
      -1,    -1,    -1,   227,   228,   229,   230,   231,    -1,    -1,
     234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,
      -1,   245,   246,    -1,    -1,    -1,   250,    -1,   252,   253,
      -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,   265,    -1,    -1,   268,    -1,    -1,   271,   272,    -1,
      -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,
      -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
      -1,   315,   316,   317,   318,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,   329,   330,   331,    -1,    -1,
     334,   335,    -1,   337,    -1,   339,    -1,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,    -1,    -1,   353,
     354,    -1,    -1,   357,   358,   359,   360,    -1,    -1,    -1,
     364,   365,    -1,    -1,    -1,   369,    -1,   371,   372,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,
      -1,   395,    -1,   397,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,    -1,    -1,   411,   412,   413,
      -1,   415,    -1,   417,   418,   419,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,   436,    -1,    -1,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,   448,   449,   450,    -1,    -1,   453,
      -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,   463,
      -1,   465,    -1,    -1,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,    -1,
      -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,
      -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,   506,   507,   508,   509,   510,   511,    -1,    -1,
      -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,
     524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,    -1,
      -1,   535,   536,    -1,   538,   539,   540,   541,   542,   543,
      -1,    -1,   546,   547,   548,   549,    -1,   551,   552,    -1,
     554,    -1,   556,   557,   558,   559,    -1,    -1,   562,   563,
      -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,
     574,   575,   576,    -1,    -1,    -1,   580,   581,   582,   583,
      -1,   585,   586,    -1,   588,   589,    -1,   591,   592,    -1,
      -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,
     614,    -1,    -1,    -1,   618,   619,   620,   621,   622,   623,
     624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,
     634,   635,   636,    -1,    -1,   639,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    12,
     654,    -1,    15,    -1,    -1,    -1,    19,    -1,   662,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,    -1,    -1,
     103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,
     113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,
      -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,   167,   168,    -1,   170,   171,   172,
     173,   174,   175,   176,    -1,    -1,   179,   180,   181,   182,
      -1,    -1,   185,   186,    -1,   188,   189,   190,    -1,    -1,
     193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,
     203,   204,   205,   206,   207,   208,   209,    -1,   211,    -1,
      -1,   214,   215,   216,    -1,   218,    -1,    -1,    -1,   222,
     223,    -1,    -1,    -1,   227,   228,   229,   230,   231,    -1,
      -1,   234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,
      -1,    -1,   245,   246,    -1,    -1,    -1,   250,    -1,   252,
     253,    -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,
     263,   264,   265,    -1,    -1,   268,    -1,    -1,   271,   272,
      -1,    -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,
     283,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,    -1,   310,   311,   312,
     313,    -1,   315,   316,   317,   318,    -1,   320,   321,    -1,
      -1,    -1,    -1,   326,   327,   328,   329,   330,   331,    -1,
      -1,   334,   335,    -1,   337,    -1,   339,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,    -1,    -1,
     353,   354,    -1,    -1,   357,   358,   359,   360,    -1,    -1,
      -1,   364,   365,    -1,    -1,    -1,   369,    -1,   371,   372,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,
      -1,    -1,   395,    -1,   397,    -1,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,    -1,    -1,   411,   412,
     413,    -1,   415,    -1,   417,   418,   419,   420,   421,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,   436,    -1,    -1,   439,   440,   441,   442,
     443,    -1,   445,   446,    -1,   448,   449,   450,    -1,    -1,
     453,    -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,
     463,    -1,   465,    -1,    -1,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,    -1,   481,   482,
      -1,    -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,
     493,    -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,   506,   507,   508,   509,   510,   511,    -1,
      -1,    -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,
      -1,   524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,
      -1,    -1,   535,   536,    -1,   538,   539,   540,   541,   542,
     543,    -1,    -1,   546,   547,   548,   549,    -1,   551,   552,
      -1,   554,    -1,   556,   557,   558,   559,    -1,    -1,   562,
     563,    -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,
      -1,   574,   575,   576,    -1,    -1,    -1,   580,   581,   582,
     583,    -1,   585,   586,    -1,   588,   589,    -1,   591,   592,
      -1,    -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,
      -1,   614,    -1,    -1,    -1,   618,   619,   620,   621,   622,
     623,   624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,
      -1,   634,   635,   636,    -1,    -1,   639,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,   661,   662,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,
      -1,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,
      -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,
      -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,   167,   168,    -1,   170,   171,
     172,   173,   174,   175,   176,    -1,    -1,   179,   180,   181,
     182,    -1,    -1,   185,   186,    -1,   188,   189,   190,    -1,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
      -1,   203,   204,   205,   206,   207,   208,   209,    -1,   211,
      -1,    -1,   214,   215,   216,    -1,   218,    -1,    -1,    -1,
     222,   223,    -1,    -1,    -1,   227,   228,   229,   230,   231,
      -1,    -1,   234,   235,   236,    -1,   238,    -1,   240,    -1,
      -1,    -1,    -1,   245,   246,    -1,    -1,    -1,   250,    -1,
     252,   253,    -1,   255,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,   265,    -1,    -1,   268,    -1,    -1,   271,
     272,    -1,    -1,    -1,    -1,    -1,   278,   279,    -1,   281,
      -1,   283,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,
      -1,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,    -1,   315,   316,   317,   318,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,   329,   330,   331,
      -1,    -1,   334,   335,    -1,   337,    -1,   339,    -1,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,    -1,
      -1,   353,   354,    -1,    -1,   357,   358,   359,   360,    -1,
      -1,    -1,   364,   365,    -1,    -1,    -1,   369,    -1,   371,
     372,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,   391,
     392,    -1,    -1,   395,    -1,   397,    -1,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,    -1,    -1,   411,
     412,   413,    -1,   415,    -1,   417,   418,   419,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,   436,    -1,    -1,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,   448,   449,   450,    -1,
      -1,   453,    -1,   455,    -1,   457,   458,    -1,   460,   461,
      -1,   463,    -1,   465,    -1,    -1,   468,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,    -1,   481,
     482,    -1,    -1,    -1,   486,   487,   488,   489,    -1,    -1,
      -1,   493,    -1,    -1,    -1,   497,    -1,   499,   500,   501,
     502,   503,   504,    -1,   506,   507,   508,   509,   510,   511,
      -1,    -1,    -1,    -1,    -1,    -1,   518,   519,    -1,   521,
      -1,    -1,   524,    -1,    -1,   527,   528,    -1,    -1,    -1,
     532,    -1,    -1,   535,   536,    -1,   538,   539,   540,   541,
     542,   543,    -1,    -1,   546,   547,   548,   549,    -1,   551,
     552,    -1,   554,    -1,   556,   557,   558,   559,    -1,    -1,
     562,   563,    -1,   565,   566,   567,   568,    -1,    -1,    -1,
      -1,    -1,   574,   575,   576,    -1,    -1,    -1,   580,   581,
     582,   583,    -1,   585,   586,    -1,   588,   589,    -1,   591,
     592,    -1,    -1,   595,    -1,    -1,   598,    -1,   600,    -1,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
      -1,    -1,   614,    -1,    -1,    -1,   618,   619,   620,   621,
     622,   623,   624,    -1,    -1,    -1,    -1,    -1,    -1,   631,
     632,    -1,   634,   635,   636,    -1,    -1,   639,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
     662,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,    -1,    -1,
     103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,
     113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,
      -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,   167,   168,    -1,   170,   171,   172,
     173,   174,   175,   176,    -1,    -1,   179,   180,   181,   182,
      -1,    -1,   185,   186,    -1,   188,   189,   190,    -1,    -1,
     193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,
     203,   204,   205,   206,   207,   208,   209,    -1,   211,    -1,
      -1,   214,   215,   216,    -1,   218,    -1,    -1,    -1,   222,
     223,    -1,    -1,    -1,   227,   228,   229,   230,   231,    -1,
      -1,   234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,
      -1,    -1,   245,   246,    -1,    -1,    -1,   250,    -1,   252,
     253,    -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,
     263,   264,   265,    -1,    -1,   268,    -1,    -1,   271,   272,
      -1,    -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,
     283,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,    -1,   310,   311,   312,
     313,    -1,   315,   316,   317,   318,    -1,   320,   321,    -1,
      -1,    -1,    -1,   326,   327,   328,   329,   330,   331,    -1,
      -1,   334,   335,    -1,   337,    -1,   339,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,    -1,    -1,
     353,   354,    -1,    -1,   357,   358,   359,   360,    -1,    -1,
      -1,   364,   365,    -1,    -1,    -1,   369,    -1,   371,   372,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,
      -1,    -1,   395,    -1,   397,    -1,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,    -1,    -1,   411,   412,
     413,    -1,   415,    -1,   417,   418,   419,   420,   421,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,   436,    -1,    -1,   439,   440,   441,   442,
     443,    -1,   445,   446,    -1,   448,   449,   450,    -1,    -1,
     453,    -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,
     463,    -1,   465,    -1,    -1,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,    -1,   481,   482,
      -1,    -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,
     493,    -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,   506,   507,   508,   509,   510,   511,    -1,
      -1,    -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,
      -1,   524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,
      -1,    -1,   535,   536,    -1,   538,   539,   540,   541,   542,
     543,    -1,    -1,   546,   547,   548,   549,    -1,   551,   552,
      -1,   554,    -1,   556,   557,   558,   559,    -1,    -1,   562,
     563,    -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,
      -1,   574,   575,   576,    -1,    -1,    -1,   580,   581,   582,
     583,    -1,   585,   586,    -1,   588,   589,    -1,   591,   592,
      -1,    -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,
      -1,   614,    -1,    -1,    -1,   618,   619,   620,   621,   622,
     623,   624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,
      -1,   634,   635,   636,    -1,    -1,   639,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,   662,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,   167,   168,    -1,   170,   171,   172,   173,
     174,   175,   176,    -1,    -1,   179,   180,   181,   182,    -1,
      -1,   185,   186,    -1,   188,   189,   190,    -1,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,    -1,    -1,
     214,   215,   216,    -1,   218,    -1,    -1,    -1,   222,   223,
      -1,    -1,    -1,   227,   228,   229,   230,   231,    -1,    -1,
     234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,
      -1,   245,   246,    -1,    -1,    -1,   250,    -1,   252,   253,
      -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,   265,    -1,    -1,   268,    -1,    -1,   271,   272,    -1,
      -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,
      -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
      -1,   315,   316,   317,   318,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,   329,   330,   331,    -1,    -1,
     334,   335,    -1,   337,    -1,   339,    -1,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,    -1,    -1,   353,
     354,    -1,    -1,   357,   358,   359,   360,    -1,    -1,    -1,
     364,   365,    -1,    -1,    -1,   369,    -1,   371,   372,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,
      -1,   395,    -1,   397,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,    -1,    -1,   411,   412,   413,
      -1,   415,    -1,   417,   418,   419,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,   436,    -1,    -1,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,   448,   449,   450,    -1,    -1,   453,
      -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,   463,
      -1,   465,    -1,    -1,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,    -1,
      -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,
      -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,   506,   507,   508,   509,   510,   511,    -1,    -1,
      -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,
     524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,    -1,
      -1,   535,   536,    -1,   538,   539,   540,   541,   542,   543,
      -1,    -1,   546,   547,   548,   549,    -1,   551,   552,    -1,
     554,    -1,   556,   557,   558,   559,    -1,    -1,   562,   563,
      -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,
     574,   575,   576,    -1,    -1,    -1,   580,   581,   582,   583,
      -1,   585,   586,    -1,   588,   589,    -1,   591,   592,    -1,
      -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,
     614,    -1,    -1,    -1,   618,   619,   620,   621,   622,   623,
     624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,
     634,   635,   636,    -1,    -1,   639,    -1,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,   662,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,   167,   168,    -1,   170,   171,   172,   173,   174,
     175,   176,    -1,    -1,   179,   180,   181,   182,    -1,    -1,
     185,   186,    -1,   188,   189,   190,    -1,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,    -1,    -1,   214,
     215,   216,    -1,   218,    -1,    -1,    -1,   222,   223,    -1,
      -1,    -1,   227,   228,   229,   230,   231,    -1,    -1,   234,
     235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,    -1,
     245,   246,    -1,    -1,    -1,   250,    -1,   252,   253,    -1,
     255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,
     265,    -1,    -1,   268,    -1,    -1,   271,   272,    -1,    -1,
      -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,    -1,
     285,   286,    -1,    -1,    -1,    -1,    -1,    -1,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,    -1,
     315,   316,   317,   318,    -1,   320,   321,    -1,    -1,    -1,
      -1,   326,   327,   328,   329,   330,   331,    -1,    -1,   334,
     335,    -1,   337,    -1,   339,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,    -1,    -1,   353,   354,
      -1,    -1,   357,   358,   359,   360,    -1,    -1,    -1,   364,
     365,    -1,    -1,    -1,   369,    -1,   371,   372,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,    -1,
     395,    -1,   397,    -1,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,    -1,    -1,   411,   412,   413,    -1,
     415,    -1,   417,   418,   419,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,   436,    -1,    -1,   439,   440,   441,   442,   443,    -1,
     445,   446,    -1,   448,   449,   450,    -1,    -1,   453,    -1,
     455,    -1,   457,   458,    -1,   460,   461,    -1,   463,    -1,
     465,    -1,    -1,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,    -1,   481,   482,    -1,    -1,
      -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,    -1,
      -1,    -1,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,   506,   507,   508,   509,   510,   511,    -1,    -1,    -1,
      -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,   524,
      -1,    -1,   527,   528,    -1,    -1,    -1,   532,    -1,    -1,
     535,   536,    -1,   538,   539,   540,   541,   542,   543,    -1,
      -1,   546,   547,   548,   549,    -1,   551,   552,    -1,   554,
      -1,   556,   557,   558,   559,    -1,    -1,   562,   563,    -1,
     565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,   574,
     575,   576,    -1,    -1,    -1,   580,   581,   582,   583,    -1,
     585,   586,    -1,   588,   589,    -1,   591,   592,    -1,    -1,
     595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,   614,
      -1,    -1,    -1,   618,   619,   620,   621,   622,   623,   624,
      -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,   634,
     635,   636,    -1,    -1,   639,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,   662,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,   167,   168,    -1,   170,   171,   172,   173,   174,   175,
     176,    -1,    -1,   179,   180,   181,   182,    -1,    -1,   185,
     186,    -1,   188,   189,   190,    -1,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,    -1,    -1,   214,   215,
     216,    -1,   218,    -1,    -1,    -1,   222,   223,    -1,    -1,
      -1,   227,   228,   229,   230,   231,    -1,    -1,   234,   235,
     236,    -1,   238,    -1,   240,    -1,    -1,    -1,    -1,   245,
     246,    -1,    -1,    -1,   250,    -1,   252,   253,    -1,   255,
     256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,   265,
      -1,    -1,   268,    -1,    -1,   271,   272,    -1,    -1,    -1,
      -1,    -1,   278,   279,    -1,   281,    -1,   283,    -1,   285,
     286,    -1,    -1,    -1,    -1,    -1,    -1,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,    -1,   315,
     316,   317,   318,    -1,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,   329,   330,   331,    -1,    -1,   334,   335,
      -1,   337,    -1,   339,    -1,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,    -1,    -1,   353,   354,    -1,
      -1,   357,   358,   359,   360,    -1,    -1,    -1,   364,   365,
      -1,    -1,    -1,   369,    -1,   371,   372,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,   391,   392,    -1,    -1,   395,
      -1,   397,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,    -1,    -1,   411,   412,   413,    -1,   415,
      -1,   417,   418,   419,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
     436,    -1,    -1,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,   448,   449,   450,    -1,    -1,   453,    -1,   455,
      -1,   457,   458,    -1,   460,   461,    -1,   463,    -1,   465,
      -1,    -1,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,    -1,   481,   482,    -1,    -1,    -1,
     486,   487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,
      -1,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
     506,   507,   508,   509,   510,   511,    -1,    -1,    -1,    -1,
      -1,    -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,
      -1,   527,   528,    -1,    -1,    -1,   532,    -1,    -1,   535,
     536,    -1,   538,   539,   540,   541,   542,   543,    -1,    -1,
     546,   547,   548,   549,    -1,   551,   552,    -1,   554,    -1,
     556,   557,   558,   559,    -1,    -1,   562,   563,    -1,   565,
     566,   567,   568,    -1,    -1,    -1,    -1,    -1,   574,   575,
     576,    -1,    -1,    -1,   580,   581,   582,   583,    -1,   585,
     586,    -1,   588,   589,    -1,   591,   592,    -1,    -1,   595,
      -1,    -1,   598,    -1,   600,    -1,   602,   603,   604,    -1,
      -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,   614,    -1,
      -1,    -1,   618,   619,   620,   621,   622,   623,   624,    -1,
      -1,    -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,
     636,    -1,    -1,   639,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,   661,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,    -1,
      -1,   179,   180,   181,   182,    -1,    -1,   185,   186,    -1,
     188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,    -1,    -1,   234,   235,   236,    -1,
     238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,
      -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,    -1,   271,   272,   273,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,    -1,   315,   316,   317,
     318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,    -1,   337,
      -1,   339,    -1,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,    -1,   353,   354,    -1,    -1,   357,
     358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,    -1,
      -1,   369,    -1,   371,   372,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,    -1,    -1,   546,   547,
     548,   549,    -1,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,   561,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
      -1,    -1,   580,   581,   582,   583,    -1,   585,   586,    -1,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
      -1,   639,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,   661,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,   167,   168,    -1,
     170,   171,   172,   173,   174,   175,   176,    -1,    -1,   179,
     180,   181,   182,    -1,    -1,   185,   186,    -1,   188,   189,
     190,    -1,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,    -1,   203,   204,   205,   206,   207,   208,   209,
      -1,   211,    -1,    -1,   214,   215,   216,    -1,   218,    -1,
      -1,    -1,   222,   223,    -1,    -1,    -1,   227,   228,   229,
     230,   231,    -1,    -1,   234,   235,   236,    -1,   238,    -1,
     240,    -1,    -1,    -1,    -1,   245,   246,    -1,    -1,    -1,
     250,    -1,   252,   253,    -1,   255,   256,    -1,    -1,    -1,
     260,    -1,    -1,   263,   264,   265,    -1,    -1,   268,    -1,
      -1,   271,   272,   273,    -1,    -1,    -1,    -1,   278,   279,
      -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,    -1,
      -1,    -1,    -1,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,    -1,   315,   316,   317,   318,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,   329,
     330,   331,    -1,    -1,   334,   335,    -1,   337,    -1,   339,
      -1,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,    -1,    -1,   353,   354,    -1,    -1,   357,   358,   359,
     360,    -1,    -1,    -1,   364,   365,    -1,    -1,    -1,   369,
      -1,   371,   372,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     390,   391,   392,    -1,    -1,   395,    -1,   397,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,    -1,
      -1,   411,   412,   413,    -1,   415,    -1,   417,   418,   419,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,   448,   449,
     450,    -1,    -1,   453,    -1,   455,    -1,   457,   458,    -1,
     460,   461,    -1,   463,    -1,   465,    -1,    -1,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
      -1,   481,   482,    -1,    -1,    -1,   486,   487,   488,   489,
      -1,    -1,    -1,   493,    -1,    -1,    -1,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,   506,   507,   508,   509,
     510,   511,    -1,    -1,    -1,    -1,    -1,    -1,   518,   519,
      -1,   521,    -1,    -1,   524,    -1,    -1,   527,   528,    -1,
      -1,    -1,   532,    -1,    -1,   535,   536,    -1,   538,   539,
     540,   541,   542,   543,    -1,    -1,   546,   547,   548,   549,
      -1,   551,   552,    -1,   554,    -1,   556,   557,   558,   559,
      -1,   561,   562,   563,    -1,   565,   566,   567,   568,    -1,
      -1,    -1,    -1,    -1,   574,   575,   576,    -1,    -1,    -1,
     580,   581,   582,   583,    -1,   585,   586,    -1,   588,   589,
      -1,   591,   592,    -1,    -1,   595,    -1,    -1,   598,    -1,
     600,    -1,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,    -1,    -1,   614,    -1,    -1,    -1,   618,   619,
     620,   621,   622,   623,   624,    -1,    -1,    -1,    -1,    -1,
      -1,   631,   632,    -1,   634,   635,   636,    -1,    -1,   639,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,   661,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,
      -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,   167,   168,    -1,   170,   171,
     172,   173,   174,   175,   176,    -1,    -1,   179,   180,   181,
     182,    -1,    -1,   185,   186,    -1,   188,   189,   190,    -1,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
      -1,   203,   204,   205,   206,   207,   208,   209,    -1,   211,
      -1,    -1,   214,   215,   216,    -1,   218,    -1,    -1,    -1,
     222,   223,    -1,    -1,    -1,   227,   228,   229,   230,   231,
      -1,    -1,   234,   235,   236,    -1,   238,    -1,   240,    -1,
      -1,    -1,    -1,   245,   246,    -1,    -1,    -1,   250,    -1,
     252,   253,    -1,   255,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,   265,    -1,    -1,   268,    -1,    -1,   271,
     272,    -1,    -1,    -1,    -1,    -1,   278,   279,    -1,   281,
      -1,   283,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,
      -1,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,    -1,   315,   316,   317,   318,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,   329,   330,   331,
      -1,    -1,   334,   335,    -1,   337,    -1,   339,    -1,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,    -1,
      -1,   353,   354,    -1,    -1,   357,   358,   359,   360,    -1,
      -1,    -1,   364,   365,    -1,    -1,    -1,   369,    -1,   371,
     372,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,   391,
     392,    -1,    -1,   395,    -1,   397,    -1,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,    -1,    -1,   411,
     412,   413,    -1,   415,    -1,   417,   418,   419,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,   436,    -1,    -1,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,   448,   449,   450,    -1,
      -1,   453,    -1,   455,    -1,   457,   458,    -1,   460,   461,
      -1,   463,    -1,   465,    -1,    -1,   468,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,    -1,   481,
     482,    -1,    -1,    -1,   486,   487,   488,   489,    -1,    -1,
      -1,   493,    -1,    -1,    -1,   497,    -1,   499,   500,   501,
     502,   503,   504,    -1,   506,   507,   508,   509,   510,   511,
      -1,    -1,    -1,    -1,    -1,    -1,   518,   519,    -1,   521,
      -1,    -1,   524,    -1,    -1,   527,   528,    -1,    -1,    -1,
     532,    -1,    -1,   535,   536,    -1,   538,   539,   540,   541,
     542,   543,    -1,    -1,   546,   547,   548,   549,    -1,   551,
     552,    -1,   554,    -1,   556,   557,   558,   559,    -1,    -1,
     562,   563,    -1,   565,   566,   567,   568,    -1,    -1,    -1,
      -1,    -1,   574,   575,   576,    -1,    -1,    -1,   580,   581,
     582,   583,    -1,   585,   586,    -1,   588,   589,    -1,   591,
     592,    -1,    -1,   595,    -1,    -1,   598,    -1,   600,    -1,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
      -1,    -1,   614,    -1,    -1,    -1,   618,   619,   620,   621,
     622,   623,   624,    -1,    -1,    -1,    -1,    -1,    -1,   631,
     632,    -1,   634,   635,   636,    -1,    -1,   639,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,   661,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,   167,   168,    -1,   170,   171,   172,   173,
     174,   175,   176,    -1,    -1,   179,   180,   181,   182,    -1,
      -1,   185,   186,    -1,   188,   189,   190,    -1,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,    -1,    -1,
     214,   215,   216,    -1,   218,    -1,    -1,    -1,   222,   223,
      -1,    -1,    -1,   227,   228,   229,   230,   231,    -1,    -1,
     234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,
      -1,   245,   246,    -1,    -1,    -1,   250,    -1,   252,   253,
      -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,   265,    -1,    -1,   268,    -1,    -1,   271,   272,   273,
      -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,
      -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
      -1,   315,   316,   317,   318,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,   329,   330,   331,    -1,    -1,
     334,   335,    -1,   337,    -1,   339,    -1,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,    -1,    -1,   353,
     354,    -1,    -1,   357,   358,   359,   360,    -1,    -1,    -1,
     364,   365,    -1,    -1,    -1,   369,    -1,   371,   372,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,
      -1,   395,    -1,   397,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,    -1,    -1,   411,   412,   413,
      -1,   415,    -1,   417,   418,   419,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,   436,    -1,    -1,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,   448,   449,   450,    -1,    -1,   453,
      -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,   463,
      -1,   465,    -1,    -1,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,    -1,
      -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,
      -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,   506,   507,   508,   509,   510,   511,    -1,    -1,
      -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,
     524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,    -1,
      -1,   535,   536,    -1,   538,   539,   540,   541,   542,   543,
      -1,    -1,   546,   547,   548,   549,    -1,   551,   552,    -1,
     554,    -1,   556,   557,   558,   559,    -1,   561,   562,   563,
      -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,
     574,   575,   576,    -1,    -1,    -1,   580,   581,   582,   583,
      -1,   585,   586,    -1,   588,   589,    -1,   591,   592,    -1,
      -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,
     614,    -1,    -1,    -1,   618,   619,   620,   621,   622,   623,
     624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,
     634,   635,   636,    -1,    -1,   639,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,   661,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,   167,   168,    -1,   170,   171,   172,   173,   174,   175,
     176,    -1,    -1,   179,   180,   181,   182,    -1,    -1,   185,
     186,    -1,   188,   189,   190,    -1,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,    -1,    -1,   214,   215,
     216,    -1,   218,    -1,    -1,    -1,   222,   223,    -1,    -1,
      -1,   227,   228,   229,   230,   231,    -1,    -1,   234,   235,
     236,    -1,   238,    -1,   240,    -1,    -1,    -1,    -1,   245,
     246,    -1,    -1,    -1,   250,    -1,   252,   253,    -1,   255,
     256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,   265,
      -1,    -1,   268,    -1,    -1,   271,   272,    -1,    -1,    -1,
      -1,    -1,   278,   279,    -1,   281,    -1,   283,    -1,   285,
     286,    -1,    -1,    -1,    -1,    -1,    -1,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,    -1,   315,
     316,   317,   318,    -1,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,   329,   330,   331,    -1,    -1,   334,   335,
      -1,   337,    -1,   339,    -1,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,    -1,    -1,   353,   354,    -1,
      -1,   357,   358,   359,   360,    -1,    -1,    -1,   364,   365,
      -1,    -1,    -1,   369,    -1,   371,   372,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,   391,   392,    -1,    -1,   395,
      -1,   397,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,    -1,    -1,   411,   412,   413,    -1,   415,
      -1,   417,   418,   419,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
     436,    -1,    -1,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,   448,   449,   450,    -1,    -1,   453,    -1,   455,
      -1,   457,   458,    -1,   460,   461,    -1,   463,    -1,   465,
      -1,    -1,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,    -1,   481,   482,    -1,    -1,    -1,
     486,   487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,
      -1,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
     506,   507,   508,   509,   510,   511,    -1,    -1,    -1,    -1,
      -1,    -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,
      -1,   527,   528,    -1,    -1,    -1,   532,    -1,    -1,   535,
     536,    -1,   538,   539,   540,   541,   542,   543,    -1,    -1,
     546,   547,   548,   549,    -1,   551,   552,    -1,   554,    -1,
     556,   557,   558,   559,    -1,    -1,   562,   563,    -1,   565,
     566,   567,   568,    -1,    -1,    -1,    -1,    -1,   574,   575,
     576,    -1,    -1,    -1,   580,   581,   582,   583,    -1,   585,
     586,    -1,   588,   589,    -1,   591,   592,    -1,    -1,   595,
      -1,    -1,   598,    -1,   600,    -1,   602,   603,   604,    -1,
      -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,   614,    -1,
      -1,    -1,   618,   619,   620,   621,   622,   623,   624,    -1,
      -1,    -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,
     636,    -1,    -1,   639,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,   661,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,    -1,
      -1,   179,   180,   181,   182,    -1,    -1,   185,   186,    -1,
     188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,    -1,    -1,   234,   235,   236,    -1,
     238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,
      -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,    -1,   271,   272,    -1,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,    -1,   315,   316,   317,
     318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,    -1,   337,
      -1,   339,    -1,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,    -1,   353,   354,    -1,    -1,   357,
     358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,    -1,
      -1,   369,    -1,   371,   372,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,    -1,    -1,   546,   547,
     548,   549,    -1,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,    -1,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
      -1,    -1,   580,   581,   582,   583,    -1,   585,   586,    -1,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
      -1,   639,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    -1,   661,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    -1,    -1,    -1,    -1,
      -1,    -1,    82,    -1,    84,    -1,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    -1,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,    -1,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,    -1,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
      -1,   161,    -1,   163,   164,   165,    -1,   167,   168,    -1,
     170,   171,   172,   173,   174,    -1,    -1,    -1,    -1,   179,
     180,   181,   182,    -1,    -1,   185,   186,   187,   188,   189,
     190,    -1,    -1,    -1,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,    -1,   203,   204,   205,   206,   207,    -1,   209,
      -1,   211,    -1,    -1,    -1,   215,   216,    -1,    -1,    -1,
      -1,    -1,    -1,   223,    -1,    -1,    -1,   227,   228,   229,
     230,   231,   232,    -1,   234,   235,   236,    -1,   238,    -1,
     240,    -1,    -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,
     250,    -1,   252,   253,    -1,   255,   256,   257,    -1,    -1,
     260,    -1,    -1,    -1,   264,   265,    -1,    -1,   268,   269,
      -1,   271,   272,    -1,    -1,    -1,    -1,    -1,   278,   279,
      -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,    -1,
      -1,   291,    -1,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,    -1,   315,   316,   317,   318,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,   329,
     330,   331,    -1,    -1,   334,   335,    -1,   337,    -1,   339,
      -1,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,    -1,    -1,   353,   354,    -1,    -1,   357,   358,   359,
     360,    -1,    -1,    -1,    -1,   365,    -1,    -1,    -1,   369,
      -1,   371,   372,   373,    -1,   375,   376,   377,   378,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   391,   392,    -1,    -1,    -1,    -1,   397,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,    -1,    -1,
      -1,    -1,   412,   413,    -1,   415,    -1,   417,   418,   419,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,   439,
     440,   441,   442,   443,    -1,   445,    -1,    -1,   448,    -1,
     450,   451,    -1,   453,    -1,    -1,    -1,   457,    -1,    -1,
     460,   461,    -1,   463,   464,   465,    -1,    -1,   468,    -1,
     470,   471,   472,   473,   474,   475,   476,    -1,   478,   479,
      -1,   481,    -1,    -1,    -1,    -1,   486,   487,   488,    -1,
      -1,    -1,    -1,   493,    -1,    -1,    -1,    -1,    -1,    -1,
     500,    -1,    -1,   503,   504,    -1,   506,    -1,   508,    -1,
     510,   511,    -1,    -1,    -1,    -1,    -1,    -1,   518,   519,
      -1,   521,    -1,    -1,   524,    -1,    -1,   527,    -1,    -1,
      -1,    -1,   532,    -1,    -1,    -1,   536,    -1,   538,   539,
     540,   541,   542,   543,    -1,    -1,   546,   547,   548,   549,
      -1,   551,   552,    -1,   554,    -1,   556,   557,   558,   559,
      -1,    -1,   562,   563,    -1,   565,   566,   567,   568,    -1,
      -1,    -1,    -1,    -1,   574,   575,   576,    -1,    -1,    -1,
      -1,   581,   582,   583,    -1,   585,   586,    -1,   588,   589,
      -1,    -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,
      -1,    -1,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,    -1,    -1,   614,    -1,    -1,    -1,   618,   619,
     620,   621,   622,   623,   624,    -1,    -1,   627,    -1,    -1,
      -1,   631,    -1,    -1,   634,    -1,   636,    -1,     5,   639,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,   656,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,
      57,    58,    -1,    60,    61,    -1,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,
      -1,   108,   109,    -1,   111,    -1,   113,    -1,    -1,    -1,
     117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,
     127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
     167,   168,    -1,   170,   171,   172,   173,   174,   175,   176,
      -1,    -1,   179,   180,   181,   182,    -1,    -1,   185,   186,
      -1,   188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,
     197,    -1,   199,    -1,   201,    -1,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,    -1,    -1,   214,   215,   216,
      -1,   218,    -1,    -1,    -1,   222,   223,    -1,    -1,    -1,
     227,   228,   229,   230,   231,    -1,    -1,   234,   235,   236,
      -1,   238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,
      -1,    -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,
      -1,    -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,
      -1,   268,    -1,    -1,   271,   272,   273,    -1,    -1,    -1,
      -1,   278,   279,    -1,   281,    -1,   283,    -1,   285,   286,
      -1,    -1,    -1,    -1,    -1,    -1,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,    -1,   310,   311,   312,   313,    -1,   315,   316,
     317,   318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,
     327,   328,   329,   330,   331,    -1,    -1,   334,   335,    -1,
     337,    -1,   339,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,    -1,    -1,   353,   354,    -1,    -1,
     357,   358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,
      -1,    -1,   369,    -1,   371,   372,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,
     397,    -1,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,
     417,   418,   419,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,   436,
      -1,    -1,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,   448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,
     457,   458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,
      -1,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,
     487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,   506,
     507,   508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,
      -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,
     527,   528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,
      -1,   538,   539,   540,   541,   542,   543,    -1,    -1,   546,
     547,   548,   549,    -1,   551,   552,    -1,   554,    -1,   556,
     557,   558,   559,    -1,   561,   562,   563,    -1,   565,   566,
     567,   568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,
      -1,    -1,    -1,   580,   581,   582,   583,    -1,   585,   586,
      -1,   588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,
      -1,   598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,
      -1,   618,   619,   620,   621,   622,   623,   624,    -1,    -1,
      -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,
      -1,     5,   639,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,   654,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,   167,   168,    -1,   170,   171,   172,   173,
     174,   175,   176,    -1,    -1,   179,   180,   181,   182,    -1,
      -1,   185,   186,    -1,   188,   189,   190,    -1,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,    -1,    -1,
     214,   215,   216,    -1,   218,    -1,    -1,    -1,   222,   223,
      -1,    -1,    -1,   227,   228,   229,   230,   231,    -1,    -1,
     234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,
      -1,   245,   246,    -1,    -1,    -1,   250,    -1,   252,   253,
      -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,   265,    -1,    -1,   268,    -1,    -1,   271,   272,    -1,
      -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,
      -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
      -1,   315,   316,   317,   318,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,   329,   330,   331,    -1,    -1,
     334,   335,    -1,   337,    -1,   339,    -1,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,    -1,    -1,   353,
     354,    -1,    -1,   357,   358,   359,   360,    -1,    -1,    -1,
     364,   365,    -1,    -1,    -1,   369,    -1,   371,   372,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,
      -1,   395,    -1,   397,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,    -1,    -1,   411,   412,   413,
      -1,   415,    -1,   417,   418,   419,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,   436,    -1,    -1,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,   448,   449,   450,    -1,    -1,   453,
      -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,   463,
      -1,   465,    -1,    -1,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,    -1,
      -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,
      -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,   506,   507,   508,   509,   510,   511,    -1,    -1,
      -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,
     524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,    -1,
      -1,   535,   536,    -1,   538,   539,   540,   541,   542,   543,
      -1,    -1,   546,   547,   548,   549,    -1,   551,   552,    -1,
     554,    -1,   556,   557,   558,   559,    -1,    -1,   562,   563,
      -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,
     574,   575,   576,    -1,    -1,    -1,   580,   581,   582,   583,
      -1,   585,   586,    -1,   588,   589,    -1,   591,   592,    -1,
      -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,
     614,    -1,    -1,    -1,   618,   619,   620,   621,   622,   623,
     624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,
     634,   635,   636,    -1,     5,   639,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,   649,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,
      61,    -1,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
      -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,
     111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,
      -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,
      -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,   167,   168,    -1,   170,
     171,   172,   173,   174,   175,   176,    -1,    -1,   179,   180,
     181,   182,    -1,    -1,   185,   186,    -1,   188,   189,   190,
      -1,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,    -1,   203,   204,   205,   206,   207,   208,   209,    -1,
     211,    -1,    -1,   214,   215,   216,    -1,   218,    -1,    -1,
      -1,   222,   223,    -1,    -1,    -1,   227,   228,   229,   230,
     231,    -1,    -1,   234,   235,   236,    -1,   238,    -1,   240,
      -1,    -1,    -1,    -1,   245,   246,    -1,    -1,    -1,   250,
      -1,   252,   253,    -1,   255,   256,    -1,    -1,    -1,   260,
      -1,    -1,   263,   264,   265,    -1,    -1,   268,    -1,    -1,
     271,   272,    -1,    -1,    -1,    -1,    -1,   278,   279,    -1,
     281,    -1,   283,    -1,   285,   286,    -1,    -1,    -1,    -1,
      -1,    -1,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,    -1,   310,
     311,   312,   313,    -1,   315,   316,   317,   318,    -1,   320,
     321,    -1,    -1,    -1,    -1,   326,   327,   328,   329,   330,
     331,    -1,    -1,   334,   335,    -1,   337,    -1,   339,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
      -1,    -1,   353,   354,    -1,    -1,   357,   358,   359,   360,
      -1,    -1,    -1,   364,   365,    -1,    -1,    -1,   369,    -1,
     371,   372,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,
     391,   392,    -1,    -1,   395,    -1,   397,    -1,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,    -1,    -1,
     411,   412,   413,    -1,   415,    -1,   417,   418,   419,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,   436,    -1,    -1,   439,   440,
     441,   442,   443,    -1,   445,   446,    -1,   448,   449,   450,
      -1,    -1,   453,    -1,   455,    -1,   457,   458,    -1,   460,
     461,    -1,   463,    -1,   465,    -1,    -1,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,    -1,
     481,   482,    -1,    -1,    -1,   486,   487,   488,   489,    -1,
      -1,    -1,   493,    -1,    -1,    -1,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,   506,   507,   508,   509,   510,
     511,    -1,    -1,    -1,    -1,    -1,    -1,   518,   519,    -1,
     521,    -1,    -1,   524,    -1,    -1,   527,   528,    -1,    -1,
      -1,   532,    -1,    -1,   535,   536,    -1,   538,   539,   540,
     541,   542,   543,    -1,    -1,   546,   547,   548,   549,    -1,
     551,   552,    -1,   554,    -1,   556,   557,   558,   559,    -1,
      -1,   562,   563,    -1,   565,   566,   567,   568,    -1,    -1,
      -1,    -1,    -1,   574,   575,   576,    -1,    -1,    -1,   580,
     581,   582,   583,    -1,   585,   586,    -1,   588,   589,    -1,
     591,   592,    -1,    -1,   595,    -1,    -1,   598,    -1,   600,
      -1,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,    -1,    -1,   614,    -1,    -1,    -1,   618,   619,   620,
     621,   622,   623,   624,    -1,    -1,    -1,    -1,    -1,    -1,
     631,   632,    -1,   634,   635,   636,    -1,     5,   639,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,   649,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,    -1,
      -1,   179,   180,   181,   182,    -1,    -1,   185,   186,    -1,
     188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,    -1,    -1,   234,   235,   236,    -1,
     238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,
      -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,    -1,   271,   272,    -1,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,    -1,   315,   316,   317,
     318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,    -1,   337,
      -1,   339,    -1,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,    -1,   353,   354,    -1,    -1,   357,
     358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,    -1,
      -1,   369,    -1,   371,   372,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,    -1,    -1,   546,   547,
     548,   549,    -1,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,    -1,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
      -1,    -1,   580,   581,   582,   583,    -1,   585,   586,    -1,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
       5,   639,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,   649,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,   167,   168,    -1,   170,   171,   172,   173,   174,
     175,   176,    -1,    -1,   179,   180,   181,   182,    -1,    -1,
     185,   186,    -1,   188,   189,   190,    -1,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,    -1,    -1,   214,
     215,   216,    -1,   218,    -1,    -1,    -1,   222,   223,    -1,
      -1,    -1,   227,   228,   229,   230,   231,    -1,    -1,   234,
     235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,    -1,
     245,   246,    -1,    -1,    -1,   250,    -1,   252,   253,    -1,
     255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,
     265,    -1,    -1,   268,    -1,    -1,   271,   272,    -1,    -1,
      -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,    -1,
     285,   286,    -1,    -1,    -1,    -1,    -1,    -1,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,    -1,
     315,   316,   317,   318,    -1,   320,   321,    -1,    -1,    -1,
      -1,   326,   327,   328,   329,   330,   331,    -1,    -1,   334,
     335,    -1,   337,    -1,   339,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,    -1,    -1,   353,   354,
      -1,    -1,   357,   358,   359,   360,    -1,    -1,    -1,   364,
     365,    -1,    -1,    -1,   369,    -1,   371,   372,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,    -1,
     395,    -1,   397,    -1,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,    -1,    -1,   411,   412,   413,    -1,
     415,    -1,   417,   418,   419,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,   436,    -1,    -1,   439,   440,   441,   442,   443,    -1,
     445,   446,    -1,   448,   449,   450,    -1,    -1,   453,    -1,
     455,    -1,   457,   458,    -1,   460,   461,    -1,   463,    -1,
     465,    -1,    -1,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,    -1,   481,   482,    -1,    -1,
      -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,    -1,
      -1,    -1,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,   506,   507,   508,   509,   510,   511,    -1,    -1,    -1,
      -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,   524,
      -1,    -1,   527,   528,    -1,    -1,    -1,   532,    -1,    -1,
     535,   536,    -1,   538,   539,   540,   541,   542,   543,    -1,
      -1,   546,   547,   548,   549,    -1,   551,   552,    -1,   554,
      -1,   556,   557,   558,   559,    -1,    -1,   562,   563,    -1,
     565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,   574,
     575,   576,    -1,    -1,    -1,   580,   581,   582,   583,    -1,
     585,   586,    -1,   588,   589,    -1,   591,   592,    -1,    -1,
     595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,   614,
      -1,    -1,    -1,   618,   619,   620,   621,   622,   623,   624,
      -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,   634,
     635,   636,    -1,     5,   639,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,   649,    -1,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,
      -1,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,
      -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,   167,   168,    -1,   170,   171,
     172,   173,   174,   175,   176,    -1,    -1,   179,   180,   181,
     182,    -1,    -1,   185,   186,    -1,   188,   189,   190,    -1,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
      -1,   203,   204,   205,   206,   207,   208,   209,    -1,   211,
      -1,    -1,   214,   215,   216,    -1,   218,    -1,    -1,    -1,
     222,   223,    -1,    -1,    -1,   227,   228,   229,   230,   231,
      -1,    -1,   234,   235,   236,    -1,   238,    -1,   240,    -1,
      -1,    -1,    -1,   245,   246,    -1,    -1,    -1,   250,    -1,
     252,   253,    -1,   255,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,   265,    -1,    -1,   268,    -1,    -1,   271,
     272,   273,    -1,    -1,    -1,    -1,   278,   279,    -1,   281,
      -1,   283,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,
      -1,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,    -1,   315,   316,   317,   318,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,   329,   330,   331,
      -1,    -1,   334,   335,    -1,   337,    -1,   339,    -1,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,    -1,
      -1,   353,   354,    -1,    -1,   357,   358,   359,   360,    -1,
      -1,    -1,   364,   365,    -1,    -1,    -1,   369,    -1,   371,
     372,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,   391,
     392,    -1,    -1,   395,    -1,   397,    -1,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,    -1,    -1,   411,
     412,   413,    -1,   415,    -1,   417,   418,   419,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,   436,    -1,    -1,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,   448,   449,   450,    -1,
      -1,   453,    -1,   455,    -1,   457,   458,    -1,   460,   461,
      -1,   463,    -1,   465,    -1,    -1,   468,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,    -1,   481,
     482,    -1,    -1,    -1,   486,   487,   488,   489,    -1,    -1,
     492,   493,    -1,    -1,    -1,   497,    -1,   499,   500,   501,
     502,   503,   504,    -1,   506,   507,   508,   509,   510,   511,
      -1,    -1,    -1,    -1,    -1,    -1,   518,   519,    -1,   521,
      -1,    -1,   524,    -1,    -1,   527,   528,    -1,    -1,    -1,
     532,    -1,    -1,   535,   536,    -1,   538,   539,   540,   541,
     542,   543,    -1,    -1,   546,   547,   548,   549,    -1,   551,
     552,    -1,   554,    -1,   556,   557,   558,   559,    -1,   561,
     562,   563,    -1,   565,   566,   567,   568,    -1,    -1,    -1,
      -1,    -1,   574,   575,   576,    -1,    -1,    -1,   580,   581,
     582,   583,    -1,   585,   586,    -1,   588,   589,    -1,   591,
     592,    -1,    -1,   595,    -1,    -1,   598,    -1,   600,    -1,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
      -1,    -1,   614,    -1,    -1,    -1,   618,   619,   620,   621,
     622,   623,   624,    -1,    -1,    -1,    -1,    -1,    -1,   631,
     632,    -1,   634,   635,   636,    -1,    -1,   639,    -1,     5,
     642,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,   104,    -1,
     106,    -1,   108,    -1,   110,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
     136,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,   167,   168,    -1,   170,   171,   172,   173,   174,   175,
     176,    -1,    -1,   179,   180,   181,   182,    -1,    -1,   185,
     186,    -1,   188,   189,   190,    -1,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,   205,
     206,   207,   208,   209,   210,   211,    -1,    -1,   214,   215,
     216,    -1,   218,    -1,    -1,    -1,   222,   223,    -1,    -1,
      -1,   227,   228,   229,   230,   231,    -1,    -1,   234,   235,
     236,   237,   238,    -1,   240,    -1,    -1,    -1,   244,   245,
     246,    -1,    -1,    -1,   250,    -1,   252,   253,    -1,   255,
     256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,   265,
      -1,    -1,   268,    -1,    -1,   271,   272,   273,    -1,    -1,
      -1,    -1,   278,   279,    -1,   281,    -1,   283,   284,   285,
     286,    -1,    -1,    -1,    -1,    -1,    -1,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,    -1,   315,
     316,   317,   318,    -1,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,   329,   330,   331,    -1,    -1,   334,   335,
      -1,   337,    -1,   339,    -1,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,    -1,    -1,   353,   354,    -1,
      -1,   357,   358,   359,   360,    -1,    -1,    -1,   364,   365,
      -1,    -1,    -1,   369,    -1,   371,   372,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,   391,   392,    -1,    -1,   395,
      -1,   397,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,    -1,    -1,   411,   412,   413,    -1,   415,
      -1,   417,   418,   419,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
     436,   437,    -1,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,   448,   449,   450,    -1,    -1,   453,    -1,   455,
      -1,   457,   458,    -1,   460,   461,    -1,   463,    -1,   465,
      -1,    -1,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,    -1,   481,   482,   483,    -1,    -1,
     486,   487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,
     496,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
     506,   507,   508,   509,   510,   511,    -1,    -1,    -1,    -1,
      -1,    -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,
      -1,   527,   528,    -1,    -1,    -1,   532,    -1,    -1,   535,
     536,    -1,   538,   539,   540,   541,   542,   543,    -1,    -1,
     546,   547,   548,   549,    -1,   551,   552,    -1,   554,    -1,
     556,   557,   558,   559,    -1,   561,   562,   563,    -1,   565,
     566,   567,   568,    -1,    -1,    -1,    -1,    -1,   574,   575,
     576,   577,    -1,    -1,   580,   581,   582,   583,    -1,   585,
     586,    -1,   588,   589,    -1,   591,   592,    -1,    -1,   595,
      -1,    -1,   598,   599,   600,   601,   602,   603,   604,    -1,
      -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,   614,    -1,
      -1,    -1,   618,   619,   620,   621,   622,   623,   624,    -1,
      -1,    -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,
     636,    -1,     5,   639,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,    -1,    -1,
     103,   104,    -1,   106,    -1,   108,    -1,   110,   111,    -1,
     113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,
      -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,
     133,    -1,   135,   136,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,   167,   168,    -1,   170,   171,   172,
     173,   174,   175,   176,    -1,    -1,   179,   180,   181,   182,
      -1,    -1,   185,   186,    -1,   188,   189,   190,    -1,    -1,
     193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,
     203,   204,   205,   206,   207,   208,   209,   210,   211,    -1,
      -1,   214,   215,   216,    -1,   218,    -1,    -1,    -1,   222,
     223,    -1,    -1,    -1,   227,   228,   229,   230,   231,    -1,
      -1,   234,   235,   236,   237,   238,    -1,   240,    -1,    -1,
      -1,   244,   245,   246,    -1,    -1,    -1,   250,    -1,   252,
     253,    -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,
     263,   264,   265,    -1,    -1,   268,    -1,    -1,   271,   272,
     273,    -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,
     283,   284,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,    -1,   310,   311,   312,
     313,    -1,   315,   316,   317,   318,    -1,   320,   321,    -1,
      -1,    -1,    -1,   326,   327,   328,   329,   330,   331,    -1,
      -1,   334,   335,    -1,   337,    -1,   339,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,    -1,    -1,
     353,   354,    -1,    -1,   357,   358,   359,   360,    -1,    -1,
      -1,   364,   365,    -1,    -1,    -1,   369,    -1,   371,   372,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,
      -1,    -1,   395,    -1,   397,    -1,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,    -1,    -1,   411,   412,
     413,    -1,   415,    -1,   417,   418,   419,   420,   421,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,   436,   437,    -1,   439,   440,   441,   442,
     443,    -1,   445,   446,    -1,   448,   449,   450,    -1,    -1,
     453,    -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,
     463,    -1,   465,    -1,    -1,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,    -1,   481,   482,
     483,    -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,
     493,    -1,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,   506,   507,   508,   509,   510,   511,    -1,
      -1,    -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,
      -1,   524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,
      -1,    -1,   535,   536,    -1,   538,   539,   540,   541,   542,
     543,    -1,    -1,   546,   547,   548,   549,    -1,   551,   552,
      -1,   554,    -1,   556,   557,   558,   559,    -1,   561,   562,
     563,    -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,
      -1,   574,   575,   576,   577,    -1,    -1,   580,   581,   582,
     583,    -1,   585,   586,    -1,   588,   589,    -1,   591,   592,
      -1,    -1,   595,    -1,    -1,   598,   599,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,
      -1,   614,    -1,    -1,    -1,   618,   619,   620,   621,   622,
     623,   624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,
      -1,   634,   635,   636,    -1,     5,   639,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,   129,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,   167,   168,    -1,
     170,   171,   172,   173,   174,   175,   176,    -1,    -1,   179,
     180,   181,   182,    -1,    -1,   185,   186,    -1,   188,   189,
     190,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,    -1,   203,   204,   205,   206,   207,   208,   209,
      -1,   211,    -1,    -1,   214,   215,   216,    -1,   218,   219,
      -1,    -1,   222,   223,    -1,    -1,    -1,   227,   228,   229,
     230,   231,    -1,    -1,   234,   235,   236,    -1,   238,    -1,
     240,    -1,    -1,    -1,    -1,   245,   246,    -1,    -1,    -1,
     250,    -1,   252,   253,    -1,   255,   256,    -1,    -1,    -1,
     260,    -1,    -1,   263,   264,   265,    -1,    -1,   268,    -1,
      -1,   271,   272,    -1,    -1,    -1,    -1,    -1,   278,   279,
      -1,   281,    -1,   283,    -1,   285,   286,    -1,    -1,   289,
      -1,    -1,    -1,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,    -1,   315,   316,   317,   318,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,   329,
     330,   331,    -1,    -1,   334,   335,    -1,   337,    -1,   339,
      -1,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,    -1,    -1,   353,   354,    -1,    -1,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,    -1,   368,   369,
      -1,   371,   372,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     390,   391,   392,    -1,    -1,   395,    -1,   397,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,    -1,
      -1,   411,   412,   413,    -1,   415,    -1,   417,   418,   419,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,   436,    -1,    -1,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,   448,   449,
     450,    -1,    -1,   453,    -1,   455,    -1,   457,   458,    -1,
     460,   461,    -1,   463,    -1,   465,    -1,    -1,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
      -1,   481,   482,    -1,    -1,    -1,   486,   487,   488,   489,
      -1,    -1,    -1,   493,    -1,    -1,    -1,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,   506,   507,   508,   509,
     510,   511,    -1,    -1,   514,   515,   516,    -1,   518,   519,
      -1,   521,    -1,    -1,   524,    -1,    -1,   527,   528,    -1,
      -1,    -1,   532,    -1,    -1,   535,   536,    -1,   538,   539,
     540,   541,   542,   543,    -1,    -1,   546,   547,   548,   549,
      -1,   551,   552,    -1,   554,    -1,   556,   557,   558,   559,
      -1,    -1,   562,   563,    -1,   565,   566,   567,   568,    -1,
      -1,    -1,    -1,    -1,   574,   575,   576,    -1,    -1,    -1,
     580,   581,   582,   583,   584,   585,   586,    -1,   588,   589,
      -1,   591,   592,    -1,    -1,   595,    -1,    -1,   598,    -1,
     600,    -1,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,    -1,    -1,   614,    -1,    -1,    -1,   618,   619,
     620,   621,   622,   623,   624,    -1,    -1,    -1,    -1,    -1,
      -1,   631,   632,    -1,   634,   635,   636,    -1,     5,   639,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,
      57,    58,    -1,    60,    61,    -1,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,
      -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,
     117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
     167,   168,    -1,   170,   171,   172,   173,   174,   175,   176,
      -1,    -1,   179,   180,   181,   182,    -1,    -1,   185,   186,
      -1,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,    -1,   199,    -1,   201,    -1,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,    -1,    -1,   214,   215,   216,
      -1,   218,   219,    -1,    -1,   222,   223,    -1,    -1,    -1,
     227,   228,   229,   230,   231,    -1,    -1,   234,   235,   236,
      -1,   238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,
      -1,    -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,
      -1,    -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,
      -1,   268,    -1,    -1,   271,   272,    -1,    -1,    -1,    -1,
      -1,   278,   279,    -1,   281,    -1,   283,    -1,   285,   286,
      -1,    -1,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,    -1,   310,   311,   312,   313,    -1,   315,   316,
     317,   318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,
     327,   328,   329,   330,   331,    -1,    -1,   334,   335,    -1,
     337,    -1,   339,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,    -1,    -1,   353,   354,    -1,    -1,
     357,   358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,
      -1,   368,   369,    -1,   371,   372,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,
     397,    -1,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,
     417,   418,   419,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,   436,
      -1,    -1,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,   448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,
     457,   458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,
      -1,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,
     487,   488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,   506,
     507,   508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,
      -1,   518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,
     527,   528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,
      -1,   538,   539,   540,   541,   542,   543,    -1,    -1,   546,
     547,   548,   549,    -1,   551,   552,    -1,   554,    -1,   556,
     557,   558,   559,    -1,   561,   562,   563,    -1,   565,   566,
     567,   568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,
      -1,    -1,    -1,   580,   581,   582,   583,   584,   585,   586,
      -1,   588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,
      -1,   598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,
      -1,   618,   619,   620,   621,   622,   623,   624,    -1,    -1,
      -1,    -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,
      -1,     5,   639,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,   167,   168,    -1,   170,   171,   172,   173,
     174,   175,   176,    -1,    -1,   179,   180,   181,   182,    -1,
      -1,   185,   186,    -1,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,    -1,    -1,
     214,   215,   216,    -1,   218,   219,    -1,    -1,   222,   223,
      -1,    -1,    -1,   227,   228,   229,   230,   231,    -1,    -1,
     234,   235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,
      -1,   245,   246,    -1,    -1,    -1,   250,    -1,   252,   253,
      -1,   255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,   265,    -1,    -1,   268,    -1,    -1,   271,   272,    -1,
      -1,    -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,
      -1,   285,   286,    -1,    -1,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
      -1,   315,   316,   317,   318,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,   329,   330,   331,    -1,    -1,
     334,   335,    -1,   337,    -1,   339,    -1,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,    -1,    -1,   353,
     354,    -1,    -1,   357,   358,   359,   360,    -1,    -1,    -1,
     364,   365,    -1,    -1,   368,   369,    -1,   371,   372,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   390,   391,   392,    -1,
      -1,   395,    -1,   397,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,    -1,    -1,   411,   412,   413,
      -1,   415,    -1,   417,   418,   419,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,   436,    -1,    -1,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,   448,   449,   450,    -1,    -1,   453,
      -1,   455,    -1,   457,   458,    -1,   460,   461,    -1,   463,
      -1,   465,    -1,    -1,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,    -1,
      -1,    -1,   486,   487,   488,   489,    -1,    -1,    -1,   493,
      -1,    -1,    -1,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,   506,   507,   508,   509,   510,   511,    -1,    -1,
      -1,    -1,    -1,    -1,   518,   519,    -1,   521,    -1,    -1,
     524,    -1,    -1,   527,   528,    -1,    -1,    -1,   532,    -1,
      -1,   535,   536,    -1,   538,   539,   540,   541,   542,   543,
      -1,    -1,   546,   547,   548,   549,    -1,   551,   552,    -1,
     554,    -1,   556,   557,   558,   559,    -1,   561,   562,   563,
      -1,   565,   566,   567,   568,    -1,    -1,    -1,    -1,    -1,
     574,   575,   576,    -1,    -1,    -1,   580,   581,   582,   583,
     584,   585,   586,    -1,   588,   589,    -1,   591,   592,    -1,
      -1,   595,    -1,    -1,   598,    -1,   600,    -1,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,
     614,    -1,    -1,    -1,   618,   619,   620,   621,   622,   623,
     624,    -1,    -1,    -1,    -1,    -1,    -1,   631,   632,    -1,
     634,   635,   636,    -1,     5,   639,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,
      61,    -1,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
      -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,
     111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,
      -1,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,   167,   168,    -1,   170,
     171,   172,   173,   174,   175,   176,    -1,    -1,   179,   180,
     181,   182,    -1,    -1,   185,   186,    -1,   188,   189,   190,
     191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,    -1,   203,   204,   205,   206,   207,   208,   209,    -1,
     211,    -1,    -1,   214,   215,   216,    -1,   218,   219,    -1,
      -1,   222,   223,    -1,    -1,    -1,   227,   228,   229,   230,
     231,    -1,    -1,   234,   235,   236,    -1,   238,    -1,   240,
      -1,    -1,    -1,    -1,   245,   246,    -1,    -1,    -1,   250,
      -1,   252,   253,    -1,   255,   256,    -1,    -1,    -1,   260,
      -1,    -1,   263,   264,   265,    -1,    -1,   268,    -1,    -1,
     271,   272,    -1,    -1,    -1,    -1,    -1,   278,   279,    -1,
     281,    -1,   283,    -1,   285,   286,    -1,    -1,   289,    -1,
      -1,    -1,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,    -1,   310,
     311,   312,   313,    -1,   315,   316,   317,   318,    -1,   320,
     321,    -1,    -1,    -1,    -1,   326,   327,   328,   329,   330,
     331,    -1,    -1,   334,   335,    -1,   337,    -1,   339,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
      -1,    -1,   353,   354,    -1,    -1,   357,   358,   359,   360,
      -1,    -1,    -1,   364,   365,    -1,    -1,   368,   369,    -1,
     371,   372,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,
     391,   392,    -1,    -1,   395,    -1,   397,    -1,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,    -1,    -1,
     411,   412,   413,    -1,   415,    -1,   417,   418,   419,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,   436,    -1,    -1,   439,   440,
     441,   442,   443,    -1,   445,   446,    -1,   448,   449,   450,
      -1,    -1,   453,    -1,   455,    -1,   457,   458,    -1,   460,
     461,    -1,   463,    -1,   465,    -1,    -1,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,    -1,
     481,   482,    -1,    -1,    -1,   486,   487,   488,   489,    -1,
      -1,    -1,   493,    -1,    -1,    -1,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,   506,   507,   508,   509,   510,
     511,    -1,    -1,    -1,    -1,    -1,    -1,   518,   519,    -1,
     521,    -1,    -1,   524,    -1,    -1,   527,   528,    -1,    -1,
      -1,   532,    -1,    -1,   535,   536,    -1,   538,   539,   540,
     541,   542,   543,    -1,    -1,   546,   547,   548,   549,    -1,
     551,   552,    -1,   554,    -1,   556,   557,   558,   559,    -1,
     561,   562,   563,    -1,   565,   566,   567,   568,    -1,    -1,
      -1,    -1,    -1,   574,   575,   576,    -1,    -1,    -1,   580,
     581,   582,   583,   584,   585,   586,    -1,   588,   589,    -1,
     591,   592,    -1,    -1,   595,    -1,    -1,   598,    -1,   600,
      -1,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,    -1,    -1,   614,    -1,    -1,    -1,   618,   619,   620,
     621,   622,   623,   624,    -1,    -1,    -1,    -1,    -1,    -1,
     631,   632,    -1,   634,   635,   636,    -1,     5,   639,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,   109,   110,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,   167,
     168,    -1,   170,   171,   172,   173,   174,   175,   176,    -1,
      -1,   179,   180,   181,   182,    -1,    -1,   185,   186,    -1,
     188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,    -1,    -1,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,   222,   223,    -1,    -1,    -1,   227,
     228,   229,   230,   231,    -1,    -1,   234,   235,   236,    -1,
     238,    -1,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,
      -1,    -1,   250,    -1,   252,   253,    -1,   255,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,   265,    -1,    -1,
     268,    -1,    -1,   271,   272,   273,    -1,    -1,    -1,    -1,
     278,   279,    -1,   281,    -1,   283,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,    -1,   315,   316,   317,
     318,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,   329,   330,   331,    -1,    -1,   334,   335,    -1,   337,
      -1,   339,    -1,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,    -1,   353,   354,    -1,    -1,   357,
     358,   359,   360,    -1,    -1,    -1,   364,   365,    -1,    -1,
      -1,   369,    -1,   371,   372,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,    -1,   395,    -1,   397,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,    -1,   411,   412,   413,    -1,   415,    -1,   417,
     418,   419,   420,   421,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,   436,    -1,
      -1,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
     448,   449,   450,    -1,    -1,   453,    -1,   455,    -1,   457,
     458,    -1,   460,   461,    -1,   463,    -1,   465,    -1,    -1,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,    -1,   481,   482,    -1,    -1,    -1,   486,   487,
     488,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,   506,   507,
     508,   509,   510,   511,    -1,    -1,    -1,    -1,    -1,    -1,
     518,   519,    -1,   521,    -1,    -1,   524,    -1,    -1,   527,
     528,    -1,    -1,    -1,   532,    -1,    -1,   535,   536,    -1,
     538,   539,   540,   541,   542,   543,    -1,    -1,   546,   547,
     548,   549,    -1,   551,   552,    -1,   554,    -1,   556,   557,
     558,   559,    -1,   561,   562,   563,    -1,   565,   566,   567,
     568,    -1,    -1,    -1,    -1,    -1,   574,   575,   576,    -1,
      -1,    -1,   580,   581,   582,   583,    -1,   585,   586,    -1,
     588,   589,    -1,   591,   592,    -1,    -1,   595,    -1,    -1,
     598,    -1,   600,    -1,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,    -1,    -1,   614,    -1,    -1,    -1,
     618,   619,   620,   621,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,   631,   632,    -1,   634,   635,   636,    -1,
       5,   639,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,    -1,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,   167,   168,    -1,   170,   171,   172,   173,   174,
     175,   176,    -1,    -1,   179,   180,   181,   182,    -1,    -1,
     185,   186,    -1,   188,   189,   190,    -1,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,    -1,    -1,   214,
     215,   216,    -1,   218,    -1,    -1,    -1,   222,   223,    -1,
      -1,    -1,   227,   228,   229,   230,   231,    -1,    -1,   234,
     235,   236,    -1,   238,    -1,   240,    -1,    -1,    -1,    -1,
     245,   246,    -1,    -1,    -1,   250,    -1,   252,   253,    -1,
     255,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,
     265,    -1,    -1,   268,    -1,    -1,   271,   272,   273,    -1,
      -1,    -1,    -1,   278,   279,    -1,   281,    -1,   283,    -1,
     285,   286,    -1,    -1,    -1,    -1,    -1,    -1,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,