/************************************************************************************
    Copyright (C) 2019 Georg Richter and MariaDB Corporation AB

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not see <http://www.gnu.org/licenses>
   or write to the Free Software Foundation, Inc.,
   51 Franklin St., Fifth Floor, Boston, MA 02110, USA
*************************************************************************************/
PyDoc_STRVAR(
  cursor_lastrowid__doc__,
  "(read only)\n\n"
  "Returns the ID generated by a query on a table with a column having\n"
  "the AUTO_INCREMENT attribute or the value for the last usage of\n"
  "LAST_INSERT_ID(expr). If the last query wasn't an INSERT or UPDATE\n"
  "statement or if the modified table does not have a column with the\n"
  "AUTO_INCREMENT attribute and LAST_INSERT_ID was not used, the returned\n"
  "value will be zero"
);

PyDoc_STRVAR(
  cursor_description__doc__,
  "(read only)\n\n"
  "This read-only attribute is a sequence of 8-item sequences.\n"
  "Each of these sequences contains information describing one result column"
);

PyDoc_STRVAR(
  cursor_rowcount__doc__,
  "(read only)\n\n"
  "This read-only attribute specifies the number of rows that the last\n"
  "execute*() produced (for DQL statements like SELECT) or affected\n"
  "(for DML statements like UPDATE or INSERT).\n"
  "The return value is -1 in case no .execute*() has been performed\n"
  "on the cursor or the rowcount of the last operation  cannot be\n"
  "determined by the interface."
);

PyDoc_STRVAR(
  cursor_warnings__doc__,
  "(read only)\n\n"
  "Returns the number of warnings from the last executed statement, or zero\n"
  "if there are no warnings.\n\n"
  "If SQL_MODE TRADITIONAL is enabled an error instead of a warning will be\n"
  "returned. To retrieve warnings use the cursor method execute(\"SHOW WARNINGS\").\n"
);

PyDoc_STRVAR(
  cursor_closed__doc__,
  "(read only)\n\n"
  "Indicates if the cursor is closed and can't be reused"
);

PyDoc_STRVAR(
  cursor_buffered__doc__,
  "(read/write)\n\n"
  "When True all result sets are immediately transferred and the connection\n"
  "between client and server is no longer blocked. Default value is False."
);

PyDoc_STRVAR(
  cursor_close__doc__,
  "close()\n"
  "--\n"
  "\n"
  "Closes the cursor. If the cursor has pending or unread results, .close()\n"
  "will cancel them so that further operations using the same connection\n"
  "can be executed.\n\n"
  "The cursor will be unusable from this point forward; an Error (or subclass)\n"
  "exception will be raised if any operation is attempted with the cursor."
);

PyDoc_STRVAR(
  cursor_execute__doc__,
  "execute(statement [, params])\n"
  "--\n"
  "\n"
  "Parameters:\n"
  "statement: string\n"
  "params: tuple\n\n"
  "parameters may be provided as sequence or mapping and will be bound\n"
  "to variables in the operation. Variables are specified as question\n"
  "marks (paramstyle='qmark'), however for compatibility reasons MariaDB\n"
  "Connector/Python also supports the 'format' and 'pyformat' paramstyles\n"
  "with the restriction, that different paramstyles can't be mixed within.\n\n"
  "a statement\n"
  "A reference to the operation will be retained by the cursor.\n"
  "If the cursor was created with attribute prepared=True the statement\n"
  "string for following execute operations will be ignored:\n"
  "This is most effective for algorithms where the same operation is used,\n"
  "but different parameters are bound to it (many times)."
);

PyDoc_STRVAR(
  cursor_executemany__doc__,
  "executemany(statement, params)\n"
  "--\n"
  "\n"
  "Parameters:\n"
  "statement: string\n"
  "params: list of tuples\n\n"
  "Exactly behaves like .execute() but accepts a list of tuples, where each\n"
  "tuple represents data of a row within a table.\n"
  ".executemany() only supports DML (insert, update, delete) statements.\n\n"
  "The following example will insert 3 rows:\n\n"
  "data= [\n"
  "   (1, 'Michael', 'Widenius')\n"
  "   (2, 'Diego', 'Dupin')\n"
  "   (3, 'Lawrin', 'Novitsky')\n"
  "    ]\n"
  "cursor.execute(\"INSERT INTO colleagues VALUES (?, ?, ?\", data)\n"
);

PyDoc_STRVAR(
  cursor_fetchall__doc__,
  "fetchall()\n"
  "--\n"
  "\n"
  "Fetches all rows of a pending result set and returns a list of tuples.\n"
);

PyDoc_STRVAR(
  cursor_callproc__doc__,
  "callproc(procedure_name, args=())\n"
  "--\n"
  "\n"
  "Executes a stored procedure. The args sequence must contain an entry for\n"
  "each parameter the procedure expects.\n"
  "Input/Output or Output parameters have to be retrieved by .fetch methods,\n"
  "the .sp_outparams attribute indicates if the result set contains output\n"
  "parameters\n\n"
  "Example:\n\n"
  ">>>cursor.execute(\"CREATE PROCEDURE p1(IN i1 VAR  CHAR(20), OUT o2 VARCHAR(40))\"\n"
  "                \"BEGIN\"\n"
  "                \"  SELECT 'hello'\"\n"
  "                \"  o2:= 'test'\"\n"
  "                \"END\")\n"
  ">>>cursor.callproc('p1', ('foo', 0))\n"
  ">>> cursor.sp_outparams\n"
  "False\n"
  ">>> cursor.fetchone()\n"
  "('hello',)\n"
  ">>> cursor.nextset()\n"
  "True\n"
  ">>> cursor.sp_outparams\n"
  "True\n"
  ">>> cursor.fetchone()\n"
  "('test',)"
);

PyDoc_STRVAR(
  cursor_fetchone__doc__,
  "fetchone()\n"
  "--\n"
  "\n"
  "Fetches next row of a pending result set and returns a tuple.\n"
);

PyDoc_STRVAR(
  cursor_fetchmany__doc__,
  "fetchmany(size)\n"
  "--\n"
  "\n"
  "Parameter:\n"
  "size: integer\n"
  "Fetch the next set of rows of a query result, returning a list of tuples\n"
  "An empty list is returned when no more rows are available.\n\n"
  "The number of rows to fetch per call is specified by the size parameter.\n"
  "If it is not given, the cursor's arraysize determines the number of\n"
  "rows to be fetched."
);

PyDoc_STRVAR(
  cursor_field_count__doc__,
  "field_count()\n"
  "--\n"
  "\n"
  "Returns the number of fields (colunns) of a result set."
);

PyDoc_STRVAR(
  cursor_nextset__doc__,
  "nextset()\n"
  "--\n"
  "\n"
  "Will make the cursor skip to the next available result set,\n"
  "discarding any remaining rows from the current set."
);

PyDoc_STRVAR(
  cursor_setinputsizes__doc__,
  "setinputsizes()\n"
  "--\n"
  "\n"
  "Required by PEP-249. Does nothing in MariaDB Connector/Python"
);

PyDoc_STRVAR(
  cursor_setoutputsize__doc__,
  "setoutputsize()\n"
  "--\n"
  "\n"
  "Required by PEP-249. Does nothing in MariaDB Connector/Python"
);

PyDoc_STRVAR(
  cursor_next__doc__,
  "next()\n"
  "--\n"
  "\n"
  "Return the next row from the currently executing SQL statement\n"
  "using the same semantics as .fetchone()."
);

PyDoc_STRVAR(
  cursor_scroll__doc__,
  "scroll(value, mode=)\n"
  "--\n"
  "\n"
  "Parameters:\n"
  "value: integer\n"
  "mode: 'relative' (default) or 'absolute'\n\n"
  "Scroll the cursor in the result set to a new position according to mode.\n\n"
  "If mode is relative (default), value is taken as offset to the current\n"
  "position in the result set, if set to absolute, value states an absolute\n"
  "target position."
);

PyDoc_STRVAR(
  cursor_connection__doc__,
  "(read only)\n\n"
  "Reference to the connection object on which the cursor was created"
);

PyDoc_STRVAR(
  cursor_statement__doc__,
  "(read only)\n\n"
  "The last executed statement"
);

PyDoc_STRVAR(
  cursor_rownumber__doc__,
  "(read only)\n\n"
  "Current row number in result set"
);

PyDoc_STRVAR(
  cursor_arraysize__doc__,
  "(read/write)\n\n"
  "the number of rows to fetch"
);

PyDoc_STRVAR(
  cursor_sp_outparam__doc__,
  "(read)\n\n"
  "Indicates if the current result set contains inout or out parameter\n"
  "from a previous executed stored procedure."
);

PyDoc_STRVAR(
  cursor_enter__doc__,
  "(read)\n\n"
  "returns a copy of the cursor"
);

PyDoc_STRVAR(
  cursor_exit__doc__,
  "--\n"
  "closes the cursor"
);
