/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.fontchooser;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jhotdraw.gui.fontchooser.FontCollectionNode;
import org.jhotdraw.gui.fontchooser.FontFaceNode;

public class FontFamilyNode
implements MutableTreeNode,
Comparable<FontFamilyNode>,
Cloneable {
    private FontCollectionNode parent;
    private String name;
    private ArrayList<FontFaceNode> children = new ArrayList();

    public FontFamilyNode(String string) {
        this.name = string;
    }

    @Override
    public int compareTo(FontFamilyNode fontFamilyNode) {
        return Collator.getInstance().compare(this.name, fontFamilyNode.name);
    }

    public FontFamilyNode clone() {
        FontFamilyNode fontFamilyNode;
        try {
            fontFamilyNode = (FontFamilyNode)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError("Clone failed");
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
        fontFamilyNode.parent = null;
        fontFamilyNode.children = new ArrayList();
        for (FontFaceNode fontFaceNode : this.children) {
            fontFamilyNode.insert(fontFaceNode.clone(), fontFamilyNode.getChildCount());
        }
        return fontFamilyNode;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void add(FontFaceNode fontFaceNode) {
        this.insert(fontFaceNode, this.getChildCount());
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        FontFamilyNode fontFamilyNode = (FontFamilyNode)mutableTreeNode.getParent();
        if (fontFamilyNode != null) {
            fontFamilyNode.remove(mutableTreeNode);
        }
        mutableTreeNode.setParent(this);
        this.children.add(n, (FontFaceNode)mutableTreeNode);
    }

    @Override
    public void remove(int n) {
        FontFaceNode fontFaceNode = this.getChildAt(n);
        this.children.remove(n);
        fontFaceNode.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(mutableTreeNode)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(mutableTreeNode));
    }

    @Override
    public void setUserObject(Object object) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = (FontCollectionNode)mutableTreeNode;
    }

    @Override
    public FontFaceNode getChildAt(int n) {
        return this.children.get(n);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public List<FontFaceNode> faces() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isNodeChild(TreeNode treeNode) {
        boolean bl = treeNode == null ? false : (this.getChildCount() == 0 ? false : treeNode.getParent() == this);
        return bl;
    }

    public boolean isEditable() {
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FontFamilyNode) {
            FontFamilyNode fontFamilyNode = (FontFamilyNode)object;
            return fontFamilyNode.name.equals(this.name);
        }
        return false;
    }
}

