/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2010 Jean-Pierre Charras, jp.charras at wanadoo.fr
 * Copyright (C) 2014 KiCad Developers, see CHANGELOG.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#ifndef __dialog_lib_edit_pin__
#define __dialog_lib_edit_pin__

/**
 * @file
 * Subclass of DIALOG_LIB_EDIT_PIN_BASE, which is generated by wxFormBuilder.
 */

#include <wx/bmpcbox.h>
#include <pin_shape_combobox.h>
#include <pin_type_combobox.h>

#include <dialog_lib_edit_pin_base.h>

/** Implementing DIALOG_LIB_EDIT_PIN_BASE */
class DIALOG_LIB_EDIT_PIN : public DIALOG_LIB_EDIT_PIN_BASE
{
    LIB_PIN * m_dummyPin;       // a working copy used to show changes

public:
    /** Constructor */
    DIALOG_LIB_EDIT_PIN( EDA_DRAW_FRAME* parent, LIB_PIN* aPin );
    ~DIALOG_LIB_EDIT_PIN();

    void OnInitDialog( wxInitDialogEvent& event) override;

    void OnCloseDialog( wxCloseEvent& event ) override;
    void OnCancelButtonClick( wxCommandEvent& event ) override;
    void OnOKButtonClick( wxCommandEvent& event ) override;
    void OnPaintShowPanel( wxPaintEvent& event ) override;
    void OnPropertiesChange( wxCommandEvent& event ) override;

    void SetOrientationList( const wxArrayString& list, const BITMAP_DEF* aBitmaps );
    void SetOrientation( int orientation )
    {
        m_choiceOrientation->SetSelection( orientation );
    }
    int GetOrientation( void ) { return m_choiceOrientation->GetSelection(); }

    void SetElectricalType( ELECTRICAL_PINTYPE type )
    {
        m_choiceElectricalType->SetSelection( type );
    }

    ELECTRICAL_PINTYPE GetElectricalType( void )
    {
        return m_choiceElectricalType->GetPinTypeSelection();
    }

    void SetStyle( GRAPHIC_PINSHAPE style ) { m_choiceStyle->SetSelection( style ); }
    GRAPHIC_PINSHAPE GetStyle( void ) { return m_choiceStyle->GetPinShapeSelection(); }

    void SetPinName( const wxString& name ) { m_textPinName->SetValue( name ); }
    wxString GetPinName( void ) { return m_textPinName->GetValue(); }

    void SetPinNameTextSize( const wxString& size )
    {
        m_textPinNameTextSize->SetValue( size );
    }
    wxString GetPinNameTextSize( void )
    {
        return m_textPinNameTextSize->GetValue();
    }

    void SetPinPositionX( const wxString& aSize )
    {
        m_textPinPosX->SetValue( aSize );
    }

    void SetPinPositionY( const wxString& aSize )
    {
        m_textPinPosY->SetValue( aSize );
    }

    wxString GetPinPositionX()
    {
        return m_textPinPosX->GetValue();
    }

    wxString GetPinPositionY()
    {
        return m_textPinPosY->GetValue();
    }

    void SetPadName( const wxString& number )
    {
        m_textPadName->SetValue( number );
    }
    wxString GetPadName( void ) { return m_textPadName->GetValue(); }

    void SetPadNameTextSize( const wxString& size )
    {
        m_textPadNameTextSize->SetValue( size );
    }
    wxString GetPadNameTextSize( void )
    {
        return m_textPadNameTextSize->GetValue();
    }

    void SetLength( const wxString& length )
    {
        m_textLength->SetValue( length );
    }
    wxString GetLength( void ) { return m_textLength->GetValue(); }

    void SetAddToAllParts( bool apply )
    {
        m_checkApplyToAllParts->SetValue( apply );
    }
    bool GetAddToAllParts( void )
    {
        return m_checkApplyToAllParts->GetValue();
    }

    void SetAddToAllBodyStyles( bool apply )
    {
        m_checkApplyToAllConversions->SetValue( apply );
    }
    bool GetAddToAllBodyStyles( void )
    {
        return m_checkApplyToAllConversions->GetValue();
    }

    void SetDlgUnitsLabel( const wxString& units );

    void SetVisible( bool visible ) { m_checkShow->SetValue( visible ); }
    bool GetVisible( void ) { return m_checkShow->GetValue(); }
};

#endif // __dialog_lib_edit_pin__
