// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptCertificateTransfer = "AcceptCertificateTransfer"

// AcceptCertificateTransferRequest generates a "aws/request.Request" representing the
// client's request for the AcceptCertificateTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptCertificateTransfer for more information on using the AcceptCertificateTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptCertificateTransferRequest method.
//    req, resp := client.AcceptCertificateTransferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AcceptCertificateTransferRequest(input *AcceptCertificateTransferInput) (req *request.Request, output *AcceptCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opAcceptCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/accept-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &AcceptCertificateTransferInput{}
	}

	output = &AcceptCertificateTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptCertificateTransfer API operation for AWS IoT.
//
// Accepts a pending certificate transfer. The default state of the certificate
// is INACTIVE.
//
// To check for pending certificate transfers, call ListCertificates to enumerate
// your certificates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AcceptCertificateTransfer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeTransferAlreadyCompletedException "TransferAlreadyCompletedException"
//   You can't revert the certificate transfer because the transfer is already
//   complete.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) AcceptCertificateTransfer(input *AcceptCertificateTransferInput) (*AcceptCertificateTransferOutput, error) {
	req, out := c.AcceptCertificateTransferRequest(input)
	return out, req.Send()
}

// AcceptCertificateTransferWithContext is the same as AcceptCertificateTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptCertificateTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AcceptCertificateTransferWithContext(ctx aws.Context, input *AcceptCertificateTransferInput, opts ...request.Option) (*AcceptCertificateTransferOutput, error) {
	req, out := c.AcceptCertificateTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddThingToBillingGroup = "AddThingToBillingGroup"

// AddThingToBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the AddThingToBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddThingToBillingGroup for more information on using the AddThingToBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddThingToBillingGroupRequest method.
//    req, resp := client.AddThingToBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AddThingToBillingGroupRequest(input *AddThingToBillingGroupInput) (req *request.Request, output *AddThingToBillingGroupOutput) {
	op := &request.Operation{
		Name:       opAddThingToBillingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/billing-groups/addThingToBillingGroup",
	}

	if input == nil {
		input = &AddThingToBillingGroupInput{}
	}

	output = &AddThingToBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddThingToBillingGroup API operation for AWS IoT.
//
// Adds a thing to a billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AddThingToBillingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) AddThingToBillingGroup(input *AddThingToBillingGroupInput) (*AddThingToBillingGroupOutput, error) {
	req, out := c.AddThingToBillingGroupRequest(input)
	return out, req.Send()
}

// AddThingToBillingGroupWithContext is the same as AddThingToBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AddThingToBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AddThingToBillingGroupWithContext(ctx aws.Context, input *AddThingToBillingGroupInput, opts ...request.Option) (*AddThingToBillingGroupOutput, error) {
	req, out := c.AddThingToBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddThingToThingGroup = "AddThingToThingGroup"

// AddThingToThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the AddThingToThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddThingToThingGroup for more information on using the AddThingToThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddThingToThingGroupRequest method.
//    req, resp := client.AddThingToThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AddThingToThingGroupRequest(input *AddThingToThingGroupInput) (req *request.Request, output *AddThingToThingGroupOutput) {
	op := &request.Operation{
		Name:       opAddThingToThingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/thing-groups/addThingToThingGroup",
	}

	if input == nil {
		input = &AddThingToThingGroupInput{}
	}

	output = &AddThingToThingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddThingToThingGroup API operation for AWS IoT.
//
// Adds a thing to a thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AddThingToThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) AddThingToThingGroup(input *AddThingToThingGroupInput) (*AddThingToThingGroupOutput, error) {
	req, out := c.AddThingToThingGroupRequest(input)
	return out, req.Send()
}

// AddThingToThingGroupWithContext is the same as AddThingToThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AddThingToThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AddThingToThingGroupWithContext(ctx aws.Context, input *AddThingToThingGroupInput, opts ...request.Option) (*AddThingToThingGroupOutput, error) {
	req, out := c.AddThingToThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTargetsWithJob = "AssociateTargetsWithJob"

// AssociateTargetsWithJobRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTargetsWithJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTargetsWithJob for more information on using the AssociateTargetsWithJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateTargetsWithJobRequest method.
//    req, resp := client.AssociateTargetsWithJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AssociateTargetsWithJobRequest(input *AssociateTargetsWithJobInput) (req *request.Request, output *AssociateTargetsWithJobOutput) {
	op := &request.Operation{
		Name:       opAssociateTargetsWithJob,
		HTTPMethod: "POST",
		HTTPPath:   "/jobs/{jobId}/targets",
	}

	if input == nil {
		input = &AssociateTargetsWithJobInput{}
	}

	output = &AssociateTargetsWithJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTargetsWithJob API operation for AWS IoT.
//
// Associates a group with a continuous job. The following criteria must be
// met:
//
//    * The job must have been created with the targetSelection field set to
//    "CONTINUOUS".
//
//    * The job status must currently be "IN_PROGRESS".
//
//    * The total number of targets associated with a job must not exceed 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AssociateTargetsWithJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) AssociateTargetsWithJob(input *AssociateTargetsWithJobInput) (*AssociateTargetsWithJobOutput, error) {
	req, out := c.AssociateTargetsWithJobRequest(input)
	return out, req.Send()
}

// AssociateTargetsWithJobWithContext is the same as AssociateTargetsWithJob with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTargetsWithJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AssociateTargetsWithJobWithContext(ctx aws.Context, input *AssociateTargetsWithJobInput, opts ...request.Option) (*AssociateTargetsWithJobOutput, error) {
	req, out := c.AssociateTargetsWithJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachPolicy = "AttachPolicy"

// AttachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachPolicy for more information on using the AttachPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachPolicyRequest method.
//    req, resp := client.AttachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AttachPolicyRequest(input *AttachPolicyInput) (req *request.Request, output *AttachPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/target-policies/{policyName}",
	}

	if input == nil {
		input = &AttachPolicyInput{}
	}

	output = &AttachPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachPolicy API operation for AWS IoT.
//
// Attaches a policy to the specified target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) AttachPolicy(input *AttachPolicyInput) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	return out, req.Send()
}

// AttachPolicyWithContext is the same as AttachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AttachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AttachPolicyWithContext(ctx aws.Context, input *AttachPolicyInput, opts ...request.Option) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachPrincipalPolicy = "AttachPrincipalPolicy"

// AttachPrincipalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachPrincipalPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachPrincipalPolicy for more information on using the AttachPrincipalPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachPrincipalPolicyRequest method.
//    req, resp := client.AttachPrincipalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Deprecated: AttachPrincipalPolicy has been deprecated
func (c *IoT) AttachPrincipalPolicyRequest(input *AttachPrincipalPolicyInput) (req *request.Request, output *AttachPrincipalPolicyOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, AttachPrincipalPolicy, has been deprecated")
	}
	op := &request.Operation{
		Name:       opAttachPrincipalPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/principal-policies/{policyName}",
	}

	if input == nil {
		input = &AttachPrincipalPolicyInput{}
	}

	output = &AttachPrincipalPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachPrincipalPolicy API operation for AWS IoT.
//
// Attaches the specified policy to the specified principal (certificate or
// other credential).
//
// Note: This API is deprecated. Please use AttachPolicy instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachPrincipalPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//
// Deprecated: AttachPrincipalPolicy has been deprecated
func (c *IoT) AttachPrincipalPolicy(input *AttachPrincipalPolicyInput) (*AttachPrincipalPolicyOutput, error) {
	req, out := c.AttachPrincipalPolicyRequest(input)
	return out, req.Send()
}

// AttachPrincipalPolicyWithContext is the same as AttachPrincipalPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AttachPrincipalPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: AttachPrincipalPolicyWithContext has been deprecated
func (c *IoT) AttachPrincipalPolicyWithContext(ctx aws.Context, input *AttachPrincipalPolicyInput, opts ...request.Option) (*AttachPrincipalPolicyOutput, error) {
	req, out := c.AttachPrincipalPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachSecurityProfile = "AttachSecurityProfile"

// AttachSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the AttachSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachSecurityProfile for more information on using the AttachSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachSecurityProfileRequest method.
//    req, resp := client.AttachSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AttachSecurityProfileRequest(input *AttachSecurityProfileInput) (req *request.Request, output *AttachSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opAttachSecurityProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/security-profiles/{securityProfileName}/targets",
	}

	if input == nil {
		input = &AttachSecurityProfileInput{}
	}

	output = &AttachSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachSecurityProfile API operation for AWS IoT.
//
// Associates a Device Defender security profile with a thing group or with
// this account. Each thing group or account can have up to five security profiles
// associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachSecurityProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) AttachSecurityProfile(input *AttachSecurityProfileInput) (*AttachSecurityProfileOutput, error) {
	req, out := c.AttachSecurityProfileRequest(input)
	return out, req.Send()
}

// AttachSecurityProfileWithContext is the same as AttachSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See AttachSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AttachSecurityProfileWithContext(ctx aws.Context, input *AttachSecurityProfileInput, opts ...request.Option) (*AttachSecurityProfileOutput, error) {
	req, out := c.AttachSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachThingPrincipal = "AttachThingPrincipal"

// AttachThingPrincipalRequest generates a "aws/request.Request" representing the
// client's request for the AttachThingPrincipal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachThingPrincipal for more information on using the AttachThingPrincipal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachThingPrincipalRequest method.
//    req, resp := client.AttachThingPrincipalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AttachThingPrincipalRequest(input *AttachThingPrincipalInput) (req *request.Request, output *AttachThingPrincipalOutput) {
	op := &request.Operation{
		Name:       opAttachThingPrincipal,
		HTTPMethod: "PUT",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &AttachThingPrincipalInput{}
	}

	output = &AttachThingPrincipalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachThingPrincipal API operation for AWS IoT.
//
// Attaches the specified principal to the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachThingPrincipal for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) AttachThingPrincipal(input *AttachThingPrincipalInput) (*AttachThingPrincipalOutput, error) {
	req, out := c.AttachThingPrincipalRequest(input)
	return out, req.Send()
}

// AttachThingPrincipalWithContext is the same as AttachThingPrincipal with the addition of
// the ability to pass a context and additional request options.
//
// See AttachThingPrincipal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AttachThingPrincipalWithContext(ctx aws.Context, input *AttachThingPrincipalInput, opts ...request.Option) (*AttachThingPrincipalOutput, error) {
	req, out := c.AttachThingPrincipalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelAuditTask = "CancelAuditTask"

// CancelAuditTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelAuditTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelAuditTask for more information on using the CancelAuditTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelAuditTaskRequest method.
//    req, resp := client.CancelAuditTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelAuditTaskRequest(input *CancelAuditTaskInput) (req *request.Request, output *CancelAuditTaskOutput) {
	op := &request.Operation{
		Name:       opCancelAuditTask,
		HTTPMethod: "PUT",
		HTTPPath:   "/audit/tasks/{taskId}/cancel",
	}

	if input == nil {
		input = &CancelAuditTaskInput{}
	}

	output = &CancelAuditTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelAuditTask API operation for AWS IoT.
//
// Cancels an audit that is in progress. The audit can be either scheduled or
// on-demand. If the audit is not in progress, an "InvalidRequestException"
// occurs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelAuditTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CancelAuditTask(input *CancelAuditTaskInput) (*CancelAuditTaskOutput, error) {
	req, out := c.CancelAuditTaskRequest(input)
	return out, req.Send()
}

// CancelAuditTaskWithContext is the same as CancelAuditTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelAuditTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelAuditTaskWithContext(ctx aws.Context, input *CancelAuditTaskInput, opts ...request.Option) (*CancelAuditTaskOutput, error) {
	req, out := c.CancelAuditTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelCertificateTransfer = "CancelCertificateTransfer"

// CancelCertificateTransferRequest generates a "aws/request.Request" representing the
// client's request for the CancelCertificateTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelCertificateTransfer for more information on using the CancelCertificateTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelCertificateTransferRequest method.
//    req, resp := client.CancelCertificateTransferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelCertificateTransferRequest(input *CancelCertificateTransferInput) (req *request.Request, output *CancelCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opCancelCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/cancel-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &CancelCertificateTransferInput{}
	}

	output = &CancelCertificateTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelCertificateTransfer API operation for AWS IoT.
//
// Cancels a pending transfer for the specified certificate.
//
// Note Only the transfer source account can use this operation to cancel a
// transfer. (Transfer destinations can use RejectCertificateTransfer instead.)
// After transfer, AWS IoT returns the certificate to the source account in
// the INACTIVE state. After the destination account has accepted the transfer,
// the transfer cannot be cancelled.
//
// After a certificate transfer is cancelled, the status of the certificate
// changes from PENDING_TRANSFER to INACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelCertificateTransfer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeTransferAlreadyCompletedException "TransferAlreadyCompletedException"
//   You can't revert the certificate transfer because the transfer is already
//   complete.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CancelCertificateTransfer(input *CancelCertificateTransferInput) (*CancelCertificateTransferOutput, error) {
	req, out := c.CancelCertificateTransferRequest(input)
	return out, req.Send()
}

// CancelCertificateTransferWithContext is the same as CancelCertificateTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCertificateTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelCertificateTransferWithContext(ctx aws.Context, input *CancelCertificateTransferInput, opts ...request.Option) (*CancelCertificateTransferOutput, error) {
	req, out := c.CancelCertificateTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelJob = "CancelJob"

// CancelJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJob for more information on using the CancelJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelJobRequest method.
//    req, resp := client.CancelJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelJobRequest(input *CancelJobInput) (req *request.Request, output *CancelJobOutput) {
	op := &request.Operation{
		Name:       opCancelJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/jobs/{jobId}/cancel",
	}

	if input == nil {
		input = &CancelJobInput{}
	}

	output = &CancelJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelJob API operation for AWS IoT.
//
// Cancels a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) CancelJob(input *CancelJobInput) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	return out, req.Send()
}

// CancelJobWithContext is the same as CancelJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelJobWithContext(ctx aws.Context, input *CancelJobInput, opts ...request.Option) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelJobExecution = "CancelJobExecution"

// CancelJobExecutionRequest generates a "aws/request.Request" representing the
// client's request for the CancelJobExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJobExecution for more information on using the CancelJobExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelJobExecutionRequest method.
//    req, resp := client.CancelJobExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelJobExecutionRequest(input *CancelJobExecutionInput) (req *request.Request, output *CancelJobExecutionOutput) {
	op := &request.Operation{
		Name:       opCancelJobExecution,
		HTTPMethod: "PUT",
		HTTPPath:   "/things/{thingName}/jobs/{jobId}/cancel",
	}

	if input == nil {
		input = &CancelJobExecutionInput{}
	}

	output = &CancelJobExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelJobExecution API operation for AWS IoT.
//
// Cancels the execution of a job for a given thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelJobExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidStateTransitionException "InvalidStateTransitionException"
//   An attempt was made to change to an invalid state, for example by deleting
//   a job or a job execution which is "IN_PROGRESS" without setting the force
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
func (c *IoT) CancelJobExecution(input *CancelJobExecutionInput) (*CancelJobExecutionOutput, error) {
	req, out := c.CancelJobExecutionRequest(input)
	return out, req.Send()
}

// CancelJobExecutionWithContext is the same as CancelJobExecution with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJobExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelJobExecutionWithContext(ctx aws.Context, input *CancelJobExecutionInput, opts ...request.Option) (*CancelJobExecutionOutput, error) {
	req, out := c.CancelJobExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClearDefaultAuthorizer = "ClearDefaultAuthorizer"

// ClearDefaultAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the ClearDefaultAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ClearDefaultAuthorizer for more information on using the ClearDefaultAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ClearDefaultAuthorizerRequest method.
//    req, resp := client.ClearDefaultAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ClearDefaultAuthorizerRequest(input *ClearDefaultAuthorizerInput) (req *request.Request, output *ClearDefaultAuthorizerOutput) {
	op := &request.Operation{
		Name:       opClearDefaultAuthorizer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/default-authorizer",
	}

	if input == nil {
		input = &ClearDefaultAuthorizerInput{}
	}

	output = &ClearDefaultAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ClearDefaultAuthorizer API operation for AWS IoT.
//
// Clears the default authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ClearDefaultAuthorizer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ClearDefaultAuthorizer(input *ClearDefaultAuthorizerInput) (*ClearDefaultAuthorizerOutput, error) {
	req, out := c.ClearDefaultAuthorizerRequest(input)
	return out, req.Send()
}

// ClearDefaultAuthorizerWithContext is the same as ClearDefaultAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See ClearDefaultAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ClearDefaultAuthorizerWithContext(ctx aws.Context, input *ClearDefaultAuthorizerInput, opts ...request.Option) (*ClearDefaultAuthorizerOutput, error) {
	req, out := c.ClearDefaultAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAuthorizer = "CreateAuthorizer"

// CreateAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the CreateAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAuthorizer for more information on using the CreateAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAuthorizerRequest method.
//    req, resp := client.CreateAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateAuthorizerRequest(input *CreateAuthorizerInput) (req *request.Request, output *CreateAuthorizerOutput) {
	op := &request.Operation{
		Name:       opCreateAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/authorizer/{authorizerName}",
	}

	if input == nil {
		input = &CreateAuthorizerInput{}
	}

	output = &CreateAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAuthorizer API operation for AWS IoT.
//
// Creates an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateAuthorizer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateAuthorizer(input *CreateAuthorizerInput) (*CreateAuthorizerOutput, error) {
	req, out := c.CreateAuthorizerRequest(input)
	return out, req.Send()
}

// CreateAuthorizerWithContext is the same as CreateAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateAuthorizerWithContext(ctx aws.Context, input *CreateAuthorizerInput, opts ...request.Option) (*CreateAuthorizerOutput, error) {
	req, out := c.CreateAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBillingGroup = "CreateBillingGroup"

// CreateBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBillingGroup for more information on using the CreateBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBillingGroupRequest method.
//    req, resp := client.CreateBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateBillingGroupRequest(input *CreateBillingGroupInput) (req *request.Request, output *CreateBillingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateBillingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/billing-groups/{billingGroupName}",
	}

	if input == nil {
		input = &CreateBillingGroupInput{}
	}

	output = &CreateBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBillingGroup API operation for AWS IoT.
//
// Creates a billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateBillingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateBillingGroup(input *CreateBillingGroupInput) (*CreateBillingGroupOutput, error) {
	req, out := c.CreateBillingGroupRequest(input)
	return out, req.Send()
}

// CreateBillingGroupWithContext is the same as CreateBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateBillingGroupWithContext(ctx aws.Context, input *CreateBillingGroupInput, opts ...request.Option) (*CreateBillingGroupOutput, error) {
	req, out := c.CreateBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCertificateFromCsr = "CreateCertificateFromCsr"

// CreateCertificateFromCsrRequest generates a "aws/request.Request" representing the
// client's request for the CreateCertificateFromCsr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCertificateFromCsr for more information on using the CreateCertificateFromCsr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCertificateFromCsrRequest method.
//    req, resp := client.CreateCertificateFromCsrRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateCertificateFromCsrRequest(input *CreateCertificateFromCsrInput) (req *request.Request, output *CreateCertificateFromCsrOutput) {
	op := &request.Operation{
		Name:       opCreateCertificateFromCsr,
		HTTPMethod: "POST",
		HTTPPath:   "/certificates",
	}

	if input == nil {
		input = &CreateCertificateFromCsrInput{}
	}

	output = &CreateCertificateFromCsrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCertificateFromCsr API operation for AWS IoT.
//
// Creates an X.509 certificate using the specified certificate signing request.
//
// Note: The CSR must include a public key that is either an RSA key with a
// length of at least 2048 bits or an ECC key from NIST P-256 or NIST P-384
// curves.
//
// Note: Reusing the same certificate signing request (CSR) results in a distinct
// certificate.
//
// You can create multiple certificates in a batch by creating a directory,
// copying multiple .csr files into that directory, and then specifying that
// directory on the command line. The following commands show how to create
// a batch of certificates given a batch of CSRs.
//
// Assuming a set of CSRs are located inside of the directory my-csr-directory:
//
// On Linux and OS X, the command is:
//
// $ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr
// --certificate-signing-request file://my-csr-directory/{}
//
// This command lists all of the CSRs in my-csr-directory and pipes each CSR
// file name to the aws iot create-certificate-from-csr AWS CLI command to create
// a certificate for the corresponding CSR.
//
// The aws iot create-certificate-from-csr part of the command can also be run
// in parallel to speed up the certificate creation process:
//
// $ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr
// --certificate-signing-request file://my-csr-directory/{}
//
// On Windows PowerShell, the command to create certificates for all CSRs in
// my-csr-directory is:
//
// > ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request
// file://my-csr-directory/$_}
//
// On a Windows command prompt, the command to create certificates for all CSRs
// in my-csr-directory is:
//
// > forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr
// --certificate-signing-request file://@path"
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateCertificateFromCsr for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateCertificateFromCsr(input *CreateCertificateFromCsrInput) (*CreateCertificateFromCsrOutput, error) {
	req, out := c.CreateCertificateFromCsrRequest(input)
	return out, req.Send()
}

// CreateCertificateFromCsrWithContext is the same as CreateCertificateFromCsr with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCertificateFromCsr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateCertificateFromCsrWithContext(ctx aws.Context, input *CreateCertificateFromCsrInput, opts ...request.Option) (*CreateCertificateFromCsrOutput, error) {
	req, out := c.CreateCertificateFromCsrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDynamicThingGroup = "CreateDynamicThingGroup"

// CreateDynamicThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDynamicThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDynamicThingGroup for more information on using the CreateDynamicThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDynamicThingGroupRequest method.
//    req, resp := client.CreateDynamicThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateDynamicThingGroupRequest(input *CreateDynamicThingGroupInput) (req *request.Request, output *CreateDynamicThingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDynamicThingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/dynamic-thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &CreateDynamicThingGroupInput{}
	}

	output = &CreateDynamicThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDynamicThingGroup API operation for AWS IoT.
//
// Creates a dynamic thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateDynamicThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidQueryException "InvalidQueryException"
//   The query is invalid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) CreateDynamicThingGroup(input *CreateDynamicThingGroupInput) (*CreateDynamicThingGroupOutput, error) {
	req, out := c.CreateDynamicThingGroupRequest(input)
	return out, req.Send()
}

// CreateDynamicThingGroupWithContext is the same as CreateDynamicThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDynamicThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateDynamicThingGroupWithContext(ctx aws.Context, input *CreateDynamicThingGroupInput, opts ...request.Option) (*CreateDynamicThingGroupOutput, error) {
	req, out := c.CreateDynamicThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJob API operation for AWS IoT.
//
// Creates a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeysAndCertificate = "CreateKeysAndCertificate"

// CreateKeysAndCertificateRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeysAndCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeysAndCertificate for more information on using the CreateKeysAndCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateKeysAndCertificateRequest method.
//    req, resp := client.CreateKeysAndCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateKeysAndCertificateRequest(input *CreateKeysAndCertificateInput) (req *request.Request, output *CreateKeysAndCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateKeysAndCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/keys-and-certificate",
	}

	if input == nil {
		input = &CreateKeysAndCertificateInput{}
	}

	output = &CreateKeysAndCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeysAndCertificate API operation for AWS IoT.
//
// Creates a 2048-bit RSA key pair and issues an X.509 certificate using the
// issued public key.
//
// Note This is the only time AWS IoT issues the private key for this certificate,
// so it is important to keep it in a secure location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateKeysAndCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateKeysAndCertificate(input *CreateKeysAndCertificateInput) (*CreateKeysAndCertificateOutput, error) {
	req, out := c.CreateKeysAndCertificateRequest(input)
	return out, req.Send()
}

// CreateKeysAndCertificateWithContext is the same as CreateKeysAndCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeysAndCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateKeysAndCertificateWithContext(ctx aws.Context, input *CreateKeysAndCertificateInput, opts ...request.Option) (*CreateKeysAndCertificateOutput, error) {
	req, out := c.CreateKeysAndCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOTAUpdate = "CreateOTAUpdate"

// CreateOTAUpdateRequest generates a "aws/request.Request" representing the
// client's request for the CreateOTAUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOTAUpdate for more information on using the CreateOTAUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOTAUpdateRequest method.
//    req, resp := client.CreateOTAUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateOTAUpdateRequest(input *CreateOTAUpdateInput) (req *request.Request, output *CreateOTAUpdateOutput) {
	op := &request.Operation{
		Name:       opCreateOTAUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/otaUpdates/{otaUpdateId}",
	}

	if input == nil {
		input = &CreateOTAUpdateInput{}
	}

	output = &CreateOTAUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOTAUpdate API operation for AWS IoT.
//
// Creates an AWS IoT OTAUpdate on a target group of things or groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateOTAUpdate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) CreateOTAUpdate(input *CreateOTAUpdateInput) (*CreateOTAUpdateOutput, error) {
	req, out := c.CreateOTAUpdateRequest(input)
	return out, req.Send()
}

// CreateOTAUpdateWithContext is the same as CreateOTAUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOTAUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateOTAUpdateWithContext(ctx aws.Context, input *CreateOTAUpdateInput, opts ...request.Option) (*CreateOTAUpdateOutput, error) {
	req, out := c.CreateOTAUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicy = "CreatePolicy"

// CreatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePolicy for more information on using the CreatePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePolicyRequest method.
//    req, resp := client.CreatePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreatePolicyRequest(input *CreatePolicyInput) (req *request.Request, output *CreatePolicyOutput) {
	op := &request.Operation{
		Name:       opCreatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &CreatePolicyInput{}
	}

	output = &CreatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicy API operation for AWS IoT.
//
// Creates an AWS IoT policy.
//
// The created policy is the default version for the policy. This operation
// creates a policy version with a version identifier of 1 and sets 1 as the
// policy's default version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreatePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeMalformedPolicyException "MalformedPolicyException"
//   The policy documentation is not valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreatePolicy(input *CreatePolicyInput) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	return out, req.Send()
}

// CreatePolicyWithContext is the same as CreatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreatePolicyWithContext(ctx aws.Context, input *CreatePolicyInput, opts ...request.Option) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicyVersion = "CreatePolicyVersion"

// CreatePolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicyVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePolicyVersion for more information on using the CreatePolicyVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePolicyVersionRequest method.
//    req, resp := client.CreatePolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreatePolicyVersionRequest(input *CreatePolicyVersionInput) (req *request.Request, output *CreatePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opCreatePolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/policies/{policyName}/version",
	}

	if input == nil {
		input = &CreatePolicyVersionInput{}
	}

	output = &CreatePolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicyVersion API operation for AWS IoT.
//
// Creates a new version of the specified AWS IoT policy. To update a policy,
// create a new policy version. A managed policy can have up to five versions.
// If the policy has five versions, you must use DeletePolicyVersion to delete
// an existing version before you create a new one.
//
// Optionally, you can set the new version as the policy's default version.
// The default version is the operative version (that is, the version that is
// in effect for the certificates to which the policy is attached).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreatePolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeMalformedPolicyException "MalformedPolicyException"
//   The policy documentation is not valid.
//
//   * ErrCodeVersionsLimitExceededException "VersionsLimitExceededException"
//   The number of policy versions exceeds the limit.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreatePolicyVersion(input *CreatePolicyVersionInput) (*CreatePolicyVersionOutput, error) {
	req, out := c.CreatePolicyVersionRequest(input)
	return out, req.Send()
}

// CreatePolicyVersionWithContext is the same as CreatePolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreatePolicyVersionWithContext(ctx aws.Context, input *CreatePolicyVersionInput, opts ...request.Option) (*CreatePolicyVersionOutput, error) {
	req, out := c.CreatePolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoleAlias = "CreateRoleAlias"

// CreateRoleAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoleAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoleAlias for more information on using the CreateRoleAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRoleAliasRequest method.
//    req, resp := client.CreateRoleAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateRoleAliasRequest(input *CreateRoleAliasInput) (req *request.Request, output *CreateRoleAliasOutput) {
	op := &request.Operation{
		Name:       opCreateRoleAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/role-aliases/{roleAlias}",
	}

	if input == nil {
		input = &CreateRoleAliasInput{}
	}

	output = &CreateRoleAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoleAlias API operation for AWS IoT.
//
// Creates a role alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateRoleAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateRoleAlias(input *CreateRoleAliasInput) (*CreateRoleAliasOutput, error) {
	req, out := c.CreateRoleAliasRequest(input)
	return out, req.Send()
}

// CreateRoleAliasWithContext is the same as CreateRoleAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoleAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateRoleAliasWithContext(ctx aws.Context, input *CreateRoleAliasInput, opts ...request.Option) (*CreateRoleAliasOutput, error) {
	req, out := c.CreateRoleAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScheduledAudit = "CreateScheduledAudit"

// CreateScheduledAuditRequest generates a "aws/request.Request" representing the
// client's request for the CreateScheduledAudit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScheduledAudit for more information on using the CreateScheduledAudit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateScheduledAuditRequest method.
//    req, resp := client.CreateScheduledAuditRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateScheduledAuditRequest(input *CreateScheduledAuditInput) (req *request.Request, output *CreateScheduledAuditOutput) {
	op := &request.Operation{
		Name:       opCreateScheduledAudit,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/scheduledaudits/{scheduledAuditName}",
	}

	if input == nil {
		input = &CreateScheduledAuditInput{}
	}

	output = &CreateScheduledAuditOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScheduledAudit API operation for AWS IoT.
//
// Creates a scheduled audit that is run at a specified time interval.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateScheduledAudit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) CreateScheduledAudit(input *CreateScheduledAuditInput) (*CreateScheduledAuditOutput, error) {
	req, out := c.CreateScheduledAuditRequest(input)
	return out, req.Send()
}

// CreateScheduledAuditWithContext is the same as CreateScheduledAudit with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScheduledAudit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateScheduledAuditWithContext(ctx aws.Context, input *CreateScheduledAuditInput, opts ...request.Option) (*CreateScheduledAuditOutput, error) {
	req, out := c.CreateScheduledAuditRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityProfile = "CreateSecurityProfile"

// CreateSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecurityProfile for more information on using the CreateSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSecurityProfileRequest method.
//    req, resp := client.CreateSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateSecurityProfileRequest(input *CreateSecurityProfileInput) (req *request.Request, output *CreateSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/security-profiles/{securityProfileName}",
	}

	if input == nil {
		input = &CreateSecurityProfileInput{}
	}

	output = &CreateSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityProfile API operation for AWS IoT.
//
// Creates a Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateSecurityProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateSecurityProfile(input *CreateSecurityProfileInput) (*CreateSecurityProfileOutput, error) {
	req, out := c.CreateSecurityProfileRequest(input)
	return out, req.Send()
}

// CreateSecurityProfileWithContext is the same as CreateSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateSecurityProfileWithContext(ctx aws.Context, input *CreateSecurityProfileInput, opts ...request.Option) (*CreateSecurityProfileOutput, error) {
	req, out := c.CreateSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStream = "CreateStream"

// CreateStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStream for more information on using the CreateStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamRequest method.
//    req, resp := client.CreateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateStreamRequest(input *CreateStreamInput) (req *request.Request, output *CreateStreamOutput) {
	op := &request.Operation{
		Name:       opCreateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &CreateStreamInput{}
	}

	output = &CreateStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStream API operation for AWS IoT.
//
// Creates a stream for delivering one or more large files in chunks over MQTT.
// A stream transports data bytes in chunks or blocks packaged as MQTT messages
// from a source like S3. You can have one or more files associated with a stream.
// The total size of a file associated with the stream cannot exceed more than
// 2 MB. The stream will be created with version 0. If a stream is created with
// the same streamID as a stream that existed and was deleted within last 90
// days, we will resurrect that old stream by incrementing the version by 1.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateStream(input *CreateStreamInput) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	return out, req.Send()
}

// CreateStreamWithContext is the same as CreateStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateStreamWithContext(ctx aws.Context, input *CreateStreamInput, opts ...request.Option) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThing = "CreateThing"

// CreateThingRequest generates a "aws/request.Request" representing the
// client's request for the CreateThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThing for more information on using the CreateThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThingRequest method.
//    req, resp := client.CreateThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateThingRequest(input *CreateThingInput) (req *request.Request, output *CreateThingOutput) {
	op := &request.Operation{
		Name:       opCreateThing,
		HTTPMethod: "POST",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &CreateThingInput{}
	}

	output = &CreateThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThing API operation for AWS IoT.
//
// Creates a thing record in the registry.
//
// This is a control plane operation. See Authorization (http://docs.aws.amazon.com/iot/latest/developerguide/authorization.html)
// for information about authorizing control plane actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) CreateThing(input *CreateThingInput) (*CreateThingOutput, error) {
	req, out := c.CreateThingRequest(input)
	return out, req.Send()
}

// CreateThingWithContext is the same as CreateThing with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateThingWithContext(ctx aws.Context, input *CreateThingInput, opts ...request.Option) (*CreateThingOutput, error) {
	req, out := c.CreateThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThingGroup = "CreateThingGroup"

// CreateThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThingGroup for more information on using the CreateThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThingGroupRequest method.
//    req, resp := client.CreateThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateThingGroupRequest(input *CreateThingGroupInput) (req *request.Request, output *CreateThingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateThingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &CreateThingGroupInput{}
	}

	output = &CreateThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThingGroup API operation for AWS IoT.
//
// Create a thing group.
//
// This is a control plane operation. See Authorization (http://docs.aws.amazon.com/iot/latest/developerguide/authorization.html)
// for information about authorizing control plane actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateThingGroup(input *CreateThingGroupInput) (*CreateThingGroupOutput, error) {
	req, out := c.CreateThingGroupRequest(input)
	return out, req.Send()
}

// CreateThingGroupWithContext is the same as CreateThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateThingGroupWithContext(ctx aws.Context, input *CreateThingGroupInput, opts ...request.Option) (*CreateThingGroupOutput, error) {
	req, out := c.CreateThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThingType = "CreateThingType"

// CreateThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateThingType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThingType for more information on using the CreateThingType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThingTypeRequest method.
//    req, resp := client.CreateThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateThingTypeRequest(input *CreateThingTypeInput) (req *request.Request, output *CreateThingTypeOutput) {
	op := &request.Operation{
		Name:       opCreateThingType,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-types/{thingTypeName}",
	}

	if input == nil {
		input = &CreateThingTypeInput{}
	}

	output = &CreateThingTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThingType API operation for AWS IoT.
//
// Creates a new thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateThingType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
func (c *IoT) CreateThingType(input *CreateThingTypeInput) (*CreateThingTypeOutput, error) {
	req, out := c.CreateThingTypeRequest(input)
	return out, req.Send()
}

// CreateThingTypeWithContext is the same as CreateThingType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateThingTypeWithContext(ctx aws.Context, input *CreateThingTypeInput, opts ...request.Option) (*CreateThingTypeOutput, error) {
	req, out := c.CreateThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTopicRule = "CreateTopicRule"

// CreateTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTopicRule for more information on using the CreateTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTopicRuleRequest method.
//    req, resp := client.CreateTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateTopicRuleRequest(input *CreateTopicRuleInput) (req *request.Request, output *CreateTopicRuleOutput) {
	op := &request.Operation{
		Name:       opCreateTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &CreateTopicRuleInput{}
	}

	output = &CreateTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTopicRule API operation for AWS IoT.
//
// Creates a rule. Creating rules is an administrator-level action. Any user
// who has permission to create rules will be able to access data processed
// by the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSqlParseException "SqlParseException"
//   The Rule-SQL expression can't be parsed correctly.
//
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeConflictingResourceUpdateException "ConflictingResourceUpdateException"
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) CreateTopicRule(input *CreateTopicRuleInput) (*CreateTopicRuleOutput, error) {
	req, out := c.CreateTopicRuleRequest(input)
	return out, req.Send()
}

// CreateTopicRuleWithContext is the same as CreateTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateTopicRuleWithContext(ctx aws.Context, input *CreateTopicRuleInput, opts ...request.Option) (*CreateTopicRuleOutput, error) {
	req, out := c.CreateTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountAuditConfiguration = "DeleteAccountAuditConfiguration"

// DeleteAccountAuditConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountAuditConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountAuditConfiguration for more information on using the DeleteAccountAuditConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccountAuditConfigurationRequest method.
//    req, resp := client.DeleteAccountAuditConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteAccountAuditConfigurationRequest(input *DeleteAccountAuditConfigurationInput) (req *request.Request, output *DeleteAccountAuditConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountAuditConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/audit/configuration",
	}

	if input == nil {
		input = &DeleteAccountAuditConfigurationInput{}
	}

	output = &DeleteAccountAuditConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccountAuditConfiguration API operation for AWS IoT.
//
// Restores the default settings for Device Defender audits for this account.
// Any configuration data you entered is deleted and all audit checks are reset
// to disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteAccountAuditConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteAccountAuditConfiguration(input *DeleteAccountAuditConfigurationInput) (*DeleteAccountAuditConfigurationOutput, error) {
	req, out := c.DeleteAccountAuditConfigurationRequest(input)
	return out, req.Send()
}

// DeleteAccountAuditConfigurationWithContext is the same as DeleteAccountAuditConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountAuditConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteAccountAuditConfigurationWithContext(ctx aws.Context, input *DeleteAccountAuditConfigurationInput, opts ...request.Option) (*DeleteAccountAuditConfigurationOutput, error) {
	req, out := c.DeleteAccountAuditConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAuthorizer = "DeleteAuthorizer"

// DeleteAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAuthorizer for more information on using the DeleteAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAuthorizerRequest method.
//    req, resp := client.DeleteAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteAuthorizerRequest(input *DeleteAuthorizerInput) (req *request.Request, output *DeleteAuthorizerOutput) {
	op := &request.Operation{
		Name:       opDeleteAuthorizer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/authorizer/{authorizerName}",
	}

	if input == nil {
		input = &DeleteAuthorizerInput{}
	}

	output = &DeleteAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAuthorizer API operation for AWS IoT.
//
// Deletes an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteAuthorizer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeleteConflictException "DeleteConflictException"
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteAuthorizer(input *DeleteAuthorizerInput) (*DeleteAuthorizerOutput, error) {
	req, out := c.DeleteAuthorizerRequest(input)
	return out, req.Send()
}

// DeleteAuthorizerWithContext is the same as DeleteAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteAuthorizerWithContext(ctx aws.Context, input *DeleteAuthorizerInput, opts ...request.Option) (*DeleteAuthorizerOutput, error) {
	req, out := c.DeleteAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBillingGroup = "DeleteBillingGroup"

// DeleteBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBillingGroup for more information on using the DeleteBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBillingGroupRequest method.
//    req, resp := client.DeleteBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteBillingGroupRequest(input *DeleteBillingGroupInput) (req *request.Request, output *DeleteBillingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteBillingGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/billing-groups/{billingGroupName}",
	}

	if input == nil {
		input = &DeleteBillingGroupInput{}
	}

	output = &DeleteBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBillingGroup API operation for AWS IoT.
//
// Deletes the billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteBillingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteBillingGroup(input *DeleteBillingGroupInput) (*DeleteBillingGroupOutput, error) {
	req, out := c.DeleteBillingGroupRequest(input)
	return out, req.Send()
}

// DeleteBillingGroupWithContext is the same as DeleteBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteBillingGroupWithContext(ctx aws.Context, input *DeleteBillingGroupInput, opts ...request.Option) (*DeleteBillingGroupOutput, error) {
	req, out := c.DeleteBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCACertificate = "DeleteCACertificate"

// DeleteCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCACertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCACertificate for more information on using the DeleteCACertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCACertificateRequest method.
//    req, resp := client.DeleteCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteCACertificateRequest(input *DeleteCACertificateInput) (req *request.Request, output *DeleteCACertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCACertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &DeleteCACertificateInput{}
	}

	output = &DeleteCACertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCACertificate API operation for AWS IoT.
//
// Deletes a registered CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteCACertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DeleteCACertificate(input *DeleteCACertificateInput) (*DeleteCACertificateOutput, error) {
	req, out := c.DeleteCACertificateRequest(input)
	return out, req.Send()
}

// DeleteCACertificateWithContext is the same as DeleteCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteCACertificateWithContext(ctx aws.Context, input *DeleteCACertificateInput, opts ...request.Option) (*DeleteCACertificateOutput, error) {
	req, out := c.DeleteCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCertificate for more information on using the DeleteCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCertificateRequest method.
//    req, resp := client.DeleteCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	output = &DeleteCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCertificate API operation for AWS IoT.
//
// Deletes the specified certificate.
//
// A certificate cannot be deleted if it has a policy attached to it or if its
// status is set to ACTIVE. To delete a certificate, first use the DetachPrincipalPolicy
// API to detach all policies. Next, use the UpdateCertificate API to set the
// certificate to the INACTIVE status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeDeleteConflictException "DeleteConflictException"
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	return out, req.Send()
}

// DeleteCertificateWithContext is the same as DeleteCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteCertificateWithContext(ctx aws.Context, input *DeleteCertificateInput, opts ...request.Option) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDynamicThingGroup = "DeleteDynamicThingGroup"

// DeleteDynamicThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDynamicThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDynamicThingGroup for more information on using the DeleteDynamicThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDynamicThingGroupRequest method.
//    req, resp := client.DeleteDynamicThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteDynamicThingGroupRequest(input *DeleteDynamicThingGroupInput) (req *request.Request, output *DeleteDynamicThingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDynamicThingGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dynamic-thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &DeleteDynamicThingGroupInput{}
	}

	output = &DeleteDynamicThingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDynamicThingGroup API operation for AWS IoT.
//
// Deletes a dynamic thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteDynamicThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteDynamicThingGroup(input *DeleteDynamicThingGroupInput) (*DeleteDynamicThingGroupOutput, error) {
	req, out := c.DeleteDynamicThingGroupRequest(input)
	return out, req.Send()
}

// DeleteDynamicThingGroupWithContext is the same as DeleteDynamicThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDynamicThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteDynamicThingGroupWithContext(ctx aws.Context, input *DeleteDynamicThingGroupInput, opts ...request.Option) (*DeleteDynamicThingGroupOutput, error) {
	req, out := c.DeleteDynamicThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJob = "DeleteJob"

// DeleteJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJob for more information on using the DeleteJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobRequest method.
//    req, resp := client.DeleteJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteJobRequest(input *DeleteJobInput) (req *request.Request, output *DeleteJobOutput) {
	op := &request.Operation{
		Name:       opDeleteJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &DeleteJobInput{}
	}

	output = &DeleteJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteJob API operation for AWS IoT.
//
// Deletes a job and its related job executions.
//
// Deleting a job may take time, depending on the number of job executions created
// for the job and various other factors. While the job is being deleted, the
// status of the job will be shown as "DELETION_IN_PROGRESS". Attempting to
// delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will
// result in an error.
//
// Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or
// a LimitExceededException will occur.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidStateTransitionException "InvalidStateTransitionException"
//   An attempt was made to change to an invalid state, for example by deleting
//   a job or a job execution which is "IN_PROGRESS" without setting the force
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) DeleteJob(input *DeleteJobInput) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	return out, req.Send()
}

// DeleteJobWithContext is the same as DeleteJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteJobWithContext(ctx aws.Context, input *DeleteJobInput, opts ...request.Option) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJobExecution = "DeleteJobExecution"

// DeleteJobExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJobExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJobExecution for more information on using the DeleteJobExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobExecutionRequest method.
//    req, resp := client.DeleteJobExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteJobExecutionRequest(input *DeleteJobExecutionInput) (req *request.Request, output *DeleteJobExecutionOutput) {
	op := &request.Operation{
		Name:       opDeleteJobExecution,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}/jobs/{jobId}/executionNumber/{executionNumber}",
	}

	if input == nil {
		input = &DeleteJobExecutionInput{}
	}

	output = &DeleteJobExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteJobExecution API operation for AWS IoT.
//
// Deletes a job execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteJobExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidStateTransitionException "InvalidStateTransitionException"
//   An attempt was made to change to an invalid state, for example by deleting
//   a job or a job execution which is "IN_PROGRESS" without setting the force
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) DeleteJobExecution(input *DeleteJobExecutionInput) (*DeleteJobExecutionOutput, error) {
	req, out := c.DeleteJobExecutionRequest(input)
	return out, req.Send()
}

// DeleteJobExecutionWithContext is the same as DeleteJobExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJobExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteJobExecutionWithContext(ctx aws.Context, input *DeleteJobExecutionInput, opts ...request.Option) (*DeleteJobExecutionOutput, error) {
	req, out := c.DeleteJobExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOTAUpdate = "DeleteOTAUpdate"

// DeleteOTAUpdateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOTAUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOTAUpdate for more information on using the DeleteOTAUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOTAUpdateRequest method.
//    req, resp := client.DeleteOTAUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteOTAUpdateRequest(input *DeleteOTAUpdateInput) (req *request.Request, output *DeleteOTAUpdateOutput) {
	op := &request.Operation{
		Name:       opDeleteOTAUpdate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/otaUpdates/{otaUpdateId}",
	}

	if input == nil {
		input = &DeleteOTAUpdateInput{}
	}

	output = &DeleteOTAUpdateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOTAUpdate API operation for AWS IoT.
//
// Delete an OTA update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteOTAUpdate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
func (c *IoT) DeleteOTAUpdate(input *DeleteOTAUpdateInput) (*DeleteOTAUpdateOutput, error) {
	req, out := c.DeleteOTAUpdateRequest(input)
	return out, req.Send()
}

// DeleteOTAUpdateWithContext is the same as DeleteOTAUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOTAUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteOTAUpdateWithContext(ctx aws.Context, input *DeleteOTAUpdateInput, opts ...request.Option) (*DeleteOTAUpdateOutput, error) {
	req, out := c.DeleteOTAUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicy for more information on using the DeletePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for AWS IoT.
//
// Deletes the specified policy.
//
// A policy cannot be deleted if it has non-default versions or it is attached
// to any certificate.
//
// To delete a policy, use the DeletePolicyVersion API to delete all non-default
// versions of the policy; use the DetachPrincipalPolicy API to detach the policy
// from any certificate; and then use the DeletePolicy API to delete the policy.
//
// When a policy is deleted using DeletePolicy, its default version is deleted
// with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeleteConflictException "DeleteConflictException"
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicyVersion = "DeletePolicyVersion"

// DeletePolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicyVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicyVersion for more information on using the DeletePolicyVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePolicyVersionRequest method.
//    req, resp := client.DeletePolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeletePolicyVersionRequest(input *DeletePolicyVersionInput) (req *request.Request, output *DeletePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opDeletePolicyVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &DeletePolicyVersionInput{}
	}

	output = &DeletePolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicyVersion API operation for AWS IoT.
//
// Deletes the specified version of the specified policy. You cannot delete
// the default version of a policy using this API. To delete the default version
// of a policy, use DeletePolicy. To find out which version of a policy is marked
// as the default version, use ListPolicyVersions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeletePolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeleteConflictException "DeleteConflictException"
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeletePolicyVersion(input *DeletePolicyVersionInput) (*DeletePolicyVersionOutput, error) {
	req, out := c.DeletePolicyVersionRequest(input)
	return out, req.Send()
}

// DeletePolicyVersionWithContext is the same as DeletePolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeletePolicyVersionWithContext(ctx aws.Context, input *DeletePolicyVersionInput, opts ...request.Option) (*DeletePolicyVersionOutput, error) {
	req, out := c.DeletePolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegistrationCode = "DeleteRegistrationCode"

// DeleteRegistrationCodeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegistrationCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRegistrationCode for more information on using the DeleteRegistrationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRegistrationCodeRequest method.
//    req, resp := client.DeleteRegistrationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteRegistrationCodeRequest(input *DeleteRegistrationCodeInput) (req *request.Request, output *DeleteRegistrationCodeOutput) {
	op := &request.Operation{
		Name:       opDeleteRegistrationCode,
		HTTPMethod: "DELETE",
		HTTPPath:   "/registrationcode",
	}

	if input == nil {
		input = &DeleteRegistrationCodeInput{}
	}

	output = &DeleteRegistrationCodeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRegistrationCode API operation for AWS IoT.
//
// Deletes a CA certificate registration code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteRegistrationCode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteRegistrationCode(input *DeleteRegistrationCodeInput) (*DeleteRegistrationCodeOutput, error) {
	req, out := c.DeleteRegistrationCodeRequest(input)
	return out, req.Send()
}

// DeleteRegistrationCodeWithContext is the same as DeleteRegistrationCode with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegistrationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteRegistrationCodeWithContext(ctx aws.Context, input *DeleteRegistrationCodeInput, opts ...request.Option) (*DeleteRegistrationCodeOutput, error) {
	req, out := c.DeleteRegistrationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoleAlias = "DeleteRoleAlias"

// DeleteRoleAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoleAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoleAlias for more information on using the DeleteRoleAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRoleAliasRequest method.
//    req, resp := client.DeleteRoleAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteRoleAliasRequest(input *DeleteRoleAliasInput) (req *request.Request, output *DeleteRoleAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteRoleAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/role-aliases/{roleAlias}",
	}

	if input == nil {
		input = &DeleteRoleAliasInput{}
	}

	output = &DeleteRoleAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoleAlias API operation for AWS IoT.
//
// Deletes a role alias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteRoleAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeleteConflictException "DeleteConflictException"
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DeleteRoleAlias(input *DeleteRoleAliasInput) (*DeleteRoleAliasOutput, error) {
	req, out := c.DeleteRoleAliasRequest(input)
	return out, req.Send()
}

// DeleteRoleAliasWithContext is the same as DeleteRoleAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoleAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteRoleAliasWithContext(ctx aws.Context, input *DeleteRoleAliasInput, opts ...request.Option) (*DeleteRoleAliasOutput, error) {
	req, out := c.DeleteRoleAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScheduledAudit = "DeleteScheduledAudit"

// DeleteScheduledAuditRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduledAudit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScheduledAudit for more information on using the DeleteScheduledAudit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScheduledAuditRequest method.
//    req, resp := client.DeleteScheduledAuditRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteScheduledAuditRequest(input *DeleteScheduledAuditInput) (req *request.Request, output *DeleteScheduledAuditOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledAudit,
		HTTPMethod: "DELETE",
		HTTPPath:   "/audit/scheduledaudits/{scheduledAuditName}",
	}

	if input == nil {
		input = &DeleteScheduledAuditInput{}
	}

	output = &DeleteScheduledAuditOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScheduledAudit API operation for AWS IoT.
//
// Deletes a scheduled audit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteScheduledAudit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteScheduledAudit(input *DeleteScheduledAuditInput) (*DeleteScheduledAuditOutput, error) {
	req, out := c.DeleteScheduledAuditRequest(input)
	return out, req.Send()
}

// DeleteScheduledAuditWithContext is the same as DeleteScheduledAudit with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScheduledAudit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteScheduledAuditWithContext(ctx aws.Context, input *DeleteScheduledAuditInput, opts ...request.Option) (*DeleteScheduledAuditOutput, error) {
	req, out := c.DeleteScheduledAuditRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecurityProfile = "DeleteSecurityProfile"

// DeleteSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecurityProfile for more information on using the DeleteSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSecurityProfileRequest method.
//    req, resp := client.DeleteSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteSecurityProfileRequest(input *DeleteSecurityProfileInput) (req *request.Request, output *DeleteSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/security-profiles/{securityProfileName}",
	}

	if input == nil {
		input = &DeleteSecurityProfileInput{}
	}

	output = &DeleteSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityProfile API operation for AWS IoT.
//
// Deletes a Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteSecurityProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
func (c *IoT) DeleteSecurityProfile(input *DeleteSecurityProfileInput) (*DeleteSecurityProfileOutput, error) {
	req, out := c.DeleteSecurityProfileRequest(input)
	return out, req.Send()
}

// DeleteSecurityProfileWithContext is the same as DeleteSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteSecurityProfileWithContext(ctx aws.Context, input *DeleteSecurityProfileInput, opts ...request.Option) (*DeleteSecurityProfileOutput, error) {
	req, out := c.DeleteSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStream = "DeleteStream"

// DeleteStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStream for more information on using the DeleteStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStreamRequest method.
//    req, resp := client.DeleteStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteStreamRequest(input *DeleteStreamInput) (req *request.Request, output *DeleteStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &DeleteStreamInput{}
	}

	output = &DeleteStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStream API operation for AWS IoT.
//
// Deletes a stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeDeleteConflictException "DeleteConflictException"
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteStream(input *DeleteStreamInput) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	return out, req.Send()
}

// DeleteStreamWithContext is the same as DeleteStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteStreamWithContext(ctx aws.Context, input *DeleteStreamInput, opts ...request.Option) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThing = "DeleteThing"

// DeleteThingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThing for more information on using the DeleteThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThingRequest method.
//    req, resp := client.DeleteThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteThingRequest(input *DeleteThingInput) (req *request.Request, output *DeleteThingOutput) {
	op := &request.Operation{
		Name:       opDeleteThing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &DeleteThingInput{}
	}

	output = &DeleteThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteThing API operation for AWS IoT.
//
// Deletes the specified thing. Returns successfully with no error if the deletion
// is successful or you specify a thing that doesn't exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteThing(input *DeleteThingInput) (*DeleteThingOutput, error) {
	req, out := c.DeleteThingRequest(input)
	return out, req.Send()
}

// DeleteThingWithContext is the same as DeleteThing with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteThingWithContext(ctx aws.Context, input *DeleteThingInput, opts ...request.Option) (*DeleteThingOutput, error) {
	req, out := c.DeleteThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThingGroup = "DeleteThingGroup"

// DeleteThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThingGroup for more information on using the DeleteThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThingGroupRequest method.
//    req, resp := client.DeleteThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteThingGroupRequest(input *DeleteThingGroupInput) (req *request.Request, output *DeleteThingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteThingGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &DeleteThingGroupInput{}
	}

	output = &DeleteThingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteThingGroup API operation for AWS IoT.
//
// Deletes a thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteThingGroup(input *DeleteThingGroupInput) (*DeleteThingGroupOutput, error) {
	req, out := c.DeleteThingGroupRequest(input)
	return out, req.Send()
}

// DeleteThingGroupWithContext is the same as DeleteThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteThingGroupWithContext(ctx aws.Context, input *DeleteThingGroupInput, opts ...request.Option) (*DeleteThingGroupOutput, error) {
	req, out := c.DeleteThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThingType = "DeleteThingType"

// DeleteThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThingType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThingType for more information on using the DeleteThingType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThingTypeRequest method.
//    req, resp := client.DeleteThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteThingTypeRequest(input *DeleteThingTypeInput) (req *request.Request, output *DeleteThingTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteThingType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/thing-types/{thingTypeName}",
	}

	if input == nil {
		input = &DeleteThingTypeInput{}
	}

	output = &DeleteThingTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteThingType API operation for AWS IoT.
//
// Deletes the specified thing type. You cannot delete a thing type if it has
// things associated with it. To delete a thing type, first mark it as deprecated
// by calling DeprecateThingType, then remove any associated things by calling
// UpdateThing to change the thing type on any associated thing, and finally
// use DeleteThingType to delete the thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteThingType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteThingType(input *DeleteThingTypeInput) (*DeleteThingTypeOutput, error) {
	req, out := c.DeleteThingTypeRequest(input)
	return out, req.Send()
}

// DeleteThingTypeWithContext is the same as DeleteThingType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteThingTypeWithContext(ctx aws.Context, input *DeleteThingTypeInput, opts ...request.Option) (*DeleteThingTypeOutput, error) {
	req, out := c.DeleteThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTopicRule = "DeleteTopicRule"

// DeleteTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTopicRule for more information on using the DeleteTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTopicRuleRequest method.
//    req, resp := client.DeleteTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteTopicRuleRequest(input *DeleteTopicRuleInput) (req *request.Request, output *DeleteTopicRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteTopicRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &DeleteTopicRuleInput{}
	}

	output = &DeleteTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTopicRule API operation for AWS IoT.
//
// Deletes the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeConflictingResourceUpdateException "ConflictingResourceUpdateException"
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) DeleteTopicRule(input *DeleteTopicRuleInput) (*DeleteTopicRuleOutput, error) {
	req, out := c.DeleteTopicRuleRequest(input)
	return out, req.Send()
}

// DeleteTopicRuleWithContext is the same as DeleteTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteTopicRuleWithContext(ctx aws.Context, input *DeleteTopicRuleInput, opts ...request.Option) (*DeleteTopicRuleOutput, error) {
	req, out := c.DeleteTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteV2LoggingLevel = "DeleteV2LoggingLevel"

// DeleteV2LoggingLevelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteV2LoggingLevel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteV2LoggingLevel for more information on using the DeleteV2LoggingLevel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteV2LoggingLevelRequest method.
//    req, resp := client.DeleteV2LoggingLevelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteV2LoggingLevelRequest(input *DeleteV2LoggingLevelInput) (req *request.Request, output *DeleteV2LoggingLevelOutput) {
	op := &request.Operation{
		Name:       opDeleteV2LoggingLevel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2LoggingLevel",
	}

	if input == nil {
		input = &DeleteV2LoggingLevelInput{}
	}

	output = &DeleteV2LoggingLevelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteV2LoggingLevel API operation for AWS IoT.
//
// Deletes a logging level.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteV2LoggingLevel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) DeleteV2LoggingLevel(input *DeleteV2LoggingLevelInput) (*DeleteV2LoggingLevelOutput, error) {
	req, out := c.DeleteV2LoggingLevelRequest(input)
	return out, req.Send()
}

// DeleteV2LoggingLevelWithContext is the same as DeleteV2LoggingLevel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteV2LoggingLevel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteV2LoggingLevelWithContext(ctx aws.Context, input *DeleteV2LoggingLevelInput, opts ...request.Option) (*DeleteV2LoggingLevelOutput, error) {
	req, out := c.DeleteV2LoggingLevelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprecateThingType = "DeprecateThingType"

// DeprecateThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeprecateThingType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprecateThingType for more information on using the DeprecateThingType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeprecateThingTypeRequest method.
//    req, resp := client.DeprecateThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeprecateThingTypeRequest(input *DeprecateThingTypeInput) (req *request.Request, output *DeprecateThingTypeOutput) {
	op := &request.Operation{
		Name:       opDeprecateThingType,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-types/{thingTypeName}/deprecate",
	}

	if input == nil {
		input = &DeprecateThingTypeInput{}
	}

	output = &DeprecateThingTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeprecateThingType API operation for AWS IoT.
//
// Deprecates a thing type. You can not associate new things with deprecated
// thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeprecateThingType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeprecateThingType(input *DeprecateThingTypeInput) (*DeprecateThingTypeOutput, error) {
	req, out := c.DeprecateThingTypeRequest(input)
	return out, req.Send()
}

// DeprecateThingTypeWithContext is the same as DeprecateThingType with the addition of
// the ability to pass a context and additional request options.
//
// See DeprecateThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeprecateThingTypeWithContext(ctx aws.Context, input *DeprecateThingTypeInput, opts ...request.Option) (*DeprecateThingTypeOutput, error) {
	req, out := c.DeprecateThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAuditConfiguration = "DescribeAccountAuditConfiguration"

// DescribeAccountAuditConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAuditConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAuditConfiguration for more information on using the DescribeAccountAuditConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAuditConfigurationRequest method.
//    req, resp := client.DescribeAccountAuditConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeAccountAuditConfigurationRequest(input *DescribeAccountAuditConfigurationInput) (req *request.Request, output *DescribeAccountAuditConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAuditConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/configuration",
	}

	if input == nil {
		input = &DescribeAccountAuditConfigurationInput{}
	}

	output = &DescribeAccountAuditConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAuditConfiguration API operation for AWS IoT.
//
// Gets information about the Device Defender audit settings for this account.
// Settings include how audit notifications are sent and which audit checks
// are enabled or disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeAccountAuditConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeAccountAuditConfiguration(input *DescribeAccountAuditConfigurationInput) (*DescribeAccountAuditConfigurationOutput, error) {
	req, out := c.DescribeAccountAuditConfigurationRequest(input)
	return out, req.Send()
}

// DescribeAccountAuditConfigurationWithContext is the same as DescribeAccountAuditConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAuditConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeAccountAuditConfigurationWithContext(ctx aws.Context, input *DescribeAccountAuditConfigurationInput, opts ...request.Option) (*DescribeAccountAuditConfigurationOutput, error) {
	req, out := c.DescribeAccountAuditConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAuditTask = "DescribeAuditTask"

// DescribeAuditTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAuditTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAuditTask for more information on using the DescribeAuditTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAuditTaskRequest method.
//    req, resp := client.DescribeAuditTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeAuditTaskRequest(input *DescribeAuditTaskInput) (req *request.Request, output *DescribeAuditTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeAuditTask,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/tasks/{taskId}",
	}

	if input == nil {
		input = &DescribeAuditTaskInput{}
	}

	output = &DescribeAuditTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAuditTask API operation for AWS IoT.
//
// Gets information about a Device Defender audit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeAuditTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeAuditTask(input *DescribeAuditTaskInput) (*DescribeAuditTaskOutput, error) {
	req, out := c.DescribeAuditTaskRequest(input)
	return out, req.Send()
}

// DescribeAuditTaskWithContext is the same as DescribeAuditTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAuditTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeAuditTaskWithContext(ctx aws.Context, input *DescribeAuditTaskInput, opts ...request.Option) (*DescribeAuditTaskOutput, error) {
	req, out := c.DescribeAuditTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAuthorizer = "DescribeAuthorizer"

// DescribeAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAuthorizer for more information on using the DescribeAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAuthorizerRequest method.
//    req, resp := client.DescribeAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeAuthorizerRequest(input *DescribeAuthorizerInput) (req *request.Request, output *DescribeAuthorizerOutput) {
	op := &request.Operation{
		Name:       opDescribeAuthorizer,
		HTTPMethod: "GET",
		HTTPPath:   "/authorizer/{authorizerName}",
	}

	if input == nil {
		input = &DescribeAuthorizerInput{}
	}

	output = &DescribeAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAuthorizer API operation for AWS IoT.
//
// Describes an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeAuthorizer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeAuthorizer(input *DescribeAuthorizerInput) (*DescribeAuthorizerOutput, error) {
	req, out := c.DescribeAuthorizerRequest(input)
	return out, req.Send()
}

// DescribeAuthorizerWithContext is the same as DescribeAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeAuthorizerWithContext(ctx aws.Context, input *DescribeAuthorizerInput, opts ...request.Option) (*DescribeAuthorizerOutput, error) {
	req, out := c.DescribeAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBillingGroup = "DescribeBillingGroup"

// DescribeBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBillingGroup for more information on using the DescribeBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBillingGroupRequest method.
//    req, resp := client.DescribeBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeBillingGroupRequest(input *DescribeBillingGroupInput) (req *request.Request, output *DescribeBillingGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeBillingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/billing-groups/{billingGroupName}",
	}

	if input == nil {
		input = &DescribeBillingGroupInput{}
	}

	output = &DescribeBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBillingGroup API operation for AWS IoT.
//
// Returns information about a billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeBillingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DescribeBillingGroup(input *DescribeBillingGroupInput) (*DescribeBillingGroupOutput, error) {
	req, out := c.DescribeBillingGroupRequest(input)
	return out, req.Send()
}

// DescribeBillingGroupWithContext is the same as DescribeBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeBillingGroupWithContext(ctx aws.Context, input *DescribeBillingGroupInput, opts ...request.Option) (*DescribeBillingGroupOutput, error) {
	req, out := c.DescribeBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCACertificate = "DescribeCACertificate"

// DescribeCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCACertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCACertificate for more information on using the DescribeCACertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCACertificateRequest method.
//    req, resp := client.DescribeCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeCACertificateRequest(input *DescribeCACertificateInput) (req *request.Request, output *DescribeCACertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCACertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &DescribeCACertificateInput{}
	}

	output = &DescribeCACertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCACertificate API operation for AWS IoT.
//
// Describes a registered CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeCACertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DescribeCACertificate(input *DescribeCACertificateInput) (*DescribeCACertificateOutput, error) {
	req, out := c.DescribeCACertificateRequest(input)
	return out, req.Send()
}

// DescribeCACertificateWithContext is the same as DescribeCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeCACertificateWithContext(ctx aws.Context, input *DescribeCACertificateInput, opts ...request.Option) (*DescribeCACertificateOutput, error) {
	req, out := c.DescribeCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificate = "DescribeCertificate"

// DescribeCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificate for more information on using the DescribeCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificateRequest method.
//    req, resp := client.DescribeCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeCertificateRequest(input *DescribeCertificateInput) (req *request.Request, output *DescribeCertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &DescribeCertificateInput{}
	}

	output = &DescribeCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificate API operation for AWS IoT.
//
// Gets information about the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DescribeCertificate(input *DescribeCertificateInput) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	return out, req.Send()
}

// DescribeCertificateWithContext is the same as DescribeCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeCertificateWithContext(ctx aws.Context, input *DescribeCertificateInput, opts ...request.Option) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDefaultAuthorizer = "DescribeDefaultAuthorizer"

// DescribeDefaultAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDefaultAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDefaultAuthorizer for more information on using the DescribeDefaultAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDefaultAuthorizerRequest method.
//    req, resp := client.DescribeDefaultAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeDefaultAuthorizerRequest(input *DescribeDefaultAuthorizerInput) (req *request.Request, output *DescribeDefaultAuthorizerOutput) {
	op := &request.Operation{
		Name:       opDescribeDefaultAuthorizer,
		HTTPMethod: "GET",
		HTTPPath:   "/default-authorizer",
	}

	if input == nil {
		input = &DescribeDefaultAuthorizerInput{}
	}

	output = &DescribeDefaultAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDefaultAuthorizer API operation for AWS IoT.
//
// Describes the default authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeDefaultAuthorizer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeDefaultAuthorizer(input *DescribeDefaultAuthorizerInput) (*DescribeDefaultAuthorizerOutput, error) {
	req, out := c.DescribeDefaultAuthorizerRequest(input)
	return out, req.Send()
}

// DescribeDefaultAuthorizerWithContext is the same as DescribeDefaultAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDefaultAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeDefaultAuthorizerWithContext(ctx aws.Context, input *DescribeDefaultAuthorizerInput, opts ...request.Option) (*DescribeDefaultAuthorizerOutput, error) {
	req, out := c.DescribeDefaultAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoint for more information on using the DescribeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointRequest method.
//    req, resp := client.DescribeEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/endpoint",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	output = &DescribeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoint API operation for AWS IoT.
//
// Returns a unique endpoint specific to the AWS account making the call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
func (c *IoT) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	return out, req.Send()
}

// DescribeEndpointWithContext is the same as DescribeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeEndpointWithContext(ctx aws.Context, input *DescribeEndpointInput, opts ...request.Option) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventConfigurations = "DescribeEventConfigurations"

// DescribeEventConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventConfigurations for more information on using the DescribeEventConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventConfigurationsRequest method.
//    req, resp := client.DescribeEventConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeEventConfigurationsRequest(input *DescribeEventConfigurationsInput) (req *request.Request, output *DescribeEventConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/event-configurations",
	}

	if input == nil {
		input = &DescribeEventConfigurationsInput{}
	}

	output = &DescribeEventConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventConfigurations API operation for AWS IoT.
//
// Describes event configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeEventConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
func (c *IoT) DescribeEventConfigurations(input *DescribeEventConfigurationsInput) (*DescribeEventConfigurationsOutput, error) {
	req, out := c.DescribeEventConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeEventConfigurationsWithContext is the same as DescribeEventConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeEventConfigurationsWithContext(ctx aws.Context, input *DescribeEventConfigurationsInput, opts ...request.Option) (*DescribeEventConfigurationsOutput, error) {
	req, out := c.DescribeEventConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIndex = "DescribeIndex"

// DescribeIndexRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIndex for more information on using the DescribeIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIndexRequest method.
//    req, resp := client.DescribeIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeIndexRequest(input *DescribeIndexInput) (req *request.Request, output *DescribeIndexOutput) {
	op := &request.Operation{
		Name:       opDescribeIndex,
		HTTPMethod: "GET",
		HTTPPath:   "/indices/{indexName}",
	}

	if input == nil {
		input = &DescribeIndexInput{}
	}

	output = &DescribeIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIndex API operation for AWS IoT.
//
// Describes a search index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeIndex for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DescribeIndex(input *DescribeIndexInput) (*DescribeIndexOutput, error) {
	req, out := c.DescribeIndexRequest(input)
	return out, req.Send()
}

// DescribeIndexWithContext is the same as DescribeIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeIndexWithContext(ctx aws.Context, input *DescribeIndexInput, opts ...request.Option) (*DescribeIndexOutput, error) {
	req, out := c.DescribeIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJob for more information on using the DescribeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobRequest method.
//    req, resp := client.DescribeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *DescribeJobOutput) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	output = &DescribeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJob API operation for AWS IoT.
//
// Describes a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) DescribeJob(input *DescribeJobInput) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	return out, req.Send()
}

// DescribeJobWithContext is the same as DescribeJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeJobWithContext(ctx aws.Context, input *DescribeJobInput, opts ...request.Option) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobExecution = "DescribeJobExecution"

// DescribeJobExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobExecution for more information on using the DescribeJobExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobExecutionRequest method.
//    req, resp := client.DescribeJobExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeJobExecutionRequest(input *DescribeJobExecutionInput) (req *request.Request, output *DescribeJobExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeJobExecution,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeJobExecutionInput{}
	}

	output = &DescribeJobExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobExecution API operation for AWS IoT.
//
// Describes a job execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeJobExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) DescribeJobExecution(input *DescribeJobExecutionInput) (*DescribeJobExecutionOutput, error) {
	req, out := c.DescribeJobExecutionRequest(input)
	return out, req.Send()
}

// DescribeJobExecutionWithContext is the same as DescribeJobExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeJobExecutionWithContext(ctx aws.Context, input *DescribeJobExecutionInput, opts ...request.Option) (*DescribeJobExecutionOutput, error) {
	req, out := c.DescribeJobExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRoleAlias = "DescribeRoleAlias"

// DescribeRoleAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRoleAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRoleAlias for more information on using the DescribeRoleAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRoleAliasRequest method.
//    req, resp := client.DescribeRoleAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeRoleAliasRequest(input *DescribeRoleAliasInput) (req *request.Request, output *DescribeRoleAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeRoleAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/role-aliases/{roleAlias}",
	}

	if input == nil {
		input = &DescribeRoleAliasInput{}
	}

	output = &DescribeRoleAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRoleAlias API operation for AWS IoT.
//
// Describes a role alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeRoleAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DescribeRoleAlias(input *DescribeRoleAliasInput) (*DescribeRoleAliasOutput, error) {
	req, out := c.DescribeRoleAliasRequest(input)
	return out, req.Send()
}

// DescribeRoleAliasWithContext is the same as DescribeRoleAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRoleAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeRoleAliasWithContext(ctx aws.Context, input *DescribeRoleAliasInput, opts ...request.Option) (*DescribeRoleAliasOutput, error) {
	req, out := c.DescribeRoleAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScheduledAudit = "DescribeScheduledAudit"

// DescribeScheduledAuditRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledAudit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScheduledAudit for more information on using the DescribeScheduledAudit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduledAuditRequest method.
//    req, resp := client.DescribeScheduledAuditRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeScheduledAuditRequest(input *DescribeScheduledAuditInput) (req *request.Request, output *DescribeScheduledAuditOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledAudit,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/scheduledaudits/{scheduledAuditName}",
	}

	if input == nil {
		input = &DescribeScheduledAuditInput{}
	}

	output = &DescribeScheduledAuditOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledAudit API operation for AWS IoT.
//
// Gets information about a scheduled audit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeScheduledAudit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeScheduledAudit(input *DescribeScheduledAuditInput) (*DescribeScheduledAuditOutput, error) {
	req, out := c.DescribeScheduledAuditRequest(input)
	return out, req.Send()
}

// DescribeScheduledAuditWithContext is the same as DescribeScheduledAudit with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScheduledAudit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeScheduledAuditWithContext(ctx aws.Context, input *DescribeScheduledAuditInput, opts ...request.Option) (*DescribeScheduledAuditOutput, error) {
	req, out := c.DescribeScheduledAuditRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecurityProfile = "DescribeSecurityProfile"

// DescribeSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSecurityProfile for more information on using the DescribeSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSecurityProfileRequest method.
//    req, resp := client.DescribeSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeSecurityProfileRequest(input *DescribeSecurityProfileInput) (req *request.Request, output *DescribeSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles/{securityProfileName}",
	}

	if input == nil {
		input = &DescribeSecurityProfileInput{}
	}

	output = &DescribeSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecurityProfile API operation for AWS IoT.
//
// Gets information about a Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeSecurityProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeSecurityProfile(input *DescribeSecurityProfileInput) (*DescribeSecurityProfileOutput, error) {
	req, out := c.DescribeSecurityProfileRequest(input)
	return out, req.Send()
}

// DescribeSecurityProfileWithContext is the same as DescribeSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeSecurityProfileWithContext(ctx aws.Context, input *DescribeSecurityProfileInput, opts ...request.Option) (*DescribeSecurityProfileOutput, error) {
	req, out := c.DescribeSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStream = "DescribeStream"

// DescribeStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStream for more information on using the DescribeStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStreamRequest method.
//    req, resp := client.DescribeStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeStreamRequest(input *DescribeStreamInput) (req *request.Request, output *DescribeStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeStream,
		HTTPMethod: "GET",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &DescribeStreamInput{}
	}

	output = &DescribeStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStream API operation for AWS IoT.
//
// Gets information about a stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeStream(input *DescribeStreamInput) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	return out, req.Send()
}

// DescribeStreamWithContext is the same as DescribeStream with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeStreamWithContext(ctx aws.Context, input *DescribeStreamInput, opts ...request.Option) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThing = "DescribeThing"

// DescribeThingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThing for more information on using the DescribeThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThingRequest method.
//    req, resp := client.DescribeThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingRequest(input *DescribeThingInput) (req *request.Request, output *DescribeThingOutput) {
	op := &request.Operation{
		Name:       opDescribeThing,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &DescribeThingInput{}
	}

	output = &DescribeThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThing API operation for AWS IoT.
//
// Gets information about the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeThing(input *DescribeThingInput) (*DescribeThingOutput, error) {
	req, out := c.DescribeThingRequest(input)
	return out, req.Send()
}

// DescribeThingWithContext is the same as DescribeThing with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingWithContext(ctx aws.Context, input *DescribeThingInput, opts ...request.Option) (*DescribeThingOutput, error) {
	req, out := c.DescribeThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThingGroup = "DescribeThingGroup"

// DescribeThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThingGroup for more information on using the DescribeThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThingGroupRequest method.
//    req, resp := client.DescribeThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingGroupRequest(input *DescribeThingGroupInput) (req *request.Request, output *DescribeThingGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeThingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &DescribeThingGroupInput{}
	}

	output = &DescribeThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThingGroup API operation for AWS IoT.
//
// Describe a thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DescribeThingGroup(input *DescribeThingGroupInput) (*DescribeThingGroupOutput, error) {
	req, out := c.DescribeThingGroupRequest(input)
	return out, req.Send()
}

// DescribeThingGroupWithContext is the same as DescribeThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingGroupWithContext(ctx aws.Context, input *DescribeThingGroupInput, opts ...request.Option) (*DescribeThingGroupOutput, error) {
	req, out := c.DescribeThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThingRegistrationTask = "DescribeThingRegistrationTask"

// DescribeThingRegistrationTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThingRegistrationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThingRegistrationTask for more information on using the DescribeThingRegistrationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThingRegistrationTaskRequest method.
//    req, resp := client.DescribeThingRegistrationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingRegistrationTaskRequest(input *DescribeThingRegistrationTaskInput) (req *request.Request, output *DescribeThingRegistrationTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeThingRegistrationTask,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-registration-tasks/{taskId}",
	}

	if input == nil {
		input = &DescribeThingRegistrationTaskInput{}
	}

	output = &DescribeThingRegistrationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThingRegistrationTask API operation for AWS IoT.
//
// Describes a bulk thing provisioning task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThingRegistrationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DescribeThingRegistrationTask(input *DescribeThingRegistrationTaskInput) (*DescribeThingRegistrationTaskOutput, error) {
	req, out := c.DescribeThingRegistrationTaskRequest(input)
	return out, req.Send()
}

// DescribeThingRegistrationTaskWithContext is the same as DescribeThingRegistrationTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThingRegistrationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingRegistrationTaskWithContext(ctx aws.Context, input *DescribeThingRegistrationTaskInput, opts ...request.Option) (*DescribeThingRegistrationTaskOutput, error) {
	req, out := c.DescribeThingRegistrationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThingType = "DescribeThingType"

// DescribeThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThingType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThingType for more information on using the DescribeThingType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThingTypeRequest method.
//    req, resp := client.DescribeThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingTypeRequest(input *DescribeThingTypeInput) (req *request.Request, output *DescribeThingTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeThingType,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-types/{thingTypeName}",
	}

	if input == nil {
		input = &DescribeThingTypeInput{}
	}

	output = &DescribeThingTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThingType API operation for AWS IoT.
//
// Gets information about the specified thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThingType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeThingType(input *DescribeThingTypeInput) (*DescribeThingTypeOutput, error) {
	req, out := c.DescribeThingTypeRequest(input)
	return out, req.Send()
}

// DescribeThingTypeWithContext is the same as DescribeThingType with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingTypeWithContext(ctx aws.Context, input *DescribeThingTypeInput, opts ...request.Option) (*DescribeThingTypeOutput, error) {
	req, out := c.DescribeThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachPolicy = "DetachPolicy"

// DetachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachPolicy for more information on using the DetachPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachPolicyRequest method.
//    req, resp := client.DetachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DetachPolicyRequest(input *DetachPolicyInput) (req *request.Request, output *DetachPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/target-policies/{policyName}",
	}

	if input == nil {
		input = &DetachPolicyInput{}
	}

	output = &DetachPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachPolicy API operation for AWS IoT.
//
// Detaches a policy from the specified target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) DetachPolicy(input *DetachPolicyInput) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	return out, req.Send()
}

// DetachPolicyWithContext is the same as DetachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DetachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DetachPolicyWithContext(ctx aws.Context, input *DetachPolicyInput, opts ...request.Option) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachPrincipalPolicy = "DetachPrincipalPolicy"

// DetachPrincipalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachPrincipalPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachPrincipalPolicy for more information on using the DetachPrincipalPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachPrincipalPolicyRequest method.
//    req, resp := client.DetachPrincipalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Deprecated: DetachPrincipalPolicy has been deprecated
func (c *IoT) DetachPrincipalPolicyRequest(input *DetachPrincipalPolicyInput) (req *request.Request, output *DetachPrincipalPolicyOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DetachPrincipalPolicy, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDetachPrincipalPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/principal-policies/{policyName}",
	}

	if input == nil {
		input = &DetachPrincipalPolicyInput{}
	}

	output = &DetachPrincipalPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachPrincipalPolicy API operation for AWS IoT.
//
// Removes the specified policy from the specified certificate.
//
// Note: This API is deprecated. Please use DetachPolicy instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachPrincipalPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//
// Deprecated: DetachPrincipalPolicy has been deprecated
func (c *IoT) DetachPrincipalPolicy(input *DetachPrincipalPolicyInput) (*DetachPrincipalPolicyOutput, error) {
	req, out := c.DetachPrincipalPolicyRequest(input)
	return out, req.Send()
}

// DetachPrincipalPolicyWithContext is the same as DetachPrincipalPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DetachPrincipalPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: DetachPrincipalPolicyWithContext has been deprecated
func (c *IoT) DetachPrincipalPolicyWithContext(ctx aws.Context, input *DetachPrincipalPolicyInput, opts ...request.Option) (*DetachPrincipalPolicyOutput, error) {
	req, out := c.DetachPrincipalPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachSecurityProfile = "DetachSecurityProfile"

// DetachSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the DetachSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachSecurityProfile for more information on using the DetachSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachSecurityProfileRequest method.
//    req, resp := client.DetachSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DetachSecurityProfileRequest(input *DetachSecurityProfileInput) (req *request.Request, output *DetachSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opDetachSecurityProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/security-profiles/{securityProfileName}/targets",
	}

	if input == nil {
		input = &DetachSecurityProfileInput{}
	}

	output = &DetachSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachSecurityProfile API operation for AWS IoT.
//
// Disassociates a Device Defender security profile from a thing group or from
// this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachSecurityProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DetachSecurityProfile(input *DetachSecurityProfileInput) (*DetachSecurityProfileOutput, error) {
	req, out := c.DetachSecurityProfileRequest(input)
	return out, req.Send()
}

// DetachSecurityProfileWithContext is the same as DetachSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DetachSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DetachSecurityProfileWithContext(ctx aws.Context, input *DetachSecurityProfileInput, opts ...request.Option) (*DetachSecurityProfileOutput, error) {
	req, out := c.DetachSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachThingPrincipal = "DetachThingPrincipal"

// DetachThingPrincipalRequest generates a "aws/request.Request" representing the
// client's request for the DetachThingPrincipal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachThingPrincipal for more information on using the DetachThingPrincipal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachThingPrincipalRequest method.
//    req, resp := client.DetachThingPrincipalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DetachThingPrincipalRequest(input *DetachThingPrincipalInput) (req *request.Request, output *DetachThingPrincipalOutput) {
	op := &request.Operation{
		Name:       opDetachThingPrincipal,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &DetachThingPrincipalInput{}
	}

	output = &DetachThingPrincipalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachThingPrincipal API operation for AWS IoT.
//
// Detaches the specified principal from the specified thing.
//
// This call is asynchronous. It might take several seconds for the detachment
// to propagate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachThingPrincipal for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DetachThingPrincipal(input *DetachThingPrincipalInput) (*DetachThingPrincipalOutput, error) {
	req, out := c.DetachThingPrincipalRequest(input)
	return out, req.Send()
}

// DetachThingPrincipalWithContext is the same as DetachThingPrincipal with the addition of
// the ability to pass a context and additional request options.
//
// See DetachThingPrincipal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DetachThingPrincipalWithContext(ctx aws.Context, input *DetachThingPrincipalInput, opts ...request.Option) (*DetachThingPrincipalOutput, error) {
	req, out := c.DetachThingPrincipalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableTopicRule = "DisableTopicRule"

// DisableTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisableTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableTopicRule for more information on using the DisableTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableTopicRuleRequest method.
//    req, resp := client.DisableTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DisableTopicRuleRequest(input *DisableTopicRuleInput) (req *request.Request, output *DisableTopicRuleOutput) {
	op := &request.Operation{
		Name:       opDisableTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}/disable",
	}

	if input == nil {
		input = &DisableTopicRuleInput{}
	}

	output = &DisableTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableTopicRule API operation for AWS IoT.
//
// Disables the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DisableTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeConflictingResourceUpdateException "ConflictingResourceUpdateException"
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) DisableTopicRule(input *DisableTopicRuleInput) (*DisableTopicRuleOutput, error) {
	req, out := c.DisableTopicRuleRequest(input)
	return out, req.Send()
}

// DisableTopicRuleWithContext is the same as DisableTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See DisableTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DisableTopicRuleWithContext(ctx aws.Context, input *DisableTopicRuleInput, opts ...request.Option) (*DisableTopicRuleOutput, error) {
	req, out := c.DisableTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableTopicRule = "EnableTopicRule"

// EnableTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the EnableTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableTopicRule for more information on using the EnableTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableTopicRuleRequest method.
//    req, resp := client.EnableTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) EnableTopicRuleRequest(input *EnableTopicRuleInput) (req *request.Request, output *EnableTopicRuleOutput) {
	op := &request.Operation{
		Name:       opEnableTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}/enable",
	}

	if input == nil {
		input = &EnableTopicRuleInput{}
	}

	output = &EnableTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableTopicRule API operation for AWS IoT.
//
// Enables the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation EnableTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeConflictingResourceUpdateException "ConflictingResourceUpdateException"
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) EnableTopicRule(input *EnableTopicRuleInput) (*EnableTopicRuleOutput, error) {
	req, out := c.EnableTopicRuleRequest(input)
	return out, req.Send()
}

// EnableTopicRuleWithContext is the same as EnableTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See EnableTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) EnableTopicRuleWithContext(ctx aws.Context, input *EnableTopicRuleInput, opts ...request.Option) (*EnableTopicRuleOutput, error) {
	req, out := c.EnableTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEffectivePolicies = "GetEffectivePolicies"

// GetEffectivePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetEffectivePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEffectivePolicies for more information on using the GetEffectivePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEffectivePoliciesRequest method.
//    req, resp := client.GetEffectivePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetEffectivePoliciesRequest(input *GetEffectivePoliciesInput) (req *request.Request, output *GetEffectivePoliciesOutput) {
	op := &request.Operation{
		Name:       opGetEffectivePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/effective-policies",
	}

	if input == nil {
		input = &GetEffectivePoliciesInput{}
	}

	output = &GetEffectivePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEffectivePolicies API operation for AWS IoT.
//
// Gets a list of the policies that have an effect on the authorization behavior
// of the specified device when it connects to the AWS IoT device gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetEffectivePolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) GetEffectivePolicies(input *GetEffectivePoliciesInput) (*GetEffectivePoliciesOutput, error) {
	req, out := c.GetEffectivePoliciesRequest(input)
	return out, req.Send()
}

// GetEffectivePoliciesWithContext is the same as GetEffectivePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetEffectivePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetEffectivePoliciesWithContext(ctx aws.Context, input *GetEffectivePoliciesInput, opts ...request.Option) (*GetEffectivePoliciesOutput, error) {
	req, out := c.GetEffectivePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIndexingConfiguration = "GetIndexingConfiguration"

// GetIndexingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetIndexingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIndexingConfiguration for more information on using the GetIndexingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIndexingConfigurationRequest method.
//    req, resp := client.GetIndexingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetIndexingConfigurationRequest(input *GetIndexingConfigurationInput) (req *request.Request, output *GetIndexingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetIndexingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/indexing/config",
	}

	if input == nil {
		input = &GetIndexingConfigurationInput{}
	}

	output = &GetIndexingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIndexingConfiguration API operation for AWS IoT.
//
// Gets the search configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetIndexingConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) GetIndexingConfiguration(input *GetIndexingConfigurationInput) (*GetIndexingConfigurationOutput, error) {
	req, out := c.GetIndexingConfigurationRequest(input)
	return out, req.Send()
}

// GetIndexingConfigurationWithContext is the same as GetIndexingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetIndexingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetIndexingConfigurationWithContext(ctx aws.Context, input *GetIndexingConfigurationInput, opts ...request.Option) (*GetIndexingConfigurationOutput, error) {
	req, out := c.GetIndexingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobDocument = "GetJobDocument"

// GetJobDocumentRequest generates a "aws/request.Request" representing the
// client's request for the GetJobDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobDocument for more information on using the GetJobDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobDocumentRequest method.
//    req, resp := client.GetJobDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetJobDocumentRequest(input *GetJobDocumentInput) (req *request.Request, output *GetJobDocumentOutput) {
	op := &request.Operation{
		Name:       opGetJobDocument,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{jobId}/job-document",
	}

	if input == nil {
		input = &GetJobDocumentInput{}
	}

	output = &GetJobDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobDocument API operation for AWS IoT.
//
// Gets a job document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetJobDocument for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) GetJobDocument(input *GetJobDocumentInput) (*GetJobDocumentOutput, error) {
	req, out := c.GetJobDocumentRequest(input)
	return out, req.Send()
}

// GetJobDocumentWithContext is the same as GetJobDocument with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetJobDocumentWithContext(ctx aws.Context, input *GetJobDocumentInput, opts ...request.Option) (*GetJobDocumentOutput, error) {
	req, out := c.GetJobDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggingOptions = "GetLoggingOptions"

// GetLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggingOptions for more information on using the GetLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoggingOptionsRequest method.
//    req, resp := client.GetLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetLoggingOptionsRequest(input *GetLoggingOptionsInput) (req *request.Request, output *GetLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opGetLoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/loggingOptions",
	}

	if input == nil {
		input = &GetLoggingOptionsInput{}
	}

	output = &GetLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggingOptions API operation for AWS IoT.
//
// Gets the logging options.
//
// NOTE: use of this command is not recommended. Use GetV2LoggingOptions instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetLoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) GetLoggingOptions(input *GetLoggingOptionsInput) (*GetLoggingOptionsOutput, error) {
	req, out := c.GetLoggingOptionsRequest(input)
	return out, req.Send()
}

// GetLoggingOptionsWithContext is the same as GetLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetLoggingOptionsWithContext(ctx aws.Context, input *GetLoggingOptionsInput, opts ...request.Option) (*GetLoggingOptionsOutput, error) {
	req, out := c.GetLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOTAUpdate = "GetOTAUpdate"

// GetOTAUpdateRequest generates a "aws/request.Request" representing the
// client's request for the GetOTAUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOTAUpdate for more information on using the GetOTAUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOTAUpdateRequest method.
//    req, resp := client.GetOTAUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetOTAUpdateRequest(input *GetOTAUpdateInput) (req *request.Request, output *GetOTAUpdateOutput) {
	op := &request.Operation{
		Name:       opGetOTAUpdate,
		HTTPMethod: "GET",
		HTTPPath:   "/otaUpdates/{otaUpdateId}",
	}

	if input == nil {
		input = &GetOTAUpdateInput{}
	}

	output = &GetOTAUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOTAUpdate API operation for AWS IoT.
//
// Gets an OTA update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetOTAUpdate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) GetOTAUpdate(input *GetOTAUpdateInput) (*GetOTAUpdateOutput, error) {
	req, out := c.GetOTAUpdateRequest(input)
	return out, req.Send()
}

// GetOTAUpdateWithContext is the same as GetOTAUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See GetOTAUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetOTAUpdateWithContext(ctx aws.Context, input *GetOTAUpdateInput, opts ...request.Option) (*GetOTAUpdateOutput, error) {
	req, out := c.GetOTAUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for AWS IoT.
//
// Gets information about the specified policy with the policy document of the
// default version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicyVersion = "GetPolicyVersion"

// GetPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicyVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicyVersion for more information on using the GetPolicyVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPolicyVersionRequest method.
//    req, resp := client.GetPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetPolicyVersionRequest(input *GetPolicyVersionInput) (req *request.Request, output *GetPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opGetPolicyVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &GetPolicyVersionInput{}
	}

	output = &GetPolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicyVersion API operation for AWS IoT.
//
// Gets information about the specified policy version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetPolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) GetPolicyVersion(input *GetPolicyVersionInput) (*GetPolicyVersionOutput, error) {
	req, out := c.GetPolicyVersionRequest(input)
	return out, req.Send()
}

// GetPolicyVersionWithContext is the same as GetPolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetPolicyVersionWithContext(ctx aws.Context, input *GetPolicyVersionInput, opts ...request.Option) (*GetPolicyVersionOutput, error) {
	req, out := c.GetPolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegistrationCode = "GetRegistrationCode"

// GetRegistrationCodeRequest generates a "aws/request.Request" representing the
// client's request for the GetRegistrationCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegistrationCode for more information on using the GetRegistrationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegistrationCodeRequest method.
//    req, resp := client.GetRegistrationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetRegistrationCodeRequest(input *GetRegistrationCodeInput) (req *request.Request, output *GetRegistrationCodeOutput) {
	op := &request.Operation{
		Name:       opGetRegistrationCode,
		HTTPMethod: "GET",
		HTTPPath:   "/registrationcode",
	}

	if input == nil {
		input = &GetRegistrationCodeInput{}
	}

	output = &GetRegistrationCodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegistrationCode API operation for AWS IoT.
//
// Gets a registration code used to register a CA certificate with AWS IoT.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetRegistrationCode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
func (c *IoT) GetRegistrationCode(input *GetRegistrationCodeInput) (*GetRegistrationCodeOutput, error) {
	req, out := c.GetRegistrationCodeRequest(input)
	return out, req.Send()
}

// GetRegistrationCodeWithContext is the same as GetRegistrationCode with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegistrationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetRegistrationCodeWithContext(ctx aws.Context, input *GetRegistrationCodeInput, opts ...request.Option) (*GetRegistrationCodeOutput, error) {
	req, out := c.GetRegistrationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTopicRule = "GetTopicRule"

// GetTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTopicRule for more information on using the GetTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTopicRuleRequest method.
//    req, resp := client.GetTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetTopicRuleRequest(input *GetTopicRuleInput) (req *request.Request, output *GetTopicRuleOutput) {
	op := &request.Operation{
		Name:       opGetTopicRule,
		HTTPMethod: "GET",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &GetTopicRuleInput{}
	}

	output = &GetTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTopicRule API operation for AWS IoT.
//
// Gets information about the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
func (c *IoT) GetTopicRule(input *GetTopicRuleInput) (*GetTopicRuleOutput, error) {
	req, out := c.GetTopicRuleRequest(input)
	return out, req.Send()
}

// GetTopicRuleWithContext is the same as GetTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetTopicRuleWithContext(ctx aws.Context, input *GetTopicRuleInput, opts ...request.Option) (*GetTopicRuleOutput, error) {
	req, out := c.GetTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetV2LoggingOptions = "GetV2LoggingOptions"

// GetV2LoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetV2LoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetV2LoggingOptions for more information on using the GetV2LoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetV2LoggingOptionsRequest method.
//    req, resp := client.GetV2LoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetV2LoggingOptionsRequest(input *GetV2LoggingOptionsInput) (req *request.Request, output *GetV2LoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opGetV2LoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/v2LoggingOptions",
	}

	if input == nil {
		input = &GetV2LoggingOptionsInput{}
	}

	output = &GetV2LoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetV2LoggingOptions API operation for AWS IoT.
//
// Gets the fine grained logging options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetV2LoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeNotConfiguredException "NotConfiguredException"
//   The resource is not configured.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) GetV2LoggingOptions(input *GetV2LoggingOptionsInput) (*GetV2LoggingOptionsOutput, error) {
	req, out := c.GetV2LoggingOptionsRequest(input)
	return out, req.Send()
}

// GetV2LoggingOptionsWithContext is the same as GetV2LoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetV2LoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetV2LoggingOptionsWithContext(ctx aws.Context, input *GetV2LoggingOptionsInput, opts ...request.Option) (*GetV2LoggingOptionsOutput, error) {
	req, out := c.GetV2LoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListActiveViolations = "ListActiveViolations"

// ListActiveViolationsRequest generates a "aws/request.Request" representing the
// client's request for the ListActiveViolations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActiveViolations for more information on using the ListActiveViolations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActiveViolationsRequest method.
//    req, resp := client.ListActiveViolationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListActiveViolationsRequest(input *ListActiveViolationsInput) (req *request.Request, output *ListActiveViolationsOutput) {
	op := &request.Operation{
		Name:       opListActiveViolations,
		HTTPMethod: "GET",
		HTTPPath:   "/active-violations",
	}

	if input == nil {
		input = &ListActiveViolationsInput{}
	}

	output = &ListActiveViolationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActiveViolations API operation for AWS IoT.
//
// Lists the active violations for a given Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListActiveViolations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListActiveViolations(input *ListActiveViolationsInput) (*ListActiveViolationsOutput, error) {
	req, out := c.ListActiveViolationsRequest(input)
	return out, req.Send()
}

// ListActiveViolationsWithContext is the same as ListActiveViolations with the addition of
// the ability to pass a context and additional request options.
//
// See ListActiveViolations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListActiveViolationsWithContext(ctx aws.Context, input *ListActiveViolationsInput, opts ...request.Option) (*ListActiveViolationsOutput, error) {
	req, out := c.ListActiveViolationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAttachedPolicies = "ListAttachedPolicies"

// ListAttachedPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttachedPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttachedPolicies for more information on using the ListAttachedPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAttachedPoliciesRequest method.
//    req, resp := client.ListAttachedPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAttachedPoliciesRequest(input *ListAttachedPoliciesInput) (req *request.Request, output *ListAttachedPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAttachedPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/attached-policies/{target}",
	}

	if input == nil {
		input = &ListAttachedPoliciesInput{}
	}

	output = &ListAttachedPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttachedPolicies API operation for AWS IoT.
//
// Lists the policies attached to the specified thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAttachedPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) ListAttachedPolicies(input *ListAttachedPoliciesInput) (*ListAttachedPoliciesOutput, error) {
	req, out := c.ListAttachedPoliciesRequest(input)
	return out, req.Send()
}

// ListAttachedPoliciesWithContext is the same as ListAttachedPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttachedPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAttachedPoliciesWithContext(ctx aws.Context, input *ListAttachedPoliciesInput, opts ...request.Option) (*ListAttachedPoliciesOutput, error) {
	req, out := c.ListAttachedPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAuditFindings = "ListAuditFindings"

// ListAuditFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListAuditFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAuditFindings for more information on using the ListAuditFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAuditFindingsRequest method.
//    req, resp := client.ListAuditFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAuditFindingsRequest(input *ListAuditFindingsInput) (req *request.Request, output *ListAuditFindingsOutput) {
	op := &request.Operation{
		Name:       opListAuditFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/findings",
	}

	if input == nil {
		input = &ListAuditFindingsInput{}
	}

	output = &ListAuditFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAuditFindings API operation for AWS IoT.
//
// Lists the findings (results) of a Device Defender audit or of the audits
// performed during a specified time period. (Findings are retained for 180
// days.)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAuditFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListAuditFindings(input *ListAuditFindingsInput) (*ListAuditFindingsOutput, error) {
	req, out := c.ListAuditFindingsRequest(input)
	return out, req.Send()
}

// ListAuditFindingsWithContext is the same as ListAuditFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListAuditFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAuditFindingsWithContext(ctx aws.Context, input *ListAuditFindingsInput, opts ...request.Option) (*ListAuditFindingsOutput, error) {
	req, out := c.ListAuditFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAuditTasks = "ListAuditTasks"

// ListAuditTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListAuditTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAuditTasks for more information on using the ListAuditTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAuditTasksRequest method.
//    req, resp := client.ListAuditTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAuditTasksRequest(input *ListAuditTasksInput) (req *request.Request, output *ListAuditTasksOutput) {
	op := &request.Operation{
		Name:       opListAuditTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/tasks",
	}

	if input == nil {
		input = &ListAuditTasksInput{}
	}

	output = &ListAuditTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAuditTasks API operation for AWS IoT.
//
// Lists the Device Defender audits that have been performed during a given
// time period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAuditTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListAuditTasks(input *ListAuditTasksInput) (*ListAuditTasksOutput, error) {
	req, out := c.ListAuditTasksRequest(input)
	return out, req.Send()
}

// ListAuditTasksWithContext is the same as ListAuditTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAuditTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAuditTasksWithContext(ctx aws.Context, input *ListAuditTasksInput, opts ...request.Option) (*ListAuditTasksOutput, error) {
	req, out := c.ListAuditTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAuthorizers = "ListAuthorizers"

// ListAuthorizersRequest generates a "aws/request.Request" representing the
// client's request for the ListAuthorizers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAuthorizers for more information on using the ListAuthorizers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAuthorizersRequest method.
//    req, resp := client.ListAuthorizersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAuthorizersRequest(input *ListAuthorizersInput) (req *request.Request, output *ListAuthorizersOutput) {
	op := &request.Operation{
		Name:       opListAuthorizers,
		HTTPMethod: "GET",
		HTTPPath:   "/authorizers/",
	}

	if input == nil {
		input = &ListAuthorizersInput{}
	}

	output = &ListAuthorizersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAuthorizers API operation for AWS IoT.
//
// Lists the authorizers registered in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAuthorizers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListAuthorizers(input *ListAuthorizersInput) (*ListAuthorizersOutput, error) {
	req, out := c.ListAuthorizersRequest(input)
	return out, req.Send()
}

// ListAuthorizersWithContext is the same as ListAuthorizers with the addition of
// the ability to pass a context and additional request options.
//
// See ListAuthorizers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAuthorizersWithContext(ctx aws.Context, input *ListAuthorizersInput, opts ...request.Option) (*ListAuthorizersOutput, error) {
	req, out := c.ListAuthorizersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBillingGroups = "ListBillingGroups"

// ListBillingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListBillingGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBillingGroups for more information on using the ListBillingGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBillingGroupsRequest method.
//    req, resp := client.ListBillingGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListBillingGroupsRequest(input *ListBillingGroupsInput) (req *request.Request, output *ListBillingGroupsOutput) {
	op := &request.Operation{
		Name:       opListBillingGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/billing-groups",
	}

	if input == nil {
		input = &ListBillingGroupsInput{}
	}

	output = &ListBillingGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBillingGroups API operation for AWS IoT.
//
// Lists the billing groups you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListBillingGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
func (c *IoT) ListBillingGroups(input *ListBillingGroupsInput) (*ListBillingGroupsOutput, error) {
	req, out := c.ListBillingGroupsRequest(input)
	return out, req.Send()
}

// ListBillingGroupsWithContext is the same as ListBillingGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListBillingGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListBillingGroupsWithContext(ctx aws.Context, input *ListBillingGroupsInput, opts ...request.Option) (*ListBillingGroupsOutput, error) {
	req, out := c.ListBillingGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCACertificates = "ListCACertificates"

// ListCACertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCACertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCACertificates for more information on using the ListCACertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCACertificatesRequest method.
//    req, resp := client.ListCACertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListCACertificatesRequest(input *ListCACertificatesInput) (req *request.Request, output *ListCACertificatesOutput) {
	op := &request.Operation{
		Name:       opListCACertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/cacertificates",
	}

	if input == nil {
		input = &ListCACertificatesInput{}
	}

	output = &ListCACertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCACertificates API operation for AWS IoT.
//
// Lists the CA certificates registered for your AWS account.
//
// The results are paginated with a default page size of 25. You can use the
// returned marker to retrieve additional results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListCACertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListCACertificates(input *ListCACertificatesInput) (*ListCACertificatesOutput, error) {
	req, out := c.ListCACertificatesRequest(input)
	return out, req.Send()
}

// ListCACertificatesWithContext is the same as ListCACertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCACertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListCACertificatesWithContext(ctx aws.Context, input *ListCACertificatesInput, opts ...request.Option) (*ListCACertificatesOutput, error) {
	req, out := c.ListCACertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificates = "ListCertificates"

// ListCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCertificates for more information on using the ListCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCertificatesRequest method.
//    req, resp := client.ListCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListCertificatesRequest(input *ListCertificatesInput) (req *request.Request, output *ListCertificatesOutput) {
	op := &request.Operation{
		Name:       opListCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates",
	}

	if input == nil {
		input = &ListCertificatesInput{}
	}

	output = &ListCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificates API operation for AWS IoT.
//
// Lists the certificates registered in your AWS account.
//
// The results are paginated with a default page size of 25. You can use the
// returned marker to retrieve additional results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListCertificates(input *ListCertificatesInput) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	return out, req.Send()
}

// ListCertificatesWithContext is the same as ListCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListCertificatesWithContext(ctx aws.Context, input *ListCertificatesInput, opts ...request.Option) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificatesByCA = "ListCertificatesByCA"

// ListCertificatesByCARequest generates a "aws/request.Request" representing the
// client's request for the ListCertificatesByCA operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCertificatesByCA for more information on using the ListCertificatesByCA
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCertificatesByCARequest method.
//    req, resp := client.ListCertificatesByCARequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListCertificatesByCARequest(input *ListCertificatesByCAInput) (req *request.Request, output *ListCertificatesByCAOutput) {
	op := &request.Operation{
		Name:       opListCertificatesByCA,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates-by-ca/{caCertificateId}",
	}

	if input == nil {
		input = &ListCertificatesByCAInput{}
	}

	output = &ListCertificatesByCAOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificatesByCA API operation for AWS IoT.
//
// List the device certificates signed by the specified CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListCertificatesByCA for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListCertificatesByCA(input *ListCertificatesByCAInput) (*ListCertificatesByCAOutput, error) {
	req, out := c.ListCertificatesByCARequest(input)
	return out, req.Send()
}

// ListCertificatesByCAWithContext is the same as ListCertificatesByCA with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificatesByCA for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListCertificatesByCAWithContext(ctx aws.Context, input *ListCertificatesByCAInput, opts ...request.Option) (*ListCertificatesByCAOutput, error) {
	req, out := c.ListCertificatesByCARequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIndices = "ListIndices"

// ListIndicesRequest generates a "aws/request.Request" representing the
// client's request for the ListIndices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIndices for more information on using the ListIndices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIndicesRequest method.
//    req, resp := client.ListIndicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListIndicesRequest(input *ListIndicesInput) (req *request.Request, output *ListIndicesOutput) {
	op := &request.Operation{
		Name:       opListIndices,
		HTTPMethod: "GET",
		HTTPPath:   "/indices",
	}

	if input == nil {
		input = &ListIndicesInput{}
	}

	output = &ListIndicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIndices API operation for AWS IoT.
//
// Lists the search indices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListIndices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListIndices(input *ListIndicesInput) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	return out, req.Send()
}

// ListIndicesWithContext is the same as ListIndices with the addition of
// the ability to pass a context and additional request options.
//
// See ListIndices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListIndicesWithContext(ctx aws.Context, input *ListIndicesInput, opts ...request.Option) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobExecutionsForJob = "ListJobExecutionsForJob"

// ListJobExecutionsForJobRequest generates a "aws/request.Request" representing the
// client's request for the ListJobExecutionsForJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobExecutionsForJob for more information on using the ListJobExecutionsForJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobExecutionsForJobRequest method.
//    req, resp := client.ListJobExecutionsForJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListJobExecutionsForJobRequest(input *ListJobExecutionsForJobInput) (req *request.Request, output *ListJobExecutionsForJobOutput) {
	op := &request.Operation{
		Name:       opListJobExecutionsForJob,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{jobId}/things",
	}

	if input == nil {
		input = &ListJobExecutionsForJobInput{}
	}

	output = &ListJobExecutionsForJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobExecutionsForJob API operation for AWS IoT.
//
// Lists the job executions for a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListJobExecutionsForJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) ListJobExecutionsForJob(input *ListJobExecutionsForJobInput) (*ListJobExecutionsForJobOutput, error) {
	req, out := c.ListJobExecutionsForJobRequest(input)
	return out, req.Send()
}

// ListJobExecutionsForJobWithContext is the same as ListJobExecutionsForJob with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobExecutionsForJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListJobExecutionsForJobWithContext(ctx aws.Context, input *ListJobExecutionsForJobInput, opts ...request.Option) (*ListJobExecutionsForJobOutput, error) {
	req, out := c.ListJobExecutionsForJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobExecutionsForThing = "ListJobExecutionsForThing"

// ListJobExecutionsForThingRequest generates a "aws/request.Request" representing the
// client's request for the ListJobExecutionsForThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobExecutionsForThing for more information on using the ListJobExecutionsForThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobExecutionsForThingRequest method.
//    req, resp := client.ListJobExecutionsForThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListJobExecutionsForThingRequest(input *ListJobExecutionsForThingInput) (req *request.Request, output *ListJobExecutionsForThingOutput) {
	op := &request.Operation{
		Name:       opListJobExecutionsForThing,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/jobs",
	}

	if input == nil {
		input = &ListJobExecutionsForThingInput{}
	}

	output = &ListJobExecutionsForThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobExecutionsForThing API operation for AWS IoT.
//
// Lists the job executions for the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListJobExecutionsForThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) ListJobExecutionsForThing(input *ListJobExecutionsForThingInput) (*ListJobExecutionsForThingOutput, error) {
	req, out := c.ListJobExecutionsForThingRequest(input)
	return out, req.Send()
}

// ListJobExecutionsForThingWithContext is the same as ListJobExecutionsForThing with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobExecutionsForThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListJobExecutionsForThingWithContext(ctx aws.Context, input *ListJobExecutionsForThingInput, opts ...request.Option) (*ListJobExecutionsForThingOutput, error) {
	req, out := c.ListJobExecutionsForThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs",
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS IoT.
//
// Lists jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOTAUpdates = "ListOTAUpdates"

// ListOTAUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the ListOTAUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOTAUpdates for more information on using the ListOTAUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOTAUpdatesRequest method.
//    req, resp := client.ListOTAUpdatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListOTAUpdatesRequest(input *ListOTAUpdatesInput) (req *request.Request, output *ListOTAUpdatesOutput) {
	op := &request.Operation{
		Name:       opListOTAUpdates,
		HTTPMethod: "GET",
		HTTPPath:   "/otaUpdates",
	}

	if input == nil {
		input = &ListOTAUpdatesInput{}
	}

	output = &ListOTAUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOTAUpdates API operation for AWS IoT.
//
// Lists OTA updates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListOTAUpdates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) ListOTAUpdates(input *ListOTAUpdatesInput) (*ListOTAUpdatesOutput, error) {
	req, out := c.ListOTAUpdatesRequest(input)
	return out, req.Send()
}

// ListOTAUpdatesWithContext is the same as ListOTAUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See ListOTAUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListOTAUpdatesWithContext(ctx aws.Context, input *ListOTAUpdatesInput, opts ...request.Option) (*ListOTAUpdatesOutput, error) {
	req, out := c.ListOTAUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOutgoingCertificates = "ListOutgoingCertificates"

// ListOutgoingCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListOutgoingCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOutgoingCertificates for more information on using the ListOutgoingCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOutgoingCertificatesRequest method.
//    req, resp := client.ListOutgoingCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListOutgoingCertificatesRequest(input *ListOutgoingCertificatesInput) (req *request.Request, output *ListOutgoingCertificatesOutput) {
	op := &request.Operation{
		Name:       opListOutgoingCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates-out-going",
	}

	if input == nil {
		input = &ListOutgoingCertificatesInput{}
	}

	output = &ListOutgoingCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOutgoingCertificates API operation for AWS IoT.
//
// Lists certificates that are being transferred but not yet accepted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListOutgoingCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListOutgoingCertificates(input *ListOutgoingCertificatesInput) (*ListOutgoingCertificatesOutput, error) {
	req, out := c.ListOutgoingCertificatesRequest(input)
	return out, req.Send()
}

// ListOutgoingCertificatesWithContext is the same as ListOutgoingCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListOutgoingCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListOutgoingCertificatesWithContext(ctx aws.Context, input *ListOutgoingCertificatesInput, opts ...request.Option) (*ListOutgoingCertificatesOutput, error) {
	req, out := c.ListOutgoingCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicies for more information on using the ListPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPoliciesRequest method.
//    req, resp := client.ListPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/policies",
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	output = &ListPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicies API operation for AWS IoT.
//
// Lists your policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	return out, req.Send()
}

// ListPoliciesWithContext is the same as ListPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPoliciesWithContext(ctx aws.Context, input *ListPoliciesInput, opts ...request.Option) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicyPrincipals = "ListPolicyPrincipals"

// ListPolicyPrincipalsRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyPrincipals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicyPrincipals for more information on using the ListPolicyPrincipals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPolicyPrincipalsRequest method.
//    req, resp := client.ListPolicyPrincipalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Deprecated: ListPolicyPrincipals has been deprecated
func (c *IoT) ListPolicyPrincipalsRequest(input *ListPolicyPrincipalsInput) (req *request.Request, output *ListPolicyPrincipalsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListPolicyPrincipals, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListPolicyPrincipals,
		HTTPMethod: "GET",
		HTTPPath:   "/policy-principals",
	}

	if input == nil {
		input = &ListPolicyPrincipalsInput{}
	}

	output = &ListPolicyPrincipalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyPrincipals API operation for AWS IoT.
//
// Lists the principals associated with the specified policy.
//
// Note: This API is deprecated. Please use ListTargetsForPolicy instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPolicyPrincipals for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//
// Deprecated: ListPolicyPrincipals has been deprecated
func (c *IoT) ListPolicyPrincipals(input *ListPolicyPrincipalsInput) (*ListPolicyPrincipalsOutput, error) {
	req, out := c.ListPolicyPrincipalsRequest(input)
	return out, req.Send()
}

// ListPolicyPrincipalsWithContext is the same as ListPolicyPrincipals with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyPrincipals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: ListPolicyPrincipalsWithContext has been deprecated
func (c *IoT) ListPolicyPrincipalsWithContext(ctx aws.Context, input *ListPolicyPrincipalsInput, opts ...request.Option) (*ListPolicyPrincipalsOutput, error) {
	req, out := c.ListPolicyPrincipalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicyVersions = "ListPolicyVersions"

// ListPolicyVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicyVersions for more information on using the ListPolicyVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPolicyVersionsRequest method.
//    req, resp := client.ListPolicyVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPolicyVersionsRequest(input *ListPolicyVersionsInput) (req *request.Request, output *ListPolicyVersionsOutput) {
	op := &request.Operation{
		Name:       opListPolicyVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}/version",
	}

	if input == nil {
		input = &ListPolicyVersionsInput{}
	}

	output = &ListPolicyVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyVersions API operation for AWS IoT.
//
// Lists the versions of the specified policy and identifies the default version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPolicyVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListPolicyVersions(input *ListPolicyVersionsInput) (*ListPolicyVersionsOutput, error) {
	req, out := c.ListPolicyVersionsRequest(input)
	return out, req.Send()
}

// ListPolicyVersionsWithContext is the same as ListPolicyVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPolicyVersionsWithContext(ctx aws.Context, input *ListPolicyVersionsInput, opts ...request.Option) (*ListPolicyVersionsOutput, error) {
	req, out := c.ListPolicyVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPrincipalPolicies = "ListPrincipalPolicies"

// ListPrincipalPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPrincipalPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrincipalPolicies for more information on using the ListPrincipalPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPrincipalPoliciesRequest method.
//    req, resp := client.ListPrincipalPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Deprecated: ListPrincipalPolicies has been deprecated
func (c *IoT) ListPrincipalPoliciesRequest(input *ListPrincipalPoliciesInput) (req *request.Request, output *ListPrincipalPoliciesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListPrincipalPolicies, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListPrincipalPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/principal-policies",
	}

	if input == nil {
		input = &ListPrincipalPoliciesInput{}
	}

	output = &ListPrincipalPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrincipalPolicies API operation for AWS IoT.
//
// Lists the policies attached to the specified principal. If you use an Cognito
// identity, the ID must be in AmazonCognito Identity format (http://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax).
//
// Note: This API is deprecated. Please use ListAttachedPolicies instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPrincipalPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//
// Deprecated: ListPrincipalPolicies has been deprecated
func (c *IoT) ListPrincipalPolicies(input *ListPrincipalPoliciesInput) (*ListPrincipalPoliciesOutput, error) {
	req, out := c.ListPrincipalPoliciesRequest(input)
	return out, req.Send()
}

// ListPrincipalPoliciesWithContext is the same as ListPrincipalPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrincipalPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: ListPrincipalPoliciesWithContext has been deprecated
func (c *IoT) ListPrincipalPoliciesWithContext(ctx aws.Context, input *ListPrincipalPoliciesInput, opts ...request.Option) (*ListPrincipalPoliciesOutput, error) {
	req, out := c.ListPrincipalPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPrincipalThings = "ListPrincipalThings"

// ListPrincipalThingsRequest generates a "aws/request.Request" representing the
// client's request for the ListPrincipalThings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrincipalThings for more information on using the ListPrincipalThings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPrincipalThingsRequest method.
//    req, resp := client.ListPrincipalThingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPrincipalThingsRequest(input *ListPrincipalThingsInput) (req *request.Request, output *ListPrincipalThingsOutput) {
	op := &request.Operation{
		Name:       opListPrincipalThings,
		HTTPMethod: "GET",
		HTTPPath:   "/principals/things",
	}

	if input == nil {
		input = &ListPrincipalThingsInput{}
	}

	output = &ListPrincipalThingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrincipalThings API operation for AWS IoT.
//
// Lists the things associated with the specified principal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPrincipalThings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) ListPrincipalThings(input *ListPrincipalThingsInput) (*ListPrincipalThingsOutput, error) {
	req, out := c.ListPrincipalThingsRequest(input)
	return out, req.Send()
}

// ListPrincipalThingsWithContext is the same as ListPrincipalThings with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrincipalThings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPrincipalThingsWithContext(ctx aws.Context, input *ListPrincipalThingsInput, opts ...request.Option) (*ListPrincipalThingsOutput, error) {
	req, out := c.ListPrincipalThingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRoleAliases = "ListRoleAliases"

// ListRoleAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoleAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoleAliases for more information on using the ListRoleAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoleAliasesRequest method.
//    req, resp := client.ListRoleAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListRoleAliasesRequest(input *ListRoleAliasesInput) (req *request.Request, output *ListRoleAliasesOutput) {
	op := &request.Operation{
		Name:       opListRoleAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/role-aliases",
	}

	if input == nil {
		input = &ListRoleAliasesInput{}
	}

	output = &ListRoleAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoleAliases API operation for AWS IoT.
//
// Lists the role aliases registered in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListRoleAliases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListRoleAliases(input *ListRoleAliasesInput) (*ListRoleAliasesOutput, error) {
	req, out := c.ListRoleAliasesRequest(input)
	return out, req.Send()
}

// ListRoleAliasesWithContext is the same as ListRoleAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoleAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListRoleAliasesWithContext(ctx aws.Context, input *ListRoleAliasesInput, opts ...request.Option) (*ListRoleAliasesOutput, error) {
	req, out := c.ListRoleAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListScheduledAudits = "ListScheduledAudits"

// ListScheduledAuditsRequest generates a "aws/request.Request" representing the
// client's request for the ListScheduledAudits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScheduledAudits for more information on using the ListScheduledAudits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListScheduledAuditsRequest method.
//    req, resp := client.ListScheduledAuditsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListScheduledAuditsRequest(input *ListScheduledAuditsInput) (req *request.Request, output *ListScheduledAuditsOutput) {
	op := &request.Operation{
		Name:       opListScheduledAudits,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/scheduledaudits",
	}

	if input == nil {
		input = &ListScheduledAuditsInput{}
	}

	output = &ListScheduledAuditsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListScheduledAudits API operation for AWS IoT.
//
// Lists all of your scheduled audits.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListScheduledAudits for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListScheduledAudits(input *ListScheduledAuditsInput) (*ListScheduledAuditsOutput, error) {
	req, out := c.ListScheduledAuditsRequest(input)
	return out, req.Send()
}

// ListScheduledAuditsWithContext is the same as ListScheduledAudits with the addition of
// the ability to pass a context and additional request options.
//
// See ListScheduledAudits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListScheduledAuditsWithContext(ctx aws.Context, input *ListScheduledAuditsInput, opts ...request.Option) (*ListScheduledAuditsOutput, error) {
	req, out := c.ListScheduledAuditsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSecurityProfiles = "ListSecurityProfiles"

// ListSecurityProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityProfiles for more information on using the ListSecurityProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecurityProfilesRequest method.
//    req, resp := client.ListSecurityProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListSecurityProfilesRequest(input *ListSecurityProfilesInput) (req *request.Request, output *ListSecurityProfilesOutput) {
	op := &request.Operation{
		Name:       opListSecurityProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles",
	}

	if input == nil {
		input = &ListSecurityProfilesInput{}
	}

	output = &ListSecurityProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityProfiles API operation for AWS IoT.
//
// Lists the Device Defender security profiles you have created. You can use
// filters to list only those security profiles associated with a thing group
// or only those associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListSecurityProfiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListSecurityProfiles(input *ListSecurityProfilesInput) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	return out, req.Send()
}

// ListSecurityProfilesWithContext is the same as ListSecurityProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListSecurityProfilesWithContext(ctx aws.Context, input *ListSecurityProfilesInput, opts ...request.Option) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSecurityProfilesForTarget = "ListSecurityProfilesForTarget"

// ListSecurityProfilesForTargetRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityProfilesForTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityProfilesForTarget for more information on using the ListSecurityProfilesForTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecurityProfilesForTargetRequest method.
//    req, resp := client.ListSecurityProfilesForTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListSecurityProfilesForTargetRequest(input *ListSecurityProfilesForTargetInput) (req *request.Request, output *ListSecurityProfilesForTargetOutput) {
	op := &request.Operation{
		Name:       opListSecurityProfilesForTarget,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles-for-target",
	}

	if input == nil {
		input = &ListSecurityProfilesForTargetInput{}
	}

	output = &ListSecurityProfilesForTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityProfilesForTarget API operation for AWS IoT.
//
// Lists the Device Defender security profiles attached to a target (thing group).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListSecurityProfilesForTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) ListSecurityProfilesForTarget(input *ListSecurityProfilesForTargetInput) (*ListSecurityProfilesForTargetOutput, error) {
	req, out := c.ListSecurityProfilesForTargetRequest(input)
	return out, req.Send()
}

// ListSecurityProfilesForTargetWithContext is the same as ListSecurityProfilesForTarget with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityProfilesForTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListSecurityProfilesForTargetWithContext(ctx aws.Context, input *ListSecurityProfilesForTargetInput, opts ...request.Option) (*ListSecurityProfilesForTargetOutput, error) {
	req, out := c.ListSecurityProfilesForTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStreams = "ListStreams"

// ListStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreams for more information on using the ListStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStreamsRequest method.
//    req, resp := client.ListStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListStreamsRequest(input *ListStreamsInput) (req *request.Request, output *ListStreamsOutput) {
	op := &request.Operation{
		Name:       opListStreams,
		HTTPMethod: "GET",
		HTTPPath:   "/streams",
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	output = &ListStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreams API operation for AWS IoT.
//
// Lists all of the streams in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListStreams for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListStreams(input *ListStreamsInput) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	return out, req.Send()
}

// ListStreamsWithContext is the same as ListStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListStreamsWithContext(ctx aws.Context, input *ListStreamsInput, opts ...request.Option) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT.
//
// Lists the tags (metadata) you have assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
func (c *IoT) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetsForPolicy = "ListTargetsForPolicy"

// ListTargetsForPolicyRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsForPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetsForPolicy for more information on using the ListTargetsForPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTargetsForPolicyRequest method.
//    req, resp := client.ListTargetsForPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTargetsForPolicyRequest(input *ListTargetsForPolicyInput) (req *request.Request, output *ListTargetsForPolicyOutput) {
	op := &request.Operation{
		Name:       opListTargetsForPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policy-targets/{policyName}",
	}

	if input == nil {
		input = &ListTargetsForPolicyInput{}
	}

	output = &ListTargetsForPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsForPolicy API operation for AWS IoT.
//
// List targets for the specified policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTargetsForPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) ListTargetsForPolicy(input *ListTargetsForPolicyInput) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	return out, req.Send()
}

// ListTargetsForPolicyWithContext is the same as ListTargetsForPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsForPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTargetsForPolicyWithContext(ctx aws.Context, input *ListTargetsForPolicyInput, opts ...request.Option) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetsForSecurityProfile = "ListTargetsForSecurityProfile"

// ListTargetsForSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsForSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetsForSecurityProfile for more information on using the ListTargetsForSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTargetsForSecurityProfileRequest method.
//    req, resp := client.ListTargetsForSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTargetsForSecurityProfileRequest(input *ListTargetsForSecurityProfileInput) (req *request.Request, output *ListTargetsForSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opListTargetsForSecurityProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles/{securityProfileName}/targets",
	}

	if input == nil {
		input = &ListTargetsForSecurityProfileInput{}
	}

	output = &ListTargetsForSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsForSecurityProfile API operation for AWS IoT.
//
// Lists the targets (thing groups) associated with a given Device Defender
// security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTargetsForSecurityProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListTargetsForSecurityProfile(input *ListTargetsForSecurityProfileInput) (*ListTargetsForSecurityProfileOutput, error) {
	req, out := c.ListTargetsForSecurityProfileRequest(input)
	return out, req.Send()
}

// ListTargetsForSecurityProfileWithContext is the same as ListTargetsForSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsForSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTargetsForSecurityProfileWithContext(ctx aws.Context, input *ListTargetsForSecurityProfileInput, opts ...request.Option) (*ListTargetsForSecurityProfileOutput, error) {
	req, out := c.ListTargetsForSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingGroups = "ListThingGroups"

// ListThingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListThingGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingGroups for more information on using the ListThingGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingGroupsRequest method.
//    req, resp := client.ListThingGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingGroupsRequest(input *ListThingGroupsInput) (req *request.Request, output *ListThingGroupsOutput) {
	op := &request.Operation{
		Name:       opListThingGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-groups",
	}

	if input == nil {
		input = &ListThingGroupsInput{}
	}

	output = &ListThingGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingGroups API operation for AWS IoT.
//
// List the thing groups in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) ListThingGroups(input *ListThingGroupsInput) (*ListThingGroupsOutput, error) {
	req, out := c.ListThingGroupsRequest(input)
	return out, req.Send()
}

// ListThingGroupsWithContext is the same as ListThingGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingGroupsWithContext(ctx aws.Context, input *ListThingGroupsInput, opts ...request.Option) (*ListThingGroupsOutput, error) {
	req, out := c.ListThingGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingGroupsForThing = "ListThingGroupsForThing"

// ListThingGroupsForThingRequest generates a "aws/request.Request" representing the
// client's request for the ListThingGroupsForThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingGroupsForThing for more information on using the ListThingGroupsForThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingGroupsForThingRequest method.
//    req, resp := client.ListThingGroupsForThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingGroupsForThingRequest(input *ListThingGroupsForThingInput) (req *request.Request, output *ListThingGroupsForThingOutput) {
	op := &request.Operation{
		Name:       opListThingGroupsForThing,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/thing-groups",
	}

	if input == nil {
		input = &ListThingGroupsForThingInput{}
	}

	output = &ListThingGroupsForThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingGroupsForThing API operation for AWS IoT.
//
// List the thing groups to which the specified thing belongs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingGroupsForThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) ListThingGroupsForThing(input *ListThingGroupsForThingInput) (*ListThingGroupsForThingOutput, error) {
	req, out := c.ListThingGroupsForThingRequest(input)
	return out, req.Send()
}

// ListThingGroupsForThingWithContext is the same as ListThingGroupsForThing with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingGroupsForThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingGroupsForThingWithContext(ctx aws.Context, input *ListThingGroupsForThingInput, opts ...request.Option) (*ListThingGroupsForThingOutput, error) {
	req, out := c.ListThingGroupsForThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingPrincipals = "ListThingPrincipals"

// ListThingPrincipalsRequest generates a "aws/request.Request" representing the
// client's request for the ListThingPrincipals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingPrincipals for more information on using the ListThingPrincipals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingPrincipalsRequest method.
//    req, resp := client.ListThingPrincipalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingPrincipalsRequest(input *ListThingPrincipalsInput) (req *request.Request, output *ListThingPrincipalsOutput) {
	op := &request.Operation{
		Name:       opListThingPrincipals,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &ListThingPrincipalsInput{}
	}

	output = &ListThingPrincipalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingPrincipals API operation for AWS IoT.
//
// Lists the principals associated with the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingPrincipals for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) ListThingPrincipals(input *ListThingPrincipalsInput) (*ListThingPrincipalsOutput, error) {
	req, out := c.ListThingPrincipalsRequest(input)
	return out, req.Send()
}

// ListThingPrincipalsWithContext is the same as ListThingPrincipals with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingPrincipals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingPrincipalsWithContext(ctx aws.Context, input *ListThingPrincipalsInput, opts ...request.Option) (*ListThingPrincipalsOutput, error) {
	req, out := c.ListThingPrincipalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingRegistrationTaskReports = "ListThingRegistrationTaskReports"

// ListThingRegistrationTaskReportsRequest generates a "aws/request.Request" representing the
// client's request for the ListThingRegistrationTaskReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingRegistrationTaskReports for more information on using the ListThingRegistrationTaskReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingRegistrationTaskReportsRequest method.
//    req, resp := client.ListThingRegistrationTaskReportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingRegistrationTaskReportsRequest(input *ListThingRegistrationTaskReportsInput) (req *request.Request, output *ListThingRegistrationTaskReportsOutput) {
	op := &request.Operation{
		Name:       opListThingRegistrationTaskReports,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-registration-tasks/{taskId}/reports",
	}

	if input == nil {
		input = &ListThingRegistrationTaskReportsInput{}
	}

	output = &ListThingRegistrationTaskReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingRegistrationTaskReports API operation for AWS IoT.
//
// Information about the thing registration tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingRegistrationTaskReports for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListThingRegistrationTaskReports(input *ListThingRegistrationTaskReportsInput) (*ListThingRegistrationTaskReportsOutput, error) {
	req, out := c.ListThingRegistrationTaskReportsRequest(input)
	return out, req.Send()
}

// ListThingRegistrationTaskReportsWithContext is the same as ListThingRegistrationTaskReports with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingRegistrationTaskReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingRegistrationTaskReportsWithContext(ctx aws.Context, input *ListThingRegistrationTaskReportsInput, opts ...request.Option) (*ListThingRegistrationTaskReportsOutput, error) {
	req, out := c.ListThingRegistrationTaskReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingRegistrationTasks = "ListThingRegistrationTasks"

// ListThingRegistrationTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListThingRegistrationTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingRegistrationTasks for more information on using the ListThingRegistrationTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingRegistrationTasksRequest method.
//    req, resp := client.ListThingRegistrationTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingRegistrationTasksRequest(input *ListThingRegistrationTasksInput) (req *request.Request, output *ListThingRegistrationTasksOutput) {
	op := &request.Operation{
		Name:       opListThingRegistrationTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-registration-tasks",
	}

	if input == nil {
		input = &ListThingRegistrationTasksInput{}
	}

	output = &ListThingRegistrationTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingRegistrationTasks API operation for AWS IoT.
//
// List bulk thing provisioning tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingRegistrationTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListThingRegistrationTasks(input *ListThingRegistrationTasksInput) (*ListThingRegistrationTasksOutput, error) {
	req, out := c.ListThingRegistrationTasksRequest(input)
	return out, req.Send()
}

// ListThingRegistrationTasksWithContext is the same as ListThingRegistrationTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingRegistrationTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingRegistrationTasksWithContext(ctx aws.Context, input *ListThingRegistrationTasksInput, opts ...request.Option) (*ListThingRegistrationTasksOutput, error) {
	req, out := c.ListThingRegistrationTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingTypes = "ListThingTypes"

// ListThingTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListThingTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingTypes for more information on using the ListThingTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingTypesRequest method.
//    req, resp := client.ListThingTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingTypesRequest(input *ListThingTypesInput) (req *request.Request, output *ListThingTypesOutput) {
	op := &request.Operation{
		Name:       opListThingTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-types",
	}

	if input == nil {
		input = &ListThingTypesInput{}
	}

	output = &ListThingTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingTypes API operation for AWS IoT.
//
// Lists the existing thing types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListThingTypes(input *ListThingTypesInput) (*ListThingTypesOutput, error) {
	req, out := c.ListThingTypesRequest(input)
	return out, req.Send()
}

// ListThingTypesWithContext is the same as ListThingTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingTypesWithContext(ctx aws.Context, input *ListThingTypesInput, opts ...request.Option) (*ListThingTypesOutput, error) {
	req, out := c.ListThingTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThings = "ListThings"

// ListThingsRequest generates a "aws/request.Request" representing the
// client's request for the ListThings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThings for more information on using the ListThings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingsRequest method.
//    req, resp := client.ListThingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingsRequest(input *ListThingsInput) (req *request.Request, output *ListThingsOutput) {
	op := &request.Operation{
		Name:       opListThings,
		HTTPMethod: "GET",
		HTTPPath:   "/things",
	}

	if input == nil {
		input = &ListThingsInput{}
	}

	output = &ListThingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThings API operation for AWS IoT.
//
// Lists your things. Use the attributeName and attributeValue parameters to
// filter your things. For example, calling ListThings with attributeName=Color
// and attributeValue=Red retrieves all things in the registry that contain
// an attribute Color with the value Red.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListThings(input *ListThingsInput) (*ListThingsOutput, error) {
	req, out := c.ListThingsRequest(input)
	return out, req.Send()
}

// ListThingsWithContext is the same as ListThings with the addition of
// the ability to pass a context and additional request options.
//
// See ListThings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingsWithContext(ctx aws.Context, input *ListThingsInput, opts ...request.Option) (*ListThingsOutput, error) {
	req, out := c.ListThingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingsInBillingGroup = "ListThingsInBillingGroup"

// ListThingsInBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the ListThingsInBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingsInBillingGroup for more information on using the ListThingsInBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingsInBillingGroupRequest method.
//    req, resp := client.ListThingsInBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingsInBillingGroupRequest(input *ListThingsInBillingGroupInput) (req *request.Request, output *ListThingsInBillingGroupOutput) {
	op := &request.Operation{
		Name:       opListThingsInBillingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/billing-groups/{billingGroupName}/things",
	}

	if input == nil {
		input = &ListThingsInBillingGroupInput{}
	}

	output = &ListThingsInBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingsInBillingGroup API operation for AWS IoT.
//
// Lists the things you have added to the given billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingsInBillingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
func (c *IoT) ListThingsInBillingGroup(input *ListThingsInBillingGroupInput) (*ListThingsInBillingGroupOutput, error) {
	req, out := c.ListThingsInBillingGroupRequest(input)
	return out, req.Send()
}

// ListThingsInBillingGroupWithContext is the same as ListThingsInBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingsInBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingsInBillingGroupWithContext(ctx aws.Context, input *ListThingsInBillingGroupInput, opts ...request.Option) (*ListThingsInBillingGroupOutput, error) {
	req, out := c.ListThingsInBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingsInThingGroup = "ListThingsInThingGroup"

// ListThingsInThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the ListThingsInThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingsInThingGroup for more information on using the ListThingsInThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingsInThingGroupRequest method.
//    req, resp := client.ListThingsInThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingsInThingGroupRequest(input *ListThingsInThingGroupInput) (req *request.Request, output *ListThingsInThingGroupOutput) {
	op := &request.Operation{
		Name:       opListThingsInThingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-groups/{thingGroupName}/things",
	}

	if input == nil {
		input = &ListThingsInThingGroupInput{}
	}

	output = &ListThingsInThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingsInThingGroup API operation for AWS IoT.
//
// Lists the things in the specified group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingsInThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) ListThingsInThingGroup(input *ListThingsInThingGroupInput) (*ListThingsInThingGroupOutput, error) {
	req, out := c.ListThingsInThingGroupRequest(input)
	return out, req.Send()
}

// ListThingsInThingGroupWithContext is the same as ListThingsInThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingsInThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingsInThingGroupWithContext(ctx aws.Context, input *ListThingsInThingGroupInput, opts ...request.Option) (*ListThingsInThingGroupOutput, error) {
	req, out := c.ListThingsInThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTopicRules = "ListTopicRules"

// ListTopicRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListTopicRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTopicRules for more information on using the ListTopicRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTopicRulesRequest method.
//    req, resp := client.ListTopicRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTopicRulesRequest(input *ListTopicRulesInput) (req *request.Request, output *ListTopicRulesOutput) {
	op := &request.Operation{
		Name:       opListTopicRules,
		HTTPMethod: "GET",
		HTTPPath:   "/rules",
	}

	if input == nil {
		input = &ListTopicRulesInput{}
	}

	output = &ListTopicRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopicRules API operation for AWS IoT.
//
// Lists the rules for the specific topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTopicRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) ListTopicRules(input *ListTopicRulesInput) (*ListTopicRulesOutput, error) {
	req, out := c.ListTopicRulesRequest(input)
	return out, req.Send()
}

// ListTopicRulesWithContext is the same as ListTopicRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopicRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTopicRulesWithContext(ctx aws.Context, input *ListTopicRulesInput, opts ...request.Option) (*ListTopicRulesOutput, error) {
	req, out := c.ListTopicRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListV2LoggingLevels = "ListV2LoggingLevels"

// ListV2LoggingLevelsRequest generates a "aws/request.Request" representing the
// client's request for the ListV2LoggingLevels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListV2LoggingLevels for more information on using the ListV2LoggingLevels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListV2LoggingLevelsRequest method.
//    req, resp := client.ListV2LoggingLevelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListV2LoggingLevelsRequest(input *ListV2LoggingLevelsInput) (req *request.Request, output *ListV2LoggingLevelsOutput) {
	op := &request.Operation{
		Name:       opListV2LoggingLevels,
		HTTPMethod: "GET",
		HTTPPath:   "/v2LoggingLevel",
	}

	if input == nil {
		input = &ListV2LoggingLevelsInput{}
	}

	output = &ListV2LoggingLevelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListV2LoggingLevels API operation for AWS IoT.
//
// Lists logging levels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListV2LoggingLevels for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeNotConfiguredException "NotConfiguredException"
//   The resource is not configured.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) ListV2LoggingLevels(input *ListV2LoggingLevelsInput) (*ListV2LoggingLevelsOutput, error) {
	req, out := c.ListV2LoggingLevelsRequest(input)
	return out, req.Send()
}

// ListV2LoggingLevelsWithContext is the same as ListV2LoggingLevels with the addition of
// the ability to pass a context and additional request options.
//
// See ListV2LoggingLevels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListV2LoggingLevelsWithContext(ctx aws.Context, input *ListV2LoggingLevelsInput, opts ...request.Option) (*ListV2LoggingLevelsOutput, error) {
	req, out := c.ListV2LoggingLevelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListViolationEvents = "ListViolationEvents"

// ListViolationEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListViolationEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListViolationEvents for more information on using the ListViolationEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListViolationEventsRequest method.
//    req, resp := client.ListViolationEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListViolationEventsRequest(input *ListViolationEventsInput) (req *request.Request, output *ListViolationEventsOutput) {
	op := &request.Operation{
		Name:       opListViolationEvents,
		HTTPMethod: "GET",
		HTTPPath:   "/violation-events",
	}

	if input == nil {
		input = &ListViolationEventsInput{}
	}

	output = &ListViolationEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListViolationEvents API operation for AWS IoT.
//
// Lists the Device Defender security profile violations discovered during the
// given time period. You can use filters to limit the results to those alerts
// issued for a particular security profile, behavior or thing (device).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListViolationEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListViolationEvents(input *ListViolationEventsInput) (*ListViolationEventsOutput, error) {
	req, out := c.ListViolationEventsRequest(input)
	return out, req.Send()
}

// ListViolationEventsWithContext is the same as ListViolationEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListViolationEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListViolationEventsWithContext(ctx aws.Context, input *ListViolationEventsInput, opts ...request.Option) (*ListViolationEventsOutput, error) {
	req, out := c.ListViolationEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterCACertificate = "RegisterCACertificate"

// RegisterCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCACertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterCACertificate for more information on using the RegisterCACertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterCACertificateRequest method.
//    req, resp := client.RegisterCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RegisterCACertificateRequest(input *RegisterCACertificateInput) (req *request.Request, output *RegisterCACertificateOutput) {
	op := &request.Operation{
		Name:       opRegisterCACertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/cacertificate",
	}

	if input == nil {
		input = &RegisterCACertificateInput{}
	}

	output = &RegisterCACertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCACertificate API operation for AWS IoT.
//
// Registers a CA certificate with AWS IoT. This CA certificate can then be
// used to sign device certificates, which can be then registered with AWS IoT.
// You can register up to 10 CA certificates per AWS account that have the same
// subject field. This enables you to have up to 10 certificate authorities
// sign your device certificates. If you have more than one CA certificate registered,
// make sure you pass the CA certificate when you register your device certificates
// with the RegisterCertificate API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RegisterCACertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeRegistrationCodeValidationException "RegistrationCodeValidationException"
//   The registration code is invalid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeCertificateValidationException "CertificateValidationException"
//   The certificate is invalid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) RegisterCACertificate(input *RegisterCACertificateInput) (*RegisterCACertificateOutput, error) {
	req, out := c.RegisterCACertificateRequest(input)
	return out, req.Send()
}

// RegisterCACertificateWithContext is the same as RegisterCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RegisterCACertificateWithContext(ctx aws.Context, input *RegisterCACertificateInput, opts ...request.Option) (*RegisterCACertificateOutput, error) {
	req, out := c.RegisterCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterCertificate = "RegisterCertificate"

// RegisterCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterCertificate for more information on using the RegisterCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterCertificateRequest method.
//    req, resp := client.RegisterCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RegisterCertificateRequest(input *RegisterCertificateInput) (req *request.Request, output *RegisterCertificateOutput) {
	op := &request.Operation{
		Name:       opRegisterCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/certificate/register",
	}

	if input == nil {
		input = &RegisterCertificateInput{}
	}

	output = &RegisterCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCertificate API operation for AWS IoT.
//
// Registers a device certificate with AWS IoT. If you have more than one CA
// certificate that has the same subject field, you must specify the CA certificate
// that was used to sign the device certificate being registered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RegisterCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeCertificateValidationException "CertificateValidationException"
//   The certificate is invalid.
//
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeCertificateConflictException "CertificateConflictException"
//   Unable to verify the CA certificate used to sign the device certificate you
//   are attempting to register. This is happens when you have registered more
//   than one CA certificate that has the same subject field and public key.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) RegisterCertificate(input *RegisterCertificateInput) (*RegisterCertificateOutput, error) {
	req, out := c.RegisterCertificateRequest(input)
	return out, req.Send()
}

// RegisterCertificateWithContext is the same as RegisterCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RegisterCertificateWithContext(ctx aws.Context, input *RegisterCertificateInput, opts ...request.Option) (*RegisterCertificateOutput, error) {
	req, out := c.RegisterCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterThing = "RegisterThing"

// RegisterThingRequest generates a "aws/request.Request" representing the
// client's request for the RegisterThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterThing for more information on using the RegisterThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterThingRequest method.
//    req, resp := client.RegisterThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RegisterThingRequest(input *RegisterThingInput) (req *request.Request, output *RegisterThingOutput) {
	op := &request.Operation{
		Name:       opRegisterThing,
		HTTPMethod: "POST",
		HTTPPath:   "/things",
	}

	if input == nil {
		input = &RegisterThingInput{}
	}

	output = &RegisterThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterThing API operation for AWS IoT.
//
// Provisions a thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RegisterThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeConflictingResourceUpdateException "ConflictingResourceUpdateException"
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
//   * ErrCodeResourceRegistrationFailureException "ResourceRegistrationFailureException"
//   The resource registration failed.
//
func (c *IoT) RegisterThing(input *RegisterThingInput) (*RegisterThingOutput, error) {
	req, out := c.RegisterThingRequest(input)
	return out, req.Send()
}

// RegisterThingWithContext is the same as RegisterThing with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RegisterThingWithContext(ctx aws.Context, input *RegisterThingInput, opts ...request.Option) (*RegisterThingOutput, error) {
	req, out := c.RegisterThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectCertificateTransfer = "RejectCertificateTransfer"

// RejectCertificateTransferRequest generates a "aws/request.Request" representing the
// client's request for the RejectCertificateTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectCertificateTransfer for more information on using the RejectCertificateTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectCertificateTransferRequest method.
//    req, resp := client.RejectCertificateTransferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RejectCertificateTransferRequest(input *RejectCertificateTransferInput) (req *request.Request, output *RejectCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opRejectCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/reject-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &RejectCertificateTransferInput{}
	}

	output = &RejectCertificateTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectCertificateTransfer API operation for AWS IoT.
//
// Rejects a pending certificate transfer. After AWS IoT rejects a certificate
// transfer, the certificate status changes from PENDING_TRANSFER to INACTIVE.
//
// To check for pending certificate transfers, call ListCertificates to enumerate
// your certificates.
//
// This operation can only be called by the transfer destination. After it is
// called, the certificate will be returned to the source's account in the INACTIVE
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RejectCertificateTransfer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeTransferAlreadyCompletedException "TransferAlreadyCompletedException"
//   You can't revert the certificate transfer because the transfer is already
//   complete.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) RejectCertificateTransfer(input *RejectCertificateTransferInput) (*RejectCertificateTransferOutput, error) {
	req, out := c.RejectCertificateTransferRequest(input)
	return out, req.Send()
}

// RejectCertificateTransferWithContext is the same as RejectCertificateTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See RejectCertificateTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RejectCertificateTransferWithContext(ctx aws.Context, input *RejectCertificateTransferInput, opts ...request.Option) (*RejectCertificateTransferOutput, error) {
	req, out := c.RejectCertificateTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveThingFromBillingGroup = "RemoveThingFromBillingGroup"

// RemoveThingFromBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the RemoveThingFromBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveThingFromBillingGroup for more information on using the RemoveThingFromBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveThingFromBillingGroupRequest method.
//    req, resp := client.RemoveThingFromBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RemoveThingFromBillingGroupRequest(input *RemoveThingFromBillingGroupInput) (req *request.Request, output *RemoveThingFromBillingGroupOutput) {
	op := &request.Operation{
		Name:       opRemoveThingFromBillingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/billing-groups/removeThingFromBillingGroup",
	}

	if input == nil {
		input = &RemoveThingFromBillingGroupInput{}
	}

	output = &RemoveThingFromBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveThingFromBillingGroup API operation for AWS IoT.
//
// Removes the given thing from the billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RemoveThingFromBillingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) RemoveThingFromBillingGroup(input *RemoveThingFromBillingGroupInput) (*RemoveThingFromBillingGroupOutput, error) {
	req, out := c.RemoveThingFromBillingGroupRequest(input)
	return out, req.Send()
}

// RemoveThingFromBillingGroupWithContext is the same as RemoveThingFromBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveThingFromBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RemoveThingFromBillingGroupWithContext(ctx aws.Context, input *RemoveThingFromBillingGroupInput, opts ...request.Option) (*RemoveThingFromBillingGroupOutput, error) {
	req, out := c.RemoveThingFromBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveThingFromThingGroup = "RemoveThingFromThingGroup"

// RemoveThingFromThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the RemoveThingFromThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveThingFromThingGroup for more information on using the RemoveThingFromThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveThingFromThingGroupRequest method.
//    req, resp := client.RemoveThingFromThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RemoveThingFromThingGroupRequest(input *RemoveThingFromThingGroupInput) (req *request.Request, output *RemoveThingFromThingGroupOutput) {
	op := &request.Operation{
		Name:       opRemoveThingFromThingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/thing-groups/removeThingFromThingGroup",
	}

	if input == nil {
		input = &RemoveThingFromThingGroupInput{}
	}

	output = &RemoveThingFromThingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveThingFromThingGroup API operation for AWS IoT.
//
// Remove the specified thing from the specified group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RemoveThingFromThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) RemoveThingFromThingGroup(input *RemoveThingFromThingGroupInput) (*RemoveThingFromThingGroupOutput, error) {
	req, out := c.RemoveThingFromThingGroupRequest(input)
	return out, req.Send()
}

// RemoveThingFromThingGroupWithContext is the same as RemoveThingFromThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveThingFromThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RemoveThingFromThingGroupWithContext(ctx aws.Context, input *RemoveThingFromThingGroupInput, opts ...request.Option) (*RemoveThingFromThingGroupOutput, error) {
	req, out := c.RemoveThingFromThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReplaceTopicRule = "ReplaceTopicRule"

// ReplaceTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the ReplaceTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReplaceTopicRule for more information on using the ReplaceTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReplaceTopicRuleRequest method.
//    req, resp := client.ReplaceTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ReplaceTopicRuleRequest(input *ReplaceTopicRuleInput) (req *request.Request, output *ReplaceTopicRuleOutput) {
	op := &request.Operation{
		Name:       opReplaceTopicRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &ReplaceTopicRuleInput{}
	}

	output = &ReplaceTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ReplaceTopicRule API operation for AWS IoT.
//
// Replaces the rule. You must specify all parameters for the new rule. Creating
// rules is an administrator-level action. Any user who has permission to create
// rules will be able to access data processed by the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ReplaceTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSqlParseException "SqlParseException"
//   The Rule-SQL expression can't be parsed correctly.
//
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeConflictingResourceUpdateException "ConflictingResourceUpdateException"
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) ReplaceTopicRule(input *ReplaceTopicRuleInput) (*ReplaceTopicRuleOutput, error) {
	req, out := c.ReplaceTopicRuleRequest(input)
	return out, req.Send()
}

// ReplaceTopicRuleWithContext is the same as ReplaceTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See ReplaceTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ReplaceTopicRuleWithContext(ctx aws.Context, input *ReplaceTopicRuleInput, opts ...request.Option) (*ReplaceTopicRuleOutput, error) {
	req, out := c.ReplaceTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchIndex = "SearchIndex"

// SearchIndexRequest generates a "aws/request.Request" representing the
// client's request for the SearchIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchIndex for more information on using the SearchIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchIndexRequest method.
//    req, resp := client.SearchIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SearchIndexRequest(input *SearchIndexInput) (req *request.Request, output *SearchIndexOutput) {
	op := &request.Operation{
		Name:       opSearchIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/indices/search",
	}

	if input == nil {
		input = &SearchIndexInput{}
	}

	output = &SearchIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchIndex API operation for AWS IoT.
//
// The query search index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SearchIndex for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidQueryException "InvalidQueryException"
//   The query is invalid.
//
//   * ErrCodeIndexNotReadyException "IndexNotReadyException"
//   The index is not ready.
//
func (c *IoT) SearchIndex(input *SearchIndexInput) (*SearchIndexOutput, error) {
	req, out := c.SearchIndexRequest(input)
	return out, req.Send()
}

// SearchIndexWithContext is the same as SearchIndex with the addition of
// the ability to pass a context and additional request options.
//
// See SearchIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SearchIndexWithContext(ctx aws.Context, input *SearchIndexInput, opts ...request.Option) (*SearchIndexOutput, error) {
	req, out := c.SearchIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDefaultAuthorizer = "SetDefaultAuthorizer"

// SetDefaultAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the SetDefaultAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetDefaultAuthorizer for more information on using the SetDefaultAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetDefaultAuthorizerRequest method.
//    req, resp := client.SetDefaultAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetDefaultAuthorizerRequest(input *SetDefaultAuthorizerInput) (req *request.Request, output *SetDefaultAuthorizerOutput) {
	op := &request.Operation{
		Name:       opSetDefaultAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/default-authorizer",
	}

	if input == nil {
		input = &SetDefaultAuthorizerInput{}
	}

	output = &SetDefaultAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetDefaultAuthorizer API operation for AWS IoT.
//
// Sets the default authorizer. This will be used if a websocket connection
// is made without specifying an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetDefaultAuthorizer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
func (c *IoT) SetDefaultAuthorizer(input *SetDefaultAuthorizerInput) (*SetDefaultAuthorizerOutput, error) {
	req, out := c.SetDefaultAuthorizerRequest(input)
	return out, req.Send()
}

// SetDefaultAuthorizerWithContext is the same as SetDefaultAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See SetDefaultAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetDefaultAuthorizerWithContext(ctx aws.Context, input *SetDefaultAuthorizerInput, opts ...request.Option) (*SetDefaultAuthorizerOutput, error) {
	req, out := c.SetDefaultAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDefaultPolicyVersion = "SetDefaultPolicyVersion"

// SetDefaultPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the SetDefaultPolicyVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetDefaultPolicyVersion for more information on using the SetDefaultPolicyVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetDefaultPolicyVersionRequest method.
//    req, resp := client.SetDefaultPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetDefaultPolicyVersionRequest(input *SetDefaultPolicyVersionInput) (req *request.Request, output *SetDefaultPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opSetDefaultPolicyVersion,
		HTTPMethod: "PATCH",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &SetDefaultPolicyVersionInput{}
	}

	output = &SetDefaultPolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetDefaultPolicyVersion API operation for AWS IoT.
//
// Sets the specified version of the specified policy as the policy's default
// (operative) version. This action affects all certificates to which the policy
// is attached. To list the principals the policy is attached to, use the ListPrincipalPolicy
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetDefaultPolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) SetDefaultPolicyVersion(input *SetDefaultPolicyVersionInput) (*SetDefaultPolicyVersionOutput, error) {
	req, out := c.SetDefaultPolicyVersionRequest(input)
	return out, req.Send()
}

// SetDefaultPolicyVersionWithContext is the same as SetDefaultPolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See SetDefaultPolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetDefaultPolicyVersionWithContext(ctx aws.Context, input *SetDefaultPolicyVersionInput, opts ...request.Option) (*SetDefaultPolicyVersionOutput, error) {
	req, out := c.SetDefaultPolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetLoggingOptions = "SetLoggingOptions"

// SetLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the SetLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetLoggingOptions for more information on using the SetLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetLoggingOptionsRequest method.
//    req, resp := client.SetLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetLoggingOptionsRequest(input *SetLoggingOptionsInput) (req *request.Request, output *SetLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opSetLoggingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/loggingOptions",
	}

	if input == nil {
		input = &SetLoggingOptionsInput{}
	}

	output = &SetLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetLoggingOptions API operation for AWS IoT.
//
// Sets the logging options.
//
// NOTE: use of this command is not recommended. Use SetV2LoggingOptions instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetLoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) SetLoggingOptions(input *SetLoggingOptionsInput) (*SetLoggingOptionsOutput, error) {
	req, out := c.SetLoggingOptionsRequest(input)
	return out, req.Send()
}

// SetLoggingOptionsWithContext is the same as SetLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See SetLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetLoggingOptionsWithContext(ctx aws.Context, input *SetLoggingOptionsInput, opts ...request.Option) (*SetLoggingOptionsOutput, error) {
	req, out := c.SetLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetV2LoggingLevel = "SetV2LoggingLevel"

// SetV2LoggingLevelRequest generates a "aws/request.Request" representing the
// client's request for the SetV2LoggingLevel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetV2LoggingLevel for more information on using the SetV2LoggingLevel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetV2LoggingLevelRequest method.
//    req, resp := client.SetV2LoggingLevelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetV2LoggingLevelRequest(input *SetV2LoggingLevelInput) (req *request.Request, output *SetV2LoggingLevelOutput) {
	op := &request.Operation{
		Name:       opSetV2LoggingLevel,
		HTTPMethod: "POST",
		HTTPPath:   "/v2LoggingLevel",
	}

	if input == nil {
		input = &SetV2LoggingLevelInput{}
	}

	output = &SetV2LoggingLevelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetV2LoggingLevel API operation for AWS IoT.
//
// Sets the logging level.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetV2LoggingLevel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeNotConfiguredException "NotConfiguredException"
//   The resource is not configured.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) SetV2LoggingLevel(input *SetV2LoggingLevelInput) (*SetV2LoggingLevelOutput, error) {
	req, out := c.SetV2LoggingLevelRequest(input)
	return out, req.Send()
}

// SetV2LoggingLevelWithContext is the same as SetV2LoggingLevel with the addition of
// the ability to pass a context and additional request options.
//
// See SetV2LoggingLevel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetV2LoggingLevelWithContext(ctx aws.Context, input *SetV2LoggingLevelInput, opts ...request.Option) (*SetV2LoggingLevelOutput, error) {
	req, out := c.SetV2LoggingLevelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetV2LoggingOptions = "SetV2LoggingOptions"

// SetV2LoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the SetV2LoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetV2LoggingOptions for more information on using the SetV2LoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetV2LoggingOptionsRequest method.
//    req, resp := client.SetV2LoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetV2LoggingOptionsRequest(input *SetV2LoggingOptionsInput) (req *request.Request, output *SetV2LoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opSetV2LoggingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/v2LoggingOptions",
	}

	if input == nil {
		input = &SetV2LoggingOptionsInput{}
	}

	output = &SetV2LoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetV2LoggingOptions API operation for AWS IoT.
//
// Sets the logging options for the V2 logging service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetV2LoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) SetV2LoggingOptions(input *SetV2LoggingOptionsInput) (*SetV2LoggingOptionsOutput, error) {
	req, out := c.SetV2LoggingOptionsRequest(input)
	return out, req.Send()
}

// SetV2LoggingOptionsWithContext is the same as SetV2LoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See SetV2LoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetV2LoggingOptionsWithContext(ctx aws.Context, input *SetV2LoggingOptionsInput, opts ...request.Option) (*SetV2LoggingOptionsOutput, error) {
	req, out := c.SetV2LoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartOnDemandAuditTask = "StartOnDemandAuditTask"

// StartOnDemandAuditTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartOnDemandAuditTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartOnDemandAuditTask for more information on using the StartOnDemandAuditTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartOnDemandAuditTaskRequest method.
//    req, resp := client.StartOnDemandAuditTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) StartOnDemandAuditTaskRequest(input *StartOnDemandAuditTaskInput) (req *request.Request, output *StartOnDemandAuditTaskOutput) {
	op := &request.Operation{
		Name:       opStartOnDemandAuditTask,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/tasks",
	}

	if input == nil {
		input = &StartOnDemandAuditTaskInput{}
	}

	output = &StartOnDemandAuditTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartOnDemandAuditTask API operation for AWS IoT.
//
// Starts an on-demand Device Defender audit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation StartOnDemandAuditTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) StartOnDemandAuditTask(input *StartOnDemandAuditTaskInput) (*StartOnDemandAuditTaskOutput, error) {
	req, out := c.StartOnDemandAuditTaskRequest(input)
	return out, req.Send()
}

// StartOnDemandAuditTaskWithContext is the same as StartOnDemandAuditTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartOnDemandAuditTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) StartOnDemandAuditTaskWithContext(ctx aws.Context, input *StartOnDemandAuditTaskInput, opts ...request.Option) (*StartOnDemandAuditTaskOutput, error) {
	req, out := c.StartOnDemandAuditTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartThingRegistrationTask = "StartThingRegistrationTask"

// StartThingRegistrationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartThingRegistrationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartThingRegistrationTask for more information on using the StartThingRegistrationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartThingRegistrationTaskRequest method.
//    req, resp := client.StartThingRegistrationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) StartThingRegistrationTaskRequest(input *StartThingRegistrationTaskInput) (req *request.Request, output *StartThingRegistrationTaskOutput) {
	op := &request.Operation{
		Name:       opStartThingRegistrationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-registration-tasks",
	}

	if input == nil {
		input = &StartThingRegistrationTaskInput{}
	}

	output = &StartThingRegistrationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartThingRegistrationTask API operation for AWS IoT.
//
// Creates a bulk thing provisioning task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation StartThingRegistrationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) StartThingRegistrationTask(input *StartThingRegistrationTaskInput) (*StartThingRegistrationTaskOutput, error) {
	req, out := c.StartThingRegistrationTaskRequest(input)
	return out, req.Send()
}

// StartThingRegistrationTaskWithContext is the same as StartThingRegistrationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartThingRegistrationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) StartThingRegistrationTaskWithContext(ctx aws.Context, input *StartThingRegistrationTaskInput, opts ...request.Option) (*StartThingRegistrationTaskOutput, error) {
	req, out := c.StartThingRegistrationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopThingRegistrationTask = "StopThingRegistrationTask"

// StopThingRegistrationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StopThingRegistrationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopThingRegistrationTask for more information on using the StopThingRegistrationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopThingRegistrationTaskRequest method.
//    req, resp := client.StopThingRegistrationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) StopThingRegistrationTaskRequest(input *StopThingRegistrationTaskInput) (req *request.Request, output *StopThingRegistrationTaskOutput) {
	op := &request.Operation{
		Name:       opStopThingRegistrationTask,
		HTTPMethod: "PUT",
		HTTPPath:   "/thing-registration-tasks/{taskId}/cancel",
	}

	if input == nil {
		input = &StopThingRegistrationTaskInput{}
	}

	output = &StopThingRegistrationTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopThingRegistrationTask API operation for AWS IoT.
//
// Cancels a bulk thing provisioning task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation StopThingRegistrationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) StopThingRegistrationTask(input *StopThingRegistrationTaskInput) (*StopThingRegistrationTaskOutput, error) {
	req, out := c.StopThingRegistrationTaskRequest(input)
	return out, req.Send()
}

// StopThingRegistrationTaskWithContext is the same as StopThingRegistrationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StopThingRegistrationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) StopThingRegistrationTaskWithContext(ctx aws.Context, input *StopThingRegistrationTaskInput, opts ...request.Option) (*StopThingRegistrationTaskOutput, error) {
	req, out := c.StopThingRegistrationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT.
//
// Adds to or modifies the tags of the given resource. Tags are metadata which
// can be used to manage a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestAuthorization = "TestAuthorization"

// TestAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the TestAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestAuthorization for more information on using the TestAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestAuthorizationRequest method.
//    req, resp := client.TestAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) TestAuthorizationRequest(input *TestAuthorizationInput) (req *request.Request, output *TestAuthorizationOutput) {
	op := &request.Operation{
		Name:       opTestAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/test-authorization",
	}

	if input == nil {
		input = &TestAuthorizationInput{}
	}

	output = &TestAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestAuthorization API operation for AWS IoT.
//
// Tests if a specified principal is authorized to perform an AWS IoT action
// on a specified resource. Use this to test and debug the authorization behavior
// of devices that connect to the AWS IoT device gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation TestAuthorization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
func (c *IoT) TestAuthorization(input *TestAuthorizationInput) (*TestAuthorizationOutput, error) {
	req, out := c.TestAuthorizationRequest(input)
	return out, req.Send()
}

// TestAuthorizationWithContext is the same as TestAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See TestAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) TestAuthorizationWithContext(ctx aws.Context, input *TestAuthorizationInput, opts ...request.Option) (*TestAuthorizationOutput, error) {
	req, out := c.TestAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestInvokeAuthorizer = "TestInvokeAuthorizer"

// TestInvokeAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the TestInvokeAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestInvokeAuthorizer for more information on using the TestInvokeAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestInvokeAuthorizerRequest method.
//    req, resp := client.TestInvokeAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) TestInvokeAuthorizerRequest(input *TestInvokeAuthorizerInput) (req *request.Request, output *TestInvokeAuthorizerOutput) {
	op := &request.Operation{
		Name:       opTestInvokeAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/authorizer/{authorizerName}/test",
	}

	if input == nil {
		input = &TestInvokeAuthorizerInput{}
	}

	output = &TestInvokeAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestInvokeAuthorizer API operation for AWS IoT.
//
// Tests a custom authorization behavior by invoking a specified custom authorizer.
// Use this to test and debug the custom authorization behavior of devices that
// connect to the AWS IoT device gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation TestInvokeAuthorizer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidResponseException "InvalidResponseException"
//   The response is invalid.
//
func (c *IoT) TestInvokeAuthorizer(input *TestInvokeAuthorizerInput) (*TestInvokeAuthorizerOutput, error) {
	req, out := c.TestInvokeAuthorizerRequest(input)
	return out, req.Send()
}

// TestInvokeAuthorizerWithContext is the same as TestInvokeAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See TestInvokeAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) TestInvokeAuthorizerWithContext(ctx aws.Context, input *TestInvokeAuthorizerInput, opts ...request.Option) (*TestInvokeAuthorizerOutput, error) {
	req, out := c.TestInvokeAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTransferCertificate = "TransferCertificate"

// TransferCertificateRequest generates a "aws/request.Request" representing the
// client's request for the TransferCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TransferCertificate for more information on using the TransferCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TransferCertificateRequest method.
//    req, resp := client.TransferCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) TransferCertificateRequest(input *TransferCertificateInput) (req *request.Request, output *TransferCertificateOutput) {
	op := &request.Operation{
		Name:       opTransferCertificate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/transfer-certificate/{certificateId}",
	}

	if input == nil {
		input = &TransferCertificateInput{}
	}

	output = &TransferCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TransferCertificate API operation for AWS IoT.
//
// Transfers the specified certificate to the specified AWS account.
//
// You can cancel the transfer until it is acknowledged by the recipient.
//
// No notification is sent to the transfer destination's account. It is up to
// the caller to notify the transfer target.
//
// The certificate being transferred must not be in the ACTIVE state. You can
// use the UpdateCertificate API to deactivate it.
//
// The certificate must not have any policies attached to it. You can use the
// DetachPrincipalPolicy API to detach them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation TransferCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeTransferConflictException "TransferConflictException"
//   You can't transfer the certificate because authorization policies are still
//   attached.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) TransferCertificate(input *TransferCertificateInput) (*TransferCertificateOutput, error) {
	req, out := c.TransferCertificateRequest(input)
	return out, req.Send()
}

// TransferCertificateWithContext is the same as TransferCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See TransferCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) TransferCertificateWithContext(ctx aws.Context, input *TransferCertificateInput, opts ...request.Option) (*TransferCertificateOutput, error) {
	req, out := c.TransferCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/untag",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT.
//
// Removes the given tags (metadata) from the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
func (c *IoT) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountAuditConfiguration = "UpdateAccountAuditConfiguration"

// UpdateAccountAuditConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountAuditConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountAuditConfiguration for more information on using the UpdateAccountAuditConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccountAuditConfigurationRequest method.
//    req, resp := client.UpdateAccountAuditConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateAccountAuditConfigurationRequest(input *UpdateAccountAuditConfigurationInput) (req *request.Request, output *UpdateAccountAuditConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountAuditConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/audit/configuration",
	}

	if input == nil {
		input = &UpdateAccountAuditConfigurationInput{}
	}

	output = &UpdateAccountAuditConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAccountAuditConfiguration API operation for AWS IoT.
//
// Configures or reconfigures the Device Defender audit settings for this account.
// Settings include how audit notifications are sent and which audit checks
// are enabled or disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateAccountAuditConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateAccountAuditConfiguration(input *UpdateAccountAuditConfigurationInput) (*UpdateAccountAuditConfigurationOutput, error) {
	req, out := c.UpdateAccountAuditConfigurationRequest(input)
	return out, req.Send()
}

// UpdateAccountAuditConfigurationWithContext is the same as UpdateAccountAuditConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountAuditConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateAccountAuditConfigurationWithContext(ctx aws.Context, input *UpdateAccountAuditConfigurationInput, opts ...request.Option) (*UpdateAccountAuditConfigurationOutput, error) {
	req, out := c.UpdateAccountAuditConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAuthorizer = "UpdateAuthorizer"

// UpdateAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAuthorizer for more information on using the UpdateAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAuthorizerRequest method.
//    req, resp := client.UpdateAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateAuthorizerRequest(input *UpdateAuthorizerInput) (req *request.Request, output *UpdateAuthorizerOutput) {
	op := &request.Operation{
		Name:       opUpdateAuthorizer,
		HTTPMethod: "PUT",
		HTTPPath:   "/authorizer/{authorizerName}",
	}

	if input == nil {
		input = &UpdateAuthorizerInput{}
	}

	output = &UpdateAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAuthorizer API operation for AWS IoT.
//
// Updates an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateAuthorizer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit has been exceeded.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateAuthorizer(input *UpdateAuthorizerInput) (*UpdateAuthorizerOutput, error) {
	req, out := c.UpdateAuthorizerRequest(input)
	return out, req.Send()
}

// UpdateAuthorizerWithContext is the same as UpdateAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateAuthorizerWithContext(ctx aws.Context, input *UpdateAuthorizerInput, opts ...request.Option) (*UpdateAuthorizerOutput, error) {
	req, out := c.UpdateAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBillingGroup = "UpdateBillingGroup"

// UpdateBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBillingGroup for more information on using the UpdateBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBillingGroupRequest method.
//    req, resp := client.UpdateBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateBillingGroupRequest(input *UpdateBillingGroupInput) (req *request.Request, output *UpdateBillingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateBillingGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/billing-groups/{billingGroupName}",
	}

	if input == nil {
		input = &UpdateBillingGroupInput{}
	}

	output = &UpdateBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBillingGroup API operation for AWS IoT.
//
// Updates information about the billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateBillingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) UpdateBillingGroup(input *UpdateBillingGroupInput) (*UpdateBillingGroupOutput, error) {
	req, out := c.UpdateBillingGroupRequest(input)
	return out, req.Send()
}

// UpdateBillingGroupWithContext is the same as UpdateBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateBillingGroupWithContext(ctx aws.Context, input *UpdateBillingGroupInput, opts ...request.Option) (*UpdateBillingGroupOutput, error) {
	req, out := c.UpdateBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCACertificate = "UpdateCACertificate"

// UpdateCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCACertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCACertificate for more information on using the UpdateCACertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCACertificateRequest method.
//    req, resp := client.UpdateCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateCACertificateRequest(input *UpdateCACertificateInput) (req *request.Request, output *UpdateCACertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateCACertificate,
		HTTPMethod: "PUT",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &UpdateCACertificateInput{}
	}

	output = &UpdateCACertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCACertificate API operation for AWS IoT.
//
// Updates a registered CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateCACertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateCACertificate(input *UpdateCACertificateInput) (*UpdateCACertificateOutput, error) {
	req, out := c.UpdateCACertificateRequest(input)
	return out, req.Send()
}

// UpdateCACertificateWithContext is the same as UpdateCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateCACertificateWithContext(ctx aws.Context, input *UpdateCACertificateInput, opts ...request.Option) (*UpdateCACertificateOutput, error) {
	req, out := c.UpdateCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCertificate = "UpdateCertificate"

// UpdateCertificateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCertificate for more information on using the UpdateCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCertificateRequest method.
//    req, resp := client.UpdateCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateCertificateRequest(input *UpdateCertificateInput) (req *request.Request, output *UpdateCertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateCertificate,
		HTTPMethod: "PUT",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &UpdateCertificateInput{}
	}

	output = &UpdateCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCertificate API operation for AWS IoT.
//
// Updates the status of the specified certificate. This operation is idempotent.
//
// Moving a certificate from the ACTIVE state (including REVOKED) will not disconnect
// currently connected devices, but these devices will be unable to reconnect.
//
// The ACTIVE state is required to authenticate devices connecting to AWS IoT
// using a certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateCertificate(input *UpdateCertificateInput) (*UpdateCertificateOutput, error) {
	req, out := c.UpdateCertificateRequest(input)
	return out, req.Send()
}

// UpdateCertificateWithContext is the same as UpdateCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateCertificateWithContext(ctx aws.Context, input *UpdateCertificateInput, opts ...request.Option) (*UpdateCertificateOutput, error) {
	req, out := c.UpdateCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDynamicThingGroup = "UpdateDynamicThingGroup"

// UpdateDynamicThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDynamicThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDynamicThingGroup for more information on using the UpdateDynamicThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDynamicThingGroupRequest method.
//    req, resp := client.UpdateDynamicThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateDynamicThingGroupRequest(input *UpdateDynamicThingGroupInput) (req *request.Request, output *UpdateDynamicThingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateDynamicThingGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/dynamic-thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &UpdateDynamicThingGroupInput{}
	}

	output = &UpdateDynamicThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDynamicThingGroup API operation for AWS IoT.
//
// Updates a dynamic thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateDynamicThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidQueryException "InvalidQueryException"
//   The query is invalid.
//
func (c *IoT) UpdateDynamicThingGroup(input *UpdateDynamicThingGroupInput) (*UpdateDynamicThingGroupOutput, error) {
	req, out := c.UpdateDynamicThingGroupRequest(input)
	return out, req.Send()
}

// UpdateDynamicThingGroupWithContext is the same as UpdateDynamicThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDynamicThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateDynamicThingGroupWithContext(ctx aws.Context, input *UpdateDynamicThingGroupInput, opts ...request.Option) (*UpdateDynamicThingGroupOutput, error) {
	req, out := c.UpdateDynamicThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventConfigurations = "UpdateEventConfigurations"

// UpdateEventConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventConfigurations for more information on using the UpdateEventConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEventConfigurationsRequest method.
//    req, resp := client.UpdateEventConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateEventConfigurationsRequest(input *UpdateEventConfigurationsInput) (req *request.Request, output *UpdateEventConfigurationsOutput) {
	op := &request.Operation{
		Name:       opUpdateEventConfigurations,
		HTTPMethod: "PATCH",
		HTTPPath:   "/event-configurations",
	}

	if input == nil {
		input = &UpdateEventConfigurationsInput{}
	}

	output = &UpdateEventConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEventConfigurations API operation for AWS IoT.
//
// Updates the event configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateEventConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
func (c *IoT) UpdateEventConfigurations(input *UpdateEventConfigurationsInput) (*UpdateEventConfigurationsOutput, error) {
	req, out := c.UpdateEventConfigurationsRequest(input)
	return out, req.Send()
}

// UpdateEventConfigurationsWithContext is the same as UpdateEventConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateEventConfigurationsWithContext(ctx aws.Context, input *UpdateEventConfigurationsInput, opts ...request.Option) (*UpdateEventConfigurationsOutput, error) {
	req, out := c.UpdateEventConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIndexingConfiguration = "UpdateIndexingConfiguration"

// UpdateIndexingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIndexingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIndexingConfiguration for more information on using the UpdateIndexingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIndexingConfigurationRequest method.
//    req, resp := client.UpdateIndexingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateIndexingConfigurationRequest(input *UpdateIndexingConfigurationInput) (req *request.Request, output *UpdateIndexingConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateIndexingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/indexing/config",
	}

	if input == nil {
		input = &UpdateIndexingConfigurationInput{}
	}

	output = &UpdateIndexingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIndexingConfiguration API operation for AWS IoT.
//
// Updates the search configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateIndexingConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateIndexingConfiguration(input *UpdateIndexingConfigurationInput) (*UpdateIndexingConfigurationOutput, error) {
	req, out := c.UpdateIndexingConfigurationRequest(input)
	return out, req.Send()
}

// UpdateIndexingConfigurationWithContext is the same as UpdateIndexingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIndexingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateIndexingConfigurationWithContext(ctx aws.Context, input *UpdateIndexingConfigurationInput, opts ...request.Option) (*UpdateIndexingConfigurationOutput, error) {
	req, out := c.UpdateIndexingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJob = "UpdateJob"

// UpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJob for more information on using the UpdateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobRequest method.
//    req, resp := client.UpdateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateJobRequest(input *UpdateJobInput) (req *request.Request, output *UpdateJobOutput) {
	op := &request.Operation{
		Name:       opUpdateJob,
		HTTPMethod: "PATCH",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &UpdateJobInput{}
	}

	output = &UpdateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateJob API operation for AWS IoT.
//
// Updates supported fields of the specified job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) UpdateJob(input *UpdateJobInput) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	return out, req.Send()
}

// UpdateJobWithContext is the same as UpdateJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateJobWithContext(ctx aws.Context, input *UpdateJobInput, opts ...request.Option) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoleAlias = "UpdateRoleAlias"

// UpdateRoleAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoleAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoleAlias for more information on using the UpdateRoleAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRoleAliasRequest method.
//    req, resp := client.UpdateRoleAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateRoleAliasRequest(input *UpdateRoleAliasInput) (req *request.Request, output *UpdateRoleAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateRoleAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/role-aliases/{roleAlias}",
	}

	if input == nil {
		input = &UpdateRoleAliasInput{}
	}

	output = &UpdateRoleAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoleAlias API operation for AWS IoT.
//
// Updates a role alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateRoleAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateRoleAlias(input *UpdateRoleAliasInput) (*UpdateRoleAliasOutput, error) {
	req, out := c.UpdateRoleAliasRequest(input)
	return out, req.Send()
}

// UpdateRoleAliasWithContext is the same as UpdateRoleAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoleAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateRoleAliasWithContext(ctx aws.Context, input *UpdateRoleAliasInput, opts ...request.Option) (*UpdateRoleAliasOutput, error) {
	req, out := c.UpdateRoleAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateScheduledAudit = "UpdateScheduledAudit"

// UpdateScheduledAuditRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScheduledAudit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateScheduledAudit for more information on using the UpdateScheduledAudit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateScheduledAuditRequest method.
//    req, resp := client.UpdateScheduledAuditRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateScheduledAuditRequest(input *UpdateScheduledAuditInput) (req *request.Request, output *UpdateScheduledAuditOutput) {
	op := &request.Operation{
		Name:       opUpdateScheduledAudit,
		HTTPMethod: "PATCH",
		HTTPPath:   "/audit/scheduledaudits/{scheduledAuditName}",
	}

	if input == nil {
		input = &UpdateScheduledAuditInput{}
	}

	output = &UpdateScheduledAuditOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateScheduledAudit API operation for AWS IoT.
//
// Updates a scheduled audit, including what checks are performed and how often
// the audit takes place.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateScheduledAudit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateScheduledAudit(input *UpdateScheduledAuditInput) (*UpdateScheduledAuditOutput, error) {
	req, out := c.UpdateScheduledAuditRequest(input)
	return out, req.Send()
}

// UpdateScheduledAuditWithContext is the same as UpdateScheduledAudit with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateScheduledAudit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateScheduledAuditWithContext(ctx aws.Context, input *UpdateScheduledAuditInput, opts ...request.Option) (*UpdateScheduledAuditOutput, error) {
	req, out := c.UpdateScheduledAuditRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecurityProfile = "UpdateSecurityProfile"

// UpdateSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecurityProfile for more information on using the UpdateSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSecurityProfileRequest method.
//    req, resp := client.UpdateSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateSecurityProfileRequest(input *UpdateSecurityProfileInput) (req *request.Request, output *UpdateSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateSecurityProfile,
		HTTPMethod: "PATCH",
		HTTPPath:   "/security-profiles/{securityProfileName}",
	}

	if input == nil {
		input = &UpdateSecurityProfileInput{}
	}

	output = &UpdateSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSecurityProfile API operation for AWS IoT.
//
// Updates a Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateSecurityProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateSecurityProfile(input *UpdateSecurityProfileInput) (*UpdateSecurityProfileOutput, error) {
	req, out := c.UpdateSecurityProfileRequest(input)
	return out, req.Send()
}

// UpdateSecurityProfileWithContext is the same as UpdateSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateSecurityProfileWithContext(ctx aws.Context, input *UpdateSecurityProfileInput, opts ...request.Option) (*UpdateSecurityProfileOutput, error) {
	req, out := c.UpdateSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStream = "UpdateStream"

// UpdateStreamRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStream for more information on using the UpdateStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStreamRequest method.
//    req, resp := client.UpdateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateStreamRequest(input *UpdateStreamInput) (req *request.Request, output *UpdateStreamOutput) {
	op := &request.Operation{
		Name:       opUpdateStream,
		HTTPMethod: "PUT",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &UpdateStreamInput{}
	}

	output = &UpdateStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStream API operation for AWS IoT.
//
// Updates an existing stream. The stream version will be incremented by one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateStream(input *UpdateStreamInput) (*UpdateStreamOutput, error) {
	req, out := c.UpdateStreamRequest(input)
	return out, req.Send()
}

// UpdateStreamWithContext is the same as UpdateStream with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateStreamWithContext(ctx aws.Context, input *UpdateStreamInput, opts ...request.Option) (*UpdateStreamOutput, error) {
	req, out := c.UpdateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThing = "UpdateThing"

// UpdateThingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThing for more information on using the UpdateThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThingRequest method.
//    req, resp := client.UpdateThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateThingRequest(input *UpdateThingInput) (req *request.Request, output *UpdateThingOutput) {
	op := &request.Operation{
		Name:       opUpdateThing,
		HTTPMethod: "PATCH",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &UpdateThingInput{}
	}

	output = &UpdateThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateThing API operation for AWS IoT.
//
// Updates the data for a thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) UpdateThing(input *UpdateThingInput) (*UpdateThingOutput, error) {
	req, out := c.UpdateThingRequest(input)
	return out, req.Send()
}

// UpdateThingWithContext is the same as UpdateThing with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateThingWithContext(ctx aws.Context, input *UpdateThingInput, opts ...request.Option) (*UpdateThingOutput, error) {
	req, out := c.UpdateThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThingGroup = "UpdateThingGroup"

// UpdateThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThingGroup for more information on using the UpdateThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThingGroupRequest method.
//    req, resp := client.UpdateThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateThingGroupRequest(input *UpdateThingGroupInput) (req *request.Request, output *UpdateThingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateThingGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &UpdateThingGroupInput{}
	}

	output = &UpdateThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThingGroup API operation for AWS IoT.
//
// Update a thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateThingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) UpdateThingGroup(input *UpdateThingGroupInput) (*UpdateThingGroupOutput, error) {
	req, out := c.UpdateThingGroupRequest(input)
	return out, req.Send()
}

// UpdateThingGroupWithContext is the same as UpdateThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateThingGroupWithContext(ctx aws.Context, input *UpdateThingGroupInput, opts ...request.Option) (*UpdateThingGroupOutput, error) {
	req, out := c.UpdateThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThingGroupsForThing = "UpdateThingGroupsForThing"

// UpdateThingGroupsForThingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThingGroupsForThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThingGroupsForThing for more information on using the UpdateThingGroupsForThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThingGroupsForThingRequest method.
//    req, resp := client.UpdateThingGroupsForThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateThingGroupsForThingRequest(input *UpdateThingGroupsForThingInput) (req *request.Request, output *UpdateThingGroupsForThingOutput) {
	op := &request.Operation{
		Name:       opUpdateThingGroupsForThing,
		HTTPMethod: "PUT",
		HTTPPath:   "/thing-groups/updateThingGroupsForThing",
	}

	if input == nil {
		input = &UpdateThingGroupsForThingInput{}
	}

	output = &UpdateThingGroupsForThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateThingGroupsForThing API operation for AWS IoT.
//
// Updates the groups to which the thing belongs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateThingGroupsForThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) UpdateThingGroupsForThing(input *UpdateThingGroupsForThingInput) (*UpdateThingGroupsForThingOutput, error) {
	req, out := c.UpdateThingGroupsForThingRequest(input)
	return out, req.Send()
}

// UpdateThingGroupsForThingWithContext is the same as UpdateThingGroupsForThing with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThingGroupsForThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateThingGroupsForThingWithContext(ctx aws.Context, input *UpdateThingGroupsForThingInput, opts ...request.Option) (*UpdateThingGroupsForThingOutput, error) {
	req, out := c.UpdateThingGroupsForThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateSecurityProfileBehaviors = "ValidateSecurityProfileBehaviors"

// ValidateSecurityProfileBehaviorsRequest generates a "aws/request.Request" representing the
// client's request for the ValidateSecurityProfileBehaviors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateSecurityProfileBehaviors for more information on using the ValidateSecurityProfileBehaviors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ValidateSecurityProfileBehaviorsRequest method.
//    req, resp := client.ValidateSecurityProfileBehaviorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ValidateSecurityProfileBehaviorsRequest(input *ValidateSecurityProfileBehaviorsInput) (req *request.Request, output *ValidateSecurityProfileBehaviorsOutput) {
	op := &request.Operation{
		Name:       opValidateSecurityProfileBehaviors,
		HTTPMethod: "POST",
		HTTPPath:   "/security-profile-behaviors/validate",
	}

	if input == nil {
		input = &ValidateSecurityProfileBehaviorsInput{}
	}

	output = &ValidateSecurityProfileBehaviorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateSecurityProfileBehaviors API operation for AWS IoT.
//
// Validates a Device Defender security profile behaviors specification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ValidateSecurityProfileBehaviors for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ValidateSecurityProfileBehaviors(input *ValidateSecurityProfileBehaviorsInput) (*ValidateSecurityProfileBehaviorsOutput, error) {
	req, out := c.ValidateSecurityProfileBehaviorsRequest(input)
	return out, req.Send()
}

// ValidateSecurityProfileBehaviorsWithContext is the same as ValidateSecurityProfileBehaviors with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateSecurityProfileBehaviors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ValidateSecurityProfileBehaviorsWithContext(ctx aws.Context, input *ValidateSecurityProfileBehaviorsInput, opts ...request.Option) (*ValidateSecurityProfileBehaviorsOutput, error) {
	req, out := c.ValidateSecurityProfileBehaviorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Details of abort criteria to abort the job.
type AbortConfig struct {
	_ struct{} `type:"structure"`

	// The list of abort criteria to define rules to abort the job.
	//
	// CriteriaList is a required field
	CriteriaList []*AbortCriteria `locationName:"criteriaList" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AbortConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortConfig"}
	if s.CriteriaList == nil {
		invalidParams.Add(request.NewErrParamRequired("CriteriaList"))
	}
	if s.CriteriaList != nil && len(s.CriteriaList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CriteriaList", 1))
	}
	if s.CriteriaList != nil {
		for i, v := range s.CriteriaList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CriteriaList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCriteriaList sets the CriteriaList field's value.
func (s *AbortConfig) SetCriteriaList(v []*AbortCriteria) *AbortConfig {
	s.CriteriaList = v
	return s
}

// Details of abort criteria to define rules to abort the job.
type AbortCriteria struct {
	_ struct{} `type:"structure"`

	// The type of abort action to initiate a job abort.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"AbortAction"`

	// The type of job execution failure to define a rule to initiate a job abort.
	//
	// FailureType is a required field
	FailureType *string `locationName:"failureType" type:"string" required:"true" enum:"JobExecutionFailureType"`

	// Minimum number of executed things before evaluating an abort rule.
	//
	// MinNumberOfExecutedThings is a required field
	MinNumberOfExecutedThings *int64 `locationName:"minNumberOfExecutedThings" min:"1" type:"integer" required:"true"`

	// The threshold as a percentage of the total number of executed things that
	// will initiate a job abort.
	//
	// AWS IoT supports up to two digits after the decimal (for example, 10.9 and
	// 10.99, but not 10.999).
	//
	// ThresholdPercentage is a required field
	ThresholdPercentage *float64 `locationName:"thresholdPercentage" type:"double" required:"true"`
}

// String returns the string representation
func (s AbortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortCriteria"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.FailureType == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureType"))
	}
	if s.MinNumberOfExecutedThings == nil {
		invalidParams.Add(request.NewErrParamRequired("MinNumberOfExecutedThings"))
	}
	if s.MinNumberOfExecutedThings != nil && *s.MinNumberOfExecutedThings < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinNumberOfExecutedThings", 1))
	}
	if s.ThresholdPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("ThresholdPercentage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *AbortCriteria) SetAction(v string) *AbortCriteria {
	s.Action = &v
	return s
}

// SetFailureType sets the FailureType field's value.
func (s *AbortCriteria) SetFailureType(v string) *AbortCriteria {
	s.FailureType = &v
	return s
}

// SetMinNumberOfExecutedThings sets the MinNumberOfExecutedThings field's value.
func (s *AbortCriteria) SetMinNumberOfExecutedThings(v int64) *AbortCriteria {
	s.MinNumberOfExecutedThings = &v
	return s
}

// SetThresholdPercentage sets the ThresholdPercentage field's value.
func (s *AbortCriteria) SetThresholdPercentage(v float64) *AbortCriteria {
	s.ThresholdPercentage = &v
	return s
}

// The input for the AcceptCertificateTransfer operation.
type AcceptCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s AcceptCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptCertificateTransferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptCertificateTransferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptCertificateTransferInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *AcceptCertificateTransferInput) SetCertificateId(v string) *AcceptCertificateTransferInput {
	s.CertificateId = &v
	return s
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *AcceptCertificateTransferInput) SetSetAsActive(v bool) *AcceptCertificateTransferInput {
	s.SetAsActive = &v
	return s
}

type AcceptCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptCertificateTransferOutput) GoString() string {
	return s.String()
}

// Describes the actions associated with a rule.
type Action struct {
	_ struct{} `type:"structure"`

	// Change the state of a CloudWatch alarm.
	CloudwatchAlarm *CloudwatchAlarmAction `locationName:"cloudwatchAlarm" type:"structure"`

	// Capture a CloudWatch metric.
	CloudwatchMetric *CloudwatchMetricAction `locationName:"cloudwatchMetric" type:"structure"`

	// Write to a DynamoDB table.
	DynamoDB *DynamoDBAction `locationName:"dynamoDB" type:"structure"`

	// Write to a DynamoDB table. This is a new version of the DynamoDB action.
	// It allows you to write each attribute in an MQTT message payload into a separate
	// DynamoDB column.
	DynamoDBv2 *DynamoDBv2Action `locationName:"dynamoDBv2" type:"structure"`

	// Write data to an Amazon Elasticsearch Service domain.
	Elasticsearch *ElasticsearchAction `locationName:"elasticsearch" type:"structure"`

	// Write to an Amazon Kinesis Firehose stream.
	Firehose *FirehoseAction `locationName:"firehose" type:"structure"`

	// Sends message data to an AWS IoT Analytics channel.
	IotAnalytics *IotAnalyticsAction `locationName:"iotAnalytics" type:"structure"`

	// Sends an input to an AWS IoT Events detector.
	IotEvents *IotEventsAction `locationName:"iotEvents" type:"structure"`

	// Write data to an Amazon Kinesis stream.
	Kinesis *KinesisAction `locationName:"kinesis" type:"structure"`

	// Invoke a Lambda function.
	Lambda *LambdaAction `locationName:"lambda" type:"structure"`

	// Publish to another MQTT topic.
	Republish *RepublishAction `locationName:"republish" type:"structure"`

	// Write to an Amazon S3 bucket.
	S3 *S3Action `locationName:"s3" type:"structure"`

	// Send a message to a Salesforce IoT Cloud Input Stream.
	Salesforce *SalesforceAction `locationName:"salesforce" type:"structure"`

	// Publish to an Amazon SNS topic.
	Sns *SnsAction `locationName:"sns" type:"structure"`

	// Publish to an Amazon SQS queue.
	Sqs *SqsAction `locationName:"sqs" type:"structure"`

	// Starts execution of a Step Functions state machine.
	StepFunctions *StepFunctionsAction `locationName:"stepFunctions" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.CloudwatchAlarm != nil {
		if err := s.CloudwatchAlarm.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchAlarm", err.(request.ErrInvalidParams))
		}
	}
	if s.CloudwatchMetric != nil {
		if err := s.CloudwatchMetric.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchMetric", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamoDB != nil {
		if err := s.DynamoDB.Validate(); err != nil {
			invalidParams.AddNested("DynamoDB", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamoDBv2 != nil {
		if err := s.DynamoDBv2.Validate(); err != nil {
			invalidParams.AddNested("DynamoDBv2", err.(request.ErrInvalidParams))
		}
	}
	if s.Elasticsearch != nil {
		if err := s.Elasticsearch.Validate(); err != nil {
			invalidParams.AddNested("Elasticsearch", err.(request.ErrInvalidParams))
		}
	}
	if s.Firehose != nil {
		if err := s.Firehose.Validate(); err != nil {
			invalidParams.AddNested("Firehose", err.(request.ErrInvalidParams))
		}
	}
	if s.IotEvents != nil {
		if err := s.IotEvents.Validate(); err != nil {
			invalidParams.AddNested("IotEvents", err.(request.ErrInvalidParams))
		}
	}
	if s.Kinesis != nil {
		if err := s.Kinesis.Validate(); err != nil {
			invalidParams.AddNested("Kinesis", err.(request.ErrInvalidParams))
		}
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(request.ErrInvalidParams))
		}
	}
	if s.Republish != nil {
		if err := s.Republish.Validate(); err != nil {
			invalidParams.AddNested("Republish", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}
	if s.Salesforce != nil {
		if err := s.Salesforce.Validate(); err != nil {
			invalidParams.AddNested("Salesforce", err.(request.ErrInvalidParams))
		}
	}
	if s.Sns != nil {
		if err := s.Sns.Validate(); err != nil {
			invalidParams.AddNested("Sns", err.(request.ErrInvalidParams))
		}
	}
	if s.Sqs != nil {
		if err := s.Sqs.Validate(); err != nil {
			invalidParams.AddNested("Sqs", err.(request.ErrInvalidParams))
		}
	}
	if s.StepFunctions != nil {
		if err := s.StepFunctions.Validate(); err != nil {
			invalidParams.AddNested("StepFunctions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudwatchAlarm sets the CloudwatchAlarm field's value.
func (s *Action) SetCloudwatchAlarm(v *CloudwatchAlarmAction) *Action {
	s.CloudwatchAlarm = v
	return s
}

// SetCloudwatchMetric sets the CloudwatchMetric field's value.
func (s *Action) SetCloudwatchMetric(v *CloudwatchMetricAction) *Action {
	s.CloudwatchMetric = v
	return s
}

// SetDynamoDB sets the DynamoDB field's value.
func (s *Action) SetDynamoDB(v *DynamoDBAction) *Action {
	s.DynamoDB = v
	return s
}

// SetDynamoDBv2 sets the DynamoDBv2 field's value.
func (s *Action) SetDynamoDBv2(v *DynamoDBv2Action) *Action {
	s.DynamoDBv2 = v
	return s
}

// SetElasticsearch sets the Elasticsearch field's value.
func (s *Action) SetElasticsearch(v *ElasticsearchAction) *Action {
	s.Elasticsearch = v
	return s
}

// SetFirehose sets the Firehose field's value.
func (s *Action) SetFirehose(v *FirehoseAction) *Action {
	s.Firehose = v
	return s
}

// SetIotAnalytics sets the IotAnalytics field's value.
func (s *Action) SetIotAnalytics(v *IotAnalyticsAction) *Action {
	s.IotAnalytics = v
	return s
}

// SetIotEvents sets the IotEvents field's value.
func (s *Action) SetIotEvents(v *IotEventsAction) *Action {
	s.IotEvents = v
	return s
}

// SetKinesis sets the Kinesis field's value.
func (s *Action) SetKinesis(v *KinesisAction) *Action {
	s.Kinesis = v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *Action) SetLambda(v *LambdaAction) *Action {
	s.Lambda = v
	return s
}

// SetRepublish sets the Republish field's value.
func (s *Action) SetRepublish(v *RepublishAction) *Action {
	s.Republish = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *Action) SetS3(v *S3Action) *Action {
	s.S3 = v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *Action) SetSalesforce(v *SalesforceAction) *Action {
	s.Salesforce = v
	return s
}

// SetSns sets the Sns field's value.
func (s *Action) SetSns(v *SnsAction) *Action {
	s.Sns = v
	return s
}

// SetSqs sets the Sqs field's value.
func (s *Action) SetSqs(v *SqsAction) *Action {
	s.Sqs = v
	return s
}

// SetStepFunctions sets the StepFunctions field's value.
func (s *Action) SetStepFunctions(v *StepFunctionsAction) *Action {
	s.StepFunctions = v
	return s
}

// Information about an active Device Defender security profile behavior violation.
type ActiveViolation struct {
	_ struct{} `type:"structure"`

	// The behavior which is being violated.
	Behavior *Behavior `locationName:"behavior" type:"structure"`

	// The time the most recent violation occurred.
	LastViolationTime *time.Time `locationName:"lastViolationTime" type:"timestamp"`

	// The value of the metric (the measurement) which caused the most recent violation.
	LastViolationValue *MetricValue `locationName:"lastViolationValue" type:"structure"`

	// The security profile whose behavior is in violation.
	SecurityProfileName *string `locationName:"securityProfileName" min:"1" type:"string"`

	// The name of the thing responsible for the active violation.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`

	// The ID of the active violation.
	ViolationId *string `locationName:"violationId" min:"1" type:"string"`

	// The time the violation started.
	ViolationStartTime *time.Time `locationName:"violationStartTime" type:"timestamp"`
}

// String returns the string representation
func (s ActiveViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveViolation) GoString() string {
	return s.String()
}

// SetBehavior sets the Behavior field's value.
func (s *ActiveViolation) SetBehavior(v *Behavior) *ActiveViolation {
	s.Behavior = v
	return s
}

// SetLastViolationTime sets the LastViolationTime field's value.
func (s *ActiveViolation) SetLastViolationTime(v time.Time) *ActiveViolation {
	s.LastViolationTime = &v
	return s
}

// SetLastViolationValue sets the LastViolationValue field's value.
func (s *ActiveViolation) SetLastViolationValue(v *MetricValue) *ActiveViolation {
	s.LastViolationValue = v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *ActiveViolation) SetSecurityProfileName(v string) *ActiveViolation {
	s.SecurityProfileName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *ActiveViolation) SetThingName(v string) *ActiveViolation {
	s.ThingName = &v
	return s
}

// SetViolationId sets the ViolationId field's value.
func (s *ActiveViolation) SetViolationId(v string) *ActiveViolation {
	s.ViolationId = &v
	return s
}

// SetViolationStartTime sets the ViolationStartTime field's value.
func (s *ActiveViolation) SetViolationStartTime(v time.Time) *ActiveViolation {
	s.ViolationStartTime = &v
	return s
}

type AddThingToBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the billing group.
	BillingGroupArn *string `locationName:"billingGroupArn" type:"string"`

	// The name of the billing group.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`

	// The ARN of the thing to be added to the billing group.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The name of the thing to be added to the billing group.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s AddThingToBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddThingToBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddThingToBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddThingToBillingGroupInput"}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *AddThingToBillingGroupInput) SetBillingGroupArn(v string) *AddThingToBillingGroupInput {
	s.BillingGroupArn = &v
	return s
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *AddThingToBillingGroupInput) SetBillingGroupName(v string) *AddThingToBillingGroupInput {
	s.BillingGroupName = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *AddThingToBillingGroupInput) SetThingArn(v string) *AddThingToBillingGroupInput {
	s.ThingArn = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AddThingToBillingGroupInput) SetThingName(v string) *AddThingToBillingGroupInput {
	s.ThingName = &v
	return s
}

type AddThingToBillingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddThingToBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddThingToBillingGroupOutput) GoString() string {
	return s.String()
}

type AddThingToThingGroupInput struct {
	_ struct{} `type:"structure"`

	// Override dynamic thing groups with static thing groups when 10-group limit
	// is reached. If a thing belongs to 10 thing groups, and one or more of those
	// groups are dynamic thing groups, adding a thing to a static group removes
	// the thing from the last dynamic group.
	OverrideDynamicGroups *bool `locationName:"overrideDynamicGroups" type:"boolean"`

	// The ARN of the thing to add to a group.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The ARN of the group to which you are adding a thing.
	ThingGroupArn *string `locationName:"thingGroupArn" type:"string"`

	// The name of the group to which you are adding a thing.
	ThingGroupName *string `locationName:"thingGroupName" min:"1" type:"string"`

	// The name of the thing to add to a group.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s AddThingToThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddThingToThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddThingToThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddThingToThingGroupInput"}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOverrideDynamicGroups sets the OverrideDynamicGroups field's value.
func (s *AddThingToThingGroupInput) SetOverrideDynamicGroups(v bool) *AddThingToThingGroupInput {
	s.OverrideDynamicGroups = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *AddThingToThingGroupInput) SetThingArn(v string) *AddThingToThingGroupInput {
	s.ThingArn = &v
	return s
}

// SetThingGroupArn sets the ThingGroupArn field's value.
func (s *AddThingToThingGroupInput) SetThingGroupArn(v string) *AddThingToThingGroupInput {
	s.ThingGroupArn = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *AddThingToThingGroupInput) SetThingGroupName(v string) *AddThingToThingGroupInput {
	s.ThingGroupName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AddThingToThingGroupInput) SetThingName(v string) *AddThingToThingGroupInput {
	s.ThingName = &v
	return s
}

type AddThingToThingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddThingToThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddThingToThingGroupOutput) GoString() string {
	return s.String()
}

// A structure containing the alert target ARN and the role ARN.
type AlertTarget struct {
	_ struct{} `type:"structure"`

	// The ARN of the notification target to which alerts are sent.
	//
	// AlertTargetArn is a required field
	AlertTargetArn *string `locationName:"alertTargetArn" type:"string" required:"true"`

	// The ARN of the role that grants permission to send alerts to the notification
	// target.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AlertTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlertTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlertTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlertTarget"}
	if s.AlertTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AlertTargetArn"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlertTargetArn sets the AlertTargetArn field's value.
func (s *AlertTarget) SetAlertTargetArn(v string) *AlertTarget {
	s.AlertTargetArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AlertTarget) SetRoleArn(v string) *AlertTarget {
	s.RoleArn = &v
	return s
}

// Contains information that allowed the authorization.
type Allowed struct {
	_ struct{} `type:"structure"`

	// A list of policies that allowed the authentication.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s Allowed) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Allowed) GoString() string {
	return s.String()
}

// SetPolicies sets the Policies field's value.
func (s *Allowed) SetPolicies(v []*Policy) *Allowed {
	s.Policies = v
	return s
}

type AssociateTargetsWithJobInput struct {
	_ struct{} `type:"structure"`

	// An optional comment string describing why the job was associated with the
	// targets.
	Comment *string `locationName:"comment" type:"string"`

	// The unique identifier you assigned to this job when it was created.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// A list of thing group ARNs that define the targets of the job.
	//
	// Targets is a required field
	Targets []*string `locationName:"targets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AssociateTargetsWithJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTargetsWithJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTargetsWithJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTargetsWithJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *AssociateTargetsWithJobInput) SetComment(v string) *AssociateTargetsWithJobInput {
	s.Comment = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *AssociateTargetsWithJobInput) SetJobId(v string) *AssociateTargetsWithJobInput {
	s.JobId = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AssociateTargetsWithJobInput) SetTargets(v []*string) *AssociateTargetsWithJobInput {
	s.Targets = v
	return s
}

type AssociateTargetsWithJobOutput struct {
	_ struct{} `type:"structure"`

	// A short text description of the job.
	Description *string `locationName:"description" type:"string"`

	// An ARN identifying the job.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`
}

// String returns the string representation
func (s AssociateTargetsWithJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTargetsWithJobOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *AssociateTargetsWithJobOutput) SetDescription(v string) *AssociateTargetsWithJobOutput {
	s.Description = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *AssociateTargetsWithJobOutput) SetJobArn(v string) *AssociateTargetsWithJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *AssociateTargetsWithJobOutput) SetJobId(v string) *AssociateTargetsWithJobOutput {
	s.JobId = &v
	return s
}

type AttachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to attach.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The identity (https://docs.aws.amazon.com/iot/latest/developerguide/iot-security-identity.html)
	// to which the policy is attached.
	//
	// Target is a required field
	Target *string `locationName:"target" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *AttachPolicyInput) SetPolicyName(v string) *AttachPolicyInput {
	s.PolicyName = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *AttachPolicyInput) SetTarget(v string) *AttachPolicyInput {
	s.Target = &v
	return s
}

type AttachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyOutput) GoString() string {
	return s.String()
}

// The input for the AttachPrincipalPolicy operation.
type AttachPrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The principal, which can be a certificate ARN (as returned from the CreateCertificate
	// operation) or an Amazon Cognito ID.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachPrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPrincipalPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachPrincipalPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachPrincipalPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *AttachPrincipalPolicyInput) SetPolicyName(v string) *AttachPrincipalPolicyInput {
	s.PolicyName = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AttachPrincipalPolicyInput) SetPrincipal(v string) *AttachPrincipalPolicyInput {
	s.Principal = &v
	return s
}

type AttachPrincipalPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachPrincipalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPrincipalPolicyOutput) GoString() string {
	return s.String()
}

type AttachSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The security profile that is attached.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`

	// The ARN of the target (thing group) to which the security profile is attached.
	//
	// SecurityProfileTargetArn is a required field
	SecurityProfileTargetArn *string `location:"querystring" locationName:"securityProfileTargetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachSecurityProfileInput"}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}
	if s.SecurityProfileTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileTargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *AttachSecurityProfileInput) SetSecurityProfileName(v string) *AttachSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

// SetSecurityProfileTargetArn sets the SecurityProfileTargetArn field's value.
func (s *AttachSecurityProfileInput) SetSecurityProfileTargetArn(v string) *AttachSecurityProfileInput {
	s.SecurityProfileTargetArn = &v
	return s
}

type AttachSecurityProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachSecurityProfileOutput) GoString() string {
	return s.String()
}

// The input for the AttachThingPrincipal operation.
type AttachThingPrincipalInput struct {
	_ struct{} `type:"structure"`

	// The principal, such as a certificate or other credential.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachThingPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachThingPrincipalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachThingPrincipalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachThingPrincipalInput"}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipal sets the Principal field's value.
func (s *AttachThingPrincipalInput) SetPrincipal(v string) *AttachThingPrincipalInput {
	s.Principal = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AttachThingPrincipalInput) SetThingName(v string) *AttachThingPrincipalInput {
	s.ThingName = &v
	return s
}

// The output from the AttachThingPrincipal operation.
type AttachThingPrincipalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachThingPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachThingPrincipalOutput) GoString() string {
	return s.String()
}

// The attribute payload.
type AttributePayload struct {
	_ struct{} `type:"structure"`

	// A JSON string containing up to three key-value pair in JSON format. For example:
	//
	// {\"attributes\":{\"string1\":\"string2\"}}
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Specifies whether the list of attributes provided in the AttributePayload
	// is merged with the attributes stored in the registry, instead of overwriting
	// them.
	//
	// To remove an attribute, call UpdateThing with an empty attribute value.
	//
	// The merge attribute is only valid when calling UpdateThing.
	Merge *bool `locationName:"merge" type:"boolean"`
}

// String returns the string representation
func (s AttributePayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributePayload) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *AttributePayload) SetAttributes(v map[string]*string) *AttributePayload {
	s.Attributes = v
	return s
}

// SetMerge sets the Merge field's value.
func (s *AttributePayload) SetMerge(v bool) *AttributePayload {
	s.Merge = &v
	return s
}

// Which audit checks are enabled and disabled for this account.
type AuditCheckConfiguration struct {
	_ struct{} `type:"structure"`

	// True if this audit check is enabled for this account.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation
func (s AuditCheckConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditCheckConfiguration) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AuditCheckConfiguration) SetEnabled(v bool) *AuditCheckConfiguration {
	s.Enabled = &v
	return s
}

// Information about the audit check.
type AuditCheckDetails struct {
	_ struct{} `type:"structure"`

	// True if the check completed and found all resources compliant.
	CheckCompliant *bool `locationName:"checkCompliant" type:"boolean"`

	// The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION",
	// "CANCELED", "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
	CheckRunStatus *string `locationName:"checkRunStatus" type:"string" enum:"AuditCheckRunStatus"`

	// The code of any error encountered when performing this check during this
	// audit. One of "INSUFFICIENT_PERMISSIONS", or "AUDIT_CHECK_DISABLED".
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The message associated with any error encountered when performing this check
	// during this audit.
	Message *string `locationName:"message" type:"string"`

	// The number of resources that the check found non-compliant.
	NonCompliantResourcesCount *int64 `locationName:"nonCompliantResourcesCount" type:"long"`

	// The number of resources on which the check was performed.
	TotalResourcesCount *int64 `locationName:"totalResourcesCount" type:"long"`
}

// String returns the string representation
func (s AuditCheckDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditCheckDetails) GoString() string {
	return s.String()
}

// SetCheckCompliant sets the CheckCompliant field's value.
func (s *AuditCheckDetails) SetCheckCompliant(v bool) *AuditCheckDetails {
	s.CheckCompliant = &v
	return s
}

// SetCheckRunStatus sets the CheckRunStatus field's value.
func (s *AuditCheckDetails) SetCheckRunStatus(v string) *AuditCheckDetails {
	s.CheckRunStatus = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AuditCheckDetails) SetErrorCode(v string) *AuditCheckDetails {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AuditCheckDetails) SetMessage(v string) *AuditCheckDetails {
	s.Message = &v
	return s
}

// SetNonCompliantResourcesCount sets the NonCompliantResourcesCount field's value.
func (s *AuditCheckDetails) SetNonCompliantResourcesCount(v int64) *AuditCheckDetails {
	s.NonCompliantResourcesCount = &v
	return s
}

// SetTotalResourcesCount sets the TotalResourcesCount field's value.
func (s *AuditCheckDetails) SetTotalResourcesCount(v int64) *AuditCheckDetails {
	s.TotalResourcesCount = &v
	return s
}

// The findings (results) of the audit.
type AuditFinding struct {
	_ struct{} `type:"structure"`

	// The audit check that generated this result.
	CheckName *string `locationName:"checkName" type:"string"`

	// The time the result (finding) was discovered.
	FindingTime *time.Time `locationName:"findingTime" type:"timestamp"`

	// The resource that was found to be non-compliant with the audit check.
	NonCompliantResource *NonCompliantResource `locationName:"nonCompliantResource" type:"structure"`

	// The reason the resource was non-compliant.
	ReasonForNonCompliance *string `locationName:"reasonForNonCompliance" type:"string"`

	// A code which indicates the reason that the resource was non-compliant.
	ReasonForNonComplianceCode *string `locationName:"reasonForNonComplianceCode" type:"string"`

	// The list of related resources.
	RelatedResources []*RelatedResource `locationName:"relatedResources" type:"list"`

	// The severity of the result (finding).
	Severity *string `locationName:"severity" type:"string" enum:"AuditFindingSeverity"`

	// The ID of the audit that generated this result (finding)
	TaskId *string `locationName:"taskId" min:"1" type:"string"`

	// The time the audit started.
	TaskStartTime *time.Time `locationName:"taskStartTime" type:"timestamp"`
}

// String returns the string representation
func (s AuditFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditFinding) GoString() string {
	return s.String()
}

// SetCheckName sets the CheckName field's value.
func (s *AuditFinding) SetCheckName(v string) *AuditFinding {
	s.CheckName = &v
	return s
}

// SetFindingTime sets the FindingTime field's value.
func (s *AuditFinding) SetFindingTime(v time.Time) *AuditFinding {
	s.FindingTime = &v
	return s
}

// SetNonCompliantResource sets the NonCompliantResource field's value.
func (s *AuditFinding) SetNonCompliantResource(v *NonCompliantResource) *AuditFinding {
	s.NonCompliantResource = v
	return s
}

// SetReasonForNonCompliance sets the ReasonForNonCompliance field's value.
func (s *AuditFinding) SetReasonForNonCompliance(v string) *AuditFinding {
	s.ReasonForNonCompliance = &v
	return s
}

// SetReasonForNonComplianceCode sets the ReasonForNonComplianceCode field's value.
func (s *AuditFinding) SetReasonForNonComplianceCode(v string) *AuditFinding {
	s.ReasonForNonComplianceCode = &v
	return s
}

// SetRelatedResources sets the RelatedResources field's value.
func (s *AuditFinding) SetRelatedResources(v []*RelatedResource) *AuditFinding {
	s.RelatedResources = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *AuditFinding) SetSeverity(v string) *AuditFinding {
	s.Severity = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *AuditFinding) SetTaskId(v string) *AuditFinding {
	s.TaskId = &v
	return s
}

// SetTaskStartTime sets the TaskStartTime field's value.
func (s *AuditFinding) SetTaskStartTime(v time.Time) *AuditFinding {
	s.TaskStartTime = &v
	return s
}

// Information about the targets to which audit notifications are sent.
type AuditNotificationTarget struct {
	_ struct{} `type:"structure"`

	// True if notifications to the target are enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The ARN of the role that grants permission to send notifications to the target.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The ARN of the target (SNS topic) to which audit notifications are sent.
	TargetArn *string `locationName:"targetArn" type:"string"`
}

// String returns the string representation
func (s AuditNotificationTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditNotificationTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuditNotificationTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuditNotificationTarget"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *AuditNotificationTarget) SetEnabled(v bool) *AuditNotificationTarget {
	s.Enabled = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AuditNotificationTarget) SetRoleArn(v string) *AuditNotificationTarget {
	s.RoleArn = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *AuditNotificationTarget) SetTargetArn(v string) *AuditNotificationTarget {
	s.TargetArn = &v
	return s
}

// The audits that were performed.
type AuditTaskMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of this audit.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`

	// The status of this audit: one of "IN_PROGRESS", "COMPLETED", "FAILED" or
	// "CANCELED".
	TaskStatus *string `locationName:"taskStatus" type:"string" enum:"AuditTaskStatus"`

	// The type of this audit: one of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
	TaskType *string `locationName:"taskType" type:"string" enum:"AuditTaskType"`
}

// String returns the string representation
func (s AuditTaskMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditTaskMetadata) GoString() string {
	return s.String()
}

// SetTaskId sets the TaskId field's value.
func (s *AuditTaskMetadata) SetTaskId(v string) *AuditTaskMetadata {
	s.TaskId = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *AuditTaskMetadata) SetTaskStatus(v string) *AuditTaskMetadata {
	s.TaskStatus = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *AuditTaskMetadata) SetTaskType(v string) *AuditTaskMetadata {
	s.TaskType = &v
	return s
}

// A collection of authorization information.
type AuthInfo struct {
	_ struct{} `type:"structure"`

	// The type of action for which the principal is being authorized.
	ActionType *string `locationName:"actionType" type:"string" enum:"ActionType"`

	// The resources for which the principal is being authorized to perform the
	// specified action.
	Resources []*string `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s AuthInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthInfo) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *AuthInfo) SetActionType(v string) *AuthInfo {
	s.ActionType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *AuthInfo) SetResources(v []*string) *AuthInfo {
	s.Resources = v
	return s
}

// The authorizer result.
type AuthResult struct {
	_ struct{} `type:"structure"`

	// The policies and statements that allowed the specified action.
	Allowed *Allowed `locationName:"allowed" type:"structure"`

	// The final authorization decision of this scenario. Multiple statements are
	// taken into account when determining the authorization decision. An explicit
	// deny statement can override multiple allow statements.
	AuthDecision *string `locationName:"authDecision" type:"string" enum:"AuthDecision"`

	// Authorization information.
	AuthInfo *AuthInfo `locationName:"authInfo" type:"structure"`

	// The policies and statements that denied the specified action.
	Denied *Denied `locationName:"denied" type:"structure"`

	// Contains any missing context values found while evaluating policy.
	MissingContextValues []*string `locationName:"missingContextValues" type:"list"`
}

// String returns the string representation
func (s AuthResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthResult) GoString() string {
	return s.String()
}

// SetAllowed sets the Allowed field's value.
func (s *AuthResult) SetAllowed(v *Allowed) *AuthResult {
	s.Allowed = v
	return s
}

// SetAuthDecision sets the AuthDecision field's value.
func (s *AuthResult) SetAuthDecision(v string) *AuthResult {
	s.AuthDecision = &v
	return s
}

// SetAuthInfo sets the AuthInfo field's value.
func (s *AuthResult) SetAuthInfo(v *AuthInfo) *AuthResult {
	s.AuthInfo = v
	return s
}

// SetDenied sets the Denied field's value.
func (s *AuthResult) SetDenied(v *Denied) *AuthResult {
	s.Denied = v
	return s
}

// SetMissingContextValues sets the MissingContextValues field's value.
func (s *AuthResult) SetMissingContextValues(v []*string) *AuthResult {
	s.MissingContextValues = v
	return s
}

// The authorizer description.
type AuthorizerDescription struct {
	_ struct{} `type:"structure"`

	// The authorizer ARN.
	AuthorizerArn *string `locationName:"authorizerArn" type:"string"`

	// The authorizer's Lambda function ARN.
	AuthorizerFunctionArn *string `locationName:"authorizerFunctionArn" type:"string"`

	// The authorizer name.
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string"`

	// The UNIX timestamp of when the authorizer was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The UNIX timestamp of when the authorizer was last updated.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The status of the authorizer.
	Status *string `locationName:"status" type:"string" enum:"AuthorizerStatus"`

	// The key used to extract the token from the HTTP headers.
	TokenKeyName *string `locationName:"tokenKeyName" min:"1" type:"string"`

	// The public keys used to validate the token signature returned by your custom
	// authentication service.
	TokenSigningPublicKeys map[string]*string `locationName:"tokenSigningPublicKeys" type:"map"`
}

// String returns the string representation
func (s AuthorizerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizerDescription) GoString() string {
	return s.String()
}

// SetAuthorizerArn sets the AuthorizerArn field's value.
func (s *AuthorizerDescription) SetAuthorizerArn(v string) *AuthorizerDescription {
	s.AuthorizerArn = &v
	return s
}

// SetAuthorizerFunctionArn sets the AuthorizerFunctionArn field's value.
func (s *AuthorizerDescription) SetAuthorizerFunctionArn(v string) *AuthorizerDescription {
	s.AuthorizerFunctionArn = &v
	return s
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *AuthorizerDescription) SetAuthorizerName(v string) *AuthorizerDescription {
	s.AuthorizerName = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AuthorizerDescription) SetCreationDate(v time.Time) *AuthorizerDescription {
	s.CreationDate = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *AuthorizerDescription) SetLastModifiedDate(v time.Time) *AuthorizerDescription {
	s.LastModifiedDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AuthorizerDescription) SetStatus(v string) *AuthorizerDescription {
	s.Status = &v
	return s
}

// SetTokenKeyName sets the TokenKeyName field's value.
func (s *AuthorizerDescription) SetTokenKeyName(v string) *AuthorizerDescription {
	s.TokenKeyName = &v
	return s
}

// SetTokenSigningPublicKeys sets the TokenSigningPublicKeys field's value.
func (s *AuthorizerDescription) SetTokenSigningPublicKeys(v map[string]*string) *AuthorizerDescription {
	s.TokenSigningPublicKeys = v
	return s
}

// The authorizer summary.
type AuthorizerSummary struct {
	_ struct{} `type:"structure"`

	// The authorizer ARN.
	AuthorizerArn *string `locationName:"authorizerArn" type:"string"`

	// The authorizer name.
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string"`
}

// String returns the string representation
func (s AuthorizerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizerSummary) GoString() string {
	return s.String()
}

// SetAuthorizerArn sets the AuthorizerArn field's value.
func (s *AuthorizerSummary) SetAuthorizerArn(v string) *AuthorizerSummary {
	s.AuthorizerArn = &v
	return s
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *AuthorizerSummary) SetAuthorizerName(v string) *AuthorizerSummary {
	s.AuthorizerName = &v
	return s
}

// Configuration for the rollout of OTA updates.
type AwsJobExecutionsRolloutConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of OTA update job executions started per minute.
	MaximumPerMinute *int64 `locationName:"maximumPerMinute" min:"1" type:"integer"`
}

// String returns the string representation
func (s AwsJobExecutionsRolloutConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsJobExecutionsRolloutConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsJobExecutionsRolloutConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsJobExecutionsRolloutConfig"}
	if s.MaximumPerMinute != nil && *s.MaximumPerMinute < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumPerMinute", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumPerMinute sets the MaximumPerMinute field's value.
func (s *AwsJobExecutionsRolloutConfig) SetMaximumPerMinute(v int64) *AwsJobExecutionsRolloutConfig {
	s.MaximumPerMinute = &v
	return s
}

// A Device Defender security profile behavior.
type Behavior struct {
	_ struct{} `type:"structure"`

	// The criteria that determine if a device is behaving normally in regard to
	// the metric.
	Criteria *BehaviorCriteria `locationName:"criteria" type:"structure"`

	// What is measured by the behavior.
	Metric *string `locationName:"metric" type:"string"`

	// The name you have given to the behavior.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Behavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Behavior) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Behavior) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Behavior"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCriteria sets the Criteria field's value.
func (s *Behavior) SetCriteria(v *BehaviorCriteria) *Behavior {
	s.Criteria = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *Behavior) SetMetric(v string) *Behavior {
	s.Metric = &v
	return s
}

// SetName sets the Name field's value.
func (s *Behavior) SetName(v string) *Behavior {
	s.Name = &v
	return s
}

// The criteria by which the behavior is determined to be normal.
type BehaviorCriteria struct {
	_ struct{} `type:"structure"`

	// The operator that relates the thing measured (metric) to the criteria (value).
	ComparisonOperator *string `locationName:"comparisonOperator" type:"string" enum:"ComparisonOperator"`

	// Use this to specify the period of time over which the behavior is evaluated,
	// for those criteria which have a time dimension (for example, NUM_MESSAGES_SENT).
	DurationSeconds *int64 `locationName:"durationSeconds" type:"integer"`

	// The value to be compared with the metric.
	Value *MetricValue `locationName:"value" type:"structure"`
}

// String returns the string representation
func (s BehaviorCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BehaviorCriteria) GoString() string {
	return s.String()
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *BehaviorCriteria) SetComparisonOperator(v string) *BehaviorCriteria {
	s.ComparisonOperator = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *BehaviorCriteria) SetDurationSeconds(v int64) *BehaviorCriteria {
	s.DurationSeconds = &v
	return s
}

// SetValue sets the Value field's value.
func (s *BehaviorCriteria) SetValue(v *MetricValue) *BehaviorCriteria {
	s.Value = v
	return s
}

// Additional information about the billing group.
type BillingGroupMetadata struct {
	_ struct{} `type:"structure"`

	// The date the billing group was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`
}

// String returns the string representation
func (s BillingGroupMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BillingGroupMetadata) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *BillingGroupMetadata) SetCreationDate(v time.Time) *BillingGroupMetadata {
	s.CreationDate = &v
	return s
}

// The properties of a billing group.
type BillingGroupProperties struct {
	_ struct{} `type:"structure"`

	// The description of the billing group.
	BillingGroupDescription *string `locationName:"billingGroupDescription" type:"string"`
}

// String returns the string representation
func (s BillingGroupProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BillingGroupProperties) GoString() string {
	return s.String()
}

// SetBillingGroupDescription sets the BillingGroupDescription field's value.
func (s *BillingGroupProperties) SetBillingGroupDescription(v string) *BillingGroupProperties {
	s.BillingGroupDescription = &v
	return s
}

// A CA certificate.
type CACertificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the CA certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the CA certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The date the CA certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The status of the CA certificate.
	//
	// The status value REGISTER_INACTIVE is deprecated and should not be used.
	Status *string `locationName:"status" type:"string" enum:"CACertificateStatus"`
}

// String returns the string representation
func (s CACertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CACertificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CACertificate) SetCertificateArn(v string) *CACertificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CACertificate) SetCertificateId(v string) *CACertificate {
	s.CertificateId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CACertificate) SetCreationDate(v time.Time) *CACertificate {
	s.CreationDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CACertificate) SetStatus(v string) *CACertificate {
	s.Status = &v
	return s
}

// Describes a CA certificate.
type CACertificateDescription struct {
	_ struct{} `type:"structure"`

	// Whether the CA certificate configured for auto registration of device certificates.
	// Valid values are "ENABLE" and "DISABLE"
	AutoRegistrationStatus *string `locationName:"autoRegistrationStatus" type:"string" enum:"AutoRegistrationStatus"`

	// The CA certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The CA certificate ID.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The CA certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The date the CA certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The customer version of the CA certificate.
	CustomerVersion *int64 `locationName:"customerVersion" min:"1" type:"integer"`

	// The generation ID of the CA certificate.
	GenerationId *string `locationName:"generationId" type:"string"`

	// The date the CA certificate was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The owner of the CA certificate.
	OwnedBy *string `locationName:"ownedBy" min:"12" type:"string"`

	// The status of a CA certificate.
	Status *string `locationName:"status" type:"string" enum:"CACertificateStatus"`

	// When the CA certificate is valid.
	Validity *CertificateValidity `locationName:"validity" type:"structure"`
}

// String returns the string representation
func (s CACertificateDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CACertificateDescription) GoString() string {
	return s.String()
}

// SetAutoRegistrationStatus sets the AutoRegistrationStatus field's value.
func (s *CACertificateDescription) SetAutoRegistrationStatus(v string) *CACertificateDescription {
	s.AutoRegistrationStatus = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CACertificateDescription) SetCertificateArn(v string) *CACertificateDescription {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CACertificateDescription) SetCertificateId(v string) *CACertificateDescription {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CACertificateDescription) SetCertificatePem(v string) *CACertificateDescription {
	s.CertificatePem = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CACertificateDescription) SetCreationDate(v time.Time) *CACertificateDescription {
	s.CreationDate = &v
	return s
}

// SetCustomerVersion sets the CustomerVersion field's value.
func (s *CACertificateDescription) SetCustomerVersion(v int64) *CACertificateDescription {
	s.CustomerVersion = &v
	return s
}

// SetGenerationId sets the GenerationId field's value.
func (s *CACertificateDescription) SetGenerationId(v string) *CACertificateDescription {
	s.GenerationId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CACertificateDescription) SetLastModifiedDate(v time.Time) *CACertificateDescription {
	s.LastModifiedDate = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *CACertificateDescription) SetOwnedBy(v string) *CACertificateDescription {
	s.OwnedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CACertificateDescription) SetStatus(v string) *CACertificateDescription {
	s.Status = &v
	return s
}

// SetValidity sets the Validity field's value.
func (s *CACertificateDescription) SetValidity(v *CertificateValidity) *CACertificateDescription {
	s.Validity = v
	return s
}

type CancelAuditTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the audit you want to cancel. You can only cancel an audit that
	// is "IN_PROGRESS".
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelAuditTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelAuditTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelAuditTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelAuditTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *CancelAuditTaskInput) SetTaskId(v string) *CancelAuditTaskInput {
	s.TaskId = &v
	return s
}

type CancelAuditTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelAuditTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelAuditTaskOutput) GoString() string {
	return s.String()
}

// The input for the CancelCertificateTransfer operation.
type CancelCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCertificateTransferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelCertificateTransferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelCertificateTransferInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *CancelCertificateTransferInput) SetCertificateId(v string) *CancelCertificateTransferInput {
	s.CertificateId = &v
	return s
}

type CancelCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCertificateTransferOutput) GoString() string {
	return s.String()
}

type CancelJobExecutionInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The expected current version of the job execution. Each time you
	// update the job execution, its version is incremented. If the version of the
	// job execution stored in Jobs does not match, the update is rejected with
	// a VersionMismatch error, and an ErrorResponse that contains the current job
	// execution status data is returned. (This makes it unnecessary to perform
	// a separate DescribeJobExecution request in order to obtain the job execution
	// status data.)
	ExpectedVersion *int64 `locationName:"expectedVersion" type:"long"`

	// (Optional) If true the job execution will be canceled if it has status IN_PROGRESS
	// or QUEUED, otherwise the job execution will be canceled only if it has status
	// QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and
	// you do not set force to true, then an InvalidStateTransitionException will
	// be thrown. The default is false.
	//
	// Canceling a job execution which is "IN_PROGRESS", will cause the device to
	// be unable to update the job execution status. Use caution and ensure that
	// the device is able to recover to a valid state.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The ID of the job to be canceled.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// A collection of name/value pairs that describe the status of the job execution.
	// If not specified, the statusDetails are unchanged. You can specify at most
	// 10 name/value pairs.
	StatusDetails map[string]*string `locationName:"statusDetails" type:"map"`

	// The name of the thing whose execution of the job will be canceled.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelJobExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobExecutionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *CancelJobExecutionInput) SetExpectedVersion(v int64) *CancelJobExecutionInput {
	s.ExpectedVersion = &v
	return s
}

// SetForce sets the Force field's value.
func (s *CancelJobExecutionInput) SetForce(v bool) *CancelJobExecutionInput {
	s.Force = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CancelJobExecutionInput) SetJobId(v string) *CancelJobExecutionInput {
	s.JobId = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *CancelJobExecutionInput) SetStatusDetails(v map[string]*string) *CancelJobExecutionInput {
	s.StatusDetails = v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *CancelJobExecutionInput) SetThingName(v string) *CancelJobExecutionInput {
	s.ThingName = &v
	return s
}

type CancelJobExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelJobExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobExecutionOutput) GoString() string {
	return s.String()
}

type CancelJobInput struct {
	_ struct{} `type:"structure"`

	// An optional comment string describing why the job was canceled.
	Comment *string `locationName:"comment" type:"string"`

	// (Optional) If true job executions with status "IN_PROGRESS" and "QUEUED"
	// are canceled, otherwise only job executions with status "QUEUED" are canceled.
	// The default is false.
	//
	// Canceling a job which is "IN_PROGRESS", will cause a device which is executing
	// the job to be unable to update the job execution status. Use caution and
	// ensure that each device executing a job which is canceled is able to recover
	// to a valid state.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The unique identifier you assigned to this job when it was created.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// (Optional)A reason code string that explains why the job was canceled.
	ReasonCode *string `locationName:"reasonCode" type:"string"`
}

// String returns the string representation
func (s CancelJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *CancelJobInput) SetComment(v string) *CancelJobInput {
	s.Comment = &v
	return s
}

// SetForce sets the Force field's value.
func (s *CancelJobInput) SetForce(v bool) *CancelJobInput {
	s.Force = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CancelJobInput) SetJobId(v string) *CancelJobInput {
	s.JobId = &v
	return s
}

// SetReasonCode sets the ReasonCode field's value.
func (s *CancelJobInput) SetReasonCode(v string) *CancelJobInput {
	s.ReasonCode = &v
	return s
}

type CancelJobOutput struct {
	_ struct{} `type:"structure"`

	// A short text description of the job.
	Description *string `locationName:"description" type:"string"`

	// The job ARN.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`
}

// String returns the string representation
func (s CancelJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CancelJobOutput) SetDescription(v string) *CancelJobOutput {
	s.Description = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *CancelJobOutput) SetJobArn(v string) *CancelJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CancelJobOutput) SetJobId(v string) *CancelJobOutput {
	s.JobId = &v
	return s
}

// Information about a certificate.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The status of the certificate.
	//
	// The status value REGISTER_INACTIVE is deprecated and should not be used.
	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *Certificate) SetCertificateId(v string) *Certificate {
	s.CertificateId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Certificate) SetCreationDate(v time.Time) *Certificate {
	s.CreationDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Certificate) SetStatus(v string) *Certificate {
	s.Status = &v
	return s
}

// Describes a certificate.
type CertificateDescription struct {
	_ struct{} `type:"structure"`

	// The certificate ID of the CA certificate used to sign this certificate.
	CaCertificateId *string `locationName:"caCertificateId" min:"64" type:"string"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The customer version of the certificate.
	CustomerVersion *int64 `locationName:"customerVersion" min:"1" type:"integer"`

	// The generation ID of the certificate.
	GenerationId *string `locationName:"generationId" type:"string"`

	// The date and time the certificate was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The ID of the AWS account that owns the certificate.
	OwnedBy *string `locationName:"ownedBy" min:"12" type:"string"`

	// The ID of the AWS account of the previous owner of the certificate.
	PreviousOwnedBy *string `locationName:"previousOwnedBy" min:"12" type:"string"`

	// The status of the certificate.
	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`

	// The transfer data.
	TransferData *TransferData `locationName:"transferData" type:"structure"`

	// When the certificate is valid.
	Validity *CertificateValidity `locationName:"validity" type:"structure"`
}

// String returns the string representation
func (s CertificateDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateDescription) GoString() string {
	return s.String()
}

// SetCaCertificateId sets the CaCertificateId field's value.
func (s *CertificateDescription) SetCaCertificateId(v string) *CertificateDescription {
	s.CaCertificateId = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CertificateDescription) SetCertificateArn(v string) *CertificateDescription {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CertificateDescription) SetCertificateId(v string) *CertificateDescription {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CertificateDescription) SetCertificatePem(v string) *CertificateDescription {
	s.CertificatePem = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CertificateDescription) SetCreationDate(v time.Time) *CertificateDescription {
	s.CreationDate = &v
	return s
}

// SetCustomerVersion sets the CustomerVersion field's value.
func (s *CertificateDescription) SetCustomerVersion(v int64) *CertificateDescription {
	s.CustomerVersion = &v
	return s
}

// SetGenerationId sets the GenerationId field's value.
func (s *CertificateDescription) SetGenerationId(v string) *CertificateDescription {
	s.GenerationId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CertificateDescription) SetLastModifiedDate(v time.Time) *CertificateDescription {
	s.LastModifiedDate = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *CertificateDescription) SetOwnedBy(v string) *CertificateDescription {
	s.OwnedBy = &v
	return s
}

// SetPreviousOwnedBy sets the PreviousOwnedBy field's value.
func (s *CertificateDescription) SetPreviousOwnedBy(v string) *CertificateDescription {
	s.PreviousOwnedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CertificateDescription) SetStatus(v string) *CertificateDescription {
	s.Status = &v
	return s
}

// SetTransferData sets the TransferData field's value.
func (s *CertificateDescription) SetTransferData(v *TransferData) *CertificateDescription {
	s.TransferData = v
	return s
}

// SetValidity sets the Validity field's value.
func (s *CertificateDescription) SetValidity(v *CertificateValidity) *CertificateDescription {
	s.Validity = v
	return s
}

// When the certificate is valid.
type CertificateValidity struct {
	_ struct{} `type:"structure"`

	// The certificate is not valid after this date.
	NotAfter *time.Time `locationName:"notAfter" type:"timestamp"`

	// The certificate is not valid before this date.
	NotBefore *time.Time `locationName:"notBefore" type:"timestamp"`
}

// String returns the string representation
func (s CertificateValidity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateValidity) GoString() string {
	return s.String()
}

// SetNotAfter sets the NotAfter field's value.
func (s *CertificateValidity) SetNotAfter(v time.Time) *CertificateValidity {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *CertificateValidity) SetNotBefore(v time.Time) *CertificateValidity {
	s.NotBefore = &v
	return s
}

type ClearDefaultAuthorizerInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ClearDefaultAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClearDefaultAuthorizerInput) GoString() string {
	return s.String()
}

type ClearDefaultAuthorizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ClearDefaultAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClearDefaultAuthorizerOutput) GoString() string {
	return s.String()
}

// Describes an action that updates a CloudWatch alarm.
type CloudwatchAlarmAction struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarm name.
	//
	// AlarmName is a required field
	AlarmName *string `locationName:"alarmName" type:"string" required:"true"`

	// The IAM role that allows access to the CloudWatch alarm.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The reason for the alarm change.
	//
	// StateReason is a required field
	StateReason *string `locationName:"stateReason" type:"string" required:"true"`

	// The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
	//
	// StateValue is a required field
	StateValue *string `locationName:"stateValue" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudwatchAlarmAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchAlarmAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchAlarmAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudwatchAlarmAction"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.StateReason == nil {
		invalidParams.Add(request.NewErrParamRequired("StateReason"))
	}
	if s.StateValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StateValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *CloudwatchAlarmAction) SetAlarmName(v string) *CloudwatchAlarmAction {
	s.AlarmName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudwatchAlarmAction) SetRoleArn(v string) *CloudwatchAlarmAction {
	s.RoleArn = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *CloudwatchAlarmAction) SetStateReason(v string) *CloudwatchAlarmAction {
	s.StateReason = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *CloudwatchAlarmAction) SetStateValue(v string) *CloudwatchAlarmAction {
	s.StateValue = &v
	return s
}

// Describes an action that captures a CloudWatch metric.
type CloudwatchMetricAction struct {
	_ struct{} `type:"structure"`

	// The CloudWatch metric name.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true"`

	// The CloudWatch metric namespace name.
	//
	// MetricNamespace is a required field
	MetricNamespace *string `locationName:"metricNamespace" type:"string" required:"true"`

	// An optional Unix timestamp (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
	MetricTimestamp *string `locationName:"metricTimestamp" type:"string"`

	// The metric unit (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit)
	// supported by CloudWatch.
	//
	// MetricUnit is a required field
	MetricUnit *string `locationName:"metricUnit" type:"string" required:"true"`

	// The CloudWatch metric value.
	//
	// MetricValue is a required field
	MetricValue *string `locationName:"metricValue" type:"string" required:"true"`

	// The IAM role that allows access to the CloudWatch metric.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudwatchMetricAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchMetricAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchMetricAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudwatchMetricAction"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricNamespace"))
	}
	if s.MetricUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricUnit"))
	}
	if s.MetricValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricValue"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricName sets the MetricName field's value.
func (s *CloudwatchMetricAction) SetMetricName(v string) *CloudwatchMetricAction {
	s.MetricName = &v
	return s
}

// SetMetricNamespace sets the MetricNamespace field's value.
func (s *CloudwatchMetricAction) SetMetricNamespace(v string) *CloudwatchMetricAction {
	s.MetricNamespace = &v
	return s
}

// SetMetricTimestamp sets the MetricTimestamp field's value.
func (s *CloudwatchMetricAction) SetMetricTimestamp(v string) *CloudwatchMetricAction {
	s.MetricTimestamp = &v
	return s
}

// SetMetricUnit sets the MetricUnit field's value.
func (s *CloudwatchMetricAction) SetMetricUnit(v string) *CloudwatchMetricAction {
	s.MetricUnit = &v
	return s
}

// SetMetricValue sets the MetricValue field's value.
func (s *CloudwatchMetricAction) SetMetricValue(v string) *CloudwatchMetricAction {
	s.MetricValue = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudwatchMetricAction) SetRoleArn(v string) *CloudwatchMetricAction {
	s.RoleArn = &v
	return s
}

// Describes the method to use when code signing a file.
type CodeSigning struct {
	_ struct{} `type:"structure"`

	// The ID of the AWSSignerJob which was created to sign the file.
	AwsSignerJobId *string `locationName:"awsSignerJobId" type:"string"`

	// A custom method for code signing a file.
	CustomCodeSigning *CustomCodeSigning `locationName:"customCodeSigning" type:"structure"`

	// Describes the code-signing job.
	StartSigningJobParameter *StartSigningJobParameter `locationName:"startSigningJobParameter" type:"structure"`
}

// String returns the string representation
func (s CodeSigning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeSigning) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeSigning) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeSigning"}
	if s.StartSigningJobParameter != nil {
		if err := s.StartSigningJobParameter.Validate(); err != nil {
			invalidParams.AddNested("StartSigningJobParameter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsSignerJobId sets the AwsSignerJobId field's value.
func (s *CodeSigning) SetAwsSignerJobId(v string) *CodeSigning {
	s.AwsSignerJobId = &v
	return s
}

// SetCustomCodeSigning sets the CustomCodeSigning field's value.
func (s *CodeSigning) SetCustomCodeSigning(v *CustomCodeSigning) *CodeSigning {
	s.CustomCodeSigning = v
	return s
}

// SetStartSigningJobParameter sets the StartSigningJobParameter field's value.
func (s *CodeSigning) SetStartSigningJobParameter(v *StartSigningJobParameter) *CodeSigning {
	s.StartSigningJobParameter = v
	return s
}

// Describes the certificate chain being used when code signing a file.
type CodeSigningCertificateChain struct {
	_ struct{} `type:"structure"`

	// The name of the certificate.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// A base64 encoded binary representation of the code signing certificate chain.
	InlineDocument *string `locationName:"inlineDocument" type:"string"`
}

// String returns the string representation
func (s CodeSigningCertificateChain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeSigningCertificateChain) GoString() string {
	return s.String()
}

// SetCertificateName sets the CertificateName field's value.
func (s *CodeSigningCertificateChain) SetCertificateName(v string) *CodeSigningCertificateChain {
	s.CertificateName = &v
	return s
}

// SetInlineDocument sets the InlineDocument field's value.
func (s *CodeSigningCertificateChain) SetInlineDocument(v string) *CodeSigningCertificateChain {
	s.InlineDocument = &v
	return s
}

// Describes the signature for a file.
type CodeSigningSignature struct {
	_ struct{} `type:"structure"`

	// A base64 encoded binary representation of the code signing signature.
	//
	// InlineDocument is automatically base64 encoded/decoded by the SDK.
	InlineDocument []byte `locationName:"inlineDocument" type:"blob"`
}

// String returns the string representation
func (s CodeSigningSignature) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeSigningSignature) GoString() string {
	return s.String()
}

// SetInlineDocument sets the InlineDocument field's value.
func (s *CodeSigningSignature) SetInlineDocument(v []byte) *CodeSigningSignature {
	s.InlineDocument = v
	return s
}

// Configuration.
type Configuration struct {
	_ struct{} `type:"structure"`

	// True to enable the configuration.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Configuration) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *Configuration) SetEnabled(v bool) *Configuration {
	s.Enabled = &v
	return s
}

type CreateAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the authorizer's Lambda function.
	//
	// AuthorizerFunctionArn is a required field
	AuthorizerFunctionArn *string `locationName:"authorizerFunctionArn" type:"string" required:"true"`

	// The authorizer name.
	//
	// AuthorizerName is a required field
	AuthorizerName *string `location:"uri" locationName:"authorizerName" min:"1" type:"string" required:"true"`

	// The status of the create authorizer request.
	Status *string `locationName:"status" type:"string" enum:"AuthorizerStatus"`

	// The name of the token key used to extract the token from the HTTP headers.
	//
	// TokenKeyName is a required field
	TokenKeyName *string `locationName:"tokenKeyName" min:"1" type:"string" required:"true"`

	// The public keys used to verify the digital signature returned by your custom
	// authentication service.
	//
	// TokenSigningPublicKeys is a required field
	TokenSigningPublicKeys map[string]*string `locationName:"tokenSigningPublicKeys" type:"map" required:"true"`
}

// String returns the string representation
func (s CreateAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAuthorizerInput"}
	if s.AuthorizerFunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerFunctionArn"))
	}
	if s.AuthorizerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerName"))
	}
	if s.AuthorizerName != nil && len(*s.AuthorizerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerName", 1))
	}
	if s.TokenKeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("TokenKeyName"))
	}
	if s.TokenKeyName != nil && len(*s.TokenKeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TokenKeyName", 1))
	}
	if s.TokenSigningPublicKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TokenSigningPublicKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerFunctionArn sets the AuthorizerFunctionArn field's value.
func (s *CreateAuthorizerInput) SetAuthorizerFunctionArn(v string) *CreateAuthorizerInput {
	s.AuthorizerFunctionArn = &v
	return s
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *CreateAuthorizerInput) SetAuthorizerName(v string) *CreateAuthorizerInput {
	s.AuthorizerName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAuthorizerInput) SetStatus(v string) *CreateAuthorizerInput {
	s.Status = &v
	return s
}

// SetTokenKeyName sets the TokenKeyName field's value.
func (s *CreateAuthorizerInput) SetTokenKeyName(v string) *CreateAuthorizerInput {
	s.TokenKeyName = &v
	return s
}

// SetTokenSigningPublicKeys sets the TokenSigningPublicKeys field's value.
func (s *CreateAuthorizerInput) SetTokenSigningPublicKeys(v map[string]*string) *CreateAuthorizerInput {
	s.TokenSigningPublicKeys = v
	return s
}

type CreateAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// The authorizer ARN.
	AuthorizerArn *string `locationName:"authorizerArn" type:"string"`

	// The authorizer's name.
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorizerArn sets the AuthorizerArn field's value.
func (s *CreateAuthorizerOutput) SetAuthorizerArn(v string) *CreateAuthorizerOutput {
	s.AuthorizerArn = &v
	return s
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *CreateAuthorizerOutput) SetAuthorizerName(v string) *CreateAuthorizerOutput {
	s.AuthorizerName = &v
	return s
}

type CreateBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name you wish to give to the billing group.
	//
	// BillingGroupName is a required field
	BillingGroupName *string `location:"uri" locationName:"billingGroupName" min:"1" type:"string" required:"true"`

	// The properties of the billing group.
	BillingGroupProperties *BillingGroupProperties `locationName:"billingGroupProperties" type:"structure"`

	// Metadata which can be used to manage the billing group.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBillingGroupInput"}
	if s.BillingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("BillingGroupName"))
	}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *CreateBillingGroupInput) SetBillingGroupName(v string) *CreateBillingGroupInput {
	s.BillingGroupName = &v
	return s
}

// SetBillingGroupProperties sets the BillingGroupProperties field's value.
func (s *CreateBillingGroupInput) SetBillingGroupProperties(v *BillingGroupProperties) *CreateBillingGroupInput {
	s.BillingGroupProperties = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBillingGroupInput) SetTags(v []*Tag) *CreateBillingGroupInput {
	s.Tags = v
	return s
}

type CreateBillingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the billing group.
	BillingGroupArn *string `locationName:"billingGroupArn" type:"string"`

	// The ID of the billing group.
	BillingGroupId *string `locationName:"billingGroupId" min:"1" type:"string"`

	// The name you gave to the billing group.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBillingGroupOutput) GoString() string {
	return s.String()
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *CreateBillingGroupOutput) SetBillingGroupArn(v string) *CreateBillingGroupOutput {
	s.BillingGroupArn = &v
	return s
}

// SetBillingGroupId sets the BillingGroupId field's value.
func (s *CreateBillingGroupOutput) SetBillingGroupId(v string) *CreateBillingGroupOutput {
	s.BillingGroupId = &v
	return s
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *CreateBillingGroupOutput) SetBillingGroupName(v string) *CreateBillingGroupOutput {
	s.BillingGroupName = &v
	return s
}

// The input for the CreateCertificateFromCsr operation.
type CreateCertificateFromCsrInput struct {
	_ struct{} `type:"structure"`

	// The certificate signing request (CSR).
	//
	// CertificateSigningRequest is a required field
	CertificateSigningRequest *string `locationName:"certificateSigningRequest" min:"1" type:"string" required:"true"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s CreateCertificateFromCsrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateFromCsrInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCertificateFromCsrInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCertificateFromCsrInput"}
	if s.CertificateSigningRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateSigningRequest"))
	}
	if s.CertificateSigningRequest != nil && len(*s.CertificateSigningRequest) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateSigningRequest", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateSigningRequest sets the CertificateSigningRequest field's value.
func (s *CreateCertificateFromCsrInput) SetCertificateSigningRequest(v string) *CreateCertificateFromCsrInput {
	s.CertificateSigningRequest = &v
	return s
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *CreateCertificateFromCsrInput) SetSetAsActive(v bool) *CreateCertificateFromCsrInput {
	s.SetAsActive = &v
	return s
}

// The output from the CreateCertificateFromCsr operation.
type CreateCertificateFromCsrOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate. You can use the ARN as
	// a principal for policy operations.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. Certificate management operations only take a
	// certificateId.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateCertificateFromCsrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateFromCsrOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateCertificateFromCsrOutput) SetCertificateArn(v string) *CreateCertificateFromCsrOutput {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CreateCertificateFromCsrOutput) SetCertificateId(v string) *CreateCertificateFromCsrOutput {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CreateCertificateFromCsrOutput) SetCertificatePem(v string) *CreateCertificateFromCsrOutput {
	s.CertificatePem = &v
	return s
}

type CreateDynamicThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The dynamic thing group index name.
	//
	// Currently one index is supported: "AWS_Things".
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The dynamic thing group search query string.
	//
	// See Query Syntax (http://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html)
	// for information about query string syntax.
	//
	// QueryString is a required field
	QueryString *string `locationName:"queryString" min:"1" type:"string" required:"true"`

	// The dynamic thing group query version.
	//
	// Currently one query version is supported: "2017-09-30". If not specified,
	// the query version defaults to this value.
	QueryVersion *string `locationName:"queryVersion" type:"string"`

	// Metadata which can be used to manage the dynamic thing group.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The dynamic thing group name to create.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`

	// The dynamic thing group properties.
	ThingGroupProperties *ThingGroupProperties `locationName:"thingGroupProperties" type:"structure"`
}

// String returns the string representation
func (s CreateDynamicThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDynamicThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDynamicThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDynamicThingGroupInput"}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}
	if s.ThingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *CreateDynamicThingGroupInput) SetIndexName(v string) *CreateDynamicThingGroupInput {
	s.IndexName = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *CreateDynamicThingGroupInput) SetQueryString(v string) *CreateDynamicThingGroupInput {
	s.QueryString = &v
	return s
}

// SetQueryVersion sets the QueryVersion field's value.
func (s *CreateDynamicThingGroupInput) SetQueryVersion(v string) *CreateDynamicThingGroupInput {
	s.QueryVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDynamicThingGroupInput) SetTags(v []*Tag) *CreateDynamicThingGroupInput {
	s.Tags = v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *CreateDynamicThingGroupInput) SetThingGroupName(v string) *CreateDynamicThingGroupInput {
	s.ThingGroupName = &v
	return s
}

// SetThingGroupProperties sets the ThingGroupProperties field's value.
func (s *CreateDynamicThingGroupInput) SetThingGroupProperties(v *ThingGroupProperties) *CreateDynamicThingGroupInput {
	s.ThingGroupProperties = v
	return s
}

type CreateDynamicThingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The dynamic thing group index name.
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The dynamic thing group search query string.
	QueryString *string `locationName:"queryString" min:"1" type:"string"`

	// The dynamic thing group query version.
	QueryVersion *string `locationName:"queryVersion" type:"string"`

	// The dynamic thing group ARN.
	ThingGroupArn *string `locationName:"thingGroupArn" type:"string"`

	// The dynamic thing group ID.
	ThingGroupId *string `locationName:"thingGroupId" min:"1" type:"string"`

	// The dynamic thing group name.
	ThingGroupName *string `locationName:"thingGroupName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDynamicThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDynamicThingGroupOutput) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *CreateDynamicThingGroupOutput) SetIndexName(v string) *CreateDynamicThingGroupOutput {
	s.IndexName = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *CreateDynamicThingGroupOutput) SetQueryString(v string) *CreateDynamicThingGroupOutput {
	s.QueryString = &v
	return s
}

// SetQueryVersion sets the QueryVersion field's value.
func (s *CreateDynamicThingGroupOutput) SetQueryVersion(v string) *CreateDynamicThingGroupOutput {
	s.QueryVersion = &v
	return s
}

// SetThingGroupArn sets the ThingGroupArn field's value.
func (s *CreateDynamicThingGroupOutput) SetThingGroupArn(v string) *CreateDynamicThingGroupOutput {
	s.ThingGroupArn = &v
	return s
}

// SetThingGroupId sets the ThingGroupId field's value.
func (s *CreateDynamicThingGroupOutput) SetThingGroupId(v string) *CreateDynamicThingGroupOutput {
	s.ThingGroupId = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *CreateDynamicThingGroupOutput) SetThingGroupName(v string) *CreateDynamicThingGroupOutput {
	s.ThingGroupName = &v
	return s
}

type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// Allows you to create criteria to abort a job.
	AbortConfig *AbortConfig `locationName:"abortConfig" type:"structure"`

	// A short text description of the job.
	Description *string `locationName:"description" type:"string"`

	// The job document.
	//
	// If the job document resides in an S3 bucket, you must use a placeholder link
	// when specifying the document.
	//
	// The placeholder link is of the following form:
	//
	// ${aws:iot:s3-presigned-url:https://s3.amazonaws.com/bucket/key}
	//
	// where bucket is your bucket name and key is the object in the bucket to which
	// you are linking.
	Document *string `locationName:"document" type:"string"`

	// An S3 link to the job document.
	DocumentSource *string `locationName:"documentSource" min:"1" type:"string"`

	// Allows you to create a staged rollout of the job.
	JobExecutionsRolloutConfig *JobExecutionsRolloutConfig `locationName:"jobExecutionsRolloutConfig" type:"structure"`

	// A job identifier which must be unique for your AWS account. We recommend
	// using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// Configuration information for pre-signed S3 URLs.
	PresignedUrlConfig *PresignedUrlConfig `locationName:"presignedUrlConfig" type:"structure"`

	// Metadata which can be used to manage the job.
	Tags []*Tag `locationName:"tags" type:"list"`

	// Specifies whether the job will continue to run (CONTINUOUS), or will be complete
	// after all those things specified as targets have completed the job (SNAPSHOT).
	// If continuous, the job may also be run on a thing when a change is detected
	// in a target. For example, a job will run on a thing when the thing is added
	// to a target group, even after the job was completed by all things originally
	// in the group.
	TargetSelection *string `locationName:"targetSelection" type:"string" enum:"TargetSelection"`

	// A list of things and thing groups to which the job should be sent.
	//
	// Targets is a required field
	Targets []*string `locationName:"targets" min:"1" type:"list" required:"true"`

	// Specifies the amount of time each device has to finish its execution of the
	// job. The timer is started when the job execution status is set to IN_PROGRESS.
	// If the job execution status is not set to another terminal state before the
	// time expires, it will be automatically set to TIMED_OUT.
	TimeoutConfig *TimeoutConfig `locationName:"timeoutConfig" type:"structure"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.DocumentSource != nil && len(*s.DocumentSource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentSource", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.AbortConfig != nil {
		if err := s.AbortConfig.Validate(); err != nil {
			invalidParams.AddNested("AbortConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.JobExecutionsRolloutConfig != nil {
		if err := s.JobExecutionsRolloutConfig.Validate(); err != nil {
			invalidParams.AddNested("JobExecutionsRolloutConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.PresignedUrlConfig != nil {
		if err := s.PresignedUrlConfig.Validate(); err != nil {
			invalidParams.AddNested("PresignedUrlConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortConfig sets the AbortConfig field's value.
func (s *CreateJobInput) SetAbortConfig(v *AbortConfig) *CreateJobInput {
	s.AbortConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetDocument sets the Document field's value.
func (s *CreateJobInput) SetDocument(v string) *CreateJobInput {
	s.Document = &v
	return s
}

// SetDocumentSource sets the DocumentSource field's value.
func (s *CreateJobInput) SetDocumentSource(v string) *CreateJobInput {
	s.DocumentSource = &v
	return s
}

// SetJobExecutionsRolloutConfig sets the JobExecutionsRolloutConfig field's value.
func (s *CreateJobInput) SetJobExecutionsRolloutConfig(v *JobExecutionsRolloutConfig) *CreateJobInput {
	s.JobExecutionsRolloutConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateJobInput) SetJobId(v string) *CreateJobInput {
	s.JobId = &v
	return s
}

// SetPresignedUrlConfig sets the PresignedUrlConfig field's value.
func (s *CreateJobInput) SetPresignedUrlConfig(v *PresignedUrlConfig) *CreateJobInput {
	s.PresignedUrlConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateJobInput) SetTags(v []*Tag) *CreateJobInput {
	s.Tags = v
	return s
}

// SetTargetSelection sets the TargetSelection field's value.
func (s *CreateJobInput) SetTargetSelection(v string) *CreateJobInput {
	s.TargetSelection = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateJobInput) SetTargets(v []*string) *CreateJobInput {
	s.Targets = v
	return s
}

// SetTimeoutConfig sets the TimeoutConfig field's value.
func (s *CreateJobInput) SetTimeoutConfig(v *TimeoutConfig) *CreateJobInput {
	s.TimeoutConfig = v
	return s
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The job description.
	Description *string `locationName:"description" type:"string"`

	// The job ARN.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The unique identifier you assigned to this job.
	JobId *string `locationName:"jobId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateJobOutput) SetDescription(v string) *CreateJobOutput {
	s.Description = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *CreateJobOutput) SetJobArn(v string) *CreateJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateJobOutput) SetJobId(v string) *CreateJobOutput {
	s.JobId = &v
	return s
}

// The input for the CreateKeysAndCertificate operation.
type CreateKeysAndCertificateInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s CreateKeysAndCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeysAndCertificateInput) GoString() string {
	return s.String()
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *CreateKeysAndCertificateInput) SetSetAsActive(v bool) *CreateKeysAndCertificateInput {
	s.SetAsActive = &v
	return s
}

// The output of the CreateKeysAndCertificate operation.
type CreateKeysAndCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. AWS IoT issues a default subject name for the
	// certificate (for example, AWS IoT Certificate).
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The generated key pair.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s CreateKeysAndCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeysAndCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateKeysAndCertificateOutput) SetCertificateArn(v string) *CreateKeysAndCertificateOutput {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CreateKeysAndCertificateOutput) SetCertificateId(v string) *CreateKeysAndCertificateOutput {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CreateKeysAndCertificateOutput) SetCertificatePem(v string) *CreateKeysAndCertificateOutput {
	s.CertificatePem = &v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *CreateKeysAndCertificateOutput) SetKeyPair(v *KeyPair) *CreateKeysAndCertificateOutput {
	s.KeyPair = v
	return s
}

type CreateOTAUpdateInput struct {
	_ struct{} `type:"structure"`

	// A list of additional OTA update parameters which are name-value pairs.
	AdditionalParameters map[string]*string `locationName:"additionalParameters" type:"map"`

	// Configuration for the rollout of OTA updates.
	AwsJobExecutionsRolloutConfig *AwsJobExecutionsRolloutConfig `locationName:"awsJobExecutionsRolloutConfig" type:"structure"`

	// The description of the OTA update.
	Description *string `locationName:"description" type:"string"`

	// The files to be streamed by the OTA update.
	//
	// Files is a required field
	Files []*OTAUpdateFile `locationName:"files" min:"1" type:"list" required:"true"`

	// The ID of the OTA update to be created.
	//
	// OtaUpdateId is a required field
	OtaUpdateId *string `location:"uri" locationName:"otaUpdateId" min:"1" type:"string" required:"true"`

	// The IAM role that allows access to the AWS IoT Jobs service.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// Specifies whether the update will continue to run (CONTINUOUS), or will be
	// complete after all the things specified as targets have completed the update
	// (SNAPSHOT). If continuous, the update may also be run on a thing when a change
	// is detected in a target. For example, an update will run on a thing when
	// the thing is added to a target group, even after the update was completed
	// by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.
	TargetSelection *string `locationName:"targetSelection" type:"string" enum:"TargetSelection"`

	// The targeted devices to receive OTA updates.
	//
	// Targets is a required field
	Targets []*string `locationName:"targets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateOTAUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOTAUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOTAUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOTAUpdateInput"}
	if s.Files == nil {
		invalidParams.Add(request.NewErrParamRequired("Files"))
	}
	if s.Files != nil && len(s.Files) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Files", 1))
	}
	if s.OtaUpdateId == nil {
		invalidParams.Add(request.NewErrParamRequired("OtaUpdateId"))
	}
	if s.OtaUpdateId != nil && len(*s.OtaUpdateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OtaUpdateId", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.AwsJobExecutionsRolloutConfig != nil {
		if err := s.AwsJobExecutionsRolloutConfig.Validate(); err != nil {
			invalidParams.AddNested("AwsJobExecutionsRolloutConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Files != nil {
		for i, v := range s.Files {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Files", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalParameters sets the AdditionalParameters field's value.
func (s *CreateOTAUpdateInput) SetAdditionalParameters(v map[string]*string) *CreateOTAUpdateInput {
	s.AdditionalParameters = v
	return s
}

// SetAwsJobExecutionsRolloutConfig sets the AwsJobExecutionsRolloutConfig field's value.
func (s *CreateOTAUpdateInput) SetAwsJobExecutionsRolloutConfig(v *AwsJobExecutionsRolloutConfig) *CreateOTAUpdateInput {
	s.AwsJobExecutionsRolloutConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateOTAUpdateInput) SetDescription(v string) *CreateOTAUpdateInput {
	s.Description = &v
	return s
}

// SetFiles sets the Files field's value.
func (s *CreateOTAUpdateInput) SetFiles(v []*OTAUpdateFile) *CreateOTAUpdateInput {
	s.Files = v
	return s
}

// SetOtaUpdateId sets the OtaUpdateId field's value.
func (s *CreateOTAUpdateInput) SetOtaUpdateId(v string) *CreateOTAUpdateInput {
	s.OtaUpdateId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateOTAUpdateInput) SetRoleArn(v string) *CreateOTAUpdateInput {
	s.RoleArn = &v
	return s
}

// SetTargetSelection sets the TargetSelection field's value.
func (s *CreateOTAUpdateInput) SetTargetSelection(v string) *CreateOTAUpdateInput {
	s.TargetSelection = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateOTAUpdateInput) SetTargets(v []*string) *CreateOTAUpdateInput {
	s.Targets = v
	return s
}

type CreateOTAUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The AWS IoT job ARN associated with the OTA update.
	AwsIotJobArn *string `locationName:"awsIotJobArn" type:"string"`

	// The AWS IoT job ID associated with the OTA update.
	AwsIotJobId *string `locationName:"awsIotJobId" type:"string"`

	// The OTA update ARN.
	OtaUpdateArn *string `locationName:"otaUpdateArn" type:"string"`

	// The OTA update ID.
	OtaUpdateId *string `locationName:"otaUpdateId" min:"1" type:"string"`

	// The OTA update status.
	OtaUpdateStatus *string `locationName:"otaUpdateStatus" type:"string" enum:"OTAUpdateStatus"`
}

// String returns the string representation
func (s CreateOTAUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOTAUpdateOutput) GoString() string {
	return s.String()
}

// SetAwsIotJobArn sets the AwsIotJobArn field's value.
func (s *CreateOTAUpdateOutput) SetAwsIotJobArn(v string) *CreateOTAUpdateOutput {
	s.AwsIotJobArn = &v
	return s
}

// SetAwsIotJobId sets the AwsIotJobId field's value.
func (s *CreateOTAUpdateOutput) SetAwsIotJobId(v string) *CreateOTAUpdateOutput {
	s.AwsIotJobId = &v
	return s
}

// SetOtaUpdateArn sets the OtaUpdateArn field's value.
func (s *CreateOTAUpdateOutput) SetOtaUpdateArn(v string) *CreateOTAUpdateOutput {
	s.OtaUpdateArn = &v
	return s
}

// SetOtaUpdateId sets the OtaUpdateId field's value.
func (s *CreateOTAUpdateOutput) SetOtaUpdateId(v string) *CreateOTAUpdateOutput {
	s.OtaUpdateId = &v
	return s
}

// SetOtaUpdateStatus sets the OtaUpdateStatus field's value.
func (s *CreateOTAUpdateOutput) SetOtaUpdateStatus(v string) *CreateOTAUpdateOutput {
	s.OtaUpdateStatus = &v
	return s
}

// The input for the CreatePolicy operation.
type CreatePolicyInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that describes the policy. policyDocument must have a minimum
	// length of 1, with a maximum length of 2048, excluding whitespace.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyInput) SetPolicyDocument(v string) *CreatePolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyInput) SetPolicyName(v string) *CreatePolicyInput {
	s.PolicyName = &v
	return s
}

// The output from the CreatePolicy operation.
type CreatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s CreatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreatePolicyOutput) SetPolicyArn(v string) *CreatePolicyOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyOutput) SetPolicyDocument(v string) *CreatePolicyOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyOutput) SetPolicyName(v string) *CreatePolicyOutput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *CreatePolicyOutput) SetPolicyVersionId(v string) *CreatePolicyOutput {
	s.PolicyVersionId = &v
	return s
}

// The input for the CreatePolicyVersion operation.
type CreatePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that describes the policy. Minimum length of 1. Maximum
	// length of 2048, excluding whitespace.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// Specifies whether the policy version is set as the default. When this parameter
	// is true, the new policy version becomes the operative version (that is, the
	// version that is in effect for the certificates to which the policy is attached).
	SetAsDefault *bool `location:"querystring" locationName:"setAsDefault" type:"boolean"`
}

// String returns the string representation
func (s CreatePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyVersionInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyVersionInput) SetPolicyDocument(v string) *CreatePolicyVersionInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyVersionInput) SetPolicyName(v string) *CreatePolicyVersionInput {
	s.PolicyName = &v
	return s
}

// SetSetAsDefault sets the SetAsDefault field's value.
func (s *CreatePolicyVersionInput) SetSetAsDefault(v bool) *CreatePolicyVersionInput {
	s.SetAsDefault = &v
	return s
}

// The output of the CreatePolicyVersion operation.
type CreatePolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s CreatePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionOutput) GoString() string {
	return s.String()
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *CreatePolicyVersionOutput) SetIsDefaultVersion(v bool) *CreatePolicyVersionOutput {
	s.IsDefaultVersion = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreatePolicyVersionOutput) SetPolicyArn(v string) *CreatePolicyVersionOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyVersionOutput) SetPolicyDocument(v string) *CreatePolicyVersionOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *CreatePolicyVersionOutput) SetPolicyVersionId(v string) *CreatePolicyVersionOutput {
	s.PolicyVersionId = &v
	return s
}

type CreateRoleAliasInput struct {
	_ struct{} `type:"structure"`

	// How long (in seconds) the credentials will be valid.
	CredentialDurationSeconds *int64 `locationName:"credentialDurationSeconds" min:"900" type:"integer"`

	// The role alias that points to a role ARN. This allows you to change the role
	// without having to update the device.
	//
	// RoleAlias is a required field
	RoleAlias *string `location:"uri" locationName:"roleAlias" min:"1" type:"string" required:"true"`

	// The role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRoleAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoleAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoleAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoleAliasInput"}
	if s.CredentialDurationSeconds != nil && *s.CredentialDurationSeconds < 900 {
		invalidParams.Add(request.NewErrParamMinValue("CredentialDurationSeconds", 900))
	}
	if s.RoleAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleAlias"))
	}
	if s.RoleAlias != nil && len(*s.RoleAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleAlias", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialDurationSeconds sets the CredentialDurationSeconds field's value.
func (s *CreateRoleAliasInput) SetCredentialDurationSeconds(v int64) *CreateRoleAliasInput {
	s.CredentialDurationSeconds = &v
	return s
}

// SetRoleAlias sets the RoleAlias field's value.
func (s *CreateRoleAliasInput) SetRoleAlias(v string) *CreateRoleAliasInput {
	s.RoleAlias = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateRoleAliasInput) SetRoleArn(v string) *CreateRoleAliasInput {
	s.RoleArn = &v
	return s
}

type CreateRoleAliasOutput struct {
	_ struct{} `type:"structure"`

	// The role alias.
	RoleAlias *string `locationName:"roleAlias" min:"1" type:"string"`

	// The role alias ARN.
	RoleAliasArn *string `locationName:"roleAliasArn" type:"string"`
}

// String returns the string representation
func (s CreateRoleAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoleAliasOutput) GoString() string {
	return s.String()
}

// SetRoleAlias sets the RoleAlias field's value.
func (s *CreateRoleAliasOutput) SetRoleAlias(v string) *CreateRoleAliasOutput {
	s.RoleAlias = &v
	return s
}

// SetRoleAliasArn sets the RoleAliasArn field's value.
func (s *CreateRoleAliasOutput) SetRoleAliasArn(v string) *CreateRoleAliasOutput {
	s.RoleAliasArn = &v
	return s
}

type CreateScheduledAuditInput struct {
	_ struct{} `type:"structure"`

	// The day of the month on which the scheduled audit takes place. Can be "1"
	// through "31" or "LAST". This field is required if the "frequency" parameter
	// is set to "MONTHLY". If days 29-31 are specified, and the month does not
	// have that many days, the audit takes place on the "LAST" day of the month.
	DayOfMonth *string `locationName:"dayOfMonth" type:"string"`

	// The day of the week on which the scheduled audit takes place. Can be one
	// of "SUN", "MON", "TUE", "WED", "THU", "FRI" or "SAT". This field is required
	// if the "frequency" parameter is set to "WEEKLY" or "BIWEEKLY".
	DayOfWeek *string `locationName:"dayOfWeek" type:"string" enum:"DayOfWeek"`

	// How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY",
	// "BIWEEKLY" or "MONTHLY". The actual start time of each audit is determined
	// by the system.
	//
	// Frequency is a required field
	Frequency *string `locationName:"frequency" type:"string" required:"true" enum:"AuditFrequency"`

	// The name you want to give to the scheduled audit. (Max. 128 chars)
	//
	// ScheduledAuditName is a required field
	ScheduledAuditName *string `location:"uri" locationName:"scheduledAuditName" min:"1" type:"string" required:"true"`

	// Which checks are performed during the scheduled audit. Checks must be enabled
	// for your account. (Use DescribeAccountAuditConfiguration to see the list
	// of all checks including those that are enabled or UpdateAccountAuditConfiguration
	// to select which checks are enabled.)
	//
	// TargetCheckNames is a required field
	TargetCheckNames []*string `locationName:"targetCheckNames" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateScheduledAuditInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScheduledAuditInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScheduledAuditInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScheduledAuditInput"}
	if s.Frequency == nil {
		invalidParams.Add(request.NewErrParamRequired("Frequency"))
	}
	if s.ScheduledAuditName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledAuditName"))
	}
	if s.ScheduledAuditName != nil && len(*s.ScheduledAuditName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledAuditName", 1))
	}
	if s.TargetCheckNames == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetCheckNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDayOfMonth sets the DayOfMonth field's value.
func (s *CreateScheduledAuditInput) SetDayOfMonth(v string) *CreateScheduledAuditInput {
	s.DayOfMonth = &v
	return s
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *CreateScheduledAuditInput) SetDayOfWeek(v string) *CreateScheduledAuditInput {
	s.DayOfWeek = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *CreateScheduledAuditInput) SetFrequency(v string) *CreateScheduledAuditInput {
	s.Frequency = &v
	return s
}

// SetScheduledAuditName sets the ScheduledAuditName field's value.
func (s *CreateScheduledAuditInput) SetScheduledAuditName(v string) *CreateScheduledAuditInput {
	s.ScheduledAuditName = &v
	return s
}

// SetTargetCheckNames sets the TargetCheckNames field's value.
func (s *CreateScheduledAuditInput) SetTargetCheckNames(v []*string) *CreateScheduledAuditInput {
	s.TargetCheckNames = v
	return s
}

type CreateScheduledAuditOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the scheduled audit.
	ScheduledAuditArn *string `locationName:"scheduledAuditArn" type:"string"`
}

// String returns the string representation
func (s CreateScheduledAuditOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScheduledAuditOutput) GoString() string {
	return s.String()
}

// SetScheduledAuditArn sets the ScheduledAuditArn field's value.
func (s *CreateScheduledAuditOutput) SetScheduledAuditArn(v string) *CreateScheduledAuditOutput {
	s.ScheduledAuditArn = &v
	return s
}

type CreateSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// Specifies the destinations to which alerts are sent. (Alerts are always sent
	// to the console.) Alerts are generated when a device (thing) violates a behavior.
	AlertTargets map[string]*AlertTarget `locationName:"alertTargets" type:"map"`

	// Specifies the behaviors that, when violated by a device (thing), cause an
	// alert.
	//
	// Behaviors is a required field
	Behaviors []*Behavior `locationName:"behaviors" type:"list" required:"true"`

	// A description of the security profile.
	SecurityProfileDescription *string `locationName:"securityProfileDescription" type:"string"`

	// The name you are giving to the security profile.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`

	// Metadata which can be used to manage the security profile.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityProfileInput"}
	if s.Behaviors == nil {
		invalidParams.Add(request.NewErrParamRequired("Behaviors"))
	}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}
	if s.AlertTargets != nil {
		for i, v := range s.AlertTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AlertTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Behaviors != nil {
		for i, v := range s.Behaviors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Behaviors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlertTargets sets the AlertTargets field's value.
func (s *CreateSecurityProfileInput) SetAlertTargets(v map[string]*AlertTarget) *CreateSecurityProfileInput {
	s.AlertTargets = v
	return s
}

// SetBehaviors sets the Behaviors field's value.
func (s *CreateSecurityProfileInput) SetBehaviors(v []*Behavior) *CreateSecurityProfileInput {
	s.Behaviors = v
	return s
}

// SetSecurityProfileDescription sets the SecurityProfileDescription field's value.
func (s *CreateSecurityProfileInput) SetSecurityProfileDescription(v string) *CreateSecurityProfileInput {
	s.SecurityProfileDescription = &v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *CreateSecurityProfileInput) SetSecurityProfileName(v string) *CreateSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSecurityProfileInput) SetTags(v []*Tag) *CreateSecurityProfileInput {
	s.Tags = v
	return s
}

type CreateSecurityProfileOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the security profile.
	SecurityProfileArn *string `locationName:"securityProfileArn" type:"string"`

	// The name you gave to the security profile.
	SecurityProfileName *string `locationName:"securityProfileName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityProfileOutput) GoString() string {
	return s.String()
}

// SetSecurityProfileArn sets the SecurityProfileArn field's value.
func (s *CreateSecurityProfileOutput) SetSecurityProfileArn(v string) *CreateSecurityProfileOutput {
	s.SecurityProfileArn = &v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *CreateSecurityProfileOutput) SetSecurityProfileName(v string) *CreateSecurityProfileOutput {
	s.SecurityProfileName = &v
	return s
}

type CreateStreamInput struct {
	_ struct{} `type:"structure"`

	// A description of the stream.
	Description *string `locationName:"description" type:"string"`

	// The files to stream.
	//
	// Files is a required field
	Files []*StreamFile `locationName:"files" min:"1" type:"list" required:"true"`

	// An IAM role that allows the IoT service principal assumes to access your
	// S3 files.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The stream ID.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamInput"}
	if s.Files == nil {
		invalidParams.Add(request.NewErrParamRequired("Files"))
	}
	if s.Files != nil && len(s.Files) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Files", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamId", 1))
	}
	if s.Files != nil {
		for i, v := range s.Files {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Files", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateStreamInput) SetDescription(v string) *CreateStreamInput {
	s.Description = &v
	return s
}

// SetFiles sets the Files field's value.
func (s *CreateStreamInput) SetFiles(v []*StreamFile) *CreateStreamInput {
	s.Files = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateStreamInput) SetRoleArn(v string) *CreateStreamInput {
	s.RoleArn = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *CreateStreamInput) SetStreamId(v string) *CreateStreamInput {
	s.StreamId = &v
	return s
}

type CreateStreamOutput struct {
	_ struct{} `type:"structure"`

	// A description of the stream.
	Description *string `locationName:"description" type:"string"`

	// The stream ARN.
	StreamArn *string `locationName:"streamArn" type:"string"`

	// The stream ID.
	StreamId *string `locationName:"streamId" min:"1" type:"string"`

	// The version of the stream.
	StreamVersion *int64 `locationName:"streamVersion" type:"integer"`
}

// String returns the string representation
func (s CreateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateStreamOutput) SetDescription(v string) *CreateStreamOutput {
	s.Description = &v
	return s
}

// SetStreamArn sets the StreamArn field's value.
func (s *CreateStreamOutput) SetStreamArn(v string) *CreateStreamOutput {
	s.StreamArn = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *CreateStreamOutput) SetStreamId(v string) *CreateStreamOutput {
	s.StreamId = &v
	return s
}

// SetStreamVersion sets the StreamVersion field's value.
func (s *CreateStreamOutput) SetStreamVersion(v int64) *CreateStreamOutput {
	s.StreamVersion = &v
	return s
}

type CreateThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parent thing group.
	ParentGroupName *string `locationName:"parentGroupName" min:"1" type:"string"`

	// Metadata which can be used to manage the thing group.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The thing group name to create.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`

	// The thing group properties.
	ThingGroupProperties *ThingGroupProperties `locationName:"thingGroupProperties" type:"structure"`
}

// String returns the string representation
func (s CreateThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThingGroupInput"}
	if s.ParentGroupName != nil && len(*s.ParentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentGroupName", 1))
	}
	if s.ThingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParentGroupName sets the ParentGroupName field's value.
func (s *CreateThingGroupInput) SetParentGroupName(v string) *CreateThingGroupInput {
	s.ParentGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateThingGroupInput) SetTags(v []*Tag) *CreateThingGroupInput {
	s.Tags = v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *CreateThingGroupInput) SetThingGroupName(v string) *CreateThingGroupInput {
	s.ThingGroupName = &v
	return s
}

// SetThingGroupProperties sets the ThingGroupProperties field's value.
func (s *CreateThingGroupInput) SetThingGroupProperties(v *ThingGroupProperties) *CreateThingGroupInput {
	s.ThingGroupProperties = v
	return s
}

type CreateThingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The thing group ARN.
	ThingGroupArn *string `locationName:"thingGroupArn" type:"string"`

	// The thing group ID.
	ThingGroupId *string `locationName:"thingGroupId" min:"1" type:"string"`

	// The thing group name.
	ThingGroupName *string `locationName:"thingGroupName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingGroupOutput) GoString() string {
	return s.String()
}

// SetThingGroupArn sets the ThingGroupArn field's value.
func (s *CreateThingGroupOutput) SetThingGroupArn(v string) *CreateThingGroupOutput {
	s.ThingGroupArn = &v
	return s
}

// SetThingGroupId sets the ThingGroupId field's value.
func (s *CreateThingGroupOutput) SetThingGroupId(v string) *CreateThingGroupOutput {
	s.ThingGroupId = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *CreateThingGroupOutput) SetThingGroupName(v string) *CreateThingGroupOutput {
	s.ThingGroupName = &v
	return s
}

// The input for the CreateThing operation.
type CreateThingInput struct {
	_ struct{} `type:"structure"`

	// The attribute payload, which consists of up to three name/value pairs in
	// a JSON document. For example:
	//
	// {\"attributes\":{\"string1\":\"string2\"}}
	AttributePayload *AttributePayload `locationName:"attributePayload" type:"structure"`

	// The name of the billing group the thing will be added to.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`

	// The name of the thing to create.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`

	// The name of the thing type associated with the new thing.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThingInput"}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributePayload sets the AttributePayload field's value.
func (s *CreateThingInput) SetAttributePayload(v *AttributePayload) *CreateThingInput {
	s.AttributePayload = v
	return s
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *CreateThingInput) SetBillingGroupName(v string) *CreateThingInput {
	s.BillingGroupName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *CreateThingInput) SetThingName(v string) *CreateThingInput {
	s.ThingName = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *CreateThingInput) SetThingTypeName(v string) *CreateThingInput {
	s.ThingTypeName = &v
	return s
}

// The output of the CreateThing operation.
type CreateThingOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new thing.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The thing ID.
	ThingId *string `locationName:"thingId" type:"string"`

	// The name of the new thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingOutput) GoString() string {
	return s.String()
}

// SetThingArn sets the ThingArn field's value.
func (s *CreateThingOutput) SetThingArn(v string) *CreateThingOutput {
	s.ThingArn = &v
	return s
}

// SetThingId sets the ThingId field's value.
func (s *CreateThingOutput) SetThingId(v string) *CreateThingOutput {
	s.ThingId = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *CreateThingOutput) SetThingName(v string) *CreateThingOutput {
	s.ThingName = &v
	return s
}

// The input for the CreateThingType operation.
type CreateThingTypeInput struct {
	_ struct{} `type:"structure"`

	// Metadata which can be used to manage the thing type.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The name of the thing type.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`

	// The ThingTypeProperties for the thing type to create. It contains information
	// about the new thing type including a description, and a list of searchable
	// thing attribute names.
	ThingTypeProperties *ThingTypeProperties `locationName:"thingTypeProperties" type:"structure"`
}

// String returns the string representation
func (s CreateThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *CreateThingTypeInput) SetTags(v []*Tag) *CreateThingTypeInput {
	s.Tags = v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *CreateThingTypeInput) SetThingTypeName(v string) *CreateThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// SetThingTypeProperties sets the ThingTypeProperties field's value.
func (s *CreateThingTypeInput) SetThingTypeProperties(v *ThingTypeProperties) *CreateThingTypeInput {
	s.ThingTypeProperties = v
	return s
}

// The output of the CreateThingType operation.
type CreateThingTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the thing type.
	ThingTypeArn *string `locationName:"thingTypeArn" type:"string"`

	// The thing type ID.
	ThingTypeId *string `locationName:"thingTypeId" type:"string"`

	// The name of the thing type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingTypeOutput) GoString() string {
	return s.String()
}

// SetThingTypeArn sets the ThingTypeArn field's value.
func (s *CreateThingTypeOutput) SetThingTypeArn(v string) *CreateThingTypeOutput {
	s.ThingTypeArn = &v
	return s
}

// SetThingTypeId sets the ThingTypeId field's value.
func (s *CreateThingTypeOutput) SetThingTypeId(v string) *CreateThingTypeOutput {
	s.ThingTypeId = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *CreateThingTypeOutput) SetThingTypeName(v string) *CreateThingTypeOutput {
	s.ThingTypeName = &v
	return s
}

// The input for the CreateTopicRule operation.
type CreateTopicRuleInput struct {
	_ struct{} `type:"structure" payload:"TopicRulePayload"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`

	// Metadata which can be used to manage the topic rule.
	//
	// For URI Request parameters use format: ...key1=value1&key2=value2...
	//
	// For the CLI command-line parameter use format: --tags "key1=value1&key2=value2..."
	//
	// For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
	Tags *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// The rule payload.
	//
	// TopicRulePayload is a required field
	TopicRulePayload *TopicRulePayload `locationName:"topicRulePayload" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.TopicRulePayload == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicRulePayload"))
	}
	if s.TopicRulePayload != nil {
		if err := s.TopicRulePayload.Validate(); err != nil {
			invalidParams.AddNested("TopicRulePayload", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *CreateTopicRuleInput) SetRuleName(v string) *CreateTopicRuleInput {
	s.RuleName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTopicRuleInput) SetTags(v string) *CreateTopicRuleInput {
	s.Tags = &v
	return s
}

// SetTopicRulePayload sets the TopicRulePayload field's value.
func (s *CreateTopicRuleInput) SetTopicRulePayload(v *TopicRulePayload) *CreateTopicRuleInput {
	s.TopicRulePayload = v
	return s
}

type CreateTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes a custom method used to code sign a file.
type CustomCodeSigning struct {
	_ struct{} `type:"structure"`

	// The certificate chain.
	CertificateChain *CodeSigningCertificateChain `locationName:"certificateChain" type:"structure"`

	// The hash algorithm used to code sign the file.
	HashAlgorithm *string `locationName:"hashAlgorithm" type:"string"`

	// The signature for the file.
	Signature *CodeSigningSignature `locationName:"signature" type:"structure"`

	// The signature algorithm used to code sign the file.
	SignatureAlgorithm *string `locationName:"signatureAlgorithm" type:"string"`
}

// String returns the string representation
func (s CustomCodeSigning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomCodeSigning) GoString() string {
	return s.String()
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *CustomCodeSigning) SetCertificateChain(v *CodeSigningCertificateChain) *CustomCodeSigning {
	s.CertificateChain = v
	return s
}

// SetHashAlgorithm sets the HashAlgorithm field's value.
func (s *CustomCodeSigning) SetHashAlgorithm(v string) *CustomCodeSigning {
	s.HashAlgorithm = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *CustomCodeSigning) SetSignature(v *CodeSigningSignature) *CustomCodeSigning {
	s.Signature = v
	return s
}

// SetSignatureAlgorithm sets the SignatureAlgorithm field's value.
func (s *CustomCodeSigning) SetSignatureAlgorithm(v string) *CustomCodeSigning {
	s.SignatureAlgorithm = &v
	return s
}

type DeleteAccountAuditConfigurationInput struct {
	_ struct{} `type:"structure"`

	// If true, all scheduled audits are deleted.
	DeleteScheduledAudits *bool `location:"querystring" locationName:"deleteScheduledAudits" type:"boolean"`
}

// String returns the string representation
func (s DeleteAccountAuditConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAuditConfigurationInput) GoString() string {
	return s.String()
}

// SetDeleteScheduledAudits sets the DeleteScheduledAudits field's value.
func (s *DeleteAccountAuditConfigurationInput) SetDeleteScheduledAudits(v bool) *DeleteAccountAuditConfigurationInput {
	s.DeleteScheduledAudits = &v
	return s
}

type DeleteAccountAuditConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountAuditConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAuditConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// The name of the authorizer to delete.
	//
	// AuthorizerName is a required field
	AuthorizerName *string `location:"uri" locationName:"authorizerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAuthorizerInput"}
	if s.AuthorizerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerName"))
	}
	if s.AuthorizerName != nil && len(*s.AuthorizerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *DeleteAuthorizerInput) SetAuthorizerName(v string) *DeleteAuthorizerInput {
	s.AuthorizerName = &v
	return s
}

type DeleteAuthorizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAuthorizerOutput) GoString() string {
	return s.String()
}

type DeleteBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the billing group.
	//
	// BillingGroupName is a required field
	BillingGroupName *string `location:"uri" locationName:"billingGroupName" min:"1" type:"string" required:"true"`

	// The expected version of the billing group. If the version of the billing
	// group does not match the expected version specified in the request, the DeleteBillingGroup
	// request is rejected with a VersionConflictException.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`
}

// String returns the string representation
func (s DeleteBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBillingGroupInput"}
	if s.BillingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("BillingGroupName"))
	}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *DeleteBillingGroupInput) SetBillingGroupName(v string) *DeleteBillingGroupInput {
	s.BillingGroupName = &v
	return s
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteBillingGroupInput) SetExpectedVersion(v int64) *DeleteBillingGroupInput {
	s.ExpectedVersion = &v
	return s
}

type DeleteBillingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBillingGroupOutput) GoString() string {
	return s.String()
}

// Input for the DeleteCACertificate operation.
type DeleteCACertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate to delete. (The last part of the certificate ARN
	// contains the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCACertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCACertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCACertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DeleteCACertificateInput) SetCertificateId(v string) *DeleteCACertificateInput {
	s.CertificateId = &v
	return s
}

// The output for the DeleteCACertificate operation.
type DeleteCACertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCACertificateOutput) GoString() string {
	return s.String()
}

// The input for the DeleteCertificate operation.
type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// Forces a certificate request to be deleted.
	ForceDelete *bool `location:"querystring" locationName:"forceDelete" type:"boolean"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DeleteCertificateInput) SetCertificateId(v string) *DeleteCertificateInput {
	s.CertificateId = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeleteCertificateInput) SetForceDelete(v bool) *DeleteCertificateInput {
	s.ForceDelete = &v
	return s
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

type DeleteDynamicThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the dynamic thing group to delete.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the dynamic thing group to delete.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDynamicThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDynamicThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDynamicThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDynamicThingGroupInput"}
	if s.ThingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteDynamicThingGroupInput) SetExpectedVersion(v int64) *DeleteDynamicThingGroupInput {
	s.ExpectedVersion = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *DeleteDynamicThingGroupInput) SetThingGroupName(v string) *DeleteDynamicThingGroupInput {
	s.ThingGroupName = &v
	return s
}

type DeleteDynamicThingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDynamicThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDynamicThingGroupOutput) GoString() string {
	return s.String()
}

type DeleteJobExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the job execution to be deleted. The executionNumber refers to
	// the execution of a particular job on a particular device.
	//
	// Note that once a job execution is deleted, the executionNumber may be reused
	// by IoT, so be sure you get and use the correct value here.
	//
	// ExecutionNumber is a required field
	ExecutionNumber *int64 `location:"uri" locationName:"executionNumber" type:"long" required:"true"`

	// (Optional) When true, you can delete a job execution which is "IN_PROGRESS".
	// Otherwise, you can only delete a job execution which is in a terminal state
	// ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception
	// will occur. The default is false.
	//
	// Deleting a job execution which is "IN_PROGRESS", will cause the device to
	// be unable to access job information or update the job execution status. Use
	// caution and ensure that the device is able to recover to a valid state.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The ID of the job whose execution on a particular device will be deleted.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// The name of the thing whose job execution will be deleted.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobExecutionInput"}
	if s.ExecutionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionNumber"))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionNumber sets the ExecutionNumber field's value.
func (s *DeleteJobExecutionInput) SetExecutionNumber(v int64) *DeleteJobExecutionInput {
	s.ExecutionNumber = &v
	return s
}

// SetForce sets the Force field's value.
func (s *DeleteJobExecutionInput) SetForce(v bool) *DeleteJobExecutionInput {
	s.Force = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteJobExecutionInput) SetJobId(v string) *DeleteJobExecutionInput {
	s.JobId = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DeleteJobExecutionInput) SetThingName(v string) *DeleteJobExecutionInput {
	s.ThingName = &v
	return s
}

type DeleteJobExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteJobExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobExecutionOutput) GoString() string {
	return s.String()
}

type DeleteJobInput struct {
	_ struct{} `type:"structure"`

	// (Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise,
	// you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED")
	// or an exception will occur. The default is false.
	//
	// Deleting a job which is "IN_PROGRESS", will cause a device which is executing
	// the job to be unable to access job information or update the job execution
	// status. Use caution and ensure that each device executing a job which is
	// deleted is able to recover to a valid state.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The ID of the job to be deleted.
	//
	// After a job deletion is completed, you may reuse this jobId when you create
	// a new job. However, this is not recommended, and you must ensure that your
	// devices are not using the jobId to refer to the deleted job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *DeleteJobInput) SetForce(v bool) *DeleteJobInput {
	s.Force = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteJobInput) SetJobId(v string) *DeleteJobInput {
	s.JobId = &v
	return s
}

type DeleteJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobOutput) GoString() string {
	return s.String()
}

type DeleteOTAUpdateInput struct {
	_ struct{} `type:"structure"`

	// Specifies if the stream associated with an OTA update should be deleted when
	// the OTA update is deleted.
	DeleteStream *bool `location:"querystring" locationName:"deleteStream" type:"boolean"`

	// Specifies if the AWS Job associated with the OTA update should be deleted
	// with the OTA update is deleted.
	ForceDeleteAWSJob *bool `location:"querystring" locationName:"forceDeleteAWSJob" type:"boolean"`

	// The OTA update ID to delete.
	//
	// OtaUpdateId is a required field
	OtaUpdateId *string `location:"uri" locationName:"otaUpdateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOTAUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOTAUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOTAUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOTAUpdateInput"}
	if s.OtaUpdateId == nil {
		invalidParams.Add(request.NewErrParamRequired("OtaUpdateId"))
	}
	if s.OtaUpdateId != nil && len(*s.OtaUpdateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OtaUpdateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteStream sets the DeleteStream field's value.
func (s *DeleteOTAUpdateInput) SetDeleteStream(v bool) *DeleteOTAUpdateInput {
	s.DeleteStream = &v
	return s
}

// SetForceDeleteAWSJob sets the ForceDeleteAWSJob field's value.
func (s *DeleteOTAUpdateInput) SetForceDeleteAWSJob(v bool) *DeleteOTAUpdateInput {
	s.ForceDeleteAWSJob = &v
	return s
}

// SetOtaUpdateId sets the OtaUpdateId field's value.
func (s *DeleteOTAUpdateInput) SetOtaUpdateId(v string) *DeleteOTAUpdateInput {
	s.OtaUpdateId = &v
	return s
}

type DeleteOTAUpdateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOTAUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOTAUpdateOutput) GoString() string {
	return s.String()
}

// The input for the DeletePolicy operation.
type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to delete.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeletePolicyInput) SetPolicyName(v string) *DeletePolicyInput {
	s.PolicyName = &v
	return s
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

// The input for the DeletePolicyVersion operation.
type DeletePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	//
	// PolicyVersionId is a required field
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyVersionInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyVersionId"))
	}
	if s.PolicyVersionId != nil && len(*s.PolicyVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeletePolicyVersionInput) SetPolicyName(v string) *DeletePolicyVersionInput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *DeletePolicyVersionInput) SetPolicyVersionId(v string) *DeletePolicyVersionInput {
	s.PolicyVersionId = &v
	return s
}

type DeletePolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionOutput) GoString() string {
	return s.String()
}

// The input for the DeleteRegistrationCode operation.
type DeleteRegistrationCodeInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRegistrationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegistrationCodeInput) GoString() string {
	return s.String()
}

// The output for the DeleteRegistrationCode operation.
type DeleteRegistrationCodeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRegistrationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegistrationCodeOutput) GoString() string {
	return s.String()
}

type DeleteRoleAliasInput struct {
	_ struct{} `type:"structure"`

	// The role alias to delete.
	//
	// RoleAlias is a required field
	RoleAlias *string `location:"uri" locationName:"roleAlias" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRoleAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoleAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoleAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRoleAliasInput"}
	if s.RoleAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleAlias"))
	}
	if s.RoleAlias != nil && len(*s.RoleAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleAlias", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleAlias sets the RoleAlias field's value.
func (s *DeleteRoleAliasInput) SetRoleAlias(v string) *DeleteRoleAliasInput {
	s.RoleAlias = &v
	return s
}

type DeleteRoleAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoleAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoleAliasOutput) GoString() string {
	return s.String()
}

type DeleteScheduledAuditInput struct {
	_ struct{} `type:"structure"`

	// The name of the scheduled audit you want to delete.
	//
	// ScheduledAuditName is a required field
	ScheduledAuditName *string `location:"uri" locationName:"scheduledAuditName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScheduledAuditInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledAuditInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduledAuditInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduledAuditInput"}
	if s.ScheduledAuditName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledAuditName"))
	}
	if s.ScheduledAuditName != nil && len(*s.ScheduledAuditName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledAuditName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduledAuditName sets the ScheduledAuditName field's value.
func (s *DeleteScheduledAuditInput) SetScheduledAuditName(v string) *DeleteScheduledAuditInput {
	s.ScheduledAuditName = &v
	return s
}

type DeleteScheduledAuditOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScheduledAuditOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledAuditOutput) GoString() string {
	return s.String()
}

type DeleteSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the security profile. A new version is generated
	// whenever the security profile is updated. If you specify a value that is
	// different than the actual version, a VersionConflictException is thrown.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the security profile to be deleted.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSecurityProfileInput"}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteSecurityProfileInput) SetExpectedVersion(v int64) *DeleteSecurityProfileInput {
	s.ExpectedVersion = &v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *DeleteSecurityProfileInput) SetSecurityProfileName(v string) *DeleteSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

type DeleteSecurityProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityProfileOutput) GoString() string {
	return s.String()
}

type DeleteStreamInput struct {
	_ struct{} `type:"structure"`

	// The stream ID.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamInput"}
	if s.StreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamId sets the StreamId field's value.
func (s *DeleteStreamInput) SetStreamId(v string) *DeleteStreamInput {
	s.StreamId = &v
	return s
}

type DeleteStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamOutput) GoString() string {
	return s.String()
}

type DeleteThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the thing group to delete.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the thing group to delete.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThingGroupInput"}
	if s.ThingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteThingGroupInput) SetExpectedVersion(v int64) *DeleteThingGroupInput {
	s.ExpectedVersion = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *DeleteThingGroupInput) SetThingGroupName(v string) *DeleteThingGroupInput {
	s.ThingGroupName = &v
	return s
}

type DeleteThingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingGroupOutput) GoString() string {
	return s.String()
}

// The input for the DeleteThing operation.
type DeleteThingInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the thing record in the registry. If the version
	// of the record in the registry does not match the expected version specified
	// in the request, the DeleteThing request is rejected with a VersionConflictException.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the thing to delete.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThingInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteThingInput) SetExpectedVersion(v int64) *DeleteThingInput {
	s.ExpectedVersion = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DeleteThingInput) SetThingName(v string) *DeleteThingInput {
	s.ThingName = &v
	return s
}

// The output of the DeleteThing operation.
type DeleteThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingOutput) GoString() string {
	return s.String()
}

// The input for the DeleteThingType operation.
type DeleteThingTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing type.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DeleteThingTypeInput) SetThingTypeName(v string) *DeleteThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// The output for the DeleteThingType operation.
type DeleteThingTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingTypeOutput) GoString() string {
	return s.String()
}

// The input for the DeleteTopicRule operation.
type DeleteTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *DeleteTopicRuleInput) SetRuleName(v string) *DeleteTopicRuleInput {
	s.RuleName = &v
	return s
}

type DeleteTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleOutput) GoString() string {
	return s.String()
}

type DeleteV2LoggingLevelInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource for which you are configuring logging.
	//
	// TargetName is a required field
	TargetName *string `location:"querystring" locationName:"targetName" type:"string" required:"true"`

	// The type of resource for which you are configuring logging. Must be THING_Group.
	//
	// TargetType is a required field
	TargetType *string `location:"querystring" locationName:"targetType" type:"string" required:"true" enum:"LogTargetType"`
}

// String returns the string representation
func (s DeleteV2LoggingLevelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteV2LoggingLevelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteV2LoggingLevelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteV2LoggingLevelInput"}
	if s.TargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetName"))
	}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetName sets the TargetName field's value.
func (s *DeleteV2LoggingLevelInput) SetTargetName(v string) *DeleteV2LoggingLevelInput {
	s.TargetName = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *DeleteV2LoggingLevelInput) SetTargetType(v string) *DeleteV2LoggingLevelInput {
	s.TargetType = &v
	return s
}

type DeleteV2LoggingLevelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteV2LoggingLevelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteV2LoggingLevelOutput) GoString() string {
	return s.String()
}

// Contains information that denied the authorization.
type Denied struct {
	_ struct{} `type:"structure"`

	// Information that explicitly denies the authorization.
	ExplicitDeny *ExplicitDeny `locationName:"explicitDeny" type:"structure"`

	// Information that implicitly denies the authorization. When a policy doesn't
	// explicitly deny or allow an action on a resource it is considered an implicit
	// deny.
	ImplicitDeny *ImplicitDeny `locationName:"implicitDeny" type:"structure"`
}

// String returns the string representation
func (s Denied) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Denied) GoString() string {
	return s.String()
}

// SetExplicitDeny sets the ExplicitDeny field's value.
func (s *Denied) SetExplicitDeny(v *ExplicitDeny) *Denied {
	s.ExplicitDeny = v
	return s
}

// SetImplicitDeny sets the ImplicitDeny field's value.
func (s *Denied) SetImplicitDeny(v *ImplicitDeny) *Denied {
	s.ImplicitDeny = v
	return s
}

// The input for the DeprecateThingType operation.
type DeprecateThingTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing type to deprecate.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`

	// Whether to undeprecate a deprecated thing type. If true, the thing type will
	// not be deprecated anymore and you can associate it with things.
	UndoDeprecate *bool `locationName:"undoDeprecate" type:"boolean"`
}

// String returns the string representation
func (s DeprecateThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprecateThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DeprecateThingTypeInput) SetThingTypeName(v string) *DeprecateThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// SetUndoDeprecate sets the UndoDeprecate field's value.
func (s *DeprecateThingTypeInput) SetUndoDeprecate(v bool) *DeprecateThingTypeInput {
	s.UndoDeprecate = &v
	return s
}

// The output for the DeprecateThingType operation.
type DeprecateThingTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateThingTypeOutput) GoString() string {
	return s.String()
}

type DescribeAccountAuditConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAuditConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAuditConfigurationInput) GoString() string {
	return s.String()
}

type DescribeAccountAuditConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Which audit checks are enabled and disabled for this account.
	AuditCheckConfigurations map[string]*AuditCheckConfiguration `locationName:"auditCheckConfigurations" type:"map"`

	// Information about the targets to which audit notifications are sent for this
	// account.
	AuditNotificationTargetConfigurations map[string]*AuditNotificationTarget `locationName:"auditNotificationTargetConfigurations" type:"map"`

	// The ARN of the role that grants permission to AWS IoT to access information
	// about your devices, policies, certificates and other items as necessary when
	// performing an audit.
	//
	// On the first call to UpdateAccountAuditConfiguration this parameter is required.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation
func (s DescribeAccountAuditConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAuditConfigurationOutput) GoString() string {
	return s.String()
}

// SetAuditCheckConfigurations sets the AuditCheckConfigurations field's value.
func (s *DescribeAccountAuditConfigurationOutput) SetAuditCheckConfigurations(v map[string]*AuditCheckConfiguration) *DescribeAccountAuditConfigurationOutput {
	s.AuditCheckConfigurations = v
	return s
}

// SetAuditNotificationTargetConfigurations sets the AuditNotificationTargetConfigurations field's value.
func (s *DescribeAccountAuditConfigurationOutput) SetAuditNotificationTargetConfigurations(v map[string]*AuditNotificationTarget) *DescribeAccountAuditConfigurationOutput {
	s.AuditNotificationTargetConfigurations = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeAccountAuditConfigurationOutput) SetRoleArn(v string) *DescribeAccountAuditConfigurationOutput {
	s.RoleArn = &v
	return s
}

type DescribeAuditTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the audit whose information you want to get.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAuditTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAuditTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAuditTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeAuditTaskInput) SetTaskId(v string) *DescribeAuditTaskInput {
	s.TaskId = &v
	return s
}

type DescribeAuditTaskOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about each check performed during this audit.
	AuditDetails map[string]*AuditCheckDetails `locationName:"auditDetails" type:"map"`

	// The name of the scheduled audit (only if the audit was a scheduled audit).
	ScheduledAuditName *string `locationName:"scheduledAuditName" min:"1" type:"string"`

	// The time the audit started.
	TaskStartTime *time.Time `locationName:"taskStartTime" type:"timestamp"`

	// Statistical information about the audit.
	TaskStatistics *TaskStatistics `locationName:"taskStatistics" type:"structure"`

	// The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or
	// "CANCELED".
	TaskStatus *string `locationName:"taskStatus" type:"string" enum:"AuditTaskStatus"`

	// The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
	TaskType *string `locationName:"taskType" type:"string" enum:"AuditTaskType"`
}

// String returns the string representation
func (s DescribeAuditTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditTaskOutput) GoString() string {
	return s.String()
}

// SetAuditDetails sets the AuditDetails field's value.
func (s *DescribeAuditTaskOutput) SetAuditDetails(v map[string]*AuditCheckDetails) *DescribeAuditTaskOutput {
	s.AuditDetails = v
	return s
}

// SetScheduledAuditName sets the ScheduledAuditName field's value.
func (s *DescribeAuditTaskOutput) SetScheduledAuditName(v string) *DescribeAuditTaskOutput {
	s.ScheduledAuditName = &v
	return s
}

// SetTaskStartTime sets the TaskStartTime field's value.
func (s *DescribeAuditTaskOutput) SetTaskStartTime(v time.Time) *DescribeAuditTaskOutput {
	s.TaskStartTime = &v
	return s
}

// SetTaskStatistics sets the TaskStatistics field's value.
func (s *DescribeAuditTaskOutput) SetTaskStatistics(v *TaskStatistics) *DescribeAuditTaskOutput {
	s.TaskStatistics = v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *DescribeAuditTaskOutput) SetTaskStatus(v string) *DescribeAuditTaskOutput {
	s.TaskStatus = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *DescribeAuditTaskOutput) SetTaskType(v string) *DescribeAuditTaskOutput {
	s.TaskType = &v
	return s
}

type DescribeAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// The name of the authorizer to describe.
	//
	// AuthorizerName is a required field
	AuthorizerName *string `location:"uri" locationName:"authorizerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAuthorizerInput"}
	if s.AuthorizerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerName"))
	}
	if s.AuthorizerName != nil && len(*s.AuthorizerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *DescribeAuthorizerInput) SetAuthorizerName(v string) *DescribeAuthorizerInput {
	s.AuthorizerName = &v
	return s
}

type DescribeAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// The authorizer description.
	AuthorizerDescription *AuthorizerDescription `locationName:"authorizerDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorizerDescription sets the AuthorizerDescription field's value.
func (s *DescribeAuthorizerOutput) SetAuthorizerDescription(v *AuthorizerDescription) *DescribeAuthorizerOutput {
	s.AuthorizerDescription = v
	return s
}

type DescribeBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the billing group.
	//
	// BillingGroupName is a required field
	BillingGroupName *string `location:"uri" locationName:"billingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBillingGroupInput"}
	if s.BillingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("BillingGroupName"))
	}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *DescribeBillingGroupInput) SetBillingGroupName(v string) *DescribeBillingGroupInput {
	s.BillingGroupName = &v
	return s
}

type DescribeBillingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the billing group.
	BillingGroupArn *string `locationName:"billingGroupArn" type:"string"`

	// The ID of the billing group.
	BillingGroupId *string `locationName:"billingGroupId" min:"1" type:"string"`

	// Additional information about the billing group.
	BillingGroupMetadata *BillingGroupMetadata `locationName:"billingGroupMetadata" type:"structure"`

	// The name of the billing group.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`

	// The properties of the billing group.
	BillingGroupProperties *BillingGroupProperties `locationName:"billingGroupProperties" type:"structure"`

	// The version of the billing group.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s DescribeBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBillingGroupOutput) GoString() string {
	return s.String()
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupArn(v string) *DescribeBillingGroupOutput {
	s.BillingGroupArn = &v
	return s
}

// SetBillingGroupId sets the BillingGroupId field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupId(v string) *DescribeBillingGroupOutput {
	s.BillingGroupId = &v
	return s
}

// SetBillingGroupMetadata sets the BillingGroupMetadata field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupMetadata(v *BillingGroupMetadata) *DescribeBillingGroupOutput {
	s.BillingGroupMetadata = v
	return s
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupName(v string) *DescribeBillingGroupOutput {
	s.BillingGroupName = &v
	return s
}

// SetBillingGroupProperties sets the BillingGroupProperties field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupProperties(v *BillingGroupProperties) *DescribeBillingGroupOutput {
	s.BillingGroupProperties = v
	return s
}

// SetVersion sets the Version field's value.
func (s *DescribeBillingGroupOutput) SetVersion(v int64) *DescribeBillingGroupOutput {
	s.Version = &v
	return s
}

// The input for the DescribeCACertificate operation.
type DescribeCACertificateInput struct {
	_ struct{} `type:"structure"`

	// The CA certificate identifier.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCACertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCACertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCACertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DescribeCACertificateInput) SetCertificateId(v string) *DescribeCACertificateInput {
	s.CertificateId = &v
	return s
}

// The output from the DescribeCACertificate operation.
type DescribeCACertificateOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificate description.
	CertificateDescription *CACertificateDescription `locationName:"certificateDescription" type:"structure"`

	// Information about the registration configuration.
	RegistrationConfig *RegistrationConfig `locationName:"registrationConfig" type:"structure"`
}

// String returns the string representation
func (s DescribeCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCACertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateDescription sets the CertificateDescription field's value.
func (s *DescribeCACertificateOutput) SetCertificateDescription(v *CACertificateDescription) *DescribeCACertificateOutput {
	s.CertificateDescription = v
	return s
}

// SetRegistrationConfig sets the RegistrationConfig field's value.
func (s *DescribeCACertificateOutput) SetRegistrationConfig(v *RegistrationConfig) *DescribeCACertificateOutput {
	s.RegistrationConfig = v
	return s
}

// The input for the DescribeCertificate operation.
type DescribeCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DescribeCertificateInput) SetCertificateId(v string) *DescribeCertificateInput {
	s.CertificateId = &v
	return s
}

// The output of the DescribeCertificate operation.
type DescribeCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The description of the certificate.
	CertificateDescription *CertificateDescription `locationName:"certificateDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateDescription sets the CertificateDescription field's value.
func (s *DescribeCertificateOutput) SetCertificateDescription(v *CertificateDescription) *DescribeCertificateOutput {
	s.CertificateDescription = v
	return s
}

type DescribeDefaultAuthorizerInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeDefaultAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultAuthorizerInput) GoString() string {
	return s.String()
}

type DescribeDefaultAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// The default authorizer's description.
	AuthorizerDescription *AuthorizerDescription `locationName:"authorizerDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeDefaultAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorizerDescription sets the AuthorizerDescription field's value.
func (s *DescribeDefaultAuthorizerOutput) SetAuthorizerDescription(v *AuthorizerDescription) *DescribeDefaultAuthorizerOutput {
	s.AuthorizerDescription = v
	return s
}

// The input for the DescribeEndpoint operation.
type DescribeEndpointInput struct {
	_ struct{} `type:"structure"`

	// The endpoint type. Valid endpoint types include:
	//
	//    * iot:Data - Returns a VeriSign signed data endpoint.
	//
	//    * iot:Data-ATS - Returns an ATS signed data endpoint.
	//
	//    * iot:CredentialProvider - Returns an AWS IoT credentials provider API
	//    endpoint.
	//
	//    * iot:Jobs - Returns an AWS IoT device management Jobs API endpoint.
	EndpointType *string `location:"querystring" locationName:"endpointType" type:"string"`
}

// String returns the string representation
func (s DescribeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointInput) GoString() string {
	return s.String()
}

// SetEndpointType sets the EndpointType field's value.
func (s *DescribeEndpointInput) SetEndpointType(v string) *DescribeEndpointInput {
	s.EndpointType = &v
	return s
}

// The output from the DescribeEndpoint operation.
type DescribeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint. The format of the endpoint is as follows: identifier.iot.region.amazonaws.com.
	EndpointAddress *string `locationName:"endpointAddress" type:"string"`
}

// String returns the string representation
func (s DescribeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointAddress sets the EndpointAddress field's value.
func (s *DescribeEndpointOutput) SetEndpointAddress(v string) *DescribeEndpointOutput {
	s.EndpointAddress = &v
	return s
}

type DescribeEventConfigurationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeEventConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventConfigurationsInput) GoString() string {
	return s.String()
}

type DescribeEventConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The creation date of the event configuration.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The event configurations.
	EventConfigurations map[string]*Configuration `locationName:"eventConfigurations" type:"map"`

	// The date the event configurations were last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`
}

// String returns the string representation
func (s DescribeEventConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventConfigurationsOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeEventConfigurationsOutput) SetCreationDate(v time.Time) *DescribeEventConfigurationsOutput {
	s.CreationDate = &v
	return s
}

// SetEventConfigurations sets the EventConfigurations field's value.
func (s *DescribeEventConfigurationsOutput) SetEventConfigurations(v map[string]*Configuration) *DescribeEventConfigurationsOutput {
	s.EventConfigurations = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeEventConfigurationsOutput) SetLastModifiedDate(v time.Time) *DescribeEventConfigurationsOutput {
	s.LastModifiedDate = &v
	return s
}

type DescribeIndexInput struct {
	_ struct{} `type:"structure"`

	// The index name.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"indexName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIndexInput"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *DescribeIndexInput) SetIndexName(v string) *DescribeIndexInput {
	s.IndexName = &v
	return s
}

type DescribeIndexOutput struct {
	_ struct{} `type:"structure"`

	// The index name.
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The index status.
	IndexStatus *string `locationName:"indexStatus" type:"string" enum:"IndexStatus"`

	// Contains a value that specifies the type of indexing performed. Valid values
	// are:
	//
	//    * REGISTRY – Your thing index will contain only registry data.
	//
	//    * REGISTRY_AND_SHADOW - Your thing index will contain registry data and
	//    shadow data.
	//
	//    * REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index will contain registry
	//    data and thing connectivity status data.
	//
	//    * REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index will
	//    contain registry data, shadow data, and thing connectivity status data.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s DescribeIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIndexOutput) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *DescribeIndexOutput) SetIndexName(v string) *DescribeIndexOutput {
	s.IndexName = &v
	return s
}

// SetIndexStatus sets the IndexStatus field's value.
func (s *DescribeIndexOutput) SetIndexStatus(v string) *DescribeIndexOutput {
	s.IndexStatus = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *DescribeIndexOutput) SetSchema(v string) *DescribeIndexOutput {
	s.Schema = &v
	return s
}

type DescribeJobExecutionInput struct {
	_ struct{} `type:"structure"`

	// A string (consisting of the digits "0" through "9" which is used to specify
	// a particular job execution on a particular device.
	ExecutionNumber *int64 `location:"querystring" locationName:"executionNumber" type:"long"`

	// The unique identifier you assigned to this job when it was created.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// The name of the thing on which the job execution is running.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeJobExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobExecutionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionNumber sets the ExecutionNumber field's value.
func (s *DescribeJobExecutionInput) SetExecutionNumber(v int64) *DescribeJobExecutionInput {
	s.ExecutionNumber = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeJobExecutionInput) SetJobId(v string) *DescribeJobExecutionInput {
	s.JobId = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DescribeJobExecutionInput) SetThingName(v string) *DescribeJobExecutionInput {
	s.ThingName = &v
	return s
}

type DescribeJobExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the job execution.
	Execution *JobExecution `locationName:"execution" type:"structure"`
}

// String returns the string representation
func (s DescribeJobExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobExecutionOutput) GoString() string {
	return s.String()
}

// SetExecution sets the Execution field's value.
func (s *DescribeJobExecutionOutput) SetExecution(v *JobExecution) *DescribeJobExecutionOutput {
	s.Execution = v
	return s
}

type DescribeJobInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier you assigned to this job when it was created.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeJobInput) SetJobId(v string) *DescribeJobInput {
	s.JobId = &v
	return s
}

type DescribeJobOutput struct {
	_ struct{} `type:"structure"`

	// An S3 link to the job document.
	DocumentSource *string `locationName:"documentSource" min:"1" type:"string"`

	// Information about the job.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation
func (s DescribeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobOutput) GoString() string {
	return s.String()
}

// SetDocumentSource sets the DocumentSource field's value.
func (s *DescribeJobOutput) SetDocumentSource(v string) *DescribeJobOutput {
	s.DocumentSource = &v
	return s
}

// SetJob sets the Job field's value.
func (s *DescribeJobOutput) SetJob(v *Job) *DescribeJobOutput {
	s.Job = v
	return s
}

type DescribeRoleAliasInput struct {
	_ struct{} `type:"structure"`

	// The role alias to describe.
	//
	// RoleAlias is a required field
	RoleAlias *string `location:"uri" locationName:"roleAlias" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRoleAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRoleAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRoleAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRoleAliasInput"}
	if s.RoleAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleAlias"))
	}
	if s.RoleAlias != nil && len(*s.RoleAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleAlias", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleAlias sets the RoleAlias field's value.
func (s *DescribeRoleAliasInput) SetRoleAlias(v string) *DescribeRoleAliasInput {
	s.RoleAlias = &v
	return s
}

type DescribeRoleAliasOutput struct {
	_ struct{} `type:"structure"`

	// The role alias description.
	RoleAliasDescription *RoleAliasDescription `locationName:"roleAliasDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeRoleAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRoleAliasOutput) GoString() string {
	return s.String()
}

// SetRoleAliasDescription sets the RoleAliasDescription field's value.
func (s *DescribeRoleAliasOutput) SetRoleAliasDescription(v *RoleAliasDescription) *DescribeRoleAliasOutput {
	s.RoleAliasDescription = v
	return s
}

type DescribeScheduledAuditInput struct {
	_ struct{} `type:"structure"`

	// The name of the scheduled audit whose information you want to get.
	//
	// ScheduledAuditName is a required field
	ScheduledAuditName *string `location:"uri" locationName:"scheduledAuditName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeScheduledAuditInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledAuditInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduledAuditInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduledAuditInput"}
	if s.ScheduledAuditName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledAuditName"))
	}
	if s.ScheduledAuditName != nil && len(*s.ScheduledAuditName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledAuditName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduledAuditName sets the ScheduledAuditName field's value.
func (s *DescribeScheduledAuditInput) SetScheduledAuditName(v string) *DescribeScheduledAuditInput {
	s.ScheduledAuditName = &v
	return s
}

type DescribeScheduledAuditOutput struct {
	_ struct{} `type:"structure"`

	// The day of the month on which the scheduled audit takes place. Will be "1"
	// through "31" or "LAST". If days 29-31 are specified, and the month does not
	// have that many days, the audit takes place on the "LAST" day of the month.
	DayOfMonth *string `locationName:"dayOfMonth" type:"string"`

	// The day of the week on which the scheduled audit takes place. One of "SUN",
	// "MON", "TUE", "WED", "THU", "FRI" or "SAT".
	DayOfWeek *string `locationName:"dayOfWeek" type:"string" enum:"DayOfWeek"`

	// How often the scheduled audit takes place. One of "DAILY", "WEEKLY", "BIWEEKLY"
	// or "MONTHLY". The actual start time of each audit is determined by the system.
	Frequency *string `locationName:"frequency" type:"string" enum:"AuditFrequency"`

	// The ARN of the scheduled audit.
	ScheduledAuditArn *string `locationName:"scheduledAuditArn" type:"string"`

	// The name of the scheduled audit.
	ScheduledAuditName *string `locationName:"scheduledAuditName" min:"1" type:"string"`

	// Which checks are performed during the scheduled audit. (Note that checks
	// must be enabled for your account. (Use DescribeAccountAuditConfiguration
	// to see the list of all checks including those that are enabled or UpdateAccountAuditConfiguration
	// to select which checks are enabled.)
	TargetCheckNames []*string `locationName:"targetCheckNames" type:"list"`
}

// String returns the string representation
func (s DescribeScheduledAuditOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledAuditOutput) GoString() string {
	return s.String()
}

// SetDayOfMonth sets the DayOfMonth field's value.
func (s *DescribeScheduledAuditOutput) SetDayOfMonth(v string) *DescribeScheduledAuditOutput {
	s.DayOfMonth = &v
	return s
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *DescribeScheduledAuditOutput) SetDayOfWeek(v string) *DescribeScheduledAuditOutput {
	s.DayOfWeek = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *DescribeScheduledAuditOutput) SetFrequency(v string) *DescribeScheduledAuditOutput {
	s.Frequency = &v
	return s
}

// SetScheduledAuditArn sets the ScheduledAuditArn field's value.
func (s *DescribeScheduledAuditOutput) SetScheduledAuditArn(v string) *DescribeScheduledAuditOutput {
	s.ScheduledAuditArn = &v
	return s
}

// SetScheduledAuditName sets the ScheduledAuditName field's value.
func (s *DescribeScheduledAuditOutput) SetScheduledAuditName(v string) *DescribeScheduledAuditOutput {
	s.ScheduledAuditName = &v
	return s
}

// SetTargetCheckNames sets the TargetCheckNames field's value.
func (s *DescribeScheduledAuditOutput) SetTargetCheckNames(v []*string) *DescribeScheduledAuditOutput {
	s.TargetCheckNames = v
	return s
}

type DescribeSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the security profile whose information you want to get.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecurityProfileInput"}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *DescribeSecurityProfileInput) SetSecurityProfileName(v string) *DescribeSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

type DescribeSecurityProfileOutput struct {
	_ struct{} `type:"structure"`

	// Where the alerts are sent. (Alerts are always sent to the console.)
	AlertTargets map[string]*AlertTarget `locationName:"alertTargets" type:"map"`

	// Specifies the behaviors that, when violated by a device (thing), cause an
	// alert.
	Behaviors []*Behavior `locationName:"behaviors" type:"list"`

	// The time the security profile was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The time the security profile was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The ARN of the security profile.
	SecurityProfileArn *string `locationName:"securityProfileArn" type:"string"`

	// A description of the security profile (associated with the security profile
	// when it was created or updated).
	SecurityProfileDescription *string `locationName:"securityProfileDescription" type:"string"`

	// The name of the security profile.
	SecurityProfileName *string `locationName:"securityProfileName" min:"1" type:"string"`

	// The version of the security profile. A new version is generated whenever
	// the security profile is updated.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s DescribeSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityProfileOutput) GoString() string {
	return s.String()
}

// SetAlertTargets sets the AlertTargets field's value.
func (s *DescribeSecurityProfileOutput) SetAlertTargets(v map[string]*AlertTarget) *DescribeSecurityProfileOutput {
	s.AlertTargets = v
	return s
}

// SetBehaviors sets the Behaviors field's value.
func (s *DescribeSecurityProfileOutput) SetBehaviors(v []*Behavior) *DescribeSecurityProfileOutput {
	s.Behaviors = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeSecurityProfileOutput) SetCreationDate(v time.Time) *DescribeSecurityProfileOutput {
	s.CreationDate = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeSecurityProfileOutput) SetLastModifiedDate(v time.Time) *DescribeSecurityProfileOutput {
	s.LastModifiedDate = &v
	return s
}

// SetSecurityProfileArn sets the SecurityProfileArn field's value.
func (s *DescribeSecurityProfileOutput) SetSecurityProfileArn(v string) *DescribeSecurityProfileOutput {
	s.SecurityProfileArn = &v
	return s
}

// SetSecurityProfileDescription sets the SecurityProfileDescription field's value.
func (s *DescribeSecurityProfileOutput) SetSecurityProfileDescription(v string) *DescribeSecurityProfileOutput {
	s.SecurityProfileDescription = &v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *DescribeSecurityProfileOutput) SetSecurityProfileName(v string) *DescribeSecurityProfileOutput {
	s.SecurityProfileName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DescribeSecurityProfileOutput) SetVersion(v int64) *DescribeSecurityProfileOutput {
	s.Version = &v
	return s
}

type DescribeStreamInput struct {
	_ struct{} `type:"structure"`

	// The stream ID.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStreamInput"}
	if s.StreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamId sets the StreamId field's value.
func (s *DescribeStreamInput) SetStreamId(v string) *DescribeStreamInput {
	s.StreamId = &v
	return s
}

type DescribeStreamOutput struct {
	_ struct{} `type:"structure"`

	// Information about the stream.
	StreamInfo *StreamInfo `locationName:"streamInfo" type:"structure"`
}

// String returns the string representation
func (s DescribeStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStreamOutput) GoString() string {
	return s.String()
}

// SetStreamInfo sets the StreamInfo field's value.
func (s *DescribeStreamOutput) SetStreamInfo(v *StreamInfo) *DescribeStreamOutput {
	s.StreamInfo = v
	return s
}

type DescribeThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing group.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThingGroupInput"}
	if s.ThingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *DescribeThingGroupInput) SetThingGroupName(v string) *DescribeThingGroupInput {
	s.ThingGroupName = &v
	return s
}

type DescribeThingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The dynamic thing group index name.
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The dynamic thing group search query string.
	QueryString *string `locationName:"queryString" min:"1" type:"string"`

	// The dynamic thing group query version.
	QueryVersion *string `locationName:"queryVersion" type:"string"`

	// The dynamic thing group status.
	Status *string `locationName:"status" type:"string" enum:"DynamicGroupStatus"`

	// The thing group ARN.
	ThingGroupArn *string `locationName:"thingGroupArn" type:"string"`

	// The thing group ID.
	ThingGroupId *string `locationName:"thingGroupId" min:"1" type:"string"`

	// Thing group metadata.
	ThingGroupMetadata *ThingGroupMetadata `locationName:"thingGroupMetadata" type:"structure"`

	// The name of the thing group.
	ThingGroupName *string `locationName:"thingGroupName" min:"1" type:"string"`

	// The thing group properties.
	ThingGroupProperties *ThingGroupProperties `locationName:"thingGroupProperties" type:"structure"`

	// The version of the thing group.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s DescribeThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingGroupOutput) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *DescribeThingGroupOutput) SetIndexName(v string) *DescribeThingGroupOutput {
	s.IndexName = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *DescribeThingGroupOutput) SetQueryString(v string) *DescribeThingGroupOutput {
	s.QueryString = &v
	return s
}

// SetQueryVersion sets the QueryVersion field's value.
func (s *DescribeThingGroupOutput) SetQueryVersion(v string) *DescribeThingGroupOutput {
	s.QueryVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeThingGroupOutput) SetStatus(v string) *DescribeThingGroupOutput {
	s.Status = &v
	return s
}

// SetThingGroupArn sets the ThingGroupArn field's value.
func (s *DescribeThingGroupOutput) SetThingGroupArn(v string) *DescribeThingGroupOutput {
	s.ThingGroupArn = &v
	return s
}

// SetThingGroupId sets the ThingGroupId field's value.
func (s *DescribeThingGroupOutput) SetThingGroupId(v string) *DescribeThingGroupOutput {
	s.ThingGroupId = &v
	return s
}

// SetThingGroupMetadata sets the ThingGroupMetadata field's value.
func (s *DescribeThingGroupOutput) SetThingGroupMetadata(v *ThingGroupMetadata) *DescribeThingGroupOutput {
	s.ThingGroupMetadata = v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *DescribeThingGroupOutput) SetThingGroupName(v string) *DescribeThingGroupOutput {
	s.ThingGroupName = &v
	return s
}

// SetThingGroupProperties sets the ThingGroupProperties field's value.
func (s *DescribeThingGroupOutput) SetThingGroupProperties(v *ThingGroupProperties) *DescribeThingGroupOutput {
	s.ThingGroupProperties = v
	return s
}

// SetVersion sets the Version field's value.
func (s *DescribeThingGroupOutput) SetVersion(v int64) *DescribeThingGroupOutput {
	s.Version = &v
	return s
}

// The input for the DescribeThing operation.
type DescribeThingInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThingInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingName sets the ThingName field's value.
func (s *DescribeThingInput) SetThingName(v string) *DescribeThingInput {
	s.ThingName = &v
	return s
}

// The output from the DescribeThing operation.
type DescribeThingOutput struct {
	_ struct{} `type:"structure"`

	// The thing attributes.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The name of the billing group the thing belongs to.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`

	// The default client ID.
	DefaultClientId *string `locationName:"defaultClientId" type:"string"`

	// The ARN of the thing to describe.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The ID of the thing to describe.
	ThingId *string `locationName:"thingId" type:"string"`

	// The name of the thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`

	// The thing type name.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`

	// The current version of the thing record in the registry.
	//
	// To avoid unintentional changes to the information in the registry, you can
	// pass the version information in the expectedVersion parameter of the UpdateThing
	// and DeleteThing calls.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s DescribeThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DescribeThingOutput) SetAttributes(v map[string]*string) *DescribeThingOutput {
	s.Attributes = v
	return s
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *DescribeThingOutput) SetBillingGroupName(v string) *DescribeThingOutput {
	s.BillingGroupName = &v
	return s
}

// SetDefaultClientId sets the DefaultClientId field's value.
func (s *DescribeThingOutput) SetDefaultClientId(v string) *DescribeThingOutput {
	s.DefaultClientId = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *DescribeThingOutput) SetThingArn(v string) *DescribeThingOutput {
	s.ThingArn = &v
	return s
}

// SetThingId sets the ThingId field's value.
func (s *DescribeThingOutput) SetThingId(v string) *DescribeThingOutput {
	s.ThingId = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DescribeThingOutput) SetThingName(v string) *DescribeThingOutput {
	s.ThingName = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DescribeThingOutput) SetThingTypeName(v string) *DescribeThingOutput {
	s.ThingTypeName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DescribeThingOutput) SetVersion(v int64) *DescribeThingOutput {
	s.Version = &v
	return s
}

type DescribeThingRegistrationTaskInput struct {
	_ struct{} `type:"structure"`

	// The task ID.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeThingRegistrationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingRegistrationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThingRegistrationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThingRegistrationTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeThingRegistrationTaskInput) SetTaskId(v string) *DescribeThingRegistrationTaskInput {
	s.TaskId = &v
	return s
}

type DescribeThingRegistrationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The task creation date.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The number of things that failed to be provisioned.
	FailureCount *int64 `locationName:"failureCount" type:"integer"`

	// The S3 bucket that contains the input file.
	InputFileBucket *string `locationName:"inputFileBucket" min:"3" type:"string"`

	// The input file key.
	InputFileKey *string `locationName:"inputFileKey" min:"1" type:"string"`

	// The date when the task was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The message.
	Message *string `locationName:"message" type:"string"`

	// The progress of the bulk provisioning task expressed as a percentage.
	PercentageProgress *int64 `locationName:"percentageProgress" type:"integer"`

	// The role ARN that grants access to the input file bucket.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The status of the bulk thing provisioning task.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// The number of things successfully provisioned.
	SuccessCount *int64 `locationName:"successCount" type:"integer"`

	// The task ID.
	TaskId *string `locationName:"taskId" type:"string"`

	// The task's template.
	TemplateBody *string `locationName:"templateBody" type:"string"`
}

// String returns the string representation
func (s DescribeThingRegistrationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingRegistrationTaskOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeThingRegistrationTaskOutput) SetCreationDate(v time.Time) *DescribeThingRegistrationTaskOutput {
	s.CreationDate = &v
	return s
}

// SetFailureCount sets the FailureCount field's value.
func (s *DescribeThingRegistrationTaskOutput) SetFailureCount(v int64) *DescribeThingRegistrationTaskOutput {
	s.FailureCount = &v
	return s
}

// SetInputFileBucket sets the InputFileBucket field's value.
func (s *DescribeThingRegistrationTaskOutput) SetInputFileBucket(v string) *DescribeThingRegistrationTaskOutput {
	s.InputFileBucket = &v
	return s
}

// SetInputFileKey sets the InputFileKey field's value.
func (s *DescribeThingRegistrationTaskOutput) SetInputFileKey(v string) *DescribeThingRegistrationTaskOutput {
	s.InputFileKey = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeThingRegistrationTaskOutput) SetLastModifiedDate(v time.Time) *DescribeThingRegistrationTaskOutput {
	s.LastModifiedDate = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DescribeThingRegistrationTaskOutput) SetMessage(v string) *DescribeThingRegistrationTaskOutput {
	s.Message = &v
	return s
}

// SetPercentageProgress sets the PercentageProgress field's value.
func (s *DescribeThingRegistrationTaskOutput) SetPercentageProgress(v int64) *DescribeThingRegistrationTaskOutput {
	s.PercentageProgress = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeThingRegistrationTaskOutput) SetRoleArn(v string) *DescribeThingRegistrationTaskOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeThingRegistrationTaskOutput) SetStatus(v string) *DescribeThingRegistrationTaskOutput {
	s.Status = &v
	return s
}

// SetSuccessCount sets the SuccessCount field's value.
func (s *DescribeThingRegistrationTaskOutput) SetSuccessCount(v int64) *DescribeThingRegistrationTaskOutput {
	s.SuccessCount = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeThingRegistrationTaskOutput) SetTaskId(v string) *DescribeThingRegistrationTaskOutput {
	s.TaskId = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *DescribeThingRegistrationTaskOutput) SetTemplateBody(v string) *DescribeThingRegistrationTaskOutput {
	s.TemplateBody = &v
	return s
}

// The input for the DescribeThingType operation.
type DescribeThingTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing type.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DescribeThingTypeInput) SetThingTypeName(v string) *DescribeThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// The output for the DescribeThingType operation.
type DescribeThingTypeOutput struct {
	_ struct{} `type:"structure"`

	// The thing type ARN.
	ThingTypeArn *string `locationName:"thingTypeArn" type:"string"`

	// The thing type ID.
	ThingTypeId *string `locationName:"thingTypeId" type:"string"`

	// The ThingTypeMetadata contains additional information about the thing type
	// including: creation date and time, a value indicating whether the thing type
	// is deprecated, and a date and time when it was deprecated.
	ThingTypeMetadata *ThingTypeMetadata `locationName:"thingTypeMetadata" type:"structure"`

	// The name of the thing type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`

	// The ThingTypeProperties contains information about the thing type including
	// description, and a list of searchable thing attribute names.
	ThingTypeProperties *ThingTypeProperties `locationName:"thingTypeProperties" type:"structure"`
}

// String returns the string representation
func (s DescribeThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingTypeOutput) GoString() string {
	return s.String()
}

// SetThingTypeArn sets the ThingTypeArn field's value.
func (s *DescribeThingTypeOutput) SetThingTypeArn(v string) *DescribeThingTypeOutput {
	s.ThingTypeArn = &v
	return s
}

// SetThingTypeId sets the ThingTypeId field's value.
func (s *DescribeThingTypeOutput) SetThingTypeId(v string) *DescribeThingTypeOutput {
	s.ThingTypeId = &v
	return s
}

// SetThingTypeMetadata sets the ThingTypeMetadata field's value.
func (s *DescribeThingTypeOutput) SetThingTypeMetadata(v *ThingTypeMetadata) *DescribeThingTypeOutput {
	s.ThingTypeMetadata = v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DescribeThingTypeOutput) SetThingTypeName(v string) *DescribeThingTypeOutput {
	s.ThingTypeName = &v
	return s
}

// SetThingTypeProperties sets the ThingTypeProperties field's value.
func (s *DescribeThingTypeOutput) SetThingTypeProperties(v *ThingTypeProperties) *DescribeThingTypeOutput {
	s.ThingTypeProperties = v
	return s
}

// Describes the location of the updated firmware.
type Destination struct {
	_ struct{} `type:"structure"`

	// Describes the location in S3 of the updated firmware.
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Destination"}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Destination sets the S3Destination field's value.
func (s *Destination) SetS3Destination(v *S3Destination) *Destination {
	s.S3Destination = v
	return s
}

type DetachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy to detach.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The target from which the policy will be detached.
	//
	// Target is a required field
	Target *string `locationName:"target" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DetachPolicyInput) SetPolicyName(v string) *DetachPolicyInput {
	s.PolicyName = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *DetachPolicyInput) SetTarget(v string) *DetachPolicyInput {
	s.Target = &v
	return s
}

type DetachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPolicyOutput) GoString() string {
	return s.String()
}

// The input for the DetachPrincipalPolicy operation.
type DetachPrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to detach.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The principal.
	//
	// If the principal is a certificate, specify the certificate ARN. If the principal
	// is an Amazon Cognito identity, specify the identity ID.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachPrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPrincipalPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachPrincipalPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachPrincipalPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DetachPrincipalPolicyInput) SetPolicyName(v string) *DetachPrincipalPolicyInput {
	s.PolicyName = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *DetachPrincipalPolicyInput) SetPrincipal(v string) *DetachPrincipalPolicyInput {
	s.Principal = &v
	return s
}

type DetachPrincipalPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachPrincipalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPrincipalPolicyOutput) GoString() string {
	return s.String()
}

type DetachSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The security profile that is detached.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`

	// The ARN of the thing group from which the security profile is detached.
	//
	// SecurityProfileTargetArn is a required field
	SecurityProfileTargetArn *string `location:"querystring" locationName:"securityProfileTargetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachSecurityProfileInput"}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}
	if s.SecurityProfileTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileTargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *DetachSecurityProfileInput) SetSecurityProfileName(v string) *DetachSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

// SetSecurityProfileTargetArn sets the SecurityProfileTargetArn field's value.
func (s *DetachSecurityProfileInput) SetSecurityProfileTargetArn(v string) *DetachSecurityProfileInput {
	s.SecurityProfileTargetArn = &v
	return s
}

type DetachSecurityProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachSecurityProfileOutput) GoString() string {
	return s.String()
}

// The input for the DetachThingPrincipal operation.
type DetachThingPrincipalInput struct {
	_ struct{} `type:"structure"`

	// If the principal is a certificate, this value must be ARN of the certificate.
	// If the principal is an Amazon Cognito identity, this value must be the ID
	// of the Amazon Cognito identity.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachThingPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachThingPrincipalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachThingPrincipalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachThingPrincipalInput"}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipal sets the Principal field's value.
func (s *DetachThingPrincipalInput) SetPrincipal(v string) *DetachThingPrincipalInput {
	s.Principal = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DetachThingPrincipalInput) SetThingName(v string) *DetachThingPrincipalInput {
	s.ThingName = &v
	return s
}

// The output from the DetachThingPrincipal operation.
type DetachThingPrincipalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachThingPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachThingPrincipalOutput) GoString() string {
	return s.String()
}

// The input for the DisableTopicRuleRequest operation.
type DisableTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule to disable.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *DisableTopicRuleInput) SetRuleName(v string) *DisableTopicRuleInput {
	s.RuleName = &v
	return s
}

type DisableTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes an action to write to a DynamoDB table.
//
// The tableName, hashKeyField, and rangeKeyField values must match the values
// used when you created the table.
//
// The hashKeyValue and rangeKeyvalue fields use a substitution template syntax.
// These templates provide data at runtime. The syntax is as follows: ${sql-expression}.
//
// You can specify any valid expression in a WHERE or SELECT clause, including
// JSON properties, comparisons, calculations, and functions. For example, the
// following field uses the third level of the topic:
//
// "hashKeyValue": "${topic(3)}"
//
// The following field uses the timestamp:
//
// "rangeKeyValue": "${timestamp()}"
type DynamoDBAction struct {
	_ struct{} `type:"structure"`

	// The hash key name.
	//
	// HashKeyField is a required field
	HashKeyField *string `locationName:"hashKeyField" type:"string" required:"true"`

	// The hash key type. Valid values are "STRING" or "NUMBER"
	HashKeyType *string `locationName:"hashKeyType" type:"string" enum:"DynamoKeyType"`

	// The hash key value.
	//
	// HashKeyValue is a required field
	HashKeyValue *string `locationName:"hashKeyValue" type:"string" required:"true"`

	// The type of operation to be performed. This follows the substitution template,
	// so it can be ${operation}, but the substitution must result in one of the
	// following: INSERT, UPDATE, or DELETE.
	Operation *string `locationName:"operation" type:"string"`

	// The action payload. This name can be customized.
	PayloadField *string `locationName:"payloadField" type:"string"`

	// The range key name.
	RangeKeyField *string `locationName:"rangeKeyField" type:"string"`

	// The range key type. Valid values are "STRING" or "NUMBER"
	RangeKeyType *string `locationName:"rangeKeyType" type:"string" enum:"DynamoKeyType"`

	// The range key value.
	RangeKeyValue *string `locationName:"rangeKeyValue" type:"string"`

	// The ARN of the IAM role that grants access to the DynamoDB table.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the DynamoDB table.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`
}

// String returns the string representation
func (s DynamoDBAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynamoDBAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDBAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamoDBAction"}
	if s.HashKeyField == nil {
		invalidParams.Add(request.NewErrParamRequired("HashKeyField"))
	}
	if s.HashKeyValue == nil {
		invalidParams.Add(request.NewErrParamRequired("HashKeyValue"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHashKeyField sets the HashKeyField field's value.
func (s *DynamoDBAction) SetHashKeyField(v string) *DynamoDBAction {
	s.HashKeyField = &v
	return s
}

// SetHashKeyType sets the HashKeyType field's value.
func (s *DynamoDBAction) SetHashKeyType(v string) *DynamoDBAction {
	s.HashKeyType = &v
	return s
}

// SetHashKeyValue sets the HashKeyValue field's value.
func (s *DynamoDBAction) SetHashKeyValue(v string) *DynamoDBAction {
	s.HashKeyValue = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *DynamoDBAction) SetOperation(v string) *DynamoDBAction {
	s.Operation = &v
	return s
}

// SetPayloadField sets the PayloadField field's value.
func (s *DynamoDBAction) SetPayloadField(v string) *DynamoDBAction {
	s.PayloadField = &v
	return s
}

// SetRangeKeyField sets the RangeKeyField field's value.
func (s *DynamoDBAction) SetRangeKeyField(v string) *DynamoDBAction {
	s.RangeKeyField = &v
	return s
}

// SetRangeKeyType sets the RangeKeyType field's value.
func (s *DynamoDBAction) SetRangeKeyType(v string) *DynamoDBAction {
	s.RangeKeyType = &v
	return s
}

// SetRangeKeyValue sets the RangeKeyValue field's value.
func (s *DynamoDBAction) SetRangeKeyValue(v string) *DynamoDBAction {
	s.RangeKeyValue = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DynamoDBAction) SetRoleArn(v string) *DynamoDBAction {
	s.RoleArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DynamoDBAction) SetTableName(v string) *DynamoDBAction {
	s.TableName = &v
	return s
}

// Describes an action to write to a DynamoDB table.
//
// This DynamoDB action writes each attribute in the message payload into it's
// own column in the DynamoDB table.
type DynamoDBv2Action struct {
	_ struct{} `type:"structure"`

	// Specifies the DynamoDB table to which the message data will be written. For
	// example:
	//
	// { "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName":
	// "my-table" } } }
	//
	// Each attribute in the message payload will be written to a separate column
	// in the DynamoDB database.
	//
	// PutItem is a required field
	PutItem *PutItemInput `locationName:"putItem" type:"structure" required:"true"`

	// The ARN of the IAM role that grants access to the DynamoDB table.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DynamoDBv2Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynamoDBv2Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDBv2Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamoDBv2Action"}
	if s.PutItem == nil {
		invalidParams.Add(request.NewErrParamRequired("PutItem"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.PutItem != nil {
		if err := s.PutItem.Validate(); err != nil {
			invalidParams.AddNested("PutItem", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPutItem sets the PutItem field's value.
func (s *DynamoDBv2Action) SetPutItem(v *PutItemInput) *DynamoDBv2Action {
	s.PutItem = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DynamoDBv2Action) SetRoleArn(v string) *DynamoDBv2Action {
	s.RoleArn = &v
	return s
}

// The policy that has the effect on the authorization results.
type EffectivePolicy struct {
	_ struct{} `type:"structure"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The IAM policy document.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`
}

// String returns the string representation
func (s EffectivePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EffectivePolicy) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *EffectivePolicy) SetPolicyArn(v string) *EffectivePolicy {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *EffectivePolicy) SetPolicyDocument(v string) *EffectivePolicy {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *EffectivePolicy) SetPolicyName(v string) *EffectivePolicy {
	s.PolicyName = &v
	return s
}

// Describes an action that writes data to an Amazon Elasticsearch Service domain.
type ElasticsearchAction struct {
	_ struct{} `type:"structure"`

	// The endpoint of your Elasticsearch domain.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" type:"string" required:"true"`

	// The unique identifier for the document you are storing.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The Elasticsearch index where you want to store your data.
	//
	// Index is a required field
	Index *string `locationName:"index" type:"string" required:"true"`

	// The IAM role ARN that has access to Elasticsearch.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The type of document you are storing.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticsearchAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchAction"}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Index == nil {
		invalidParams.Add(request.NewErrParamRequired("Index"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpoint sets the Endpoint field's value.
func (s *ElasticsearchAction) SetEndpoint(v string) *ElasticsearchAction {
	s.Endpoint = &v
	return s
}

// SetId sets the Id field's value.
func (s *ElasticsearchAction) SetId(v string) *ElasticsearchAction {
	s.Id = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *ElasticsearchAction) SetIndex(v string) *ElasticsearchAction {
	s.Index = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ElasticsearchAction) SetRoleArn(v string) *ElasticsearchAction {
	s.RoleArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *ElasticsearchAction) SetType(v string) *ElasticsearchAction {
	s.Type = &v
	return s
}

// The input for the EnableTopicRuleRequest operation.
type EnableTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the topic rule to enable.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *EnableTopicRuleInput) SetRuleName(v string) *EnableTopicRuleInput {
	s.RuleName = &v
	return s
}

type EnableTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableTopicRuleOutput) GoString() string {
	return s.String()
}

// Error information.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string"`

	// The error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorInfo) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ErrorInfo) SetCode(v string) *ErrorInfo {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ErrorInfo) SetMessage(v string) *ErrorInfo {
	s.Message = &v
	return s
}

// Information that explicitly denies authorization.
type ExplicitDeny struct {
	_ struct{} `type:"structure"`

	// The policies that denied the authorization.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ExplicitDeny) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExplicitDeny) GoString() string {
	return s.String()
}

// SetPolicies sets the Policies field's value.
func (s *ExplicitDeny) SetPolicies(v []*Policy) *ExplicitDeny {
	s.Policies = v
	return s
}

// Allows you to create an exponential rate of rollout for a job.
type ExponentialRolloutRate struct {
	_ struct{} `type:"structure"`

	// The minimum number of things that will be notified of a pending job, per
	// minute at the start of job rollout. This parameter allows you to define the
	// initial rate of rollout.
	//
	// BaseRatePerMinute is a required field
	BaseRatePerMinute *int64 `locationName:"baseRatePerMinute" min:"1" type:"integer" required:"true"`

	// The exponential factor to increase the rate of rollout for a job.
	//
	// IncrementFactor is a required field
	IncrementFactor *float64 `locationName:"incrementFactor" min:"1" type:"double" required:"true"`

	// The criteria to initiate the increase in rate of rollout for a job.
	//
	// AWS IoT supports up to one digit after the decimal (for example, 1.5, but
	// not 1.55).
	//
	// RateIncreaseCriteria is a required field
	RateIncreaseCriteria *RateIncreaseCriteria `locationName:"rateIncreaseCriteria" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExponentialRolloutRate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExponentialRolloutRate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExponentialRolloutRate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExponentialRolloutRate"}
	if s.BaseRatePerMinute == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseRatePerMinute"))
	}
	if s.BaseRatePerMinute != nil && *s.BaseRatePerMinute < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BaseRatePerMinute", 1))
	}
	if s.IncrementFactor == nil {
		invalidParams.Add(request.NewErrParamRequired("IncrementFactor"))
	}
	if s.IncrementFactor != nil && *s.IncrementFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("IncrementFactor", 1))
	}
	if s.RateIncreaseCriteria == nil {
		invalidParams.Add(request.NewErrParamRequired("RateIncreaseCriteria"))
	}
	if s.RateIncreaseCriteria != nil {
		if err := s.RateIncreaseCriteria.Validate(); err != nil {
			invalidParams.AddNested("RateIncreaseCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseRatePerMinute sets the BaseRatePerMinute field's value.
func (s *ExponentialRolloutRate) SetBaseRatePerMinute(v int64) *ExponentialRolloutRate {
	s.BaseRatePerMinute = &v
	return s
}

// SetIncrementFactor sets the IncrementFactor field's value.
func (s *ExponentialRolloutRate) SetIncrementFactor(v float64) *ExponentialRolloutRate {
	s.IncrementFactor = &v
	return s
}

// SetRateIncreaseCriteria sets the RateIncreaseCriteria field's value.
func (s *ExponentialRolloutRate) SetRateIncreaseCriteria(v *RateIncreaseCriteria) *ExponentialRolloutRate {
	s.RateIncreaseCriteria = v
	return s
}

// The location of the OTA update.
type FileLocation struct {
	_ struct{} `type:"structure"`

	// The location of the updated firmware in S3.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`

	// The stream that contains the OTA update.
	Stream *Stream `locationName:"stream" type:"structure"`
}

// String returns the string representation
func (s FileLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FileLocation"}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}
	if s.Stream != nil {
		if err := s.Stream.Validate(); err != nil {
			invalidParams.AddNested("Stream", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Location sets the S3Location field's value.
func (s *FileLocation) SetS3Location(v *S3Location) *FileLocation {
	s.S3Location = v
	return s
}

// SetStream sets the Stream field's value.
func (s *FileLocation) SetStream(v *Stream) *FileLocation {
	s.Stream = v
	return s
}

// Describes an action that writes data to an Amazon Kinesis Firehose stream.
type FirehoseAction struct {
	_ struct{} `type:"structure"`

	// The delivery stream name.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `locationName:"deliveryStreamName" type:"string" required:"true"`

	// The IAM role that grants access to the Amazon Kinesis Firehose stream.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// A character separator that will be used to separate records written to the
	// Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows
	// newline), ',' (comma).
	Separator *string `locationName:"separator" type:"string"`
}

// String returns the string representation
func (s FirehoseAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FirehoseAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirehoseAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FirehoseAction"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *FirehoseAction) SetDeliveryStreamName(v string) *FirehoseAction {
	s.DeliveryStreamName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *FirehoseAction) SetRoleArn(v string) *FirehoseAction {
	s.RoleArn = &v
	return s
}

// SetSeparator sets the Separator field's value.
func (s *FirehoseAction) SetSeparator(v string) *FirehoseAction {
	s.Separator = &v
	return s
}

type GetEffectivePoliciesInput struct {
	_ struct{} `type:"structure"`

	// The Cognito identity pool ID.
	CognitoIdentityPoolId *string `locationName:"cognitoIdentityPoolId" type:"string"`

	// The principal.
	Principal *string `locationName:"principal" type:"string"`

	// The thing name.
	ThingName *string `location:"querystring" locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetEffectivePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEffectivePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEffectivePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEffectivePoliciesInput"}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCognitoIdentityPoolId sets the CognitoIdentityPoolId field's value.
func (s *GetEffectivePoliciesInput) SetCognitoIdentityPoolId(v string) *GetEffectivePoliciesInput {
	s.CognitoIdentityPoolId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *GetEffectivePoliciesInput) SetPrincipal(v string) *GetEffectivePoliciesInput {
	s.Principal = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *GetEffectivePoliciesInput) SetThingName(v string) *GetEffectivePoliciesInput {
	s.ThingName = &v
	return s
}

type GetEffectivePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The effective policies.
	EffectivePolicies []*EffectivePolicy `locationName:"effectivePolicies" type:"list"`
}

// String returns the string representation
func (s GetEffectivePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEffectivePoliciesOutput) GoString() string {
	return s.String()
}

// SetEffectivePolicies sets the EffectivePolicies field's value.
func (s *GetEffectivePoliciesOutput) SetEffectivePolicies(v []*EffectivePolicy) *GetEffectivePoliciesOutput {
	s.EffectivePolicies = v
	return s
}

type GetIndexingConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetIndexingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIndexingConfigurationInput) GoString() string {
	return s.String()
}

type GetIndexingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The index configuration.
	ThingGroupIndexingConfiguration *ThingGroupIndexingConfiguration `locationName:"thingGroupIndexingConfiguration" type:"structure"`

	// Thing indexing configuration.
	ThingIndexingConfiguration *ThingIndexingConfiguration `locationName:"thingIndexingConfiguration" type:"structure"`
}

// String returns the string representation
func (s GetIndexingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIndexingConfigurationOutput) GoString() string {
	return s.String()
}

// SetThingGroupIndexingConfiguration sets the ThingGroupIndexingConfiguration field's value.
func (s *GetIndexingConfigurationOutput) SetThingGroupIndexingConfiguration(v *ThingGroupIndexingConfiguration) *GetIndexingConfigurationOutput {
	s.ThingGroupIndexingConfiguration = v
	return s
}

// SetThingIndexingConfiguration sets the ThingIndexingConfiguration field's value.
func (s *GetIndexingConfigurationOutput) SetThingIndexingConfiguration(v *ThingIndexingConfiguration) *GetIndexingConfigurationOutput {
	s.ThingIndexingConfiguration = v
	return s
}

type GetJobDocumentInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier you assigned to this job when it was created.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobDocumentInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetJobDocumentInput) SetJobId(v string) *GetJobDocumentInput {
	s.JobId = &v
	return s
}

type GetJobDocumentOutput struct {
	_ struct{} `type:"structure"`

	// The job document content.
	Document *string `locationName:"document" type:"string"`
}

// String returns the string representation
func (s GetJobDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobDocumentOutput) GoString() string {
	return s.String()
}

// SetDocument sets the Document field's value.
func (s *GetJobDocumentOutput) SetDocument(v string) *GetJobDocumentOutput {
	s.Document = &v
	return s
}

// The input for the GetLoggingOptions operation.
type GetLoggingOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingOptionsInput) GoString() string {
	return s.String()
}

// The output from the GetLoggingOptions operation.
type GetLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The logging level.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// The ARN of the IAM role that grants access.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s GetLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingOptionsOutput) GoString() string {
	return s.String()
}

// SetLogLevel sets the LogLevel field's value.
func (s *GetLoggingOptionsOutput) SetLogLevel(v string) *GetLoggingOptionsOutput {
	s.LogLevel = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetLoggingOptionsOutput) SetRoleArn(v string) *GetLoggingOptionsOutput {
	s.RoleArn = &v
	return s
}

type GetOTAUpdateInput struct {
	_ struct{} `type:"structure"`

	// The OTA update ID.
	//
	// OtaUpdateId is a required field
	OtaUpdateId *string `location:"uri" locationName:"otaUpdateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOTAUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOTAUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOTAUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOTAUpdateInput"}
	if s.OtaUpdateId == nil {
		invalidParams.Add(request.NewErrParamRequired("OtaUpdateId"))
	}
	if s.OtaUpdateId != nil && len(*s.OtaUpdateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OtaUpdateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOtaUpdateId sets the OtaUpdateId field's value.
func (s *GetOTAUpdateInput) SetOtaUpdateId(v string) *GetOTAUpdateInput {
	s.OtaUpdateId = &v
	return s
}

type GetOTAUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The OTA update info.
	OtaUpdateInfo *OTAUpdateInfo `locationName:"otaUpdateInfo" type:"structure"`
}

// String returns the string representation
func (s GetOTAUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOTAUpdateOutput) GoString() string {
	return s.String()
}

// SetOtaUpdateInfo sets the OtaUpdateInfo field's value.
func (s *GetOTAUpdateOutput) SetOtaUpdateInfo(v *OTAUpdateInfo) *GetOTAUpdateOutput {
	s.OtaUpdateInfo = v
	return s
}

// The input for the GetPolicy operation.
type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetPolicyInput) SetPolicyName(v string) *GetPolicyInput {
	s.PolicyName = &v
	return s
}

// The output from the GetPolicy operation.
type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The date the policy was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The default policy version ID.
	DefaultVersionId *string `locationName:"defaultVersionId" type:"string"`

	// The generation ID of the policy.
	GenerationId *string `locationName:"generationId" type:"string"`

	// The date the policy was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetPolicyOutput) SetCreationDate(v time.Time) *GetPolicyOutput {
	s.CreationDate = &v
	return s
}

// SetDefaultVersionId sets the DefaultVersionId field's value.
func (s *GetPolicyOutput) SetDefaultVersionId(v string) *GetPolicyOutput {
	s.DefaultVersionId = &v
	return s
}

// SetGenerationId sets the GenerationId field's value.
func (s *GetPolicyOutput) SetGenerationId(v string) *GetPolicyOutput {
	s.GenerationId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *GetPolicyOutput) SetLastModifiedDate(v time.Time) *GetPolicyOutput {
	s.LastModifiedDate = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *GetPolicyOutput) SetPolicyArn(v string) *GetPolicyOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *GetPolicyOutput) SetPolicyDocument(v string) *GetPolicyOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetPolicyOutput) SetPolicyName(v string) *GetPolicyOutput {
	s.PolicyName = &v
	return s
}

// The input for the GetPolicyVersion operation.
type GetPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	//
	// PolicyVersionId is a required field
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyVersionInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyVersionId"))
	}
	if s.PolicyVersionId != nil && len(*s.PolicyVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetPolicyVersionInput) SetPolicyName(v string) *GetPolicyVersionInput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *GetPolicyVersionInput) SetPolicyVersionId(v string) *GetPolicyVersionInput {
	s.PolicyVersionId = &v
	return s
}

// The output from the GetPolicyVersion operation.
type GetPolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// The date the policy version was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The generation ID of the policy version.
	GenerationId *string `locationName:"generationId" type:"string"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The date the policy version was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s GetPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetPolicyVersionOutput) SetCreationDate(v time.Time) *GetPolicyVersionOutput {
	s.CreationDate = &v
	return s
}

// SetGenerationId sets the GenerationId field's value.
func (s *GetPolicyVersionOutput) SetGenerationId(v string) *GetPolicyVersionOutput {
	s.GenerationId = &v
	return s
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *GetPolicyVersionOutput) SetIsDefaultVersion(v bool) *GetPolicyVersionOutput {
	s.IsDefaultVersion = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *GetPolicyVersionOutput) SetLastModifiedDate(v time.Time) *GetPolicyVersionOutput {
	s.LastModifiedDate = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *GetPolicyVersionOutput) SetPolicyArn(v string) *GetPolicyVersionOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *GetPolicyVersionOutput) SetPolicyDocument(v string) *GetPolicyVersionOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetPolicyVersionOutput) SetPolicyName(v string) *GetPolicyVersionOutput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *GetPolicyVersionOutput) SetPolicyVersionId(v string) *GetPolicyVersionOutput {
	s.PolicyVersionId = &v
	return s
}

// The input to the GetRegistrationCode operation.
type GetRegistrationCodeInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetRegistrationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegistrationCodeInput) GoString() string {
	return s.String()
}

// The output from the GetRegistrationCode operation.
type GetRegistrationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificate registration code.
	RegistrationCode *string `locationName:"registrationCode" min:"64" type:"string"`
}

// String returns the string representation
func (s GetRegistrationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegistrationCodeOutput) GoString() string {
	return s.String()
}

// SetRegistrationCode sets the RegistrationCode field's value.
func (s *GetRegistrationCodeOutput) SetRegistrationCode(v string) *GetRegistrationCodeOutput {
	s.RegistrationCode = &v
	return s
}

// The input for the GetTopicRule operation.
type GetTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *GetTopicRuleInput) SetRuleName(v string) *GetTopicRuleInput {
	s.RuleName = &v
	return s
}

// The output from the GetTopicRule operation.
type GetTopicRuleOutput struct {
	_ struct{} `type:"structure"`

	// The rule.
	Rule *TopicRule `locationName:"rule" type:"structure"`

	// The rule ARN.
	RuleArn *string `locationName:"ruleArn" type:"string"`
}

// String returns the string representation
func (s GetTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicRuleOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *GetTopicRuleOutput) SetRule(v *TopicRule) *GetTopicRuleOutput {
	s.Rule = v
	return s
}

// SetRuleArn sets the RuleArn field's value.
func (s *GetTopicRuleOutput) SetRuleArn(v string) *GetTopicRuleOutput {
	s.RuleArn = &v
	return s
}

type GetV2LoggingOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetV2LoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetV2LoggingOptionsInput) GoString() string {
	return s.String()
}

type GetV2LoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The default log level.
	DefaultLogLevel *string `locationName:"defaultLogLevel" type:"string" enum:"LogLevel"`

	// Disables all logs.
	DisableAllLogs *bool `locationName:"disableAllLogs" type:"boolean"`

	// The IAM role ARN AWS IoT uses to write to your CloudWatch logs.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s GetV2LoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetV2LoggingOptionsOutput) GoString() string {
	return s.String()
}

// SetDefaultLogLevel sets the DefaultLogLevel field's value.
func (s *GetV2LoggingOptionsOutput) SetDefaultLogLevel(v string) *GetV2LoggingOptionsOutput {
	s.DefaultLogLevel = &v
	return s
}

// SetDisableAllLogs sets the DisableAllLogs field's value.
func (s *GetV2LoggingOptionsOutput) SetDisableAllLogs(v bool) *GetV2LoggingOptionsOutput {
	s.DisableAllLogs = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetV2LoggingOptionsOutput) SetRoleArn(v string) *GetV2LoggingOptionsOutput {
	s.RoleArn = &v
	return s
}

// The name and ARN of a group.
type GroupNameAndArn struct {
	_ struct{} `type:"structure"`

	// The group ARN.
	GroupArn *string `locationName:"groupArn" type:"string"`

	// The group name.
	GroupName *string `locationName:"groupName" min:"1" type:"string"`
}

// String returns the string representation
func (s GroupNameAndArn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupNameAndArn) GoString() string {
	return s.String()
}

// SetGroupArn sets the GroupArn field's value.
func (s *GroupNameAndArn) SetGroupArn(v string) *GroupNameAndArn {
	s.GroupArn = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GroupNameAndArn) SetGroupName(v string) *GroupNameAndArn {
	s.GroupName = &v
	return s
}

// Information that implicitly denies authorization. When policy doesn't explicitly
// deny or allow an action on a resource it is considered an implicit deny.
type ImplicitDeny struct {
	_ struct{} `type:"structure"`

	// Policies that don't contain a matching allow or deny statement for the specified
	// action on the specified resource.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ImplicitDeny) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImplicitDeny) GoString() string {
	return s.String()
}

// SetPolicies sets the Policies field's value.
func (s *ImplicitDeny) SetPolicies(v []*Policy) *ImplicitDeny {
	s.Policies = v
	return s
}

// Sends messge data to an AWS IoT Analytics channel.
type IotAnalyticsAction struct {
	_ struct{} `type:"structure"`

	// (deprecated) The ARN of the IoT Analytics channel to which message data will
	// be sent.
	ChannelArn *string `locationName:"channelArn" type:"string"`

	// The name of the IoT Analytics channel to which message data will be sent.
	ChannelName *string `locationName:"channelName" type:"string"`

	// The ARN of the role which has a policy that grants IoT Analytics permission
	// to send message data via IoT Analytics (iotanalytics:BatchPutMessage).
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s IotAnalyticsAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IotAnalyticsAction) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *IotAnalyticsAction) SetChannelArn(v string) *IotAnalyticsAction {
	s.ChannelArn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *IotAnalyticsAction) SetChannelName(v string) *IotAnalyticsAction {
	s.ChannelName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *IotAnalyticsAction) SetRoleArn(v string) *IotAnalyticsAction {
	s.RoleArn = &v
	return s
}

// Sends an input to an AWS IoT Events detector.
type IotEventsAction struct {
	_ struct{} `type:"structure"`

	// The name of the AWS IoT Events input.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`

	// [Optional] Use this to ensure that only one input (message) with a given
	// messageId will be processed by an AWS IoT Events detector.
	MessageId *string `locationName:"messageId" type:"string"`

	// The ARN of the role that grants AWS IoT permission to send an input to an
	// AWS IoT Events detector. ("Action":"iotevents:BatchPutMessage").
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s IotEventsAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IotEventsAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IotEventsAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IotEventsAction"}
	if s.InputName == nil {
		invalidParams.Add(request.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputName sets the InputName field's value.
func (s *IotEventsAction) SetInputName(v string) *IotEventsAction {
	s.InputName = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *IotEventsAction) SetMessageId(v string) *IotEventsAction {
	s.MessageId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *IotEventsAction) SetRoleArn(v string) *IotEventsAction {
	s.RoleArn = &v
	return s
}

// The Job object contains details about a job.
type Job struct {
	_ struct{} `type:"structure"`

	// Configuration for criteria to abort the job.
	AbortConfig *AbortConfig `locationName:"abortConfig" type:"structure"`

	// If the job was updated, describes the reason for the update.
	Comment *string `locationName:"comment" type:"string"`

	// The time, in milliseconds since the epoch, when the job was completed.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A short text description of the job.
	Description *string `locationName:"description" type:"string"`

	// Will be true if the job was canceled with the optional force parameter set
	// to true.
	ForceCanceled *bool `locationName:"forceCanceled" type:"boolean"`

	// An ARN identifying the job with format "arn:aws:iot:region:account:job/jobId".
	JobArn *string `locationName:"jobArn" type:"string"`

	// Allows you to create a staged rollout of a job.
	JobExecutionsRolloutConfig *JobExecutionsRolloutConfig `locationName:"jobExecutionsRolloutConfig" type:"structure"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// Details about the job process.
	JobProcessDetails *JobProcessDetails `locationName:"jobProcessDetails" type:"structure"`

	// The time, in milliseconds since the epoch, when the job was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// Configuration for pre-signed S3 URLs.
	PresignedUrlConfig *PresignedUrlConfig `locationName:"presignedUrlConfig" type:"structure"`

	// If the job was updated, provides the reason code for the update.
	ReasonCode *string `locationName:"reasonCode" type:"string"`

	// The status of the job, one of IN_PROGRESS, CANCELED, DELETION_IN_PROGRESS
	// or COMPLETED.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`

	// Specifies whether the job will continue to run (CONTINUOUS), or will be complete
	// after all those things specified as targets have completed the job (SNAPSHOT).
	// If continuous, the job may also be run on a thing when a change is detected
	// in a target. For example, a job will run on a device when the thing representing
	// the device is added to a target group, even after the job was completed by
	// all things originally in the group.
	TargetSelection *string `locationName:"targetSelection" type:"string" enum:"TargetSelection"`

	// A list of IoT things and thing groups to which the job should be sent.
	Targets []*string `locationName:"targets" min:"1" type:"list"`

	// Specifies the amount of time each device has to finish its execution of the
	// job. A timer is started when the job execution status is set to IN_PROGRESS.
	// If the job execution status is not set to another terminal state before the
	// timer expires, it will be automatically set to TIMED_OUT.
	TimeoutConfig *TimeoutConfig `locationName:"timeoutConfig" type:"structure"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Job) GoString() string {
	return s.String()
}

// SetAbortConfig sets the AbortConfig field's value.
func (s *Job) SetAbortConfig(v *AbortConfig) *Job {
	s.AbortConfig = v
	return s
}

// SetComment sets the Comment field's value.
func (s *Job) SetComment(v string) *Job {
	s.Comment = &v
	return s
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *Job) SetCompletedAt(v time.Time) *Job {
	s.CompletedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Job) SetCreatedAt(v time.Time) *Job {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Job) SetDescription(v string) *Job {
	s.Description = &v
	return s
}

// SetForceCanceled sets the ForceCanceled field's value.
func (s *Job) SetForceCanceled(v bool) *Job {
	s.ForceCanceled = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *Job) SetJobArn(v string) *Job {
	s.JobArn = &v
	return s
}

// SetJobExecutionsRolloutConfig sets the JobExecutionsRolloutConfig field's value.
func (s *Job) SetJobExecutionsRolloutConfig(v *JobExecutionsRolloutConfig) *Job {
	s.JobExecutionsRolloutConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *Job) SetJobId(v string) *Job {
	s.JobId = &v
	return s
}

// SetJobProcessDetails sets the JobProcessDetails field's value.
func (s *Job) SetJobProcessDetails(v *JobProcessDetails) *Job {
	s.JobProcessDetails = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *Job) SetLastUpdatedAt(v time.Time) *Job {
	s.LastUpdatedAt = &v
	return s
}

// SetPresignedUrlConfig sets the PresignedUrlConfig field's value.
func (s *Job) SetPresignedUrlConfig(v *PresignedUrlConfig) *Job {
	s.PresignedUrlConfig = v
	return s
}

// SetReasonCode sets the ReasonCode field's value.
func (s *Job) SetReasonCode(v string) *Job {
	s.ReasonCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Job) SetStatus(v string) *Job {
	s.Status = &v
	return s
}

// SetTargetSelection sets the TargetSelection field's value.
func (s *Job) SetTargetSelection(v string) *Job {
	s.TargetSelection = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Job) SetTargets(v []*string) *Job {
	s.Targets = v
	return s
}

// SetTimeoutConfig sets the TimeoutConfig field's value.
func (s *Job) SetTimeoutConfig(v *TimeoutConfig) *Job {
	s.TimeoutConfig = v
	return s
}

// The job execution object represents the execution of a job on a particular
// device.
type JobExecution struct {
	_ struct{} `type:"structure"`

	// The estimated number of seconds that remain before the job execution status
	// will be changed to TIMED_OUT. The timeout interval can be anywhere between
	// 1 minute and 7 days (1 to 10080 minutes). The actual job execution timeout
	// can occur up to 60 seconds later than the estimated duration. This value
	// will not be included if the job execution has reached a terminal status.
	ApproximateSecondsBeforeTimedOut *int64 `locationName:"approximateSecondsBeforeTimedOut" type:"long"`

	// A string (consisting of the digits "0" through "9") which identifies this
	// particular job execution on this particular device. It can be used in commands
	// which return or update job execution information.
	ExecutionNumber *int64 `locationName:"executionNumber" type:"long"`

	// Will be true if the job execution was canceled with the optional force parameter
	// set to true.
	ForceCanceled *bool `locationName:"forceCanceled" type:"boolean"`

	// The unique identifier you assigned to the job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the job execution was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the job execution was queued.
	QueuedAt *time.Time `locationName:"queuedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the job execution started.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp"`

	// The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED,
	// TIMED_OUT, CANCELED, or REJECTED).
	Status *string `locationName:"status" type:"string" enum:"JobExecutionStatus"`

	// A collection of name/value pairs that describe the status of the job execution.
	StatusDetails *JobExecutionStatusDetails `locationName:"statusDetails" type:"structure"`

	// The ARN of the thing on which the job execution is running.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The version of the job execution. Job execution versions are incremented
	// each time they are updated by a device.
	VersionNumber *int64 `locationName:"versionNumber" type:"long"`
}

// String returns the string representation
func (s JobExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobExecution) GoString() string {
	return s.String()
}

// SetApproximateSecondsBeforeTimedOut sets the ApproximateSecondsBeforeTimedOut field's value.
func (s *JobExecution) SetApproximateSecondsBeforeTimedOut(v int64) *JobExecution {
	s.ApproximateSecondsBeforeTimedOut = &v
	return s
}

// SetExecutionNumber sets the ExecutionNumber field's value.
func (s *JobExecution) SetExecutionNumber(v int64) *JobExecution {
	s.ExecutionNumber = &v
	return s
}

// SetForceCanceled sets the ForceCanceled field's value.
func (s *JobExecution) SetForceCanceled(v bool) *JobExecution {
	s.ForceCanceled = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobExecution) SetJobId(v string) *JobExecution {
	s.JobId = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *JobExecution) SetLastUpdatedAt(v time.Time) *JobExecution {
	s.LastUpdatedAt = &v
	return s
}

// SetQueuedAt sets the QueuedAt field's value.
func (s *JobExecution) SetQueuedAt(v time.Time) *JobExecution {
	s.QueuedAt = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *JobExecution) SetStartedAt(v time.Time) *JobExecution {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobExecution) SetStatus(v string) *JobExecution {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *JobExecution) SetStatusDetails(v *JobExecutionStatusDetails) *JobExecution {
	s.StatusDetails = v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *JobExecution) SetThingArn(v string) *JobExecution {
	s.ThingArn = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *JobExecution) SetVersionNumber(v int64) *JobExecution {
	s.VersionNumber = &v
	return s
}

// Details of the job execution status.
type JobExecutionStatusDetails struct {
	_ struct{} `type:"structure"`

	// The job execution status.
	DetailsMap map[string]*string `locationName:"detailsMap" type:"map"`
}

// String returns the string representation
func (s JobExecutionStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobExecutionStatusDetails) GoString() string {
	return s.String()
}

// SetDetailsMap sets the DetailsMap field's value.
func (s *JobExecutionStatusDetails) SetDetailsMap(v map[string]*string) *JobExecutionStatusDetails {
	s.DetailsMap = v
	return s
}

// The job execution summary.
type JobExecutionSummary struct {
	_ struct{} `type:"structure"`

	// A string (consisting of the digits "0" through "9") which identifies this
	// particular job execution on this particular device. It can be used later
	// in commands which return or update job execution information.
	ExecutionNumber *int64 `locationName:"executionNumber" type:"long"`

	// The time, in milliseconds since the epoch, when the job execution was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the job execution was queued.
	QueuedAt *time.Time `locationName:"queuedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the job execution started.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp"`

	// The status of the job execution.
	Status *string `locationName:"status" type:"string" enum:"JobExecutionStatus"`
}

// String returns the string representation
func (s JobExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobExecutionSummary) GoString() string {
	return s.String()
}

// SetExecutionNumber sets the ExecutionNumber field's value.
func (s *JobExecutionSummary) SetExecutionNumber(v int64) *JobExecutionSummary {
	s.ExecutionNumber = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *JobExecutionSummary) SetLastUpdatedAt(v time.Time) *JobExecutionSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetQueuedAt sets the QueuedAt field's value.
func (s *JobExecutionSummary) SetQueuedAt(v time.Time) *JobExecutionSummary {
	s.QueuedAt = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *JobExecutionSummary) SetStartedAt(v time.Time) *JobExecutionSummary {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobExecutionSummary) SetStatus(v string) *JobExecutionSummary {
	s.Status = &v
	return s
}

// Contains a summary of information about job executions for a specific job.
type JobExecutionSummaryForJob struct {
	_ struct{} `type:"structure"`

	// Contains a subset of information about a job execution.
	JobExecutionSummary *JobExecutionSummary `locationName:"jobExecutionSummary" type:"structure"`

	// The ARN of the thing on which the job execution is running.
	ThingArn *string `locationName:"thingArn" type:"string"`
}

// String returns the string representation
func (s JobExecutionSummaryForJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobExecutionSummaryForJob) GoString() string {
	return s.String()
}

// SetJobExecutionSummary sets the JobExecutionSummary field's value.
func (s *JobExecutionSummaryForJob) SetJobExecutionSummary(v *JobExecutionSummary) *JobExecutionSummaryForJob {
	s.JobExecutionSummary = v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *JobExecutionSummaryForJob) SetThingArn(v string) *JobExecutionSummaryForJob {
	s.ThingArn = &v
	return s
}

// The job execution summary for a thing.
type JobExecutionSummaryForThing struct {
	_ struct{} `type:"structure"`

	// Contains a subset of information about a job execution.
	JobExecutionSummary *JobExecutionSummary `locationName:"jobExecutionSummary" type:"structure"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`
}

// String returns the string representation
func (s JobExecutionSummaryForThing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobExecutionSummaryForThing) GoString() string {
	return s.String()
}

// SetJobExecutionSummary sets the JobExecutionSummary field's value.
func (s *JobExecutionSummaryForThing) SetJobExecutionSummary(v *JobExecutionSummary) *JobExecutionSummaryForThing {
	s.JobExecutionSummary = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobExecutionSummaryForThing) SetJobId(v string) *JobExecutionSummaryForThing {
	s.JobId = &v
	return s
}

// Allows you to create a staged rollout of a job.
type JobExecutionsRolloutConfig struct {
	_ struct{} `type:"structure"`

	// The rate of increase for a job rollout. This parameter allows you to define
	// an exponential rate for a job rollout.
	ExponentialRate *ExponentialRolloutRate `locationName:"exponentialRate" type:"structure"`

	// The maximum number of things that will be notified of a pending job, per
	// minute. This parameter allows you to create a staged rollout.
	MaximumPerMinute *int64 `locationName:"maximumPerMinute" min:"1" type:"integer"`
}

// String returns the string representation
func (s JobExecutionsRolloutConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobExecutionsRolloutConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobExecutionsRolloutConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobExecutionsRolloutConfig"}
	if s.MaximumPerMinute != nil && *s.MaximumPerMinute < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumPerMinute", 1))
	}
	if s.ExponentialRate != nil {
		if err := s.ExponentialRate.Validate(); err != nil {
			invalidParams.AddNested("ExponentialRate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExponentialRate sets the ExponentialRate field's value.
func (s *JobExecutionsRolloutConfig) SetExponentialRate(v *ExponentialRolloutRate) *JobExecutionsRolloutConfig {
	s.ExponentialRate = v
	return s
}

// SetMaximumPerMinute sets the MaximumPerMinute field's value.
func (s *JobExecutionsRolloutConfig) SetMaximumPerMinute(v int64) *JobExecutionsRolloutConfig {
	s.MaximumPerMinute = &v
	return s
}

// The job process details.
type JobProcessDetails struct {
	_ struct{} `type:"structure"`

	// The number of things that cancelled the job.
	NumberOfCanceledThings *int64 `locationName:"numberOfCanceledThings" type:"integer"`

	// The number of things that failed executing the job.
	NumberOfFailedThings *int64 `locationName:"numberOfFailedThings" type:"integer"`

	// The number of things currently executing the job.
	NumberOfInProgressThings *int64 `locationName:"numberOfInProgressThings" type:"integer"`

	// The number of things that are awaiting execution of the job.
	NumberOfQueuedThings *int64 `locationName:"numberOfQueuedThings" type:"integer"`

	// The number of things that rejected the job.
	NumberOfRejectedThings *int64 `locationName:"numberOfRejectedThings" type:"integer"`

	// The number of things that are no longer scheduled to execute the job because
	// they have been deleted or have been removed from the group that was a target
	// of the job.
	NumberOfRemovedThings *int64 `locationName:"numberOfRemovedThings" type:"integer"`

	// The number of things which successfully completed the job.
	NumberOfSucceededThings *int64 `locationName:"numberOfSucceededThings" type:"integer"`

	// The number of things whose job execution status is TIMED_OUT.
	NumberOfTimedOutThings *int64 `locationName:"numberOfTimedOutThings" type:"integer"`

	// The target devices to which the job execution is being rolled out. This value
	// will be null after the job execution has finished rolling out to all the
	// target devices.
	ProcessingTargets []*string `locationName:"processingTargets" type:"list"`
}

// String returns the string representation
func (s JobProcessDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobProcessDetails) GoString() string {
	return s.String()
}

// SetNumberOfCanceledThings sets the NumberOfCanceledThings field's value.
func (s *JobProcessDetails) SetNumberOfCanceledThings(v int64) *JobProcessDetails {
	s.NumberOfCanceledThings = &v
	return s
}

// SetNumberOfFailedThings sets the NumberOfFailedThings field's value.
func (s *JobProcessDetails) SetNumberOfFailedThings(v int64) *JobProcessDetails {
	s.NumberOfFailedThings = &v
	return s
}

// SetNumberOfInProgressThings sets the NumberOfInProgressThings field's value.
func (s *JobProcessDetails) SetNumberOfInProgressThings(v int64) *JobProcessDetails {
	s.NumberOfInProgressThings = &v
	return s
}

// SetNumberOfQueuedThings sets the NumberOfQueuedThings field's value.
func (s *JobProcessDetails) SetNumberOfQueuedThings(v int64) *JobProcessDetails {
	s.NumberOfQueuedThings = &v
	return s
}

// SetNumberOfRejectedThings sets the NumberOfRejectedThings field's value.
func (s *JobProcessDetails) SetNumberOfRejectedThings(v int64) *JobProcessDetails {
	s.NumberOfRejectedThings = &v
	return s
}

// SetNumberOfRemovedThings sets the NumberOfRemovedThings field's value.
func (s *JobProcessDetails) SetNumberOfRemovedThings(v int64) *JobProcessDetails {
	s.NumberOfRemovedThings = &v
	return s
}

// SetNumberOfSucceededThings sets the NumberOfSucceededThings field's value.
func (s *JobProcessDetails) SetNumberOfSucceededThings(v int64) *JobProcessDetails {
	s.NumberOfSucceededThings = &v
	return s
}

// SetNumberOfTimedOutThings sets the NumberOfTimedOutThings field's value.
func (s *JobProcessDetails) SetNumberOfTimedOutThings(v int64) *JobProcessDetails {
	s.NumberOfTimedOutThings = &v
	return s
}

// SetProcessingTargets sets the ProcessingTargets field's value.
func (s *JobProcessDetails) SetProcessingTargets(v []*string) *JobProcessDetails {
	s.ProcessingTargets = v
	return s
}

// The job summary.
type JobSummary struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds since the epoch, when the job completed.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The job ARN.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the job was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The job summary status.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`

	// Specifies whether the job will continue to run (CONTINUOUS), or will be complete
	// after all those things specified as targets have completed the job (SNAPSHOT).
	// If continuous, the job may also be run on a thing when a change is detected
	// in a target. For example, a job will run on a thing when the thing is added
	// to a target group, even after the job was completed by all things originally
	// in the group.
	TargetSelection *string `locationName:"targetSelection" type:"string" enum:"TargetSelection"`

	// The ID of the thing group.
	ThingGroupId *string `locationName:"thingGroupId" min:"1" type:"string"`
}

// String returns the string representation
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobSummary) GoString() string {
	return s.String()
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *JobSummary) SetCompletedAt(v time.Time) *JobSummary {
	s.CompletedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobSummary) SetCreatedAt(v time.Time) *JobSummary {
	s.CreatedAt = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *JobSummary) SetJobArn(v string) *JobSummary {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobSummary) SetJobId(v string) *JobSummary {
	s.JobId = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *JobSummary) SetLastUpdatedAt(v time.Time) *JobSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobSummary) SetStatus(v string) *JobSummary {
	s.Status = &v
	return s
}

// SetTargetSelection sets the TargetSelection field's value.
func (s *JobSummary) SetTargetSelection(v string) *JobSummary {
	s.TargetSelection = &v
	return s
}

// SetThingGroupId sets the ThingGroupId field's value.
func (s *JobSummary) SetThingGroupId(v string) *JobSummary {
	s.ThingGroupId = &v
	return s
}

// Describes a key pair.
type KeyPair struct {
	_ struct{} `type:"structure"`

	// The private key.
	PrivateKey *string `min:"1" type:"string" sensitive:"true"`

	// The public key.
	PublicKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPair) GoString() string {
	return s.String()
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *KeyPair) SetPrivateKey(v string) *KeyPair {
	s.PrivateKey = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *KeyPair) SetPublicKey(v string) *KeyPair {
	s.PublicKey = &v
	return s
}

// Describes an action to write data to an Amazon Kinesis stream.
type KinesisAction struct {
	_ struct{} `type:"structure"`

	// The partition key.
	PartitionKey *string `locationName:"partitionKey" type:"string"`

	// The ARN of the IAM role that grants access to the Amazon Kinesis stream.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the Amazon Kinesis stream.
	//
	// StreamName is a required field
	StreamName *string `locationName:"streamName" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisAction"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *KinesisAction) SetPartitionKey(v string) *KinesisAction {
	s.PartitionKey = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *KinesisAction) SetRoleArn(v string) *KinesisAction {
	s.RoleArn = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *KinesisAction) SetStreamName(v string) *KinesisAction {
	s.StreamName = &v
	return s
}

// Describes an action to invoke a Lambda function.
type LambdaAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the Lambda function.
	//
	// FunctionArn is a required field
	FunctionArn *string `locationName:"functionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaAction"}
	if s.FunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *LambdaAction) SetFunctionArn(v string) *LambdaAction {
	s.FunctionArn = &v
	return s
}

type ListActiveViolationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the Device Defender security profile for which violations are
	// listed.
	SecurityProfileName *string `location:"querystring" locationName:"securityProfileName" min:"1" type:"string"`

	// The name of the thing whose active violations are listed.
	ThingName *string `location:"querystring" locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActiveViolationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActiveViolationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActiveViolationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActiveViolationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListActiveViolationsInput) SetMaxResults(v int64) *ListActiveViolationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActiveViolationsInput) SetNextToken(v string) *ListActiveViolationsInput {
	s.NextToken = &v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *ListActiveViolationsInput) SetSecurityProfileName(v string) *ListActiveViolationsInput {
	s.SecurityProfileName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *ListActiveViolationsInput) SetThingName(v string) *ListActiveViolationsInput {
	s.ThingName = &v
	return s
}

type ListActiveViolationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of active violations.
	ActiveViolations []*ActiveViolation `locationName:"activeViolations" type:"list"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListActiveViolationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActiveViolationsOutput) GoString() string {
	return s.String()
}

// SetActiveViolations sets the ActiveViolations field's value.
func (s *ListActiveViolationsOutput) SetActiveViolations(v []*ActiveViolation) *ListActiveViolationsOutput {
	s.ActiveViolations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActiveViolationsOutput) SetNextToken(v string) *ListActiveViolationsOutput {
	s.NextToken = &v
	return s
}

type ListAttachedPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of results to be returned per request.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// When true, recursively list attached policies.
	Recursive *bool `location:"querystring" locationName:"recursive" type:"boolean"`

	// The group for which the policies will be listed.
	//
	// Target is a required field
	Target *string `location:"uri" locationName:"target" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAttachedPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttachedPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttachedPoliciesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListAttachedPoliciesInput) SetMarker(v string) *ListAttachedPoliciesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListAttachedPoliciesInput) SetPageSize(v int64) *ListAttachedPoliciesInput {
	s.PageSize = &v
	return s
}

// SetRecursive sets the Recursive field's value.
func (s *ListAttachedPoliciesInput) SetRecursive(v bool) *ListAttachedPoliciesInput {
	s.Recursive = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ListAttachedPoliciesInput) SetTarget(v string) *ListAttachedPoliciesInput {
	s.Target = &v
	return s
}

type ListAttachedPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or ``null`` if there are no
	// more results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The policies.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ListAttachedPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAttachedPoliciesOutput) SetNextMarker(v string) *ListAttachedPoliciesOutput {
	s.NextMarker = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListAttachedPoliciesOutput) SetPolicies(v []*Policy) *ListAttachedPoliciesOutput {
	s.Policies = v
	return s
}

type ListAuditFindingsInput struct {
	_ struct{} `type:"structure"`

	// A filter to limit results to the findings for the specified audit check.
	CheckName *string `locationName:"checkName" type:"string"`

	// A filter to limit results to those found before the specified time. You must
	// specify either the startTime and endTime or the taskId, but not both.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The maximum number of results to return at one time. The default is 25.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information identifying the non-compliant resource.
	ResourceIdentifier *ResourceIdentifier `locationName:"resourceIdentifier" type:"structure"`

	// A filter to limit results to those found after the specified time. You must
	// specify either the startTime and endTime or the taskId, but not both.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// A filter to limit results to the audit with the specified ID. You must specify
	// either the taskId or the startTime and endTime, but not both.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAuditFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAuditFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAuditFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAuditFindingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}
	if s.ResourceIdentifier != nil {
		if err := s.ResourceIdentifier.Validate(); err != nil {
			invalidParams.AddNested("ResourceIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckName sets the CheckName field's value.
func (s *ListAuditFindingsInput) SetCheckName(v string) *ListAuditFindingsInput {
	s.CheckName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ListAuditFindingsInput) SetEndTime(v time.Time) *ListAuditFindingsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAuditFindingsInput) SetMaxResults(v int64) *ListAuditFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAuditFindingsInput) SetNextToken(v string) *ListAuditFindingsInput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ListAuditFindingsInput) SetResourceIdentifier(v *ResourceIdentifier) *ListAuditFindingsInput {
	s.ResourceIdentifier = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListAuditFindingsInput) SetStartTime(v time.Time) *ListAuditFindingsInput {
	s.StartTime = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *ListAuditFindingsInput) SetTaskId(v string) *ListAuditFindingsInput {
	s.TaskId = &v
	return s
}

type ListAuditFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The findings (results) of the audit.
	Findings []*AuditFinding `locationName:"findings" type:"list"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAuditFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAuditFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *ListAuditFindingsOutput) SetFindings(v []*AuditFinding) *ListAuditFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAuditFindingsOutput) SetNextToken(v string) *ListAuditFindingsOutput {
	s.NextToken = &v
	return s
}

type ListAuditTasksInput struct {
	_ struct{} `type:"structure"`

	// The end of the time period.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" required:"true"`

	// The maximum number of results to return at one time. The default is 25.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The beginning of the time period. Note that audit information is retained
	// for a limited time (180 days). Requesting a start time prior to what is retained
	// results in an "InvalidRequestException".
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" required:"true"`

	// A filter to limit the output to audits with the specified completion status:
	// can be one of "IN_PROGRESS", "COMPLETED", "FAILED" or "CANCELED".
	TaskStatus *string `location:"querystring" locationName:"taskStatus" type:"string" enum:"AuditTaskStatus"`

	// A filter to limit the output to the specified type of audit: can be one of
	// "ON_DEMAND_AUDIT_TASK" or "SCHEDULED__AUDIT_TASK".
	TaskType *string `location:"querystring" locationName:"taskType" type:"string" enum:"AuditTaskType"`
}

// String returns the string representation
func (s ListAuditTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAuditTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAuditTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAuditTasksInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListAuditTasksInput) SetEndTime(v time.Time) *ListAuditTasksInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAuditTasksInput) SetMaxResults(v int64) *ListAuditTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAuditTasksInput) SetNextToken(v string) *ListAuditTasksInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListAuditTasksInput) SetStartTime(v time.Time) *ListAuditTasksInput {
	s.StartTime = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *ListAuditTasksInput) SetTaskStatus(v string) *ListAuditTasksInput {
	s.TaskStatus = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *ListAuditTasksInput) SetTaskType(v string) *ListAuditTasksInput {
	s.TaskType = &v
	return s
}

type ListAuditTasksOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The audits that were performed during the specified time period.
	Tasks []*AuditTaskMetadata `locationName:"tasks" type:"list"`
}

// String returns the string representation
func (s ListAuditTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAuditTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAuditTasksOutput) SetNextToken(v string) *ListAuditTasksOutput {
	s.NextToken = &v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *ListAuditTasksOutput) SetTasks(v []*AuditTaskMetadata) *ListAuditTasksOutput {
	s.Tasks = v
	return s
}

type ListAuthorizersInput struct {
	_ struct{} `type:"structure"`

	// Return the list of authorizers in ascending alphabetical order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// A marker used to get the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of results to return at one time.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The status of the list authorizers request.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"AuthorizerStatus"`
}

// String returns the string representation
func (s ListAuthorizersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAuthorizersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAuthorizersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAuthorizersInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListAuthorizersInput) SetAscendingOrder(v bool) *ListAuthorizersInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAuthorizersInput) SetMarker(v string) *ListAuthorizersInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListAuthorizersInput) SetPageSize(v int64) *ListAuthorizersInput {
	s.PageSize = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListAuthorizersInput) SetStatus(v string) *ListAuthorizersInput {
	s.Status = &v
	return s
}

type ListAuthorizersOutput struct {
	_ struct{} `type:"structure"`

	// The authorizers.
	Authorizers []*AuthorizerSummary `locationName:"authorizers" type:"list"`

	// A marker used to get the next set of results.
	NextMarker *string `locationName:"nextMarker" type:"string"`
}

// String returns the string representation
func (s ListAuthorizersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAuthorizersOutput) GoString() string {
	return s.String()
}

// SetAuthorizers sets the Authorizers field's value.
func (s *ListAuthorizersOutput) SetAuthorizers(v []*AuthorizerSummary) *ListAuthorizersOutput {
	s.Authorizers = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAuthorizersOutput) SetNextMarker(v string) *ListAuthorizersOutput {
	s.NextMarker = &v
	return s
}

type ListBillingGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Limit the results to billing groups whose names have the given prefix.
	NamePrefixFilter *string `location:"querystring" locationName:"namePrefixFilter" min:"1" type:"string"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBillingGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBillingGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBillingGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBillingGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NamePrefixFilter != nil && len(*s.NamePrefixFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefixFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBillingGroupsInput) SetMaxResults(v int64) *ListBillingGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNamePrefixFilter sets the NamePrefixFilter field's value.
func (s *ListBillingGroupsInput) SetNamePrefixFilter(v string) *ListBillingGroupsInput {
	s.NamePrefixFilter = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBillingGroupsInput) SetNextToken(v string) *ListBillingGroupsInput {
	s.NextToken = &v
	return s
}

type ListBillingGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of billing groups.
	BillingGroups []*GroupNameAndArn `locationName:"billingGroups" type:"list"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBillingGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBillingGroupsOutput) GoString() string {
	return s.String()
}

// SetBillingGroups sets the BillingGroups field's value.
func (s *ListBillingGroupsOutput) SetBillingGroups(v []*GroupNameAndArn) *ListBillingGroupsOutput {
	s.BillingGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBillingGroupsOutput) SetNextToken(v string) *ListBillingGroupsOutput {
	s.NextToken = &v
	return s
}

// Input for the ListCACertificates operation.
type ListCACertificatesInput struct {
	_ struct{} `type:"structure"`

	// Determines the order of the results.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListCACertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCACertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCACertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCACertificatesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListCACertificatesInput) SetAscendingOrder(v bool) *ListCACertificatesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListCACertificatesInput) SetMarker(v string) *ListCACertificatesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCACertificatesInput) SetPageSize(v int64) *ListCACertificatesInput {
	s.PageSize = &v
	return s
}

// The output from the ListCACertificates operation.
type ListCACertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificates registered in your AWS account.
	Certificates []*CACertificate `locationName:"certificates" type:"list"`

	// The current position within the list of CA certificates.
	NextMarker *string `locationName:"nextMarker" type:"string"`
}

// String returns the string representation
func (s ListCACertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCACertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *ListCACertificatesOutput) SetCertificates(v []*CACertificate) *ListCACertificatesOutput {
	s.Certificates = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListCACertificatesOutput) SetNextMarker(v string) *ListCACertificatesOutput {
	s.NextMarker = &v
	return s
}

// The input to the ListCertificatesByCA operation.
type ListCertificatesByCAInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If True, the results are returned in ascending
	// order, based on the creation date.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The ID of the CA certificate. This operation will list all registered device
	// certificate that were signed by this CA certificate.
	//
	// CaCertificateId is a required field
	CaCertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListCertificatesByCAInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesByCAInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificatesByCAInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertificatesByCAInput"}
	if s.CaCertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CaCertificateId"))
	}
	if s.CaCertificateId != nil && len(*s.CaCertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CaCertificateId", 64))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListCertificatesByCAInput) SetAscendingOrder(v bool) *ListCertificatesByCAInput {
	s.AscendingOrder = &v
	return s
}

// SetCaCertificateId sets the CaCertificateId field's value.
func (s *ListCertificatesByCAInput) SetCaCertificateId(v string) *ListCertificatesByCAInput {
	s.CaCertificateId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListCertificatesByCAInput) SetMarker(v string) *ListCertificatesByCAInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCertificatesByCAInput) SetPageSize(v int64) *ListCertificatesByCAInput {
	s.PageSize = &v
	return s
}

// The output of the ListCertificatesByCA operation.
type ListCertificatesByCAOutput struct {
	_ struct{} `type:"structure"`

	// The device certificates signed by the specified CA certificate.
	Certificates []*Certificate `locationName:"certificates" type:"list"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`
}

// String returns the string representation
func (s ListCertificatesByCAOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesByCAOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *ListCertificatesByCAOutput) SetCertificates(v []*Certificate) *ListCertificatesByCAOutput {
	s.Certificates = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListCertificatesByCAOutput) SetNextMarker(v string) *ListCertificatesByCAOutput {
	s.NextMarker = &v
	return s
}

// The input for the ListCertificates operation.
type ListCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If True, the results are returned in ascending
	// order, based on the creation date.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertificatesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListCertificatesInput) SetAscendingOrder(v bool) *ListCertificatesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListCertificatesInput) SetMarker(v string) *ListCertificatesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCertificatesInput) SetPageSize(v int64) *ListCertificatesInput {
	s.PageSize = &v
	return s
}

// The output of the ListCertificates operation.
type ListCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The descriptions of the certificates.
	Certificates []*Certificate `locationName:"certificates" type:"list"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`
}

// String returns the string representation
func (s ListCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *ListCertificatesOutput) SetCertificates(v []*Certificate) *ListCertificatesOutput {
	s.Certificates = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListCertificatesOutput) SetNextMarker(v string) *ListCertificatesOutput {
	s.NextMarker = &v
	return s
}

type ListIndicesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListIndicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIndicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIndicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIndicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIndicesInput) SetMaxResults(v int64) *ListIndicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicesInput) SetNextToken(v string) *ListIndicesInput {
	s.NextToken = &v
	return s
}

type ListIndicesOutput struct {
	_ struct{} `type:"structure"`

	// The index names.
	IndexNames []*string `locationName:"indexNames" type:"list"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListIndicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIndicesOutput) GoString() string {
	return s.String()
}

// SetIndexNames sets the IndexNames field's value.
func (s *ListIndicesOutput) SetIndexNames(v []*string) *ListIndicesOutput {
	s.IndexNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicesOutput) SetNextToken(v string) *ListIndicesOutput {
	s.NextToken = &v
	return s
}

type ListJobExecutionsForJobInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier you assigned to this job when it was created.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The status of the job.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"JobExecutionStatus"`
}

// String returns the string representation
func (s ListJobExecutionsForJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobExecutionsForJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobExecutionsForJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobExecutionsForJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *ListJobExecutionsForJobInput) SetJobId(v string) *ListJobExecutionsForJobInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobExecutionsForJobInput) SetMaxResults(v int64) *ListJobExecutionsForJobInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobExecutionsForJobInput) SetNextToken(v string) *ListJobExecutionsForJobInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListJobExecutionsForJobInput) SetStatus(v string) *ListJobExecutionsForJobInput {
	s.Status = &v
	return s
}

type ListJobExecutionsForJobOutput struct {
	_ struct{} `type:"structure"`

	// A list of job execution summaries.
	ExecutionSummaries []*JobExecutionSummaryForJob `locationName:"executionSummaries" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListJobExecutionsForJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobExecutionsForJobOutput) GoString() string {
	return s.String()
}

// SetExecutionSummaries sets the ExecutionSummaries field's value.
func (s *ListJobExecutionsForJobOutput) SetExecutionSummaries(v []*JobExecutionSummaryForJob) *ListJobExecutionsForJobOutput {
	s.ExecutionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobExecutionsForJobOutput) SetNextToken(v string) *ListJobExecutionsForJobOutput {
	s.NextToken = &v
	return s
}

type ListJobExecutionsForThingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An optional filter that lets you search for jobs that have the specified
	// status.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"JobExecutionStatus"`

	// The thing name.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListJobExecutionsForThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobExecutionsForThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobExecutionsForThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobExecutionsForThingInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobExecutionsForThingInput) SetMaxResults(v int64) *ListJobExecutionsForThingInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobExecutionsForThingInput) SetNextToken(v string) *ListJobExecutionsForThingInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListJobExecutionsForThingInput) SetStatus(v string) *ListJobExecutionsForThingInput {
	s.Status = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *ListJobExecutionsForThingInput) SetThingName(v string) *ListJobExecutionsForThingInput {
	s.ThingName = &v
	return s
}

type ListJobExecutionsForThingOutput struct {
	_ struct{} `type:"structure"`

	// A list of job execution summaries.
	ExecutionSummaries []*JobExecutionSummaryForThing `locationName:"executionSummaries" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListJobExecutionsForThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobExecutionsForThingOutput) GoString() string {
	return s.String()
}

// SetExecutionSummaries sets the ExecutionSummaries field's value.
func (s *ListJobExecutionsForThingOutput) SetExecutionSummaries(v []*JobExecutionSummaryForThing) *ListJobExecutionsForThingOutput {
	s.ExecutionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobExecutionsForThingOutput) SetNextToken(v string) *ListJobExecutionsForThingOutput {
	s.NextToken = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An optional filter that lets you search for jobs that have the specified
	// status.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"JobStatus"`

	// Specifies whether the job will continue to run (CONTINUOUS), or will be complete
	// after all those things specified as targets have completed the job (SNAPSHOT).
	// If continuous, the job may also be run on a thing when a change is detected
	// in a target. For example, a job will run on a thing when the thing is added
	// to a target group, even after the job was completed by all things originally
	// in the group.
	TargetSelection *string `location:"querystring" locationName:"targetSelection" type:"string" enum:"TargetSelection"`

	// A filter that limits the returned jobs to those for the specified group.
	ThingGroupId *string `location:"querystring" locationName:"thingGroupId" min:"1" type:"string"`

	// A filter that limits the returned jobs to those for the specified group.
	ThingGroupName *string `location:"querystring" locationName:"thingGroupName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ThingGroupId != nil && len(*s.ThingGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupId", 1))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListJobsInput) SetStatus(v string) *ListJobsInput {
	s.Status = &v
	return s
}

// SetTargetSelection sets the TargetSelection field's value.
func (s *ListJobsInput) SetTargetSelection(v string) *ListJobsInput {
	s.TargetSelection = &v
	return s
}

// SetThingGroupId sets the ThingGroupId field's value.
func (s *ListJobsInput) SetThingGroupId(v string) *ListJobsInput {
	s.ThingGroupId = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *ListJobsInput) SetThingGroupName(v string) *ListJobsInput {
	s.ThingGroupName = &v
	return s
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of jobs.
	Jobs []*JobSummary `locationName:"jobs" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsOutput) SetJobs(v []*JobSummary) *ListJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

type ListOTAUpdatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token used to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The OTA update job status.
	OtaUpdateStatus *string `location:"querystring" locationName:"otaUpdateStatus" type:"string" enum:"OTAUpdateStatus"`
}

// String returns the string representation
func (s ListOTAUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOTAUpdatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOTAUpdatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOTAUpdatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOTAUpdatesInput) SetMaxResults(v int64) *ListOTAUpdatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOTAUpdatesInput) SetNextToken(v string) *ListOTAUpdatesInput {
	s.NextToken = &v
	return s
}

// SetOtaUpdateStatus sets the OtaUpdateStatus field's value.
func (s *ListOTAUpdatesInput) SetOtaUpdateStatus(v string) *ListOTAUpdatesInput {
	s.OtaUpdateStatus = &v
	return s
}

type ListOTAUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// A token to use to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of OTA update jobs.
	OtaUpdates []*OTAUpdateSummary `locationName:"otaUpdates" type:"list"`
}

// String returns the string representation
func (s ListOTAUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOTAUpdatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOTAUpdatesOutput) SetNextToken(v string) *ListOTAUpdatesOutput {
	s.NextToken = &v
	return s
}

// SetOtaUpdates sets the OtaUpdates field's value.
func (s *ListOTAUpdatesOutput) SetOtaUpdates(v []*OTAUpdateSummary) *ListOTAUpdatesOutput {
	s.OtaUpdates = v
	return s
}

// The input to the ListOutgoingCertificates operation.
type ListOutgoingCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If True, the results are returned in ascending
	// order, based on the creation date.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListOutgoingCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutgoingCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOutgoingCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOutgoingCertificatesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListOutgoingCertificatesInput) SetAscendingOrder(v bool) *ListOutgoingCertificatesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListOutgoingCertificatesInput) SetMarker(v string) *ListOutgoingCertificatesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListOutgoingCertificatesInput) SetPageSize(v int64) *ListOutgoingCertificatesInput {
	s.PageSize = &v
	return s
}

// The output from the ListOutgoingCertificates operation.
type ListOutgoingCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The certificates that are being transferred but not yet accepted.
	OutgoingCertificates []*OutgoingCertificate `locationName:"outgoingCertificates" type:"list"`
}

// String returns the string representation
func (s ListOutgoingCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutgoingCertificatesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListOutgoingCertificatesOutput) SetNextMarker(v string) *ListOutgoingCertificatesOutput {
	s.NextMarker = &v
	return s
}

// SetOutgoingCertificates sets the OutgoingCertificates field's value.
func (s *ListOutgoingCertificatesOutput) SetOutgoingCertificates(v []*OutgoingCertificate) *ListOutgoingCertificatesOutput {
	s.OutgoingCertificates = v
	return s
}

// The input for the ListPolicies operation.
type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If true, the results are returned in ascending
	// creation order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListPoliciesInput) SetAscendingOrder(v bool) *ListPoliciesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPoliciesInput) SetMarker(v string) *ListPoliciesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPoliciesInput) SetPageSize(v int64) *ListPoliciesInput {
	s.PageSize = &v
	return s
}

// The output from the ListPolicies operation.
type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The descriptions of the policies.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListPoliciesOutput) SetNextMarker(v string) *ListPoliciesOutput {
	s.NextMarker = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPoliciesOutput) SetPolicies(v []*Policy) *ListPoliciesOutput {
	s.Policies = v
	return s
}

// The input for the ListPolicyPrincipals operation.
type ListPolicyPrincipalsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If true, the results are returned in ascending
	// creation order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"header" locationName:"x-amzn-iot-policy" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPolicyPrincipalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyPrincipalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyPrincipalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPolicyPrincipalsInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListPolicyPrincipalsInput) SetAscendingOrder(v bool) *ListPolicyPrincipalsInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPolicyPrincipalsInput) SetMarker(v string) *ListPolicyPrincipalsInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPolicyPrincipalsInput) SetPageSize(v int64) *ListPolicyPrincipalsInput {
	s.PageSize = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ListPolicyPrincipalsInput) SetPolicyName(v string) *ListPolicyPrincipalsInput {
	s.PolicyName = &v
	return s
}

// The output from the ListPolicyPrincipals operation.
type ListPolicyPrincipalsOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The descriptions of the principals.
	Principals []*string `locationName:"principals" type:"list"`
}

// String returns the string representation
func (s ListPolicyPrincipalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyPrincipalsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListPolicyPrincipalsOutput) SetNextMarker(v string) *ListPolicyPrincipalsOutput {
	s.NextMarker = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ListPolicyPrincipalsOutput) SetPrincipals(v []*string) *ListPolicyPrincipalsOutput {
	s.Principals = v
	return s
}

// The input for the ListPolicyVersions operation.
type ListPolicyVersionsInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPolicyVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPolicyVersionsInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *ListPolicyVersionsInput) SetPolicyName(v string) *ListPolicyVersionsInput {
	s.PolicyName = &v
	return s
}

// The output from the ListPolicyVersions operation.
type ListPolicyVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The policy versions.
	PolicyVersions []*PolicyVersion `locationName:"policyVersions" type:"list"`
}

// String returns the string representation
func (s ListPolicyVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsOutput) GoString() string {
	return s.String()
}

// SetPolicyVersions sets the PolicyVersions field's value.
func (s *ListPolicyVersionsOutput) SetPolicyVersions(v []*PolicyVersion) *ListPolicyVersionsOutput {
	s.PolicyVersions = v
	return s
}

// The input for the ListPrincipalPolicies operation.
type ListPrincipalPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If true, results are returned in ascending
	// creation order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The principal.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPrincipalPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrincipalPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrincipalPoliciesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListPrincipalPoliciesInput) SetAscendingOrder(v bool) *ListPrincipalPoliciesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPrincipalPoliciesInput) SetMarker(v string) *ListPrincipalPoliciesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPrincipalPoliciesInput) SetPageSize(v int64) *ListPrincipalPoliciesInput {
	s.PageSize = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ListPrincipalPoliciesInput) SetPrincipal(v string) *ListPrincipalPoliciesInput {
	s.Principal = &v
	return s
}

// The output from the ListPrincipalPolicies operation.
type ListPrincipalPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The policies.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ListPrincipalPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListPrincipalPoliciesOutput) SetNextMarker(v string) *ListPrincipalPoliciesOutput {
	s.NextMarker = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPrincipalPoliciesOutput) SetPolicies(v []*Policy) *ListPrincipalPoliciesOutput {
	s.Policies = v
	return s
}

// The input for the ListPrincipalThings operation.
type ListPrincipalThingsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The principal.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPrincipalThingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalThingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrincipalThingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrincipalThingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPrincipalThingsInput) SetMaxResults(v int64) *ListPrincipalThingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrincipalThingsInput) SetNextToken(v string) *ListPrincipalThingsInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ListPrincipalThingsInput) SetPrincipal(v string) *ListPrincipalThingsInput {
	s.Principal = &v
	return s
}

// The output from the ListPrincipalThings operation.
type ListPrincipalThingsOutput struct {
	_ struct{} `type:"structure"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The things.
	Things []*string `locationName:"things" type:"list"`
}

// String returns the string representation
func (s ListPrincipalThingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalThingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrincipalThingsOutput) SetNextToken(v string) *ListPrincipalThingsOutput {
	s.NextToken = &v
	return s
}

// SetThings sets the Things field's value.
func (s *ListPrincipalThingsOutput) SetThings(v []*string) *ListPrincipalThingsOutput {
	s.Things = v
	return s
}

type ListRoleAliasesInput struct {
	_ struct{} `type:"structure"`

	// Return the list of role aliases in ascending alphabetical order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// A marker used to get the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of results to return at one time.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListRoleAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoleAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoleAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoleAliasesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListRoleAliasesInput) SetAscendingOrder(v bool) *ListRoleAliasesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListRoleAliasesInput) SetMarker(v string) *ListRoleAliasesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRoleAliasesInput) SetPageSize(v int64) *ListRoleAliasesInput {
	s.PageSize = &v
	return s
}

type ListRoleAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A marker used to get the next set of results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The role aliases.
	RoleAliases []*string `locationName:"roleAliases" type:"list"`
}

// String returns the string representation
func (s ListRoleAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoleAliasesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRoleAliasesOutput) SetNextMarker(v string) *ListRoleAliasesOutput {
	s.NextMarker = &v
	return s
}

// SetRoleAliases sets the RoleAliases field's value.
func (s *ListRoleAliasesOutput) SetRoleAliases(v []*string) *ListRoleAliasesOutput {
	s.RoleAliases = v
	return s
}

type ListScheduledAuditsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time. The default is 25.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListScheduledAuditsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListScheduledAuditsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListScheduledAuditsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListScheduledAuditsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListScheduledAuditsInput) SetMaxResults(v int64) *ListScheduledAuditsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduledAuditsInput) SetNextToken(v string) *ListScheduledAuditsInput {
	s.NextToken = &v
	return s
}

type ListScheduledAuditsOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of scheduled audits.
	ScheduledAudits []*ScheduledAuditMetadata `locationName:"scheduledAudits" type:"list"`
}

// String returns the string representation
func (s ListScheduledAuditsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListScheduledAuditsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduledAuditsOutput) SetNextToken(v string) *ListScheduledAuditsOutput {
	s.NextToken = &v
	return s
}

// SetScheduledAudits sets the ScheduledAudits field's value.
func (s *ListScheduledAuditsOutput) SetScheduledAudits(v []*ScheduledAuditMetadata) *ListScheduledAuditsOutput {
	s.ScheduledAudits = v
	return s
}

type ListSecurityProfilesForTargetInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// If true, return child groups as well.
	Recursive *bool `location:"querystring" locationName:"recursive" type:"boolean"`

	// The ARN of the target (thing group) whose attached security profiles you
	// want to get.
	//
	// SecurityProfileTargetArn is a required field
	SecurityProfileTargetArn *string `location:"querystring" locationName:"securityProfileTargetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListSecurityProfilesForTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityProfilesForTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecurityProfilesForTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecurityProfilesForTargetInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SecurityProfileTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileTargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecurityProfilesForTargetInput) SetMaxResults(v int64) *ListSecurityProfilesForTargetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityProfilesForTargetInput) SetNextToken(v string) *ListSecurityProfilesForTargetInput {
	s.NextToken = &v
	return s
}

// SetRecursive sets the Recursive field's value.
func (s *ListSecurityProfilesForTargetInput) SetRecursive(v bool) *ListSecurityProfilesForTargetInput {
	s.Recursive = &v
	return s
}

// SetSecurityProfileTargetArn sets the SecurityProfileTargetArn field's value.
func (s *ListSecurityProfilesForTargetInput) SetSecurityProfileTargetArn(v string) *ListSecurityProfilesForTargetInput {
	s.SecurityProfileTargetArn = &v
	return s
}

type ListSecurityProfilesForTargetOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of security profiles and their associated targets.
	SecurityProfileTargetMappings []*SecurityProfileTargetMapping `locationName:"securityProfileTargetMappings" type:"list"`
}

// String returns the string representation
func (s ListSecurityProfilesForTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityProfilesForTargetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityProfilesForTargetOutput) SetNextToken(v string) *ListSecurityProfilesForTargetOutput {
	s.NextToken = &v
	return s
}

// SetSecurityProfileTargetMappings sets the SecurityProfileTargetMappings field's value.
func (s *ListSecurityProfilesForTargetOutput) SetSecurityProfileTargetMappings(v []*SecurityProfileTargetMapping) *ListSecurityProfilesForTargetOutput {
	s.SecurityProfileTargetMappings = v
	return s
}

type ListSecurityProfilesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSecurityProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecurityProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecurityProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecurityProfilesInput) SetMaxResults(v int64) *ListSecurityProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityProfilesInput) SetNextToken(v string) *ListSecurityProfilesInput {
	s.NextToken = &v
	return s
}

type ListSecurityProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of security profile identifiers (names and ARNs).
	SecurityProfileIdentifiers []*SecurityProfileIdentifier `locationName:"securityProfileIdentifiers" type:"list"`
}

// String returns the string representation
func (s ListSecurityProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityProfilesOutput) SetNextToken(v string) *ListSecurityProfilesOutput {
	s.NextToken = &v
	return s
}

// SetSecurityProfileIdentifiers sets the SecurityProfileIdentifiers field's value.
func (s *ListSecurityProfilesOutput) SetSecurityProfileIdentifiers(v []*SecurityProfileIdentifier) *ListSecurityProfilesOutput {
	s.SecurityProfileIdentifiers = v
	return s
}

type ListStreamsInput struct {
	_ struct{} `type:"structure"`

	// Set to true to return the list of streams in ascending order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The maximum number of results to return at a time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token used to get the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListStreamsInput) SetAscendingOrder(v bool) *ListStreamsInput {
	s.AscendingOrder = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStreamsInput) SetMaxResults(v int64) *ListStreamsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsInput) SetNextToken(v string) *ListStreamsInput {
	s.NextToken = &v
	return s
}

type ListStreamsOutput struct {
	_ struct{} `type:"structure"`

	// A token used to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of streams.
	Streams []*StreamSummary `locationName:"streams" type:"list"`
}

// String returns the string representation
func (s ListStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsOutput) SetNextToken(v string) *ListStreamsOutput {
	s.NextToken = &v
	return s
}

// SetStreams sets the Streams field's value.
func (s *ListStreamsOutput) SetStreams(v []*StreamSummary) *ListStreamsOutput {
	s.Streams = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of tags assigned to the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTargetsForPolicyInput struct {
	_ struct{} `type:"structure"`

	// A marker used to get the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of results to return at one time.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTargetsForPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsForPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsForPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsForPolicyInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListTargetsForPolicyInput) SetMarker(v string) *ListTargetsForPolicyInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTargetsForPolicyInput) SetPageSize(v int64) *ListTargetsForPolicyInput {
	s.PageSize = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ListTargetsForPolicyInput) SetPolicyName(v string) *ListTargetsForPolicyInput {
	s.PolicyName = &v
	return s
}

type ListTargetsForPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A marker used to get the next set of results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The policy targets.
	Targets []*string `locationName:"targets" type:"list"`
}

// String returns the string representation
func (s ListTargetsForPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsForPolicyOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListTargetsForPolicyOutput) SetNextMarker(v string) *ListTargetsForPolicyOutput {
	s.NextMarker = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsForPolicyOutput) SetTargets(v []*string) *ListTargetsForPolicyOutput {
	s.Targets = v
	return s
}

type ListTargetsForSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The security profile.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTargetsForSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsForSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsForSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsForSecurityProfileInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTargetsForSecurityProfileInput) SetMaxResults(v int64) *ListTargetsForSecurityProfileInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsForSecurityProfileInput) SetNextToken(v string) *ListTargetsForSecurityProfileInput {
	s.NextToken = &v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *ListTargetsForSecurityProfileInput) SetSecurityProfileName(v string) *ListTargetsForSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

type ListTargetsForSecurityProfileOutput struct {
	_ struct{} `type:"structure"`

