//  Copyright (c) 2006 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Each row of data contains in order:
//
// n, phi, k, PI(n, phi, k)
//
   static const std::array<std::array<typename table_type<T>::type, 4>, 400> ellint_pi3_data = {{
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.15321610867977142333984375e0), SC_(0.814723670482635498046875e0), SC_(0.15373203842748125370338546651780574888816846402842e0) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.1994704306125640869140625e0), SC_(0.135477006435394287109375e0), SC_(0.19975117232566753482238350513231879856319046077755e0) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.2128067910671234130859375e0), SC_(0.905791938304901123046875e0), SC_(0.21444962146028791552496083456124507126701014421723e0) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.295909702777862548828125e0), SC_(0.835008561611175537109375e0), SC_(0.2997980220798275355640498732995940042091456814389e0) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.3471994698047637939453125e0), SC_(0.12698681652545928955078125e0), SC_(0.3486476485633547682857103272510437125962758824058e0) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.4374639987945556640625e0), SC_(0.968867778778076171875e0), SC_(0.45394401267101670348318068398554096043112056011139e0) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.4840676784515380859375e0), SC_(0.9133758544921875e0), SC_(0.50429356834860180919136192213432534063086058053706e0) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.859039485454559326171875e0), SC_(0.22103404998779296875e0), SC_(0.88214398516284753446093152446515519356116616485632e0) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.859572112560272216796875e0), SC_(0.6323592662811279296875e0), SC_(0.92068616339339750141383142107393122316780108757901e0) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.993307650089263916015625e0), SC_(0.308167040348052978515625e0), SC_(0.10344161605846899329010060099405650089702846030678e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.127976500988006591796875e1), SC_(0.97540400922298431396484375e-1), SC_(0.13345405612458198850035058621296608418958648996025e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.131162846088409423828125e1), SC_(0.54722058773040771484375e0), SC_(0.1467211661750789199498096403270216766602112811216e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.142281472682952880859375e1), SC_(0.278498232364654541015625e0), SC_(0.1517376955674343715832681461618162299318704226245e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.14347274303436279296875e1), SC_(0.188381969928741455078125e0), SC_(0.15154584947701684136724391750741680569501800622377e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.150404822826385498046875e1), SC_(0.546881496906280517578125e0), SC_(0.17193768372540183459266121250638009185486028760609e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.15156433582305908203125e1), SC_(0.992881298065185546875e0), SC_(0.32971643837652261637854814203821825514327178475199e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.15200517177581787109375e1), SC_(0.957506835460662841796875e0), SC_(0.26533602409619323321869623248304538129999833091585e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.1521893978118896484375e1), SC_(0.996461331844329833984375e0), SC_(0.3561780644579714064351594651991953922505125185799e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.155961430072784423828125e1), SC_(0.964888513088226318359375e0), SC_(0.28980698413581142714910692917445567690962125009838e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.156523787975311279296875e1), SC_(0.967694938182830810546875e0), SC_(0.2963846383355250968965561470164902664673523718254e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.15321610867977142333984375e0), SC_(0.15761308372020721435546875e0), SC_(0.15338276528480469307645524589925911983842933545318e0) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.1994704306125640869140625e0), SC_(0.725838959217071533203125e0), SC_(0.20050472017966223244832559958930749817872953420574e0) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.2128067910671234130859375e0), SC_(0.970592796802520751953125e0), SC_(0.21474633975859950860058990149085299903493818118173e0) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.295909702777862548828125e0), SC_(0.981109678745269775390625e0), SC_(0.30126622877564752427416022416319928001205083826745e0) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.3471994698047637939453125e0), SC_(0.957166969776153564453125e0), SC_(0.35556281810161664845441307089338900623226704681013e0) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.4374639987945556640625e0), SC_(0.109861753880977630615234375e0), SC_(0.44108704490870617851306791784352122043342900288043e0) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.4840676784515380859375e0), SC_(0.4853756427764892578125e0), SC_(0.4931534053333340013873746669080440363943172483071e0) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.859039485454559326171875e0), SC_(0.79810583591461181640625e0), SC_(0.95793555582395747656127633027011309520362186574239e0) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.859572112560272216796875e0), SC_(0.80028045177459716796875e0), SC_(0.95916493478176953527039854676450394699681072398641e0) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.993307650089263916015625e0), SC_(0.297029435634613037109375e0), SC_(0.10423576221417789616871878908198112649827548095731e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.127976500988006591796875e1), SC_(0.14188633859157562255859375e0), SC_(0.13546856275247299959686911377471236914557130492097e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.131162846088409423828125e1), SC_(0.47834846191108226776123046875e-2), SC_(0.13852508127489059545144640536254575613018719622883e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.142281472682952880859375e1), SC_(0.4217612743377685546875e0), SC_(0.1580806460730606927026951555195055758185719667744e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.14347274303436279296875e1), SC_(0.1124645173549652099609375e0), SC_(0.15299877934449998899665605808479497934876736447949e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.150404822826385498046875e1), SC_(0.915735542774200439453125e0), SC_(0.23689609442676919170416815484427154520853373075881e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.15156433582305908203125e1), SC_(0.639763355255126953125e0), SC_(0.1835738109897334786523262319533878046183264001931e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.15200517177581787109375e1), SC_(0.792207300662994384765625e0), SC_(0.20421897283663486226184747704649952019905530832883e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.1521893978118896484375e1), SC_(0.878430664539337158203125e0), SC_(0.22634516501807612485356151537759920819079714452558e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.155961430072784423828125e1), SC_(0.9594924449920654296875e0), SC_(0.28887516554719816744397706140122177270738385968024e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.156523787975311279296875e1), SC_(0.50366270542144775390625e0), SC_(0.18034472925184640376371577046428385276285373444411e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.15321610867977142333984375e0), SC_(0.655740678310394287109375e0), SC_(0.15363629557196132980883089360225522896492220958322e0) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.1994704306125640869140625e0), SC_(0.797928631305694580078125e0), SC_(0.20067494179979137242421676287559757328741739620642e0) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.2128067910671234130859375e0), SC_(0.357116796076297760009765625e-1), SC_(0.21324169024677035294223198881641105042673468575295e0) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.295909702777862548828125e0), SC_(0.3612940013408660888671875e0), SC_(0.29762814633345360441629373229306400484051906392213e0) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.3471994698047637939453125e0), SC_(0.84912931919097900390625e0), SC_(0.35421678576166500134526995976876470429367721514915e0) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.4374639987945556640625e0), SC_(0.21192432940006256103515625e0), SC_(0.44177167179472452041878404853114448084677945000124e0) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.4840676784515380859375e0), SC_(0.93399322032928466796875e0), SC_(0.50663380674601173483407086537779743434452929228299e0) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.859039485454559326171875e0), SC_(0.6813595294952392578125e0), SC_(0.93627839278165512585472067471532220087472706511487e0) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.859572112560272216796875e0), SC_(0.67873513698577880859375e0), SC_(0.93649514133220802251023716495055301794222292469291e0) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.993307650089263916015625e0), SC_(0.3987385332584381103515625e0), SC_(0.10560205210680177542821652194191329203962951766098e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.127976500988006591796875e1), SC_(0.75774013996124267578125e0), SC_(0.15792362576660079817584588221413499564813109220967e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.131162846088409423828125e1), SC_(0.740647256374359130859375e0), SC_(0.16166573009327473944412502794295013421915138113773e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.142281472682952880859375e1), SC_(0.74313247203826904296875e0), SC_(0.18051149573204353151046319086097224034327358735037e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.14347274303436279296875e1), SC_(0.474758684635162353515625e0), SC_(0.16246331859624891584468937862242197255022663725014e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.150404822826385498046875e1), SC_(0.3922270238399505615234375e0), SC_(0.16794499146710961167059977468015447083859789387452e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.15156433582305908203125e1), SC_(0.42208766937255859375e0), SC_(0.17060778738061936719641657840144566082201208057621e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.15200517177581787109375e1), SC_(0.65547788143157958984375e0), SC_(0.18666567615959102360545655098338303883335250287837e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.1521893978118896484375e1), SC_(0.1738651692867279052734375e0), SC_(0.16454282072183386718850345865233706115846811877772e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.155961430072784423828125e1), SC_(0.1711866855621337890625e0), SC_(0.16893141542034271144719727903810757021076763554868e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.156523787975311279296875e1), SC_(0.3019131124019622802734375e0), SC_(0.17247629437572107835994205744033158553091594172942e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.15321610867977142333984375e0), SC_(0.70604610443115234375e0), SC_(0.15374129235371893318320391783184832151469294397024e0) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.1994704306125640869140625e0), SC_(0.797279894351959228515625e0), SC_(0.2008145356675702347171190965342317709807636891598e0) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.2128067910671234130859375e0), SC_(0.318328440189361572265625e-1), SC_(0.21341117056965599965495209080176878817755967511103e0) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.295909702777862548828125e0), SC_(0.316550433635711669921875e0), SC_(0.29795513263165928606457135223504215685844085773217e0) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.3471994698047637939453125e0), SC_(0.2769229710102081298828125e0), SC_(0.35033068412795226925211701071698054849499734821317e0) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.4374639987945556640625e0), SC_(0.872428834438323974609375e0), SC_(0.45377622361953390225693442448312860081404123131496e0) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.4840676784515380859375e0), SC_(0.46171389520168304443359375e-1), SC_(0.49107707095547017672688328632255114847364396826043e0) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.859039485454559326171875e0), SC_(0.1491139829158782958984375e0), SC_(0.89809346952145047341364443710813312775512398687315e0) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.859572112560272216796875e0), SC_(0.9713177382946014404296875e-1), SC_(0.89742881227836558792767615520993058490648040919703e0) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.993307650089263916015625e0), SC_(0.99406850337982177734375e0), SC_(0.12866346097182797011525547537719695362479512768895e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.127976500988006591796875e1), SC_(0.82345783710479736328125e0), SC_(0.16914757898617543913705440681606954379713844698507e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.131162846088409423828125e1), SC_(0.821903288364410400390625e0), SC_(0.17526435342761314289792276986725477524729486307092e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.142281472682952880859375e1), SC_(0.69482862949371337890625e0), SC_(0.18074516959783082924161058130735089760598245925545e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.14347274303436279296875e1), SC_(0.12518276274204254150390625e0), SC_(0.15821089098843317773364875191045306220560055453024e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.150404822826385498046875e1), SC_(0.3170994818210601806640625e0), SC_(0.17058814441489491473297807610972946548213895543091e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.15156433582305908203125e1), SC_(0.763750016689300537109375e0), SC_(0.20637169193009524132911154276297356959219373460124e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.15200517177581787109375e1), SC_(0.950222074985504150390625e0), SC_(0.27609962127380559638098576214993238543182071812583e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.1521893978118896484375e1), SC_(0.4905890524387359619140625e0), SC_(0.18032026658448356902584396515553902990867775956652e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.155961430072784423828125e1), SC_(0.344460792839527130126953125e-1), SC_(0.17303476959832356294063472935024048455993292586807e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.156523787975311279296875e1), SC_(0.663605511188507080078125e0), SC_(0.20113750121583671741913865522845026629311302910205e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.15321610867977142333984375e0), SC_(0.438744366168975830078125e0), SC_(0.1535961334273079861587554680902180767535933121918e0) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.1994704306125640869140625e0), SC_(0.125896632671356201171875e0), SC_(0.20007451067950229557071601603618648918488711197919e0) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.2128067910671234130859375e0), SC_(0.3815584480762481689453125e0), SC_(0.21374845606321022784859713852988170011624650844054e0) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.295909702777862548828125e0), SC_(0.210209071636199951171875e0), SC_(0.29799713063089460727421513782103336686001971629263e0) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.3471994698047637939453125e0), SC_(0.765516817569732666015625e0), SC_(0.35444071148127028925045636140809782748017213282674e0) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.4374639987945556640625e0), SC_(0.512164272367954254150390625e-1), SC_(0.44358367380486624727607248832401085063181616261823e0) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.4840676784515380859375e0), SC_(0.795199930667877197265625e0), SC_(0.50483832329245369216251822963557623972617072245322e0) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.859039485454559326171875e0), SC_(0.3644125163555145263671875e-1), SC_(0.90299571928636336736922979730603695661988483695763e0) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.859572112560272216796875e0), SC_(0.18687260150909423828125e0), SC_(0.90697574315316785499358809761253389134040276995581e0) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.993307650089263916015625e0), SC_(0.408731162548065185546875e0), SC_(0.10856589748405692386816934071269772056858576647844e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.127976500988006591796875e1), SC_(0.489764392375946044921875e0), SC_(0.14886223498445177499912691983828381727724836491669e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.131162846088409423828125e1), SC_(0.457989156246185302734375e0), SC_(0.15220768540074777299689071277697836406097310372819e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.142281472682952880859375e1), SC_(0.44558620452880859375e0), SC_(0.16744936605233572376252500760257564793127109126491e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.14347274303436279296875e1), SC_(0.487568914890289306640625e0), SC_(0.17110729628156196981212899770183869772565168863267e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.150404822826385498046875e1), SC_(0.646313011646270751953125e0), SC_(0.1933092756197274518916224005354708607388503185371e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.15156433582305908203125e1), SC_(0.79397499561309814453125e0), SC_(0.2166255974158738876201014946009867539448484268238e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.15200517177581787109375e1), SC_(0.709364831447601318359375e0), SC_(0.2034428279940906279008383937197067818330582509111e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.1521893978118896484375e1), SC_(0.920874774456024169921875e0), SC_(0.2616800166987692910971567207696862859904694205349e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.155961430072784423828125e1), SC_(0.754686653614044189453125e0), SC_(0.2179805727870919063027322336453024912606464369963e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.156523787975311279296875e1), SC_(0.80753099918365478515625e0), SC_(0.23029746114936592935848874987910772650992336584872e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.15321610867977142333984375e0), SC_(0.2760250866413116455078125e0), SC_(0.15359541782380050352597486443399222909392234264685e0) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.1994704306125640869140625e0), SC_(0.705774247646331787109375e0), SC_(0.20087009631940590382571690580804294285648939517886e0) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.2128067910671234130859375e0), SC_(0.679702699184417724609375e0), SC_(0.21444797183262799392607887736033371299155530609359e0) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.295909702777862548828125e0), SC_(0.281843240372836589813232421875e-2), SC_(0.29830765543973898992025811850671529367027500970513e0) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.3471994698047637939453125e0), SC_(0.655098021030426025390625e0), SC_(0.35411794025945834835727211951953443076949635747455e0) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.4374639987945556640625e0), SC_(0.71070384979248046875e0), SC_(0.4524826643757160648605550478329710828157251664892e0) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.4840676784515380859375e0), SC_(0.16261173784732818603515625e0), SC_(0.49499697125379261889806778419304409139008558843921e0) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.859039485454559326171875e0), SC_(0.6439609527587890625e0), SC_(0.96333163295565645502967783347483325884263807771615e0) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.859572112560272216796875e0), SC_(0.11899767816066741943359375e0), SC_(0.9176561440475954755039102167213592687115744135363e0) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.993307650089263916015625e0), SC_(0.456032812595367431640625e0), SC_(0.11134022476344790910101546725940210489730674983636e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.127976500988006591796875e1), SC_(0.4983640611171722412109375e0), SC_(0.15368295460927824856946772689083585631020920131703e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.131162846088409423828125e1), SC_(0.773917138576507568359375e0), SC_(0.17830405487442546796542290785991455855656124062556e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.142281472682952880859375e1), SC_(0.959743976593017578125e0), SC_(0.26237895927756704539015875648309470455458940161269e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.14347274303436279296875e1), SC_(0.57375466823577880859375e0), SC_(0.18255750883765396647112454665804781738544974696669e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.150404822826385498046875e1), SC_(0.340385735034942626953125e0), SC_(0.18131037694384272884073379641282368202293747220275e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.15156433582305908203125e1), SC_(0.876757442951202392578125e0), SC_(0.24978164737894485672194659894415770879812438246432e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.15200517177581787109375e1), SC_(0.585267722606658935546875e0), SC_(0.19789188390198927819451388121514228171201085780378e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.1521893978118896484375e1), SC_(0.808175504207611083984375e0), SC_(0.23043263816568838971690889587715553812810080017821e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.155961430072784423828125e1), SC_(0.22381193935871124267578125e0), SC_(0.18591676639051519540527805732955958744105106103142e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.156523787975311279296875e1), SC_(0.177738964557647705078125e-1), SC_(0.18417264218153788933151910939894397755769046323768e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.15321610867977142333984375e0), SC_(0.75126707553863525390625e0), SC_(0.15392567485046429104853351638076369308441312440194e0) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.1994704306125640869140625e0), SC_(0.821245968341827392578125e0), SC_(0.20118756667244770992110958566757492099981524943717e0) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.2128067910671234130859375e0), SC_(0.25509512424468994140625e0), SC_(0.21390060705363350408076620954899649469747666138872e0) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.295909702777862548828125e0), SC_(0.820840775966644287109375e0), SC_(0.30155059618105085830666692356165451679878348376507e0) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.3471994698047637939453125e0), SC_(0.505957067012786865234375e0), SC_(0.35329539424037961151212458125809826398055395541705e0) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.4374639987945556640625e0), SC_(0.940074026584625244140625e0), SC_(0.45930022500374264535920809304342668001912426848082e0) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.4840676784515380859375e0), SC_(0.699076712131500244140625e0), SC_(0.50532921843610224822188904193980807204299968331298e0) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.859039485454559326171875e0), SC_(0.4126665294170379638671875e0), SC_(0.94076579198312640059853653523053054951670998420627e0) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.859572112560272216796875e0), SC_(0.8909032344818115234375e0), SC_(0.10302320117360371620572455298638790520158782314861e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.993307650089263916015625e0), SC_(0.4231651127338409423828125e0), SC_(0.11194350928930373957087037995051718294575131965952e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.127976500988006591796875e1), SC_(0.959291398525238037109375e0), SC_(0.2105640545937209865793460126473308981607671818351e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.131162846088409423828125e1), SC_(0.5809566974639892578125e0), SC_(0.16542811049231352756099077522451639718250570933187e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.142281472682952880859375e1), SC_(0.547215521335601806640625e0), SC_(0.18227251405247038014457677379504342975130147875429e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.14347274303436279296875e1), SC_(0.15805758535861968994140625e0), SC_(0.17029536585882085658642883555352536099982100046429e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.150404822826385498046875e1), SC_(0.13862444460391998291015625e0), SC_(0.18011727896006691442429472244668928246761893745114e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.15156433582305908203125e1), SC_(0.761731207370758056640625e0), SC_(0.22424388225967142214463496089885385435429884763411e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.15200517177581787109375e1), SC_(0.14929400384426116943359375e0), SC_(0.18259999071161079666724764785633064412899826784228e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.1521893978118896484375e1), SC_(0.23015606403350830078125e0), SC_(0.18440796562186155881647002585956695417463014805546e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.155961430072784423828125e1), SC_(0.2575082480907440185546875e0), SC_(0.19073443315304275817280146256306210452474615171165e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.156523787975311279296875e1), SC_(0.809734523296356201171875e0), SC_(0.24680665053651211920659364343243037508421719972311e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.15321610867977142333984375e0), SC_(0.840717256069183349609375e0), SC_(0.15430191164125987413293996120618665981534857333765e0) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.1994704306125640869140625e0), SC_(0.988521575927734375e0), SC_(0.20224679678600899598988461657720043375320482570529e0) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.2128067910671234130859375e0), SC_(0.254282176494598388671875e0), SC_(0.21467837012396115801541257902605108910689958506691e0) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.295909702777862548828125e0), SC_(0.3324482738971710205078125e0), SC_(0.30117035511666434450009340920986806453217985836914e0) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.3471994698047637939453125e0), SC_(0.814284801483154296875e0), SC_(0.3598145341367038812561615485839961747283045936216e0) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.4374639987945556640625e0), SC_(0.2998317182064056396484375e0), SC_(0.45438791796517087379541413090689801503022764166296e0) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.4840676784515380859375e0), SC_(0.243524968624114990234375e0), SC_(0.50651360267838455337049620434256116881293607563184e0) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.859039485454559326171875e0), SC_(0.13539127074182033538818359375e-1), SC_(0.98444868321134112616327742058262550532022365829997e0) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.859572112560272216796875e0), SC_(0.929263651371002197265625e0), SC_(0.11202387372756731561909381445040107404687318049755e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.993307650089263916015625e0), SC_(0.21723784506320953369140625e0), SC_(0.11996102990401438772325527772204776207943966293915e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.127976500988006591796875e1), SC_(0.349983751773834228515625e0), SC_(0.17631141790422961822411101374980407330945194154271e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.131162846088409423828125e1), SC_(0.90736472606658935546875e0), SC_(0.24685991521322679592835286954438482312764117623578e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.142281472682952880859375e1), SC_(0.196595251560211181640625e0), SC_(0.20309668813290373338560634748500047283537802013056e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.14347274303436279296875e1), SC_(0.848467767238616943359375e0), SC_(0.27689406702583450585113794060991706194777122327044e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.150404822826385498046875e1), SC_(0.251083850860595703125e0), SC_(0.2227331793067602279515444807538003960194407743336e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.15156433582305908203125e1), SC_(0.955017566680908203125e0), SC_(0.39841502366038685758009437093503073409703050289282e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.15200517177581787109375e1), SC_(0.616044700145721435546875e0), SC_(0.25398945504855765112206170478211853748621866326079e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.1521893978118896484375e1), SC_(0.778897702693939208984375e0), SC_(0.28708224866732851174538356618123006393499065869153e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.155961430072784423828125e1), SC_(0.473288834095001220703125e0), SC_(0.24867907032316093745687384858281855283550442766088e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.156523787975311279296875e1), SC_(0.987459599971771240234375e0), SC_(0.55880532293684972175096743550522689481009401335481e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.15321610867977142333984375e0), SC_(0.3516595065593719482421875e0), SC_(0.15394861027987851790269470747728106269690935269237e0) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.1994704306125640869140625e0), SC_(0.6759537756443023681640625e-1), SC_(0.20093157039642945851543617878154228686960679374495e0) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.2128067910671234130859375e0), SC_(0.830828607082366943359375e0), SC_(0.21570587318320040209124323131575989765027779856438e0) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.295909702777862548828125e0), SC_(0.79359757900238037109375e0), SC_(0.30350802740747761165151485445091375548128161543869e0) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.3471994698047637939453125e0), SC_(0.58526408672332763671875e0), SC_(0.35742192071722254902413558768566837125434097666391e0) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.4374639987945556640625e0), SC_(0.594503581523895263671875e0), SC_(0.45830806922418915745292117712593945684636620822424e0) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.4840676784515380859375e0), SC_(0.54972362518310546875e0), SC_(0.51143347634367867342471257562016343685162976186578e0) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.859039485454559326171875e0), SC_(0.73279869556427001953125e0), SC_(0.10577042332472346798816418293514163759853976562141e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.859572112560272216796875e0), SC_(0.9171936511993408203125e0), SC_(0.11155239315987519432370181784079532188750709866122e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.993307650089263916015625e0), SC_(0.695232868194580078125e0), SC_(0.12977243502236374337725785194246729813171091308621e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.127976500988006591796875e1), SC_(0.285839021205902099609375e0), SC_(0.17456484465742635510491489805029645776724197810908e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.131162846088409423828125e1), SC_(0.679819762706756591796875e0), SC_(0.20395618535968433986342758103170943928811359281533e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.142281472682952880859375e1), SC_(0.7572002410888671875e0), SC_(0.24839162402307899431852893659934423982272592946283e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.14347274303436279296875e1), SC_(0.3923204839229583740234375e0), SC_(0.21288092547044085132951719509766559675057581911452e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.150404822826385498046875e1), SC_(0.7537291049957275390625e0), SC_(0.27439874042495155666431832587302615179331837996014e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.15156433582305908203125e1), SC_(0.561557471752166748046875e0), SC_(0.24615640805355064111625476270972091825378518899619e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.15200517177581787109375e1), SC_(0.38044583797454833984375e0), SC_(0.23241267316766070614681045515295373421784862934509e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.1521893978118896484375e1), SC_(0.20806805789470672607421875e0), SC_(0.22551080259640874274686631474827923351847427045064e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.155961430072784423828125e1), SC_(0.56782162189483642578125e0), SC_(0.25863529809290751691249488671768068424620240885224e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.156523787975311279296875e1), SC_(0.527371466159820556640625e0), SC_(0.2554629161518851188714800488545195748365555606992e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.15321610867977142333984375e0), SC_(0.75854294002056121826171875e-1), SC_(0.15398092120954751027321508980312697284256070785844e0) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.1994704306125640869140625e0), SC_(0.4042085111141204833984375e0), SC_(0.20137362997676579799176872137982828890827039500779e0) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.2128067910671234130859375e0), SC_(0.539501197636127471923828125e-1), SC_(0.2148594661573741380378818908772550006184401355113e0) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.295909702777862548828125e0), SC_(0.352762401103973388671875e0), SC_(0.30200600483140969518899676847986391907832733198417e0) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.3471994698047637939453125e0), SC_(0.530797541141510009765625e0), SC_(0.35825232301582295088937112205796335247816877004938e0) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.4374639987945556640625e0), SC_(0.59282386302947998046875e0), SC_(0.46094914705726719065176684471987501601200188434625e0) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.4840676784515380859375e0), SC_(0.779167234897613525390625e0), SC_(0.52174982956066074439247911824370445814787929403429e0) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.859039485454559326171875e0), SC_(0.3563451468944549560546875e0), SC_(0.10262543672450826829260724771835297960230291295702e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.859572112560272216796875e0), SC_(0.934010684490203857421875e0), SC_(0.11547625238873614738644258264457290529891583193801e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.993307650089263916015625e0), SC_(0.964966356754302978515625e0), SC_(0.15234413567879387020642788633248001491416209408078e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.127976500988006591796875e1), SC_(0.1299062073230743408203125e0), SC_(0.18413491768831881075312787552138802618527381876723e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.131162846088409423828125e1), SC_(0.15443842113018035888671875e0), SC_(0.19222378071201812732675807899949738595403581073747e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.142281472682952880859375e1), SC_(0.568823635578155517578125e0), SC_(0.24365724142849164356444375034499546430239505553693e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.14347274303436279296875e1), SC_(0.3949082195758819580078125e0), SC_(0.23314229565108520603670128868078607414012938471566e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.150404822826385498046875e1), SC_(0.4693906307220458984375e0), SC_(0.25916897134612854229552277854239085364596238474712e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.15156433582305908203125e1), SC_(0.387295901775360107421875e0), SC_(0.25615820809238499526599318049112869297280332401821e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.15200517177581787109375e1), SC_(0.1190206967294216156005859375e-1), SC_(0.24529258671729803411462179505475180495199613985106e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.1521893978118896484375e1), SC_(0.7269546985626220703125e0), SC_(0.30522768807297073528830958653582311888514530629749e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.155961430072784423828125e1), SC_(0.3371226489543914794921875e0), SC_(0.26568993493402351861178312883401261620461637682988e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.156523787975311279296875e1), SC_(0.3885698020458221435546875e0), SC_(0.27085657207478667326908185684482658038481557744533e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.15321610867977142333984375e0), SC_(0.1621823012828826904296875e0), SC_(0.15421544224519914647291040764576977885848570497352e0) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.1994704306125640869140625e0), SC_(0.9274928569793701171875e0), SC_(0.20281990141672933241592473860441227009665877630456e0) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.2128067910671234130859375e0), SC_(0.794284522533416748046875e0), SC_(0.21649872459140500962390619725457369928514509967875e0) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.295909702777862548828125e0), SC_(0.4361175596714019775390625e0), SC_(0.30397706429573268293288300856057951281709299084787e0) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.3471994698047637939453125e0), SC_(0.31121504306793212890625e0), SC_(0.35967712746026221135867420211146755398231759545097e0) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.4374639987945556640625e0), SC_(0.86267817020416259765625e0), SC_(0.47324388859539641114477253820149458045388655379996e0) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.4840676784515380859375e0), SC_(0.528533160686492919921875e0), SC_(0.52290645966044236278240775991610829019053680855343e0) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.859039485454559326171875e0), SC_(0.62036001682281494140625e0), SC_(0.11330056495992178266959300159233313895725637509264e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.859572112560272216796875e0), SC_(0.1656487286090850830078125e0), SC_(0.10799870751230090525159652586345386778803883297933e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.993307650089263916015625e0), SC_(0.119547180831432342529296875e0), SC_(0.13594746169525790221222252791669481748489966831704e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.127976500988006591796875e1), SC_(0.601981937885284423828125e0), SC_(0.25029079546248654600284239262212144798031946300692e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.131162846088409423828125e1), SC_(0.471956789493560791015625e0), SC_(0.25313839456705618070572598272578480282827783285862e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.142281472682952880859375e1), SC_(0.26297128200531005859375e0), SC_(0.29390140522227067881692822236045018165494514735754e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.14347274303436279296875e1), SC_(0.3402197062969207763671875e0), SC_(0.30483218097902679731101280792650785140765948430902e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.150404822826385498046875e1), SC_(0.65407907962799072265625e0), SC_(0.39437980136742475702199210287732838111218905421546e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.15156433582305908203125e1), SC_(0.529841959476470947265625e0), SC_(0.37394248092977825165545518375842222109446969765199e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.15200517177581787109375e1), SC_(0.689214527606964111328125e0), SC_(0.4168571485915139152854457402894778942914186994962e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.1521893978118896484375e1), SC_(0.7161006927490234375e0), SC_(0.42818097827852255129418358029436883892256225300985e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.155961430072784423828125e1), SC_(0.748151600360870361328125e0), SC_(0.47246208849629886552050967056823184649385220954246e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.156523787975311279296875e1), SC_(0.988379418849945068359375e0), SC_(0.10627631649024785924819390085951672540955014724732e2) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.15321610867977142333984375e0), SC_(0.4505415856838226318359375e0), SC_(0.1543471504345624424109375684172675717946165311776e0) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.1994704306125640869140625e0), SC_(0.72049343585968017578125e0), SC_(0.20240768262814177579386325803677866788584066829019e0) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.2128067910671234130859375e0), SC_(0.83821378648281097412109375e-1), SC_(0.21553765540268994498307217721263063665507699685948e0) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.295909702777862548828125e0), SC_(0.91257750988006591796875e0), SC_(0.30713411949524097334864751538453432899082333661098e0) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.3471994698047637939453125e0), SC_(0.2289769649505615234375e0), SC_(0.35966592222946696834558061228751634321678291896457e0) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.4374639987945556640625e0), SC_(0.50549852848052978515625e0), SC_(0.46604314861839282811575794774201959832277773764614e0) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.4840676784515380859375e0), SC_(0.91333734989166259765625e0), SC_(0.53657208745343046140672467966345188537341555208544e0) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.859039485454559326171875e0), SC_(0.5582687854766845703125e0), SC_(0.11296229001178209304704909676204483091200543834654e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.859572112560272216796875e0), SC_(0.152378022670745849609375e0), SC_(0.10876415477927578200486376096943838141845740716713e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.993307650089263916015625e0), SC_(0.50319004058837890625e0), SC_(0.14358965883735935905419862051172824592728587725814e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.127976500988006591796875e1), SC_(0.82581698894500732421875e0), SC_(0.30009544156151973102913624524063756620151459309383e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.131162846088409423828125e1), SC_(0.4624741971492767333984375e0), SC_(0.26081148621086425356924764795547014604072097723466e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.142281472682952880859375e1), SC_(0.538342416286468505859375e0), SC_(0.33347088553490709903999593163585110664196386181649e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.14347274303436279296875e1), SC_(0.546591937541961669921875e0), SC_(0.34253854001310708224056686833635863338817740830414e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.150404822826385498046875e1), SC_(0.996134698390960693359375e0), SC_(0.10570130611831314444016501000969951914299134551828e2) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.15156433582305908203125e1), SC_(0.4475843906402587890625e0), SC_(0.38124794859273825441069683694442615588309980456637e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.15200517177581787109375e1), SC_(0.7817552983760833740234375e-1), SC_(0.35683967981908619275495637085001629411640461384741e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.1521893978118896484375e1), SC_(0.854451000690460205078125e0), SC_(0.54441031646948756423096963485056383495288465537153e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.155961430072784423828125e1), SC_(0.442678272724151611328125e0), SC_(0.41008144401977018287198169560791113378794188376539e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.156523787975311279296875e1), SC_(0.60423147678375244140625e0), SC_(0.44902845167476946580473712439439527882954432526114e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.15321610867977142333984375e0), SC_(0.106652773916721343994140625e0), SC_(0.15431778412390276277759782789476393007797031164116e0) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.1994704306125640869140625e0), SC_(0.4985441863536834716796875e0), SC_(0.20223472108953525129458054711444453260790566685329e0) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.2128067910671234130859375e0), SC_(0.9618980884552001953125e0), SC_(0.21730110751061073351172410418940772710015669363783e0) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.295909702777862548828125e0), SC_(0.979925632476806640625e0), SC_(0.3084178501706348073664487064448083712718646501623e0) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.3471994698047637939453125e0), SC_(0.463422574102878570556640625e-2), SC_(0.36038118493419671483975692269590337503857139776645e0) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.4374639987945556640625e0), SC_(0.34317314624786376953125e-1), SC_(0.46453047117703614141431491209083328921397976267143e0) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.4840676784515380859375e0), SC_(0.774910449981689453125e0), SC_(0.53445337251807937943341267247025011827714976413687e0) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.859039485454559326171875e0), SC_(0.97700202465057373046875e0), SC_(0.13073593675547265731392611682266271034008381336704e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.859572112560272216796875e0), SC_(0.817303240299224853515625e0), SC_(0.12336363654190000070799786896326903015961440380611e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.993307650089263916015625e0), SC_(0.3631864488124847412109375e0), SC_(0.14680584179397563044440300090163768039256833250483e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.127976500988006591796875e1), SC_(0.868694722652435302734375e0), SC_(0.36195182216979546329535507825802014326665932215075e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.131162846088409423828125e1), SC_(0.679519712924957275390625e0), SC_(0.33180763503853330565879465111347181515075951838091e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.142281472682952880859375e1), SC_(0.844358503818511962890625e-1), SC_(0.36534512094703041360100869161806161319790771488492e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.14347274303436279296875e1), SC_(0.3462333977222442626953125e0), SC_(0.39163710827778602815532035038817324104097313639414e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.150404822826385498046875e1), SC_(0.399782657623291015625e0), SC_(0.47062733336349311179199616568378630864013468807379e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.15156433582305908203125e1), SC_(0.85587513446807861328125e0), SC_(0.71682639328546134519511374804756058127979789269403e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.15200517177581787109375e1), SC_(0.25987040996551513671875e0), SC_(0.47029104727608450068777767843245946384702754006103e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.1521893978118896484375e1), SC_(0.450595431029796600341796875e-1), SC_(0.46060031279437956120359972587500133523360294174506e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.155961430072784423828125e1), SC_(0.80006849765777587890625e0), SC_(0.72700660235850347593340492456248967795090945146508e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.156523787975311279296875e1), SC_(0.660119473934173583984375e0), SC_(0.62668628529934141301633691980218815706575920761165e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.15321610867977142333984375e0), SC_(0.431413829326629638671875e0), SC_(0.15443290505311020333906151706417274386985828283102e0) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.1994704306125640869140625e0), SC_(0.74994099140167236328125e0), SC_(0.20268273748172570844017355906890170538408812180291e0) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.2128067910671234130859375e0), SC_(0.910647571086883544921875e0), SC_(0.2171644354883534523862993429784570956100173387294e0) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.295909702777862548828125e0), SC_(0.13299603760242462158203125e0), SC_(0.30412483443831110153287192256766962962132883624802e0) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.3471994698047637939453125e0), SC_(0.18184702098369598388671875e0), SC_(0.36074030690148914565708013284359470991242254317927e0) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.4374639987945556640625e0), SC_(0.982360541820526123046875e0), SC_(0.48048629106037844526396100101670448320331828451626e0) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.4840676784515380859375e0), SC_(0.2638029158115386962890625e0), SC_(0.5230961824634638806349914938609306071392737346471e0) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.859039485454559326171875e0), SC_(0.95355175435543060302734375e-1), SC_(0.11185041878549939751098381930154546784656137010255e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.859572112560272216796875e0), SC_(0.145538985729217529296875e0), SC_(0.11213536603792059774918319247221406474855248988517e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.993307650089263916015625e0), SC_(0.282673299312591552734375e0), SC_(0.1461722381151363043123137222502210037687124044186e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.127976500988006591796875e1), SC_(0.1360685527324676513671875e0), SC_(0.26525882801860511037844408826245496016245268036215e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.131162846088409423828125e1), SC_(0.802111446857452392578125e0), SC_(0.37416125150641848054422354073252550844982695384563e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.142281472682952880859375e1), SC_(0.869292199611663818359375e0), SC_(0.57788660737214781633058238439722973539236454033723e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.14347274303436279296875e1), SC_(0.77557027339935302734375e-1), SC_(0.38656540745788403336980969144129335357085104505533e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.150404822826385498046875e1), SC_(0.579704582691192626953125e0), SC_(0.5308931263965051225905007403546656963535804193718e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.15156433582305908203125e1), SC_(0.627384364604949951171875e0), SC_(0.56471912265854451136580037609045870976368644105271e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.15200517177581787109375e1), SC_(0.549860179424285888671875e0), SC_(0.54293646342251173327831417909795900892556227316998e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.1521893978118896484375e1), SC_(0.80939121544361114501953125e-2), SC_(0.47772934568305271919245882141704353562392730986097e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.155961430072784423828125e1), SC_(0.14495480060577392578125e0), SC_(0.52505674569203204356112454815791129424788077064078e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.156523787975311279296875e1), SC_(0.680287063121795654296875e0), SC_(0.66666552931803800594035671336221702055705322158683e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.15321610867977142333984375e0), SC_(0.853031098842620849609375e0), SC_(0.15481774707560496930363054522440908507917413009748e0) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.1994704306125640869140625e0), SC_(0.533933103084564208984375e0), SC_(0.20242662055466222679121771918699529789871242510745e0) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.2128067910671234130859375e0), SC_(0.622055113315582275390625e0), SC_(0.21657303272186598526038842892565787030644597135577e0) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.295909702777862548828125e0), SC_(0.438666820526123046875e0), SC_(0.305325449160118086406466057134119599385952338642e0) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.3471994698047637939453125e0), SC_(0.3509523868560791015625e0), SC_(0.36209484469042096248341537701264301717612689738285e0) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.4374639987945556640625e0), SC_(0.19955120980739593505859375e0), SC_(0.46684567081558110757689784751620916168246019568281e0) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.4840676784515380859375e0), SC_(0.51324951648712158203125e0), SC_(0.52935680730599232733985699412171877186079491901809e0) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.859039485454559326171875e0), SC_(0.13800132274627685546875e0), SC_(0.11407487548467852359981403322089829376175201572234e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.859572112560272216796875e0), SC_(0.4018080234527587890625e0), SC_(0.1163899161424413562126027226572649039973629639954e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.993307650089263916015625e0), SC_(0.3823329508304595947265625e0), SC_(0.15262448255296013666408007770892306704744229353925e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.127976500988006591796875e1), SC_(0.75966693460941314697265625e-1), SC_(0.29290099528685311976523608955369731517542782786117e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.131162846088409423828125e1), SC_(0.762421309947967529296875e0), SC_(0.41053275865860098054744782921646613492465209139515e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.142281472682952880859375e1), SC_(0.23991616070270538330078125e0), SC_(0.46813989048163996563380048828520825839097189715557e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.14347274303436279296875e1), SC_(0.404711104929447174072265625e-1), SC_(0.47788268276127732733457680654331679141798344391712e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.150404822826385498046875e1), SC_(0.123318932950496673583984375e0), SC_(0.61357293060950543264386123385763602959388466283618e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.15156433582305908203125e1), SC_(0.252955973148345947265625e0), SC_(0.65194812902628771299651783588365566014443617619048e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.15200517177581787109375e1), SC_(0.18390779197216033935546875e0), SC_(0.65372936297719301770177202712323542853298019862264e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.1521893978118896484375e1), SC_(0.5047709941864013671875e0), SC_(0.72914805028595182618960631382952662249808063648781e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.155961430072784423828125e1), SC_(0.23995251953601837158203125e0), SC_(0.75386824268841640857291503768392622713931248458187e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.156523787975311279296875e1), SC_(0.822604954242706298828125e0), SC_(0.11779662037709625925184321613253996376786579444437e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.15321610867977142333984375e0), SC_(0.4172670543193817138671875e0), SC_(0.15448882344790787156296341867339868332457948807052e0) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.1994704306125640869140625e0), SC_(0.981723129749298095703125e0), SC_(0.20337922888420170276988198067749659054470861589626e0) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.2128067910671234130859375e0), SC_(0.49654424190521240234375e-1), SC_(0.21596458061912549782608623520382652671726856226904e0) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.295909702777862548828125e0), SC_(0.823455393314361572265625e0), SC_(0.30764056045125212509981423182632573255939610348868e0) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.3471994698047637939453125e0), SC_(0.902716100215911865234375e0), SC_(0.36753519265948343352389735238830844233032763658407e0) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.4374639987945556640625e0), SC_(0.30182731151580810546875e0), SC_(0.46787533494744948797082361076311838959825562533425e0) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.4840676784515380859375e0), SC_(0.944787204265594482421875e0), SC_(0.5445223245928084775267765729197998028660600584015e0) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.859039485454559326171875e0), SC_(0.47944284975528717041015625e-1), SC_(0.11419027027282526641589478874771346651066443929172e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.859572112560272216796875e0), SC_(0.490864098072052001953125e0), SC_(0.11808672878095468146367317247402229236578230060389e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.993307650089263916015625e0), SC_(0.24784760177135467529296875e0), SC_(0.1510724625040434411255264498029019527172851997852e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.127976500988006591796875e1), SC_(0.489252626895904541015625e0), SC_(0.32280438417295395871118450367533561750559999591205e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.131162846088409423828125e1), SC_(0.544056117534637451171875e0), SC_(0.36504488865335236099239461305551504634226544981061e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.142281472682952880859375e1), SC_(0.3377194106578826904296875e0), SC_(0.50116795201376154085275472036734434589857008050158e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.14347274303436279296875e1), SC_(0.887726128101348876953125e0), SC_(0.84737046797468561823325202938718437497405596511517e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.150404822826385498046875e1), SC_(0.90005385875701904296875e0), SC_(0.1220953724302114044945527274939858629960732655187e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.15156433582305908203125e1), SC_(0.34383952617645263671875e0), SC_(0.72095527210305660305435684328627246055341040572769e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.15200517177581787109375e1), SC_(0.369246780872344970703125e0), SC_(0.73951653011181049471553914144499669460128656610602e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.1521893978118896484375e1), SC_(0.332685671746730804443359375e-1), SC_(0.70226485349191424980633816661935532981874296964893e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.155961430072784423828125e1), SC_(0.111202754080295562744140625e0), SC_(0.81068545032839266532237826137590524593444458725166e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.156523787975311279296875e1), SC_(0.16287212073802947998046875e0), SC_(0.83179075701627955962804491044936954892179920378095e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.15321610867977142333984375e0), SC_(0.780252039432525634765625e0), SC_(0.15475737949909478047070462517579700762311896812467e0) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.1994704306125640869140625e0), SC_(0.8773639202117919921875e0), SC_(0.20311816608308845738741679638823944097342405030992e0) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.2128067910671234130859375e0), SC_(0.3897388279438018798828125e0), SC_(0.21621899453934087771630140894213617277836386575984e0) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.295909702777862548828125e0), SC_(0.210301876068115234375e0), SC_(0.30475355080306542334755083460182527328263134950226e0) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.3471994698047637939453125e0), SC_(0.241691291332244873046875e0), SC_(0.36177750353192331687490589127139362126212997719881e0) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.4374639987945556640625e0), SC_(0.2727530300617218017578125e0), SC_(0.46771577025858626653425311574087731731956124765164e0) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.4840676784515380859375e0), SC_(0.4039121568202972412109375e0), SC_(0.52767826728868531754847133793738779282091365583467e0) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.859039485454559326171875e0), SC_(0.4924419820308685302734375e0), SC_(0.11813053210788657581802109097418532290258576315896e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.859572112560272216796875e0), SC_(0.964545309543609619140625e-1), SC_(0.11455168350090201971996502157180470721371292865453e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.993307650089263916015625e0), SC_(0.22341994941234588623046875e0), SC_(0.15107327851553261381802481252276623959863389023143e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.127976500988006591796875e1), SC_(0.1319732964038848876953125e0), SC_(0.30226301010207643007928191799916828281937612556814e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.131162846088409423828125e1), SC_(0.49030148983001708984375e0), SC_(0.36046119497745151784175948042189361277202154524485e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.142281472682952880859375e1), SC_(0.94205057621002197265625e0), SC_(0.97203663176735132514825064074609997743512356998894e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.14347274303436279296875e1), SC_(0.954943358898162841796875e0), SC_(0.11011978177735173557154678889804622221909342333903e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.150404822826385498046875e1), SC_(0.9561345577239990234375e0), SC_(0.16402053042712315197657916684556169457872592674081e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.15156433582305908203125e1), SC_(0.651968657970428466796875e0), SC_(0.88345194368628355267695132101617160342034756495267e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.15200517177581787109375e1), SC_(0.575208604335784912109375e0), SC_(0.84748225307301094222380991355005567566274686726537e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.1521893978118896484375e1), SC_(0.75750362873077392578125e0), SC_(0.10197430359981236616697924921398899211464970560759e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.155961430072784423828125e1), SC_(0.597795434296131134033203125e-1), SC_(0.84064025327619517361822639394442268158035554852917e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.156523787975311279296875e1), SC_(0.435245692729949951171875e0), SC_(0.9358518445225700860544455145015555791226110767821e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.15321610867977142333984375e0), SC_(0.23477990925312042236328125e0), SC_(0.15442156112978093297454160863238247516165272128913e0) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.1994704306125640869140625e0), SC_(0.552881181240081787109375e0), SC_(0.20248591151512684889777908313507098733907404479779e0) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.2128067910671234130859375e0), SC_(0.3531585633754730224609375e0), SC_(0.21617827331752659885227560975063192503354205955227e0) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.295909702777862548828125e0), SC_(0.53152568638324737548828125e-1), SC_(0.30457929773810368279656335904075896840505542281782e0) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.3471994698047637939453125e0), SC_(0.82119405269622802734375e0), SC_(0.36648381459009855010282636497000495844067411495728e0) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.4374639987945556640625e0), SC_(0.3225107491016387939453125e0), SC_(0.46820813134691862413002859030329680920443396476487e0) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.4840676784515380859375e0), SC_(0.15403441153466701507568359375e-1), SC_(0.52429622697384041199554387963318726564829097537693e0) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.859039485454559326171875e0), SC_(0.4049813747406005859375e0), SC_(0.11688412506184163287721570308014524903017013494232e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.859572112560272216796875e0), SC_(0.430237986147403717041015625e-1), SC_(0.11449988182409327994485455270827429695338275912174e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.993307650089263916015625e0), SC_(0.908433616161346435546875e0), SC_(0.18266789783360020292814582325699256373584172249477e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.127976500988006591796875e1), SC_(0.16899003088474273681640625e0), SC_(0.30430369250697162478388242126743830858353764266449e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.131162846088409423828125e1), SC_(0.80913722515106201171875e0), SC_(0.44920137262555851592309929494558415631051796363299e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.142281472682952880859375e1), SC_(0.649115502834320068359375e0), SC_(0.59891751296524440844289458168416602134024673548837e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.14347274303436279296875e1), SC_(0.25829589366912841796875e0), SC_(0.52965937189811672314081569081059077796519658968977e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.150404822826385498046875e1), SC_(0.731722414493560791015625e0), SC_(0.92583262981154382185351350782094876668592638916589e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.15156433582305908203125e1), SC_(0.12984652817249298095703125e0), SC_(0.7233773376721171229435259512236443934650475081173e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.15200517177581787109375e1), SC_(0.64774596691131591796875e0), SC_(0.91053372374313401582308361573901478352610855700337e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.1521893978118896484375e1), SC_(0.493326842784881591796875e0), SC_(0.82536400334140914822765036957266265919633704648661e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.155961430072784423828125e1), SC_(0.4509237110614776611328125e0), SC_(0.93995103249245477244455231773136703775786210343295e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.156523787975311279296875e1), SC_(0.3785004317760467529296875e0), SC_(0.93125715606508175287280208010343215728209966217622e1) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.15321610867977142333984375e0), SC_(0.54700887203216552734375e0), SC_(0.154599286903186347536842701718471127585280120763e0) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.1994704306125640869140625e0), SC_(0.71846997737884521484375e0), SC_(0.20283934930431330261325692288358107410442895192458e0) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.2128067910671234130859375e0), SC_(0.29632079601287841796875e0), SC_(0.21619844220527214635649026415392786440017796933018e0) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.295909702777862548828125e0), SC_(0.2878049910068511962890625e0), SC_(0.3051647326285145064763788149974065042939649411249e0) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.3471994698047637939453125e0), SC_(0.74469280242919921875e0), SC_(0.36593269361963920740660627814234613035125736530233e0) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.4374639987945556640625e0), SC_(0.623435556888580322265625e0), SC_(0.47351038005245946606485569936799511854047412964646e0) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.4840676784515380859375e0), SC_(0.188955008983612060546875e0), SC_(0.52619421119616314908557198345534215266757025628341e0) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.859039485454559326171875e0), SC_(0.811873972415924072265625e0), SC_(0.12796147420322316976041013515903300942049403300717e1) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.859572112560272216796875e0), SC_(0.6867754459381103515625e0), SC_(0.12394269966981472546595377372621649553539498692944e1) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.993307650089263916015625e0), SC_(0.31250798702239990234375e0), SC_(0.15534506456507100564291157167033185308229885626081e1) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.127976500988006591796875e1), SC_(0.18351115286350250244140625e0), SC_(0.32883134974911278663257207579294642984195789886813e1) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.131162846088409423828125e1), SC_(0.3857105076313018798828125e0), SC_(0.3843930070475687905185740186007796682476313279295e1) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.142281472682952880859375e1), SC_(0.3684845864772796630859375e0), SC_(0.64560281183013155713676475264767841267885661014251e1) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.14347274303436279296875e1), SC_(0.3439297378063201904296875e0), SC_(0.68762448789590812867204741141193446919124297531292e1) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.150404822826385498046875e1), SC_(0.62561857700347900390625e0), SC_(0.13204500086777579559121699778257730234656273348984e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.15156433582305908203125e1), SC_(0.81576907634735107421875e0), SC_(0.18782686397271619660785945631793130083787364064634e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.15200517177581787109375e1), SC_(0.7802274227142333984375e0), SC_(0.18302545936290427541117117730722002834553061125842e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.1521893978118896484375e1), SC_(0.669285118579864501953125e0), SC_(0.16059155876792932443850017386340255003749606531065e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.155961430072784423828125e1), SC_(0.811257660388946533203125e-1), SC_(0.17107262415330151383028878013437636789944479173721e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.156523787975311279296875e1), SC_(0.379418849945068359375e0), SC_(0.19155786972659388496036522827203540528048007161044e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.15321610867977142333984375e0), SC_(0.929385960102081298828125e0), SC_(0.15494953789788259980228066836666586023123819724425e0) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.1994704306125640869140625e0), SC_(0.4584968984127044677734375e0), SC_(0.20243262749758402603750294407634188860785303898664e0) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.2128067910671234130859375e0), SC_(0.775712668895721435546875e0), SC_(0.21706303863374380621352712917030134681912729698606e0) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.295909702777862548828125e0), SC_(0.303613960742950439453125e0), SC_(0.30524071829572125811103009319660245769811854653147e0) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.3471994698047637939453125e0), SC_(0.4867916405200958251953125e0), SC_(0.36356073608058866564834344897710010972287253451556e0) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.4374639987945556640625e0), SC_(0.910564959049224853515625e0), SC_(0.48104301408957402493870044558559339292659904746407e0) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.4840676784515380859375e0), SC_(0.4358585774898529052734375e0), SC_(0.5296599894432982217860267176354900496432490384687e0) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.859039485454559326171875e0), SC_(0.488617718219757080078125e0), SC_(0.11959816962457412713215082894885440106679306405223e1) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.859572112560272216796875e0), SC_(0.4467837512493133544921875e0), SC_(0.11905815264303277217419460505969483267592093504852e1) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.993307650089263916015625e0), SC_(0.75578987598419189453125e0), SC_(0.17303829899385816376582825125863049753469531971278e1) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.127976500988006591796875e1), SC_(0.3063494861125946044921875e0), SC_(0.33959201984939021366299708945798000348464210899788e1) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.131162846088409423828125e1), SC_(0.108061917126178741455078125e0), SC_(0.37244311575010030859404652598599661337479280352413e1) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.142281472682952880859375e1), SC_(0.5085086822509765625e0), SC_(0.71622395151588347106386969682257760699123684023386e1) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.14347274303436279296875e1), SC_(0.39358985424041748046875e0), SC_(0.73636293852590201326616972102360781065664379097234e1) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.150404822826385498046875e1), SC_(0.510771572589874267578125e0), SC_(0.13953417098210141831895151114277855224069335314941e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.15156433582305908203125e1), SC_(0.870186746120452880859375e0), SC_(0.2556857706461314333232853600430574327145004073045e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.15200517177581787109375e1), SC_(0.817627727985382080078125e0), SC_(0.23625019083977016071256452688852096136119845707138e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.1521893978118896484375e1), SC_(0.36086070537567138671875e0), SC_(0.15792458525021165627427857010031529171479777626611e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.155961430072784423828125e1), SC_(0.79483139514923095703125e0), SC_(0.36995201253231850772712106938485439098332159356711e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.156523787975311279296875e1), SC_(0.917117893695831298828125e0), SC_(0.57989207945838172546694589268843963845498536168854e2) }}
   }};

