#!/bin/bash
#
###############################################################
#
# Restore the system to a usable and bootable installation
#
# Urs Beyerle, PSI
#
###############################################################

### check if I run inside my directory
if [ ! -x $( basename $0 ) ]; then
    echo "Please run $( basename $0 ) within its directory"
    exit 1
fi

LIVECD_DIR=$( pwd )

cp /etc/rc.d/rc.sysinit.ori /etc/rc.d/rc.sysinit

chkconfig sshd on

mkdir -p /livecd/live
rm -f /livecd/live/liblinuxlive
ln -s $LIVECD_DIR/linux-live.sl4/initrd/liblinuxlive /livecd/live/liblinuxlive

cat > /etc/resolv.conf <<EOF
search psi.ch
nameserver 129.129.190.11
nameserver 129.129.230.11
EOF

/etc/init.d/afs start

# move /etc/yum.repos.d, it will interfere with our yum.conf.psi
if [ -d /etc/yum.repos.d ]; then
    rm -rf /etc/yum.repos.d.ori
    mv -f /etc/yum.repos.d /etc/yum.repos.d.ori
fi

# restore folders from /mini
if [ -f /mini/usr/share/info/bash.info.gz ]; then
    ./mini_livecd.sh -restore
fi

# restore cronjobs
mv /etc/cron_backup/sysstat /etc/cron.d/ 2>/dev/null
mv /etc/cron_backup/00-makewhatis.cron.weekly /etc/cron.weekly/00-makewhatis.cron 2>/dev/null
mv /etc/cron_backup/* /etc/cron.daily/

# special PAM for PSI
if [ -e /etc/security/users ]; then
    echo "root" > /etc/security/users
fi

# set root password
passwd
